/*
FILE: SnareCore.h
*/

#include "NTService.h"
#include "support.h"
#include <ntsecapi.h>

#define MAX_EVENT 8192
#define MAX_STRING 1024
#define MAX_OUTPUT_STRING 8192
#define MAX_USERNAME	512

#define LOG_TYPE_SECURITY 0
#define LOG_TYPE_SYSTEM 1
#define LOG_TYPE_APPLICATION 2
#define LOG_TYPE_DS 3
#define LOG_TYPE_DNS 4
#define LOG_TYPE_FRS 5
#define MAX_LOG_TYPE 5

struct _node
{
	int event_number;				// The event number this is supposed to match
	int criticality;				// How critical is this particular node
	int excludeflag;				// Include or exclude users?
	int eventlogtype;				// binary Warning / Information / Success / Failure / Error
	int sourcename;					// binary Security / Application / Active Directory etc
	char username[SIZE_OF_USERMATCH];	// Remember, this will be a wildcard match.
	BOOL muserflag;					// Are there multiple users?
	char match[SIZE_OF_GENERALMATCH];
	struct _node *next;
};

typedef struct _node Node;


class CSnarecoreService : public CNTService
{
public:
	CSnarecoreService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();

    void SaveStatus();

// 	int SNAREDEBUG;

private:
	HANDLE m_hEventList[9]; // Eight elements at the moment.

	HANDLE hEventLog[6];
	HANDLE hPipe;
	HANDLE hWritePipe;		// Pipe to the Audit GUI
};

// Function Prototypes.
BOOL	InitWinsock				(char *);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

void	syslogdate				(char *, struct tm *);

int		wildmatch				(char *, char *);
void	splitstrings			(char *, int, char *, int);

SOCKET	ConnectToServer			(char *, UINT, char *, int);

BOOL	GetCategoryString		(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length);
BOOL	GetEventLogType			(TCHAR *sz, unsigned short uEventType, DWORD length);
BOOL	SendToSocket			(SOCKET hSocket, char *buf, int nSize, char *szError, int eSize);
BOOL	GetSIDType				(SID_NAME_USE _SidNameUse, TCHAR *szSIDType, DWORD length);
BOOL	ExpandStrings			(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length);
BOOL	GetDataString			(PEVENTLOGRECORD pELR, char *StringBuffer, DWORD length);
void	GetArgs					(const EVENTLOGRECORD *pELR, char **Args);
BOOL	GetEventUserName		(EVENTLOGRECORD *pELR, char * lpszUser, int length, SID_NAME_USE *snu);

BOOL	CheckLogExists			(TCHAR *LogName);
char *	GetParameterMsg			(char *message, char *tmp);
void	GetFQDN					(char *string,int length);

int		ReadObjectives();
static Node *	AddToList		(int eventnumber, char *username, char *match, int criticality,
								 int excludeflag, int muserflag, int eventlogtype, int sourcename);

static Node * FastCheckObjective	(int eventnumber, int etype, int stype);
int	CheckObjective				(Node * Match, int eventnumber, char *username, char *match);
// Node *	CheckObjective			(int eventnumber, char *username, char *match, int etype, int stype);
void	ResetCurrentNode		(void);
void	NextItemInList			(void);
Node *	GetCurrentItem			(void);
int		IsValidItem				(void);
void	DestroyList				(void);
char *  string_split			(char divider,char *string,char *destination,int destlength);


// BOOL	SwitchAudit				(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure, BOOL Switch);
// BOOL	ClearAllAuditCategories	(void);
void	ClearAuditFlags			(void);
int		SetAuditFlag			(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure);
BOOL	ApplyAudit				(void);
BOOL	TurnOnEvent				(DWORD EventID,DWORD SuccessFailure);

int		SetAuditEvent			(LSA_HANDLE PolicyHandle, POLICY_AUDIT_EVENT_TYPE EventType,
									 POLICY_AUDIT_EVENT_OPTIONS EventOption);
int		SetAuditMode			(LSA_HANDLE PolicyHandle, BOOL bEnable);

void	GetHostname				(char * Hostname,int size);
void	GetDestPort				(DWORD * dwDestPort);
void	GetSyslog				(DWORD * dwSyslog);
void	GetSyslogDynamic		(DWORD * dwSyslogDynamic);
void	GetSyslogHeader			(DWORD * dwSyslogHeader);
void	GetWEBSERVER_ACTIVE		(DWORD * WEBSERVER_ACTIVE);
void	GetPortNumber			(DWORD * dwPortNumber);
void	GetChecksum				(BOOL * ActivateChecksum);
void	GetCrit					(DWORD * dwCrit);
void	GetDestination			(char * lpszDestination,int size);
void	GetDelim				(char * DELIM,int size);
void	GetPassword				(char * lpszPassword,int size);
void	GetIPAddress			(char * lpszIPAddress,int size);
void	GetClearTabs			(DWORD * ClearTabs);
FILE *  GetOutputFile			(void);
int		DirExists				(char *);


void	DEBUGDumpEventLog(DWORD EventTriggered,DWORD dwBytesRead,PEVENTLOGRECORD pELR);

typedef struct _tagEVENTID
{
	TCHAR lpszMachineName[_MAX_PATH + 1];
	TCHAR lpszEventName[_MAX_PATH + 1];
	DWORD dwEventId;
	HWND  hwndDlg;
} EVENTID, *LPEVENTID;

// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;









