#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <process.h>
#include "NTService.h"
#include "webserver.h"
#include "WebPages.h"
#include "MD5.h"

// extern int SNAREDEBUG;

#define MAX_HTTPBUFFER 8192

// Socket for our pseudo-httpd server
SOCKET http_listen_socket = INVALID_SOCKET;
SOCKET http_message_socket = INVALID_SOCKET;

extern void DebugMsg(const char* pszFormat, ...);
extern int SNAREDEBUG;

// NOTE: This password sits in RAM.
// A user with appropriate access could pull it out.
// .. they could also grab it from the registry.
// Note: Despite the fact that we set the string, this does NOT represent a default password.
char SnarePass[256]="Broulee";
char SnareIP[17]="";

int InitWebServer(unsigned short port,char *password,char *ip)
{
	struct sockaddr_in local;

	if(password) {
		strncpy(SnarePass,password,sizeof(SnarePass));
	}
	
	if(ip) {
		if(strlen(ip)) {
			strncpy(SnareIP,ip,sizeof(SnareIP));
		} else {
			strcpy(SnareIP,"");
		}
	} else {
		strcpy(SnareIP,"");
	}
		
	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY; 

	local.sin_port = htons(port);

	http_listen_socket = socket(AF_INET, SOCK_STREAM,0); // TCP socket
	
	if (http_listen_socket == INVALID_SOCKET){
		DebugMsg("bind() failed: INVALID_SOCKET");
		return -1;
	}

	if (bind(http_listen_socket,(struct sockaddr*)&local,sizeof(local) ) 
		== SOCKET_ERROR) {
		DebugMsg("bind() failed: SOCKET_ERROR");
		return -1;
	}

	if (listen(http_listen_socket,5) == SOCKET_ERROR) {
		DebugMsg("listen() failed: SOCKET_ERROR");
		return -1;
	}
	
	return(1);
}

int CloseWebServer()
{
	closesocket(http_listen_socket);
	return(1);
}

int HandleConnect(HANDLE event)
{	
	int retval;
	// 8k buffer for input and output. Suggest we may need more for output.
	char HTTPBuffer[MAX_HTTPBUFFER];
	char HTTPOutputBuffer[MAX_HTTPBUFFER];
	char *pos;
	int size=0;
	int header=1;


	

	retval = recv(http_message_socket,HTTPBuffer,sizeof (HTTPBuffer),0 );
	// NOTE: Should probably do something about requests that are bigger than
	// HTTPBuffer also..

	if (retval == SOCKET_ERROR) {
		// printf("recv() failed: error %d\n",WSAGetLastError());
		closesocket(http_message_socket);
		return(1);
	}
	if (retval == 0) {
		closesocket(http_message_socket);
		return(1);
	}

	HTTPBuffer[retval]='\0';

if(SNAREDEBUG) { DebugMsg("Handling connection: [ %s ]\n",HTTPBuffer); }

	// Hunt down the authentication string
	// Dont ask for authentication if the password is blank.

	pos=strstr(HTTPBuffer,"Authorization: Basic ");
	if(strlen(SnarePass) && !pos) {
		RequestAuth(HTTPOutputBuffer,MAX_HTTPBUFFER);
		header=0;
	} else if(strlen(SnarePass) && !MatchAuth(pos + strlen("Authorization: Basic "))) {
		RequestAuth(HTTPOutputBuffer,MAX_HTTPBUFFER);
		header=0;
	} else {
		// Don't care about anything after the GET
		pos=strstr(HTTPBuffer,"\n");
		if(pos) {
			*pos='\0';
		}
		pos=strstr(HTTPBuffer,"\r");
		if(pos) {
			*pos='\0';
		}

		// Get rid of the "GET "
		pos=strstr(HTTPBuffer," ");
		if(pos) {
			strncpy(HTTPBuffer,pos+1,MAX_HTTPBUFFER);
		}
			
		// and the HTTP/1.x
		pos=strstr(HTTPBuffer," ");
		if(pos) {
			*pos='\0';
		}

		decodeurl(HTTPBuffer);
		// printf("DEBUG: DATA IN is now [%s]\n",HTTPBuffer);

		size=HandleWebPages(HTTPBuffer,HTTPOutputBuffer,MAX_HTTPBUFFER,http_message_socket,event);
	}

	if(size == -1) {
		size = 0;
	} else if(size == 0 && HTTPOutputBuffer) {
		size=(int)strlen(HTTPOutputBuffer);
	}

	if(size) {
		if(SNAREDEBUG) { DebugMsg("Data back from handlewebpages.."); }
		// Overwrite HTTPBuffer with the header data.
		strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n" \
							"Server: SNARE/1.0\r\n" \
							"MIME-version: 1.0\r\n" \
							"Content-type: text/html\r\n\r\n",
				sizeof(HTTPBuffer));
		
		if(header) {
			retval = send(http_message_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
			if (retval == SOCKET_ERROR) {
				DebugMsg("send() failed: SOCKET_ERROR");
			}
		}

		retval = send(http_message_socket,HTTPOutputBuffer,size,0);

		if (retval == SOCKET_ERROR) {
			DebugMsg("send() failed: SOCKET_ERROR");
		}
	}
	
	if(SNAREDEBUG) { DebugMsg("Handling connection finished\n"); }

	// printf("DEBUG: Terminating connection\n");
	closesocket(http_message_socket);
	
	return(1);
}

int StartThread(HANDLE event)
{
	int threadid=0;
	
	threadid=_beginthread( ListenThread, 0, (HANDLE) event );
	if(SNAREDEBUG) { DebugMsg("DEBUG: Starting thread %d.. event is %d\n",threadid,event); }
	if(threadid==-1)
	{
		DebugMsg("Error in HTTPD thread creation");
		return(-1);
	}
	return(1);
}

void ListenThread(HANDLE event)
{
	struct sockaddr_in from;
	int fromlen;
	BOOL invalidrequest=1;
	char ip_address[16];

	if(SNAREDEBUG) { DebugMsg("Starting ListenThread"); }

	fromlen=sizeof(from);

	while(invalidrequest) {
		if(SNAREDEBUG) { DebugMsg("ListenThread - looping"); }
		http_message_socket = accept(http_listen_socket,(struct sockaddr*)&from, &fromlen);
		if (http_message_socket == INVALID_SOCKET) {
			DebugMsg("Accept() Error - socket is invalid");
			return;
		}

		strncpy(ip_address,inet_ntoa(from.sin_addr),sizeof(ip_address));

		if(AuthorisedSource(ip_address)) {
			invalidrequest=0;
		} else {
			invalidrequest=1;
			send(http_message_socket,"<HTML><BODY><CENTER>Authentication failed</CENTER></BODY></HTML>\r\n\0",66,0);
			closesocket(http_message_socket);
		}
	}

	if(SNAREDEBUG) { DebugMsg("ListenThread finished - telling main thread about the new connection "); }
	// Notify the main thread
	SetEvent(event);

	if(SNAREDEBUG) { DebugMsg("ListenThread terminating (explicitly)."); }
	// Terminate this thread.
	_endthread();
}

BOOL AuthorisedSource(char *address)
{
	if(!address) return(0);
	if(!strlen(address)) return(1);
	if(!strlen(SnareIP)) return(1);
	if(!strncmp(address,SnareIP,sizeof(SnareIP))) {
		return(1);
	}
	return(0);
}

void decodeurl(char *pEncoded)
{
	char *pDecoded;

	pDecoded=pEncoded;
	while (*pDecoded) {
		if (*pDecoded=='+') *pDecoded=' ';
		pDecoded++;
	};
	pDecoded=pEncoded;
	while (*pEncoded) {
		if (*pEncoded=='%') {
			pEncoded++;
			if(pEncoded[0]) {
				if(pEncoded[1]) {
					if (isxdigit(pEncoded[0])&&isxdigit(pEncoded[1])) {
						// *pDecoded++=(char)hex2int((char *)pEncoded);
						// Special InterSect Alliance - escape ampersands and slashes.
						// Note: hex characters are 3 bytes, we are only adding 2, so no
						// problems with buffer overflows.
						*pDecoded=(char)hex2int((char *)pEncoded);
						if(*pDecoded=='&') {
							*pDecoded++='\\';
							*pDecoded='&';
						} else if(*pDecoded=='\\') {
							*pDecoded++='\\';
							*pDecoded='\\';
						} else if(*pDecoded=='=') {
							*pDecoded++='\\';
							*pDecoded='=';
						}
						pDecoded++;
						// End changes

						pEncoded+=2;
					}
				} else {
					break;
				}
			} else {
				break;
			}
		} else {
			*pDecoded++=*pEncoded++;
		}
	}
	*pDecoded='\0';
}

// Find ampersand-delimited strings (but ignore escaped ampersands).
char * GetNextArgument(char *source,char *destvar,int varlength,char *destval,int vallength)
{
	char prevchar='\0';
	int destlen=0;

	if(!source || !destvar || !destval) {
		return((char *)NULL);
	}

	if(!*source) {
		return((char *)NULL);
	}

	*destvar='\0';
	*destval='\0';

	// length = maximum size of dest
	while(*source && !(*source == '&' && prevchar != '\\') && !(*source == '=' && prevchar != '\\') && destlen<varlength) {

		if(*source!='\\' || (*source == '\\' && prevchar == '\\')) {
			*destvar=*source;
			destvar++;
			destlen++;
		}

		if(*source == '\\' && prevchar == '\\') {
			prevchar=0;
		} else {
			prevchar=*source;
		}

		source++;
	}
	*destvar='\0';

	destlen=0;

	if(*source == '=') {
		// We have a value. Excellent.
		source++;
	
		while(*source && !(*source == '&' && prevchar != '\\') && destlen<vallength) {
			if(*source!='\\' || (*source == '\\' && prevchar == '\\')) {
				*destval=*source;
				destval++;
				destlen++;
			}

			if(*source == '\\' && prevchar == '\\') {
				prevchar=0;
			} else {
				prevchar=*source;
			}
			source++;
		}
		*destval='\0';
	}

	// Return our position in the new string, or null for end of string.
	if(*source) {
		*source++;
	}

	return(source);
}


int hex2int(char *pChars)
{
	int Hi;
	int Lo;
	int Result;

	Hi=pChars[0];
	if ('0'<=Hi&&Hi<='9') {
		Hi-='0';
	} else if ('a'<=Hi&&Hi<='f') {
		Hi-=('a'-10);
	} else if ('A'<=Hi&&Hi<='F') {
		Hi-=('A'-10);
	}
	Lo = pChars[1];
	if ('0'<=Lo&&Lo<='9') {
		Lo-='0';
	} else if ('a'<=Lo&&Lo<='f') {
		Lo-=('a'-10);
	} else if ('A'<=Lo&&Lo<='F') {
		Lo-=('A'-10);
	}
	Result=Lo+(16*Hi);
	return (Result);
}

void RequestAuth(char *HTTPOutputBuffer,int size)
{
	strncpy(HTTPOutputBuffer,"HTTP/1.0 401 Unauthorized\r\n" \
		"Connection: close\r\n" \
		"Content-Type: text/html\r\n" \
		"Server: SNARE\r\n" \
		"WWW-Authenticate: Basic realm=\"SNARE\"\r\n\r\n" \
		"<HTML><HEAD>\r\n<TITLE>401 Authorization Required</TITLE>\r\n" \
		"</HEAD><BODY>\r\n<H2>Authorization Required</H2>\r\nSnare could not " \
		"verify that you.are authorized to access the remote control facility. " \
		"You may have supplied the wrong credentials<P>\r\n<HR>\r\n" \
		"<ADDRESS>Snare Server Remote Control facility</ADDRESS>\r\n</BODY></HTML>\r\n",size);
}

/*void RequestAuth(char *HTTPOutputBuffer,int size)
{
	strncpy(HTTPOutputBuffer,"HTTP/1.0 401 Unauthorized\n" \
		"Connection: close\n" \
		"Content-Type: text/html\n" \
		"Server: SNARE\n" \
		"WWW-Authenticate: Basic realm=\"SNARE\"\n",size);
}*/

BOOL MatchAuth(char *AuthStart)
{
	char AuthString[256]="";
	char AuthString2[256]="";
	char CryptString[256]="";
	char *pos;
	int length=0;

	// Hunt down end of line
	pos=AuthStart;

	while(isalpha(*pos) || (*pos >= '0' && *pos <= '9') || *pos == '+' || *pos == '=') {
		pos++;
	}

	if(!pos) return(0);

	length=(int)(pos-AuthStart);
	if(length<1) return(0);

	if(length >= sizeof(AuthString)) {
		length=sizeof(AuthString) - 1;
	}
	strncpy(AuthString,AuthStart,length);
	AuthString[length]='\0';

	length=base64decode(AuthString2,AuthString);

	pos=strstr(AuthString2,":");

	if(!pos) return(0);

	*pos='\0';
	pos++;

	if(strcmp(AuthString2,"snare") && strcmp(AuthString2,"Snare") && strcmp(AuthString2,"SNARE")) {
		// Username does not match
		return(0);
	}

	strncpy(CryptString,MD5String(pos),sizeof(CryptString));

	if(!strcmp(CryptString,SnarePass)) {
		return(1);
	}

	// Lets try and support non-encrypted passwords too.
	// Removed for 2.4.5
//	if(!strcmp(MD5String(SnarePass),CryptString)) {
//		return(1);
//	}

	return(0);

}

int base64decode(char *dest, char *src)
{
	char *ascii, *pBase64, *mBase64;
	char TopVal, BottomVal;
	int chars_left, i, padding, count=0;
	
	mBase64 = (char *) malloc(strlen(src) + 1);
	pBase64 = mBase64;
	if (pBase64 == NULL) {
		dest[0] = '\0';	// Returns null if there was a problem
		return(0);
	}
	
	strcpy(pBase64, src);
	ascii = dest;
	
	chars_left = (int)strlen(pBase64);
	while (chars_left > 0) {
		padding = 0;
		for (i = 0; i < 4; i++) {
			if (pBase64[i] == '=') {
				padding++;
			} else if (pBase64[i] == '+') {
				pBase64[i] = 62;
			} else if (pBase64[i] == '/') {
				pBase64[i] = 63;
			} else if (pBase64[i] <= '9') {
				pBase64[i] = pBase64[i] + 52 - '0';
			} else if (pBase64[i] <= 'Z') {
				pBase64[i] = pBase64[i] - 'A';
			} else {
				pBase64[i] = pBase64[i] + 26 - 'a';
			}
		}
		TopVal = pBase64[0] << 2;
		BottomVal = pBase64[1] >> 4;
		ascii[0] = TopVal | BottomVal;
		count++;
		
		if (padding < 2) {
			TopVal = pBase64[1] << 4;
			BottomVal = pBase64[2] >> 2;
			ascii[1] = TopVal | BottomVal;
			count++;
			if (padding < 1) {
				TopVal = pBase64[2] << 6;
				ascii[2] = TopVal | pBase64[3];
				count++;
			} else {
				ascii[2] = '\0';
			}
		} else {
			ascii[1] = '\0';
		}
		
		ascii += 3;
		pBase64 += 4;
		chars_left -= 4;
	}
	*ascii = '\0';
	free(mBase64);
	return(count);
}

