// NTService.cpp

#include "NTServApp.h"
#include "SnareCore.h"

extern int SNAREDEBUG;

int main(int argc, char* argv[])
{
    // Create the service object
    CSnarecoreService CustomServiceObject;
#ifdef DEBUG_TO_FILE
	//DMM testing only, REMOVE
	SNAREDEBUG=7;
#endif

    // Parse for standard arguments (install, uninstall, version etc.)
    if (!CustomServiceObject.ParseStandardArgs(argc, argv)) 
	{
		CustomServiceObject.DebugMsg("Args grabbed");
		if(argc>1) {
			CustomServiceObject.DebugMsg("there are args");

			// Go into debug mode if it was a flag we don't recognise (or debug wasn't set)

			if (CustomServiceObject.DEBUGSET < 0 || CustomServiceObject.DEBUGSET > 9) CustomServiceObject.DEBUGSET=9;
			
			// we're debugging, so fake a few calls & run as a console app
			if (CustomServiceObject.OnInit())
			{
				CustomServiceObject.m_bIsRunning = TRUE;
				CustomServiceObject.Run();
			}
			
		} else {
			CustomServiceObject.DebugMsg("no args");

#ifndef _DEBUG
			// Didn't find any standard args so start the service
			CustomServiceObject.StartService();
#else
			// we're debugging, so fake a few calls & run as a console app
			if (CustomServiceObject.OnInit())
			{
				CustomServiceObject.m_bIsRunning = TRUE;
				CustomServiceObject.Run();
			}
#endif
		}
	}

    // When we get here, the service has been stopped
    return CustomServiceObject.m_Status.dwWin32ExitCode;
}
