// SNARE - Audit / EventLog analysis and forwarding
// Copyright 2001-2006 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// See Readme.txt file for more information.
//
// NOTE: Use the \data\64bit.bat file to compile in 64 bit mode!!!!
#include <stdio.h>
#include <stdlib.h>
#include <winsock2.h>
#include <windows.h>
#include <time.h>
#include <tchar.h>
#include <sys/stat.h>

#include "NTServApp.h"
#include "SnareCore.h"
#include "webserver.h"
#include "MD5.h"
#include "Version.h"


// memory testing only
//#define MEMDEBUG 1

#ifdef MEMDEBUG
// MEMORY LEAK DETECTION ROUTINES
	// #define _CRTDBG_MAP_ALLOC
	#define CRTDBG_MAP_ALLOC
	#include <stdlib.h>
	#include <crtdbg.h>
#endif

//#define DEBUG_TO_FILE 1

// Quick function proto
void DebugMsg(const char* pszFormat, ...);


// Pull this from registry
DWORD			WEBSERVER_ACTIVE = 0;

DWORD			g_dwLastError			= 0L;
char			Hostname[100];
ThreadStruct	g_Info;
//SOCKET *		g_hSockets;						// Array of socket pointers - one for each destination.
//char **			SocketNames;					// HostNames for each of the sockets.
//int				SocketCount=0;
//SOCKET			g_hSocket = INVALID_SOCKET;     // client/server socket, used in for/next loops.
int				nStopListening=0;
DWORD			dwEventIDRead[6];				// maintain entries for those events that we have already read.
DWORD			dwEventIDOldest[6];				// Save off the 'oldest' entry in each list, so we know when to rotate.
DWORD			dwEventLogCleared[6];			// Used to flag when an event log has been cleared, during normal operations
TCHAR			DELIM[2]="	";					// TAB

int				AuditFlags[9];					// Array of audit flags to set.
												// Note: Increase this if the POLICY_AUDIT_EVENTTYPE grows in ntsecapi.h

int				SNAREDEBUG=0;

int				USB_ENABLED=0;					// Are we looking for USB events.

static Node *head, *currentnode;

// Host target list
static HostNode *hosthead, *hostcurrentnode;

int MCCount=0;
MsgCache *MCHead=NULL;
MsgCache *MCTail=NULL;
MsgCache *MCCurrent=NULL;

USBMsg *usb_msg=NULL;
USBMsg *usb_msg_head=NULL;
USBMsg *usb_msg_tail=NULL;

// Locker
HANDLE hMutex;
DWORD WebResetFlag=0;

CSnarecoreService::CSnarecoreService()
:CNTService("SNARE")
{
	//TODO: Initialize your class members here
}

BOOL CSnarecoreService::OnInit()
{
	char szError[MAX_STRING];
	//TODO: Perform any initialization that needs to be done before entering the main loop

	SNAREDEBUG=this->DEBUGSET;

	if( !InitWinsock( szError,_countof(szError) ) )
	{
		if(SNAREDEBUG >= 9) { DebugMsg(szError); }
		return FALSE;
	}

	m_hEventList[0] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[1] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[2] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[3] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[4] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[5] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[6] = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hEventList[7] = CreateEvent(NULL, TRUE, FALSE, NULL);


	
	if(m_hEventList[0] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 0 failed"); }	return FALSE;	}
	if(m_hEventList[1] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 1 failed"); }	return FALSE;	}
	if(m_hEventList[2] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 2 failed"); }	return FALSE;	}
	if(m_hEventList[3] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 3 failed"); }	return FALSE;	}
	if(m_hEventList[4] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 4 failed"); }	return FALSE;	}
	if(m_hEventList[5] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() 5 failed"); }	return FALSE;	}

	if(m_hEventList[6] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() Web notification failed"); }	return FALSE;	}
	if(m_hEventList[7] == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() Custom event log failed"); }	return FALSE;	}


	hMutex = CreateMutex(NULL,FALSE,"SnareAgentLock");
	if(hMutex == NULL) {
		if(SNAREDEBUG >= 9) { DebugMsg("I cannot create the Snare Agent 'Mutex' lock. This probably means that you already have another instance of the Snare Agent running.\nPlease stop the other incarnation of the Snare Agent (eg: net stop snare) before continuing."); }
		return FALSE;
	}

	if(SNAREDEBUG >= 9) { DebugMsg("SNARE Initialisation complete"); }
#ifdef DEBUG_TO_FILE
	//DMM testing only, REMOVE
	SNAREDEBUG=6;
#endif
	DebugMsg("SNAREDEBUG: %d", SNAREDEBUG);
	// return FALSE here if initialization failed & the service shouldn't start
	return TRUE;
}

void CSnarecoreService::Run()
{
	DWORD dwEventLogRecords = 0, dwOldestEventLogRecord = 0, dwNewestEventLogRecord = 0,
		dwEvLogStart = 0, dwEvLogCounter = 0, dwNumberOfBytesToRead = 0, 
		dwBytesRead = 0, dwMinNumberOfBytesNeeded = 0, dwCancel = 0, dwClose = 0;

	DWORD ClearTabs=0;
	DWORD dwSyslogHeader=0; // Send the Syslog header?
	DWORD dwPortNumber=6161;
	DWORD dwRestrictIP=0;
	DWORD dwUsePassword=0;

	DWORD dwCatchUpCount=0;
	DWORD dwWaitRes=0,dwWaitReset=0;

	long Category=0;

	// Define an eventlogrecord buffer of 8k.
	// Should be enough for an overwhelming majority of circumstances.
	TCHAR EventLogRecordBuffer[MAX_EVENT]="";
	TCHAR SourceName[100]="";	// Eg: "Security" or "Active Directory"
	TCHAR SIDType[100]="";		// User or System
	TCHAR EventLogType[60]=""; // Warning / Information / success / failure
	TCHAR ExpandedString[MAX_EVENT]="";
	TCHAR DataString[MAX_EVENT]="";
	TCHAR ComputerName[256]="";
	TCHAR UserName[256]="";
	TCHAR szCategoryString[256]=""; // "Detailed Tracking"

  	TCHAR szError[MAX_STRING]="";

	TCHAR SubmitTime[26]="None Yet";
	TCHAR WriteTime[26];

	TCHAR lpszIPAddress[SIZE_OF_RESTRICTIP];
	TCHAR lpszPassword[256];

	short nEventCount=7; // including pipe events

	short TimeoutCounter=0;
	short MessageCounter=0;
	short LogCounter=0;
	short SnareTimeout=0;

	// Destination for log events. Default it to something safe.
	TCHAR lpszDestination[SIZE_OF_DESTINATION]="127.0.0.1";

	PEVENTLOGRECORD pELR = 0;
	PSID UserSID = 0;
	unsigned long EventID=0;
	
	BOOL bRetVal = FALSE;
	BOOL fExit = FALSE;
	UINT uStep = 0, uStepAt = 0, uPos = 0, uOffset = 0;

	int nRet;
	int etype=0;	// eventlog type
	int stype=0;	// source type
	UINT EventTriggered=0;

	DWORD SocketType=SOCKETTYPE_UDP;	// 0 for UDP, 1 for TCP.

	DWORD Offset=0;
	DWORD dwDestPort=6161;
	DWORD dwSyslog=13;
	DWORD dwSyslogDynamic=0;
	DWORD dwCritAudit=0;
	DWORD dwObjectiveCount=0;
	Node **MatchList=NULL;
	Node **MatchPointer=NULL;
	DWORD MatchCount;
	BOOL MatchFound=0;

	static DWORD SnareCounter=1;
	static BOOL ActivateChecksum=0;
	
	TCHAR EventLogSourceName[MAX_LOG_TYPE + 1][_MAX_PATH + 1];

	FILE * OutputFile=(FILE *)NULL;

	// Syslog, and output log time variables.
	time_t currenttime;
	struct tm newtime;
	struct tm savedtime;

	// Initialise the elements of savedtime that we use.
	savedtime.tm_mday=0;
	savedtime.tm_mon=0;
	savedtime.tm_year=0;

	strncpy_s(EventLogSourceName[LOG_TYPE_SECURITY],_countof(EventLogSourceName[LOG_TYPE_SECURITY]),"Security",_TRUNCATE);
	strncpy_s(EventLogSourceName[LOG_TYPE_SYSTEM],_countof(EventLogSourceName[LOG_TYPE_SYSTEM]),"System",_TRUNCATE);
	strncpy_s(EventLogSourceName[LOG_TYPE_APPLICATION],_countof(EventLogSourceName[LOG_TYPE_APPLICATION]),"Application",_TRUNCATE);
	strncpy_s(EventLogSourceName[LOG_TYPE_DS],_countof(EventLogSourceName[LOG_TYPE_DS]),"Directory Service",_TRUNCATE);
	strncpy_s(EventLogSourceName[LOG_TYPE_DNS],_countof(EventLogSourceName[LOG_TYPE_DNS]),"DNS Server",_TRUNCATE);
	strncpy_s(EventLogSourceName[LOG_TYPE_FRS],_countof(EventLogSourceName[LOG_TYPE_FRS]),"File Replication Service",_TRUNCATE);

	// This is the internal Snare eventlog counter.
	DWORD EventLogCounter[6];
	EventLogCounter[0]=0;
	EventLogCounter[1]=0;
	EventLogCounter[2]=0;
	EventLogCounter[3]=0;
	EventLogCounter[4]=0;
	EventLogCounter[5]=0;

	dwEventIDRead[0]=0; dwEventIDRead[1]=0; dwEventIDRead[2]=0;
	dwEventIDRead[3]=0; dwEventIDRead[4]=0; dwEventIDRead[5]=0;

	dwEventLogCleared[0]=0; dwEventLogCleared[1]=0; dwEventLogCleared[2]=0;
	dwEventLogCleared[3]=0; dwEventLogCleared[4]=0; dwEventLogCleared[5]=0;

	dwEventIDOldest[0]=dwEventIDOldest[1]=dwEventIDOldest[2]=dwEventIDOldest[3]=dwEventIDOldest[4]=dwEventIDOldest[5]=0;

	if(SNAREDEBUG >= 1) { DebugMsg("SNARE is Running"); }

	// READ in our data
	GetHostname(Hostname,_countof(Hostname));
	GetDestPort(&dwDestPort);
	GetSocketType(&SocketType);
	GetSyslog(&dwSyslog);
	GetSyslogDynamic(&dwSyslogDynamic);
	GetSyslogHeader(&dwSyslogHeader);
	GetWEBSERVER_ACTIVE(&WEBSERVER_ACTIVE);
	GetPortNumber(&dwPortNumber);
	GetDestination(lpszDestination,_countof(lpszDestination));
	GetCrit(&dwCritAudit);
	if(dwSyslogHeader) {
		GetDelim(DELIM,_countof(DELIM));
	}
	GetPassword(lpszPassword,_countof(lpszPassword));
	GetIPAddress(lpszIPAddress,_countof(lpszIPAddress));
	GetClearTabs(&ClearTabs);
	GetChecksum(&ActivateChecksum);

	OutputFile=GetOutputFile();

	// Load the objective data here.
	dwObjectiveCount=ReadObjectives();
	if(dwObjectiveCount) {
		// Malloc a array for our FastCheckObjective process
		MatchList = (Node **)malloc(dwObjectiveCount * sizeof(Node *));
		if(!MatchList) {
			if(SNAREDEBUG >= 9) DebugMsg("Cannot allocate memory for our internal Objective match list");
			dwObjectiveCount=0;
		}
	}


	hosthead=OpenSockets(lpszDestination,dwDestPort,SocketType);

	
	if(SNAREDEBUG >= 9) DebugMsg("Sockets opened/connected");
	////////////////// REMEMBER TO FREE THESE SOCKETS LATER!!!!   REDREDRED



	// Open the socket (UDP or TCP) to the indicated port
	//g_hSocket = ConnectToServer( lpszDestination, (UINT)dwDestPort, szError,_countof(szError), SocketType );

	//if( g_hSocket == INVALID_SOCKET ) {
	//	if(SNAREDEBUG >= 9) DebugMsg(szError);
	//}

	// Ok, we have finished our general configuration reads.
	if(SNAREDEBUG >= 9) { DebugMsg("Opening event log sources"); }

	// Open each event log, and if the log exists, bind the event notifier.
	hEventLog[0] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_SECURITY] );
	if(hEventLog[0])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_SECURITY]))
		{
			nRet = NotifyChangeEventLog( hEventLog[0], m_hEventList[0] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 0 failed"); } return; }
		
			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[0], &dwOldestEventLogRecord);
			dwEventIDOldest[0]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[0], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord = 0;
			}

			// Pull in our current position from the registry
			dwEventIDRead[0]=MyGetProfileDWORD("Status","LOG_TYPE_SECURITY",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[0] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[0]) > 5000)) {
				dwEventIDRead[0]=dwNewestEventLogRecord;
			}

			if(SNAREDEBUG >= 1) { DebugMsg("	Opened %s",EventLogSourceName[LOG_TYPE_SECURITY]); }

			// Set log retention to zero.


		} else {
			CloseEventLog(hEventLog[0]);
			hEventLog[0]=NULL;
		}

	}
	hEventLog[1] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_SYSTEM] );
	if(hEventLog[1])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_SYSTEM]))
		{
			nRet = NotifyChangeEventLog( hEventLog[1], m_hEventList[1] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 1 failed"); } return; }

			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[1], &dwOldestEventLogRecord);
			dwEventIDOldest[1]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[1], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord = 0;
			}

			// Pull in our current position from the registry
			dwEventIDRead[1]=MyGetProfileDWORD("Status","LOG_TYPE_SYSTEM",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[1] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[1]) > 5000)) {
				dwEventIDRead[1]=dwNewestEventLogRecord;
			}

			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_SYSTEM]); }
		} else {
			CloseEventLog(hEventLog[1]);
			hEventLog[1]=NULL;
		}
	}
	
	hEventLog[2] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_APPLICATION] );
	if(hEventLog[2])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_APPLICATION]))
		{
			nRet = NotifyChangeEventLog( hEventLog[2], m_hEventList[2] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 2 failed"); } return; }

			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[2], &dwOldestEventLogRecord);
			dwEventIDOldest[2]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[2], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord = 0;
			}

			// Pull in our current position from the registry
			dwEventIDRead[2]=MyGetProfileDWORD("Status","LOG_TYPE_APPLICATION",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[2] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[2]) > 5000)) {
				dwEventIDRead[2]=dwNewestEventLogRecord;
			}
			
			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_APPLICATION]); }
		} else {
			CloseEventLog(hEventLog[2]);
			hEventLog[2]=NULL;
		}
	}
	
	// Optional event logs - ie: not present on NT
	// NOTE: If this eventlog does not exist, Windows returns
	//       a handle to the Application log.
	hEventLog[3] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_DS] );
	if(hEventLog[3])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_DS]))
		{
			nRet = NotifyChangeEventLog( hEventLog[3], m_hEventList[3] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 3 failed"); } return; }

			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[3], &dwOldestEventLogRecord);
			dwEventIDOldest[3]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[3], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord=0;
			}
			
			// Pull in our current position from the registry
			dwEventIDRead[3]=MyGetProfileDWORD("Status","LOG_TYPE_DS",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[3] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[3]) > 5000)) {
				dwEventIDRead[3]=dwNewestEventLogRecord;
			}



			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_DS]); }

		} else {
			CloseEventLog(hEventLog[3]);
			hEventLog[3]=NULL;
		}
	}

	// Optional event logs - ie: not present on NT
	hEventLog[4] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_DNS] );
	if(hEventLog[4])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_DNS]))
		{
			nRet = NotifyChangeEventLog( hEventLog[4], m_hEventList[4] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 4 failed"); } return; }

			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[4], &dwOldestEventLogRecord);
			dwEventIDOldest[4]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[4], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord = 0;
			}
			
			
			// Pull in our current position from the registry
			dwEventIDRead[4]=MyGetProfileDWORD("Status","LOG_TYPE_DNS",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[4] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[4]) > 5000)) {
				dwEventIDRead[4]=dwNewestEventLogRecord;
			}


			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_DNS]); }
		} else {
			CloseEventLog(hEventLog[4]);
			hEventLog[4]=NULL;
		}
	}

	// Optional event logs - ie: not present on NT
	hEventLog[5] = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_FRS] );
	if(hEventLog[5])
	{
		if(CheckLogExists(EventLogSourceName[LOG_TYPE_FRS]))
		{
			nRet = NotifyChangeEventLog( hEventLog[5], m_hEventList[5] );
			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 5 failed"); } return; }

			// Work out the latest audit log record
			GetOldestEventLogRecord(hEventLog[5], &dwOldestEventLogRecord);
			dwEventIDOldest[5]=dwOldestEventLogRecord;
			GetNumberOfEventLogRecords(hEventLog[5], &dwEventLogRecords);
			if(dwEventLogRecords) {
				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
			} else {
				dwNewestEventLogRecord = 0;
			}
			
			// Pull in our current position from the registry
			dwEventIDRead[5]=MyGetProfileDWORD("Status","LOG_TYPE_FRS",0);
			// If it's over 5000 events in the past, go to the most recent log.
			if(dwEventIDRead[5] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[5]) > 5000)) {
				dwEventIDRead[5]=dwNewestEventLogRecord;
			}


			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_FRS]); }
		} else {
			CloseEventLog(hEventLog[5]);
			hEventLog[5]=NULL;
		}
	}
	////DMM
	//// Custom event logs, first check if there are any
	//if (
	//hCustEventLog = (EvtHandle *)malloc(sizeof(EvtHandle));
	//if (hCustEventLog) {
	//	hCustEventLog->hSocket = OpenEventLog( NULL, EventLogSourceName[LOG_TYPE_FRS] );
	//	if(hEventLog[5])
	//	{
	//		if(CheckLogExists(EventLogSourceName[LOG_TYPE_FRS]))
	//		{
	//			nRet = NotifyChangeEventLog( hEventLog[5], m_hEventList[5] );
	//			if(!nRet) { if(SNAREDEBUG >= 1) { DebugMsg("Event Bind 5 failed"); } return; }

	//			// Work out the latest audit log record
	//			GetOldestEventLogRecord(hEventLog[5], &dwOldestEventLogRecord);
	//			dwEventIDOldest[5]=dwOldestEventLogRecord;
	//			GetNumberOfEventLogRecords(hEventLog[5], &dwEventLogRecords);
	//			if(dwEventLogRecords) {
	//				dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
	//			} else {
	//				dwNewestEventLogRecord = 0;
	//			}
	//			
	//			// Pull in our current position from the registry
	//			dwEventIDRead[5]=MyGetProfileDWORD("Status","LOG_TYPE_FRS",0);
	//			// If it's over 5000 events in the past, go to the most recent log.
	//			if(dwEventIDRead[5] == 0 || ((dwNewestEventLogRecord - dwEventIDRead[5]) > 5000)) {
	//				dwEventIDRead[5]=dwNewestEventLogRecord;
	//			}


	//			if(SNAREDEBUG >= 1) { DebugMsg("Opened %s",EventLogSourceName[LOG_TYPE_FRS]); }
	//		} else {
	//			CloseEventLog(hEventLog[5]);
	//			hEventLog[5]=NULL;
	//		}
	//	}
	//} else {
	//	if (SNAREDEBUG >= 9) DebugMsg("Could not allocate memory for custom event logs");
	//}

	if(WEBSERVER_ACTIVE) {
		if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
			StartWebThread(m_hEventList[6]);
		} else {
			if(SNAREDEBUG >= 5) { DebugMsg("Unable to start web server [1], disabling."); }
			WEBSERVER_ACTIVE = 0;
		}
	}

	// Monitor the pipe
	// Set the terminate flag to zero.
	// setting this value to TRUE will terminate the service,
	// and ask it to save it's current status.
	g_Info.bTerminate = FALSE;

	
	if(SNAREDEBUG >= 9) { DebugMsg("Entering main loop."); }
	// This is the service's main run loop.
    while (m_bIsRunning) 
	{
		// TODO: Add code to perform processing here  
		// If we have been asked to terminate, do so.
		if(g_Info.bTerminate)
		{
			m_bIsRunning=0;
			break;
		}
		while (usb_msg_head && USB_ENABLED) {
			if (SNAREDEBUG >= 6) DebugMsg("USB: Checking USB Events..");
			static char szSendString[MAX_OUTPUT_STRING]=""; // Nice big memory buffer - just in case.
			static char szTempString[MAX_EVENT]=""; // Approximately the maximum we could reasonably expect to transfer over UDP
			USBMsg *temp;
			if (SNAREDEBUG >= 6) DebugMsg("USB: Event found, processing data for USB event");
			EventTriggered = LOG_TYPE_SYSTEM;
			etype = TYPE_INFO;
			stype = LOG_SYS;
			EventID = usb_msg_head->EventID;

			if (dwObjectiveCount){
				MatchCount=0;
				MatchPointer=MatchList; // Start of the list
				if(!MatchPointer) {
					// Something seriously wierd is happening if MatchPointer is null.
					// Leave the usb messages as they are and try again later.
					if(SNAREDEBUG >= 7) DebugMsg("Match Pointer has gone away");
					break;
				}
				do {
					try {
						*MatchPointer=FastCheckObjective(EventID,etype,stype);
					} catch(...) {
						if(SNAREDEBUG >= 7) DebugMsg("FastCheckObjective: Error encountered!");
						if(SNAREDEBUG >= 7) DebugMsg("MatchPointer is %ld, EventID is %d, etype is %d, stype is %d",*MatchPointer,EventID,etype,stype);
						*MatchPointer=NULL;
					}
					
					if(*MatchPointer) {
						MatchFound=1;
						MatchCount++;
						MatchPointer++;
					} else {
						MatchFound=0;
					}
				} while(MatchFound && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows
				
				if(g_Info.bTerminate) {
					m_bIsRunning=0;
					break;
				}
				if(!MatchCount) {
					if(SNAREDEBUG >= 7) { DebugMsg("Match Checker: No matches found, clearing data for USB event"); }
					temp = usb_msg_head;
					usb_msg_head = usb_msg_head->next;
					free(temp);
					continue;
				}
			}
			if (!usb_msg_head) {
				//strncpy_s(SubmitTime,_countof(SubmitTime),"",_TRUNCATE);
				break;
			}
			if(SNAREDEBUG >= 7) { DebugMsg("FastCheckObjective: found matches (%d)",MatchCount); }
			strncpy_s(SubmitTime,_countof(SubmitTime),usb_msg_head->SubmitTime,_TRUNCATE);
			_snprintf_s(SourceName, _countof(SourceName),_TRUNCATE,"Removable Storage Service");
			_snprintf_s(EventLogType,_countof(EventLogType),_TRUNCATE,"Information");
			strncpy_s(DataString,_countof(DataString),"",_TRUNCATE);
			_snprintf_s(szTempString,_countof(szTempString),_TRUNCATE,"Received a device interface %s notification for device: %s", usb_msg_head->type, usb_msg_head->name);
			strncpy_s(szCategoryString,_countof(szCategoryString),"N/A",_TRUNCATE);
			strncpy_s(UserName,_countof(UserName),"Unknown User",_TRUNCATE);
			strncpy_s(SIDType,_countof(SIDType),"N/A",_TRUNCATE);
			strncpy_s(ComputerName,_countof(ComputerName),Hostname,_TRUNCATE);
			if (SNAREDEBUG >= 6) DebugMsg("USB: clearing data for USB event");
			temp = usb_msg_head;
			usb_msg_head = usb_msg_head->next;
			free(temp);
			if (SNAREDEBUG >= 6) DebugMsg("USB: done");
			//DMM
			if(strlen(EventLogSourceName[EventTriggered]) && strlen(SubmitTime) && strlen(SourceName) && strlen(EventLogType) && strlen(ComputerName) && DataString && strlen(szTempString) && strlen(szCategoryString))
			{
				if (SNAREDEBUG >= 6) DebugMsg("Event is ready, checking objectives");
				char *stringp;
				
				// This is the point at which we integrate our regular expression handling
				// and event filtering facilities.
				// NOTE:
				// Was going to implement a regular expression matching capability,
				// - but based on the limitations of the NT Audit subsystem, it's probably
				//   better that we use dos wildcards instead.
				//
				
				DWORD ShortEventID=0;
				// Cut off the severity, flags, and  facility data
				// Just leave the real event ID.
				ShortEventID = EventID & 65535;
				if (SNAREDEBUG >= 6) DebugMsg("ShortEventID: %d", ShortEventID);
				char header[256];
				
				BOOL nodematch=0;
				int criticality=0;
				int tcriticality=0;
				
				if (SNAREDEBUG >= 6) DebugMsg("dwObjectiveCount: %d", dwObjectiveCount);
				// Check objectives
				// NOTE: If there are no objectives, send all?
				if(!dwObjectiveCount) {
					nodematch=1;
				} else {
					MatchCount=0;
					MatchPointer=MatchList; // Start of the list
					
					do {
						if (SNAREDEBUG >= 6) DebugMsg("begin MatchCount: %d", MatchCount);
						// Some of the MS System calls used in CheckObjective are buggy.
						try {
							tcriticality=CheckObjective(*MatchPointer,ShortEventID,UserName,szTempString);
						} catch(...) {
							if(SNAREDEBUG >= 7) DebugMsg("CheckObjective CRASH");
							tcriticality=0;
						}
						if(tcriticality >= 0) {
							nodematch=1;
							if(SNAREDEBUG >= 7) { DebugMsg("Checkobjective: node found"); }
							if(criticality < tcriticality) {
								criticality = tcriticality;
							}
							if(!dwCritAudit) {
								// break here if we just want the FIRST match.
								break;
							}
						}
						MatchPointer++;
						MatchCount++;

						if (SNAREDEBUG >= 6) DebugMsg("end MatchCount: %d", MatchCount);
					} while(*MatchPointer && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows
					
					if(g_Info.bTerminate) {
						m_bIsRunning=0;
						break;
					}
					if (SNAREDEBUG >= 6) {
						if (!*MatchPointer) DebugMsg("Check Objective finished: MatchPointer has gone away");
						if (MatchCount >= dwObjectiveCount) DebugMsg("Check Objective finished: no objectives left to check");
					}
				}
				// END
				if (SNAREDEBUG >= 6) DebugMsg("nodematch: %d", (nodematch?1:0));
				if(nodematch) {
					
					if(dwSyslogHeader || OutputFile) {
						time(&currenttime);
						localtime_s(&newtime,&currenttime);
					}
					
					if(OutputFile) {
						// Check to see whether we need to rotate our log file.
						if(newtime.tm_year != savedtime.tm_year ||
							newtime.tm_mon != savedtime.tm_mon ||
							newtime.tm_mday != savedtime.tm_mday) {
							
							fclose(OutputFile);
							OutputFile=GetOutputFile();
							
							savedtime.tm_year=newtime.tm_year;
							savedtime.tm_mon=newtime.tm_mon;
							savedtime.tm_mday=newtime.tm_mday;
						}
					}
			
					char CurrentDate[16]="";
					if(dwSyslogHeader) {
						DWORD tdwSyslog;
						
						syslogdate(CurrentDate,&newtime);
						
						
						// HERE: Split out criticality.
						if(dwSyslogDynamic) {
							tdwSyslog=((7-criticality) & 7) | ((dwSyslog >> 3) << 3);
						} else {
							tdwSyslog=dwSyslog;
						}
						
						_snprintf_s(header,_countof(header),_TRUNCATE,"<%ld>%s %s MSWinEventLog%s%d%s",tdwSyslog,CurrentDate,Hostname,DELIM,criticality,DELIM);
					} else {
						_snprintf_s(header,_countof(header),_TRUNCATE,"%s%sMSWinEventLog%s%d%s",Hostname,DELIM,DELIM,criticality,DELIM);
					}
					
					_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s%d%s%s%s%ld%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%d\0",header,EventLogSourceName[EventTriggered],DELIM,SnareCounter,DELIM,SubmitTime,DELIM,ShortEventID,DELIM,SourceName,DELIM,UserName,DELIM,SIDType,DELIM,EventLogType,DELIM,ComputerName,DELIM,szCategoryString,DELIM,DataString,DELIM,szTempString,DELIM,EventLogCounter[EventTriggered]);
					if(SNAREDEBUG >= 3 && DataString) { DebugMsg("DataString: %s",DataString); }
					if(SNAREDEBUG >= 3 && szTempString) { DebugMsg("szTempString: %s",szTempString); }
					
					// Jump through szSendString, and remove any newline characters.
					stringp=szSendString;
					while(*stringp) {
						// CR or LF
						if(*stringp==10 || *stringp==13) {
							*stringp=' ';
						}
						stringp++;
					}
					
					// Add in an MD5 if appropriate
					if(ActivateChecksum) {
						char CryptString[64];
						strncpy_s(CryptString,_countof(CryptString),MD5String(szSendString),_TRUNCATE);
						_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s",szSendString,DELIM,CryptString);
					}
					
					// Ok, now add a newline.
					if (strlen(szSendString) >= _countof(szSendString)) {
						szSendString[strlen(szSendString)-1]='\n';
					} else {
						strncat_s(szSendString,_countof(szSendString),"\n",_TRUNCATE);
					}
					
					if(SNAREDEBUG >= 3 && strlen(szSendString)) { DebugMsg("DEBUG: Sending the following string to the server: %s",szSendString); }
					
					BOOL DataSent=0;

					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						//if (SNAREDEBUG >= 2) DebugMsg("sending data to %s", hostcurrentnode->HostName);
						if(hostcurrentnode->Socket == INVALID_SOCKET) {
							// Try to reestablish here.
							// Since socket connects use a fair bit of system resources, try and do it nicely.
							if(SNAREDEBUG >= 9) { DebugMsg("Socket is toast for %s. Trying to reestablish.",hostcurrentnode->HostName); }
							
							hostcurrentnode->Socket = ConnectToServer( hostcurrentnode, (UINT)dwDestPort, szError, _countof(szError), SocketType );
							
							if(hostcurrentnode->Socket == INVALID_SOCKET) {
								// Hmm. Try again later.
								// Jump to the next socket
								hostcurrentnode=hostcurrentnode->next;
								if (SNAREDEBUG >=9) DebugMsg("Failed to reconnect socket");
								continue;
							}
						}

						if( !SendToSocket(hostcurrentnode, szSendString, (int)strlen(szSendString), szError, _countof(szError)) )
						{
							if(SNAREDEBUG >= 9) { if(szError) { DebugMsg(szError); } }
							if(SNAREDEBUG >= 9) { DebugMsg("Socket for %s is toast. Breaking out - will reestablish next time.",hostcurrentnode->HostName); }
							// Close the socket. Restablish it on the next cycle, if we can.
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						} else {
							DataSent=1;
						}

						hostcurrentnode=hostcurrentnode->next;
					}


					// Did we push out at least one record?
					if(!DataSent) {
						dwEvLogCounter--;
						dwNewestEventLogRecord=dwEvLogCounter;
						if (SNAREDEBUG >= 1) DebugMsg("Failed to send message, holding position in event log");
						// Break out of the for/next loop.
						break;
					} else {
						MCCurrent = (MsgCache *)malloc(sizeof(MsgCache));
						if (MCCurrent) {
							strncpy_s(MCCurrent->Hostname,_countof(MCCurrent->Hostname),Hostname,_TRUNCATE);
							MCCurrent->criticality = criticality;
							MCCurrent->SnareCounter = SnareCounter;
							strncpy_s(MCCurrent->SubmitTime, 26, SubmitTime,_TRUNCATE);
							MCCurrent->ShortEventID = ShortEventID;
							strncpy_s(MCCurrent->SourceName, 100, SourceName,_TRUNCATE);
							strncpy_s(MCCurrent->UserName, 256, UserName,_TRUNCATE);
							strncpy_s(MCCurrent->SIDType, 100, SIDType,_TRUNCATE);
							strncpy_s(MCCurrent->EventLogType, 60, EventLogType,_TRUNCATE);
							strncpy_s(MCCurrent->szCategoryString, 256, szCategoryString,_TRUNCATE);
							strncpy_s(MCCurrent->szTempString, MAX_EVENT, szTempString,_TRUNCATE);
							MCCurrent->EventLogCounter = EventLogCounter[EventTriggered];
							MCCurrent->seenflag=0;
							MCCurrent->next = NULL;
							MCCurrent->prev = NULL;
							dwWaitRes = WaitForSingleObject(hMutex,500);
							if(dwWaitRes == WAIT_OBJECT_0) {
								if (MCCount >= WEB_CACHE_SIZE) {
									//Lock Mutex and drop the oldest record
									MsgCache *temp;
									temp = MCTail;
									MCTail = MCTail->prev;
									MCTail->next = NULL;
									free(temp);
									MCCount--;
								}
							} else {
								if(SNAREDEBUG >= 9) DebugMsg("USB: EVENT CACHE FAILED!\n");
							}
							ReleaseMutex(hMutex);
							if (MCHead) {
								MCHead->prev = MCCurrent;
								MCCurrent->next = MCHead;
							}
							MCHead = MCCurrent;
							if (!MCTail) MCTail = MCCurrent;
							MCCount++;
						} else {
							if(SNAREDEBUG >= 9) DebugMsg("Unable to allocate latest event cache\n");
						}
						// Increment the Snare internal event counter
						// Note: Maxdword is 4294967295
						// Dont overflow our array either.
						if(EventTriggered <= 5) {
							EventLogCounter[EventTriggered]++;
							if(EventLogCounter[EventTriggered] >= MAXDWORD) {
								EventLogCounter[EventTriggered]=1;
							}
						}
						SnareCounter++;
						if(SnareCounter >= MAXDWORD) {
							SnareCounter=1;
						}
					}
					
					// Write the data out to a disk, if requested.
					if(OutputFile) {
						fputs(szSendString,OutputFile);
						fflush(OutputFile);
					}
				}
#ifdef MEMDEBUG
				_CrtDumpMemoryLeaks();
#endif
			} else {
				DebugMsg("ERROR: Invalid USB event.");
			}
		}
		// The service performs one check per 5 seconds. This should not be
		// a significant drain on resources.
		dwWaitRes=WaitForMultipleObjects(nEventCount,m_hEventList,FALSE,5000);

		// if(dwWaitRes != WAIT_FAILED && dwWaitRes != WAIT_TIMEOUT)
		if(dwWaitRes != WAIT_FAILED)
		{
			EventTriggered=0;
			stype = LOG_APP;	 // Assume application log if no valid source provided.
			if(dwWaitRes == WAIT_OBJECT_0) {
				EventTriggered=0;
				ResetEvent(m_hEventList[0]);
				TimeoutCounter=0;
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 0 Triggered."); }
				stype = LOG_SEC;
			} else if (dwWaitRes == WAIT_OBJECT_0+1) {
				EventTriggered=1;
				ResetEvent(m_hEventList[1]);
				TimeoutCounter=0;
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 1 Triggered."); }
				stype = LOG_SYS;
			} else if (dwWaitRes == WAIT_OBJECT_0+2) {	
				EventTriggered=2;
				ResetEvent(m_hEventList[2]);
				TimeoutCounter=0;
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 2 Triggered."); }
				stype = LOG_APP;
			} else if (dwWaitRes == WAIT_OBJECT_0+3) {	
				EventTriggered=3;
				ResetEvent(m_hEventList[3]);
				TimeoutCounter=0;
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 3 Triggered."); }
				stype = LOG_DIR;
			} else if (dwWaitRes == WAIT_OBJECT_0+4) {	
				EventTriggered=4;
				ResetEvent(m_hEventList[4]);
				TimeoutCounter=0;
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 4 Triggered."); }
				stype = LOG_DNS;
			} else if (dwWaitRes == WAIT_OBJECT_0+5) {	
				EventTriggered=5;
				TimeoutCounter=0;
				ResetEvent(m_hEventList[5]);
				if(SNAREDEBUG >= 1) { DebugMsg("WAIT_OBJECT 5 Triggered."); }
				stype = LOG_REP;
			} else if (dwWaitRes == WAIT_OBJECT_0+6) {	
				//do nothing, this means there has been a web reset event, it will be handled below.
				// this is just to prevent a delay
				ResetEvent(m_hEventList[6]);
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Reset event received"); }
			} else if (dwWaitRes == WAIT_TIMEOUT) {
 				if(SNAREDEBUG >= 9) { DebugMsg("Timeout hit"); }

				//Firstly check if there are any usb events
				if (usb_msg_head) {
					TimeoutCounter=0;
				} else {
					// Every 20 seconds, check one of the open log files for new events.
					// This is just in case notifychangeeventlog does not let us know
					// about new events
					if(TimeoutCounter < 4) {
						TimeoutCounter++;
						continue;
					}
					TimeoutCounter=0;
					
					
					for(int tcounter=0;tcounter<=MAX_LOG_TYPE;tcounter++) {
						LogCounter++;
						if(LogCounter > MAX_LOG_TYPE) {
							LogCounter=0;
						}
						if(hEventLog[LogCounter]) {
							break;
						}
					}

					// set STYPE here, as it's not set due to a normal WAIT event.
					if(LogCounter == 0) {
						stype = LOG_SEC;
						MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
					} else if(LogCounter == 1) {
						stype = LOG_SYS;
						MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
					} else if(LogCounter == 2) {
						stype = LOG_APP;
						MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
					} else if(LogCounter == 3) {
						stype = LOG_DIR;
						MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
					} else if(LogCounter == 4) {
						stype = LOG_DNS;
						MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
					} else if(LogCounter == 5) {
						stype = LOG_REP;
						MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);
					}
					//MessageCounter = 0;

					if(SNAREDEBUG >= 1) { DebugMsg("20 seconds have elapsed. Checking a log file: %d",LogCounter); }

					if(hEventLog[LogCounter]!=NULL) {
						EventTriggered=LogCounter;
					} else {
						// No logs to check? Urk.
						// Hop back into the loop.
						if(SNAREDEBUG >= 9) { DebugMsg("Oh dear. I can't seem to find the next open log file. Something quite strange is going on here."); }
						continue;
					}

					SnareTimeout=1;
				}
			} else {
				if(SNAREDEBUG >= 9) { DebugMsg("Warning: An event occured that I am not programmed to deal with. Continuing"); }
				continue;
			}
			//firstly, check to see if the web server needs resetting:
			if (WebResetFlag) {
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: resetting the web thread"); }
				// Save off our current position in each of our log files.
				MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
				MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
				MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
				MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
				MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
				MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);
				if (WebResetFlag == FULL_WEB_RESET) {
					DestroyList();

					if(WEBSERVER_ACTIVE) {
						CloseWebServer();
					}

					// cancel blocking calls, if any
					WSACancelBlockingCall();

					// Close all active sockets.
					HostNode * temphostnode;

					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						if(hostcurrentnode->Socket != INVALID_SOCKET) {
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						}
						temphostnode=hostcurrentnode->next;

						// Free the RAM associated with this node. We don't need it any more.
						free(hostcurrentnode);
						hostcurrentnode=temphostnode;
						// Just in case
						hosthead=hostcurrentnode;
					}
					hosthead=NULL;


					// READ in our data
					GetHostname(Hostname,_countof(Hostname));
					GetDestPort(&dwDestPort);
					GetSocketType(&SocketType);
					GetSyslog(&dwSyslog);
					GetSyslogDynamic(&dwSyslogDynamic);
					GetSyslogHeader(&dwSyslogHeader);
					GetWEBSERVER_ACTIVE(&WEBSERVER_ACTIVE);
					GetPortNumber(&dwPortNumber);
					GetChecksum(&ActivateChecksum);
					GetDestination(lpszDestination,_countof(lpszDestination));
					if(dwSyslogHeader) {
						GetDelim(DELIM,_countof(DELIM));
					}
					GetPassword(lpszPassword,_countof(lpszPassword));
					GetIPAddress(lpszIPAddress,_countof(lpszIPAddress));
					GetClearTabs(&ClearTabs);

					if(OutputFile) {
						fclose(OutputFile);
					}
					OutputFile=GetOutputFile();

					//if (!dwObjectiveCount) MatchList = NULL;
					if(MatchList) {
						free(MatchList);
						MatchList=NULL;
					}
					// Load the objective data here.
					dwObjectiveCount=ReadObjectives();
					if(dwObjectiveCount) {
						// Malloc a array for our FastCheckObjective process
						MatchList = (Node **)malloc(dwObjectiveCount * sizeof(Node *));
						if(!MatchList) {
							if(SNAREDEBUG >= 9) DebugMsg("Cannot allocate memory for our internal Objective match list");
							dwObjectiveCount=0;
						}
					}
					ResetCurrentNode();

					// Open our outgoing sockets.
					hosthead=OpenSockets(lpszDestination,dwDestPort,SocketType);

					// Ok, we have finished our general configuration reads.

					if(WEBSERVER_ACTIVE) {
						if(SNAREDEBUG >= 5) { DebugMsg("Starting web thread."); }
						if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
							StartWebThread(m_hEventList[6]);
						} else {
							if(SNAREDEBUG >= 5) { DebugMsg("Unable to start web server [2], disabling."); }
							WEBSERVER_ACTIVE = 0;
						}
					}
				} else if (WebResetFlag == BASIC_WEB_RESET) {
					if(WEBSERVER_ACTIVE) {
						if(SNAREDEBUG >= 5) { DebugMsg("Restarting web thread."); }
						CloseWebServer();
						if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
							StartWebThread(m_hEventList[6]);
						} else {
							if(SNAREDEBUG >= 5) { DebugMsg("Unable to start web server [3], disabling."); }
							WEBSERVER_ACTIVE = 0;
						}
					}
					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						//if(hostcurrentnode->Socket != INVALID_SOCKET) {
						if(hostcurrentnode->Socket != INVALID_SOCKET) {
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						}
						hostcurrentnode=hostcurrentnode->next;
					}
				}
				//dwWaitReset = WaitForSingleObject(hMutex,500);
				//if(dwWaitReset == WAIT_OBJECT_0) {
					WebResetFlag=0;
				//}
				//ReleaseMutex(hMutex);
			}
			// The first eventlog record in the file - absolute record number.
			bRetVal=GetOldestEventLogRecord(hEventLog[EventTriggered], &dwOldestEventLogRecord);
			if(bRetVal) {
				// Check to see if the log has rotated.
				if(dwOldestEventLogRecord < dwEventIDOldest[EventTriggered]) {
					dwNewestEventLogRecord=-2;
					if(SNAREDEBUG >= 1) { DebugMsg("Oldest Event log is less than the last known value. Log must have recycled. Prev was is %d, current is %d. Reopening log file from the start.",dwEventIDOldest[EventTriggered],dwOldestEventLogRecord); }
				} else {
					// The total number of eventlog records.
					bRetVal=GetNumberOfEventLogRecords(hEventLog[EventTriggered], &dwEventLogRecords);
					if(bRetVal) {
						// The last eventlog record number
						// Note: This number could shift a little as events drop off the 'bottom' of the pile
						// ie: pass 1, newest might be 1000 (oldest=10, number = 990)
						//     pass 2, newest might be 9999 (oldest=11, number = 990).. so no new events, but one less in the pile.
						dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
						if(SNAREDEBUG >= 1) { DebugMsg("OLDEST: %d Number: %d Newest: %d",dwOldestEventLogRecord,dwEventLogRecords,dwNewestEventLogRecord); }
					} else {
						// Something wierd is happening. Force a close/reopen of this log file.
						dwNewestEventLogRecord=-1;
					}
					dwEventIDOldest[EventTriggered]=dwOldestEventLogRecord;
				}
			} else {
				// Something wierd is happening. Force a close/reopen of this log file.
				dwNewestEventLogRecord=-1;
			}

			// Have we been signaled without any new events being added?
			if(((dwNewestEventLogRecord == dwEventIDRead[EventTriggered]) && dwNewestEventLogRecord != 0 && SnareTimeout==0)) {
				// This should not be happening.. unless the newest event log has an id of 0
				// for some reason, or perhaps we have rolled around to the exact same
				// audit record number while the audit service was no-t running.
				// Either way, ignore the event, and do nothing.
				if(SNAREDEBUG >= 1) { DebugMsg("Event Log counter is still %d. Recording position and continuing at next event.",dwNewestEventLogRecord); }

				//While we are here, may as well record the value
				switch (EventTriggered) {
					case 0: MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]); break;
					case 1: MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]); break;
					case 2: MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]); break;
					case 3: MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]); break;
					case 4: MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]); break;
					case 5: MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]); break;
				}

				// Sleep for a moment, just to give the system time to rotate appropriately.
				Sleep(1000);
				
				// Force a close/reopen of the eventlog
				
				// ACTUALLY, Dont reopen. dwNewestEventLogRecord is slightly variable, and could wander a little.
				//dwNewestEventLogRecord=-1;

				//if(SNAREDEBUG >= 1) { DebugMsg("Event log seems to have rotated strangely!. Jumped to end of log, and continuing."); }
				continue;
			} else if((dwNewestEventLogRecord == dwEventIDRead[EventTriggered]) && dwNewestEventLogRecord != 0 && SnareTimeout==1) {
				// SnareTimeout has asked us to check the eventlog for new events as a result
				// of a regular timeout. If there are no new events, continue on.
				SnareTimeout=0;
				continue;
			}


			if(dwNewestEventLogRecord < 0) {
				for(int i=0;i<10;i++) {
					if(!CloseEventLog(hEventLog[EventTriggered])) {
						if(SNAREDEBUG >= 1) { DebugMsg("1: Closure of eventlog failed! Error is %d.",GetLastError()); }
						if(SNAREDEBUG >= 1 && i==9) { DebugMsg("Bailing out! Cannot seem to close this eventlog. Name is %s, hEventLog[EventTriggered] is %ld, EventTriggered is %d",EventLogSourceName[EventTriggered],hEventLog[EventTriggered],EventTriggered); }
						Sleep(1000);
					} else {
						if(SNAREDEBUG >= 1) { DebugMsg("Closure of eventlog succeeded"); }
						break;
					}
				}

				if(SNAREDEBUG >= 1) { DebugMsg("%s has recycled. Reopening eventlog file.",EventLogSourceName[EventTriggered]); }

				int count=0;
				// open it again.
				do {
					hEventLog[EventTriggered] = OpenEventLog( NULL, EventLogSourceName[EventTriggered] );
					if(hEventLog[EventTriggered] != NULL) {
						break;
					}
					if(SNAREDEBUG >= 1) { DebugMsg("1: Could not re-open event log.. EventTriggered is %d, log name is %s - sleeping for 5 seconds (Error code was %d)",EventTriggered,EventLogSourceName[EventTriggered],GetLastError()); }
					Sleep(5000);
					count++;
					if(count > 20) {
						hEventLog[EventTriggered]=NULL;
						if(SNAREDEBUG >= 1) { DebugMsg("%s wont reopen after 20 attempts. Bailing out.",EventLogSourceName[EventTriggered]); }
						break;
					}
				} while(hEventLog[EventTriggered] == NULL);
				
				if(hEventLog[EventTriggered]==NULL) {
					continue;
				}

				while((nRet = NotifyChangeEventLog( hEventLog[EventTriggered], m_hEventList[EventTriggered] )) == 0) {
					if(SNAREDEBUG >= 1) { DebugMsg("1: Could not re-bind to event log.. sleeping for 5 seconds. Error code was %d",GetLastError()); }
					Sleep(5000);
				}

				// Grab these details again
				GetOldestEventLogRecord(hEventLog[EventTriggered], &dwOldestEventLogRecord);
				dwEventIDOldest[EventTriggered]=dwOldestEventLogRecord;
				// The total number of eventlog records.
				GetNumberOfEventLogRecords(hEventLog[EventTriggered], &dwEventLogRecords);
				// The last eventlog record number
				

				// Jump to the newest event log
				if(dwNewestEventLogRecord == -1) {
					dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
					dwEventIDRead[EventTriggered]=dwNewestEventLogRecord;
					dwEvLogStart=dwNewestEventLogRecord;
				} else {
					// Jump to the start of the log file (log rotation)
					dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
					dwEventIDRead[EventTriggered]=dwOldestEventLogRecord;
					dwEvLogStart=dwOldestEventLogRecord;
				}

				if(SNAREDEBUG >= 1) { DebugMsg("Event log seems to have wrapped!. Continuing."); }
				// Wrap around, and wait for a new signal?


				// Need to continue here, or we will hit the 'log rotation problem' code.
				continue;
			} else {
				//if (EventTriggered != 0 || dwEventIDRead[EventTriggered]!=1 ) dwEvLogStart=dwEventIDRead[EventTriggered]+1;
				// Check if the log has been cleared, if it has, then reset the flag and do NOT increment the log counter
				if (dwEventLogCleared[EventTriggered] == 0) dwEvLogStart=dwEventIDRead[EventTriggered]+1;
				else dwEventLogCleared[EventTriggered] = 0;
			}
			
			SnareTimeout=0;

			// Has the eventlog somehow overtaken us, or is this the first time we
			// have been run?

			if(dwOldestEventLogRecord > dwEventIDRead[EventTriggered]) {
				// Yes. Set our start counter to the first record.
				// This probably means that windows is overwriting old events,
				// and we have been overtaken. VERY doubtful that this will happen
				// within the one second timeout.
				//dwEventIDRead[EventTriggered]=dwOldestEventLogRecord;
				//dwEvLogStart = dwOldestEventLogRecord;
				
				// At the risk of missing a few events, jump to the most recent event.
				dwEventIDRead[EventTriggered]=dwNewestEventLogRecord;
				dwEvLogStart = dwNewestEventLogRecord;
				
				if(SNAREDEBUG >= 1) { DebugMsg("Acceleration problem: I have lost my old event pointer. Recalculating"); }
			}
			
			// No data in the current log file? Break out.
			if(dwEventLogRecords == 0) {
				if(SNAREDEBUG >= 1) { DebugMsg("No events in the current file. Popping back out to the main loop."); }
				continue;
			}

			for(dwEvLogCounter=dwEvLogStart; dwEvLogCounter <= dwNewestEventLogRecord; dwEvLogCounter++) {
				// First, check to see if we should save off a log position
				if (MessageCounter >= MSG_COUNT_SAVE_POS) {
					switch(EventTriggered) {
						case 0: MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEvLogCounter); break;
						case 1: MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEvLogCounter); break;
						case 2: MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEvLogCounter); break;
						case 3: MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEvLogCounter); break;
						case 4: MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEvLogCounter); break;
						case 5: MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEvLogCounter); break;
					}
					if(SNAREDEBUG >= 1) { DebugMsg("Saving position for log: %d", EventTriggered); }
					MessageCounter = 0;
				} else {
					MessageCounter++;
				}
				// Has the user requested that we exit here?
				// This may be called if the user has multiple megabytes of
				// data to send and they didn't realise it.
				if(g_Info.bTerminate) {
					m_bIsRunning=0;
					break;
				}

				// NOTE: THIS WILL POTENTIALLY READ MULTIPLE RECORDS INTO THE BUFFER!
				// Ignore any after the first, and iterate through the file.
				// Read the Event Log records we have not yet seen
				// NOTE 2: These events can be BIG - 78k in one case. (DrWatson dump)
				bRetVal = ReadEventLog( hEventLog[EventTriggered], EVENTLOG_BACKWARDS_READ|EVENTLOG_SEEK_READ, dwEvLogCounter, EventLogRecordBuffer,
						  MAX_EVENT,&dwBytesRead,&dwMinNumberOfBytesNeeded );
				
				if(!bRetVal) {
					// Problem encountered.
					g_dwLastError = GetLastError();
				}
				// I would like to filter out events that have been caused by Snare here,
				// but there seems to be no way to correalate the process ID reported in
				// the event with real process ID of Snare

				pELR=(PEVENTLOGRECORD)EventLogRecordBuffer;
				
				if(!pELR) {
					continue;
				}
				
				if(SNAREDEBUG >= 1 && bRetVal) {
					// ZAP out out last eventlog record to a file.
					// if(SNAREDEBUG >= 1) DebugMsg("Dumping Eventlog to file..");
					// DEBUGDumpEventLog(EventTriggered,dwBytesRead,pELR);

					DebugMsg("pELR Len: %d RecordNum: %d TimeGen: %ld TimeWr: %ld EventID: %d EventType: %d NumStrings: %d EventCat: %d StringOff: %d UserSidLen: %d UserSidOff: %d DataLen: %d DataOff: %d",
						pELR->Length,pELR->RecordNumber,pELR->TimeGenerated,pELR->TimeWritten,pELR->EventID,
						pELR->EventType,pELR->NumStrings,pELR->EventCategory,pELR->StringOffset,pELR->UserSidLength,pELR->UserSidOffset,pELR->DataLength,pELR->DataOffset);
				}
				
				if(!bRetVal) {
					if(g_dwLastError == ERROR_INSUFFICIENT_BUFFER) {
						if(SNAREDEBUG >= 1) { DebugMsg("Not enough buffer available for a event log record. Dropped event."); }
						if(SNAREDEBUG >= 1) { DebugMsg("loop info: dwEvLogStart: %d - dwEvLogCounter: %d - dwNewestEventLogRecord: %d",dwEvLogStart,dwEvLogCounter,dwNewestEventLogRecord); }
						if(SNAREDEBUG >= 1) { DebugMsg("Minimum number of bytes needed is aparently %ld. Bytes read is %ld",dwMinNumberOfBytesNeeded,dwBytesRead); }
						// Buffer is not large enough? An event greater than 8k? You're joking.
						// For the moment, drop this event.
						// We may wish to consider malloc'ing some extra RAM
						// to retrieve the event (Like we did in the old backlog)
						// but I don't think it's worthwhile, due to the risk of memory leaks.
						
						// NOTE: User report of a 78k!!! log message (drwatson dump)

						// Maybe we should print out some raw stats here.

						
						continue; // to the next event.
					}  else if(g_dwLastError == ERROR_EVENTLOG_FILE_CHANGED || g_dwLastError == ERROR_EVENTLOG_FILE_CORRUPT) {
						// Someone cleared the file, close and reread!
						if(SNAREDEBUG >= 1) { DebugMsg("%s has been cleared. Reopening eventlog file.",EventLogSourceName[EventTriggered]); }
						dwEventLogCleared[EventTriggered] = 1;
						for(int i=0;i<10;i++) {
							if(!CloseEventLog(hEventLog[EventTriggered])) {
								if(SNAREDEBUG >= 1) { DebugMsg("Closure of eventlog failed! Error is %d.",GetLastError()); }
								if(SNAREDEBUG >= 1 && i==9) { DebugMsg("Bailing out! Cannot seem to close this eventlog. Name is %s, hEventLog[EventTriggered] is %ld, EventTriggered is %d",EventLogSourceName[EventTriggered],hEventLog[EventTriggered],EventTriggered); }
								Sleep(1000);
							} else {
								if(SNAREDEBUG >= 1) { DebugMsg("Closure of eventlog succeeded"); }
								break;
							}
						}
						

						int count=0;
						do {
							hEventLog[EventTriggered] = OpenEventLog( NULL, EventLogSourceName[EventTriggered] );
							if(hEventLog[EventTriggered] != NULL) {
								break;
							}
							if(SNAREDEBUG >= 1) { DebugMsg("2: Could not re-open event log.. EventTriggered is %d, log name is %s - sleeping for 5 seconds (Error code was %d)",EventTriggered,EventLogSourceName[EventTriggered],GetLastError()); }
							Sleep(5000);
							count++;
							if(count > 20) {
								hEventLog[EventTriggered]=NULL;
								if(SNAREDEBUG >= 1) { DebugMsg("%s wont reopen after 20 attempts. Bailing out.",EventLogSourceName[EventTriggered]); }
								break;
							}
						} while(hEventLog[EventTriggered] == NULL);

						if(hEventLog[EventTriggered]==NULL) {
							continue;
						}

						while((nRet = NotifyChangeEventLog( hEventLog[EventTriggered], m_hEventList[EventTriggered] )) == NULL) {
							if(SNAREDEBUG >= 1) { DebugMsg("2: Could not re-bind to event log.. sleeping for 5 seconds"); }
							Sleep(5000);
						}
						
						// Grab these details just in case.
						// They should persist, but read them again anyway.
						GetOldestEventLogRecord(hEventLog[EventTriggered], &dwOldestEventLogRecord);
						dwEventIDOldest[EventTriggered]=dwOldestEventLogRecord;
						// The total number of eventlog records.
						GetNumberOfEventLogRecords(hEventLog[EventTriggered], &dwEventLogRecords);
						// The last eventlog record number
						dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;

						dwEventIDRead[EventTriggered]=dwOldestEventLogRecord;
						dwEvLogStart = dwOldestEventLogRecord;
						
						if(SNAREDEBUG >= 1) { DebugMsg("Eventlog has been cleared. Re-created pointers to log"); }
						
						// Jump out of the for/next loop, and try again.
						dwNewestEventLogRecord=dwOldestEventLogRecord;
						::SetEvent(m_hEventList[EventTriggered]);
						break;
						
					} else if(g_dwLastError == ERROR_INVALID_PARAMETER || g_dwLastError == ERROR_HANDLE_EOF || g_dwLastError == RPC_S_UNKNOWN_IF) {
						// This error generally means that the user has a small
						// audit buffer set to overwrite old audit events.
						// We have not been quick enough to catch the old event before
						// it is overwritten, so Continue on to the next one and try to
						// catch up again.
						
						// Add one to our catchup variable - this should help us if we get into an endless loop here.
						dwCatchUpCount++;
						
						if(dwCatchUpCount > 100) {
							// Hmm.. we have problems, we can't seem to catch up to the audit record
							// pointer. Lets try and sleep for a moment in the hope that the system
							// stabilises. Note: This will mean that we lose a few records (potentially)
							// but at least we won't grind the system to a halt..
							dwCatchUpCount=0;
							if(SNAREDEBUG >= 1) { DebugMsg("Acceleration problem: Small audit buffer means that I cannot catch up to the most recent audit event. Sleeping for a moment."); }
							
							Sleep(1000);
							
							GetOldestEventLogRecord(hEventLog[EventTriggered], &dwOldestEventLogRecord);
							dwEventIDOldest[EventTriggered]=dwOldestEventLogRecord;
							// The total number of eventlog records.
							GetNumberOfEventLogRecords(hEventLog[EventTriggered], &dwEventLogRecords);
							// The last eventlog record number
							dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
							dwEventIDRead[EventTriggered]=dwNewestEventLogRecord;
						}
						// We may want to continue here instead.
						break; // Break out of the for loop. Note that this will send us to the newest event.
					} else {
						// Unknown error. Windows is  doing something very strange.
						// We sometimes receive a 998 here (ERROR_NOACCESS). Not sure what the cause is.

						if(SNAREDEBUG >= 1) { DebugMsg("An unknown error occurred - g_dwLastError is %d. Continuing.",g_dwLastError); }
						// m_bIsRunning=0;
						
						// Sleep for a second, since we do NOT want to get into an endless loop
						// here, and eat CPU.
						Sleep(1000);
						
						// IF the event is a log-related one:
						// Close and reopen the offending log file, just in case.
						if(EventTriggered <= MAX_LOG_TYPE) {
							for(int i=0;i<10;i++) {
								if(!CloseEventLog(hEventLog[EventTriggered])) {
									if(SNAREDEBUG >= 1) { DebugMsg("Closure of eventlog failed! Error is %d.",GetLastError()); }
									if(SNAREDEBUG >= 1 && i==9) { DebugMsg("Bailing out! Cannot seem to close this eventlog. Name is %s, hEventLog[EventTriggered] is %ld, EventTriggered is %d",EventLogSourceName[EventTriggered],hEventLog[EventTriggered],EventTriggered); }
									Sleep(1000);
								} else {
									if(SNAREDEBUG >= 1) { DebugMsg("Closure of eventlog succeeded"); }
									break;
								}
							}

							int count=0;
							do {
								hEventLog[EventTriggered] = OpenEventLog( NULL, EventLogSourceName[EventTriggered] );
								if(hEventLog[EventTriggered] != NULL) {
									break;
								}
								if(SNAREDEBUG >= 1) { DebugMsg("3: Could not re-open event log.. EventTriggered is %d, log name is %s - sleeping for 5 seconds (Error code was %d)",EventTriggered,EventLogSourceName[EventTriggered],GetLastError()); }
								Sleep(5000);
								count++;
								if(count > 20) {
									hEventLog[EventTriggered]=NULL;
									if(SNAREDEBUG >= 1) { DebugMsg("%s wont reopen after 20 attempts. Bailing out.",EventLogSourceName[EventTriggered]); }
									break;
								}
							} while(hEventLog[EventTriggered] == NULL);

							if(hEventLog[EventTriggered]==NULL) {
								continue;
							}

							while((nRet = NotifyChangeEventLog( hEventLog[EventTriggered], m_hEventList[EventTriggered] )) == NULL) {
								if(SNAREDEBUG >= 1) { DebugMsg("3: Could not re-bind to event log.. sleeping for 5 seconds"); }
								Sleep(5000);
							}
						
							GetOldestEventLogRecord(hEventLog[EventTriggered], &dwOldestEventLogRecord);
							dwEventIDOldest[EventTriggered]=dwOldestEventLogRecord;
							// The total number of eventlog records.
							GetNumberOfEventLogRecords(hEventLog[EventTriggered], &dwEventLogRecords);
							// The last eventlog record number
							dwNewestEventLogRecord = (dwEventLogRecords + dwOldestEventLogRecord) -1;
							dwEventIDRead[EventTriggered]=dwNewestEventLogRecord;
						}
						break; // Break out of the for loop.
					}
				}
				
				// We received a good event. Clear our catch-up variable.
				dwCatchUpCount=0;

				if(bRetVal)
				{
					if(EventTriggered==1) { // SYSTEM
						// For some wierd reason, MS mangles the system eventIDs!
						if(pELR->EventID > 1073741824) {
							EventID = pELR->EventID & 65535;
						} else {
							EventID = pELR->EventID;
						}
					} else {
						EventID = pELR->EventID;
					}
					
					if(dwObjectiveCount) {
						// I was considering doing a quick eventid match here,
						// to see whether we should continue or not, but there's no real point
						// if users are going to have at least ONE '*' match for eventid..
						
						switch(pELR->EventType)	{
						case EVENTLOG_SUCCESS:
							etype=TYPE_INFO;
							break;
						case EVENTLOG_ERROR_TYPE:
							etype=TYPE_ERROR;
							break;
						case EVENTLOG_WARNING_TYPE:
							etype=TYPE_WARN;
							break;
						case EVENTLOG_INFORMATION_TYPE:
							etype=TYPE_INFO;
							break;
						case EVENTLOG_AUDIT_SUCCESS:
							etype=TYPE_SUCCESS;
							break;
						case EVENTLOG_AUDIT_FAILURE:
							etype=TYPE_FAILURE;
							break;
						default:
							if(SNAREDEBUG >= 1) { DebugMsg("pELR->EventType looks to be corrupted. Set to TYPE_INFO"); }
							etype=TYPE_INFO;
							break;
						}
						
						if(SNAREDEBUG >= 7) { DebugMsg("FastCheckObjective: Starting checks"); }
						
						MatchCount=0;
						MatchPointer=MatchList; // Start of the list
						if(!MatchPointer) {
							// Something seriously wierd is happening if MatchPointer is null.
							if(SNAREDEBUG >= 7) DebugMsg("Match Pointer has gone away");
							continue;
						}

						
						do {
							try {
								*MatchPointer=FastCheckObjective(EventID,etype,stype);
							} catch(...) {
								if(SNAREDEBUG >= 7) DebugMsg("FastCheckObjective: Error encountered!");
								if(SNAREDEBUG >= 7) DebugMsg("MatchPointer is %ld, EventID is %d, etype is %d, stype is %d",*MatchPointer,EventID,etype,stype);
								*MatchPointer=NULL;
							}
							
							if(*MatchPointer) {
								MatchFound=1;
								MatchCount++;
								MatchPointer++;
							} else {
								MatchFound=0;
							}
						} while(MatchFound && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows

						if(g_Info.bTerminate) {
							m_bIsRunning=0;
							break;
						}
						
						// No matches? Not much point in expanding strings and so on.
						// Jump out now.
						if(!MatchCount) {
							if(SNAREDEBUG >= 7) { DebugMsg("Match Checker: No matches found"); }
							continue;
						}
						if(SNAREDEBUG >= 7) { DebugMsg("FastCheckObjective: found matches (%d)",MatchCount); }
					}
					
					// OK, we have at least one probable match. Expand our strings
					// so that we can continue looking.
					
					
					// No error. Proceed.
					Offset = sizeof(EVENTLOGRECORD);
					// Grab the source name, the start of which is eventlogrecordbuffer + _countof(eventlogrecord)
					strncpy_s(SourceName, _countof(SourceName), (LPTSTR)((LPBYTE)pELR + Offset), _TRUNCATE);
					// Just in case
					SourceName[_countof(SourceName)-1]='\0';

					if(SNAREDEBUG >= 9) { DebugMsg("SourceName is %s",SourceName); }
					
					// Jump to the next element of the eventlog record
					Offset += (DWORD)strlen(SourceName) +1; // length + \0 character
					// Note that there is a chance that the sourcename is longer than 1024.
					// If this is the case, then this event is probably corrupted.
					
					strncpy_s(ComputerName,_countof(ComputerName), (LPTSTR)((LPBYTE)pELR + Offset), _TRUNCATE);
					
					if(SNAREDEBUG >= 9) { if(ComputerName) { DebugMsg("Received event from computer %s",ComputerName); } }
					
					if(pELR->UserSidLength > 0 && pELR->UserSidLength < 8192)	{
						if(SNAREDEBUG >= 9) { DebugMsg("UserSidLength is > 0 and less than 8k.."); }
						SID_NAME_USE SidNameUse=SidTypeUser;
						if(SNAREDEBUG >= 9) { DebugMsg("Getting event user name"); }
						bRetVal=GetEventUserName(pELR,UserName,_countof(UserName),&SidNameUse);
						if(SNAREDEBUG >= 9) { DebugMsg("User name grabbed. Getting Sid type"); }

						if(bRetVal && SidNameUse) {
							GetSIDType(SidNameUse,SIDType,_countof(SIDType));
						} else {
							SIDType[0]='\0';
						}
						
						if(SNAREDEBUG >= 9) { DebugMsg("Grabbed Sidtype"); }
					} else {
						if(SNAREDEBUG >= 9) { DebugMsg("UserSidLength problem. Event is corrupt - size is %ld !!!!!!!!!!!!!!!!!!!!!!!!!! Consider dumping this event.",pELR->UserSidLength); }
						UserName[0]='\0';
						// Consider dumping this event!
						// continue;
					}
					
					if(SNAREDEBUG >= 9) { DebugMsg("Getting Event Log Type"); }
					
					// Some of the MS System calls used in GetEventLogType are prone to error.
					try {
						GetEventLogType(EventLogType, pELR->EventType, _countof(EventLogType));
					} catch(...) {
						if(SNAREDEBUG >= 9) DebugMsg("GetEventLogType error caught. EventType is %ld. Continuing.",pELR->EventType);
						strncpy_s(EventLogType,_countof(EventLogType),"Success Audit",_TRUNCATE);
						//continue;
					}
					
					if(SNAREDEBUG >= 9) { DebugMsg("Ok, checking times"); }
					if(pELR->TimeGenerated && pELR->TimeWritten) {
						struct tm ptmTime;
						time_t ttime;
						errno_t err;
						
						ttime=(time_t)pELR->TimeGenerated;
						err=localtime_s(&ptmTime,&ttime);
						if(!err) {
							strftime(SubmitTime, _countof(SubmitTime),"%a %b %d %H:%M:%S %Y", &ptmTime);
						} else {
							// Could not pull back date/time from the event. Use current time.
							ttime=time(NULL);
							localtime_s(&ptmTime,&ttime);
							strftime(SubmitTime, _countof(SubmitTime),"%a %b %d %H:%M:%S %Y", &ptmTime);
						}
						ttime=(time_t)pELR->TimeWritten;
						err=localtime_s(&ptmTime,&ttime);
						if(!err) {
							strftime(WriteTime, _countof(WriteTime),"%a %b %d %H:%M:%S %Y", &ptmTime);
						} else {
							ttime=time(NULL);
							localtime_s(&ptmTime,&ttime);
							strftime(WriteTime, _countof(WriteTime),"%a %b %d %H:%M:%S %Y", &ptmTime);
						}
						
						//lstrcpyn(SubmitTime, asctime(localtime((time_t *)&(pELR->TimeGenerated))), _countof(SubmitTime));
						// lstrcpyn(WriteTime, asctime(localtime((time_t *)&(pELR->TimeWritten))), _countof(WriteTime));
						// May need to chomp off the last character - asctime return a newline!
						// SubmitTime[strlen(SubmitTime)-1]='\0';
						// WriteTime[strlen(WriteTime)-1]='\0';
					} else {
						SubmitTime[0]='\0';
						WriteTime[0]='\0';
					}
					
					if(SNAREDEBUG >= 9) { if(SubmitTime) { DebugMsg("Date and Time grabbed: %s.",SubmitTime); } }
					
					try {
						ExpandStrings(pELR,EventLogSourceName[EventTriggered],ExpandedString,_countof(ExpandedString));
					} catch (...) {
						int size;
						size=pELR->DataOffset - pELR->StringOffset;
						if(size >= _countof(ExpandedString)) {
							size=_countof(ExpandedString)-1;
						}
						
						if(SNAREDEBUG >= 9) { DebugMsg("CRASH: ExpandStrings Failure Caught"); }
						
						strncpy_s(ExpandedString,_countof(ExpandedString),"N/A",_TRUNCATE);
						memcpy(ExpandedString, (LPBYTE)pELR + pELR->StringOffset, size);
						ExpandedString[size]='\0';
					}
					
					if(SNAREDEBUG >= 9) { DebugMsg("Strings Expanded"); }
					
					try {
						GetDataString(pELR,DataString,_countof(DataString));
					} catch (...) {
						if(SNAREDEBUG >= 9) { DebugMsg("CRASH: GetDataString Failure Caught"); }
						strncpy_s(DataString,_countof(DataString),"N/A",_TRUNCATE);
					}
					
					if(SNAREDEBUG >= 9) { DebugMsg("DataStrings Grabbed"); }
					
					Category = pELR->EventCategory;
					
					// Some of the MS system calls use by GetCategoryString are buggy.
					try {
						GetCategoryString(pELR,EventLogSourceName[EventTriggered],szCategoryString,_countof(szCategoryString));
					} catch (...) {
						if(SNAREDEBUG >= 9) { DebugMsg("CRASH: GetCategoryString Failure Caught"); }
						strncpy_s(szCategoryString,_countof(szCategoryString),"N/A",_TRUNCATE);
					}
					
					if(SNAREDEBUG >= 9) { if(szCategoryString) { DebugMsg("Category String grabbed: %s.",szCategoryString); } }
					
					// Send out to network
					// First set the separator in the strings area to use tabs instead.
					static char szSendString[MAX_OUTPUT_STRING]=""; // Nice big memory buffer - just in case.
					static char szTempString[MAX_EVENT]=""; // Approximately the maximum we could reasonably expect to transfer over UDP

					UINT counter=0;
					
					// Chop down the ExpandedString into nice easy bits.
					if(strlen(ExpandedString))
					{
						UINT stringsize=0;
						BOOL bDelim=0;
						BOOL bNewLine=0;
						
						if(SNAREDEBUG >= 9) { DebugMsg("Expanding Strings..."); }
						
						if(strlen(ExpandedString) >= MAX_EVENT) {
							stringsize=MAX_EVENT;
						} else {
							stringsize=(UINT)strlen(ExpandedString);
						}
						
						// Within the "Extra strings" section of a windows log,
						// get rid of newlines (cr / lf), and change any multiple-tabs to a single tab.
						strncpy_s(szTempString,_countof(szTempString),"",_TRUNCATE);
						
						while(counter < stringsize) {
							// Replace any delimiter characters (usually tab)
							// with spaces.
							// Also, if the ClearTabs registry key is set, kill off the tabs.
							if(ExpandedString[counter]==DELIM[0] || (ExpandedString[counter]==9 && ClearTabs==1))
							{
								bNewLine=0;
								if(!bDelim) {
									if((strlen(szTempString) + 1) < MAX_EVENT) {
										strncat_s(szTempString,_countof(szTempString)," ",_TRUNCATE);
									}
									bDelim=1;
								}
							}
							else if(ExpandedString[counter]==10 || ExpandedString[counter]==13)
							{
								// CR/LF - substitute a space instead.
								if((strlen(szTempString) + 1) < MAX_EVENT) {
									strncat_s(szTempString,_countof(szTempString)," ",_TRUNCATE);
								}
								
								bDelim=0;
								bNewLine=1;
							} else if(ExpandedString[counter]==' ' && bNewLine==1) {
								// Lots of spaces after newlines. Trim them down.
								1;
							} else {
								char szTempString2[2]="";
								
								bNewLine=0;
								bDelim=0;
								szTempString2[0]=(char)ExpandedString[counter];
								szTempString2[1]='\0';
								if((strlen(szTempString) + strlen(szTempString2)) < MAX_EVENT) {
									strncat_s(szTempString,_countof(szTempString),szTempString2,_TRUNCATE);
								}
							}
							counter++;
						}
					} else {
						// Could not expand the strings.
						strncpy_s(szTempString,_countof(szTempString),"",_TRUNCATE);
					}
					
					char CurrentDate[16]="";
					// Check that we have all the data that we need.
					// Note: DataString may not exist, but everything else should.
					// Removed this bit: && strlen(UserName) && strlen(SIDType)
					
					// Sanitise some of the data if it's not available.
					if(!strlen(EventLogSourceName[EventTriggered]))
						strncpy_s(EventLogSourceName[EventTriggered],_countof(EventLogSourceName[EventTriggered]),"Unknown",_TRUNCATE);
					if(!strlen(SubmitTime))
						strncpy_s(SubmitTime,_countof(SubmitTime),"Unknown",_TRUNCATE);
					if(!strlen(SourceName))
						strncpy_s(SourceName,_countof(SourceName),"Unknown",_TRUNCATE);
					if(!strlen(EventLogType))
						strncpy_s(EventLogType,_countof(EventLogType),"Unknown",_TRUNCATE);
					if(!strlen(ComputerName))
						strncpy_s(ComputerName,_countof(ComputerName),"Unknown",_TRUNCATE);
					if(!strlen(szTempString))
						strncpy_s(szTempString,_countof(szTempString),"Unknown",_TRUNCATE);
					if(!strlen(szCategoryString))
						strncpy_s(szCategoryString,_countof(szCategoryString),"Unknown",_TRUNCATE);
				
					if(strlen(EventLogSourceName[EventTriggered]) && strlen(SubmitTime) && strlen(SourceName) && strlen(EventLogType) && strlen(ComputerName) && DataString && strlen(szTempString) && strlen(szCategoryString))
					{
						if (SNAREDEBUG >= 6) DebugMsg("Event is ready, checking objectives");
						char *stringp;
						if(!strlen(UserName)) {
							strncpy_s(UserName,_countof(UserName),"Unknown User",_TRUNCATE);
							strncpy_s(SIDType,_countof(SIDType),"N/A",_TRUNCATE);
						}
						
						// This is the point at which we integrate our regular expression handling
						// and event filtering facilities.
						// NOTE:
						// Was going to implement a regular expression matching capability,
						// - but based on the limitations of the NT Audit subsystem, it's probably
						//   better that we use dos wildcards instead.
						//
						
						DWORD ShortEventID=0;
						// Cut off the severity, flags, and  facility data
						// Just leave the real event ID.
						ShortEventID = EventID & 65535;
						if (SNAREDEBUG >= 6) DebugMsg("ShortEventID: %d", ShortEventID);
						char header[256];
						
						BOOL nodematch=0;
						int criticality=0;
						int tcriticality=0;
						
						if (SNAREDEBUG >= 6) DebugMsg("dwObjectiveCount: %d", dwObjectiveCount);
						// Check objectives
						// NOTE: If there are no objectives, send all?
						if(!dwObjectiveCount) {
							nodematch=1;
						} else {
							MatchCount=0;
							MatchPointer=MatchList; // Start of the list
							
							do {
								if (SNAREDEBUG >= 6) DebugMsg("begin MatchCount: %d", MatchCount);
								// Some of the MS System calls used in CheckObjective are buggy.
								try {
									tcriticality=CheckObjective(*MatchPointer,ShortEventID,UserName,szTempString);
								} catch(...) {
									if(SNAREDEBUG >= 7) DebugMsg("CheckObjective CRASH");
									tcriticality=0;
								}
								if(tcriticality >= 0) {
									nodematch=1;
									if(SNAREDEBUG >= 7) { DebugMsg("Checkobjective: node found"); }
									if(criticality < tcriticality) {
										criticality = tcriticality;
									}
									if(!dwCritAudit) {
										// break here if we just want the FIRST match.
										break;
									}
								}
								MatchPointer++;
								MatchCount++;

								if (SNAREDEBUG >= 6) DebugMsg("end MatchCount: %d", MatchCount);
							} while(*MatchPointer && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows
							
							if(g_Info.bTerminate) {
								m_bIsRunning=0;
								break;
							}
							if (SNAREDEBUG >= 6) {
								if (!*MatchPointer) DebugMsg("Check Objective finished: MatchPointer has gone away");
								if (MatchCount >= dwObjectiveCount) DebugMsg("Check Objective finished: no objectives left to check");
							}
						}
						// END
						if (SNAREDEBUG >= 6) DebugMsg("nodematch: %d", (nodematch?1:0));
						if(nodematch) {
							
							if(dwSyslogHeader || OutputFile) {
								time(&currenttime);
								localtime_s(&newtime,&currenttime);
							}
							
							if(OutputFile) {
								// Check to see whether we need to rotate our log file.
								if(newtime.tm_year != savedtime.tm_year ||
									newtime.tm_mon != savedtime.tm_mon ||
									newtime.tm_mday != savedtime.tm_mday) {
									
									fclose(OutputFile);
									OutputFile=GetOutputFile();
									
									savedtime.tm_year=newtime.tm_year;
									savedtime.tm_mon=newtime.tm_mon;
									savedtime.tm_mday=newtime.tm_mday;
								}
							}
							
							if(dwSyslogHeader) {
								DWORD tdwSyslog;
								
								syslogdate(CurrentDate,&newtime);
								
								
								// HERE: Split out criticality.
								if(dwSyslogDynamic) {
									tdwSyslog=((7-criticality) & 7) | ((dwSyslog >> 3) << 3);
								} else {
									tdwSyslog=dwSyslog;
								}
								
								_snprintf_s(header,_countof(header),_TRUNCATE,"<%ld>%s %s MSWinEventLog%s%d%s",tdwSyslog,CurrentDate,Hostname,DELIM,criticality,DELIM);
							} else {
								_snprintf_s(header,_countof(header),_TRUNCATE,"%s%sMSWinEventLog%s%d%s",Hostname,DELIM,DELIM,criticality,DELIM);
							}
							
							_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s%d%s%s%s%ld%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%d\0",header,EventLogSourceName[EventTriggered],DELIM,SnareCounter,DELIM,SubmitTime,DELIM,ShortEventID,DELIM,SourceName,DELIM,UserName,DELIM,SIDType,DELIM,EventLogType,DELIM,ComputerName,DELIM,szCategoryString,DELIM,DataString,DELIM,szTempString,DELIM,EventLogCounter[EventTriggered]);
							if(SNAREDEBUG >= 3 && DataString) { DebugMsg("DataString: %s",DataString); }
							if(SNAREDEBUG >= 3 && szTempString) { DebugMsg("szTempString: %s",szTempString); }

							// Jump through szSendString, and remove any newline characters.
							stringp=szSendString;
							while(*stringp) {
								// CR or LF
								if(*stringp==10 || *stringp==13) {
									*stringp=' ';
								}
								stringp++;
							}
							
							// Add in an MD5 if appropriate
							if(ActivateChecksum) {
								char CryptString[64];
								strncpy_s(CryptString,_countof(CryptString),MD5String(szSendString),_TRUNCATE);
								_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s",szSendString,DELIM,CryptString);
							}
							
							
							// Ok, now add a newline.
							if (strlen(szSendString) >= _countof(szSendString)) {
								szSendString[strlen(szSendString)-1]='\n';
							} else {
								strncat_s(szSendString,_countof(szSendString),"\n",_TRUNCATE);
							}
									
							if(SNAREDEBUG >= 3 && strlen(szSendString)) { DebugMsg("DEBUG: Sending the following string to the server: %s",szSendString); }
							
							BOOL DataSent=0;

							hostcurrentnode=hosthead;
							while(hostcurrentnode) {
								//if (SNAREDEBUG >= 2) DebugMsg("sending data to %s", hostcurrentnode->HostName);
								if(hostcurrentnode->Socket == INVALID_SOCKET) {
									// Try to reestablish here.
									// Since socket connects use a fair bit of system resources, try and do it nicely.
									if(SNAREDEBUG >= 9) { DebugMsg("Socket is toast for %s. Trying to reestablish.",hostcurrentnode->HostName); }
									
									hostcurrentnode->Socket = ConnectToServer( hostcurrentnode, (UINT)dwDestPort, szError, _countof(szError), SocketType );
									
									if(hostcurrentnode->Socket == INVALID_SOCKET) {
										// Hmm. Try again later.
										// Jump to the next socket
										hostcurrentnode=hostcurrentnode->next;
										if (SNAREDEBUG >=9) DebugMsg("Failed to reconnect socket");
										continue;
									}
								}

								if( !SendToSocket(hostcurrentnode, szSendString, (int)strlen(szSendString), szError, _countof(szError)) )
								{
									if(SNAREDEBUG >= 9) { if(szError) { DebugMsg(szError); } }
									if(SNAREDEBUG >= 9) { DebugMsg("Socket for %s is toast. Breaking out - will reestablish next time.",hostcurrentnode->HostName); }
									// Close the socket. Restablish it on the next cycle, if we can.
									closesocket(hostcurrentnode->Socket);
									hostcurrentnode->Socket=INVALID_SOCKET;
								} else {
									DataSent=1;
								}

								hostcurrentnode=hostcurrentnode->next;
							}


							// Did we push out at least one record?
							if(!DataSent) {
								dwEvLogCounter--;
								dwNewestEventLogRecord=dwEvLogCounter;
								if (SNAREDEBUG >= 1) DebugMsg("Failed to send message, holding position in event log");
								// Break out of the for/next loop.
								break;
							} else {
								MCCurrent = (MsgCache *)malloc(sizeof(MsgCache));
								if (MCCurrent) {
									strncpy_s(MCCurrent->Hostname,_countof(Hostname),Hostname,_TRUNCATE);
									MCCurrent->criticality = criticality;
									MCCurrent->SnareCounter = SnareCounter;
									strncpy_s(MCCurrent->SubmitTime, 26, SubmitTime,_TRUNCATE);
									MCCurrent->ShortEventID = ShortEventID;
									strncpy_s(MCCurrent->SourceName, 100, SourceName,_TRUNCATE);
									strncpy_s(MCCurrent->UserName, 256, UserName,_TRUNCATE);
									strncpy_s(MCCurrent->SIDType, 100, SIDType,_TRUNCATE);
									strncpy_s(MCCurrent->EventLogType, 60, EventLogType,_TRUNCATE);
									strncpy_s(MCCurrent->szCategoryString, 256, szCategoryString,_TRUNCATE);
									strncpy_s(MCCurrent->szTempString, MAX_EVENT, szTempString,_TRUNCATE);
									MCCurrent->EventLogCounter = EventLogCounter[EventTriggered];
									MCCurrent->seenflag=0;
									MCCurrent->next = NULL;
									MCCurrent->prev = NULL;
									dwWaitRes = WaitForSingleObject(hMutex,500);
									if(dwWaitRes == WAIT_OBJECT_0) {
										if (MCCount >= WEB_CACHE_SIZE) {
											//Lock Mutex and drop the oldest record
											MsgCache *temp;
											temp = MCTail;
											MCTail = MCTail->prev;
											MCTail->next = NULL;
											free(temp);
											MCCount--;
										}
									} else {
										if(SNAREDEBUG >= 9) DebugMsg("EVENT CACHE FAILED!\n");
									}
									ReleaseMutex(hMutex);
									if (MCHead) {
										MCHead->prev = MCCurrent;
										MCCurrent->next = MCHead;
									}
									MCHead = MCCurrent;
									if (!MCTail) MCTail = MCCurrent;
									MCCount++;
								} else {
									if(SNAREDEBUG >= 9) DebugMsg("Unable to allocate latest event cache\n");
								}
								// Increment the Snare internal event counter
								// Note: Maxdword is 4294967295
								// Dont overflow our array either.
								if(EventTriggered <= 5) {
									EventLogCounter[EventTriggered]++;
									if(EventLogCounter[EventTriggered] >= MAXDWORD) {
										EventLogCounter[EventTriggered]=1;
									}
								}
								SnareCounter++;
								if(SnareCounter >= MAXDWORD) {
									SnareCounter=1;
								}
							}
							
							// Write the data out to a disk, if requested.
							if(OutputFile) {
								fputs(szSendString,OutputFile);
								fflush(OutputFile);
							}
						}
							
#ifdef MEMDEBUG
						_CrtDumpMemoryLeaks();
#endif
							
					} else {
							if(SNAREDEBUG >= 9) {
								DebugMsg("DEBUG: I received an event that I could not process! Details are as follows:");
								DebugMsg("dwSyslog: ");
								if(dwSyslog) { DebugMsg("%d\n",dwSyslog);} else { DebugMsg("NO DATA\n");}
								DebugMsg("CurrentDate: ");
								if(CurrentDate) { DebugMsg("%s\n",CurrentDate);} else { DebugMsg("NO DATA\n");}
								DebugMsg("Hostname: ");
								if(Hostname) {DebugMsg("%s\n",Hostname);} else { DebugMsg("NO DATA\n");}
								DebugMsg("EventTriggered: ");
								if(EventTriggered) { DebugMsg("%d\n",EventTriggered);} else { DebugMsg("NO DATA\n");}
								DebugMsg("EventLogSourceName[EventTriggered]: ");
								if(EventLogSourceName[EventTriggered]) {DebugMsg("%s\n",EventLogSourceName[EventTriggered]);} else {DebugMsg("NO DATA\n");}
								DebugMsg("dwEvLogCounter: ");
								if(dwEvLogCounter) { DebugMsg("%d\n",dwEvLogCounter);} else { DebugMsg("NO DATA\n");}
								DebugMsg("SubmitTime: ");
								if(SubmitTime) { DebugMsg("%s\n",SubmitTime);} else { DebugMsg("NO DATA\n");}
								DebugMsg("EventID: ");
								if(EventID) { DebugMsg("%d\n",EventID);} else { DebugMsg("NO DATA\n");}
								DebugMsg("SourceName: ");
								if(SourceName) { DebugMsg("%s\n",SourceName);} else { DebugMsg("NO DATA\n");}
								DebugMsg("UserName: ");
								if(UserName) { DebugMsg("%s\n",UserName);} else { DebugMsg("NO DATA\n");}
								DebugMsg("SIDType: ");
								if(SIDType) { DebugMsg("%s\n",SIDType);} else { DebugMsg("NO DATA\n");}
								DebugMsg("EventLogType: ");
								if(EventLogType) { DebugMsg("%s\n",EventLogType);} else { DebugMsg("NO DATA\n");}
								DebugMsg("ComputerName: ");
								if(ComputerName) { DebugMsg("%s\n",ComputerName);} else { DebugMsg("NO DATA\n");}
								DebugMsg("DataString: ");
								if(DataString) { DebugMsg("%s\n",DataString);} else { DebugMsg("NO DATA\n");}
								DebugMsg("szTempString: ");
								if(szTempString) { DebugMsg("%s\n",szTempString);} else { DebugMsg("NO DATA\n");}
							}
						}
				}
				//firstly, check to see if the web server needs resetting:
				if (WebResetFlag) {
					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: resetting the web thread"); }
									//While we are here, may as well record the value
					switch(EventTriggered) {
						case 0: MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEvLogCounter); break;
						case 1: MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEvLogCounter); break;
						case 2: MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEvLogCounter); break;
						case 3: MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEvLogCounter); break;
						case 4: MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEvLogCounter); break;
						case 5: MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEvLogCounter); break;
					}
					if (WebResetFlag == FULL_WEB_RESET) {
						DestroyList();

						if(WEBSERVER_ACTIVE) {
							CloseWebServer();
						}

						// cancel blocking calls, if any
						WSACancelBlockingCall();

						// Close all active sockets.
						HostNode * temphostnode;

						hostcurrentnode=hosthead;
						while(hostcurrentnode) {
							if(hostcurrentnode->Socket != INVALID_SOCKET) {
								closesocket(hostcurrentnode->Socket);
								hostcurrentnode->Socket=INVALID_SOCKET;
							}
							temphostnode=hostcurrentnode->next;

							// Free the RAM associated with this node. We don't need it any more.
							free(hostcurrentnode);
							hostcurrentnode=temphostnode;
							// Just in case
							hosthead=hostcurrentnode;
						}
						hosthead=NULL;


						// READ in our data
						GetHostname(Hostname,_countof(Hostname));
						GetDestPort(&dwDestPort);
						GetSocketType(&SocketType);
						GetSyslog(&dwSyslog);
						GetSyslogDynamic(&dwSyslogDynamic);
						GetSyslogHeader(&dwSyslogHeader);
						GetWEBSERVER_ACTIVE(&WEBSERVER_ACTIVE);
						GetPortNumber(&dwPortNumber);
						GetChecksum(&ActivateChecksum);
						GetDestination(lpszDestination,_countof(lpszDestination));
						if(dwSyslogHeader) {
							GetDelim(DELIM,_countof(DELIM));
						}
						GetPassword(lpszPassword,_countof(lpszPassword));
						GetIPAddress(lpszIPAddress,_countof(lpszIPAddress));
						GetClearTabs(&ClearTabs);

						if(OutputFile) {
							fclose(OutputFile);
						}
						OutputFile=GetOutputFile();

						//if (!dwObjectiveCount) MatchList = NULL;
						if(MatchList) {
							free(MatchList);
							MatchList=NULL;
						}
						// Load the objective data here.
						dwObjectiveCount=ReadObjectives();
						if(dwObjectiveCount) {
							// Malloc a array for our FastCheckObjective process
							MatchList = (Node **)malloc(dwObjectiveCount * sizeof(Node *));
							if(!MatchList) {
								if(SNAREDEBUG >= 9) DebugMsg("Cannot allocate memory for our internal Objective match list");
								dwObjectiveCount=0;
							}
						}
						ResetCurrentNode();

						// Open our outgoing sockets.
						hosthead=OpenSockets(lpszDestination,dwDestPort,SocketType);

						// Ok, we have finished our general configuration reads.

						if(WEBSERVER_ACTIVE) {
							if(SNAREDEBUG >= 5) { DebugMsg("Starting web thread."); }
							if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
								StartWebThread(m_hEventList[6]);
							} else {
								if(SNAREDEBUG >= 5) { DebugMsg("Unable to start web server [4], disabling."); }
								WEBSERVER_ACTIVE = 0;
							}
						}
						break;
					} else if (WebResetFlag == BASIC_WEB_RESET) {
						if(WEBSERVER_ACTIVE) {
							if(SNAREDEBUG >= 5) { DebugMsg("Restarting web thread."); }
							CloseWebServer();
							if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
								StartWebThread(m_hEventList[6]);
							} else {
								if(SNAREDEBUG >= 5) { DebugMsg("Unable to start web server [5], disabling."); }
								WEBSERVER_ACTIVE = 0;
							}
						}
						hostcurrentnode=hosthead;
						while(hostcurrentnode) {
							//if(hostcurrentnode->Socket != INVALID_SOCKET) {
							if(hostcurrentnode->Socket != INVALID_SOCKET) {
								closesocket(hostcurrentnode->Socket);
								hostcurrentnode->Socket=INVALID_SOCKET;
							}
							hostcurrentnode=hostcurrentnode->next;
						}
					}
					//dwWaitReset = WaitForSingleObject(hMutex,500);
					//if(dwWaitReset == WAIT_OBJECT_0) {
					WebResetFlag=0;
					//}
					//ReleaseMutex(hMutex);
					break;
				}
				
			} // End for loop
			dwEventIDRead[EventTriggered]=dwNewestEventLogRecord;
		}
    }

	if(SNAREDEBUG >= 1) { DebugMsg("SNARE Closing"); }

	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);

	if(MatchList) {
		free(MatchList);
	}

	CloseWebServer();

	if(OutputFile) {
		fclose(OutputFile);
	}
	
	if(hEventLog[0]) CloseEventLog(hEventLog[0]);
	if(hEventLog[1]) CloseEventLog(hEventLog[1]);
	if(hEventLog[2]) CloseEventLog(hEventLog[2]);
	if(hEventLog[3]) CloseEventLog(hEventLog[3]);
	if(hEventLog[4]) CloseEventLog(hEventLog[4]);
	if(hEventLog[5]) CloseEventLog(hEventLog[5]);


	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);

	HostNode * temphostnode;
	// Free our host linked list.
	hostcurrentnode=hosthead;
	while(hostcurrentnode) {
		if(hostcurrentnode->Socket != INVALID_SOCKET) {
			TerminateWinsock(hostcurrentnode->Socket);
		}
		temphostnode=hostcurrentnode;
		hostcurrentnode=hostcurrentnode->next;
		free(temphostnode);
	}
	hosthead = NULL;

	if( m_hEventList[0] ) ::CloseHandle(m_hEventList[0]);
	if( m_hEventList[1] ) ::CloseHandle(m_hEventList[1]);
	if( m_hEventList[2] ) ::CloseHandle(m_hEventList[2]);
	if( m_hEventList[3] ) ::CloseHandle(m_hEventList[3]);
	if( m_hEventList[4] ) ::CloseHandle(m_hEventList[4]);
	if( m_hEventList[5] ) ::CloseHandle(m_hEventList[5]);
	if( m_hEventList[6] ) ::CloseHandle(m_hEventList[6]);

	// Free memory used by the objectives lists
	DestroyList();
}

void GetFQDN(char *string, const int length)
{
	struct hostent *phostent;
	
	if(!string) return;

	// Now, grab fully qualified hostname here.
	// Get the normal name.
	if(gethostname(string, length)) {		
		strncpy_s(string,length,"localhost.unknown",_TRUNCATE);
		return;
	}
	
	
	// Now perform a lookup on that name.
	phostent=gethostbyname(string);
	if(phostent) {
		while(phostent->h_aliases && *phostent->h_aliases) {
			if(strlen(*(phostent->h_aliases)) > strlen(string) && !strncmp(string,*(phostent->h_aliases),strlen(string))) {
				strncpy_s(string,length,*(phostent->h_aliases),_TRUNCATE);
			}
			phostent->h_aliases++;
		}
		if(strlen(phostent->h_name) > strlen(string) && !strncmp(string,phostent->h_name,strlen(string))) {
			strncpy_s(string,length,phostent->h_name,_TRUNCATE);
		}
	}
}

BOOL GetEventUserName(EVENTLOGRECORD *pELR, char * lpszUser, int length, SID_NAME_USE *snu)
{
    PSID lpSid;
    char szName[257]="";
    char szDomain[257]="";
    DWORD dwRC;
    DWORD cbName = 256;
    DWORD cbDomain = 256;

	if(!lpszUser || length<=0 || !pELR) {
		if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: Input Variables incorrect. Length, lpszUser or pELR are null "); }
		return(FALSE);
	}

	strncpy_s(lpszUser,length,"",_TRUNCATE);

	if(!pELR->UserSidOffset) {
		if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: UserSidOffset is Null"); }
		return(FALSE);
	}

	if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: pUserSID length is %d",pELR->UserSidLength); }

	if(pELR->UserSidLength <= 0) {
		if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: UserSidLength is Null"); }
		return(FALSE);
	} else if(pELR->UserSidLength > 8192) {
		// Sanity check. An 8k sid? You've got to be kidding me.
		if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: UserSidLength is > 8k. This event looks corrupt to me."); }
		return(FALSE);
	}

    // Point to the SID.
    lpSid = (PSID)((LPBYTE) pELR + pELR->UserSidOffset);

	try {
		if(IsValidSid(lpSid)) {
			dwRC=LookupAccountSid(NULL, lpSid, szName, &cbName, szDomain, &cbDomain, snu);
			if(szName) {
				strncpy_s(lpszUser,length,szName,_TRUNCATE);
			}
		} else {
			if(SNAREDEBUG >= 9) { DebugMsg("GetEventUserName: IsValidSid returned FALSE! Not much I can do with an invalid SID.\n"); }
		}
	} catch (...) {
		if(SNAREDEBUG >= 9) { DebugMsg("LookupAccountSid Failed in GetEventUserName"); }

		GetTextualSid(lpSid,lpszUser,(LPDWORD)&length);
		
		if(SNAREDEBUG  >= 9) {
			DebugMsg("GetEventUserName: Dumping details of the event....");
			DebugMsg("    UserSidLength is %d, offset is %d",pELR->UserSidLength,pELR->UserSidOffset);
			DebugMsg("    DataLength is %d, DataOffset is %d",pELR->DataLength,pELR->DataOffset);
			DebugMsg("    Length is %d, string count is %d",pELR->Length,pELR->NumStrings);
			DebugMsg("    StringOffset is %d",pELR->StringOffset);
			DebugMsg("    SID: %s",lpszUser);
		}
		dwRC=0;
	}

    if (dwRC) {
		strncpy_s(lpszUser,length,szName,_TRUNCATE);
	} else {
		return(FALSE);
	}

	return TRUE;
}

BOOL GetCategoryString(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length)
{
	TCHAR szKeyName[MAX_STRING]="";
	HKEY   hk = (HKEY)0;
	long Category;

	DWORD dwMaxPath;			
	DWORD dwType; // Temporary variable.
	TCHAR szExeFile[_MAX_PATH + 1]="", szExeFilePath[_MAX_PATH+1]="";
	HMODULE hModule = 0;
	TCHAR TStringBuffer[_MAX_PATH + 1];

	if(!Trigger || !StringBuffer || !pELR || !length) return(0);

	strncpy_s(StringBuffer,length,"None",_TRUNCATE);
	StringBuffer[length-1]='\0';
	
	Category=pELR->EventCategory;

	if(!Category) {
		if(SNAREDEBUG >= 9) { DebugMsg("The current event has no category string."); }
		return(FALSE);
	}

	_snprintf_s(szKeyName, _countof(szKeyName),_TRUNCATE,_T("SYSTEM\\CurrentControlSet\\Services\\EventLog\\%s\\%s"), Trigger, Trigger);

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0L, KEY_QUERY_VALUE, &hk) != NOERROR) {
		if(SNAREDEBUG >= 9) { DebugMsg("Could not open eventlog category string registry information"); }
		return(FALSE);
	}

	dwMaxPath = _MAX_PATH + 1;
	if(RegQueryValueEx(hk, _T("CategoryMessageFile"), 0, &dwType, (LPBYTE)szExeFile, &dwMaxPath) != NOERROR)
	{
		RegCloseKey(hk);
		if(SNAREDEBUG >= 9) { DebugMsg("Could not query categorymessagefile."); }
		return(FALSE);
	}

	if(ExpandEnvironmentStrings(szExeFile, szExeFilePath, _MAX_PATH + 1) == 0)
	{
		strncpy_s(szExeFilePath,_countof(szExeFilePath),szExeFile,_TRUNCATE);
		szExeFilePath[_MAX_PATH]='\0';

	}

	
	// Jump through our DLL references, and try to expand our strings.
	char * DLLStart;
	char * DLLEnd;
	char * StringEnd;

	DLLStart=szExeFilePath;
	StringEnd=DLLStart+strlen(szExeFilePath);

	DLLEnd=strstr(szExeFilePath,";");
	if(!DLLEnd) {
		DLLEnd=StringEnd;
	}

	do {
		*DLLEnd='\0';
	
		hModule = LoadLibraryEx(DLLStart, 0, DONT_RESOLVE_DLL_REFERENCES);
		
		DLLEnd++;
		DLLStart=DLLEnd;

		if(!hModule) {
			if(SNAREDEBUG >= 9) { DebugMsg("LoadLibraryEx failed for %s",DLLStart); }
			continue;
		}


		BOOL HasContent=0;

		try {
			if(!FormatMessage(
				FORMAT_MESSAGE_FROM_HMODULE | 
				FORMAT_MESSAGE_FROM_SYSTEM |
				FORMAT_MESSAGE_IGNORE_INSERTS,
				hModule, Category,
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR)TStringBuffer, _countof(TStringBuffer),
				NULL))
			{
				if(SNAREDEBUG >= 9) { DebugMsg("Could not format message"); }
				FreeLibrary(hModule);
				continue;
			} else {
				if(TStringBuffer != NULL) {
					// Ok, we have resolved a string. Add it to our buffer.
					if(HasContent) {
						_snprintf_s(StringBuffer,length,_TRUNCATE,"%s %s",StringBuffer,TStringBuffer);
					} else {
						HasContent=1;
						strncpy_s(StringBuffer,length,TStringBuffer,_TRUNCATE);
					}
				}
			}
		} catch(...) {
			FreeLibrary(hModule);
			if(SNAREDEBUG >= 9) { DebugMsg("CRASH: Could not format message in GetCategoryString"); }
			continue;
		}

		FreeLibrary(hModule);
	} while(DLLEnd < StringEnd);



	// Kill off those annoying CR/LF chars on the end of this string.
	char *pSB;
	pSB=StringBuffer;
	while(*pSB) {
		if(*pSB==13 || *pSB == 10) {
			*pSB=0;
			break;
		}
		pSB++;
	}

	RegCloseKey(hk);

	return(TRUE);
}


// Match a DOS wildcard against a string.
// eg: wildmatch("c:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatch(char *pattern, char *source)
{
	if(!pattern || !source) {
		return(0);
	}
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatch(pattern, source+1) || wildmatch(pattern+1, source) || wildmatch(pattern+1, source+1);
    case '?':
        return wildmatch(pattern+1, source+1);
    default:
        return (*pattern == *source) && wildmatch(pattern+1, source+1);
    }
}

// Match a DOS wildcard against a string.
// eg: wildmatch("C:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatchi(char *pattern, char *source)
{
	if(!pattern || !source) {
		return(0);
	}
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatchi(pattern, source+1) || wildmatchi(pattern+1, source) || wildmatchi(pattern+1, source+1);
    case '?':
        return wildmatchi(pattern+1, source+1);
    default:
		char lpattern,lsource;
		lpattern = tolower(*pattern);
		lsource = tolower(*source);
		
        return (lpattern == lsource) && wildmatchi(pattern+1, source+1);
    }
}



// Find the nth entry in the tab-delimited string 'search'.
// NOTE: may need to take into account the user delimiter
void splitstrings(char *store, int field, char *search, int size)
{
	int count;
	char *start=search;
	char *end=search;

	if(!store || !search) return;

	strncpy_s(store,1,"",_TRUNCATE);

	for(count=1;count<=field;count++) {
		end=strstr(start,"	");
		if(!end) {
			if(count < field) {
				return;
			} else {
				strncpy_s(store,size,start,_TRUNCATE);
				store[size]='\0';
				return;
			}
		} else {
			int nsize;

			if((end-start) >= size) {
				nsize=size-1;
			} else {
				nsize=(int)(end-start);
			}

			if(count == field) {
				strncpy_s(store,nsize+1,start,_TRUNCATE);
				store[nsize]='\0';
				return;
			}

			start=end+1;
			end=start;
		}
	}
}


void syslogdate(char *sdate, struct tm *cdate)
{
	char Month[4];
	char Date[3];
	char Hour[3];
	char Min[3];
	char Sec[3];

	if(!sdate || !cdate) return;

	switch (cdate->tm_mon) {
		case 0: strncpy_s(Month,_countof(Month),"Jan",_TRUNCATE); break;
		case 1: strncpy_s(Month,_countof(Month),"Feb",_TRUNCATE); break;
		case 2: strncpy_s(Month,_countof(Month),"Mar",_TRUNCATE); break;
		case 3: strncpy_s(Month,_countof(Month),"Apr",_TRUNCATE); break;
		case 4: strncpy_s(Month,_countof(Month),"May",_TRUNCATE); break;
		case 5: strncpy_s(Month,_countof(Month),"Jun",_TRUNCATE); break;
		case 6: strncpy_s(Month,_countof(Month),"Jul",_TRUNCATE); break;
		case 7: strncpy_s(Month,_countof(Month),"Aug",_TRUNCATE); break;
		case 8: strncpy_s(Month,_countof(Month),"Sep",_TRUNCATE); break;
		case 9: strncpy_s(Month,_countof(Month),"Oct",_TRUNCATE); break;
		case 10: strncpy_s(Month,_countof(Month),"Nov",_TRUNCATE); break;
		default: strncpy_s(Month,_countof(Month),"Dec",_TRUNCATE); break;
	}

	if(cdate->tm_mday<10) {
		_snprintf_s(Date,3,_TRUNCATE," %d\0",cdate->tm_mday);
	} else {
		_snprintf_s(Date,3,_TRUNCATE,"%d\0",cdate->tm_mday);
	}

	if(cdate->tm_hour<10) {
		_snprintf_s(Hour,3,_TRUNCATE,"0%d\0",cdate->tm_hour);
	} else {
		_snprintf_s(Hour,3,_TRUNCATE,"%d\0",cdate->tm_hour);
	}

	if(cdate->tm_min<10) {
		_snprintf_s(Min,3,_TRUNCATE,"0%d\0",cdate->tm_min);
	} else {
		_snprintf_s(Min,3,_TRUNCATE,"%d\0",cdate->tm_min);
	}

	if(cdate->tm_sec<10) {
		_snprintf_s(Sec,3,_TRUNCATE,"0%d\0",cdate->tm_sec);
	} else {
		_snprintf_s(Sec,3,_TRUNCATE,"%d\0",cdate->tm_sec);
	}

	_snprintf_s(sdate,16,_TRUNCATE,"%s %s %s:%s:%s\0",Month,Date,Hour,Min,Sec);
}


//////////////////////////////////////////////////////////////////
// SendToSocket
//              sends a buffer (buf) of size size to the specified socket
//              returns TRUE or FALSE.
BOOL  SendToSocket(HostNode *hcn, char *buf, int nSize, char *szError, int eSize)
{
	// int   rv;
	int bytessent=0;

	if(!buf || !szError || !eSize || !hcn || hcn->Socket == INVALID_SOCKET) return(0);

	do {
		bytessent = sendto(hcn->Socket,buf,nSize,0,(SOCKADDR *)&hcn->server,sizeof(hcn->server));
		if(bytessent==-1) {
			if(SNAREDEBUG >= 9) { DebugMsg("error sending to server. WSA ERROR: %d",WSAGetLastError()); }
			return FALSE;
		}
		buf+= bytessent;
		nSize -= bytessent;
	} while(nSize > 0);

	return TRUE;
}


BOOL GetDataString(PEVENTLOGRECORD pELR, char *DataString, DWORD length)
{
	register UINT x;
	LPBYTE			pData = 0;

	if(!DataString) {
		return(0);
	}

	DataString[0]='\0';
	if(pELR->DataLength <= 0)
		return(FALSE);

	// pData = (LPBYTE)GlobalAlloc(GPTR, pELR->DataLength * _countof(BYTE));
	pData = (LPBYTE)malloc(pELR->DataLength * sizeof(BYTE));
	if(pData == NULL) {
		if(SNAREDEBUG >= 9) { DebugMsg("Could not allocate memory in GetDataString"); }
		return(FALSE);
	}

	memcpy(pData, (LPBYTE)((LPBYTE)pELR + pELR->DataOffset), pELR->DataLength);

	for(x = 0; x < pELR->DataLength; x += 8)
	{
		TCHAR DataStringAux[MAX_STRING];
		register UINT y;

		_snprintf_s(DataStringAux,_countof(DataStringAux),_TRUNCATE,"%.4x: ", x);
		if((strlen(DataString) + strlen(DataStringAux)) < length) {
			_tcscat_s(DataString,length, DataStringAux);
		} 
									
		for(y = x; y < x + 8; y++)
		{
			_snprintf_s(DataStringAux, _countof(DataStringAux),_TRUNCATE, "%.2x ", pData[y]);
			if((strlen(DataString) + strlen(DataStringAux)) < length) {
				_tcscat_s(DataString,length, DataStringAux);
			}
		}
		if((strlen(DataString) + 2) < length) {
			_tcscat_s(DataString,length, _T("  "));
		}
									
		for(y = x; y < x + 8; y++)
		{
			if(!isprint((int)pData[y]))
				if((strlen(DataString) + 1) < length) {
					_tcscat_s(DataString,length, _T("."));
				}
			else
			{
				TCHAR s[2];
				s[0] = (TCHAR)pData[y];
				s[1] = '\0';
				if((strlen(DataString) + 1) < length) {
					_tcscat_s(DataString,length, s);
				}
			}
		}
		if((strlen(DataString) + 2) < length) {
			_tcscat_s(DataString,length, _T("\r\n"));
		}
	}
						
	if(pData) {
		//GlobalFree(pData);
		free(pData);
	}

	return(TRUE);
}

BOOL ExpandStrings(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length)
{
	TCHAR szKeyName[MAX_STRING]="";
	LPVOID lpszBuffer = 0;
	LPBYTE pSourceName=0;
	HKEY   hk = (HKEY)0;
	LPBYTE pStrings = 0;

	DWORD dwMaxPath;
	DWORD dwType; // Temporary variable.
	TCHAR szExeFile[_MAX_PATH + 1]="", szExeFilePath[_MAX_PATH+1]="";
	HMODULE hModule = 0;
	LPTSTR *Args = NULL;
	LPTSTR *SArgs = NULL; // Save off any RAM that has been allocated.
	BOOL returncode=FALSE;
	
	
	DWORD ShortEventID=pELR->EventID;

	if(SNAREDEBUG >= 9) { DebugMsg("Inside ExpandStrings"); }
	
	if(!pELR || !StringBuffer) { return(FALSE); }
	
	StringBuffer[0]='\0';
	if(!pELR->DataOffset || !pELR->StringOffset) {
		if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Event looks to have been corrupted."); }
		return(FALSE);
	}


	if(!Trigger) {
		DWORD size=0;

		// No trigger? Send back the input value.
		size=pELR->DataOffset - pELR->StringOffset;
		// Something strange with this audit event. Try and just send back the raw string
		// if it is available.
		if(size) {
			if(size > (length-1)) {
					size=length-1;
			}
			memcpy(StringBuffer, (LPBYTE)pELR + pELR->StringOffset, size);
			StringBuffer[size+1]='\0';
			return(TRUE);
		} else {
			_snprintf_s(StringBuffer,length,_TRUNCATE,"N/A");
		}
	}

	pSourceName = (LPBYTE) pELR + sizeof(EVENTLOGRECORD);
	if(pELR->DataOffset != pELR->StringOffset) {
		pStrings = (LPBYTE)malloc(pELR->DataOffset - pELR->StringOffset);

		// Malloc failed. Dump this event, try the next.
		if(pStrings == NULL) 
		{
			if(SNAREDEBUG >= 9) { DebugMsg("Could not malloc in ExpandStrings"); }
			return(FALSE);
		}

		// Grab the strings (located between stringoffset and dataoffset.
		memcpy(pStrings, (LPBYTE)pELR + pELR->StringOffset, pELR->DataOffset - pELR->StringOffset);
	}
	
	// NOTE that pStrings is null-terminated.

	_snprintf_s(szKeyName, _countof(szKeyName),_TRUNCATE, _T("SYSTEM\\CurrentControlSet\\Services\\EventLog\\%s\\%s"), Trigger, pSourceName);
	//DebugMsg("KEY: %s",szKeyName);

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0L, KEY_QUERY_VALUE, &hk) != NOERROR) {
		DWORD slen=pELR->DataOffset - pELR->StringOffset;
		if(slen >= (length)) {
			slen=length-1;
		}
		if(pStrings) {
			strncpy_s(StringBuffer,slen+1,(char *)pStrings,_TRUNCATE);
			StringBuffer[slen+1]='\0';

			free(pStrings);
		} else {
			_snprintf_s(StringBuffer,length,_TRUNCATE,"N/A");
		}
		if(SNAREDEBUG >= 9) { DebugMsg("Could not open registry data in expandstrings"); }
		return(FALSE);
	}

	dwMaxPath = _MAX_PATH + 1;
	if(RegQueryValueEx(hk, _T("EventMessageFile"), 0, &dwType, (LPBYTE)szExeFile, &dwMaxPath) != NOERROR)
	{
		DWORD slen=pELR->DataOffset - pELR->StringOffset;
		if(slen >= (length)) {
			slen=length-1;
		}

		if(pStrings) {
			strncpy_s(StringBuffer,slen+1,(char *)pStrings,_TRUNCATE);
			StringBuffer[slen+1]='\0';

			free(pStrings);
		} else {
			_snprintf_s(StringBuffer,length,_TRUNCATE,"N/A");
		}
		
		RegCloseKey(hk);
		if(SNAREDEBUG >= 9) { DebugMsg("Could not queryvalue in expandstrings"); }
		return(FALSE);
	}


	// Establish a loop for those eventlog entries that use more than one
	// DLL to retrieve audit data from. Loop through each until we find a
	// valid bit of info.

	TCHAR szExeFile2[_MAX_PATH + 1];
	char * pszExeFile2;
	char * semipos;
	
	DWORD ArgCount;
	DWORD NewStringsCount=0;
	DWORD AllocCount=0;
	char * tempArg=NULL;
	
	strncpy_s(szExeFile2,_countof(szExeFile2),szExeFile,_TRUNCATE);
	pszExeFile2=szExeFile2;
	
	if(pELR->NumStrings) {
		// Allocate memory and split up string arguments
		// Note: We are only allocating RAM here for the pointer list. The actual string
		// RAM is allocated from within GetParameterMsg
		Args = (LPTSTR *)malloc((pELR->NumStrings) * sizeof(TCHAR *));
		if(Args == NULL)
		{
			FreeLibrary(hModule);
			if(SNAREDEBUG >= 9) DebugMsg("Could not allocate memory for the appropriate number of strings.");
			return(FALSE);
		}
		
		SArgs = (LPTSTR *)malloc((pELR->NumStrings) * sizeof(TCHAR *));
		if(SArgs == NULL)
		{
			free(Args);
			FreeLibrary(hModule);
			if(SNAREDEBUG >= 9) DebugMsg("Could not allocate memory for the appropriate number of strings.");
			return(FALSE);
		}
	}

	if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Getting Args"); }
	// No need to free anything after this call. We are just constructing a pointer list to
	// data within pELR
	if(pELR->NumStrings) {
		GetArgs(pELR,(char **)Args);
						
		for(ArgCount=0; ArgCount<pELR->NumStrings; ArgCount++) {
			NewStringsCount++;
					//if(SNAREDEBUG >= 1 && strstr(Args[ArgCount],"%%")) {
					//	DebugMsg("some percents");
					//}
			tempArg=GetParameterMsg(Args[ArgCount],szKeyName);
			// Save off the location of the allocated RAM
			// So we can free it later.
			if(tempArg) {
				Args[ArgCount]=tempArg;
				SArgs[ArgCount]=tempArg;

				AllocCount++;
			} else {
				SArgs[ArgCount]=NULL;
			}
		}
	}


	// Loop through the available libary options until we actually get
	// something useful.
	do {
		semipos=strstr(pszExeFile2,";");
		if(semipos) {
			if(semipos-pszExeFile2 < _MAX_PATH) {
				strncpy_s(szExeFile,(semipos-pszExeFile2)+1,pszExeFile2,_TRUNCATE);
				szExeFile[semipos-pszExeFile2]='\0';
			} else {
				strncpy_s(szExeFile,_countof(szExeFile),pszExeFile2,_TRUNCATE);
			}
			pszExeFile2=semipos+1;
		} else {
			strncpy_s(szExeFile,_countof(szExeFile),pszExeFile2,_TRUNCATE);
			pszExeFile2=(char *)NULL;
		}
		
		// If someone has added a semi-colon without actually putting info after it, break out.
		if(!strlen(szExeFile)) {
			break;
		}
				
		if(ExpandEnvironmentStrings(szExeFile, szExeFilePath, _MAX_PATH + 1) == 0)
		{
			strncpy_s(szExeFilePath,_countof(szExeFilePath),szExeFile,_TRUNCATE);
			szExeFilePath[_MAX_PATH]='\0';
		}
				
		// NOTE: Windows 2000 SP2 introduces a bug here, because it
		// adds another DLL after the normal msaudite.dll (after a semicolon)
		// Have changed this routine to cover this problem. We are now in a do..while loop.
		hModule=NULL;
		hModule = LoadLibraryEx(szExeFilePath, 0, DONT_RESOLVE_DLL_REFERENCES);
		if(!hModule) {
			if(SNAREDEBUG >= 9) { DebugMsg("LoadLibraryEx failed in expandstrings"); }
			continue;
		}
		
		
		if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Allocating Args"); }
		
		if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Jumping through params"); }
		// Now, jump through the parametermessage stuff.
		// Basically: jump through each of the strings,
		// if it contains a %%, then send it through
		
		if(pELR->NumStrings) {			
			if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: NumStrings is NOT zero"); }
			if(Args) {
				if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Args exist, now formatting for %d...", ShortEventID); }
				// This FORMATMESSAGE call is causing a DrWATSON in some strange circumstances
				// principally on exchange boxes... (eg: eventid 287, and 1292)
				// Not sure why yet.
				// I'll encase this in a try/catch block.
				
				try {
					if(!FormatMessage(
						FORMAT_MESSAGE_ALLOCATE_BUFFER | 
						FORMAT_MESSAGE_FROM_HMODULE | 
						FORMAT_MESSAGE_FROM_SYSTEM | 
						FORMAT_MESSAGE_ARGUMENT_ARRAY,
						hModule, ShortEventID,
						MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
						(LPTSTR)&lpszBuffer, 0,
						(va_list *)Args))	{
							if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage failed (with no strings) - Event ID was %d - trying shorter ID",ShortEventID); }
							// Use the shortened event ID to deal with buggy software that
							// does not fill out the whole DWORD.

							// Some buggy software does not write out a full dword eventid.
							//       However: By 'shortening' the eventid, it kills many legitimate
							//                event logs. *sigh*
							ShortEventID=ShortEventID &0x0000FFF;

							if(!FormatMessage(
								FORMAT_MESSAGE_ALLOCATE_BUFFER | 
								FORMAT_MESSAGE_FROM_HMODULE | 
								FORMAT_MESSAGE_FROM_SYSTEM | 
								FORMAT_MESSAGE_IGNORE_INSERTS,
								hModule, ShortEventID,
								MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
								(LPTSTR)&lpszBuffer, 0,
								(va_list *)NULL))	{
									if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage failed (with no strings) on second try - Event ID was %d",ShortEventID); }
									if(hModule) {	FreeLibrary(hModule);	}
									continue;
							
							}
					}
				} catch(...) {
					if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage Died - handling catch"); }
					
					// No characters stored in buffer.
					
					if(hModule) {	FreeLibrary(hModule);	}
					if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage failure cleanup complete"); }
					continue;
				}
			} else {
				// ARGS - null pointer.
				if(SNAREDEBUG >= 9) { DebugMsg("Args has mysteriously disappeared"); }
				
				// No characters stored in buffer.
				
				if(hModule) {	FreeLibrary(hModule);	}
				if(SNAREDEBUG >= 9) { DebugMsg("Cleaning up after args dissappearance"); }
				continue;
			}
		} else {
			if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: NumStrings is zero"); }
			// No Strings! Try and format it anyway.
			DWORD size=0;
		
			// Note: There are some events (eg: the one generated by Snare!)
			// That do not seem to fit this (StringOffset = DataOffset) - where do we get strings
			// from????
			ShortEventID=pELR->EventID;
			pSourceName = (LPBYTE) pELR + sizeof(EVENTLOGRECORD);

			if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Now formatting for %d...", ShortEventID); }
			try {
				if(!FormatMessage(
					FORMAT_MESSAGE_ALLOCATE_BUFFER | 
					FORMAT_MESSAGE_FROM_HMODULE | 
					FORMAT_MESSAGE_FROM_SYSTEM | 
					FORMAT_MESSAGE_IGNORE_INSERTS,
					hModule, ShortEventID,
					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
					(LPTSTR)&lpszBuffer, 0,
					(va_list *)NULL))	{
						if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage failed (with no strings) - Event ID was %d - trying shorter ID",ShortEventID); }
						// Hmm.. Try with a short ID instead.
						ShortEventID=ShortEventID &0x0000FFF;

						if(!FormatMessage(
							FORMAT_MESSAGE_ALLOCATE_BUFFER | 
							FORMAT_MESSAGE_FROM_HMODULE | 
							FORMAT_MESSAGE_FROM_SYSTEM | 
							FORMAT_MESSAGE_IGNORE_INSERTS,
							hModule, ShortEventID,
							MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
							(LPTSTR)&lpszBuffer, 0,
							(va_list *)NULL))	{
								if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage failed (with no strings) on second try - Event ID was %d",ShortEventID); }
								if(hModule) {	FreeLibrary(hModule);	}
								continue;
						}
				}
			} catch(...) {
				if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Format message failed..."); }
				if(hModule) {	FreeLibrary(hModule);	}
				continue;
			}
		}

		if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: pELR OK"); }
			
		if(!lpszBuffer)
		{
			if(hModule) { FreeLibrary(hModule); }
			if(SNAREDEBUG >= 9) { DebugMsg("No lpszBuffer"); }
			continue;
		}
		
		strncpy_s(StringBuffer,length,(const char *)lpszBuffer,_TRUNCATE);
	
		LocalFree(lpszBuffer);
			
		if(hModule) { FreeLibrary(hModule); }
	
		returncode=TRUE;
		// We have some data! Break out of our loop. No point in investigating the other
		// locations for data.
		break;

	} while(pszExeFile2);

	if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: About to free SArgs"); }

	if(AllocCount) {
		for(ArgCount=0;ArgCount<AllocCount;ArgCount++) {
			free(SArgs[ArgCount]);
		}
	}
	if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: About to free Args"); }

	if(Args) { free(Args); }
	if(SArgs) { free(SArgs); }

	if(hk) { RegCloseKey(hk); }

	if(pStrings) {
		// If we have been unable to push anything into the string buffer.
		if(!strlen(StringBuffer)) {
			if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Nothing in StringBuffer"); }
			DWORD slen=pELR->DataOffset - pELR->StringOffset;
			if(slen >= (length)) {
				slen=length-1;
			}
			strncpy_s(StringBuffer,slen+1,(char *)pStrings,_TRUNCATE);
			StringBuffer[slen+1]='\0';
			if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Returning with pStrings in stringbuffer"); }
			returncode=FALSE;
		}
		free(pStrings);
	} else if(!strlen(StringBuffer)) {
		if(SNAREDEBUG >= 9) { DebugMsg("ExpandStrings: Setting StringBuffer to unknown"); }
		strncpy_s(StringBuffer,length,"Unknown",_TRUNCATE);
		returncode=FALSE;
	}
	return(returncode);
}


char * GetParameterMsg(char *message, char *szKeyName)
{
	int		I, StringId, FileNameModuleSize = MAX_STRING;
	char    *EndPtr;
	HKEY	nKeyHandle=0;
	BYTE	FileNameModule[MAX_STRING+1],expbuffer[MAX_STRING+1];
	HMODULE hModule = 0;

	char	lpBuffer[MAX_STRING+1], tmpStr[MAX_STRING+2], *StartPtr;
	static char *DescrStr;

	if(!message || !szKeyName) {
		return((char *)NULL);
	}

	if(!strstr(message,"%%")) {
		DescrStr = (char *)malloc(strlen(message) + 1);
		if(DescrStr) {
			strncpy_s(DescrStr,strlen(message) + 1, message,_TRUNCATE);
			return DescrStr;
		} else {
			return((char *)NULL);
		}
	}

	if(strlen(message) < 3) {
		return((char *)NULL);
	}

	if(!strlen(szKeyName)) {
		return((char *)NULL);
	}

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, (LPTSTR) szKeyName, 0L, KEY_QUERY_VALUE, &nKeyHandle) != NOERROR) {
		if(SNAREDEBUG >= 9) { DebugMsg("Could not open key in getparametermsg"); }
		return((char *)NULL);	
	}

	if (RegQueryValueEx(nKeyHandle,
				"ParameterMessageFile",
				NULL,
				NULL,
				FileNameModule,
				(unsigned long *)&FileNameModuleSize) != ERROR_SUCCESS) {
		if(SNAREDEBUG >= 9) { DebugMsg("Could not regqueryvalueex in getparametermsg"); }
	    if(nKeyHandle) { RegCloseKey(nKeyHandle); }
		return((char *)NULL);
	}

	ExpandEnvironmentStrings(
				(const char *)FileNameModule,	// pointer to string with environment variables
				(char *)expbuffer,      		// pointer to string with expanded environment variables
				MAX_STRING);					// maximum characters in expanded string

	
	if(nKeyHandle) { RegCloseKey(nKeyHandle); }

	hModule=LoadLibraryEx((const char *)expbuffer,NULL,LOAD_LIBRARY_AS_DATAFILE|DONT_RESOLVE_DLL_REFERENCES);
	if(!hModule) {
		return((char *)NULL);
	}

	EndPtr = message;
	StartPtr = message;
	tmpStr[0] = '\0';

	// HMMM... this could be an issue? REDRED - TODO / FIXME
	StringId = strtol(StartPtr + 2 ,&EndPtr,10);

	int csize=0;	// current size
	int ssize=0;	// target string size
	int copysize=0;	// amount to copy
	int overflow=0;	// did we overflow?

	char * tmpPtr;

	while (StringId != 0)
	{
		try {
			I=FormatMessage(
				FORMAT_MESSAGE_FROM_HMODULE|
				FORMAT_MESSAGE_IGNORE_INSERTS,
				hModule,
				StringId,
				0,  // Default language
				(LPTSTR) &lpBuffer,
				MAX_STRING,
				(LPTSTR *) NULL
			);
		} catch(...) {
			if(SNAREDEBUG >= 9) { DebugMsg("FormatMessage crash in GetParameterMsg"); }
			I=0;
		}

		if (I==0)
		{
			FreeLibrary(hModule);
			// return (message);
			return((char *)NULL);
		}
		
		csize=(int)strlen(tmpStr);
		ssize=(int)strlen((char *)lpBuffer);
		if((csize + ssize) >= MAX_STRING) {
			// Overflow. Copy what we can.
			copysize=MAX_STRING - csize;
			overflow=1;
		} else {
			copysize=csize+ssize;
		}

		strncat_s(tmpStr, _countof(tmpStr),(char *)lpBuffer,_TRUNCATE);
		if(overflow) {
			StringId=0;
		} else {
			strncat_s(tmpStr, _countof(tmpStr), " ",_TRUNCATE);		
			if ((tmpPtr=strstr(EndPtr, "%%")) != NULL) {
				char *tmpPtr2;
				StringId = strtol(tmpPtr + 2,&tmpPtr2,10);
				EndPtr=tmpPtr2;
				if(!EndPtr) {
					StringId=0;
				}
			} else {
				StringId =0;
			}
		}
	}

	FreeLibrary(hModule);

	// NOTE: the calling routine REALLY needs to free this string once it's grabbed.
	// C sucks sometimes.
	DescrStr = (char *)malloc(strlen(tmpStr) + 1);
	if(DescrStr) {
		strncpy_s(DescrStr,strlen(tmpStr) + 1, tmpStr,_TRUNCATE);

		return DescrStr;
	}
	return((char *)NULL);
}




void GetArgs(const EVENTLOGRECORD *pELR, char **Args)
{
	DWORD ArgCount;
	char * cpointer;

	if(!pELR || !Args) return;
	if(pELR->NumStrings == 0) return;

	cpointer = (char *)pELR + (pELR->StringOffset);

	for(ArgCount=0; ArgCount<pELR->NumStrings; ArgCount++) {
		Args[ArgCount] = cpointer;
		cpointer += strlen(cpointer) + 1;
	}
}

BOOL GetEventLogType(TCHAR *sz, unsigned short uEventType, DWORD length)
{
	if(!sz || !length)
		return FALSE;

	switch(uEventType)
	{
		case EVENTLOG_SUCCESS:
			strncpy_s(sz, length, _T("Success"),_TRUNCATE);
			break;
		case EVENTLOG_ERROR_TYPE:
			strncpy_s(sz, length, _T("Error"),_TRUNCATE);
			break;
		case EVENTLOG_WARNING_TYPE:
			strncpy_s(sz, length, _T("Warning"),_TRUNCATE);
			break;
		case EVENTLOG_INFORMATION_TYPE:
			strncpy_s(sz, length, _T("Information"),_TRUNCATE);
			break;
		case EVENTLOG_AUDIT_SUCCESS:
			strncpy_s(sz, length, _T("Success Audit"),_TRUNCATE);
			break;
		case EVENTLOG_AUDIT_FAILURE:
			strncpy_s(sz, length, _T("Failure Audit"),_TRUNCATE);
			break;
		default:
			strncpy_s(sz, length, _T("Unknown"),_TRUNCATE);
			break;
	}

	return TRUE;
}

BOOL CheckLogExists(TCHAR *LogName)
{
	TCHAR szKeyName[MAX_STRING]="";
	LPBYTE pSourceName=0;
	HKEY   hk = (HKEY)0;
	LPBYTE pStrings = 0;

	DWORD dwMaxString;			
	DWORD dwType; // Temporary variable.
	TCHAR szKeyValue[MAX_STRING+1]="";
	TCHAR szFileName[MAX_STRING+1]="";

	if(!LogName) return(0);
			
	wsprintf(szKeyName, _T("SYSTEM\\CurrentControlSet\\Services\\EventLog\\%s"), LogName);

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0L, KEY_READ|KEY_SET_VALUE, &hk) != ERROR_SUCCESS) {
		if(SNAREDEBUG >= 1 && LogName) { if(LogName) { DebugMsg("Cannot determine if log %s exists - openkey failed",LogName); } }
		return(FALSE);
	}

	dwMaxString=MAX_STRING-1;
	if(RegQueryValueEx(hk, _T("File"), 0, &dwType, (LPBYTE)szKeyValue, &dwMaxString) != ERROR_SUCCESS)
	{
		if(SNAREDEBUG >= 1 && LogName) { DebugMsg("Cannot determine if log %s exists - queryvalueex failed",LogName); }
		RegCloseKey(hk);
		return(FALSE);
	}

	ExpandEnvironmentStrings(szKeyValue,szFileName,_countof(szFileName));
	if(!strlen(szFileName)) {
		if(SNAREDEBUG >= 1 && LogName) { DebugMsg("String just wont expand in checklogexists. Log %s probably doesnt exist",LogName); }
		RegCloseKey(hk);
		return(FALSE);
	}

	struct _stat buf;

	if(_stat(szFileName, &buf)) {
		RegCloseKey(hk);
		return(FALSE);
	}

	// Verify that log retention settings are set to 'overwrite as needed'.
	// Not sure if we need to restart the audit service if this succeeds..

	DWORD RetentionValue=0;
	DWORD RetentionSize=sizeof(RetentionValue);

	// Verify that the user is overwriting as required
	if(RegQueryValueEx(hk, _T("Retention"), 0, &dwType, (unsigned char *)&RetentionValue, &RetentionSize) != ERROR_SUCCESS)
	{
		if(SNAREDEBUG >= 1 && LogName) {
			DebugMsg("Cannot check log retention settings - queryvalueex failed for log %s",LogName);
		}
	}
	if(SNAREDEBUG >= 1) { DebugMsg("Log retention settings are set to %d for log %s",RetentionValue,LogName); }
	
	if(RetentionValue != 0) {
		RetentionValue=0;
		if(RegSetValueEx(hk, _T("Retention"), 0, REG_DWORD, (unsigned char *)&RetentionValue, sizeof(DWORD)) != ERROR_SUCCESS)
		{
			if(SNAREDEBUG >= 1 && LogName) { DebugMsg("Cannot set log retention settings - regsetvalueex failed for log %s",LogName); }
		}
	}
	

	RegCloseKey(hk);
	return(TRUE);
}



BOOL GetSIDType(SID_NAME_USE _SidNameUse, TCHAR *szSIDType, DWORD length)
{
	if(!szSIDType || length <=1 || !_SidNameUse) {
		return FALSE;
	}

	szSIDType[0] = '\0';
	switch(_SidNameUse)
	{
		case SidTypeUser:
			strncpy_s(szSIDType,length,"User",_TRUNCATE);
			break;
		case SidTypeGroup:
			strncpy_s(szSIDType,length,"Group",_TRUNCATE);
			break;
		case SidTypeDomain:
			strncpy_s(szSIDType,length,"Domain",_TRUNCATE);
			break;
		case SidTypeAlias:
			strncpy_s(szSIDType,length,"Alias",_TRUNCATE);
			break;
		case SidTypeWellKnownGroup:
			strncpy_s(szSIDType,length,"Well Known Group",_TRUNCATE);
			break;
		case SidTypeDeletedAccount:
			strncpy_s(szSIDType,length,"Deleted Account",_TRUNCATE);
			break;
		case SidTypeInvalid:
			strncpy_s(szSIDType,length,"Invalid SID",_TRUNCATE);
			break;
		case SidTypeUnknown:
			strncpy_s(szSIDType,length,"Unknown",_TRUNCATE);
			break;
		case SidTypeComputer:
			strncpy_s(szSIDType,length,"Computer",_TRUNCATE);
			break;
		default:
			strncpy_s(szSIDType,length,"Out of Type",_TRUNCATE);
			break;
	}						

	return TRUE;
}


///////////////////////////////////////////////////////////////////
// InitWinsock
//              starts up winsock.dll or wsock32.dll
BOOL InitWinsock( char *szError, int size )
{
	WSAData wsData;

	if(!szError) return(FALSE);
	
	WORD wVersionRequested = WINSOCK_VERSION;
	
	if(WSAStartup(wVersionRequested, &wsData) != 0)
	{
		// :( error
		if( szError )
		{
			sprintf_s(szError,size,"WSAStartup failed: WSA ERROR: %d\r\n",
				WSAGetLastError());
			if(SNAREDEBUG >= 9) { if(szError) { DebugMsg(szError); } }
		}
		return FALSE;
	}
	
	// all is well
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// TerminateWinsock
//      call this function with the current socket or INVALID_SOCKET
void TerminateWinsock( SOCKET hSocket )
{
	// cancel blocking calls, if any
	WSACancelBlockingCall();
	
	// close socket
	if( hSocket != INVALID_SOCKET ) {
		closesocket(hSocket);
		hSocket=INVALID_SOCKET;
	}
		
	// unload winsock
	WSACleanup();
}

// Note that hosthead is a global.
HostNode * OpenSockets(char *lpszDestination, DWORD dwDestPort, DWORD SocketType)
{
	HostNode * headnode=NULL;
	char szError[MAX_STRING];

	headnode=(HostNode *)malloc(sizeof(HostNode));
	if(!headnode) {
		// Oh dear.. out of RAM?
		return(headnode);
	}

	headnode->next=NULL;
	strncpy_s(headnode->HostName,511,lpszDestination,_TRUNCATE);
	headnode->Socket=ConnectToServer( headnode, (UINT)dwDestPort, szError,_countof(szError), SocketType );
	if(headnode->Socket == INVALID_SOCKET) {
		if(SNAREDEBUG >= 9) DebugMsg("Problem opening Socket to %s: %s",lpszDestination,szError);
	}
		
	return(headnode);
}



//////////////////////////////////////////////////////////////
// ConnectToServer:
//    connects to a server on a specified port number
//    returns the connected socket
SOCKET ConnectToServer(HostNode *hcn, UINT nPort, char *szError, int size, DWORD SocketType)
{
	SOCKET hSocket;
	struct hostent far *hp;
	
	if (SNAREDEBUG >= 9) DebugMsg("ConnectToServer");
	if(!hcn->HostName) return INVALID_SOCKET;
	if(!szError || !size) return INVALID_SOCKET;
	if(!*hcn->HostName) return INVALID_SOCKET;
	
	hcn->SocketType = SocketType;
	// Should use something nicer to check for IP addresses...
	if( isdigit(hcn->HostName[0])) {
		ZeroMemory((char *) &hcn->server, sizeof(hcn->server));
		hcn->server.sin_family      = AF_INET;
		hcn->server.sin_addr.s_addr = inet_addr(hcn->HostName);
		hcn->server.sin_port        = htons(nPort);
	} else {
		if ( (hp = (struct hostent far *) gethostbyname(hcn->HostName)) == NULL)	{
			_snprintf_s(szError,size,_TRUNCATE,"Error: gethostbyname failed: %s.",hcn->HostName);
			return INVALID_SOCKET;
		}
		
		ZeroMemory((char *)&hcn->server, sizeof(hcn->server));
		CopyMemory((char *) &hcn->server.sin_addr,hp->h_addr,hp->h_length);
		hcn->server.sin_family = hp->h_addrtype;
		hcn->server.sin_port = htons(nPort);
	}

	// create socket
	if((hSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET) {
		_snprintf_s(szError,size,_TRUNCATE,"socket failed to create datagram socket: %d\n",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	return hSocket;
}


static Node * FastCheckObjective(int eventnumber, int etype, int stype)
{
	static int firstcall=0;
	static Node *tnode;
	int ShortEventID=0;
	
	// No objectives?
	if(!head) {
			return(NULL);
	}
	
	if(firstcall==0) {
		ResetCurrentNode();
		firstcall=1;
	}

	do {
		tnode = GetCurrentItem();
		if(!tnode) {
			ResetCurrentNode();
			// if(SNAREDEBUG >= 7) { DebugMsg("FCO: Current item is null. Must be at the end of the list"); }
			return(NULL);
		}
		
		ShortEventID=eventnumber & 65535;

		if(SNAREDEBUG >= 7) { DebugMsg("FCO: Checking event %d against %d, and etype %d against %d, and stype %d against %d",eventnumber,tnode->event_number,etype,tnode->eventlogtype,stype,tnode->sourcename); }
		//if(eventnumber == tnode->event_number || tnode->event_number == AUDIT_ALL) {
		if(ShortEventID == tnode->event_number || tnode->event_number == AUDIT_ALL) {
			//if(SNAREDEBUG >= 7) { DebugMsg("FCO: Event number looks good.."); }
			if((etype & tnode->eventlogtype) && (stype & tnode->sourcename)) {
				//if(SNAREDEBUG >= 7) { DebugMsg("FCO: etype/stype looks good!"); }
				// Are we including users, or excluding.
				NextItemInList();
				return(tnode);
			}
		}
		NextItemInList();
	} while(IsValidItem());
	//if(SNAREDEBUG >= 7) { DebugMsg("FCO: Out. No more valid items."); }
	// Will probably never get here.
	ResetCurrentNode();
	return(NULL);
}

int CheckObjective(Node * Match, int eventnumber, char *username, char *match)
{
	if(!username || !match) {
		if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: No Username or Match Term supplied"); }
		return(-1);
	}

	if(!Match) {
		if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: No Objective supplied"); }
		return(-1);
	}
	if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective ([%s,%d,%s],%d,%s,%s)", Match->match, Match->excludeflag, Match->username, eventnumber, username, match); }

	int usermatch=0;
	char * spoint;
	char tuser[256];
			
	// This could do with some optimisation.. FIXME
	// NOTE: Cannot split out into separate objectives, due to exclusion stuff.
	if(Match->muserflag) {
		spoint=Match->username;
		usermatch=0;
		do {
			spoint=string_split(',',spoint,tuser,_countof(tuser));
			usermatch=wildmatchi(tuser,username);
			if(usermatch) {
				break;
			}
		} while(spoint);
	} else {
		usermatch=wildmatchi(Match->username,username);
	}
	
	if(IS_OBJECT_ACCESS(eventnumber)) {
		if(strlen(Match->match)>2) {
			// Windows 2000 does wierd things with filename auditing - eg: c:\temp\goo
			// becomes \Device\HarddiskDmVolumes\PhysicalDmVolumes\BlockVolume2\temp\goo
			// As such, if this is an object-event, FIRST, try stripping off the
			// VOLUME: (eg: C:) part of the match term, and add on a general raw device
			// term. If nothing comes up, drop back to standard tests.
			
			if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: object access.."); }
			
			char tempmatch[SIZE_OF_GENERALMATCH];
			_snprintf_s(tempmatch,SIZE_OF_GENERALMATCH,_TRUNCATE,"*\\Device\\HarddiskDmVolumes\\PhysicalDmVolumes\\BlockVolume*\\%s",&Match->match[4]);
					
			// Allowing multiple users (comma separated) may slow things down a little..
					
			if(Match->excludeflag) {
				if(!usermatch && wildmatchi(tempmatch,match)) {
					return(Match->criticality);
				}
			} else {
				if(usermatch && wildmatchi(tempmatch,match)) {
					return(Match->criticality);
				}
			}
		}
	}

	if(SNAREDEBUG >= 7) { DebugMsg("Match->excludeflag: %d", Match->excludeflag); }
	if(Match->excludeflag) {
		if(SNAREDEBUG >= 7) { DebugMsg("usermatch: %d", usermatch); }
		if(!usermatch && wildmatchi(Match->match,match)) {
			return(Match->criticality);
		}
	} else {
		if(SNAREDEBUG >= 7) { DebugMsg("usermatch: %d", usermatch); }
		if(usermatch && wildmatchi(Match->match,match)) {
			return(Match->criticality);
		}
	}
	if(SNAREDEBUG >= 7) { DebugMsg("Match failed", Match->excludeflag); }
	
	return(-1);
}

char * string_split(char divider,char *string,char *destination,int destlength)
{
	int destsize=0;

	if(!string || !destination) {
		return((char *)NULL);
	}

	while(*string && *string != divider) {
		if(destsize < destlength) {
			*destination=*string;
			destination++;
			destsize++;
		}

		string++;
	}
	*destination='\0';
	if(*string == divider) {
		string++;
	} else {
		return((char *)NULL);
	}
	return(string);
}


int ReadObjectives()
{
	Reg_Objective reg_objective;
	DWORD dw_objective_error;
	int i_objective_count=0;
	char *eventpointer,*eventpointer2;
	char eventnumber[11];
	int eventid;
	int criticality;
	int etype=0;
	int stype=0;
	int userflag=0; // include by default
	int muserflag=0; // multiple users, comma separated?
	DWORD SetAudit=0;

	SetAudit=MyGetProfileDWORD("Config","Audit",0);

	// HERE: Turn off all auditing, unless there are NO objectives to read.
	if(SetAudit) {
		ClearAuditFlags();
	}
	
	while((dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective))==0) {
		// For each event number defined.
		eventpointer=reg_objective.str_unformatted_eventid_match;
		eventpointer2=reg_objective.str_unformatted_eventid_match;

		userflag=reg_objective.dw_user_match_type;
		
		// While there are no more commas
		while(eventpointer2) {
			eventpointer2=strstr(eventpointer,",");
			if(eventpointer2 == (char *)NULL) {
				// No commas left. Just copy to the end of the line.
				strncpy_s(eventnumber,_countof(eventnumber),eventpointer,_TRUNCATE);
				eventnumber[10]='\0'; // just in case
			} else {
				int size=9;
				if(eventpointer2-eventpointer < 10) {
					size=(int)(eventpointer2-eventpointer);
				}
				strncpy_s(eventnumber,size+1,eventpointer,_TRUNCATE);
				// Make sure we have a null on the end of the line.
				eventnumber[size]='\0';
			}
			if(eventpointer2) {
				// Skip the comma
				eventpointer=eventpointer2+1;
			}
			
			if(!strcmp(eventnumber,"*")) {
				eventid=AUDIT_ALL;
			} else {
				eventid=atoi(eventnumber);
			}
			if((eventid >=0 && eventid <= 65535) || eventid==AUDIT_ALL) {
				// valid event ID. Continue.

				// HERE: Turn on the appropriate audit.

				if(!strcmp(reg_objective.str_critic,CRITICAL_TOKEN)) {
					criticality=EVENT_CRITICAL;
				} else if(!strcmp(reg_objective.str_critic,PRIORITY_TOKEN)) {
					criticality=EVENT_PRIORITY;
				} else if(!strcmp(reg_objective.str_critic,WARNING_TOKEN)) {
					criticality=EVENT_WARNING;
				} else if(!strcmp(reg_objective.str_critic,INFORMATION_TOKEN)) {
					criticality=EVENT_INFORMATION;
				} else if(!strcmp(reg_objective.str_critic,CLEAR_TOKEN)) {
					criticality=EVENT_CLEAR;
				}

				etype=reg_objective.dw_event_type;
				if(!etype) etype=TYPE_SUCCESS|TYPE_FAILURE|TYPE_INFO|TYPE_WARN|TYPE_ERROR;
				
				// Does the user want us to change the audit settings?
				// Only do this for SECURITY log events
				if(SetAudit && (reg_objective.dw_eventlog_type & LOG_SEC)) {
					if((etype & TYPE_SUCCESS) || (etype & TYPE_FAILURE)) {
						TurnOnEvent(eventid,etype);
					} else {
						// The user didn't specify whether to audit success or failures.
						// TURN ON SUCCESS AUDITING AND FAILURE AUDITING
						TurnOnEvent(eventid,TYPE_SUCCESS|TYPE_FAILURE);
					}
				}

				stype=reg_objective.dw_eventlog_type;
				if(!stype) stype=LOG_SEC|LOG_SYS|LOG_APP|LOG_DIR|LOG_DNS|LOG_REP;

				// Just in case the general match is empty.
				char tempmatch[SIZE_OF_GENERALMATCH];

				if(!strlen(reg_objective.str_general_match)) {
					// NOTE: general_match is > 1, so strcpy is safe here.
					strncpy_s(tempmatch,_countof(tempmatch),"*",_TRUNCATE);
				} else {
					_snprintf_s(tempmatch,_countof(tempmatch),_TRUNCATE,"*%s*",reg_objective.str_general_match);
				}

				if(strstr(reg_objective.str_user_match,",")) {
					muserflag=1;
				} else {
					muserflag=0;
				}

				AddToList(eventid, reg_objective.str_user_match,
						  tempmatch,
						  criticality, userflag, muserflag, etype,
						  stype);
			}
		}
		
		i_objective_count++;
	}

	if(SetAudit) {
		ApplyAudit();
	}
	return(i_objective_count);
}

BOOL TurnOnEvent(DWORD EventID,DWORD SuccessFailure)
{
	if(IS_PRIVILEGE_USE(EventID)) {
		SetAuditFlag(AuditCategoryPrivilegeUse,SuccessFailure);
	}
	if(IS_PROCESS_TRACKING(EventID)) {
		SetAuditFlag(AuditCategoryDetailedTracking,SuccessFailure);
	}
	if(IS_SYSTEM_EVENTS(EventID)) {
		SetAuditFlag(AuditCategorySystem,SuccessFailure);
	}
	if(IS_LOGON_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryLogon,SuccessFailure);
	}
	if(IS_ACCOUNT_LOGON_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryAccountLogon,SuccessFailure);
	}
	if(IS_ACCOUNT_MANAGEMENT_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryAccountManagement,SuccessFailure);
	}
	if(IS_OBJECT_ACCESS(EventID)) {
		SetAuditFlag(AuditCategoryObjectAccess,SuccessFailure);
	}
	if(IS_POLICY_CHANGE(EventID)) {
		SetAuditFlag(AuditCategoryPolicyChange,SuccessFailure);
	}
	if(IS_DIRECTORY_SERVICE_ACCESS(EventID)) {
		SetAuditFlag(AuditCategoryDirectoryServiceAccess,SuccessFailure);
	}

	return(1);
}

// New routines to cope with win2003 PDC replication issues.
// Rather than clear, and re-set all auditing (which causes lots of replication traffic)
// we will just establish a 'flag' array, and then apply it all at the end.

void ClearAuditFlags()
{
	// Uses global flag array "int AuditFlags[9]"
	int i=0;
	for(i=0;i<9;i++) {
		AuditFlags[i]=0;
	}
}

// Make sure you clear audit flags before building this array up.
int SetAuditFlag(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure)
{
	// Uses global flag array "int AuditFlags[9]"
	// Note: expand AuditFlags to max(POLICY_AUDIT_EVENT_TYPE)
	AuditFlags[AuditCategory] |= SuccessFailure;

	return(0);
}

BOOL ApplyAudit()
{
	// AuditCategorySystem, AuditCategoryLogon, AuditCategoryObjectAccess,
	// AuditCategoryPrivilegeUse, AuditCategoryDetailedTracking,
	// AuditCategoryPolicyChange, AuditCategoryAccountManagement,
	// AuditCategoryDirectoryServiceAccess, AuditCategoryAccountLogon

	LPWSTR wComputerName = NULL; 
    LSA_HANDLE PolicyHandle; 
    NTSTATUS Status; 
	PPOLICY_AUDIT_EVENTS_INFO AuditEvents;
	LSA_OBJECT_ATTRIBUTES ObjectAttributes; 
	DWORD Flag=0;
	int i=0;
	DWORD SuccessFailure;
	POLICY_AUDIT_EVENT_TYPE AuditCategory;
	int AuditChanged=0;

	ZeroMemory(&ObjectAttributes, sizeof(ObjectAttributes));

	Status = LsaOpenPolicy(NULL, &ObjectAttributes, POLICY_VIEW_AUDIT_INFORMATION | POLICY_SET_AUDIT_REQUIREMENTS, &PolicyHandle);

	if(Status == 0) {
		Status = LsaQueryInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (void **) &AuditEvents); 
 
		if(Status != 0) {
			LsaClose(PolicyHandle);
			return 0; 
		}
		// 
		// successfully obtained AuditEventsInformation. 
		// 

		// If audit is not turned on
		if(AuditEvents->AuditingMode == 0) {
			// In theory, we need to turn on auditing.
			AuditEvents->AuditingMode = 1;
			Status = LsaSetInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
				(PVOID) AuditEvents); 
		}

		// For each element in the AuditFlags array:
		for(i=0;i<9;i++) {
			AuditCategory=(POLICY_AUDIT_EVENT_TYPE)i;
			SuccessFailure=AuditFlags[AuditCategory];
			Flag=0;
			
			if(SuccessFailure & TYPE_SUCCESS) {
				Flag |= POLICY_AUDIT_EVENT_SUCCESS;
			}
			
			if(SuccessFailure & TYPE_FAILURE) {
				Flag |= POLICY_AUDIT_EVENT_FAILURE;
			}
			
			// If the current settings mirror what we want, don't change anything.
			if((Flag == 0 && (AuditEvents->EventAuditingOptions[AuditCategory] &
				(POLICY_AUDIT_EVENT_SUCCESS | POLICY_AUDIT_EVENT_FAILURE)) == 0) ||
				Flag && AuditEvents->EventAuditingOptions[AuditCategory]) {
				Flag=POLICY_AUDIT_EVENT_UNCHANGED;
			} else if(Flag==0) {
				Flag=POLICY_AUDIT_EVENT_NONE;
			}
			
			if(Flag != POLICY_AUDIT_EVENT_UNCHANGED) {
				Status = SetAuditEvent(PolicyHandle,AuditCategory,Flag);
				AuditChanged=1;
			}
		}

		if(AuditChanged) {
			// 
			// enable audits 
			// 
			if( Status == 0 ) {
				Status = SetAuditMode(PolicyHandle, TRUE);
			}
		}

		LsaClose(PolicyHandle);
	}
 
	return(1);
}








/*

// Turn an audit category on or off
BOOL SwitchAudit(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure, BOOL Switch)
{
	// AuditCategorySystem, AuditCategoryLogon, AuditCategoryObjectAccess,
	// AuditCategoryPrivilegeUse, AuditCategoryDetailedTracking,
	// AuditCategoryPolicyChange, AuditCategoryAccountManagement,
	// AuditCategoryDirectoryServiceAccess, AuditCategoryAccountLogon

	LPWSTR wComputerName = NULL; 
    LSA_HANDLE PolicyHandle; 
    NTSTATUS Status; 
	PPOLICY_AUDIT_EVENTS_INFO AuditEvents;
	LSA_OBJECT_ATTRIBUTES ObjectAttributes; 
	DWORD Flag=0;

	ZeroMemory(&ObjectAttributes, _countof(ObjectAttributes));

	Status = LsaOpenPolicy(NULL, &ObjectAttributes, POLICY_VIEW_AUDIT_INFORMATION | POLICY_SET_AUDIT_REQUIREMENTS, &PolicyHandle);

	if(Status == 0) {
		Status = LsaQueryInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (void **) &AuditEvents); 
 
	    if(Status != 0) return 0; 
 
	    // 
	    // successfully obtained AuditEventsInformation. 
	    // 
		// If audit is not turned on
	    if(AuditEvents->AuditingMode == 0) {
			// In theory, we need to turn on auditing.
			AuditEvents->AuditingMode = 1;
			Status = LsaSetInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (PVOID) AuditEvents); 
		}

		if(SuccessFailure & TYPE_SUCCESS) {
			if(Switch==1) {
				Flag |= POLICY_AUDIT_EVENT_SUCCESS;
			}
		}

		if(SuccessFailure & TYPE_FAILURE) {
			if(Switch==1) {
				Flag |= POLICY_AUDIT_EVENT_FAILURE;
			}
		}

		// If the current settings mirror what we want, don't change anything.
		if((Flag == 0 && (AuditEvents->EventAuditingOptions[AuditCategory] &
			(POLICY_AUDIT_EVENT_SUCCESS | POLICY_AUDIT_EVENT_FAILURE)) == 0) ||
			Flag && AuditEvents->EventAuditingOptions[AuditCategory]) {
			Flag=POLICY_AUDIT_EVENT_UNCHANGED;
		} else if(Flag==0) {
			Flag=POLICY_AUDIT_EVENT_NONE;
		}
		
		if(Flag != POLICY_AUDIT_EVENT_UNCHANGED) {
			Status = SetAuditEvent(PolicyHandle,AuditCategory,Flag);
 			// 
			// enable audits 
			// 
			if( Status == 0 ) {
				Status = SetAuditMode(PolicyHandle, TRUE);
			}
		}

		LsaClose(PolicyHandle);
	}
 
	return(1);
} */



int SetAuditEvent(LSA_HANDLE PolicyHandle, POLICY_AUDIT_EVENT_TYPE EventType,
					   POLICY_AUDIT_EVENT_OPTIONS EventOption)
{ 
    PPOLICY_AUDIT_EVENTS_INFO pae; 
    NTSTATUS Status; 
    DWORD i; // index into EventAuditingOptions 
 
    // 
    // obtain AuditEvents 
    // 
    Status = LsaQueryInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                (void **)&pae 
                ); 
 
    if(Status != 0) return Status; 
 
    // 
    // ensure we were passed a valid EventType and EventOption 
    // 
    if((ULONG)EventType > pae->MaximumAuditEventCount) {
		LsaFreeMemory(pae);
		if(SNAREDEBUG >= 9) { DebugMsg("Invalid eventtype."); }
        return -1; 
	}
		
	if(!(EventOption & POLICY_AUDIT_EVENT_MASK)) { 
        LsaFreeMemory(pae); 
		if(SNAREDEBUG >= 9) { DebugMsg("Invalid eventoption"); }
        return -1; 
    } 
 
    // 
    // set all auditevents to the unchanged status... 
    // 
    for(i = 0 ; i < pae->MaximumAuditEventCount ; i++) { 
        pae->EventAuditingOptions[i] = POLICY_AUDIT_EVENT_UNCHANGED; 
    } 
 
    // 
    // ...and update only the specified EventType 
    // 
    pae->EventAuditingOptions[EventType] = EventOption; 
 
    // 
    // set the new AuditEvents 
    // 
    Status = LsaSetInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                pae 
                ); 
 
    // 
    // free allocated memory 
    // 
    LsaFreeMemory(pae); 
 
    return Status; 
} 

int SetAuditMode(LSA_HANDLE PolicyHandle, BOOL bEnable)
{ 
    PPOLICY_AUDIT_EVENTS_INFO AuditEvents; 
    NTSTATUS Status; 
    DWORD i; 
 
    // 
    // obtain current AuditEvents 
    // 
    Status = LsaQueryInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                (void **)&AuditEvents 
                ); 
 
    if(Status != 0) return Status; 
 
    // 
    // update the relevant member 
    // 
    AuditEvents->AuditingMode = bEnable; 
 
    // 
    // set all auditevents to the unchanged status... 
    // 
    for(i = 0 ; i < AuditEvents->MaximumAuditEventCount ; i++) { 
        AuditEvents->EventAuditingOptions[i] = POLICY_AUDIT_EVENT_UNCHANGED; 
    } 
 
    // 
    // set the new auditing mode (enabled or disabled) 
    // 
    Status = LsaSetInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                AuditEvents 
                ); 
 
    LsaFreeMemory(AuditEvents); 
 
    return Status; 
} 


// Linked List Functions

void CreateLinkedList(void)
{
    head = currentnode = NULL;
	if(SNAREDEBUG >= 7) { DebugMsg("initialising currentnode"); }
	currentnode->next = NULL;
}

int IsListEmpty(void)
{
    if (NULL == head)
        return 1;
    else
        return 0;
}

static Node * AddToList(int eventnumber, char *username, char *match, int criticality, int excludeflag,
				 int muserflag, int eventlogtype, int sourcename)
{
    static Node *newNode=NULL;

    if(SNAREDEBUG >= 7) DebugMsg("AddToList()");

	if(!username || !match) {
		return(NULL);
	}

    newNode = (Node *) malloc(sizeof(Node));

    if (newNode == NULL) {
        if(SNAREDEBUG >= 7) DebugMsg("AddToList(): error in dynamic memory allocation\nCould not add a new objective into our linked list. You may be low on memory.\n");
        return(NULL);
    }

	newNode->event_number=eventnumber;
	newNode->criticality=criticality;
	newNode->excludeflag=excludeflag;
	newNode->muserflag=muserflag;
	newNode->eventlogtype=eventlogtype;
	newNode->sourcename=sourcename;

	strncpy_s(newNode->username,_countof(newNode->username),username,_TRUNCATE);
	strncpy_s(newNode->match,_countof(newNode->username),match,_TRUNCATE);
	
    if (head == NULL) {
        head = newNode;
        newNode->next = NULL;
    } else {
        newNode->next = head;
        head = newNode;
    }

    return newNode;
}

void RemoveFromListHead(void)
{
    Node *tempPtr;

    if (NULL == head)
        return;

    tempPtr = head;
    head = head->next;

    free(tempPtr);
}

void RemoveFromList(Node* node)
{
    Node *tempPtr, *previousPtr;

    if (NULL == node) {
        return;
	}

    if (head == node) {
        RemoveFromListHead();
        return;
    }

    tempPtr = head;

    while (NULL != tempPtr) {
        previousPtr = tempPtr;
        tempPtr = tempPtr ->next;

        if (tempPtr == node) {
            previousPtr->next = tempPtr->next;
            free(tempPtr);
            break;
        }
    }
}

void ResetCurrentNode(void)
{
    currentnode = head;
	if(SNAREDEBUG >= 7) { DebugMsg("re-initialising currentnode to head"); }
}

int IsValidItem(void)
{
    return ((NULL == currentnode) ? 0 : 1);
}

Node * GetCurrentItem()
{
    return (currentnode);
}

void NextItemInList(void)
{
	if (NULL == currentnode) {
        return;
	}
    currentnode = currentnode->next;
	if(SNAREDEBUG >= 7) { DebugMsg("currentnode is moving to the next item"); }
}

void DestroyList(void)
{
	DWORD dwWaitRes=0;
	MsgCache *temp;
	USBMsg *temp2;
    if (NULL == head) {
        return;
    }
	usb_msg = usb_msg_head;
	while (usb_msg) {
		temp2 = usb_msg;
		usb_msg = usb_msg->next;
		free(temp2);
	}
	usb_msg_head=NULL;
	usb_msg_tail=NULL;
	usb_msg=NULL;
	MCCount=0;
	while(hosthead) {
		HostNode *th;
		th = hosthead;
		hosthead = th->next;
		if (th->Socket != INVALID_SOCKET) closesocket(th->Socket);
		free(th);
	}
	hosthead=NULL;
	hostcurrentnode=NULL;
    while (NULL != head) {
        Node *tempPtr = head;
        head = head->next;

        free(tempPtr);
    }
	head = NULL;
	currentnode=NULL;
	dwWaitRes = WaitForSingleObject(hMutex,1000);
	//We should be the only ones, so success or fail, we need to get rid of this list
	MCCurrent = MCHead;
	while (MCCurrent) {
		temp = MCCurrent;
		MCCurrent = MCCurrent->next;
		free(temp);
	}
	ReleaseMutex(hMutex);
	MCHead=NULL;
	MCTail=NULL;
	MCCurrent=NULL;
	MCCount=0;
}


void CSnarecoreService::OnShutdown() {
	// Audit: Set that global variable to TRUE so that the threads
	// receive the terminate message

	g_Info.bTerminate=TRUE;
	
	if(SNAREDEBUG >= 2) { DebugMsg("SNARE Shutdown request received"); }

	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);

	// Call a fake event so that the subroutine	gets the shutdown message
	// through the setting of g_Info.bTerminate
	if(m_hEventList[0])
		::SetEvent(m_hEventList[0]);
}

void CSnarecoreService::OnStop() {
	g_Info.bTerminate=TRUE;
	
	if(SNAREDEBUG >= 2) { DebugMsg("SNARE Stop request received"); }
	
	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);

	// Call a fake event so that the subroutine	gets the shutdown message
	// through the setting of g_Info.bTerminate
	if(m_hEventList[0])
		::SetEvent(m_hEventList[0]);
}

void CSnarecoreService::OnSignal() {
	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);
}

// Process user control requests
BOOL CSnarecoreService::OnUserControl(DWORD dwOpcode)
{
    switch (dwOpcode) {
    case SERVICE_CONTROL_USER + 0:

        // Save the current status in the registry
        SaveStatus();
        return TRUE;

    default:
        break;
    }
    return FALSE; // say not handled
}

// Save the current status in the registry
void CSnarecoreService::SaveStatus()
{
	// Save off our current position in each of our log files.
	MyWriteProfileDWORD("Status","LOG_TYPE_SECURITY",dwEventIDRead[0]);
	MyWriteProfileDWORD("Status","LOG_TYPE_SYSTEM",dwEventIDRead[1]);
	MyWriteProfileDWORD("Status","LOG_TYPE_APPLICATION",dwEventIDRead[2]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DS",dwEventIDRead[3]);
	MyWriteProfileDWORD("Status","LOG_TYPE_DNS",dwEventIDRead[4]);
	MyWriteProfileDWORD("Status","LOG_TYPE_FRS",dwEventIDRead[5]);
}


// Configuration reading routines

void GetHostname(char * Hostname,int size)
{
	// Grab the fully qualified hostname
	// Note: if the user has explicitly set a hostname in the registry, use that instead.

	if(!Hostname) return;
	if(!size) return;

	Hostname[0]='\0';
	MyGetProfileString("Config","Clientname",Hostname,size);
	if(Hostname[0]=='\0') {
		GetFQDN(Hostname,size);
	}
}

void GetDestPort(DWORD * dwDestPort)
{
	if(!dwDestPort) return;
	// Where should we be sending this stuff (syslog ID)
	*dwDestPort=MyGetProfileDWORD("Network","DestPort",6161);
}

void GetCrit(DWORD * dwCrit)
{
	if(!dwCrit) return;
	*dwCrit=MyGetProfileDWORD("Config","CritAudit",0);
}

void GetSyslog(DWORD * dwSyslog)
{
	if(!dwSyslog) return;
	*dwSyslog=MyGetProfileDWORD("Network","SyslogDest",13);
}

void GetSyslogDynamic(DWORD * dwSyslogDynamic)
{
	if(!dwSyslogDynamic) return;
	*dwSyslogDynamic=MyGetProfileDWORD("Network","SyslogDynamicCritic",0);
}

void GetSyslogHeader(DWORD * dwSyslogHeader)
{
	if(!dwSyslogHeader) return;
	*dwSyslogHeader=MyGetProfileDWORD("Network","Syslog",0);
}

void GetWEBSERVER_ACTIVE(DWORD * WEBSERVER_ACTIVE)
{
	//if(!WEBSERVER_ACTIVE) return;
	*WEBSERVER_ACTIVE=MyGetProfileDWORD("Remote","Allow",0);
}

void GetPortNumber(DWORD * dwPortNumber)
{
	DWORD dwUsePort;

	if(!dwPortNumber) return;
	*dwPortNumber=6161;
	dwUsePort=MyGetProfileDWORD("Remote","WebPortChange",0);
	if(dwUsePort) {
		*dwPortNumber=MyGetProfileDWORD("Remote","WebPort",6161);
	}
}

void GetChecksum(BOOL *ActivateChecksum)
{
	DWORD Check=0;
	Check=MyGetProfileDWORD("Config","Checksum",0);
	*ActivateChecksum = (BOOL)Check;
}

void GetDestination(char * lpszDestination,int size)
{
	if(!lpszDestination) return;
	if(!size) return;
	
	strncpy_s(lpszDestination,size,"127.0.0.1",_TRUNCATE);
	if(!MyGetProfileString("Network","Destination",lpszDestination,size))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		MyWriteProfileString("Network","Destination",lpszDestination);
	}
}

void GetDelim(char * DELIM,int size)
{
	if(!DELIM) return;
	if(size < 2) return;

	DELIM[0]=9;	// TAB character
	DELIM[1]='\0';
	// Only use a different character for delimiters if we're sending data via syslog.
	MyGetProfileString("Config","Delimiter",DELIM,size);
}

void GetPassword(char * lpszPassword,int size)
{
	DWORD dwUsePassword;

	if(!lpszPassword) return;
	if(!size) return;

	strncpy_s(lpszPassword,size,"",_TRUNCATE);
	dwUsePassword=MyGetProfileDWORD("Remote","AccessKey",0);
	if(dwUsePassword) {
		if(!MyGetProfileString("Remote","AccessKeySet",lpszPassword,size))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strncpy_s(lpszPassword,size,"",_TRUNCATE);
		}
	}
}

void GetIPAddress(char * lpszIPAddress,int size)
{
	DWORD dwRestrictIP;

	if(!lpszIPAddress) return;
	if(!size) return;

	strncpy_s(lpszIPAddress,size,"",_TRUNCATE);
	dwRestrictIP=MyGetProfileDWORD("Remote","Restrict",0);

	if(dwRestrictIP) {
		if(!MyGetProfileString("Remote","RestrictIP",lpszIPAddress,SIZE_OF_RESTRICTIP))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strncpy_s(lpszIPAddress,size,"127.0.0.1",_TRUNCATE);
		}
	}
}

void GetClearTabs(DWORD * ClearTabs)
{
	if(!ClearTabs) return;
	// If the user SPECIFICALLY does not want TABS in the output,
	// even IF the delimiter is not a TAB:
	*ClearTabs=MyGetProfileDWORD("Config","ClearTabs",0);
}


void GetSocketType(DWORD * SocketType)
{
	if(!SocketType) return;
	*SocketType=MyGetProfileDWORD("Network","SocketType",0);
}


FILE * GetOutputFile() {
	DWORD FileExport=0;
	char tempdir[1024]="";
	char tempdir2[1024];
	int returncode=0;
	time_t currenttime;
	struct tm newtime;
	FILE * fp;
	errno_t err;

	FileExport=MyGetProfileDWORD("Config","FileExport",0);
	if(!FileExport) {
		return(NULL);
	}
	
	// Ok, the user wants to save the data off to a file.
	// Pull back our directory location.
	ExpandEnvironmentStrings("%SystemRoot%\\system32\\LogFiles",tempdir,1024);
	returncode=DirExists(tempdir);
	if(returncode== -1) {
		return(NULL);
	}
	if(returncode==0) {
		// Create it...
		returncode=CreateDirectory(tempdir,NULL);
		if(!returncode) {
			return(NULL);
		}
	}
	ExpandEnvironmentStrings("%SystemRoot%\\system32\\LogFiles\\Snare",tempdir,1024);
	returncode=DirExists(tempdir);
	if(returncode== -1) {
		return(NULL);
	}
	if(returncode==0) {
		// Create it...
		returncode=CreateDirectory(tempdir,NULL);
		if(!returncode) {
			return(NULL);
		}
	}

	time(&currenttime);                
	localtime_s(&newtime,&currenttime);
	_snprintf_s(tempdir2,_countof(tempdir2),_TRUNCATE,"%s%04d%02d%02d.log","%SystemRoot%\\system32\\LogFiles\\Snare\\",newtime.tm_year+1900,newtime.tm_mon+1,newtime.tm_mday);
	ExpandEnvironmentStrings(tempdir2,tempdir,1024);
	err = fopen_s(&fp,tempdir,"a");
	return(fp);

}

int DirExists(char * dir)
{
    WIN32_FIND_DATA data;
    HANDLE hFile = FindFirstFile(dir, &data);

	if(!dir) {
		return(-1);
	}

    if (hFile == INVALID_HANDLE_VALUE) { // directory doesn't exist
        return FALSE;
    } else {
        // is it folder or file?
        FindClose(hFile);
        if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
            return TRUE;
		}
        return -1;
    }
}

// END Configuration Reading Routines

int StartWebThread(HANDLE event)
{
	int threadid=0;
	
	threadid=(int)_beginthread( HandleWebThread, 0, event );
	if(SNAREDEBUG >= 5) { DebugMsg("DEBUG: Starting web thread %d..",threadid); }
	if(threadid==-1)
	{
		if(SNAREDEBUG >= 5) DebugMsg("Error in web thread creation");
		return(-1);
	}
	return(1);
}

void HandleWebThread(HANDLE event)
{
	HANDLE web_hEventList[2]; // seven elements at the moment.
	time_t currenttime,lasttime;
	DWORD dwWaitRes=0;
	DWORD dwWaitReset=0;
	
	time(&lasttime);
	// Web server
	web_hEventList[0] = CreateEvent(NULL, TRUE, FALSE, NULL);

	// Web server reset
	web_hEventList[1] = CreateEvent(NULL, TRUE, FALSE, NULL);
	
	if(web_hEventList[0] == NULL)
	{	if(SNAREDEBUG >= 5) { DebugMsg("CreateEvent() Web Server failed"); }	_endthread();	}
	if(web_hEventList[1] == NULL)
	{	if(SNAREDEBUG >= 5) { DebugMsg("CreateEvent() Web Server Reset failed"); }	_endthread();	}

	if(SNAREDEBUG >= 5) { DebugMsg("Starting HandleWebThread."); }
	StartThread(web_hEventList[0]);
	//while (m_bIsRunning) {
	while (1) {
		dwWaitRes=WaitForMultipleObjects(2,web_hEventList,FALSE,500);
		if(dwWaitRes != WAIT_FAILED) {
			if(dwWaitRes == WAIT_OBJECT_0) {
				// Web server has data to read.
				ResetEvent(web_hEventList[0]);
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Connect."); }

				if(WEBSERVER_ACTIVE) {
					// Let handleconnect have the eventlist pointer, in case it needs
					// to signal a restart
					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: About to HandleConnect"); }
					HandleConnect(web_hEventList[1]);

					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: Running thread again."); }
					StartThread(web_hEventList[0]);
				}
				
				continue;
			} else if (dwWaitRes == WAIT_OBJECT_0+1) {
			// We need to re-read our configuration file.
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Reset."); }
				ResetEvent(web_hEventList[1]);
			    
				WebResetFlag=FULL_WEB_RESET;
				//don't end straigh away, we need to finish handling any other connections, just sleep for now
				//Sleep(10);
				SetEvent(event);
				_endthread();

				continue;
			} else if (dwWaitRes == WAIT_TIMEOUT) {
				// For the time being, we want to reset the web server every 20 mins
				// This is done using the last values that were grabbed
				time(&currenttime);
				if ((currenttime - lasttime) > DNS_CHECK_TIME) {
					lasttime=currenttime;
					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Timeout Reset."); }
					WebResetFlag=BASIC_WEB_RESET;
					SetEvent(event);
					//Sleep(10);
					_endthread();
				}
			}
		}
	}
	
	_endthread();
}

// Duplicate of the CNTService DebugMsg
void DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[50];
	char time[50];

	if(!pszFormat) return;
	
	SYSTEMTIME st;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,_countof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,_countof(time));

	_snprintf_s(buf, 8192,_TRUNCATE, "[SNARE %s](%lu - %s %s): ",SNARE_VERSION,GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf_s(&buf[strlen(buf)],8192-strlen(buf),_TRUNCATE,pszFormat,arglist);
	va_end(arglist);
    _snprintf_s(buf,8192,_TRUNCATE,"%s\n",buf);

	if(buf) { printf("%s",buf); fflush(stdout); }

#ifdef DEBUG_TO_FILE
	FILE *fp;
	errno_t err;

	if(!strlen(pszFormat)) {
		// Send a "" to truncate the file back to zero
		err=fopen_s(&fp,"C:\\SNAREDebug.log","wt");
	} else {
		err=fopen_s(&fp,"C:\\SNAREDebug.log","a");
	}
	if(fp) {
		fprintf(fp,"%s",buf);
		fflush(fp);
		fclose(fp);
	}
#endif
}

// Dump the current eventlog record to a file.
void DEBUGDumpEventLog(DWORD EventTriggered,DWORD dwBytesRead,PEVENTLOGRECORD pELR)
{
	FILE *fp;
	errno_t err;
	err = fopen_s(&fp, "SNAREEvt.log","w");
	if(!err) {
		
		fwrite(&EventTriggered,sizeof(EventTriggered),1,fp);
		fwrite(pELR,dwBytesRead,1,fp);
		fflush(fp);
		fclose(fp);
	}
}
