// SNARE - Audit / EventLog analysis and forwarding
// Copyright 2001-2006 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// See Readme.txt file for more information.
//
// NOTE: Use the \data\64bit.bat file to compile in 64 bit mode!!!!
#include <stdio.h>
#include <stdlib.h>
#include <winsock2.h>
#include <windows.h>
#include <time.h>
#include <tchar.h>
#include <sys/stat.h>
#include <winevt.h>

#include "NTServApp.h"
#include "SnareCore.h"
#include "webserver.h"
#include "MD5.h"
#include "Version.h"


// memory testing only
//#define MEMDEBUG 1

#ifdef MEMDEBUG
// MEMORY LEAK DETECTION ROUTINES
	// #define _CRTDBG_MAP_ALLOC
	#define CRTDBG_MAP_ALLOC
	#include <stdlib.h>
	#include <crtdbg.h>
#endif

//#define DEBUG_TO_FILE 1

// Quick function proto
void DebugMsg(const char* pszFormat, ...);


// Pull this from registry
DWORD			WEBSERVER_ACTIVE = 0;
EVT_HANDLE m_hEventSys = NULL;   // Handle to the event subscriber.
EVT_HANDLE m_hEventSec = NULL;   // Handle to the event subscriber.
EVT_HANDLE m_hEventApp = NULL;   // Handle to the event subscriber.

DWORD			g_dwLastError			= 0L;
char			Hostname[100];
ThreadStruct	g_Info;
//SOCKET *		g_hSockets;						// Array of socket pointers - one for each destination.
//char **			SocketNames;					// HostNames for each of the sockets.
//int				SocketCount=0;
//SOCKET			g_hSocket = INVALID_SOCKET;     // client/server socket, used in for/next loops.
int				nStopListening=0;
DWORD			dwEventIDRead[6];				// maintain entries for those events that we have already read.
wchar_t			szEventIDRead[6][SIZE_EVENTREAD];				// maintain entries for those events that we have already read.
DWORD			dwEventIDSize;
EVT_HANDLE		hEvtBookmark[6];
DWORD			dwEventIDOldest[6];				// Save off the 'oldest' entry in each list, so we know when to rotate.
DWORD			dwEventLogCleared[6];			// Used to flag when an event log has been cleared, during normal operations
TCHAR			DELIM[2]="	";					// TAB

int				AuditFlags[9];					// Array of audit flags to set.
												// Note: Increase this if the POLICY_AUDIT_EVENTTYPE grows in ntsecapi.h

int				SNAREDEBUG=0;

static Node *head, *currentnode;

// Host target list
static HostNode *hosthead, *hostcurrentnode;

int MCCount=0;
MsgCache *MCHead=NULL;
MsgCache *MCTail=NULL;
MsgCache *MCCurrent=NULL;

int EventCount=0;
MsgCache *EventHead=NULL;
MsgCache *EventTail=NULL;
MsgCache *EventCurrent=NULL;

// Locker
HANDLE hMutex;
DWORD WebResetFlag=0;

CSnarecoreService::CSnarecoreService()
:CNTService("SNARE")
{
	//TODO: Initialize your class members here
}

BOOL CSnarecoreService::OnInit()
{
	char szError[MAX_STRING];
	//TODO: Perform any initialization that needs to be done before entering the main loop

	SNAREDEBUG=this->DEBUGSET;

	if( !InitWinsock( szError,_countof(szError) ) )
	{
		if(SNAREDEBUG >= 9) { DebugMsg(szError); }
		return FALSE;
	}

	m_hEventList = CreateEvent(NULL, TRUE, FALSE, NULL);

	if(m_hEventList == NULL)
	{	if(SNAREDEBUG >= 9) { DebugMsg("CreateEvent() Web notification failed"); }	return FALSE;	}


	hMutex = CreateMutex(NULL,FALSE,"SnareAgentLock");
	if(hMutex == NULL) {
		if(SNAREDEBUG >= 9) { DebugMsg("I cannot create the Snare Agent 'Mutex' lock. This probably means that you already have another instance of the Snare Agent running.\nPlease stop the other incarnation of the Snare Agent (eg: net stop snare) before continuing."); }
		return FALSE;
	}

	wchar_t *szApplication = L"Application";   // Channel.
	wchar_t *szSecurity = L"Security";   // Channel.
	wchar_t *szSystem = L"System";   // Channel.
	wchar_t *szQuery = L"*";   // XPATH Query to specify which events to subscribe to.

	if (MyGetProfileWString("Status",L"LOG_TYPE_SECURITY",szEventIDRead[0],_countof(szEventIDRead[0]))) {
		hEvtBookmark[0] = EvtCreateBookmark(szEventIDRead[0]);

		// Register the subscription.
		m_hEventSec = EvtSubscribe( 
			NULL,					 //Session
			NULL,                    // Used for pull subscriptions.
			szSecurity,              // Channel.
			szQuery,                 // XPath query.
			hEvtBookmark[0],               // Bookmark.
			NULL,                    // CallbackContext.
			(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,  // Callback.
			EvtSubscribeStartAfterBookmark   // Flags.
			);
	} else {
		hEvtBookmark[0] = EvtCreateBookmark(NULL);
		// Register the subscription.
		m_hEventSec = EvtSubscribe(NULL,NULL,szSecurity,szQuery,NULL,NULL,(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,EvtSubscribeToFutureEvents);
	}
	if (MyGetProfileWString("Status",L"LOG_TYPE_SYSTEM",szEventIDRead[1],_countof(szEventIDRead[1]))) {
		hEvtBookmark[1] = EvtCreateBookmark(szEventIDRead[1]);
	m_hEventSys = EvtSubscribe(NULL,NULL,szSystem,szQuery,hEvtBookmark[1],NULL,(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,EvtSubscribeStartAfterBookmark);
	} else {
		hEvtBookmark[1] = EvtCreateBookmark(NULL);
	m_hEventSys = EvtSubscribe(NULL,NULL,szSystem,szQuery,NULL,NULL,(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,EvtSubscribeToFutureEvents);
	}

	if (MyGetProfileWString("Status",L"LOG_TYPE_APPLICATION",szEventIDRead[2],_countof(szEventIDRead[2]))) {
		hEvtBookmark[2] = EvtCreateBookmark(szEventIDRead[2]);
		m_hEventApp = EvtSubscribe(NULL,NULL,szApplication,szQuery,hEvtBookmark[2],NULL,(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,EvtSubscribeStartAfterBookmark);
	} else {
		hEvtBookmark[2] = EvtCreateBookmark(NULL);
		m_hEventApp = EvtSubscribe(NULL,NULL,szApplication,szQuery,NULL,NULL,(EVT_SUBSCRIBE_CALLBACK) EventSubCallBack,EvtSubscribeToFutureEvents);
	}

	if( !m_hEventApp  || !m_hEventSys  || !m_hEventSec) {
		if(SNAREDEBUG >= 9) { DebugMsg("Couldn't Subscribe to Events!. Error = 0x%x", GetLastError()); }
		return FALSE;
	}  

	if(SNAREDEBUG >= 9) { DebugMsg("SNARE Initialisation complete"); }
#ifdef DEBUG_TO_FILE
	//DMM testing only, REMOVE
	SNAREDEBUG=9;
#endif
	DebugMsg("SNAREDEBUG: %d", SNAREDEBUG);
	// return FALSE here if initialization failed & the service shouldn't start
	return TRUE;
}

DWORD WINAPI EventSubCallBack(EVT_SUBSCRIBE_NOTIFY_ACTION Action, PVOID Context, EVT_HANDLE Event)
{
	WCHAR *pBuff = NULL;
	DWORD dwBuffSize = 0;
	DWORD dwBuffUsed = 0;
	DWORD dwRes = 0;
	DWORD dwWaitRes =0;
	DWORD dwPropertyCount = 0;
	UINT EventTriggered=0;
	char SubmitTime[26];

	// Create a context for rendering all event system properties to values.
	EVT_HANDLE renderContext = EvtCreateRenderContext(
		NULL, 0, EvtRenderContextSystem);

	PBYTE pValues = NULL;      
	DWORD dwValueSize = 0;
	// Get the XML EventSize to allocate the buffer size.
	BOOL bRet = EvtRender(  
		renderContext,       // Session.
		Event,               // HANDLE.
		EvtRenderEventValues,   // Flags.                                              
		dwValueSize,          // BufferSize.
		pValues,               // Buffer.
		&dwValueSize,         // Buffersize that is used or required.
		&dwPropertyCount);

	if (!bRet) {
		dwRes = GetLastError();
		if( dwRes == ERROR_INSUFFICIENT_BUFFER ) {
			// Allocate the buffer size needed to for the XML event.
			//dwBuffSize = dwBuffUsed;
			//pBuff = new WCHAR[dwBuffSize/sizeof(WCHAR)];
			pValues = new BYTE[dwValueSize];
            
			//Get the Event XML
			bRet = EvtRender(   
				renderContext,        // Session.
				Event,                // HANDLE.
				EvtRenderEventValues,    // Flags.                                              
				dwValueSize,           // BufferSize.
				pValues,                // Buffer.
				&dwValueSize,          // Buffer size that is used or required.
				&dwPropertyCount);

			if( !bRet ) {
				if(SNAREDEBUG >= 6) DebugMsg("Couldn't Render Events!. Error = 0x%x", GetLastError());
				delete[] pValues;
				EvtClose(renderContext);
				return dwRes;
            }
		} else {
			if(SNAREDEBUG >= 6) DebugMsg("Couldn't Render Events!. Error = 0x%x", dwRes);
			delete[] pValues;
			EvtClose(renderContext);
			return dwRes;
		}
    }    
    //Display the Event XML on console
	//if(SNAREDEBUG >= 9) DebugMsg("The following Event is received : \n %s \n\n", pValues);
	PEVT_VARIANT valArray = PEVT_VARIANT(pValues);

	// Process vallArray here
	for(int i=0; i < dwPropertyCount; i++)
	{
	//	// Process a property in valArray[i].
		if (valArray[i].Type == 17) {

			SYSTEMTIME st;
			FILETIME ft;
			FileTimeToLocalFileTime((FILETIME *)&valArray[i].FileTimeVal,&ft);
			FileTimeToSystemTime(&ft,&st);
			char subtime[32];
			
			GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"ddd MMM dd ",subtime,_countof(subtime));
			strncpy_s(SubmitTime,_countof(SubmitTime),subtime,_TRUNCATE);
			GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss ",subtime,_countof(subtime));
			strncat_s(SubmitTime,_countof(SubmitTime),subtime,_TRUNCATE);
			GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"yyyy",subtime,_countof(subtime));
			strncat_s(SubmitTime,_countof(SubmitTime),subtime,_TRUNCATE);
			break;
		}
	}

	EVT_HANDLE hPubConfig = EvtOpenPublisherMetadata( NULL, valArray[0].StringVal, NULL, NULL, 0);

	bRet = EvtFormatMessage(hPubConfig, Event, NULL, dwPropertyCount, valArray, 9, dwBuffSize, pBuff, &dwBuffUsed);
	if (SNAREDEBUG >= 3) DebugMsg("got message");

	//pBuff = new WCHAR[4096];

	//keyword = audit success,classic
	//Task = category
	//opcode = info
	//Level = information
	//<Event xmlns='http://schemas.microsoft.com/win/2004/08/events/event'>
	//<System>
	//	<Provider Name='VMTools'/>
	//	<EventID Qualifiers='0'>108</EventID>
	//	<Level>4</Level>
	//	<Task>0</Task>
	//	<Keywords>0x80000000000000</Keywords>
	//	<TimeCreated SystemTime='2007-03-07T04:23:08.000Z'/>
	//	<EventRecordID>1256</EventRecordID><
	//	<Channel>Application</Channel>
	//	<Computer>vista</Computer>
	//	<Security/>
	//</System>
	//<EventData></EventData>
	//<RenderingInfo Culture='en-AU'>
	//	<Message>The service was stopped.</Message>
	//	<Level>Information</Level>
	//	<Opcode>Info</Opcode>
	//	<Keywords><Keyword>Classic</Keyword></Keywords>
	//</RenderingInfo>
	//</Event>

	//EventLogSourceName	= XML Channel
	//SubmitTime			= XML TimeCreated
	//EventID				= XML EventID
	//Source				= XML Provider Name
	// Username				= XML Security UserID
	// UserType				= NA
	//EventLogType			= XML Level
	//computername			= XML Computer
	//category				= XML 
	//data
	//Strings				= EvtFormatMessageEvent

	if (!bRet) {
		dwRes = GetLastError();
		if (SNAREDEBUG >= 3) DebugMsg("EvtFormatMessage Error: %d", dwRes);
		//regardless of the error, try again anyway
		//if( dwRes == ERROR_INSUFFICIENT_BUFFER ) {
			// Allocate the buffer size needed to for the XML event.
			dwBuffSize = dwBuffUsed;
			pBuff = new WCHAR[dwBuffSize/sizeof(WCHAR)];
			bRet = EvtFormatMessage(hPubConfig, Event, NULL, dwPropertyCount, valArray, 9, dwBuffSize, pBuff, &dwBuffUsed);
		//}
		if (!bRet) {
			dwRes = GetLastError();
			if (SNAREDEBUG >= 3) DebugMsg("EvtFormatMessage Error 2: %d", dwRes);
			delete[] pBuff;
			delete[] pValues;
			EvtClose(renderContext);
			EvtClose(hPubConfig);
			return dwRes;
		}
	}
	MsgCache *ecur;
	ecur = (MsgCache *)malloc(sizeof(MsgCache));
	if (ecur) {
		strncpy_s(ecur->ComputerName,_countof(ecur->ComputerName),"unknown",_TRUNCATE);
		ecur->criticality=0;
		ecur->SnareCounter=0;
		strncpy_s(ecur->SubmitTime,_countof(ecur->SubmitTime),"not yet",_TRUNCATE);
		ecur->ShortEventID;
		strncpy_s(ecur->SourceName, 100, "Unknown",_TRUNCATE);
		strncpy_s(ecur->EventLogSourceName, _countof(ecur->EventLogSourceName), "System",_TRUNCATE);
		strncpy_s(ecur->UserName, 256, "N/A",_TRUNCATE);
		strncpy_s(ecur->SIDType, 100, "N/A",_TRUNCATE);
		strncpy_s(ecur->EventLogType, 60, "Information",_TRUNCATE);
		strncpy_s(ecur->szCategoryString, 256, "None",_TRUNCATE);
		ecur->DataString[0] = '\0';
		ecur->szTempString[0] = '\0';
		ecur->EventLogCounter=0;
		ecur->seenflag=0;
		ecur->next=NULL;
		ecur->prev=NULL;
		char tempevent[8192],tempvar[8192];
		char *start,*end;
		WideCharToMultiByte(CP_ACP,0,pBuff,-1,tempevent,8192,NULL,NULL);
		if (SNAREDEBUG >= 3) DebugMsg("%s",tempevent);
		//computername			= XML Computer
		start = strstr(tempevent,"<Computer");
		if (start) {
			start = strstr(start,">");
			if (start) {
				start = start+1;
				end = strstr(start,"<");
				if (end) {
					strncpy_s(ecur->ComputerName,_countof(ecur->ComputerName),start,end-start);
				}
			}
		}
		ecur->criticality = 0;
		ecur->SnareCounter = 0;
		////SubmitTime			= XML TimeCreated
		strncpy_s(ecur->SubmitTime, 26,SubmitTime,_TRUNCATE);
		////EventID				= XML EventID
		start = strstr(tempevent,"<EventID");
		if (start) {
			start = strstr(start,">");
			if (start) {
				start = start+1;
				end = strstr(start,"<");
				if (end) {
					strncpy_s(tempvar, _countof(tempvar), start,end-start);
					ecur->ShortEventID = atoi(tempvar);
				}
			}
		}
		////EventLogSourceName				= XML Channel
		start = strstr(tempevent,"<Channel");
		if (start) {
			start = strstr(start,">");
			if (start) {
				start = start+1;
				end = strstr(start,"<");
				if (end) {
					strncpy_s(ecur->EventLogSourceName, _countof(ecur->EventLogSourceName), start,end-start);
					if (strstr(ecur->EventLogSourceName,"Security") != NULL) {
						EventTriggered = 0;
					} else if (strstr(ecur->EventLogSourceName,"System") != NULL) {
						EventTriggered = 1;
					} else if (strstr(ecur->EventLogSourceName,"Application") != NULL) {
						EventTriggered = 2;
					}
					if (!EvtUpdateBookmark(hEvtBookmark[EventTriggered], Event)) {
						if (SNAREDEBUG >= 3) DebugMsg("Error in bookmark: %d",GetLastError());
					}
				}
			}
		}

		//if (!EvtRender(NULL, hEvtBookmark[EventTriggered], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[EventTriggered], &dwValueSize, NULL)) {
		//	if (SNAREDEBUG >= 3) DebugMsg("Error in bookmark: %d",GetLastError());
		//}
		////Source				= XML Provider Name
		start = strstr(tempevent,"<Provider");
		if (start) {
			start = strstr(start,"'");
			start = start+1;
			if (start) {
				end = strstr(start,"'");
				if (end) {
					strncpy_s(ecur->SourceName, 100, start,end-start);
				}
			}
		}

		//// Username				= XML Security UserID
		start = strstr(tempevent,"<Security");
		if (start) {
			end = strstr(start,">");
			start = strstr(start,"'");
			if (start && end && start < end) {
				start = start+1;
				end = strstr(start,"'");
				if (end) {
					strncpy_s(ecur->UserName, 256, start,end-start);
				}
			}
		}

		////EventLogType			= XML Level
		start = strstr(tempevent,"<RenderingInfo");
		if (start) {
			start = strstr(start,"<Level");
			if (start) {
				start = strstr(start,">");
				start = start+1;
				if (start) {
					end = strstr(start,"<");
					if (end) {
						strncpy_s(ecur->EventLogType, 60, start,end-start);
					}
				}
			}
		}

		////category				= XML 
		////Strings				= XML Message
		start = strstr(tempevent,"<Message");
		if (start) {
			start = strstr(start,">");
			start = start+1;
			if (start) {
				end = strstr(start,"<");
				if (end) {
					strncpy_s(ecur->szTempString, MAX_EVENT, start,end-start);
				}
			}
		}

		dwWaitRes = WaitForSingleObject(hMutex,1000);
		if (dwWaitRes == WAIT_OBJECT_0) {
			if (EventTail) {
				ecur->prev = EventTail;
				EventTail->next = ecur;
			}
			EventTail = ecur;
			if (!EventHead) EventHead = ecur;
		}
		ReleaseMutex(hMutex);
		EventCount++;
	} else {
		if(SNAREDEBUG >= 9) DebugMsg("Unable to allocate latest VistaEvent cache\n");
	}
    //Cleanup
    delete[] pBuff;
    delete[] pValues;
	EvtClose(hPubConfig);
	EvtClose(renderContext);
    return dwRes;

}

void CSnarecoreService::Run()
{
	DWORD dwEventLogRecords = 0, dwOldestEventLogRecord = 0, dwNewestEventLogRecord = 0,
		dwEvLogStart = 0, dwEvLogCounter = 0, dwNumberOfBytesToRead = 0, 
		dwBytesRead = 0, dwMinNumberOfBytesNeeded = 0, dwCancel = 0, dwClose = 0;

	DWORD ClearTabs=0;
	DWORD dwSyslogHeader=0; // Send the Syslog header?
	DWORD dwPortNumber=6161;
	DWORD dwRestrictIP=0;
	DWORD dwUsePassword=0;

	DWORD dwCatchUpCount=0;
	DWORD dwWaitRes=0,dwWaitReset=0;

	long Category=0;

	// Define an eventlogrecord buffer of 8k.
	// Should be enough for an overwhelming majority of circumstances.
	TCHAR EventLogRecordBuffer[MAX_EVENT]="";
	TCHAR SourceName[100]="";	// Eg: "Security" or "Active Directory"
	TCHAR SIDType[100]="";		// User or System
	TCHAR EventLogType[60]=""; // Warning / Information / success / failure
	TCHAR ExpandedString[MAX_EVENT]="";
	TCHAR DataString[MAX_EVENT]="";
	TCHAR ComputerName[256]="";
	TCHAR UserName[256]="";
	TCHAR szCategoryString[256]=""; // "Detailed Tracking"

  	TCHAR szError[MAX_STRING]="";

	TCHAR SubmitTime[26]="None Yet";

	TCHAR lpszIPAddress[SIZE_OF_RESTRICTIP];
	TCHAR lpszPassword[256];

	short nEventCount=7; // including pipe events

	short TimeoutCounter=0;
	short MessageCounter=0;
	short LogCounter=0;
	short SnareTimeout=0;

	// Destination for log events. Default it to something safe.
	TCHAR lpszDestination[SIZE_OF_DESTINATION]="127.0.0.1";

	PEVENTLOGRECORD pELR = 0;
	PSID UserSID = 0;
	unsigned long EventID=0;
	
	BOOL bRetVal = FALSE;
	BOOL fExit = FALSE;
	UINT uStep = 0, uStepAt = 0, uPos = 0, uOffset = 0;

	int etype=0;	// eventlog type
	int stype=0;	// source type
	UINT EventTriggered=0;

	DWORD SocketType=SOCKETTYPE_UDP;

	DWORD Offset=0;
	DWORD dwDestPort=6161;
	DWORD dwSyslog=13;
	DWORD dwSyslogDynamic=0;
	DWORD dwCritAudit=0;
	DWORD dwObjectiveCount=0;
	Node **MatchList=NULL;
	Node **MatchPointer=NULL;
	DWORD MatchCount;
	BOOL MatchFound=0;

	static DWORD SnareCounter=1;
	static BOOL ActivateChecksum=0;
	
	FILE * OutputFile=(FILE *)NULL;

	// Syslog, and output log time variables.
	time_t currenttime;
	struct tm newtime;
	struct tm savedtime;

	// Initialise the elements of savedtime that we use.
	savedtime.tm_mday=0;
	savedtime.tm_mon=0;
	savedtime.tm_year=0;

	//Create_EventLog_Hive();

	// This is the internal Snare eventlog counter.
	DWORD EventLogCounter[6];
	EventLogCounter[0]=0;
	EventLogCounter[1]=0;
	EventLogCounter[2]=0;
	EventLogCounter[3]=0;
	EventLogCounter[4]=0;
	EventLogCounter[5]=0;

	dwEventIDRead[0]=0; dwEventIDRead[1]=0; dwEventIDRead[2]=0;
	dwEventIDRead[3]=0; dwEventIDRead[4]=0; dwEventIDRead[5]=0;

	dwEventLogCleared[0]=0; dwEventLogCleared[1]=0; dwEventLogCleared[2]=0;
	dwEventLogCleared[3]=0; dwEventLogCleared[4]=0; dwEventLogCleared[5]=0;

	dwEventIDOldest[0]=dwEventIDOldest[1]=dwEventIDOldest[2]=dwEventIDOldest[3]=dwEventIDOldest[4]=dwEventIDOldest[5]=0;

	if(SNAREDEBUG >= 1) { DebugMsg("SNARE is Running"); }

	// READ in our data
	GetHostname(Hostname,_countof(Hostname));
	GetDestPort(&dwDestPort);
	GetSocketType(&SocketType);
	GetSyslog(&dwSyslog);
	GetSyslogDynamic(&dwSyslogDynamic);
	GetSyslogHeader(&dwSyslogHeader);
	GetWEBSERVER_ACTIVE(&WEBSERVER_ACTIVE);
	GetPortNumber(&dwPortNumber);
	GetDestination(lpszDestination,_countof(lpszDestination));
	GetCrit(&dwCritAudit);
	if(dwSyslogHeader) {
		GetDelim(DELIM,_countof(DELIM));
	}
	GetPassword(lpszPassword,_countof(lpszPassword));
	GetIPAddress(lpszIPAddress,_countof(lpszIPAddress));
	GetClearTabs(&ClearTabs);
	GetChecksum(&ActivateChecksum);

	OutputFile=GetOutputFile();

	// Load the objective data here.
	dwObjectiveCount=ReadObjectives();
	if(dwObjectiveCount) {
		// Malloc a array for our FastCheckObjective process
		MatchList = (Node **)malloc(dwObjectiveCount * sizeof(Node *));
		if(!MatchList) {
			if(SNAREDEBUG >= 9) DebugMsg("Cannot allocate memory for our internal Objective match list");
			dwObjectiveCount=0;
		}
	}


	hosthead=OpenSockets(lpszDestination,dwDestPort,SocketType);

	
	if(SNAREDEBUG >= 9) DebugMsg("Sockets opened/connected");
	////////////////// REMEMBER TO FREE THESE SOCKETS LATER!!!!   REDREDRED



	// Open the socket (UDP or TCP) to the indicated port
	//g_hSocket = ConnectToServer( lpszDestination, (UINT)dwDestPort, szError,_countof(szError), SocketType );

	//if( g_hSocket == INVALID_SOCKET ) {
	//	if(SNAREDEBUG >= 9) DebugMsg(szError);
	//}

	if(WEBSERVER_ACTIVE) {
		if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
			StartWebThread(m_hEventList);
		} else {
			WEBSERVER_ACTIVE = 0;
		}
	}

	// Monitor the pipe
	// Set the terminate flag to zero.
	// setting this value to TRUE will terminate the service,
	// and ask it to save it's current status.
	g_Info.bTerminate = FALSE;

	
	if(SNAREDEBUG >= 9) { DebugMsg("Entering main loop."); }
	// This is the service's main run loop.
    while (m_bIsRunning) 
	{
		// TODO: Add code to perform processing here  
		// If we have been asked to terminate, do so.
		if(g_Info.bTerminate)
		{
			m_bIsRunning=0;
			break;
		}
		while (EventHead) {
			if (SNAREDEBUG >= 6) DebugMsg("VISTA: Checking VISTA Events..");
			static char szSendString[MAX_OUTPUT_STRING]=""; // Nice big memory buffer - just in case.
			static char szTempString[MAX_EVENT]=""; // Approximately the maximum we could reasonably expect to transfer over UDP
			MsgCache *CurrentEvent;
			dwWaitRes = WaitForSingleObject(hMutex,1000);
			if (dwWaitRes == WAIT_OBJECT_0) {
				CurrentEvent = EventHead;
				EventHead = EventHead->next;
				if (EventHead) EventHead->prev = NULL;
				else EventTail = NULL;
				CurrentEvent->prev=NULL;
				CurrentEvent->next=NULL;
			}
			EventCount--;
			ReleaseMutex(hMutex);
			//DMM

			if (!CurrentEvent->EventLogSourceName) {
				if (SNAREDEBUG >= 3) DebugMsg("FAILED message!!");
			}
			if (SNAREDEBUG >= 6) DebugMsg("VISTA: Event found, processing data for VISTA event");
			if (strstr(CurrentEvent->EventLogSourceName,"Security") != NULL) {
				stype = LOG_SEC;
				EventTriggered = 0;
			} else if (strstr(CurrentEvent->EventLogSourceName,"System") != NULL) {
				stype = LOG_SYS;
				EventTriggered = 1;
			} else if (strstr(CurrentEvent->EventLogSourceName,"Application") != NULL) {
				stype = LOG_APP;
				EventTriggered = 2;
			}

			if (strstr(CurrentEvent->EventLogType,"Success") != NULL)
				etype = TYPE_SUCCESS;
			else if (strstr(CurrentEvent->EventLogType,"Failure") != NULL)
				etype = TYPE_FAILURE;
			else if (strstr(CurrentEvent->EventLogType,"Error") != NULL)
				etype = TYPE_ERROR;
			else if (strstr(CurrentEvent->EventLogType,"Information") != NULL)
				etype = TYPE_INFO;
			else if (strstr(CurrentEvent->EventLogType,"Warning") != NULL)
				etype = TYPE_WARN;
			EventID = CurrentEvent->ShortEventID;

			if (dwObjectiveCount){
				MatchCount=0;
				MatchPointer=MatchList; // Start of the list
				if(!MatchPointer) {
					// Something seriously wierd is happening if MatchPointer is null.
					// Leave the messages as they are and try again later.
					if(SNAREDEBUG >= 7) DebugMsg("Match Pointer has gone away");
					dwWaitRes = WaitForSingleObject(hMutex,1000);
					if (dwWaitRes == WAIT_OBJECT_0) {
						if (EventTail) {
							CurrentEvent->prev = EventTail;
							EventTail->next = CurrentEvent;
						}
						EventTail = CurrentEvent;
						if (!EventHead) EventHead = CurrentEvent;
					}
					ReleaseMutex(hMutex);
					EventCount++;
					break;
				}
				do {
					try {
						*MatchPointer=FastCheckObjective(EventID,etype,stype);
					} catch(...) {
						if(SNAREDEBUG >= 7) DebugMsg("FastCheckObjective: Error encountered!");
						if(SNAREDEBUG >= 7) DebugMsg("MatchPointer is %ld, EventID is %d, etype is %d, stype is %d",*MatchPointer,EventID,etype,stype);
						*MatchPointer=NULL;
					}
					
					if(*MatchPointer) {
						MatchFound=1;
						MatchCount++;
						MatchPointer++;
					} else {
						MatchFound=0;
					}
				} while(MatchFound && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows
				
				if(g_Info.bTerminate) {
					m_bIsRunning=0;
					free(CurrentEvent);
					break;
				}
				if(!MatchCount) {
					if(SNAREDEBUG >= 7) { DebugMsg("Match Checker: No matches found, clearing data for VISTA event"); }
					free(CurrentEvent);
					continue;
				}
			}
			if (!CurrentEvent) {
				//strncpy_s(SubmitTime,_countof(SubmitTime),"",_TRUNCATE);
				//free(CurrentEvent);
				break;
			}
			if(SNAREDEBUG >= 7) { DebugMsg("FastCheckObjective: found matches (%d)",MatchCount); }
			if (SNAREDEBUG >= 6) DebugMsg("VISTA: done");
			//DMM
			if(strlen(CurrentEvent->EventLogSourceName) && strlen(CurrentEvent->SubmitTime) && strlen(CurrentEvent->SourceName) && strlen(CurrentEvent->EventLogType) && strlen(CurrentEvent->ComputerName) && strlen(CurrentEvent->szTempString) && strlen(CurrentEvent->szCategoryString))
			{
				if (SNAREDEBUG >= 6) DebugMsg("Event is ready, checking objectives");
				char *stringp;
				
				// This is the point at which we integrate our regular expression handling
				// and event filtering facilities.
				// NOTE:
				// Was going to implement a regular expression matching capability,
				// - but based on the limitations of the NT Audit subsystem, it's probably
				//   better that we use dos wildcards instead.
				//
				
				DWORD ShortEventID=0;
				// Cut off the severity, flags, and  facility data
				// Just leave the real event ID.
				ShortEventID = EventID & 65535;
				if (SNAREDEBUG >= 6) DebugMsg("ShortEventID: %d", ShortEventID);
				char header[256];
				
				BOOL nodematch=0;
				int tcriticality=0;
				
				if (SNAREDEBUG >= 6) DebugMsg("dwObjectiveCount: %d", dwObjectiveCount);
				// Check objectives
				// NOTE: If there are no objectives, send all?
				if(!dwObjectiveCount) {
					nodematch=1;
				} else {
					MatchCount=0;
					MatchPointer=MatchList; // Start of the list
					
					do {
						if (SNAREDEBUG >= 6) DebugMsg("begin MatchCount: %d", MatchCount);
						// Some of the MS System calls used in CheckObjective are buggy.
						try {
							tcriticality=CheckObjective(*MatchPointer,ShortEventID,CurrentEvent->UserName,CurrentEvent->szTempString);
						} catch(...) {
							if(SNAREDEBUG >= 7) DebugMsg("CheckObjective CRASH");
							tcriticality=0;
						}
						if(tcriticality >= 0) {
							if ((*MatchPointer)->excludeidflag) {
								if(SNAREDEBUG >= 7) DebugMsg("Excluding this event");
								nodematch=0;
								break;
							}
							nodematch=1;
							if(SNAREDEBUG >= 7) { DebugMsg("Checkobjective: node found"); }
							if(CurrentEvent->criticality < tcriticality) {
								CurrentEvent->criticality = tcriticality;
							}
							if(!dwCritAudit) {
								// break here if we just want the FIRST match.
								break;
							}
						}
						MatchPointer++;
						MatchCount++;

						if (SNAREDEBUG >= 6) DebugMsg("end MatchCount: %d", MatchCount);
					} while(*MatchPointer && (MatchCount < dwObjectiveCount) && g_Info.bTerminate==0); // Guard against overflows
					
					if(g_Info.bTerminate) {
						m_bIsRunning=0;
						free(CurrentEvent);
						break;
					}
					if (SNAREDEBUG >= 6) {
						if (!*MatchPointer) DebugMsg("Check Objective finished: MatchPointer has gone away");
						if (MatchCount >= dwObjectiveCount) DebugMsg("Check Objective finished: no objectives left to check");
					}
				}
				// END
				if (SNAREDEBUG >= 6) DebugMsg("nodematch: %d", (nodematch?1:0));
				if(nodematch) {
					
					if(dwSyslogHeader || OutputFile) {
						time(&currenttime);
						localtime_s(&newtime,&currenttime);
					}
					
					if(OutputFile) {
						// Check to see whether we need to rotate our log file.
						if(newtime.tm_year != savedtime.tm_year ||
							newtime.tm_mon != savedtime.tm_mon ||
							newtime.tm_mday != savedtime.tm_mday) {
							
							fclose(OutputFile);
							OutputFile=GetOutputFile();
							
							savedtime.tm_year=newtime.tm_year;
							savedtime.tm_mon=newtime.tm_mon;
							savedtime.tm_mday=newtime.tm_mday;
						}
					}
			
					char CurrentDate[16]="";
					if(dwSyslogHeader) {
						DWORD tdwSyslog;
						
						syslogdate(CurrentDate,&newtime);
						
						
						// HERE: Split out criticality.
						if(dwSyslogDynamic) {
							tdwSyslog=((7-CurrentEvent->criticality) & 7) | ((dwSyslog >> 3) << 3);
						} else {
							tdwSyslog=dwSyslog;
						}
						
						_snprintf_s(header,_countof(header),_TRUNCATE,"<%ld>%s %s MSWinEventLog%s%d%s",tdwSyslog,CurrentDate,Hostname,DELIM,CurrentEvent->criticality,DELIM);
					} else {
						_snprintf_s(header,_countof(header),_TRUNCATE,"%s%sMSWinEventLog%s%d%s",Hostname,DELIM,DELIM,CurrentEvent->criticality,DELIM);
					}
					stringp=CurrentEvent->szTempString;
					while(*stringp) {
						// TAB
						if(*stringp==9) {
							*stringp=' ';
						}
						stringp++;
					}
					_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s%d%s%s%s%ld%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%d\0",header,CurrentEvent->EventLogSourceName,DELIM,SnareCounter,DELIM,CurrentEvent->SubmitTime,DELIM,ShortEventID,DELIM,CurrentEvent->SourceName,DELIM,CurrentEvent->UserName,DELIM,CurrentEvent->SIDType,DELIM,CurrentEvent->EventLogType,DELIM,CurrentEvent->ComputerName,DELIM,CurrentEvent->szCategoryString,DELIM,CurrentEvent->DataString,DELIM,CurrentEvent->szTempString,DELIM,EventLogCounter[EventTriggered]);
					if(SNAREDEBUG >= 3 && CurrentEvent->DataString) { DebugMsg("DataString: %s",CurrentEvent->DataString); }
					if(SNAREDEBUG >= 3 && CurrentEvent->szTempString) { DebugMsg("szTempString: %s",CurrentEvent->szTempString); }
					
					// Jump through szSendString, and remove any newline characters.
					stringp=szSendString;
					while(*stringp) {
						// CR or LF
						if(*stringp==10 || *stringp==13) {
							*stringp=' ';
						}
						stringp++;
					}
					
					// Add in an MD5 if appropriate
					if(ActivateChecksum) {
						char CryptString[64];
						strncpy_s(CryptString,_countof(CryptString),MD5String(szSendString),_TRUNCATE);
						_snprintf_s(szSendString,_countof(szSendString),_TRUNCATE,"%s%s%s",szSendString,DELIM,CryptString);
					}
					
					
					// Ok, now add a newline.
					if (strlen(szSendString) >= _countof(szSendString)) {
						szSendString[strlen(szSendString)-1]='\n';
					} else {
						strncat_s(szSendString,_countof(szSendString),"\n",_TRUNCATE);
					}
					
					if(SNAREDEBUG >= 3 && szSendString) { DebugMsg("DEBUG: Sending the following string to the server: %s",szSendString); }
					
					BOOL DataSent=0;

					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						//if (SNAREDEBUG >= 2) DebugMsg("sending data to %s", hostcurrentnode->HostName);
						if(hostcurrentnode->Socket == INVALID_SOCKET) {
							// Try to reestablish here.
							// Since socket connects use a fair bit of system resources, try and do it nicely.
							if(SNAREDEBUG >= 9) { DebugMsg("Socket is toast for %s. Trying to reestablish.",hostcurrentnode->HostName); }
							
							hostcurrentnode->Socket = ConnectToServer( hostcurrentnode, (UINT)dwDestPort, szError, _countof(szError), SocketType );
							
							if(hostcurrentnode->Socket == INVALID_SOCKET) {
								// Hmm. Try again later.
								// Jump to the next socket
								hostcurrentnode=hostcurrentnode->next;
								if (SNAREDEBUG >=9) DebugMsg("Failed to reconnect socket");
								continue;
							}
						}

						if( !SendToSocket(hostcurrentnode, szSendString, (int)strlen(szSendString), szError, _countof(szError)) )
						{
							if(SNAREDEBUG >= 9) { if(szError) { DebugMsg(szError); } }
							if(SNAREDEBUG >= 9) { DebugMsg("Socket for %s is toast. Breaking out - will reestablish next time.",hostcurrentnode->HostName); }
							// Close the socket. Restablish it on the next cycle, if we can.
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						} else {
							DataSent=1;
						}

						hostcurrentnode=hostcurrentnode->next;
					}


					// Did we push out at least one record?
					if(!DataSent) {
						dwEvLogCounter--;
						dwNewestEventLogRecord=dwEvLogCounter;
						if (SNAREDEBUG >= 1) DebugMsg("Failed to send message, holding position in event log");
						// Break out of the while loop.
						dwWaitRes = WaitForSingleObject(hMutex,1000);
						if (dwWaitRes == WAIT_OBJECT_0) {
							if (EventTail) {
								CurrentEvent->prev = EventTail;
								EventTail->next = CurrentEvent;
							}
							EventTail = CurrentEvent;
							if (!EventHead) EventHead = CurrentEvent;
						}
						ReleaseMutex(hMutex);
						EventCount++;
						break;
					} else {
						MCCurrent = CurrentEvent;
						strncpy_s(MCCurrent->ComputerName,_countof(MCCurrent->ComputerName),Hostname,_TRUNCATE);
						MCCurrent->EventLogCounter = EventLogCounter[EventTriggered];
						MCCurrent->SnareCounter = SnareCounter;
						MCCurrent->next = NULL;
						MCCurrent->prev = NULL;
						dwWaitRes = WaitForSingleObject(hMutex,500);
						if(dwWaitRes == WAIT_OBJECT_0) {
							if (MCCount >= WEB_CACHE_SIZE) {
								//Lock Mutex and drop the oldest record
								MsgCache *temp;
								temp = MCTail;
								MCTail = MCTail->prev;
								free(temp);
								MCCount--;
								if (!MCTail) {
									//Something is wrong, recalculate the tail
									MCHead=NULL;
									MCCount = 0;
									MCTail = NULL;
								} else {
									MCTail->next = NULL;
								}
							}
						} else {
							if(SNAREDEBUG >= 9) DebugMsg("VISTA: EVENT CACHE FAILED!\n");
						}
						ReleaseMutex(hMutex);
						if (MCHead) {
							MCHead->prev = MCCurrent;
							MCCurrent->next = MCHead;
						}
						MCHead = MCCurrent;
						if (!MCTail) MCTail = MCCurrent;
						MCCount++;
						
						// Increment the Snare internal event counter
						// Note: Maxdword is 4294967295
						// Dont overflow our array either.
						if(EventTriggered <= 5) {
							EventLogCounter[EventTriggered]++;
							if(EventLogCounter[EventTriggered] >= MAXDWORD) {
								EventLogCounter[EventTriggered]=1;
							}
						}
						SnareCounter++;
						if(SnareCounter >= MAXDWORD) {
							SnareCounter=1;
						}
					}
					
					// Write the data out to a disk, if requested.
					if(OutputFile) {
						fputs(szSendString,OutputFile);
						fflush(OutputFile);
					}
				}
#ifdef MEMDEBUG
				_CrtDumpMemoryLeaks();
#endif
			} else {
				if (SNAREDEBUG >= 3) DebugMsg("ERROR: Invalid VISTA event.");
				DebugMsg("%d %d %d %d %d %d %d", strlen(CurrentEvent->EventLogSourceName), strlen(CurrentEvent->SubmitTime), strlen(CurrentEvent->SourceName), strlen(CurrentEvent->EventLogType), strlen(CurrentEvent->ComputerName), strlen(CurrentEvent->szTempString), strlen(CurrentEvent->szCategoryString));
				free(CurrentEvent);
			}
			//free(CurrentEvent);

		}
		// The service performs one check per 5 seconds. This should not be
		// a significant drain on resources.
		dwWaitRes=WaitForSingleObject(m_hEventList,5000);

		// if(dwWaitRes != WAIT_FAILED && dwWaitRes != WAIT_TIMEOUT)
		if(dwWaitRes != WAIT_FAILED)
		{
			EventTriggered=0;
			stype = LOG_APP;	 // Assume application log if no valid source provided.
			if(dwWaitRes == WAIT_OBJECT_0) {
				//do nothing, this means there has been a web reset event, it will be handled below.
				// this is just to prevent a delay
				ResetEvent(m_hEventList);
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Reset event received"); }
			} else if (dwWaitRes == WAIT_TIMEOUT) {
 				if(SNAREDEBUG >= 9) { DebugMsg("Timeout hit"); }
			} else {
				if(SNAREDEBUG >= 9) { DebugMsg("Warning: An event occured that I am not programmed to deal with. Continuing"); }
				continue;
			}
			//firstly, check to see if the web server needs resetting:
			if (WebResetFlag) {
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: resetting the web thread"); }
				// Save off our current position in each of our log files.
				EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
				EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
				EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
				MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
				MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
				MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);
				if (WebResetFlag == FULL_WEB_RESET) {
					DestroyList();

					if(WEBSERVER_ACTIVE) {
						CloseWebServer();
					}

					// cancel blocking calls, if any
					WSACancelBlockingCall();

					// Close all active sockets.
					HostNode * temphostnode;

					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						if(hostcurrentnode->Socket != INVALID_SOCKET) {
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						}
						temphostnode=hostcurrentnode->next;

						// Free the RAM associated with this node. We don't need it any more.
						free(hostcurrentnode);
						hostcurrentnode=temphostnode;
						// Just in case
						hosthead=hostcurrentnode;
					}
					hosthead=NULL;


					// READ in our data
					GetHostname(Hostname,_countof(Hostname));
					GetDestPort(&dwDestPort);
					GetSocketType(&SocketType);
					GetSyslog(&dwSyslog);
					GetSyslogDynamic(&dwSyslogDynamic);
					GetSyslogHeader(&dwSyslogHeader);
					GetWEBSERVER_ACTIVE(&WEBSERVER_ACTIVE);
					GetPortNumber(&dwPortNumber);
					GetChecksum(&ActivateChecksum);
					GetDestination(lpszDestination,_countof(lpszDestination));
					if(dwSyslogHeader) {
						GetDelim(DELIM,_countof(DELIM));
					}
					GetPassword(lpszPassword,_countof(lpszPassword));
					GetIPAddress(lpszIPAddress,_countof(lpszIPAddress));
					GetClearTabs(&ClearTabs);

					if(OutputFile) {
						fclose(OutputFile);
					}
					OutputFile=GetOutputFile();

					//if (!dwObjectiveCount) MatchList = NULL;
					if(MatchList) {
						free(MatchList);
						MatchList=NULL;
					}
					// Load the objective data here.
					dwObjectiveCount=ReadObjectives();
					if(dwObjectiveCount) {
						// Malloc a array for our FastCheckObjective process
						MatchList = (Node **)malloc(dwObjectiveCount * sizeof(Node *));
						if(!MatchList) {
							if(SNAREDEBUG >= 9) DebugMsg("Cannot allocate memory for our internal Objective match list");
							dwObjectiveCount=0;
						}
					}
					ResetCurrentNode();

					// Open our outgoing sockets.
					hosthead=OpenSockets(lpszDestination,dwDestPort,SocketType);

					// Ok, we have finished our general configuration reads.

					if(WEBSERVER_ACTIVE) {
						if(SNAREDEBUG >= 5) { DebugMsg("Starting web thread."); }
						if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
							StartWebThread(m_hEventList);
						} else {
							WEBSERVER_ACTIVE = 0;
						}
					}
				} else if (WebResetFlag == BASIC_WEB_RESET) {
					if(WEBSERVER_ACTIVE) {
						if(SNAREDEBUG >= 5) { DebugMsg("Restarting web thread."); }
						CloseWebServer();
						if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
							StartWebThread(m_hEventList);
						} else {
							WEBSERVER_ACTIVE = 0;
						}
					}
					hostcurrentnode=hosthead;
					while(hostcurrentnode) {
						//if(hostcurrentnode->Socket != INVALID_SOCKET) {
						if(hostcurrentnode->Socket != INVALID_SOCKET) {
							closesocket(hostcurrentnode->Socket);
							hostcurrentnode->Socket=INVALID_SOCKET;
						}
						hostcurrentnode=hostcurrentnode->next;
					}
				}
				//dwWaitReset = WaitForSingleObject(hMutex,500);
				//if(dwWaitReset == WAIT_OBJECT_0) {
					WebResetFlag=0;
				//}
				//ReleaseMutex(hMutex);
			}
		}
		EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
		EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
		EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
		MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
		MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
		MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);
    }

	if(SNAREDEBUG >= 1) { DebugMsg("SNARE Closing"); }

	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);

	if(MatchList) {
		free(MatchList);
	}

	CloseWebServer();

	if(OutputFile) {
		fclose(OutputFile);
	}

	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);

	HostNode * temphostnode;
	// Free our host linked list.
	hostcurrentnode=hosthead;
	while(hostcurrentnode) {
		if(hostcurrentnode->Socket != INVALID_SOCKET) {
			TerminateWinsock(hostcurrentnode->Socket);
		}
		temphostnode=hostcurrentnode;
		hostcurrentnode=hostcurrentnode->next;
		free(temphostnode);
	}
	hosthead = NULL;

	if( m_hEventList ) ::CloseHandle(m_hEventList);

    // Close the subscriber handle.
    EvtClose(m_hEventSys);
    EvtClose(m_hEventSec);
    EvtClose(m_hEventApp);

	// Free memory used by the objectives lists
	DestroyList();
}

void GetFQDN(char *string, const int length)
{
	struct hostent *phostent;
	
	if(!string) return;

	// Now, grab fully qualified hostname here.
	// Get the normal name.
	if(gethostname(string, length)) {		
		strncpy_s(string,length,"localhost.unknown",_TRUNCATE);
		return;
	}
	
	
	// Now perform a lookup on that name.
	phostent=gethostbyname(string);
	if(phostent) {
		while(phostent->h_aliases && *phostent->h_aliases) {
			if(strlen(*(phostent->h_aliases)) > strlen(string) && !strncmp(string,*(phostent->h_aliases),strlen(string))) {
				strncpy_s(string,length,*(phostent->h_aliases),_TRUNCATE);
			}
			phostent->h_aliases++;
		}
		if(strlen(phostent->h_name) > strlen(string) && !strncmp(string,phostent->h_name,strlen(string))) {
			strncpy_s(string,length,phostent->h_name,_TRUNCATE);
		}
	}
}

// Match a DOS wildcard against a string.
// eg: wildmatch("c:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatch(char *pattern, char *source)
{
	if(!pattern || !source) {
		return(0);
	}
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatch(pattern, source+1) || wildmatch(pattern+1, source) || wildmatch(pattern+1, source+1);
    case '?':
        return wildmatch(pattern+1, source+1);
    default:
        return (*pattern == *source) && wildmatch(pattern+1, source+1);
    }
}

// Match a DOS wildcard against a string.
// eg: wildmatch("C:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatchi(char *pattern, char *source)
{
	if(!pattern || !source) {
		return(0);
	}
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatchi(pattern, source+1) || wildmatchi(pattern+1, source) || wildmatchi(pattern+1, source+1);
    case '?':
        return wildmatchi(pattern+1, source+1);
    default:
		char lpattern,lsource;
		lpattern = tolower(*pattern);
		lsource = tolower(*source);
		
        return (lpattern == lsource) && wildmatchi(pattern+1, source+1);
    }
}



// Find the nth entry in the tab-delimited string 'search'.
// NOTE: may need to take into account the user delimiter
void splitstrings(char *store, int field, char *search, int size)
{
	int count;
	char *start=search;
	char *end=search;

	if(!store || !search) return;

	strcpy_s(store,1,"");

	for(count=1;count<=field;count++) {
		end=strstr(start,"	");
		if(!end) {
			if(count < field) {
				return;
			} else {
				strncpy_s(store,size,start,_TRUNCATE);
				store[size]='\0';
				return;
			}
		} else {
			int nsize;

			if((end-start) >= size) {
				nsize=size-1;
			} else {
				nsize=(int)(end-start);
			}

			if(count == field) {
				strncpy_s(store,nsize+1,start,_TRUNCATE);
				store[nsize]='\0';
				return;
			}

			start=end+1;
			end=start;
		}
	}
}


void syslogdate(char *sdate, struct tm *cdate)
{
	char Month[4];
	char Date[3];
	char Hour[3];
	char Min[3];
	char Sec[3];

	if(!sdate || !cdate) return;

	switch (cdate->tm_mon) {
		case 0: strcpy_s(Month,_countof(Month),"Jan"); break;
		case 1: strcpy_s(Month,_countof(Month),"Feb"); break;
		case 2: strcpy_s(Month,_countof(Month),"Mar"); break;
		case 3: strcpy_s(Month,_countof(Month),"Apr"); break;
		case 4: strcpy_s(Month,_countof(Month),"May"); break;
		case 5: strcpy_s(Month,_countof(Month),"Jun"); break;
		case 6: strcpy_s(Month,_countof(Month),"Jul"); break;
		case 7: strcpy_s(Month,_countof(Month),"Aug"); break;
		case 8: strcpy_s(Month,_countof(Month),"Sep"); break;
		case 9: strcpy_s(Month,_countof(Month),"Oct"); break;
		case 10: strcpy_s(Month,_countof(Month),"Nov"); break;
		default: strcpy_s(Month,_countof(Month),"Dec"); break;
	}

	if(cdate->tm_mday<10) {
		_snprintf_s(Date,3,_TRUNCATE," %d\0",cdate->tm_mday);
	} else {
		_snprintf_s(Date,3,_TRUNCATE,"%d\0",cdate->tm_mday);
	}

	if(cdate->tm_hour<10) {
		_snprintf_s(Hour,3,_TRUNCATE,"0%d\0",cdate->tm_hour);
	} else {
		_snprintf_s(Hour,3,_TRUNCATE,"%d\0",cdate->tm_hour);
	}

	if(cdate->tm_min<10) {
		_snprintf_s(Min,3,_TRUNCATE,"0%d\0",cdate->tm_min);
	} else {
		_snprintf_s(Min,3,_TRUNCATE,"%d\0",cdate->tm_min);
	}

	if(cdate->tm_sec<10) {
		_snprintf_s(Sec,3,_TRUNCATE,"0%d\0",cdate->tm_sec);
	} else {
		_snprintf_s(Sec,3,_TRUNCATE,"%d\0",cdate->tm_sec);
	}

	_snprintf_s(sdate,16,_TRUNCATE,"%s %s %s:%s:%s\0",Month,Date,Hour,Min,Sec);
}


//////////////////////////////////////////////////////////////////
// SendToSocket
//              sends a buffer (buf) of size size to the specified socket
//              returns TRUE or FALSE.
BOOL  SendToSocket(HostNode *hcn, char *buf, int nSize, char *szError, int eSize)
{
	// int   rv;
	int bytessent=0;

	if(!buf || !szError || !eSize || !hcn || hcn->Socket == INVALID_SOCKET) return(0);

	do {
		bytessent = sendto(hcn->Socket,buf,nSize,0,(SOCKADDR *)&hcn->server,sizeof(hcn->server));
		if(bytessent==-1) {
			if(SNAREDEBUG >= 9) { DebugMsg("error sending to server. WSA ERROR: %d",WSAGetLastError()); }
			return FALSE;
		}
		buf+= bytessent;
		nSize -= bytessent;
	} while(nSize > 0);

	return TRUE;
}


BOOL CheckLogExists(TCHAR *LogName)
{
	TCHAR szKeyName[MAX_STRING]="";
	LPBYTE pSourceName=0;
	HKEY   hk = (HKEY)0;
	LPBYTE pStrings = 0;

	DWORD dwMaxString;			
	DWORD dwType; // Temporary variable.
	TCHAR szKeyValue[MAX_STRING+1]="";
	TCHAR szFileName[MAX_STRING+1]="";

	if(!LogName) return(0);
			
	wsprintf(szKeyName, _T("SYSTEM\\CurrentControlSet\\Services\\EventLog\\%s"), LogName);

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0L, KEY_READ|KEY_SET_VALUE, &hk) != ERROR_SUCCESS) {
		if(SNAREDEBUG >= 1 && LogName) { if(LogName) { DebugMsg("Cannot determine if log %s exists - openkey failed",LogName); } }
		return(FALSE);
	}

	dwMaxString=MAX_STRING-1;
	if(RegQueryValueEx(hk, _T("File"), 0, &dwType, (LPBYTE)szKeyValue, &dwMaxString) != ERROR_SUCCESS)
	{
		if(SNAREDEBUG >= 1 && LogName) { DebugMsg("Cannot determine if log %s exists - queryvalueex failed",LogName); }
		RegCloseKey(hk);
		return(FALSE);
	}

	ExpandEnvironmentStrings(szKeyValue,szFileName,_countof(szFileName));
	if(!strlen(szFileName)) {
		if(SNAREDEBUG >= 1 && LogName) { DebugMsg("String just wont expand in checklogexists. Log %s probably doesnt exist",LogName); }
		RegCloseKey(hk);
		return(FALSE);
	}

	struct _stat buf;

	if(_stat(szFileName, &buf)) {
		RegCloseKey(hk);
		return(FALSE);
	}

	// Verify that log retention settings are set to 'overwrite as needed'.
	// Not sure if we need to restart the audit service if this succeeds..

	DWORD RetentionValue=0;
	DWORD RetentionSize=sizeof(RetentionValue);

	// Verify that the user is overwriting as required
	if(RegQueryValueEx(hk, _T("Retention"), 0, &dwType, (unsigned char *)&RetentionValue, &RetentionSize) != ERROR_SUCCESS)
	{
		if(SNAREDEBUG >= 1 && LogName) {
			DebugMsg("Cannot check log retention settings - queryvalueex failed for log %s",LogName);
		}
	}
	if(SNAREDEBUG >= 1) { DebugMsg("Log retention settings are set to %d for log %s",RetentionValue,LogName); }
	
	if(RetentionValue != 0) {
		RetentionValue=0;
		if(RegSetValueEx(hk, _T("Retention"), 0, REG_DWORD, (unsigned char *)&RetentionValue, sizeof(DWORD)) != ERROR_SUCCESS)
		{
			if(SNAREDEBUG >= 1 && LogName) { DebugMsg("Cannot set log retention settings - regsetvalueex failed for log %s",LogName); }
		}
	}
	

	RegCloseKey(hk);
	return(TRUE);
}



BOOL GetSIDType(SID_NAME_USE _SidNameUse, TCHAR *szSIDType, DWORD length)
{
	if(!szSIDType || length <=1 || !_SidNameUse) {
		return FALSE;
	}

	szSIDType[0] = '\0';
	switch(_SidNameUse)
	{
		case SidTypeUser:
			strncpy_s(szSIDType,length,"User",_TRUNCATE);
			break;
		case SidTypeGroup:
			strncpy_s(szSIDType,length,"Group",_TRUNCATE);
			break;
		case SidTypeDomain:
			strncpy_s(szSIDType,length,"Domain",_TRUNCATE);
			break;
		case SidTypeAlias:
			strncpy_s(szSIDType,length,"Alias",_TRUNCATE);
			break;
		case SidTypeWellKnownGroup:
			strncpy_s(szSIDType,length,"Well Known Group",_TRUNCATE);
			break;
		case SidTypeDeletedAccount:
			strncpy_s(szSIDType,length,"Deleted Account",_TRUNCATE);
			break;
		case SidTypeInvalid:
			strncpy_s(szSIDType,length,"Invalid SID",_TRUNCATE);
			break;
		case SidTypeUnknown:
			strncpy_s(szSIDType,length,"Unknown",_TRUNCATE);
			break;
		case SidTypeComputer:
			strncpy_s(szSIDType,length,"Computer",_TRUNCATE);
			break;
		default:
			strncpy_s(szSIDType,length,"Out of Type",_TRUNCATE);
			break;
	}						

	return TRUE;
}


///////////////////////////////////////////////////////////////////
// InitWinsock
//              starts up winsock.dll or wsock32.dll
BOOL InitWinsock( char *szError, int size )
{
	WSAData wsData;

	if(!szError) return(FALSE);
	
	WORD wVersionRequested = WINSOCK_VERSION;
	
	if(WSAStartup(wVersionRequested, &wsData) != 0)
	{
		// :( error
		if( szError )
		{
			sprintf_s(szError,size,"WSAStartup failed: WSA ERROR: %d\r\n",
				WSAGetLastError());
			if(SNAREDEBUG >= 9) { if(szError) { DebugMsg(szError); } }
		}
		return FALSE;
	}
	
	// all is well
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// TerminateWinsock
//      call this function with the current socket or INVALID_SOCKET
void TerminateWinsock( SOCKET hSocket )
{
	// cancel blocking calls, if any
	WSACancelBlockingCall();
	
	// close socket
	if( hSocket != INVALID_SOCKET ) {
		closesocket(hSocket);
		hSocket=INVALID_SOCKET;
	}
		
	// unload winsock
	WSACleanup();
}

// Note that hosthead is a global.
HostNode * OpenSockets(char *lpszDestination, DWORD dwDestPort, DWORD SocketType)
{

	HostNode * headnode=NULL;
	char szError[MAX_STRING];

	headnode=(HostNode *)malloc(sizeof(HostNode));
	if(!headnode) {
		// Oh dear.. out of RAM?
		return(headnode);
	}

	headnode->next=NULL;
	strncpy_s(headnode->HostName,511,lpszDestination,_TRUNCATE);
	headnode->Socket=ConnectToServer( headnode, (UINT)dwDestPort, szError,_countof(szError), SocketType );
	if(headnode->Socket == INVALID_SOCKET) {
		if(SNAREDEBUG >= 9) DebugMsg("Problem opening Socket to %s: %s",lpszDestination,szError);
	}
		
	return(headnode);
}



//////////////////////////////////////////////////////////////
// ConnectToServer:
//    connects to a server on a specified port number
//    returns the connected socket
SOCKET ConnectToServer(HostNode *hcn, UINT nPort, char *szError, int size, DWORD SocketType)
{
	SOCKET hSocket;
	struct hostent far *hp;
	
	if (SNAREDEBUG >= 9) DebugMsg("ConnectToServer");
	if(!hcn->HostName) return INVALID_SOCKET;
	if(!szError || !size) return INVALID_SOCKET;
	if(!*hcn->HostName) return INVALID_SOCKET;
	
	hcn->SocketType = SocketType;
	// Should use something nicer to check for IP addresses...
	if( isdigit(hcn->HostName[0])) {
		ZeroMemory((char *) &hcn->server, sizeof(hcn->server));
		hcn->server.sin_family      = AF_INET;
		hcn->server.sin_addr.s_addr = inet_addr(hcn->HostName);
		hcn->server.sin_port        = htons(nPort);
	} else {
		if ( (hp = (struct hostent far *) gethostbyname(hcn->HostName)) == NULL)	{
			_snprintf_s(szError,size,_TRUNCATE,"Error: gethostbyname failed: %s.",hcn->HostName);
			return INVALID_SOCKET;
		}
		
		ZeroMemory((char *)&hcn->server, sizeof(hcn->server));
		CopyMemory((char *) &hcn->server.sin_addr,hp->h_addr,hp->h_length);
		hcn->server.sin_family = hp->h_addrtype;
		hcn->server.sin_port = htons(nPort);
	}

	// create socket
	if((hSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET) {
		_snprintf_s(szError,size,_TRUNCATE,"socket failed to create datagram socket: %d\n",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	return hSocket;
}


static Node * FastCheckObjective(int eventnumber, int etype, int stype)
{
	static int firstcall=0;
	static Node *tnode;
	int ShortEventID=0;
	
	// No objectives?
	if(!head) {
			return(NULL);
	}
	
	if(firstcall==0) {
		ResetCurrentNode();
		firstcall=1;
	}

	do {
		tnode = GetCurrentItem();
		if(!tnode) {
			ResetCurrentNode();
			// if(SNAREDEBUG >= 7) { DebugMsg("FCO: Current item is null. Must be at the end of the list"); }
			return(NULL);
		}
		
		ShortEventID=eventnumber & 65535;

		if(SNAREDEBUG >= 7) { DebugMsg("FCO: Checking event %d against %d, and etype %d against %d, and stype %d against %d",eventnumber,tnode->event_number,etype,tnode->eventlogtype,stype,tnode->sourcename); }
		//if(eventnumber == tnode->event_number || tnode->event_number == AUDIT_ALL) {
		if(ShortEventID == tnode->event_number || tnode->event_number == AUDIT_ALL) {
			//if(SNAREDEBUG >= 7) { DebugMsg("FCO: Event number looks good.."); }
			if((etype & tnode->eventlogtype) && (stype & tnode->sourcename)) {
				//if(SNAREDEBUG >= 7) { DebugMsg("FCO: etype/stype looks good!"); }
				// Are we including users, or excluding.
				NextItemInList();
				// check if we should exclude this event later
				return(tnode);
			}
		}
		NextItemInList();
	} while(IsValidItem());
	//if(SNAREDEBUG >= 7) { DebugMsg("FCO: Out. No more valid items."); }
	// Will probably never get here.
	ResetCurrentNode();
	return(NULL);
}

int CheckObjective(Node * Match, int eventnumber, char *username, char *match)
{
	if(!username || !match) {
		if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: No Username or Match Term supplied"); }
		return(-1);
	}

	if(!Match) {
		if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: No Objective supplied"); }
		return(-1);
	}
	if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective ([%s,%d,%d,%s],%d,%s,%s)", Match->match, Match->excludeidflag, Match->excludeflag, Match->username, eventnumber, username, match); }

	int usermatch=0;
	char * spoint;
	char tuser[256];
			
	// This could do with some optimisation.. FIXME
	// NOTE: Cannot split out into separate objectives, due to exclusion stuff.
	if(Match->muserflag) {
		spoint=Match->username;
		usermatch=0;
		do {
			spoint=string_split(',',spoint,tuser,_countof(tuser));
			usermatch=wildmatchi(tuser,username);
			if(usermatch) {
				break;
			}
		} while(spoint);
	} else {
		usermatch=wildmatchi(Match->username,username);
	}
	
	if(IS_OBJECT_ACCESS(eventnumber)) {
		if(strlen(Match->match)>2) {
			// Windows 2000 does wierd things with filename auditing - eg: c:\temp\goo
			// becomes \Device\HarddiskDmVolumes\PhysicalDmVolumes\BlockVolume2\temp\goo
			// As such, if this is an object-event, FIRST, try stripping off the
			// VOLUME: (eg: C:) part of the match term, and add on a general raw device
			// term. If nothing comes up, drop back to standard tests.
			
			if(SNAREDEBUG >= 7) { DebugMsg("CheckObjective: object access.."); }
			
			char tempmatch[SIZE_OF_GENERALMATCH];
			_snprintf_s(tempmatch,SIZE_OF_GENERALMATCH,_TRUNCATE,"*\\Device\\HarddiskDmVolumes\\PhysicalDmVolumes\\BlockVolume*\\%s",&Match->match[4]);
					
			// Allowing multiple users (comma separated) may slow things down a little..
					
			if(Match->excludeflag) {
				if(!usermatch && wildmatchi(tempmatch,match)) {
					return(Match->criticality);
				}
			} else {
				if(usermatch && wildmatchi(tempmatch,match)) {
					return(Match->criticality);
				}
			}
		}
	}

	if(SNAREDEBUG >= 7) { DebugMsg("Match->excludeflag: %d, Match->excludeidflag: %d", Match->excludeflag, Match->excludeidflag); }
	if(Match->excludeflag) {
		if(SNAREDEBUG >= 7) { DebugMsg("usermatch: %d", usermatch); }
		if(!usermatch && wildmatchi(Match->match,match)) {
			return(Match->criticality);
		}
	} else {
		if(SNAREDEBUG >= 7) { DebugMsg("usermatch: %d", usermatch); }
		if(usermatch && wildmatchi(Match->match,match)) {
			return(Match->criticality);
		}
	}
	if(SNAREDEBUG >= 7) { DebugMsg("Match failed"); }
	
	return(-1);
}

char * string_split(char divider,char *string,char *destination,int destlength)
{
	int destsize=0;

	if(!string || !destination) {
		return((char *)NULL);
	}

	while(*string && *string != divider) {
		if(destsize < destlength) {
			*destination=*string;
			destination++;
			destsize++;
		}

		string++;
	}
	*destination='\0';
	if(*string == divider) {
		string++;
	} else {
		return((char *)NULL);
	}
	return(string);
}


int ReadObjectives()
{
	Reg_Objective reg_objective;
	DWORD dw_objective_error;
	int i_objective_count=0;
	char *eventpointer,*eventpointer2;
	char eventnumber[11];
	int eventid;
	int criticality;
	int etype=0;
	int stype=0;
	int userflag=0; // include by default
	int eventflag=0; // include by default
	int muserflag=0; // multiple users, comma separated?
	DWORD SetAudit=0;

	SetAudit=MyGetProfileDWORD("Config","Audit",0);

	// HERE: Turn off all auditing, unless there are NO objectives to read.
	if(SetAudit) {
		ClearAuditFlags();
	}
	
	while((dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective))==0) {
		// For each event number defined.
		eventpointer=reg_objective.str_unformatted_eventid_match;
		eventpointer2=reg_objective.str_unformatted_eventid_match;

		userflag=reg_objective.dw_user_match_type;
		eventflag=reg_objective.dw_event_match_type;
		
		// While there are no more commas
		while(eventpointer2) {
			eventpointer2=strstr(eventpointer,",");
			if(eventpointer2 == (char *)NULL) {
				// No commas left. Just copy to the end of the line.
				strncpy_s(eventnumber,_countof(eventnumber),eventpointer,_TRUNCATE);
				eventnumber[10]='\0'; // just in case
			} else {
				int size=9;
				if(eventpointer2-eventpointer < 10) {
					size=(int)(eventpointer2-eventpointer);
				}
				strncpy_s(eventnumber,size+1,eventpointer,_TRUNCATE);
				// Make sure we have a null on the end of the line.
				eventnumber[size]='\0';
			}
			if(eventpointer2) {
				// Skip the comma
				eventpointer=eventpointer2+1;
			}
			
			if(!strcmp(eventnumber,"*")) {
				eventid=AUDIT_ALL;
			} else {
				eventid=atoi(eventnumber);
			}
			if((eventid >=0 && eventid <= 65535) || eventid==AUDIT_ALL) {
				// valid event ID. Continue.

				// HERE: Turn on the appropriate audit.

				if(!strcmp(reg_objective.str_critic,CRITICAL_TOKEN)) {
					criticality=EVENT_CRITICAL;
				} else if(!strcmp(reg_objective.str_critic,PRIORITY_TOKEN)) {
					criticality=EVENT_PRIORITY;
				} else if(!strcmp(reg_objective.str_critic,WARNING_TOKEN)) {
					criticality=EVENT_WARNING;
				} else if(!strcmp(reg_objective.str_critic,INFORMATION_TOKEN)) {
					criticality=EVENT_INFORMATION;
				} else if(!strcmp(reg_objective.str_critic,CLEAR_TOKEN)) {
					criticality=EVENT_CLEAR;
				}

				etype=reg_objective.dw_event_type;
				if(!etype) etype=TYPE_SUCCESS|TYPE_FAILURE|TYPE_INFO|TYPE_WARN|TYPE_ERROR;
				
				// Does the user want us to change the audit settings?
				// Only do this for SECURITY log events
				if(SetAudit && (reg_objective.dw_eventlog_type & LOG_SEC)) {
					if((etype & TYPE_SUCCESS) || (etype & TYPE_FAILURE)) {
						TurnOnEvent(eventid,etype);
					} else {
						// The user didn't specify whether to audit success or failures.
						// TURN ON SUCCESS AUDITING AND FAILURE AUDITING
						TurnOnEvent(eventid,TYPE_SUCCESS|TYPE_FAILURE);
					}
				}

				stype=reg_objective.dw_eventlog_type;
				if(!stype) stype=LOG_SEC|LOG_SYS|LOG_APP|LOG_DIR|LOG_DNS|LOG_REP;

				// Just in case the general match is empty.
				char tempmatch[SIZE_OF_GENERALMATCH];

				if(!strlen(reg_objective.str_general_match)) {
					// NOTE: general_match is > 1, so strcpy is safe here.
					strncpy_s(tempmatch,_countof(tempmatch),"*",_TRUNCATE);
				} else {
					_snprintf_s(tempmatch,_countof(tempmatch),_TRUNCATE,"*%s*",reg_objective.str_general_match);
				}

				if(strstr(reg_objective.str_user_match,",")) {
					muserflag=1;
				} else {
					muserflag=0;
				}

				AddToList(eventid, reg_objective.str_user_match,
						  tempmatch,
						  criticality, eventflag, userflag, muserflag, etype,
						  stype);
			}
		}
		
		i_objective_count++;
	}

	if(SetAudit) {
		ApplyAudit();
	}
	return(i_objective_count);
}

BOOL TurnOnEvent(DWORD EventID,DWORD SuccessFailure)
{
	if(IS_PRIVILEGE_USE(EventID)) {
		SetAuditFlag(AuditCategoryPrivilegeUse,SuccessFailure);
	}
	if(IS_PROCESS_TRACKING(EventID)) {
		SetAuditFlag(AuditCategoryDetailedTracking,SuccessFailure);
	}
	if(IS_SYSTEM_EVENTS(EventID)) {
		SetAuditFlag(AuditCategorySystem,SuccessFailure);
	}
	if(IS_LOGON_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryLogon,SuccessFailure);
	}
	if(IS_ACCOUNT_LOGON_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryAccountLogon,SuccessFailure);
	}
	if(IS_ACCOUNT_MANAGEMENT_EVENTS(EventID)) {
		SetAuditFlag(AuditCategoryAccountManagement,SuccessFailure);
	}
	if(IS_OBJECT_ACCESS(EventID)) {
		SetAuditFlag(AuditCategoryObjectAccess,SuccessFailure);
	}
	if(IS_POLICY_CHANGE(EventID)) {
		SetAuditFlag(AuditCategoryPolicyChange,SuccessFailure);
	}
	if(IS_DIRECTORY_SERVICE_ACCESS(EventID)) {
		SetAuditFlag(AuditCategoryDirectoryServiceAccess,SuccessFailure);
	}

	return(1);
}

// New routines to cope with win2003 PDC replication issues.
// Rather than clear, and re-set all auditing (which causes lots of replication traffic)
// we will just establish a 'flag' array, and then apply it all at the end.

void ClearAuditFlags()
{
	// Uses global flag array "int AuditFlags[9]"
	int i=0;
	for(i=0;i<9;i++) {
		AuditFlags[i]=0;
	}
}

// Make sure you clear audit flags before building this array up.
int SetAuditFlag(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure)
{
	// Uses global flag array "int AuditFlags[9]"
	// Note: expand AuditFlags to max(POLICY_AUDIT_EVENT_TYPE)
	AuditFlags[AuditCategory] |= SuccessFailure;

	return(0);
}

BOOL ApplyAudit()
{
	// AuditCategorySystem, AuditCategoryLogon, AuditCategoryObjectAccess,
	// AuditCategoryPrivilegeUse, AuditCategoryDetailedTracking,
	// AuditCategoryPolicyChange, AuditCategoryAccountManagement,
	// AuditCategoryDirectoryServiceAccess, AuditCategoryAccountLogon

	LPWSTR wComputerName = NULL; 
    LSA_HANDLE PolicyHandle; 
    NTSTATUS Status; 
	PPOLICY_AUDIT_EVENTS_INFO AuditEvents;
	LSA_OBJECT_ATTRIBUTES ObjectAttributes; 
	DWORD Flag=0;
	int i=0;
	DWORD SuccessFailure;
	POLICY_AUDIT_EVENT_TYPE AuditCategory;
	int AuditChanged=0;

	ZeroMemory(&ObjectAttributes, sizeof(ObjectAttributes));

	Status = LsaOpenPolicy(NULL, &ObjectAttributes, POLICY_VIEW_AUDIT_INFORMATION | POLICY_SET_AUDIT_REQUIREMENTS, &PolicyHandle);

	if(Status == 0) {
		Status = LsaQueryInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (void **) &AuditEvents); 
 
		if(Status != 0) {
			LsaClose(PolicyHandle);
			return 0; 
		}
		// 
		// successfully obtained AuditEventsInformation. 
		// 

		// If audit is not turned on
		if(AuditEvents->AuditingMode == 0) {
			// In theory, we need to turn on auditing.
			AuditEvents->AuditingMode = 1;
			Status = LsaSetInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
				(PVOID) AuditEvents); 
		}

		// For each element in the AuditFlags array:
		for(i=0;i<9;i++) {
			AuditCategory=(POLICY_AUDIT_EVENT_TYPE)i;
			SuccessFailure=AuditFlags[AuditCategory];
			Flag=0;
			
			if(SuccessFailure & TYPE_SUCCESS) {
				Flag |= POLICY_AUDIT_EVENT_SUCCESS;
			}
			
			if(SuccessFailure & TYPE_FAILURE) {
				Flag |= POLICY_AUDIT_EVENT_FAILURE;
			}
			
			// If the current settings mirror what we want, don't change anything.
			if((Flag == 0 && (AuditEvents->EventAuditingOptions[AuditCategory] &
				(POLICY_AUDIT_EVENT_SUCCESS | POLICY_AUDIT_EVENT_FAILURE)) == 0) ||
				Flag && AuditEvents->EventAuditingOptions[AuditCategory]) {
				Flag=POLICY_AUDIT_EVENT_UNCHANGED;
			} else if(Flag==0) {
				Flag=POLICY_AUDIT_EVENT_NONE;
			}
			
			if(Flag != POLICY_AUDIT_EVENT_UNCHANGED) {
				Status = SetAuditEvent(PolicyHandle,AuditCategory,Flag);
				AuditChanged=1;
			}
		}

		if(AuditChanged) {
			// 
			// enable audits 
			// 
			if( Status == 0 ) {
				Status = SetAuditMode(PolicyHandle, TRUE);
			}
		}

		LsaClose(PolicyHandle);
	}
 
	return(1);
}








/*

// Turn an audit category on or off
BOOL SwitchAudit(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure, BOOL Switch)
{
	// AuditCategorySystem, AuditCategoryLogon, AuditCategoryObjectAccess,
	// AuditCategoryPrivilegeUse, AuditCategoryDetailedTracking,
	// AuditCategoryPolicyChange, AuditCategoryAccountManagement,
	// AuditCategoryDirectoryServiceAccess, AuditCategoryAccountLogon

	LPWSTR wComputerName = NULL; 
    LSA_HANDLE PolicyHandle; 
    NTSTATUS Status; 
	PPOLICY_AUDIT_EVENTS_INFO AuditEvents;
	LSA_OBJECT_ATTRIBUTES ObjectAttributes; 
	DWORD Flag=0;

	ZeroMemory(&ObjectAttributes, _countof(ObjectAttributes));

	Status = LsaOpenPolicy(NULL, &ObjectAttributes, POLICY_VIEW_AUDIT_INFORMATION | POLICY_SET_AUDIT_REQUIREMENTS, &PolicyHandle);

	if(Status == 0) {
		Status = LsaQueryInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (void **) &AuditEvents); 
 
	    if(Status != 0) return 0; 
 
	    // 
	    // successfully obtained AuditEventsInformation. 
	    // 
		// If audit is not turned on
	    if(AuditEvents->AuditingMode == 0) {
			// In theory, we need to turn on auditing.
			AuditEvents->AuditingMode = 1;
			Status = LsaSetInformationPolicy(PolicyHandle, PolicyAuditEventsInformation, 
                (PVOID) AuditEvents); 
		}

		if(SuccessFailure & TYPE_SUCCESS) {
			if(Switch==1) {
				Flag |= POLICY_AUDIT_EVENT_SUCCESS;
			}
		}

		if(SuccessFailure & TYPE_FAILURE) {
			if(Switch==1) {
				Flag |= POLICY_AUDIT_EVENT_FAILURE;
			}
		}

		// If the current settings mirror what we want, don't change anything.
		if((Flag == 0 && (AuditEvents->EventAuditingOptions[AuditCategory] &
			(POLICY_AUDIT_EVENT_SUCCESS | POLICY_AUDIT_EVENT_FAILURE)) == 0) ||
			Flag && AuditEvents->EventAuditingOptions[AuditCategory]) {
			Flag=POLICY_AUDIT_EVENT_UNCHANGED;
		} else if(Flag==0) {
			Flag=POLICY_AUDIT_EVENT_NONE;
		}
		
		if(Flag != POLICY_AUDIT_EVENT_UNCHANGED) {
			Status = SetAuditEvent(PolicyHandle,AuditCategory,Flag);
 			// 
			// enable audits 
			// 
			if( Status == 0 ) {
				Status = SetAuditMode(PolicyHandle, TRUE);
			}
		}

		LsaClose(PolicyHandle);
	}
 
	return(1);
} */



int SetAuditEvent(LSA_HANDLE PolicyHandle, POLICY_AUDIT_EVENT_TYPE EventType,
					   POLICY_AUDIT_EVENT_OPTIONS EventOption)
{ 
    PPOLICY_AUDIT_EVENTS_INFO pae; 
    NTSTATUS Status; 
    DWORD i; // index into EventAuditingOptions 
 
    // 
    // obtain AuditEvents 
    // 
    Status = LsaQueryInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                (void **)&pae 
                ); 
 
    if(Status != 0) return Status; 
 
    // 
    // ensure we were passed a valid EventType and EventOption 
    // 
    if((ULONG)EventType > pae->MaximumAuditEventCount) {
		LsaFreeMemory(pae);
		if(SNAREDEBUG >= 9) { DebugMsg("Invalid eventtype."); }
        return -1; 
	}
		
	if(!(EventOption & POLICY_AUDIT_EVENT_MASK)) { 
        LsaFreeMemory(pae); 
		if(SNAREDEBUG >= 9) { DebugMsg("Invalid eventoption"); }
        return -1; 
    } 
 
    // 
    // set all auditevents to the unchanged status... 
    // 
    for(i = 0 ; i < pae->MaximumAuditEventCount ; i++) { 
        pae->EventAuditingOptions[i] = POLICY_AUDIT_EVENT_UNCHANGED; 
    } 
 
    // 
    // ...and update only the specified EventType 
    // 
    pae->EventAuditingOptions[EventType] = EventOption; 
 
    // 
    // set the new AuditEvents 
    // 
    Status = LsaSetInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                pae 
                ); 
 
    // 
    // free allocated memory 
    // 
    LsaFreeMemory(pae); 
 
    return Status; 
} 

int SetAuditMode(LSA_HANDLE PolicyHandle, BOOL bEnable)
{ 
    PPOLICY_AUDIT_EVENTS_INFO AuditEvents; 
    NTSTATUS Status; 
    DWORD i; 
 
    // 
    // obtain current AuditEvents 
    // 
    Status = LsaQueryInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                (void **)&AuditEvents 
                ); 
 
    if(Status != 0) return Status; 
 
    // 
    // update the relevant member 
    // 
    AuditEvents->AuditingMode = bEnable; 
 
    // 
    // set all auditevents to the unchanged status... 
    // 
    for(i = 0 ; i < AuditEvents->MaximumAuditEventCount ; i++) { 
        AuditEvents->EventAuditingOptions[i] = POLICY_AUDIT_EVENT_UNCHANGED; 
    } 
 
    // 
    // set the new auditing mode (enabled or disabled) 
    // 
    Status = LsaSetInformationPolicy( 
                PolicyHandle, 
                PolicyAuditEventsInformation, 
                AuditEvents 
                ); 
 
    LsaFreeMemory(AuditEvents); 
 
    return Status; 
} 


// Linked List Functions

void CreateLinkedList(void)
{
    head = currentnode = NULL;
	if(SNAREDEBUG >= 7) { DebugMsg("initialising currentnode"); }
	currentnode->next = NULL;
}

int IsListEmpty(void)
{
    if (NULL == head)
        return 1;
    else
        return 0;
}

static Node * AddToList(int eventnumber, char *username, char *match, int criticality, int excludeidflag, int excludeflag,
				 int muserflag, int eventlogtype, int sourcename)
{
    static Node *newNode=NULL;

    if(SNAREDEBUG >= 7) DebugMsg("AddToList()");

	if(!username || !match) {
		return(NULL);
	}

    newNode = (Node *) malloc(sizeof(Node));

    if (newNode == NULL) {
        if(SNAREDEBUG >= 7) DebugMsg("AddToList(): error in dynamic memory allocation\nCould not add a new objective into our linked list. You may be low on memory.\n");
        return(NULL);
    }

	newNode->event_number=eventnumber;
	newNode->criticality=criticality;
	newNode->excludeflag=excludeflag;
	newNode->excludeidflag=excludeidflag;
	newNode->muserflag=muserflag;
	newNode->eventlogtype=eventlogtype;
	newNode->sourcename=sourcename;

	strncpy_s(newNode->username,_countof(newNode->username),username,_TRUNCATE);
	strncpy_s(newNode->match,_countof(newNode->username),match,_TRUNCATE);
	
    if (head == NULL) {
        head = newNode;
        newNode->next = NULL;
    } else {
        newNode->next = head;
        head = newNode;
    }

    return newNode;
}

void RemoveFromListHead(void)
{
    Node *tempPtr;

    if (NULL == head)
        return;

    tempPtr = head;
    head = head->next;

    free(tempPtr);
}

void RemoveFromList(Node* node)
{
    Node *tempPtr, *previousPtr;

    if (NULL == node) {
        return;
	}

    if (head == node) {
        RemoveFromListHead();
        return;
    }

    tempPtr = head;

    while (NULL != tempPtr) {
        previousPtr = tempPtr;
        tempPtr = tempPtr ->next;

        if (tempPtr == node) {
            previousPtr->next = tempPtr->next;
            free(tempPtr);
            break;
        }
    }
}

void ResetCurrentNode(void)
{
    currentnode = head;
	if(SNAREDEBUG >= 7) { DebugMsg("re-initialising currentnode to head"); }
}

int IsValidItem(void)
{
    return ((NULL == currentnode) ? 0 : 1);
}

Node * GetCurrentItem()
{
    return (currentnode);
}

void NextItemInList(void)
{
	if (NULL == currentnode) {
        return;
	}
    currentnode = currentnode->next;
	if(SNAREDEBUG >= 7) { DebugMsg("currentnode is moving to the next item"); }
}

void DestroyList(void)
{
	DWORD dwWaitRes=0;
	MsgCache *temp;
    if (NULL == head) {
        return;
    }

	MCCount=0;
	while(hosthead) {
		HostNode *th;
		th = hosthead;
		hosthead = th->next;
		if (th->Socket != INVALID_SOCKET) closesocket(th->Socket);
		free(th);
	}
	hosthead=NULL;
	hostcurrentnode=NULL;
    while (NULL != head) {
        Node *tempPtr = head;
        head = head->next;

        free(tempPtr);
    }
	head = NULL;
	currentnode=NULL;
	dwWaitRes = WaitForSingleObject(hMutex,1000);
	//We should be the only ones, so success or fail, we need to get rid of this list
	//EventCurrent = EventHead;
	//while (EventCurrent) {
	//	temp = EventCurrent;
	//	EventCurrent = EventCurrent->next;
	//	free(temp);
	//}
	//EventHead=NULL;
	//EventTail=NULL;
	//EventCurrent=NULL;
	//EventCount=0;
	MCCurrent = MCTail;
	while (MCCurrent) {
		temp = MCCurrent;
		MCCurrent = MCCurrent->prev;
		free(temp);
	}
	MCHead=NULL;
	MCTail=NULL;
	MCCurrent=NULL;
	MCCount=0;

	ReleaseMutex(hMutex);

}


void CSnarecoreService::OnShutdown() {
	// Audit: Set that global variable to TRUE so that the threads
	// receive the terminate message

	g_Info.bTerminate=TRUE;
	
	if(SNAREDEBUG >= 2) { DebugMsg("SNARE Shutdown request received"); }

	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);


	// Call a fake event so that the subroutine	gets the shutdown message
	// through the setting of g_Info.bTerminate
	if(m_hEventList)
		::SetEvent(m_hEventList);
}

void CSnarecoreService::OnStop() {
	g_Info.bTerminate=TRUE;
	
	if(SNAREDEBUG >= 2) { DebugMsg("SNARE Stop request received"); }
	
	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);

	// Call a fake event so that the subroutine	gets the shutdown message
	// through the setting of g_Info.bTerminate
	if(m_hEventList)
		::SetEvent(m_hEventList);
}

void CSnarecoreService::OnSignal() {
	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);
}

// Process user control requests
BOOL CSnarecoreService::OnUserControl(DWORD dwOpcode)
{
    switch (dwOpcode) {
    case SERVICE_CONTROL_USER + 0:

        // Save the current status in the registry
        SaveStatus();
        return TRUE;

    default:
        break;
    }
    return FALSE; // say not handled
}

// Save the current status in the registry
void CSnarecoreService::SaveStatus()
{
	// Save off our current position in each of our log files.
	EvtRender(NULL, hEvtBookmark[0], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[0], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[1], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[1], &dwEventIDSize, NULL);
	EvtRender(NULL, hEvtBookmark[2], EvtRenderBookmark, SIZE_EVENTREAD, szEventIDRead[2], &dwEventIDSize, NULL);
	MyWriteProfileWString("Status","LOG_TYPE_SECURITY",szEventIDRead[0]);
	MyWriteProfileWString("Status","LOG_TYPE_SYSTEM",szEventIDRead[1]);
	MyWriteProfileWString("Status","LOG_TYPE_APPLICATION",szEventIDRead[2]);
}


// Configuration reading routines

void GetHostname(char * Hostname,int size)
{
	// Grab the fully qualified hostname
	// Note: if the user has explicitly set a hostname in the registry, use that instead.

	if(!Hostname) return;
	if(!size) return;

	Hostname[0]='\0';
	MyGetProfileString("Config","Clientname",Hostname,size);
	if(Hostname[0]=='\0') {
		GetFQDN(Hostname,size);
	}
}

void GetDestPort(DWORD * dwDestPort)
{
	if(!dwDestPort) return;
	// Where should we be sending this stuff (syslog ID)
	*dwDestPort=MyGetProfileDWORD("Network","DestPort",6161);
}

void GetCrit(DWORD * dwCrit)
{
	if(!dwCrit) return;
	*dwCrit=MyGetProfileDWORD("Config","CritAudit",0);
}

void GetSyslog(DWORD * dwSyslog)
{
	if(!dwSyslog) return;
	*dwSyslog=MyGetProfileDWORD("Network","SyslogDest",13);
}

void GetSyslogDynamic(DWORD * dwSyslogDynamic)
{
	if(!dwSyslogDynamic) return;
	*dwSyslogDynamic=MyGetProfileDWORD("Network","SyslogDynamicCritic",0);
}

void GetSyslogHeader(DWORD * dwSyslogHeader)
{
	if(!dwSyslogHeader) return;
	*dwSyslogHeader=MyGetProfileDWORD("Network","Syslog",0);
}

void GetWEBSERVER_ACTIVE(DWORD * WEBSERVER_ACTIVE)
{
	if(!WEBSERVER_ACTIVE) return;
	*WEBSERVER_ACTIVE=MyGetProfileDWORD("Remote","Allow",0);
}

void GetPortNumber(DWORD * dwPortNumber)
{
	DWORD dwUsePort;

	if(!dwPortNumber) return;
	*dwPortNumber=6161;
	dwUsePort=MyGetProfileDWORD("Remote","WebPortChange",0);
	if(dwUsePort) {
		*dwPortNumber=MyGetProfileDWORD("Remote","WebPort",6161);
	}
}

void GetChecksum(BOOL *ActivateChecksum)
{
	DWORD Check=0;
	Check=MyGetProfileDWORD("Config","Checksum",0);
	*ActivateChecksum = (BOOL)Check;
}

void GetDestination(char * lpszDestination,int size)
{
	if(!lpszDestination) return;
	if(!size) return;
	
	strncpy_s(lpszDestination,size,"127.0.0.1",_TRUNCATE);
	if(!MyGetProfileString("Network","Destination",lpszDestination,size))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		MyWriteProfileString("Network","Destination",lpszDestination);
	}
}

void GetDelim(char * DELIM,int size)
{
	if(!DELIM) return;
	if(size < 2) return;

	DELIM[0]=9;	// TAB character
	DELIM[1]='\0';
	// Only use a different character for delimiters if we're sending data via syslog.
	MyGetProfileString("Config","Delimiter",DELIM,size);
}

void GetPassword(char * lpszPassword,int size)
{
	DWORD dwUsePassword;

	if(!lpszPassword) return;
	if(!size) return;

	strncpy_s(lpszPassword,size,"",_TRUNCATE);
	dwUsePassword=MyGetProfileDWORD("Remote","AccessKey",0);
	if(dwUsePassword) {
		if(!MyGetProfileString("Remote","AccessKeySet",lpszPassword,size))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strncpy_s(lpszPassword,size,"",_TRUNCATE);
		}
	}
}

void GetIPAddress(char * lpszIPAddress,int size)
{
	DWORD dwRestrictIP;

	if(!lpszIPAddress) return;
	if(!size) return;

	strcpy_s(lpszIPAddress,size,"");
	dwRestrictIP=MyGetProfileDWORD("Remote","Restrict",0);

	if(dwRestrictIP) {
		if(!MyGetProfileString("Remote","RestrictIP",lpszIPAddress,SIZE_OF_RESTRICTIP))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strncpy_s(lpszIPAddress,size,"127.0.0.1",_TRUNCATE);
		}
	}
}

void GetClearTabs(DWORD * ClearTabs)
{
	if(!ClearTabs) return;
	// If the user SPECIFICALLY does not want TABS in the output,
	// even IF the delimiter is not a TAB:
	*ClearTabs=MyGetProfileDWORD("Config","ClearTabs",0);
}


void GetSocketType(DWORD * SocketType)
{
	if(!SocketType) return;
	*SocketType=MyGetProfileDWORD("Network","SocketType",0);
}


FILE * GetOutputFile() {
	DWORD FileExport=0;
	char tempdir[1024]="";
	char tempdir2[1024];
	int returncode=0;
	time_t currenttime;
	struct tm newtime;
	FILE * fp;
	errno_t err;

	FileExport=MyGetProfileDWORD("Config","FileExport",0);
	if(!FileExport) {
		return(NULL);
	}
	
	// Ok, the user wants to save the data off to a file.
	// Pull back our directory location.
	ExpandEnvironmentStrings("%SystemRoot%\\system32\\LogFiles",tempdir,1024);
	returncode=DirExists(tempdir);
	if(returncode== -1) {
		return(NULL);
	}
	if(returncode==0) {
		// Create it...
		returncode=CreateDirectory(tempdir,NULL);
		if(!returncode) {
			return(NULL);
		}
	}
	ExpandEnvironmentStrings("%SystemRoot%\\system32\\LogFiles\\Snare",tempdir,1024);
	returncode=DirExists(tempdir);
	if(returncode== -1) {
		return(NULL);
	}
	if(returncode==0) {
		// Create it...
		returncode=CreateDirectory(tempdir,NULL);
		if(!returncode) {
			return(NULL);
		}
	}

	time(&currenttime);                
	localtime_s(&newtime,&currenttime);
	_snprintf_s(tempdir2,_countof(tempdir2),_TRUNCATE,"%s%04d%02d%02d.log","%SystemRoot%\\system32\\LogFiles\\Snare\\",newtime.tm_year+1900,newtime.tm_mon+1,newtime.tm_mday);
	ExpandEnvironmentStrings(tempdir2,tempdir,1024);
	err = fopen_s(&fp,tempdir,"a");
	return(fp);

}

int DirExists(char * dir)
{
    WIN32_FIND_DATA data;
    HANDLE hFile = FindFirstFile(dir, &data);

	if(!dir) {
		return(-1);
	}

    if (hFile == INVALID_HANDLE_VALUE) { // directory doesn't exist
        return FALSE;
    } else {
        // is it folder or file?
        FindClose(hFile);
        if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
            return TRUE;
		}
        return -1;
    }
}

// END Configuration Reading Routines

int StartWebThread(HANDLE event)
{
	int threadid=0;
	
	threadid=(int)_beginthread( HandleWebThread, 0, event );
	if(SNAREDEBUG >= 5) { DebugMsg("DEBUG: Starting web thread %d..",threadid); }
	if(threadid==-1)
	{
		if(SNAREDEBUG >= 5) DebugMsg("Error in web thread creation");
		return(-1);
	}
	return(1);
}

void HandleWebThread(HANDLE event)
{
	HANDLE web_hEventList[2]; // seven elements at the moment.
	time_t currenttime,lasttime;
	DWORD dwWaitRes=0;
	DWORD dwWaitReset=0;
	
	time(&lasttime);
	// Web server
	web_hEventList[0] = CreateEvent(NULL, TRUE, FALSE, NULL);

	// Web server reset
	web_hEventList[1] = CreateEvent(NULL, TRUE, FALSE, NULL);
	
	if(web_hEventList[0] == NULL)
	{	if(SNAREDEBUG >= 5) { DebugMsg("CreateEvent() Web Server failed"); }	_endthread();	}
	if(web_hEventList[1] == NULL)
	{	if(SNAREDEBUG >= 5) { DebugMsg("CreateEvent() Web Server Reset failed"); }	_endthread();	}

	if(SNAREDEBUG >= 5) { DebugMsg("Starting HandleWebThread."); }
	StartThread(web_hEventList[0]);
	//while (m_bIsRunning) {
	while (1) {
		dwWaitRes=WaitForMultipleObjects(2,web_hEventList,FALSE,500);
		if(dwWaitRes != WAIT_FAILED) {
			if(dwWaitRes == WAIT_OBJECT_0) {
				// Web server has data to read.
				ResetEvent(web_hEventList[0]);
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Connect."); }

				if(WEBSERVER_ACTIVE) {
					// Let handleconnect have the eventlist pointer, in case it needs
					// to signal a restart
					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: About to HandleConnect"); }
					HandleConnect(web_hEventList[1]);

					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: Running thread again."); }
					StartThread(web_hEventList[0]);
				}
				
				continue;
			} else if (dwWaitRes == WAIT_OBJECT_0+1) {
			// We need to re-read our configuration file.
				if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Reset."); }
				ResetEvent(web_hEventList[1]);
			    
				WebResetFlag=FULL_WEB_RESET;
				//don't end straigh away, we need to finish handling any other connections, just sleep for now
				//Sleep(10);
				SetEvent(event);
				_endthread();

				continue;
			} else if (dwWaitRes == WAIT_TIMEOUT) {
				// For the time being, we want to reset the web server every 20 mins
				// This is done using the last values that were grabbed
				time(&currenttime);
				if ((currenttime - lasttime) > DNS_CHECK_TIME) {
					lasttime=currenttime;
					if(SNAREDEBUG >= 5) { DebugMsg("HandleWebThread: WEB Server Timeout Reset."); }
					WebResetFlag=BASIC_WEB_RESET;
					SetEvent(event);
					//Sleep(10);
					_endthread();
				}
			}
		}
	}
	
	_endthread();
}

int Create_EventLog_Hive()
{
	int i_return_val=0, cont=1, i=0, result;
	DWORD dwDisp;
	DWORD subkeys;
	DWORD maxsubkeylen;
	DWORD maxvaluenamelen;
	DWORD maxvaluelen;
	HKEY hKey,key;
	TCHAR szKeyName[MAX_STRING]="";
	TCHAR szNewKeyName[MAX_STRING]="";
	//TCHAR EventLogSourceName[MAX_LOG_TYPE + 1][_MAX_PATH + 1];
	TCHAR szResFile[_MAX_PATH]="";
	TCHAR szResName[_MAX_PATH]="";

	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, EVENTLOG_KEY_NAME, 0, KEY_ALL_ACCESS | DELETE,&hKey ) 
		== ERROR_SUCCESS )
	{
		if ( RegDeleteTree(hKey,NULL) != ERROR_SUCCESS ) {
		
			//The registry key was unable to be deleted. Return.
			//if (SNAREDEBUG >= 2) DebugMsg("%d",GetLastError());
			i_return_val += 2;
			return i_return_val;
		}
		RegCloseKey(hKey);
		//key must not exist
	}
	//The registry key does not exist, now we can build the fresh one
	//Try and create it.
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, EVENTLOG_KEY_NAME,0,REG_NONE,
				       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
					   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
	{
		//The registry key was unable to be deleted. Return.
		i_return_val += 2;
		return i_return_val;
	}

	//for (i = 0; i < MAX_LOG_TYPE; i++) {
		//wsprintf(szKeyName, _T("SYSTEM\\CurrentControlSet\\Services\\EventLog\\%s"), EventLogSourceName[i]);
//		wsprintf(szKeyName, _T("SYSTEM\\CurrentControlSet\\Services\\EventLog"));
//		RegCopyTree(HKEY_LOCAL_MACHINE,szKeyName,hKey);
	//}
	i=0;
	wsprintf(szKeyName, _T("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WINEVT\\Publishers"));
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0, KEY_ALL_ACCESS,&key ) 
		!= ERROR_SUCCESS )
	{
		//The registry key was unable to be deleted. Return.
		i_return_val += 4;
		RegCloseKey(hKey);
		return i_return_val;
	}
	result=RegQueryInfoKey(key,
		NULL,			// class buffer
		NULL,			// pointer to class buffer size
		NULL,			// reserved
		&subkeys,		// number of subkeys here
		&maxsubkeylen,	// maximum subkey name length
		NULL,			// max class name length
		NULL,			// number of values associated with the key
		&maxvaluenamelen,// maximum value name length
		&maxvaluelen,	// maximum value length
		NULL,			// security descriptor
		NULL);			// last write time

	if(result != ERROR_SUCCESS) {
		i_return_val += 4;
		return i_return_val;
	}

	DWORD namelen = maxvaluenamelen + 1;
	DWORD valuelen = maxvaluelen + 1;
	DWORD dwMaxPath;			
	DWORD dwResFileType,dwResNameType; // Temporary variable.
	// FREE These
	LPTSTR subkeyname = new TCHAR [maxsubkeylen + 1];
	LPTSTR name       = new TCHAR [maxvaluenamelen + 1];
	LPBYTE value      = new BYTE [maxvaluelen + 1];
	HKEY subkey;

	while(cont) {
		DWORD length = maxsubkeylen + 1;
		result = RegEnumKeyEx(key, i,
			subkeyname,
			&length,
			NULL, // reserved
			NULL, // class name buffer
			NULL, // class name buffer length
			NULL); // file time

		if(result == ERROR_NO_MORE_ITEMS) {
			cont=0;
			break;
		}
		if(result != ERROR_SUCCESS) {
			cont=0;
			break;
		}
		i++;
		
		result = RegOpenKeyEx(key,  // root key
            subkeyname, // key name
            0,  // reserved
            KEY_READ, // access desired
            &subkey); // result goes here
		
		if(result != ERROR_SUCCESS) {
			
			// Should really find out the value of this.
			if(result == 5) {
				// Permission denied
				continue;
			} else {
				cont=0;
				break;
			}
		}

		dwMaxPath = _MAX_PATH + 1;
		result = RegQueryValueEx(subkey,  // root key
            NULL, // key name _T("ResourceFileName"),
            0,  // reserved
            &dwResNameType, // access desired
            (LPBYTE)szResName,
			&dwMaxPath); // result goes here
		if (result != ERROR_SUCCESS) {
			RegCloseKey(subkey);
			continue;
		}
		if (SNAREDEBUG >= 9) DebugMsg("szResName: %s",szResName);
		dwMaxPath = _MAX_PATH + 1;
		result = RegQueryValueEx(subkey,  // root key
            _T("ResourceFileName"), // key name 
            0,  // reserved
            &dwResFileType, // access desired
            (LPBYTE)szResFile,
			&dwMaxPath); // result goes here
		if (result != ERROR_SUCCESS) {
			if (result == ERROR_MORE_DATA) {
				//DebugMsg("err more data");
			}
			RegCloseKey(subkey);
			continue;
		}
		if (SNAREDEBUG >= 9) DebugMsg("szResFile: %s",szResFile);
		HKEY newEventKey;
		wsprintf(szNewKeyName,"%s\\%s",EVENTLOG_KEY_NAME,szResName);
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, szNewKeyName,0,REG_NONE,
				       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
					   NULL,&newEventKey,&dwDisp) != ERROR_SUCCESS)
		{
			//The registry key was unable to be deleted. Return.
			i_return_val += 2;
			RegCloseKey(subkey);
			continue;
		}
		if ( RegSetValueEx(newEventKey, _T("EventMessageFile"),0,REG_EXPAND_SZ,
			(CONST BYTE *) szResFile,(DWORD)strlen(szResFile)) 
			!= ERROR_SUCCESS )
		{
			i_return_val += 4;
			RegCloseKey(subkey);
			RegCloseKey(newEventKey);
			continue;
		}
		RegCloseKey(subkey);
		RegCloseKey(newEventKey);
	}
	
	delete [] subkeyname;
    delete [] name;
    delete [] value;
	return(0);
	

		
	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

// Duplicate of the CNTService DebugMsg
void DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[50];
	char time[50];

	if(!pszFormat) return;
	
	SYSTEMTIME st;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,_countof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,_countof(time));

	_snprintf_s(buf, 8192,_TRUNCATE, "[SNARE %s](%lu - %s %s): ",SNARE_VERSION,GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf_s(&buf[strlen(buf)],8192-strlen(buf),_TRUNCATE,pszFormat,arglist);
	va_end(arglist);
    _snprintf_s(buf,8192,_TRUNCATE,"%s\n",buf);

	if(buf) { printf("%s",buf); fflush(stdout); }

#ifdef DEBUG_TO_FILE
	FILE *fp;
	errno_t err;

	if(!strlen(pszFormat)) {
		// Send a "" to truncate the file back to zero
		err=fopen_s(&fp,"C:\\SNAREDebug.log","wt");
	} else {
		err=fopen_s(&fp,"C:\\SNAREDebug.log","a");
	}
	if(fp) {
		fprintf(fp,"%s",buf);
		fflush(fp);
		fclose(fp);
	}
#endif
}

// Dump the current eventlog record to a file.
void DEBUGDumpEventLog(DWORD EventTriggered,DWORD dwBytesRead,PEVENTLOGRECORD pELR)
{
	FILE *fp;
	errno_t err;
	err = fopen_s(&fp, "SNAREEvt.log","w");
	if(!err) {
		
		fwrite(&EventTriggered,sizeof(EventTriggered),1,fp);
		fwrite(pELR,dwBytesRead,1,fp);
		fflush(fp);
		fclose(fp);
	}
}
