/*
FILE: SnareCore.h
*/

#include "NTService.h"
#include "support.h"
#include <WinEvt.h>
#include <Dbt.h>
#include <process.h>
#include <ntsecapi.h>

#define MAX_STRING 1024
#define MAX_OUTPUT_STRING 8192
#define MAX_USERNAME	512
#define MSG_COUNT_SAVE_POS 100

#define LOG_TYPE_SECURITY 0
#define LOG_TYPE_SYSTEM 1
#define LOG_TYPE_APPLICATION 2
#define LOG_TYPE_DS 3
#define LOG_TYPE_DNS 4
#define LOG_TYPE_FRS 5
#define MAX_LOG_TYPE 5

#define SIZE_EVENTREAD 1024

// Web reset flags
#define BASIC_WEB_RESET 1
#define FULL_WEB_RESET  2

#define DNS_CHECK_TIME 1200  //time in seconds between DNS checks for remote access and event transmission

struct _node
{
	int event_number;				// The event number this is supposed to match
	int criticality;				// How critical is this particular node
	int excludeflag;				// Include or exclude users?
	int excludeidflag;				// Include or exclude event IDs?
	int eventlogtype;				// binary Warning / Information / Success / Failure / Error
	int sourcename;					// binary Security / Application / Active Directory etc
	char username[SIZE_OF_USERMATCH];	// Remember, this will be a wildcard match.
	BOOL muserflag;					// Are there multiple users?
	char match[SIZE_OF_GENERALMATCH];
	struct _node *next;
};

typedef struct _node Node;

// Store a linked list of our target destinations.
struct _hostnode
{
	SOCKET Socket;
	struct sockaddr_in server;
	char HostName[512];
	DWORD SocketType;
	struct _hostnode *next;
};

typedef struct _hostnode HostNode;


class CSnarecoreService : public CNTService
{
public:
	CSnarecoreService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();
	void OnStop();
	void OnSignal();

    void SaveStatus();

// 	int SNAREDEBUG;

private:
	HANDLE m_hEventList; // just the web server left.
};

// Function Prototypes.
BOOL	InitWinsock				(char *, int);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

void	syslogdate				(char *, struct tm *);

int		wildmatch				(char *, char *);
void	splitstrings			(char *, int, char *, int);

SOCKET	ConnectToServer			(HostNode *, UINT, char *, int, DWORD);

BOOL	GetEventLogType			(TCHAR *sz, unsigned short uEventType, DWORD length);
BOOL	SendToSocket			(HostNode *hcn, char *buf, int nSize, char *szError, int eSize);
BOOL	GetSIDType				(SID_NAME_USE _SidNameUse, TCHAR *szSIDType, DWORD length);
BOOL	ExpandStrings			(PEVENTLOGRECORD pELR, char *Trigger, char *StringBuffer, DWORD length);
BOOL	GetDataString			(PEVENTLOGRECORD pELR, char *StringBuffer, DWORD length);
void	GetArgs					(const EVENTLOGRECORD *pELR, char **Args);

DWORD WINAPI EventSubCallBack(EVT_SUBSCRIBE_NOTIFY_ACTION Action, PVOID Context, EVT_HANDLE Event);
BOOL	CheckLogExists			(TCHAR *LogName);
char *	GetParameterMsg			(char *message, char *tmp);
void	GetFQDN					(char *string,int length);

int		ReadObjectives();
static Node *	AddToList		(int eventnumber, char *username, char *match, int criticality, int excludeidflag,
								 int excludeflag, int muserflag, int eventlogtype, int sourcename);

static Node * FastCheckObjective	(int eventnumber, int etype, int stype);
int	CheckObjective				(Node * Match, int eventnumber, char *username, char *match);
// Node *	CheckObjective			(int eventnumber, char *username, char *match, int etype, int stype);
void	ResetCurrentNode		(void);
void	NextItemInList			(void);
Node *	GetCurrentItem			(void);
int		IsValidItem				(void);
void	DestroyList				(void);
char *  string_split			(char divider,char *string,char *destination,int destlength);

HostNode *	OpenSockets			(char *lpszDestination, DWORD dwDestPort, DWORD SocketType);


// BOOL	SwitchAudit				(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure, BOOL Switch);
// BOOL	ClearAllAuditCategories	(void);
void	ClearAuditFlags			(void);
int		SetAuditFlag			(POLICY_AUDIT_EVENT_TYPE AuditCategory, DWORD SuccessFailure);
BOOL	ApplyAudit				(void);
BOOL	TurnOnEvent				(DWORD EventID,DWORD SuccessFailure);

int		SetAuditEvent			(LSA_HANDLE PolicyHandle, POLICY_AUDIT_EVENT_TYPE EventType,
									 POLICY_AUDIT_EVENT_OPTIONS EventOption);
int		SetAuditMode			(LSA_HANDLE PolicyHandle, BOOL bEnable);

void	GetHostname				(char * Hostname,int size);
void	GetDestPort				(DWORD * dwDestPort);
void	GetSocketType			(DWORD * SocketType);
void	GetSyslog				(DWORD * dwSyslog);
void	GetSyslogDynamic		(DWORD * dwSyslogDynamic);
void	GetSyslogHeader			(DWORD * dwSyslogHeader);
void	GetWEBSERVER_ACTIVE		(DWORD * WEBSERVER_ACTIVE);
void	GetPortNumber			(DWORD * dwPortNumber);
void	GetChecksum				(BOOL * ActivateChecksum);
void	GetCrit					(DWORD * dwCrit);
void	GetDestination			(char * lpszDestination,int size);
void	GetDelim				(char * DELIM,int size);
void	GetPassword				(char * lpszPassword,int size);
void	GetIPAddress			(char * lpszIPAddress,int size);
void	GetClearTabs			(DWORD * ClearTabs);
FILE *  GetOutputFile			(void);
int		DirExists				(char *);

int		StartWebThread(HANDLE event);
void	HandleWebThread(HANDLE event);
int		Create_EventLog_Hive();

void	DEBUGDumpEventLog(DWORD EventTriggered,DWORD dwBytesRead,PEVENTLOGRECORD pELR);

typedef struct _tagEVENTID
{
	TCHAR lpszMachineName[_MAX_PATH + 1];
	TCHAR lpszEventName[_MAX_PATH + 1];
	DWORD dwEventId;
	HWND  hwndDlg;
} EVENTID, *LPEVENTID;

// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;