//
// SNARE - Audit / EventLog analysis and forwarding
// Copyright 2001-2007 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <winsock2.h>
#include <windows.h>
#include <lm.h>
#include <iads.h>

#include <comdef.h>
#include <activeds.h>

#include <windows.h>
#include <Adshlp.h>
#include <comutil.h>

#include "WebPages.h"
#include "Version.h"

#include "support.h"
#include "MD5.h"

#include "webserver.h"

extern void DebugMsg(const char* pszFormat, ...);

extern int SNAREDEBUG;
extern HANDLE hMutex;
extern MsgCache *MCHead;

#define snprintf_s _snprintf_s

// Make sure we return the size, or zero (for strings).
// Note that for the most part, the socket will be ignored
int HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size,SOCKET http_socket, HANDLE event)
{
	int returncode=0, refreshflag=0;
	char *ArgPosition;
	char TBuffer[2048]="";
	
	if(SNAREDEBUG >= 5) { DebugMsg("HandleWebPages"); }
	
	if(!HTTPBuffer || !HTTPOutputBuffer) {
		return(0);
	}

	// Stuff without the header/footer
	if(!strcmp(HTTPBuffer,"/intersect.gif")) {
		return(InterSectImage(HTTPBuffer,HTTPOutputBuffer,size));
	} else if(!strcmp(HTTPBuffer,"/critical.gif")) {
		return(InterSectImageCrit(HTTPBuffer,HTTPOutputBuffer,size));
	} else if(!strcmp(HTTPBuffer,"/priority.gif")) {
		return(InterSectImagePri(HTTPBuffer,HTTPOutputBuffer,size));
	} else if(!strcmp(HTTPBuffer,"/warning.gif")) {
		return(InterSectImageWarn(HTTPBuffer,HTTPOutputBuffer,size));
	} else if(!strcmp(HTTPBuffer,"/info.gif")) {
		return(InterSectImageInfo(HTTPBuffer,HTTPOutputBuffer,size));
	} else if(!strcmp(HTTPBuffer,"/clear.gif")) {
		return(InterSectImageClear(HTTPBuffer,HTTPOutputBuffer,size));
	} else {
		char * pBuffer=HTTPOutputBuffer;
		int length=0;
		int psize=0;
		
		if(SNAREDEBUG >= 5) { DebugMsg("Processing Request"); }

		ArgPosition=strstr(HTTPBuffer,"?");
		// No arguments passed?
		if(!ArgPosition) {
			// Set argument position to the beginning of the buffer.
			ArgPosition=HTTPBuffer;
		} else {
			ArgPosition++;
		}

		if(!strcmp(HTTPBuffer,"/LocalUsers")) {
			DisplayTextHeader(http_socket);
			ShowLocalUsers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/DomainUsers")) {
			DisplayTextHeader(http_socket);
			ShowDomainUsers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/LocalGroupMembers")) {
			DisplayTextHeader(http_socket);
			ShowLocalGroupMembers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/DomainGroupMembers")) {
			DisplayTextHeader(http_socket);
			ShowDomainGroupMembers(http_socket);
			return(-1);
		} else if(!strncmp(HTTPBuffer,"/RegDump",8)) {
			// DisplayTextHeader(http_socket);
			DumpRegistry(http_socket,ArgPosition,TBuffer,_countof(TBuffer));
			if(!strlen(TBuffer)) {
				return(-1);
			}
		}
		if(!strncmp(HTTPBuffer,"/eventlog",9)) refreshflag=1;
		returncode=DefaultHeader(HTTPBuffer,pBuffer,size, refreshflag);
		length=(int)strlen(HTTPOutputBuffer);
		
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}


		// Web pages
		if(!strcmp(HTTPBuffer,"/network")) {
			returncode+=Network_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/network?",9)) {
			strncpy_s(pBuffer,psize,"Nothing here yet",_TRUNCATE);
		} else if(!strcmp(HTTPBuffer,"/remote")) {
			returncode+=Remote_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setremote",10)) {
			returncode+=Remote_Set(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/objective",10)) {
			returncode+=Objective_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setobjective",13)) {
			returncode+=Objective_Display(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/changeobjective",16)) {
			returncode+=Objective_Result(HTTPBuffer,pBuffer,psize);
		} else if(!strcmp(HTTPBuffer,"/restart")) {
			returncode+=Restart(HTTPBuffer,pBuffer,psize,event);
		} else if(!strncmp(HTTPBuffer,"/restart?",10)) {
			strncpy_s(pBuffer,psize,"Nothing here yet",_TRUNCATE);
		} else if(!strncmp(HTTPBuffer,"/setnetwork",11)) {
			returncode+=Network_Set(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/status",6)) {
			returncode+=Status_Page(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/eventlog",9)) {
			returncode+=Current_Events(ArgPosition,pBuffer,psize);
		} else if(strlen(TBuffer)) {
			strncpy_s(pBuffer,psize,TBuffer,_TRUNCATE);
		} else if(!strcmp(HTTPBuffer,"/")) {
			returncode=+Status_Page(ArgPosition,pBuffer,psize);
		} else {
			// Here: Consider returning a 404 instead.
			// returncode=+Status_Page(ArgPosition,pBuffer,psize);
			if(SNAREDEBUG >= 5) { DebugMsg("No page - sending a 404"); }
			Display404(http_socket);
			return(-1);
		}

		pBuffer='\0';
		pBuffer = HTTPOutputBuffer;
		length=(int)strlen(HTTPOutputBuffer);
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}

		returncode+=DefaultFooter(HTTPBuffer,pBuffer,psize);
	}

	return(returncode);
}


// This page will be usefull for debug information
int Status_Page(char *source, char *dest, int size)
{
	snprintf_s(dest,size,_TRUNCATE,"<HTML><BODY><H2><CENTER>SNARE Version %s Status Page</H2></CENTER><P><center><font color=green>Snare for Windows is currently active.</font></CENTER></BODY></HTML>",SNARE_VERSION);
	return(0);
}

int Network_Config(char *source, char *dest, int size)
{
	//All strncpy_s or strncat_s functions in this routine have been designed avoid overflows
	Reg_Config config_struct;
	Reg_Network network_struct;
	DWORD dw_config_error,dw_network_error;
	char str_DestPort[10];
	char str_conferr[10],str_neterr[10];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug","DYNAMIC"};
	UINT i,i_SyslogFacility,i_SyslogPriority;
		
	dw_config_error = Read_Config_Registry(&config_struct);
	dw_network_error = Read_Network_Registry(&network_struct);

	// This function will display the form used to set the audit configuration
	// The result of the form will be sent to "network_set"
	strncpy_s(dest,size,"<form method=get action=setnetwork><h2><center>SNARE Network Configuration</h2>",_TRUNCATE);

	// Will display an error if unable to completely read from the registry
	if ((dw_network_error > 0) || (dw_config_error > 0)) {
		dw_network_error += WEB_READ_NETWORK_ERROR_CODE;
		dw_config_error += WEB_READ_CONFIG_ERROR_CODE;
		_itoa_s(dw_network_error,str_neterr,10);
		_itoa_s(dw_config_error,str_conferr,10);

		strncat_s(dest,size,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",_TRUNCATE);
		strncat_s(dest,size,str_neterr,_TRUNCATE);
		strncat_s(dest,size,".",_TRUNCATE);
		strncat_s(dest,size,str_conferr,_TRUNCATE);
		strncat_s(dest,size,"</b><br>",_TRUNCATE);
	}

	strncat_s(dest,size,"<br>The following network configuration parameters of the SNARE unit is set to the following values:<br><br>" \
				"<table  width=70% border=0>" \
				"<tr bgcolor=#FFFFCC><td>Override detected DNS Name with: </td>" \
				"<td><input type=text name=str_ClientName size=25 value=\"",_TRUNCATE);
	
	strncat_s(dest,size,config_struct.str_ClientName,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);


	// Here: Two alternatives: Allow a user-supplied comma-separated list, or
	// alternatively, add a new element for each new system?
	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Destination Snare Server address </td><td><input type=text name=str_Destination size=25 value=\"",_TRUNCATE);
	strncat_s(dest,size,network_struct.str_Destination,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Destination Port</td><td><input type=text name=dw_DestPort size=8 value=\"",_TRUNCATE);
	_itoa_s(network_struct.dw_DestPort,str_DestPort,10);
	strncat_s(dest,size,str_DestPort,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Perform a scan of ALL objectives, and display the maximum criticality?</td><td><input type=checkbox name=dw_CritAudit",_TRUNCATE);
	if (config_struct.dw_CritAudit != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);	
	}
	strncat_s(dest,size,"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Allow SNARE to automatically set audit configuration?</td><td><input type=checkbox name=dw_Audit",_TRUNCATE);
	if (config_struct.dw_Audit != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);
	}
	strncat_s(dest,size,"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Allow SNARE to automatically set file audit configuration?</td><td><input type=checkbox name=dw_FileAudit",_TRUNCATE);
	if (config_struct.dw_FileAudit != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);	
	}
	strncat_s(dest,size,"></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Export Snare Log data to a file?</td><td><input type=checkbox name=dw_FileExport",_TRUNCATE);
	if (config_struct.dw_FileExport != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);
	}
	strncat_s(dest,size,"></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",_TRUNCATE);


	// First 3 bits = facility (eg: emerg, alert, etc.)
	// Rest = priority. Note that there is a gap between ftp and local1.
	i_SyslogPriority = (UINT)network_struct.dw_SyslogDest & 7;
	i_SyslogFacility = (UINT)network_struct.dw_SyslogDest >> 3;
	if(i_SyslogFacility > 11) { 
		i_SyslogFacility = i_SyslogFacility - 4;
	}

	if(network_struct.dw_DynamicCritic) {
		i_SyslogPriority=8;
	}

	//Need to convert this next section to YES or NO
	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Enable SYSLOG Header?</td><td><input type=checkbox name=dw_Syslog",_TRUNCATE);
	if (network_struct.dw_Syslog != 0) {
		strncat_s(dest,size," checked",_TRUNCATE);
	}
	strncat_s(dest,size,"></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>SYSLOG Facility </td><td><select name=SyslogFacility>",_TRUNCATE);
	for (i = 0; i <= 19; i++)
	{
		strncat_s(dest,size,"<option",_TRUNCATE);
		if (i == i_SyslogFacility) {
			strncat_s(dest,size," selected>",_TRUNCATE);
		} else {
			strncat_s(dest,size,">",_TRUNCATE);
		}
		strncat_s(dest,size,str_facility[i],_TRUNCATE);
	}
	strncat_s(dest,size,"</select></td></tr>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>SYSLOG Priority </td><td><select name=SyslogPriority>",_TRUNCATE);
	for (i = 0; i <= 8; i++) {
		strncat_s(dest,size,"<option",_TRUNCATE);
		if (i == i_SyslogPriority) {
			strncat_s(dest,size," selected>",_TRUNCATE);
		} else {
			strncat_s(dest,size,">",_TRUNCATE);
		}
		strncat_s(dest,size,str_priority[i],_TRUNCATE);
	}
	
	strncat_s(dest,size,"</select></td></tr>" \
		         "</table><br>" \
				 "<input type=submit value=\"Change Configuration\">    " \
				 "<input type=reset value=\"Reset Form\"></form>",_TRUNCATE);
	
	return(0);
}

int Network_Set(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100]="", web_port[100]="",syslog_fac[100]="",syslog_pri[100]="";
	char Argument[100]="";
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	Reg_Network network_struct;
	Reg_Config config_struct;
	DWORD dw_error_network = 1,dw_error_config = 1,dw_SyslogClass = 0;
	int i;

	if(!source || !dest || !size) {
		return(0);
	}

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy_s(dest,size,"<h2><center>SNARE Network Configuration</h2>",_TRUNCATE);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Checking is limited to ensuring the Detsination port in the range 1-65535.
	// The variable associated with the checkbox (dw_Syslog) must be
	// exactly "on" or it will be defaulted to "off".

	network_struct.dw_DestPort = -1;
	network_struct.dw_SocketType=SOCKETTYPE_UDP;	// UDP
	network_struct.dw_Syslog = 0;
	config_struct.dw_Audit = 0;
	config_struct.dw_FileAudit = 0;
	config_struct.dw_FileExport = 0;

	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_ClientName") != NULL) {
			strncpy_s(config_struct.str_ClientName,_countof(config_struct.str_ClientName),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_Destination") != NULL) {
			strncpy_s(network_struct.str_Destination,_countof(network_struct.str_Destination),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"dw_DestPort") != NULL)	{
			strncpy_s(web_port,_countof(web_port),Argument,_TRUNCATE);
		}

		if (strstr(Variable,"SyslogPriority") != NULL) {
			strncpy_s(syslog_pri,_countof(syslog_pri),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"SyslogFacility") != NULL) {
			strncpy_s(syslog_fac,_countof(syslog_fac),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"dw_Syslog") != NULL) {
			if (strcmp(Argument,"on") == 0)
				network_struct.dw_Syslog = 1;
		}
		if (strstr(Variable,"dw_Audit") != NULL) {
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_Audit = 1;
		}
		if (strstr(Variable,"dw_FileAudit") != NULL) {
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_FileAudit = 1;
		}
		if (strstr(Variable,"dw_FileExport") != NULL) {
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_FileExport = 1;
		}

		if (strstr(Variable,"dw_CritAudit") != NULL) {
			if (strcmp(Argument,"on") == 0)
				config_struct.dw_CritAudit = 1;
		}
	}

	for (i = 0; i <= 7; i++) {
		if (strstr(syslog_pri,str_priority[i]) != NULL) {
			network_struct.dw_SyslogDest = i;
			break;
		}
	}
	for (i = 0; i <= 20; i++) {
		if (strstr(syslog_fac,str_facility[i]) != NULL) {
			dw_SyslogClass = i;
			break;
		}
	}

	if(network_struct.dw_SyslogDest > 7) {
		network_struct.dw_SyslogDest=0;
		network_struct.dw_DynamicCritic=1;
	} else {
		network_struct.dw_DynamicCritic=0;
	}

	if(dw_SyslogClass > 11) {
		dw_SyslogClass = dw_SyslogClass + 4;
	}
	network_struct.dw_SyslogDest = network_struct.dw_SyslogDest | (dw_SyslogClass << 3);


	network_struct.dw_DestPort = atoi(web_port);
	if ((network_struct.dw_DestPort < 1) || (network_struct.dw_DestPort > 65535)) {
		strncat_s(dest,size,"The Destination Port value must be between 1 and 65535. Use the 'back' button to change the value.",_TRUNCATE);
	} else {

		dw_error_network = Write_Network_Registry(&network_struct);

		dw_error_config = Write_Config_Registry(&config_struct);

		if ((dw_error_network != 0) || (dw_error_config != 0)) {
			strncat_s(dest,size,"Values have NOT been changed.",_TRUNCATE);
		} else {
			strncat_s(dest,size,"Values have been changed.",_TRUNCATE);
		}
	}
	return(0);

}


int Remote_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Remote remote_struct;
	DWORD dw_remote_error;
	char str_WebPort[10];
	char str_remerr[10];

	dw_remote_error = Read_Remote_Registry(&remote_struct);

	// This function will display the form used to set the remote audit configuration
	strncpy_s(dest,size,"\n<form method=get action=setremote><h2><center>SNARE Remote Control Configuration</h2>",_TRUNCATE);

	// Will display an error if unable to completely read from the registry
	if (dw_remote_error > 0)
	{
		dw_remote_error += WEB_READ_REMOTE_ERROR_CODE;
		_itoa_s(dw_remote_error,str_remerr,10);
		
		strncat_s(dest,size,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",_TRUNCATE);
		strncat_s(dest,size,str_remerr,_TRUNCATE);
		strncat_s(dest,size,"</b><br>\n",_TRUNCATE);
	}
	strncat_s(dest,size,"<br>The following remote control configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Restrict remote control of SNARE agent to certain hosts </td><td><input type=checkbox name=dw_Restrict",_TRUNCATE);

	if (remote_struct.dw_Restrict != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>IP Address allowed to remote control SNARE </td><td><input type=text name=str_RestrictIP size=12 value=\"",_TRUNCATE);
	strncat_s(dest,size,remote_struct.str_RestrictIP,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);
	

	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Require a password for remote control? </td><td><input type=checkbox name=dw_Password",_TRUNCATE);

	if (remote_struct.dw_Password != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Password to allow remote control of SNARE </td><td><input type=password name=str_Password size=12 value=\"",_TRUNCATE);
	strncat_s(dest,size,remote_struct.str_Password,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);


	strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Change Web Server default (6161) port </td><td><input type=checkbox name=dw_PortChange",_TRUNCATE);

	if (remote_struct.dw_WebPortChange != 0)
		strncat_s(dest,size," checked",_TRUNCATE);
	strncat_s(dest,size,"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Web Server Port </td><td><input type=text name=dw_WebPort size=8 value=\"",_TRUNCATE);
	_itoa_s(remote_struct.dw_WebPort,str_WebPort,10);
	strncat_s(dest,size,str_WebPort,_TRUNCATE);
	strncat_s(dest,size,"\"></td></tr>\n",_TRUNCATE);

	strncat_s(dest,size,"</table><br>\n",_TRUNCATE);
	strncat_s(dest,size,"<input type=submit value=\"Change Configuration\">    ",_TRUNCATE);
	strncat_s(dest,size,"<input type=reset value=\"Reset Form\"></form>",_TRUNCATE);
	
	return(0);
}

int Remote_Set(char *source, char *dest, int size) 
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100];
	char Argument[100];
	Reg_Remote remote_struct;
	DWORD dw_error = 0;
	
	dw_error = Read_Remote_Registry(&remote_struct);

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy_s(dest,size,"<h2><center>SNARE Remote Control Configuration</h2>",_TRUNCATE);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Also be aware that there may not be any arguments for this objective. If a sysadmin does not want
	// remote control, then there will be no arguments.
	// Hence: Checking is limited to Webport in the range 1-65535 only if portchange is "on"
	// The three variable associated with the checkboxes (dw_Allow, dw_Restrict, and dw_PortChange) must be
	// exactly "on" or they will be defaulted to "off".
	// str_RestrictIP can be anything it wants to be, so long as it is within size bounds.

	// Configure the defaults.
	remote_struct.dw_WebPort = -1;
	remote_struct.dw_Password = 0;
	remote_struct.dw_Restrict = 0;
	remote_struct.dw_WebPortChange = 0;

	while((psource=GetNextArgument(psource,Variable,_countof(Variable)-1,Argument,_countof(Argument)-1)) != (char *)NULL) 
	{	
		if (strstr(Variable,"dw_WebPort") != NULL) {
			strncpy_s(web_port,_countof(web_port),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_RestrictIP") != NULL) {
			strncpy_s(remote_struct.str_RestrictIP,_countof(remote_struct.str_RestrictIP),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_Password") != NULL) {
			if(strcmp(Argument,remote_struct.str_Password)!=0) {
				// Changed
				// mD5 things here.
				strncpy_s(remote_struct.str_Password,_countof(remote_struct.str_Password),MD5String(Argument),_TRUNCATE);
			}
		}
		if (strstr(Variable,"dw_Password") != NULL)	{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Password = 1;
			} else {
				remote_struct.dw_Password = 0;
			}
		}
		if (strstr(Variable,"dw_Restrict") != NULL)
		{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Restrict = 1;
			} else {
				remote_struct.dw_Restrict = 0;
			}
		}
		if (strstr(Variable,"dw_PortChange") != NULL)
		{
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_WebPortChange = 1;
			} else {
				remote_struct.dw_WebPortChange = 0;
			}
		}
	}

	remote_struct.dw_WebPort = atoi(web_port);
	if ((remote_struct.dw_WebPort < 1) || (remote_struct.dw_WebPort > 65535))
	{
		strncat_s(dest,size,"The Web Port value must be between 1 and 65535. Use the 'back' button to change the value.",_TRUNCATE);
	} else {
		// Check remote_struct.str_Password against the existing password.
		
		dw_error = Write_Remote_Registry(&remote_struct);
		if (dw_error != 0)
		{
			strncat_s(dest,size,"Remote Control Values have NOT been changed. Report error: ",_TRUNCATE);
			//**********PUT AN ERROR CODE IN HERE
		} else {
			strncat_s(dest,size,"Remote Control Values have been changed.",_TRUNCATE);
		}
	}
	return(0);
}


int Objective_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0;
	int i_objective_count = 0;
	char str_obj_count[10];
	char str_user_match_metachar_remove[SIZE_OF_USERMATCH*2];
	char str_eventid_match_metachar_remove[SIZE_OF_EVENTIDMATCH*2];
	char str_general_match_metachar_remove[SIZE_OF_GENERALMATCH*2];


	strncpy_s(dest,size,"<form method=get action=setobjective><H2><CENTER>SNARE Filtering Objectives Configuration</H2>",_TRUNCATE);
		
	dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
	if (dw_objective_error == 0)
	{
		strncat_s(dest,size,"<br>The following filtering objectives of the SNARE unit are active:<br><br>" \
		"<table  width=100% border=1>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><center><td><b>Action Required</b></td><td><b>Criticality</b></td>" \
			        "<td><b>Event ID Include/Exclude</b></td><td><b>Event ID Match</b></td><td><b>User Include/Exclude</b></td><td><b>User Match</b></td><td><b>General Match</b>" \
					"</td><td><b>Return</b></td><td><b>Event Src</b></td></center></tr>",_TRUNCATE);

		while (dw_objective_error == 0)
		{
			_itoa_s(i_objective_count,str_obj_count,10);		
			
			if ((i_objective_count%2) == 0)
				strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td><input type=submit name=",_TRUNCATE);
			else
				strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td><input type=submit name=",_TRUNCATE);

			strncat_s(dest,size,str_obj_count,_TRUNCATE);
			strncat_s(dest,size," value=Delete>     ",_TRUNCATE);

			strncat_s(dest,size,"<input type=submit name=",_TRUNCATE);
			strncat_s(dest,size,str_obj_count,_TRUNCATE);
			strncat_s(dest,size," value=Modify>",_TRUNCATE);
			strncat_s(dest,size,"</td><td>",_TRUNCATE);

					
			if (_stricmp(reg_objective.str_critic,CRITICAL_TOKEN) == 0) {
				strncat_s(dest,size,"<font color=\"red\">Critical</font>",_TRUNCATE);
			} else if(_stricmp(reg_objective.str_critic,PRIORITY_TOKEN) == 0) {
				strncat_s(dest,size,"<font color=\"orange\">Priority</font>",_TRUNCATE);
			} else if (_stricmp(reg_objective.str_critic,WARNING_TOKEN) == 0) {
				strncat_s(dest,size,"<font color=\"blue\">Warning</font>",_TRUNCATE);
			} else if (_stricmp(reg_objective.str_critic,INFORMATION_TOKEN) == 0) {
				strncat_s(dest,size,"<font color=\"green\">Information</font>",_TRUNCATE);
			} else {
				strncat_s(dest,size,"<font color=\"black\">Clear</font>",_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>",_TRUNCATE);


			// Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			// need to be replaced. This is done with the "debracket" routine.
			// Note that the new strings are allowed to be twice as long as the real strings

			debracket(reg_objective.str_user_match,str_user_match_metachar_remove,SIZE_OF_USERMATCH*2);
			debracket(reg_objective.str_eventid_match,str_eventid_match_metachar_remove,SIZE_OF_EVENTIDMATCH*2);
			debracket(reg_objective.str_general_match,str_general_match_metachar_remove,SIZE_OF_GENERALMATCH*2);

			if(reg_objective.dw_event_match_type!=0) {
				strncat_s(dest,size,"Exclude",_TRUNCATE);
			} else {
				strncat_s(dest,size,"Include",_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>      ",_TRUNCATE);
			if (strlen(reg_objective.str_eventid_match) == 0) {
				strncat_s(dest,size,"&nbsp",_TRUNCATE);
			} else {
				strncat_s(dest,size,str_eventid_match_metachar_remove,_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>      ",_TRUNCATE);

			if(reg_objective.dw_user_match_type!=0) {
				strncat_s(dest,size,"Exclude",_TRUNCATE);
			} else {
				strncat_s(dest,size,"Include",_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>      ",_TRUNCATE);
			
			if (strlen(reg_objective.str_user_match) == 0) {
				strncat_s(dest,size,"&nbsp",_TRUNCATE);
			} else {
				strncat_s(dest,size,str_user_match_metachar_remove,_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>",_TRUNCATE);
			
			if (strlen(reg_objective.str_general_match) == 0) {
				strncat_s(dest,size,"&nbsp",_TRUNCATE);
			} else {
				strncat_s(dest,size,str_general_match_metachar_remove,_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>",_TRUNCATE);

			if(reg_objective.dw_event_type & TYPE_SUCCESS) {
				strncat_s(dest,size,"Success<br>",_TRUNCATE);
			}
			if(reg_objective.dw_event_type & TYPE_FAILURE) {
				strncat_s(dest,size,"Failure<br>",_TRUNCATE);
			}
			if(reg_objective.dw_event_type & TYPE_ERROR) {
				strncat_s(dest,size,"Error<br>",_TRUNCATE);
			}
			if(reg_objective.dw_event_type & TYPE_INFO) {
				strncat_s(dest,size,"Information<br>",_TRUNCATE);
			}
			if(reg_objective.dw_event_type & TYPE_WARN) {
				strncat_s(dest,size,"Warning<br>",_TRUNCATE);
			}
			strncat_s(dest,size,"</td><td>",_TRUNCATE);

			
			if(reg_objective.dw_eventlog_type & LOG_SEC) {
				strncat_s(dest,size,"Security<br>",_TRUNCATE);
			}
			if(reg_objective.dw_eventlog_type & LOG_SYS) {
				strncat_s(dest,size,"System<br>",_TRUNCATE);
			}
			if(reg_objective.dw_eventlog_type & LOG_APP) {
				strncat_s(dest,size,"Application<br>",_TRUNCATE);
			}
			if(reg_objective.dw_eventlog_type & LOG_DIR) {
				strncat_s(dest,size,"Active Directory Service<br>",_TRUNCATE);
			}
			if(reg_objective.dw_eventlog_type & LOG_DNS) {
				strncat_s(dest,size,"Domain Name Server<br>",_TRUNCATE);
			}
			if(reg_objective.dw_eventlog_type & LOG_REP) {
				strncat_s(dest,size,"Replication Service<br>",_TRUNCATE);
			}
						
			strncat_s(dest,size,"</td></tr>",_TRUNCATE);

			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}
		strncat_s(dest,size,"</table><br>",_TRUNCATE);
	} else {
		strncat_s(dest,size,"<br>There are no current filtering objectives active.<br><br>",_TRUNCATE);
	}

	strncat_s(dest,size,"Select this button to add a new objective.  ",_TRUNCATE);
	strncat_s(dest,size,"<input type=submit name=0",_TRUNCATE);
	strncat_s(dest,size," value=Add>",_TRUNCATE);



	return(0);
}


int Objective_Display(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective;
	DWORD dw_objective_error = 0, dw_objective_write_error = 0,dw_objective_delete_error = 0;
;
	char str_objerr[10];
	int i_set=0,i_objective_count = 0,i_type = 0;
	char *psource=source, Variable[100], Argument[100];
	char str_temp[20], str_temp_objective[10];
	

	//This function will display an existing, or a blank, objective
	strncpy_s(dest,size,"<form method=get action=changeobjective><h2><center>SNARE Filtering Objective Configuration</h2>",_TRUNCATE);

	//Determine whether the objective will be modified or deleted
	while((psource=GetNextArgument(psource,Variable,_countof(Variable)-1,Argument,_countof(Argument)-1)) != (char *)NULL) 
	{	
		if (strstr(Argument,"Delete") != NULL)
		{
			sscanf_s(Variable,"%20[^?]?%10[^\n]\n",str_temp,_countof(str_temp),str_temp_objective,_countof(str_temp_objective));
			i_type = 0;
			break;
		}
		if (strstr(Argument,"Modify") != NULL)
		{
			sscanf_s(Variable,"%20[^?]?%10[^\n]\n",str_temp,_countof(str_temp),str_temp_objective,_countof(str_temp_objective));
			i_type = 1;
			break;
		}
		if (strstr(Argument,"Add") != NULL)
		{
			strncpy_s(str_temp_objective,_countof(str_temp_objective),"-2",_TRUNCATE);
			i_type = 2;
			break;
		}
	}

	//Extract the objective number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_objective,"0") == 0)
		i_objective_count = -1;
	else
		i_objective_count = atoi(str_temp_objective);

	//If the objective number could not be successfully extracted, return immediately.
	if (i_objective_count == 0)
	{
		strncat_s(dest,size,"<br><b>NOTE: It appears the URL is encoded incorrectly.",_TRUNCATE);
		return 0;
	}

	if (i_objective_count == -1)
		i_objective_count = 0;
		
	//If the objective is being modified or added
	if (i_type > 0) {
		if (i_type == 1) {
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		} else {
			strncpy_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),SUCCESS_TOKEN,_TRUNCATE);
			strncpy_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),SECLOG_TOKEN,_TRUNCATE);
			strncpy_s(reg_objective.str_critic,_countof(reg_objective.str_critic),CRITICAL_TOKEN,_TRUNCATE);
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),LOGONOFF_TOKEN,_TRUNCATE);
			strncpy_s(reg_objective.str_general_match,_countof(reg_objective.str_general_match),"*",_TRUNCATE);
			strncpy_s(reg_objective.str_user_match,_countof(reg_objective.str_user_match),"*",_TRUNCATE);
			strncpy_s(reg_objective.str_user_match_type,_countof(reg_objective.str_user_match_type),INCLUDE,_TRUNCATE);
			strncpy_s(reg_objective.str_event_match_type,_countof(reg_objective.str_event_match_type),INCLUDE,_TRUNCATE);
		}

		// Will display an error if unable to completely read from the registry
		if (dw_objective_error > 0) {
			dw_objective_error += WEB_READ_OBJECTIVE_ERROR_CODE;
			_itoa_s(dw_objective_error,str_objerr,10);
	
			strncat_s(dest,size,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
						"may be used.<br> Report error: ",_TRUNCATE);
			strncat_s(dest,size,str_objerr,_TRUNCATE);
			strncat_s(dest,size,"</b><br>",_TRUNCATE);
		}

		strncat_s(dest,size,"<br>The following parameters of the SNARE objective may be set:<br><br>" \
			"<table  width=100% border=0>",_TRUNCATE);

		//Identify the high level event. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Identify the high level event</td><td><table  width=100% border=0><tr>",_TRUNCATE);
		strncat_s(dest,size,"<td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,LOGONOFF_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,LOGONOFF_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Logon or Logoff  </td><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,MANAGE_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,MANAGE_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Account Administration  </td></tr><tr><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,FILE_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,FILE_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Access a file or directory  </td><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,SECPOL_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,SECPOL_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Change the security policy  </td></tr><tr><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,PROCESS_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,PROCESS_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Start or stop a process  </td><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,REBOOT_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,REBOOT_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Restart, shutdown and system  </td></tr><tr><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,USERRIGHTS_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,USERRIGHTS_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Use of user rights  </td><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,USB_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,USB_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">USB Event  </td></tr>",_TRUNCATE);
		strncat_s(dest,size,"<tr><td><input type=radio name=str_eventid_match value=",_TRUNCATE);
		strncat_s(dest,size,FILTERING_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventid_match,FILTERING_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			reg_objective.str_eventid_match[0]='\0';
			i_set = 1;
		}
		strncat_s(dest,size,">Filtering Platform Events  </td>",_TRUNCATE);
		strncat_s(dest,size,"<td><input type=radio name=str_eventid_match value=Any_Event",_TRUNCATE);

		if (i_set == 0)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Any event(s) </td></tr></table></td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Select the Event ID Match Type</td><td>",_TRUNCATE);
		strncat_s(dest,size,"<input type=radio name=str_event_match_type value=",_TRUNCATE);
		strncat_s(dest,size,INCLUDE,_TRUNCATE);
		if (strstr(reg_objective.str_event_match_type,INCLUDE) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,">Include    <input type=radio name=str_event_match_type value=",_TRUNCATE);
		strncat_s(dest,size,EXCLUDE,_TRUNCATE);
		if (strstr(reg_objective.str_event_match_type,EXCLUDE) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,">Exclude    </td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Event ID Search Term<br><i>Optional, Comma separated: only used by the 'Any Event' setting above</i></td><td><input type=text name=str_eventid_text size=50 value=\"",_TRUNCATE);
		strncat_s(dest,size,reg_objective.str_eventid_match,_TRUNCATE);
		strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>General Search Term<br><i>Wildcards accepted</i></td><td><input type=text name=str_general_match size=50 value=\"",_TRUNCATE);
		strncat_s(dest,size,reg_objective.str_general_match,_TRUNCATE);
		strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Select the User Match Type</td><td>",_TRUNCATE);
		strncat_s(dest,size,"<input type=radio name=str_user_match_type value=",_TRUNCATE);
		strncat_s(dest,size,INCLUDE,_TRUNCATE);
		if (strstr(reg_objective.str_user_match_type,INCLUDE) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,">Include    <input type=radio name=str_user_match_type value=",_TRUNCATE);
		strncat_s(dest,size,EXCLUDE,_TRUNCATE);
		if (strstr(reg_objective.str_user_match_type,EXCLUDE) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,">Exclude    </td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>User Search Term<br><i>User Names, comma separated. Wilcards accepted</i></td><td><input type=text name=str_user_match size=50 value=\"",_TRUNCATE);
		strncat_s(dest,size,reg_objective.str_user_match,_TRUNCATE);
		strncat_s(dest,size,"\"></td></tr>",_TRUNCATE);

		//Identify the event type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Identify the event types to be captured</td><td><table  width=100% border=0><tr>",_TRUNCATE);
		strncat_s(dest,size,"<td><input type=checkbox name=str_event_type_succ value=",_TRUNCATE);
		strncat_s(dest,size,SUCCESS_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_event_type,SUCCESS_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Success Audit  </td><td><input type=checkbox name=str_event_type_fail value=",_TRUNCATE);
		strncat_s(dest,size,FAILURE_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_event_type,FAILURE_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Failure Audit  </td></tr><tr><td><input type=checkbox name=str_event_type_info value=",_TRUNCATE);
		strncat_s(dest,size,INFO_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_event_type,INFO_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Information  </td><td><input type=checkbox name=str_event_type_warn value=",_TRUNCATE);
		strncat_s(dest,size,WARN_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_event_type,WARN_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Warning  </td></tr><tr><td><input type=checkbox name=str_event_type_error value=",_TRUNCATE);
		strncat_s(dest,size,ERROR_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_event_type,ERROR_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Error  </td></tr></table></td></tr>",_TRUNCATE);

	
		//Identify the log type to capture. Note that there is a table within a table in these radio buttons.
		i_set = 0;

		strncat_s(dest,size,"<tr bgcolor=#FFFFCC><td>Identify the event logs <br>(ignored if any objective other <br>than 'Any event(s)' is selected):</td><td><table  width=100% border=0><tr>",_TRUNCATE);
		strncat_s(dest,size,"<td><input type=checkbox name=str_eventlog_type_seclog value=",_TRUNCATE);
		strncat_s(dest,size,SECLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,SECLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Security  </td><td><input type=checkbox name=str_eventlog_type_syslog value=",_TRUNCATE);
		strncat_s(dest,size,SYSLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,SYSLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">System  </td></tr><tr><td><input type=checkbox name=str_eventlog_type_applog value=",_TRUNCATE);
		strncat_s(dest,size,APPLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,APPLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Application  </td><td><input type=checkbox name=str_eventlog_type_dirlog value=",_TRUNCATE);
		strncat_s(dest,size,DIRLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,DIRLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">Directory Service  </td></tr><tr><td><input type=checkbox name=str_eventlog_type_dnslog value=",_TRUNCATE);
		strncat_s(dest,size,DNSLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,DNSLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">DNS Server  </td><td><input type=checkbox name=str_eventlog_type_replog value=",_TRUNCATE);
		strncat_s(dest,size,REPLOG_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_eventlog_type,REPLOG_TOKEN) != NULL)
		{
			strncat_s(dest,size," checked",_TRUNCATE);
			i_set = 1;
		}
		strncat_s(dest,size,">File Replication  </td></tr></table></td></tr>",_TRUNCATE);

		strncat_s(dest,size,"<tr bgcolor=#FFFFBB><td>Select the Alert Level</td><td>",_TRUNCATE);

		//Determine the criticality level
		strncat_s(dest,size,"<input type=radio name=str_critic value=",_TRUNCATE);
		strncat_s(dest,size,CRITICAL_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_critic,CRITICAL_TOKEN) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,"><img src=/critical.gif> Critical    <input type=radio name=str_critic value=",_TRUNCATE);
		strncat_s(dest,size,PRIORITY_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_critic,PRIORITY_TOKEN) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,"><img src=/priority.gif> Priority    <input type=radio name=str_critic value=",_TRUNCATE);
		strncat_s(dest,size,WARNING_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_critic,WARNING_TOKEN) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,"><img src=/warning.gif> Warning    <input type=radio name=str_critic value=",_TRUNCATE);
		strncat_s(dest,size,INFORMATION_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_critic,INFORMATION_TOKEN) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,"><img src=/info.gif> Information    <input type=radio name=str_critic value=",_TRUNCATE);
		strncat_s(dest,size,CLEAR_TOKEN,_TRUNCATE);
		if (strstr(reg_objective.str_critic,CLEAR_TOKEN) != NULL)
			strncat_s(dest,size," checked",_TRUNCATE);
		strncat_s(dest,size,"><img src=/clear.gif> Clear    </td></tr>",_TRUNCATE);


		strncat_s(dest,size,"</table><br>",_TRUNCATE);
		strncat_s(dest,size,"<input type=hidden name=objnumber value=",_TRUNCATE);
		strncat_s(dest,size,str_temp_objective,_TRUNCATE);//Objective number goes here
		strncat_s(dest,size,"><input type=submit value=\"Change Configuration\">    ",_TRUNCATE);
		strncat_s(dest,size,"<input type=reset value=\"Reset Form\"></form>",_TRUNCATE);
	}
	else
	{
		dw_objective_delete_error = Delete_Objective(i_objective_count);
		i_objective_count++;
		dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		while (dw_objective_error == 0)
		{
			dw_objective_write_error = Write_Objective_Registry(i_objective_count-1,&reg_objective);
			dw_objective_delete_error = Delete_Objective(i_objective_count);
			i_objective_count++;
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective);
		}

		if (dw_objective_delete_error == 0) {
			strncat_s(dest,size,"<br>The objective has been deleted.",_TRUNCATE);
		} else {
			strncat_s(dest,size,"<br>The objective was unable to be deleted.",_TRUNCATE);
			//***REPORT AN ERROR
		}
	}
	
	return(0);
}


int Objective_Result(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Objective reg_objective, reg_objective_read;
	// DWORD dw_objective_error = -1;
	DWORD dw_objective_error = 0;

	int i_objective_count = 0,i_objective = 0, i_event_type_set = 0, i_event_type_log_set = 0;
	char str_obj_count[10],str_eventid_radio[50],str_eventid_text[SIZE_OF_EVENTIDMATCH];
	char *psource=source, Variable[100], Argument[300];

	strncpy_s(dest,size,"<form method=get action=setobjective><H2><CENTER>SNARE Filtering Objectives Configuration</H2>",_TRUNCATE);

	strncpy_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),"",_TRUNCATE);
	strncpy_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),"",_TRUNCATE);

	while((psource=GetNextArgument(psource,Variable,_countof(Variable)-1,Argument,_countof(Argument)-1)) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_user_match") != NULL) {
			strncpy_s(reg_objective.str_user_match,_countof(reg_objective.str_user_match),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_general_match") != NULL) {
			strncpy_s(reg_objective.str_general_match,_countof(reg_objective.str_general_match),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_event_type_succ") != NULL) {
			strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),SUCCESS_TOKEN,_TRUNCATE);
			if (i_event_type_set == 1)
				strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),",",_TRUNCATE);
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_fail") != NULL) {
			strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),FAILURE_TOKEN,_TRUNCATE);
			if (i_event_type_set == 1)
				strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),",",_TRUNCATE);
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_info") != NULL) {
			strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),INFO_TOKEN,_TRUNCATE);
			if (i_event_type_set == 1)
				strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),",",_TRUNCATE);
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_warn") != NULL) {
			strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),WARN_TOKEN,_TRUNCATE);
			if (i_event_type_set == 1)
				strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),",",_TRUNCATE);
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_event_type_error") != NULL) {
			strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),ERROR_TOKEN,_TRUNCATE);
			if (i_event_type_set == 1)
				strncat_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),",",_TRUNCATE);
			i_event_type_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_seclog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),SECLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_syslog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),SYSLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_applog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),APPLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_dirlog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),DIRLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_dnslog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),DNSLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventlog_type_replog") != NULL) {
			strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),REPLOG_TOKEN,_TRUNCATE);
			if (i_event_type_log_set == 1)
				strncat_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),",",_TRUNCATE);
			i_event_type_log_set = 1;
		}
		if (strstr(Variable,"str_eventid_match") != NULL) {
			strncpy_s(str_eventid_radio,_countof(str_eventid_radio),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_eventid_text") != NULL) {
			strncpy_s(str_eventid_text,_countof(str_eventid_text),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"objnumber") != NULL) {
			strncpy_s(str_obj_count,_countof(str_obj_count),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_critic") != NULL) {
			strncpy_s(reg_objective.str_critic,_countof(reg_objective.str_critic),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_user_match_type") != NULL) {
			strncpy_s(reg_objective.str_user_match_type,_countof(reg_objective.str_user_match_type),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_event_match_type") != NULL) {
			strncpy_s(reg_objective.str_event_match_type,_countof(reg_objective.str_event_match_type),Argument,_TRUNCATE);
		}
	}

	if (strstr(str_eventid_radio,"Any_Event") != NULL) {
		strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),str_eventid_text,_TRUNCATE);
	} else {
		if (strstr(str_eventid_radio,FILE_TOKEN) != NULL) {
			// Turn on file auditing for the specified general match term.

			if(validate_file_or_directory(reg_objective.str_general_match)) {
				// Set auditing on the file.
				DWORD dw_FileAudit;
				dw_FileAudit=MyGetProfileDWORD("Config","FileAudit",1);
				if(dw_FileAudit) {
					// Enable the SE_SECURITY_NAME privilege.
					if (EnableSecurityName()) {
						AddEveryoneAceToFileSacl(reg_objective.str_general_match,GENERIC_ALL | ACCESS_SYSTEM_SECURITY);
					}
					// "I have recursively set audit on the filepath specified in this objective."
					strncat_s(dest,size,"<br>I have recursively set audit on the filepath specified in this objective.",_TRUNCATE);
				}
			} else {
				// Tell the user something stuffed up.
				dw_objective_error=1;
				strncat_s(dest,size,"<br>The value supplied in the General Search filter, is not a valid file or directory.<P>Please supply a valid entry (eg: C:\\DIR\\TO\\AUDIT).",_TRUNCATE);
			}

		}
		if (strstr(str_eventid_radio,USB_TOKEN) != NULL) {
			// make sure that SYSTEM and INFORMATION are ticked
			strncpy_s(reg_objective.str_eventlog_type,_countof(reg_objective.str_eventlog_type),SYSLOG_TOKEN,_TRUNCATE);
			strncpy_s(reg_objective.str_event_type,_countof(reg_objective.str_event_type),INFO_TOKEN,_TRUNCATE);
		}
		/*if (strstr(str_eventid_radio,"Logon_Logoff") != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),LOGON_LOGOFF_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,FILE_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),FILE_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,PROCESS_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),PROCESS_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,USERRIGHTS_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),USER_OF_USER_RIGHTS_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,MANAGE_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),USER_GROUP_ADMIN_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,SECPOL_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),SECURITY_POLICY_EVENTS,_TRUNCATE);
		if (strstr(str_eventid_radio,REBOOT_TOKEN) != NULL)
			strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),RESTART_EVENTS,_TRUNCATE);
		else*/

		strncpy_s(reg_objective.str_eventid_match,_countof(reg_objective.str_eventid_match),str_eventid_radio,_TRUNCATE);
	}

	if(!dw_objective_error) {
		i_objective = atoi(str_obj_count);
		
		//-2 = "Add a new objective", hence we must go to the end of the list.
		if (i_objective == -2)
		{
			dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			while (dw_objective_error == 0)
			{
				i_objective_count++;
				dw_objective_error = Read_Objective_Registry(i_objective_count,&reg_objective_read);
			}
			i_objective = i_objective_count;
		}

		dw_objective_error = Write_Objective_Registry(i_objective,&reg_objective);
		if (dw_objective_error  == 0)
			strncat_s(dest,size,"<br>The objective has been modifed/added.",_TRUNCATE);
		else
			strncat_s(dest,size,"<br>The objective was unable to be modifed/added.",_TRUNCATE);
			//***REPORT AN ERROR
	}

	return(0);
}


int DefaultHeader(char *source, char *dest, int size, int refreshflag)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"<HTML><head>" \
	"<title>InterSect Alliance - Information Technology Security</title>" \
	"<meta name=\"TITLE\" content=\"InterSect Alliance - Information Technology Security\">" \
	"<style type=\"text/css\">\n" \
	"body {\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" font-size: 10px; font-weight: normal;\n" \
	" margin: 0px;\n" \
	"}\n" \
	"h1 {\n" \
	" font-size: 30px;\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" color: white;\n" \
	"}\n" \
	"h2 {\n" \
	" font-size: 30px;\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" color: black;\n" \
	"}\n" \
	"font {\n" \
	" font-family: Verdana,Helvetica,sans-serif;\n" \
	" text-decoration: none; font-size: 10px;\n" \
	" font-weight: normal;\n" \
	"}\n" \
	"table {\n" \
	" margin: 0px; padding: 0px;\n" \
	"}\n" \
	"td {\n" \
	" font-size: 75%;\n" \
	"}\n" \
	"</style>\n" \
	"<meta HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">" \
	"<meta HTTP-EQUIV=\"Expires\" CONTENT=\"-1\">",_TRUNCATE);
	if (refreshflag) strncat_s(dest,size,"<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"30\">",_TRUNCATE);
	strncat_s(dest,size,"</head>" \
	"<body text=black bgcolor=white link=#000066 vlink=#000044 alink=#000055>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=3 width=100%>" \
	"<tbody>" \
    "<tr>" \
    "<td height=70><img src=/intersect.gif alt=\"InterSect\" width=205 height=70 hspace=20 vspace=0 border=0 align=Right>" \
    "</td>" \
    "<td height=70 width=1% bgcolor=#eeeeee><br></td>" \
	"<td height=70 width=1% bgcolor=#dddddd><br></td>" \
	"<td height=70 width=1% bgcolor=#cccccc><br></td>" \
	"<td height=70 width=1% bgcolor=#ccbbbb><br></td>" \
	"<td height=70 width=1% bgcolor=#ccaaaa><br></td>" \
	"<td height=70 width=1% bgcolor=#cc9999><br></td>" \
	"<td height=70 width=1% bgcolor=#cc8888><br></td>" \
	"<td height=70 width=1% bgcolor=#cc7777><br></td>" \
	"<td height=70 width=1% bgcolor=#cc6666><br></td>" \
	"<td height=70 width=1% bgcolor=#cc5555><br></td>" \
	"<td height=70 width=1% bgcolor=#cc4444><br></td>" \
	"<td height=70 width=1% bgcolor=#cc3333><br></td>" \
	"<td height=70 width=1% bgcolor=#cc2222><br></td>" \
	"<td height=70 width=1% bgcolor=#cc1111><br></td>" \
	"<td height=70 width=86% bgcolor=#cc0000><div align=right><center><h1>SNARE for Windows&nbsp;</h1></center></div></td>" \
    "</tr>" \
    "</tbody>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=1 width=100%>" \
    "<tr><td height=3 border=0 bgcolor=white width=100%></td></tr>" \
    "<tr><td height=3 border=0 bgcolor=black width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=#AAAAAA width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=white width=100%></td></tr>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=5 columns=2 width=100% height=100%>" \
	"<tbody>" \
    "<tr>" \
      "<td valign=Top width=20% bgcolor=#cc0000>" \
      "<div align=Center><font color=#ffffff>" \
      "<br>" \
      "<font face=\"Helvetica,Arial,sans-serif\" size=-1><B>" \
      "<br><A HREF=\"/eventlog\" style=\"color:FFFFFF;text-decoration:none\">Latest Events</A><br>" \
      "<br><A HREF=\"/network\" style=\"color:FFFFFF;text-decoration:none\">Network Configuration</A><br>" \
      "<br><A HREF=\"/remote\" style=\"color:FFFFFF;text-decoration:none\">Remote Control Configuration</A><br>" \
      "<br><A HREF=\"/objective\" style=\"color:FFFFFF;text-decoration:none\">Objectives Configuration</A><br>" \
      "<br><A HREF=\"/status\" style=\"color:FFFFFF;text-decoration:none\">View Audit Service Status</A><br>" \
	  "<br><A HREF=\"/restart\" style=\"color:FFFFFF;text-decoration:none\">Apply the Latest Audit Configuration</A><br>" \
	  "</div>" \
	  "<br><font size=-2><A HREF=\"/LocalUsers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Local Users</A></font>" \
	  "<br><font size=-2><A HREF=\"/DomainUsers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Domain Users</A></font>" \
	  "<br><font size=-2><A HREF=\"/LocalGroupMembers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Local Group Members</A></font>" \
	  "<br><font size=-2><A HREF=\"/DomainGroupMembers\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Domain Group Members</A></font>" \
	  "<br><font size=-2><A HREF=\"/RegDump\" style=\"color:FFFFFF;text-decoration:none\" target=\"SnareData\">Registry Dump</A></font><br>" \
      "</b></font>" \
      "<br>" \
      
    "</td>" \
    "<td width=100% valign=Top>" \
     "<table cellpadding=0 cellspacing=10 border=0 width=100%>" \
      "<tbody>" \
       "<tr>" \
        "<td valign=Top align=Justify>",_TRUNCATE);

	return(0);
}

int DefaultFooter(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"</td>" \
		"</tr>" \
		"</tbody>" \
		"</table>" \
		"</body><center>" \
		"<BR><BR><FONT SIZE=-1 face=helvetica>(c) <A HREF=\"http://www.intersectalliance.com\">Intersect Alliance</A> Pty Ltd 1999-2007. " \
		"This site is powered by <A HREF=\"http://www.intersectalliance.com/projects/\">SNARE for Windows.</A></FONT>" \
		"</center></html>",_TRUNCATE);

	return(0);
}

int Restart(char *source, char *dest, int size, HANDLE event)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy_s(dest,size,"<HTML><BODY><H2><CENTER>Reapply the Latest Configuration</H2><P>Snare Objectives have been reapplied to the running system.</CENTER></BODY></HTML>",_TRUNCATE);

	// Notify the main thread that we want to reapply config changes
		SetEvent(event);

    return(0);
}



int ShowLocalUsers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";

	USER_INFO_2	*UserInfo;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwResume=0,dwReturn=0, i=0;
	char szName[255],szDesc[255],szFName[255];

	char szTextualSid[256];
	DWORD dwBufferLen;
	WCHAR UserName[256];
	NET_API_STATUS nasReturn;
	USER_MODALS_INFO_0 *pModBuf = NULL;
	PNET_DISPLAY_USER pBuf,p;
	long MaxPwdAge;

	if (NetUserModalsGet(NULL, 0, (LPBYTE *)&pModBuf) == NERR_Success) {
		if (SNAREDEBUG >= 6) DebugMsg("Maximum password age (d): %d\n", pModBuf->usrmod0_max_passwd_age/86400);
		MaxPwdAge=pModBuf->usrmod0_max_passwd_age;
	} else {
		if (SNAREDEBUG >= 6) DebugMsg("Could not find MaxPasswordAge");
		MaxPwdAge=-1;
	}
	if (pModBuf) NetApiBufferFree(pModBuf);

	do {
		dwReturn = NetQueryDisplayInformation( NULL, 1, i, 1000, MAX_PREFERRED_LENGTH, &dwEntriesRead, (PVOID *) &pBuf);
		p=pBuf;
		while ( dwEntriesRead ) {
			
			// Is this a local user account?
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,p->usri1_name,-1, szName, 254, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0,p->usri1_comment,-1, szDesc, 254, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0,p->usri1_full_name,-1, szFName, 254, NULL, NULL );
			

			if(szName) {
				// GET SID HERE

				dwBufferLen=_countof(szTextualSid);

				// Obtain the textual representation of the SID.
				GetUserSid(szName,szTextualSid,&dwBufferLen);
			}

			// Get rid of tabs in the Description field
			char * t;
			t=szDesc;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}
			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%s (%s)\t%s",szName,szFName,szDesc,szTextualSid);

			mbstowcs_s(NULL,UserName,_countof(UserName),szName,_TRUNCATE);
			nasReturn=NetUserGetInfo(NULL,UserName,2,(LPBYTE *)&UserInfo);
			if (nasReturn == NERR_Success && UserInfo) {
				if(UserInfo->usri2_flags & UF_ACCOUNTDISABLE) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tACCOUNTDISABLE",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_PASSWD_NOTREQD) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tPASSWD_NOTREQD",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_PASSWD_CANT_CHANGE) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tPASSWD_CANT_CHANGE",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_LOCKOUT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tLOCKOUT",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_DONT_EXPIRE_PASSWD) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tDONT_EXPIRE_PASSWD",HTTPBuffer);
				}
				//password age in seconds since last reset:max password age in seconds (const):time when the account will expire in seconds since epoch
				snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%d:%d:%d:%d\n",HTTPBuffer,UserInfo->usri2_password_age,MaxPwdAge,UserInfo->usri2_acct_expires, UserInfo->usri2_last_logon);
			} else {
				snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t-1:%d:-1:-1\n",HTTPBuffer,MaxPwdAge);
			}
			if(UserInfo) NetApiBufferFree(UserInfo);
			
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
			
			i = p->usri1_next_index;
			p++;  // Step to the next one

			dwEntriesRead--;

		}
		if(pBuf) NetApiBufferFree(pBuf);
	} while(dwReturn == ERROR_MORE_DATA);

	//if(pBuf) NetApiBufferFree(pBuf);

	// Send a newline to finish off.
	retval = send(http_socket,"\n",(int)strlen("\n"),0);
	return(0);
}

int ShowDomainUsers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	LPWSTR tPrimaryDC = NULL;
	WCHAR PrimaryDC[256];
	WCHAR *PDC;
	WCHAR UserName[256];
	NET_API_STATUS netErr=1;

	// Get the primary domain controller
	netErr = NetGetDCName(NULL,NULL,(LPBYTE *)&tPrimaryDC);
	if(netErr == NERR_Success) {
		char temp[256]="", temp2[256]="";
		if(tPrimaryDC) {
			wcsncpy_s(PrimaryDC,_countof(PrimaryDC),tPrimaryDC,_TRUNCATE);
			PDC=PrimaryDC;

			WideCharToMultiByte( CP_ACP, 0,PDC,-1, temp, 255, NULL, NULL );
			_snprintf_s(temp2,256,_TRUNCATE,"PDC: %s\n",temp);
			retval = send(http_socket,temp2,(int)strlen(temp2),0);
		} else {
			if(tPrimaryDC) {
				NetApiBufferFree(tPrimaryDC);
			}
			//char temp[256];
			//PDC=NULL;
			//strncpy_s(temp,_countof(temp),"PDC: LOCAL\n",_TRUNCATE);
			//retval = send(http_socket,temp,(int)strlen(temp),0);	
			return(0);
		}
	} else {
		if(tPrimaryDC) {
				NetApiBufferFree(tPrimaryDC);
		}
		return(0);
		//char temp[256];
		//
		//PDC=NULL;
		//
		//strncpy_s(temp,_countof(temp),"PDC: LOCAL\n",_TRUNCATE);
		//retval = send(http_socket,temp,(int)strlen(temp),0);	
	}

	if(tPrimaryDC) {
	  NetApiBufferFree(tPrimaryDC);
	}


	NET_API_STATUS nasReturn;
	NET_API_STATUS nasReturn2;
	PNET_DISPLAY_USER pNDUBuff, p;
	USER_INFO_2	*UserInfo;
	DWORD  dwUsers;
	char szNameBuffer[256];
	char szCommentBuffer[256];
	char szFNameBuffer[256];

	char szTextualSid[256];
	DWORD dwBufferLen;

	DWORD i=0;
	DWORD next=0;
	long MaxPwdAge;

	USER_MODALS_INFO_0 *pBuf = NULL;

	if (NetUserModalsGet(PDC, 0, (LPBYTE *)&pBuf) == NERR_Success) {
		if (SNAREDEBUG >= 6) DebugMsg("Maximum password age (d): %d\n", pBuf->usrmod0_max_passwd_age/86400);
		MaxPwdAge=pBuf->usrmod0_max_passwd_age;
	} else {
		if (SNAREDEBUG >= 6) DebugMsg("Could not find MaxPasswordAge");
		MaxPwdAge=-1;
	}
	if (pBuf != NULL) NetApiBufferFree(pBuf);

	do {
		// 1 = Users, 2 = Machines, 3 = groups
		nasReturn = NetQueryDisplayInformation(PDC,1,next,1000,MAX_PREFERRED_LENGTH,&dwUsers,(PVOID *)&pNDUBuff);
		
		if(nasReturn == ERROR_ACCESS_DENIED) {
			char temp[256]="Access Denied. Cannot query domain users while SNARE is running with the privileges of the local administrator";
            retval = send(http_socket,temp,(int)strlen(temp),0);
			if (pNDUBuff) NetApiBufferFree(pNDUBuff);
			break;
        }
		p = pNDUBuff;
		for (i=0; i<dwUsers; i++)
		{
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           p->usri1_name,
                           -1,
                           szNameBuffer,
                           _countof(szNameBuffer),
                           NULL,
                           NULL);
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           p->usri1_comment,
                           -1,
                           szCommentBuffer,
                           _countof(szCommentBuffer),
                           NULL,
                           NULL);

			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           p->usri1_full_name,
                           -1,
                           szFNameBuffer,
                           _countof(szFNameBuffer),
                           NULL,
                           NULL);

			if(szNameBuffer) {
				// GET SID HERE

				dwBufferLen=_countof(szTextualSid);

				// Obtain the textual representation of the SID.
				GetUserSid(szNameBuffer,szTextualSid,&dwBufferLen);
			}


			// Get rid of tabs in the Description field
			char * t;
			t=szCommentBuffer;
			if(t) {
				while(*t) {
					if(*t == '\t') { *t=' '; }
					t++;
				}
			}

			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%s (%s)\t%s",szNameBuffer,szFNameBuffer,szCommentBuffer,szTextualSid);
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);

			strncpy_s(HTTPBuffer,1,"",_TRUNCATE);
			// Unfortunately, the NetQueryDisplayInformation system call does not tell us the flags!
			// Argh.. ok, get more details on this user.
			// This probably means that user info will slow down lots..
			// Use NetUserGetInfo here.

			mbstowcs_s(NULL,UserName,_countof(UserName),szNameBuffer,_TRUNCATE);

			nasReturn2=NetUserGetInfo(PDC,UserName,2,(LPBYTE *)&UserInfo);
			if (nasReturn2 == NERR_Success && UserInfo) {

				if(UserInfo->usri2_flags & UF_ACCOUNTDISABLE) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tACCOUNTDISABLE",HTTPBuffer);
				}
				// This flag doesn't seem to be used by Windows 200 and above, any more
				if(UserInfo->usri2_flags & UF_PASSWD_NOTREQD) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tPASSWD_NOTREQD",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_PASSWD_CANT_CHANGE) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tPASSWD_CANT_CHANGE",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_LOCKOUT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tLOCKOUT",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_DONT_EXPIRE_PASSWD) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tDONT_EXPIRE_PASSWD",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_INTERDOMAIN_TRUST_ACCOUNT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tINTERDOMAIN_TRUST_ACCOUNT",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_SERVER_TRUST_ACCOUNT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tSERVER_TRUST_ACCOUNT",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_WORKSTATION_TRUST_ACCOUNT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tWORKSTATION_TRUST_ACCOUNT",HTTPBuffer);
				}
				if(UserInfo->usri2_flags & UF_TEMP_DUPLICATE_ACCOUNT) {
					snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\tTEMP_DUPLICATE_ACCOUNT",HTTPBuffer);
				}
				//password age in seconds since last reset:max password age in seconds (const):time when the account will expire in seconds since epoch
				snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%d:%d:%d:%d\n",HTTPBuffer,UserInfo->usri2_password_age,MaxPwdAge,UserInfo->usri2_acct_expires, UserInfo->usri2_last_logon);
			} else {
				snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t-1:%d:-1:-1\n",HTTPBuffer,MaxPwdAge);
			}
		
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);

			if(UserInfo) NetApiBufferFree(UserInfo);

			next = p->usri1_next_index;
			p++;

		}
		if (pNDUBuff) NetApiBufferFree(pNDUBuff);

	} while(nasReturn == ERROR_MORE_DATA);

	return(1);
}


int ShowLocalGroupMembers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[4096]="";

	GROUP_INFO_1	*GroupInfo,*GISave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwReturn=0;
	char szName[255];
	char szComment[255];

	if (SNAREDEBUG >= 5) DebugMsg("ShowLocalGroupMembers");
	do {
		dwReturn = NetLocalGroupEnum( NULL, 1, (LPBYTE *)&GroupInfo, MAX_PREFERRED_LENGTH, 
                &dwEntriesRead,	&dwTotalEntries, NULL );
		GISave=GroupInfo;
		switch (dwReturn) {
			case ERROR_MORE_DATA: DebugMsg("ERROR_MORE_DATA"); break;
			case ERROR_ACCESS_DENIED: DebugMsg("ERROR_ACCESS_DENIED"); break;
			case NERR_Success: DebugMsg("NERR_Success"); break;
			case NERR_InvalidComputer: DebugMsg("NERR_InvalidComputer"); break;
			case NERR_BufTooSmall: DebugMsg("NERR_BufTooSmall"); break;
		}
		if (SNAREDEBUG >= 5) DebugMsg("NetLocalGroupEnum: dwEntriesRead (%d) dwTotalEntries (%d) ", dwEntriesRead, dwTotalEntries);
		if (SNAREDEBUG >= 5) DebugMsg("grabbed list of groups, now checking members");

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_name,-1, szName, 254, NULL, NULL );
			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t",szName);
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
			
			WideCharToMultiByte( CP_ACP, 0,GroupInfo->grpi1_comment,-1, szComment, 254, NULL, NULL );
			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t",szComment);
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);

			//This function will grab the group members
			ShowThisLocalGroupMembers(GroupInfo->grpi1_name,http_socket);
			retval = send(http_socket,"\n",(int)strlen("\n"),0);
			
			GroupInfo += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(GISave) NetApiBufferFree(GISave);
	} while(dwReturn == ERROR_MORE_DATA);
	if (SNAREDEBUG >= 5) DebugMsg("finished ShowDomainGroupMembers");

	// Send a newline to finish off.
	retval = send(http_socket,"\n",(int)strlen("\n"),0);

	return(0);
}


int ShowDomainGroupMembers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";

	LPWSTR tPrimaryDC = NULL;
	WCHAR PrimaryDC[256];
	WCHAR *PDC;
	NET_API_STATUS netErr=1;

	if (SNAREDEBUG >= 5) DebugMsg("ShowDomainGroupMembers");
	// Get the primary domain controller
	netErr = NetGetDCName(NULL,NULL,(LPBYTE *)&tPrimaryDC);
	if(netErr == NERR_Success) {
		char temp[256]="", temp2[256]="";
		if(tPrimaryDC) {
			wcsncpy_s(PrimaryDC,255,tPrimaryDC,_TRUNCATE);
			PDC=PrimaryDC;

			WideCharToMultiByte( CP_ACP, 0,PDC,-1, temp, _countof(temp), NULL, NULL );
			_snprintf_s(temp2,_countof(temp2),_TRUNCATE,"PDC: %s\n",temp);
			retval = send(http_socket,temp2,(int)strlen(temp2),0);
		} else {
			return(0);
		}
	} else {
		if(tPrimaryDC) {
				NetApiBufferFree(tPrimaryDC);
		}
		return(0);
	}

	if(tPrimaryDC) {
	  NetApiBufferFree(tPrimaryDC);
	}


	NET_API_STATUS nasReturn;
	PNET_DISPLAY_GROUP pNDUBuff, p;
	DWORD  dwGroups;
	char szNameBuffer[256]="";
	char szCommentBuffer[256]="";

	DWORD i=0;
	DWORD next=0;

	if (SNAREDEBUG >= 5) DebugMsg("Checking version");
	if (SNAREDEBUG >= 5) DebugMsg("Version is 5+");
	// Initialise COM object for grabbing AD groups if available.
	CoInitialize(NULL);

	if (SNAREDEBUG >= 5) DebugMsg("Checking for mixed mode");
	if(ADIsMixedMode()) {
		if (SNAREDEBUG >= 5) DebugMsg("domain is mixed mode");
		HRESULT hr = S_OK;
		// Pull back rootDSE and the current user's domain container DN.
		IADs *pObject = NULL;
		IDirectorySearch *pContainerToSearch = NULL;
		LPOLESTR szPath = new OLECHAR[MAX_PATH];
		VARIANT var;
		int iCount = 0;

		hr = ADsOpenObject(L"LDAP://rootDSE",
			NULL,
			NULL,
			ADS_SECURE_AUTHENTICATION, // Use Secure Authentication
			IID_IADs,
			(void**)&pObject);
		
		if (FAILED(hr))	{
			if (pObject) {
				pObject->Release();
			}
			delete [] szPath;
			CoUninitialize();
			return(0);
		}
		
		hr = pObject->Get(L"defaultNamingContext",&var);
		if (SUCCEEDED(hr)) {
			wcscpy_s(szPath,MAX_PATH,L"LDAP://");
			if(wcslen(var.bstrVal) < MAX_PATH) {
				wcscat_s(szPath,MAX_PATH,var.bstrVal);
			} else {
				// Buffer is too small for the domain DN
				if (pObject) { pObject->Release(); }
				delete [] szPath;
				VariantClear(&var);
				CoUninitialize();
				return(0);
			}

			hr = ADsOpenObject(szPath, NULL, NULL,
				ADS_SECURE_AUTHENTICATION, //Use Secure Authentication
				IID_IDirectorySearch, (void**)&pContainerToSearch);
			
			if (SUCCEEDED(hr)) {		
				// Specify subtree search
				ADS_SEARCHPREF_INFO SearchPrefs[2];
				SearchPrefs[0].dwSearchPref = ADS_SEARCHPREF_SEARCH_SCOPE;
				SearchPrefs[0].vValue.dwType = ADSTYPE_INTEGER;
				SearchPrefs[0].vValue.Integer = ADS_SCOPE_SUBTREE;
				
				SearchPrefs[1].dwSearchPref = ADS_SEARCHPREF_PAGESIZE;
				SearchPrefs[1].vValue.dwType = ADSTYPE_INTEGER;
				SearchPrefs[1].vValue.Integer = 1000;

				DWORD dwNumPrefs = 2;
				
				// COL for iterations
				LPOLESTR pszColumn = NULL;    
				ADS_SEARCH_COLUMN col;
				
				// Interface Pointers
				IADs *pObj = NULL;
				IADs * pIADs = NULL;
				
				// Handle used for searching
				ADS_SEARCH_HANDLE hSearch = NULL;
				
				// Set the search preference
				hr = pContainerToSearch->SetSearchPreference(SearchPrefs, dwNumPrefs);
				if (FAILED(hr)) {
					if (pObject) {
						pObject->Release();
					}
					delete [] szPath;
					if (pContainerToSearch) {
						pContainerToSearch->Release();
					}
					VariantClear(&var);
					CoUninitialize();
					return(0);
				}
				
				LPOLESTR pszScanList[] = {L"name",L"description"};
				
				char cszName[MAX_PATH]="";
				char cszDesc[MAX_PATH]="";
				
				hr = pContainerToSearch->ExecuteSearch(L"(&(objectCategory=group))",
					pszScanList,
					sizeof(pszScanList)/sizeof(LPOLESTR),
					&hSearch);
				
				if (SUCCEEDED(hr)) {
					// Call IDirectorySearch::GetNextRow() to retrieve more data
					hr = pContainerToSearch->GetFirstRow(hSearch);
					if (SUCCEEDED(hr)) {
						while(hr == S_OK) {
							iCount++;
							
							strncpy_s(cszName,_countof(cszName),"",_TRUNCATE);
							strncpy_s(cszName,_countof(cszDesc),"",_TRUNCATE);

							// loop through the array of passed column names,						
							while( pContainerToSearch->GetNextColumnName(hSearch, &pszColumn ) == S_OK ) {
								hr = pContainerToSearch->GetColumn(hSearch, pszColumn, &col);
								if(SUCCEEDED(hr)) {
									// Print the data for the column and free the column
									if (0==wcscmp(L"name", pszColumn)) {
										if(wcslen(col.pADsValues->CaseIgnoreString) < MAX_PATH) {
											if(!WideCharToMultiByte(CP_ACP,0,col.pADsValues->CaseIgnoreString,-1,cszName,_countof(cszName),NULL,FALSE)) {
												strncpy_s(cszName,1,"",_TRUNCATE);
											}
										}
									}
									
									if (0==wcscmp(L"description", pszColumn)) {
										if(wcslen(col.pADsValues->CaseIgnoreString) < MAX_PATH) {
											if(!WideCharToMultiByte(CP_ACP,0,col.pADsValues->CaseIgnoreString,-1,cszDesc,_countof(cszDesc),NULL,FALSE)) {
												strncpy_s(cszDesc,1,"",_TRUNCATE);
											}
										}
									}
									
									pContainerToSearch->FreeColumn(&col);
								}
								FreeADsMem(pszColumn);
							}
							//snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%s\t",cszName,cszDesc);
							snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t%s",cszName,cszDesc);
							retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
							
							//WCHAR szName[MAX_PATH];
							//mbstowcs_s(szName,_countof(szName),cszName,_TRUNCATE);
							
							// ShowThisDomainGroupMembers(szName,PDC,http_socket);
							retval = send(http_socket,"\n",(int)strlen("\n"),0);
							
							// Get the next row
							hr = pContainerToSearch->GetNextRow(hSearch);
						}
					}
					// Close the search handle to clean up
					if(hSearch) {
						pContainerToSearch->CloseSearchHandle(hSearch);
					}
				} 
				if (SUCCEEDED(hr) && 0==iCount) {
					hr = S_FALSE;
				}
				
				if (SUCCEEDED(hr)) {
					if (S_FALSE==hr) {
						if(SNAREDEBUG >= 6) DebugMsg("No user object could be found");
					}
				} else if (0x8007203e==hr) {
					if(SNAREDEBUG >= 6) DebugMsg("Could not execute query. An invalid filter was specified.");
				} else {
					if(SNAREDEBUG >= 6) DebugMsg("Query failed to run. HRESULT: %x",hr);
				}
			} else {
				if(SNAREDEBUG >= 6) DebugMsg("Could not execute query. Could not bind to the container.");
			}
		
			if (pContainerToSearch) {
				pContainerToSearch->Release();
			}
			
			VariantClear(&var);
		}
	
	
		if(pObject) {
			pObject->Release();
		}
		if(szPath) {
			delete [] szPath;
		}


		retval = send(http_socket,"\n",(int)strlen("\n"),0);
		retval = send(http_socket,"-\n",2,0);
		retval = send(http_socket,"\n",(int)strlen("\n"),0);

		ShowDomainUserGroupsWin2k(http_socket);

		// We're done, so uninitialise the COM interface
		CoUninitialize();

		return(1);
	} else {
		// We're done, so uninitialise the COM interface
		if (SNAREDEBUG >= 5) DebugMsg("domain is NOT mixed mode");

		CoUninitialize();
		// And fall through to normal mode.
	}

	// If we are not in native mode, fall through to normal mode.

	do {
		if (SNAREDEBUG >= 5) DebugMsg("Starting native check");
		// 1 = Users, 2 = Machines, 3 = groups
		nasReturn = NetQueryDisplayInformation(PDC,3,next,1000,MAX_PREFERRED_LENGTH,&dwGroups,(PVOID*)&pNDUBuff);
		
		if(nasReturn == ERROR_ACCESS_DENIED) {
			char temp[256]="Access Denied. Cannot query domain groups while SNARE is running with the privileges of the local administrator";
            retval = send(http_socket,temp,(int)strlen(temp),0);
			if(pNDUBuff) NetApiBufferFree (pNDUBuff);
			break;
        }
		p = pNDUBuff;
		for (i=0; i<dwGroups; i++)
		{
			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           p->grpi3_name,
                           -1,
                           szNameBuffer,
                           _countof(szNameBuffer),
                           NULL,
                           NULL);
		
			
			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t",szNameBuffer);
		
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);

			WideCharToMultiByte (CP_ACP,
                           WC_COMPOSITECHECK,
                           p->grpi3_comment,
                           -1,
                           szCommentBuffer,
                           _countof(szCommentBuffer),
                           NULL,
                           NULL);
		
			
			snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s\t",szCommentBuffer);
		
			retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);

			ShowThisDomainGroupMembersNT(p->grpi3_name,PDC,http_socket);
			retval = send(http_socket,"\n",(int)strlen("\n"),0);
			next = p->grpi3_next_index;
			p++;
		}

		if(pNDUBuff) NetApiBufferFree (pNDUBuff);
	} while(nasReturn == ERROR_MORE_DATA);
	return(1);
}


int ShowThisLocalGroupMembers(WCHAR *Group,SOCKET http_socket)
{
	LOCALGROUP_MEMBERS_INFO_3 *Members,*MSave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwReturn=0;
	char szName[255]="";
	char Buffer[256]="";
	int first=1;
	int retval;

	if (SNAREDEBUG >= 5) DebugMsg("ShowThisLocalGroupMembers");
	do {
		dwReturn = NetLocalGroupGetMembers(NULL, Group, 3,
         (PBYTE*) &Members, MAX_PREFERRED_LENGTH,
         &dwEntriesRead,	&dwTotalEntries, NULL );
		MSave=Members;
		if (SNAREDEBUG >= 5) DebugMsg("grabbed list of users, sending data");
		switch (dwReturn) {
			case ERROR_MORE_DATA: DebugMsg("ERROR_MORE_DATA"); break;
			case ERROR_ACCESS_DENIED: DebugMsg("ERROR_ACCESS_DENIED"); break;
			case NERR_Success: DebugMsg("NERR_Success"); break;
			case NERR_InvalidComputer: DebugMsg("NERR_InvalidComputer"); break;
			case ERROR_NO_SUCH_ALIAS: DebugMsg("ERROR_NO_SUCH_ALIAS"); break;
		}

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,Members->lgrmi3_domainandname,-1, szName, 254, NULL, NULL );

			if(!first) {
				snprintf_s(Buffer,256,_TRUNCATE,",%s",szName);
			} else {
				first=0;
				snprintf_s(Buffer,256,_TRUNCATE,"%s",szName);
			}

			retval = send(http_socket,Buffer,(int)strlen(Buffer),0);			

			Members += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(MSave) NetApiBufferFree(MSave);
	} while(dwReturn == ERROR_MORE_DATA);

	if (SNAREDEBUG >= 5) DebugMsg("finished ShowThisLocalGroupMembers");

	return(0);
}


HRESULT VarToBytes(VARIANT *Variant,LPBYTE *bytes,long *plcb)
{
    HRESULT hr = E_FAIL;
    SAFEARRAY *pArrayVal = NULL;
    CHAR HUGEP *pArray = NULL;

	if(!plcb || !Variant || !Variant->pparray) {
		return(hr);
	}
	int temp = sizeof(Variant);
    // Retrieve the safe array....
    pArrayVal = Variant->parray;
	if (SNAREDEBUG >= 6) DebugMsg("Variant.vt: %d",Variant->vt);
	//if (Variant->vt != 8209) {
	//	if (SNAREDEBUG >= 6) DebugMsg("Unknown Variant type %d.  Time to bail out...",Variant->vt);
	//	return(E_FAIL);
	//}
	
    if (pArrayVal != NULL) {
		ULONG cSize;

		if(!Variant->parray->rgsabound || !pArrayVal->rgsabound) {
			if(SNAREDEBUG >= 6) { DebugMsg("WARNING: Variant array is corrupted. I'm not touching it."); }
			return(E_FAIL);
		}
		try {
			if(SNAREDEBUG >= 6) { DebugMsg("rgsabound is OK: cElements: %il, lLbound: %il", Variant->parray->rgsabound->cElements, Variant->parray->rgsabound->lLbound); }
		} catch(...) {
			if(SNAREDEBUG >= 6) { DebugMsg("CRASH: cSize grab failed. Some null-pointer weirdness going on here."); }
			return(E_FAIL);
		}
		//SAFEARRAYBOUND
		//try {
		//	if(Variant.parray->rgsabound[0] == (SAFEARRAYBOUND)NULL) {
		//		if(SNAREDEBUG >= 6) { DebugMsg("WARNING: Variant array is corrupted. I'm not touching it."); }
		//		return(E_FAIL);
		//	}
		//} catch(...) {
		//	if(SNAREDEBUG >= 6) { DebugMsg("CRASH: rgsabound[0] grab failed. No idea what is going on here."); }
		//	return(E_FAIL);
		//}
		//if(SNAREDEBUG >= 6) { DebugMsg("rgsabound[0] is OK"); }

		// try / catch
		try {
			if (!Variant->parray->rgsabound->cElements && SNAREDEBUG >= 6) { DebugMsg("cSize is going to fail"); } 
			cSize = Variant->parray->rgsabound->cElements;
			if(SNAREDEBUG >= 6) { DebugMsg("csize(ptr) is OK: %d", cSize); }
			if (!pArrayVal->rgsabound[0].cElements && SNAREDEBUG >= 6) { DebugMsg("cSize is going to fail"); } 
			cSize = pArrayVal->rgsabound[0].cElements;
		} catch(...) {
			if(SNAREDEBUG >= 6) { DebugMsg("CRASH: cSize grab failed. Some null-pointer weirdness going on here."); }
			return(E_FAIL);
		}

		if(SNAREDEBUG >= 6) { DebugMsg("csize is OK"); }
		// Just a small 'what the?' check
		if(cSize > 16384 || cSize <= 0) {
			if(SNAREDEBUG >= 6) { DebugMsg("Size: %d is just plain silly. Must be a corruption. Exiting",cSize); }
			return(E_FAIL);
		}
        *bytes = (LPBYTE)malloc( cSize );

        if( *bytes == NULL ) return E_FAIL;

        hr = SafeArrayAccessData(pArrayVal, (void HUGEP * FAR *) &pArray);
        if (SUCCEEDED(hr)) {
            // Copy the bytes to the safe array.
		    memcpy( *bytes, pArray, cSize );
		    SafeArrayUnaccessData( pArrayVal );
            *plcb = cSize;
            hr = S_OK;
        } else {
			// Clean up
			free(*bytes);
			return(E_FAIL);
		}
    } else {
        hr = E_OUTOFMEMORY;
    }

    return hr;
}


// Lets go about this VERY differently. It appears that getting a users group membership
// is relatively easy. Lets work backwards from that.
//
int ShowDomainUserGroupsWin2k(SOCKET http_socket)
{
	char HTTPBuffer[1024]="";
	
	HRESULT hr = S_OK;

	// Pull back rootDSE and the current user's domain container DN.
	IADs *pObject = NULL;
	IADsUser * pADsUser;
	IDirectorySearch *pContainerToSearch = NULL;
	LPOLESTR szPath = new OLECHAR[MAX_PATH];
	VARIANT var;
	int iCount = 0;
	BOOL FirstUser=1;

	if(!http_socket) {
		return(0);
	}

	if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Inside ShowDomainUserGroupsWin2k."); }
	
	hr = ADsOpenObject(L"LDAP://rootDSE",
		NULL, NULL,
		ADS_SECURE_AUTHENTICATION, // Use Secure Authentication
		IID_IADs,
		(void**)&pObject);
	
	if (FAILED(hr))	{
		if (pObject) {
			pObject->Release();
		}
		delete [] szPath;
		if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Could not open RootDSE."); }
		return(0);
	}

	if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Grabbed RootDSE."); }

	hr = pObject->Get(L"defaultNamingContext",&var);
	if (SUCCEEDED(hr)) {

		if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Grabbed defaultNamingContext."); }

		wcscpy_s(szPath,MAX_PATH,L"LDAP://");
		if(wcslen(var.bstrVal) < MAX_PATH) {
			wcscat_s(szPath,MAX_PATH,var.bstrVal);
		} else {
			// Buffer is too small for the domain DN
			if (pObject) {
				pObject->Release();
			}
			delete [] szPath;
			VariantClear(&var);
			if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Tiny buffer. Out of here."); }
			return(0);
		}
		
		hr = ADsOpenObject(szPath, NULL, NULL,
			ADS_SECURE_AUTHENTICATION, // Use Secure Authentication
			IID_IDirectorySearch, (void**)&pContainerToSearch);
		
		if (SUCCEEDED(hr)) {

			if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Opened object."); }

			// Specify subtree search
			ADS_SEARCHPREF_INFO SearchPrefs[2];
			SearchPrefs[0].dwSearchPref = ADS_SEARCHPREF_SEARCH_SCOPE;
			SearchPrefs[0].vValue.dwType = ADSTYPE_INTEGER;
			SearchPrefs[0].vValue.Integer = ADS_SCOPE_SUBTREE;
				
			// Note: By default, MS will only return 1000 entries.
			// The following code forces it to look for more.
			SearchPrefs[1].dwSearchPref = ADS_SEARCHPREF_PAGESIZE;
			SearchPrefs[1].vValue.dwType = ADSTYPE_INTEGER;
			SearchPrefs[1].vValue.Integer = 1000;

			DWORD dwNumPrefs = 2;
			
			// COL for iterations
			LPOLESTR pszColumn = NULL;
			LPOLESTR szADsPath=new OLECHAR[MAX_PATH];

			ADS_SEARCH_COLUMN col;
			
			// Interface Pointers
			IADs *pObj = NULL;
			IADs * pIADs = NULL;
			
			// Handle used for searching
			ADS_SEARCH_HANDLE hSearch = NULL;

			// Set the search preference
			hr = pContainerToSearch->SetSearchPreference(SearchPrefs, dwNumPrefs);
			if (FAILED(hr)) {
				if (pObject) {
					pObject->Release();
				}
				delete [] szADsPath;
				delete [] szPath;
				if (pContainerToSearch) {
					pContainerToSearch->Release();
				}
				VariantClear(&var);
				if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Could not setsearchpreference."); }

				return(0);
			}

			LPOLESTR pszScanList[] = {L"ADsPath"};
			
			hr = pContainerToSearch->ExecuteSearch(L"(&(objectCategory=person)(objectClass=user))",
				pszScanList,
				sizeof(pszScanList)/sizeof(LPOLESTR),
				&hSearch);
			
			if (SUCCEEDED(hr)) {
				// Call IDirectorySearch::GetNextRow() to retrieve more data
				hr = pContainerToSearch->GetFirstRow(hSearch);
				if (SUCCEEDED(hr)) {
					
					while(hr == S_OK) {
						iCount++;

						// No need to loop through the array of passed column names,
						// Since we only asked for one.
						hr = pContainerToSearch->GetNextColumnName(hSearch, &pszColumn );
						if(!SUCCEEDED(hr)) {
							hr=S_OK;
							if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Could not get next column name."); }

							continue;
						}

						hr = pContainerToSearch->GetColumn(hSearch, pszColumn, &col);
						if(SUCCEEDED(hr)) {
							// Print the data for the column and free the column
							wcsncpy_s(szADsPath,MAX_PATH,col.pADsValues->CaseIgnoreString,_TRUNCATE);

// DEBUG only - simulate lots of users.
//for(int tempcount=0;tempcount<500;tempcount++) {
// OK.. the memory leak is in here somewhere!!!!!!!

							if(SNAREDEBUG >= 6) { DebugMsg("Alloc pADsUser"); }

							hr = ADsOpenObject(szADsPath,NULL,NULL,
									ADS_SECURE_AUTHENTICATION,
									IID_IADsUser,
									(void **)&pADsUser);
							
							if(SUCCEEDED(hr)) {

								BSTR username;
								VARIANT vTokenGroups;
								VARIANT HUGEP *pVar;
								LPWSTR prop[] = {L"TokenGroups"};
								SAFEARRAY *pArray;
								DWORD SIDCount,lBound;

								PSID pSID;
								DWORD i;
								long cbSID;

								int firstgroup=1;

								if(SNAREDEBUG >= 6) { DebugMsg("Alloc username"); }
								pADsUser->get_Name(&username);

								// die if username null?
								if(!username) {
									hr=S_OK;
									if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Could not get Name."); }
									pADsUser->Release();
									if(pszColumn) {	FreeADsMem(pszColumn); }
									continue;
								}
								char utemp[1024];
								snprintf_s(utemp,1024,_TRUNCATE,"%S",username);
								//if (!strncmp(utemp,"CN=hcluster",11) || !strncmp(utemp,"CN=asdf",7)) {
								//	DebugMsg("here is the user");
								//}

								snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%S	",username);
								send(http_socket,&HTTPBuffer[3],(int)strlen(HTTPBuffer)-3,0);

								// Free username here - we don't need it any more.
								if(username) {
									if(SNAREDEBUG >= 6) { DebugMsg("Free username"); }
									SysFreeString(username);
								}

								if(SNAREDEBUG >= 6) { DebugMsg("Alloc vTokenGroups?"); }
								// Retreive the token groups array...
								VariantInit(&vTokenGroups);

								hr = ADsBuildVarArrayStr(prop,1,&vTokenGroups);
								if(!SUCCEEDED(hr)) {
									hr=S_OK;
									if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Couldnt buildvararraystr."); }
									pContainerToSearch->FreeColumn(&col);
									if(pszColumn) {	FreeADsMem(pszColumn); }
									pADsUser->Release();

									continue;
								}

								hr = pADsUser->GetInfoEx(vTokenGroups, NULL);

								if(SNAREDEBUG >= 6) { DebugMsg("Free vTokenGroups"); }
								VariantClear(&vTokenGroups);
								if(!SUCCEEDED(hr)) {
									hr=S_OK;
									if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Couldnt getinfoex."); }
									pContainerToSearch->FreeColumn(&col);
									if(pszColumn) {	FreeADsMem(pszColumn); }
									pADsUser->Release();
									continue;
								}

								if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Getting tokengroups."); }

								if(SNAREDEBUG >= 6) { DebugMsg("Alloc vtokengroups again?"); }
								hr = pADsUser->Get(L"TokenGroups",&vTokenGroups);
								if(!SUCCEEDED(hr)) {
									hr=S_OK;
									if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Could not get tokengroups."); }
									pADsUser->Release();
									VariantClear(&vTokenGroups);
									pContainerToSearch->FreeColumn(&col);
									if(pszColumn) {	FreeADsMem(pszColumn); }
									continue;
								}

								// Wander through the TokenGroups with a variant array
								// and loop through the SIDs
								pArray = vTokenGroups.parray;
								SIDCount = pArray->rgsabound->cElements;
								lBound = pArray->rgsabound->lLbound;

								if(SNAREDEBUG >= 6) { DebugMsg("Alloc pArray"); }

								hr = SafeArrayAccessData( pArray, (void HUGEP**)&pVar);
								if(!SUCCEEDED(hr)) {
									hr=S_OK;
									if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Couldn't SafeArrayAccessData."); }
									pADsUser->Release();
									VariantClear(&vTokenGroups);
									pContainerToSearch->FreeColumn(&col);
									if(pszColumn) {	FreeADsMem(pszColumn); }
									continue;
								}
								// Grab the sid into pSID (note: allocated by VarToBytes...
								// Don't forget to clear!
								DWORD dwRC;

								firstgroup=1;

								char szName[513]="";
								char szDomain[513]="";

								if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: about to loop through sids. lbound is %d nosids is %d",lBound,SIDCount); }
								for( i = lBound; i < SIDCount;i++ ) {

									// if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: looping through sids. lbound is %d nosids is %d, i is %d.",lBound,SIDCount,i); }
									strncpy_s(szName,_countof(szName),"",_TRUNCATE);
									strncpy_s(szDomain,_countof(szDomain),"",_TRUNCATE);

									// Convert the variant containing the SID into an array
									// of bytes so that we can use lookupaccountsid.
									if(SNAREDEBUG >= 6) { DebugMsg("Alloc psid"); }
									hr = VarToBytes(&pVar[i], (LPBYTE *)&pSID, &cbSID);

									if(!SUCCEEDED(hr)) {
										// Break out of here. Something is seriously corrupted in our pVar variables.
										if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: VarToBytes bugged out. The UserName is %S",username); }
										// continue;
										break;
									}

									if(SNAREDEBUG >= 6) { DebugMsg("Attempting sid translation"); }
									// HERE: Translate sid to name.
								    // Some of the MS System calls use by LookupAccountSid are buggy.
									try {
										SID_NAME_USE snu;
										DWORD cbName = 512;
										DWORD cbDomain = 512;
										// if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Trying lookupaccountsid."); }
										dwRC=LookupAccountSid(NULL, pSID, szName, &cbName, szDomain, &cbDomain, &snu);
									} catch (...) {
										dwRC=0;
										strncpy_s(szName,1,"",_TRUNCATE);
										if(SNAREDEBUG >= 6) { DebugMsg("DGWin2k: Lookupaccountsid barfed."); }
									}

									if(szName) {
										if(strlen(szName)) {
											char group1[1024]="";
											char tempstr[1024]="";

											if(firstgroup) {
												snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%s",szName);
												firstgroup=0;
											} else {
												snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,",%s",szName);
											}
											send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
										}
									}

									if(pSID) {
										if(SNAREDEBUG >= 6) { DebugMsg("Releasing pSID"); }
										free(pSID); // VariantArrayToBytes allocates memory using Malloc, must free it
									}

								}

								send(http_socket,"\n",1,0);

								// Need to clean up...

								if(SNAREDEBUG >= 6) { DebugMsg("Releasing pArray"); }
								SafeArrayUnaccessData(pArray);

								if(SNAREDEBUG >= 6) { DebugMsg("Releasing vTokenGroups"); }
								VariantClear( &vTokenGroups);


								// Free pADsUser - we don't need it any more.						
								if(SNAREDEBUG >= 6) { DebugMsg("Releasing PADSUser"); }
								if(pADsUser) {	pADsUser->Release(); }
							}

//} // Debug only

							pContainerToSearch->FreeColumn(&col);


						}
						if(pszColumn) {
							FreeADsMem(pszColumn);
						}
						
						// Get the next row
						hr = pContainerToSearch->GetNextRow(hSearch);
					}
				}
				// Close the search handle to clean up
				if(hSearch) {
					pContainerToSearch->CloseSearchHandle(hSearch);
				}
			}
			if(szADsPath) {
				delete [] szADsPath;
			}

			if (SUCCEEDED(hr) && iCount==0) {
				hr = S_FALSE;
			}
			
			if (SUCCEEDED(hr)) {
				if (hr==S_FALSE) {
					if(SNAREDEBUG >= 6) DebugMsg("No user object could be found");
				}
			} else if (hr==0x8007203e) {
				if(SNAREDEBUG >= 6) DebugMsg("Could not execute query. An invalid filter was specified.");
			} else {
				if(SNAREDEBUG >= 6) DebugMsg("Query failed to run. HRESULT: %x",hr);
			}
		} else {
			if(SNAREDEBUG >= 6) DebugMsg("Could not execute query. Could not bind to the container.");
		}

		if (pContainerToSearch) {
			pContainerToSearch->Release();
		}
		VariantClear(&var);
	}

	if(szPath) {
		delete [] szPath;
	}
			
	if(pObject) {
		pObject->Release();
	}

	return(1);
}

// Check for mixed mode..
BOOL ADIsMixedMode()
{
	BOOL rc=0;
	HRESULT hr = E_FAIL;
	VARIANT var;
	
	// This ADSOpenObject is causing a new thread to happen & stick around.
	// Suspect it might be a windows DLL.

	// Pull back rootDSE and the current user's domain container DN.
	IADs *pDomain = NULL;
	LPOLESTR szPath = new OLECHAR[MAX_PATH];
		
	if (SNAREDEBUG >= 5) DebugMsg("ADIsMixedMode");
	hr = ADsOpenObject(L"LDAP://rootDSE",
			NULL,
			NULL,
			ADS_SECURE_AUTHENTICATION, // Use Secure Authentication
			IID_IADs,
			(void**)&pDomain);
		
	if (FAILED(hr))	{
		if (pDomain) {
			pDomain->Release();
		}
		delete [] szPath;
		return(0);
	}
	
	if (pDomain) {
		hr = pDomain->Get(L"defaultNamingContext",&var);
		if (SUCCEEDED(hr)) {
			wcscpy_s(szPath,MAX_PATH,L"LDAP://");
			if(wcslen(var.bstrVal) < MAX_PATH) {
				wcscat_s(szPath,MAX_PATH,var.bstrVal);
			} else {
				// Buffer is too small for the domain DN
				if (pDomain) {
					pDomain->Release();
				}
				delete [] szPath;
				return(0);
			}
			
			if (pDomain) {
				pDomain->Release();
				pDomain=NULL;
			}
			hr = ADsOpenObject(szPath, NULL, NULL,
					ADS_SECURE_AUTHENTICATION, // Use Secure Authentication
					IID_IADs, (void**)&pDomain);
				
			if (SUCCEEDED(hr)) {		
				VariantClear(&var);

				// Get the ntMixedDomain attribute.
				hr = pDomain->Get(_bstr_t("ntMixedDomain"), &var);
				if (SUCCEEDED(hr)) {
			
					// Type should be VT_I4.
					if (var.vt==VT_I4) {			
						// Zero means native mode.
						if (var.lVal == 0) {
							rc=1;
						}
					}
				}
			}

			VariantClear(&var);

			if(pDomain) {
				pDomain->Release();
				pDomain=NULL;
			}
		}
	}
	if(pDomain) {
		pDomain->Release();
	}
	delete [] szPath;
	return rc;
}



int ShowThisDomainGroupMembersNT(WCHAR *Group,WCHAR *PDC, SOCKET http_socket)
{
	GROUP_USERS_INFO_0* Members,*MSave;
	DWORD dwEntriesRead=0,dwTotalEntries=0,dwReturn=0;
	char szName[255]="";
	char Buffer[256]="";
	int first=1;
	int retval;

	if (SNAREDEBUG >= 5)DebugMsg("ShowThisDomainGroupMembersNT");
	do {
		// NOTE: This function call does not display domain groups of groups in active directory native mode!
		dwReturn = NetGroupGetUsers(PDC, Group, 0,
         (PBYTE*) &Members, MAX_PREFERRED_LENGTH,
         &dwEntriesRead,	&dwTotalEntries, NULL );
		MSave=Members;

		while ( dwEntriesRead ) {
			// Convert UniCode to ASCII
			WideCharToMultiByte( CP_ACP, 0,Members->grui0_name,-1, szName, 254, NULL, NULL );

			if(!first) {
				snprintf_s(Buffer,256,_TRUNCATE,",%s",szName);
			} else {
				first=0;
				snprintf_s(Buffer,256,_TRUNCATE,"%s",szName);
			}
			
			retval = send(http_socket,Buffer,(int)strlen(Buffer),0);			

			Members += 1;  // Step to the next one

			dwEntriesRead--;

		}
		if(MSave != NULL) {
			NetApiBufferFree(MSave);
			MSave=NULL;
		}
	} while(dwReturn == ERROR_MORE_DATA);

	if(MSave != NULL) {
		NetApiBufferFree(MSave);
	}

	return(0);
}








// General instructions:
// $ expr `./base64 intersect.gif | wc -c` - `./base64 intersect.gif | wc -l` "*" 2 + 1
//   2029
// ./base64 intersect.gif | sed 's/^/   "/' | sed 's/.$/"  \\/' >out.txt
// 
//  mangle out.txt as appropriate - add the (wc -c) - ((wc -l)*2) + 1 figure to the buffer size.
int InterSectImageClear(char *source, char *dest, int size)
{
	char IntersectGif[329];
	char temp[329];
	int size2;

	strncpy_s(IntersectGif,329,"R0lGODlhDQAOAIQVAAwMDCIiIikpKUJCQk1NTVVVVV9fX2ZmZnd3d4aGhpaWlpmZmaCgpLKy"  \
		"ssDAwMzMzNfX193d3ePj4+rq6vHx8f//////////////////////////////////////////"  \
		"/yH5BAEKAB8ALAAAAAANAA4AAAVx4Cd+RwAIxzgexfJATzMkI3IwkkRRUGMgolnjFYn0EIVP"  \
		"4dZoOJ6OJoIwWDSh0QYjQShcIeBw03BwPIq5HMxxODQiksmOMpFEGonEW1fp0ydbeQ99hH0P"  \
		"eSQKEYUVEgpAImQMEBMQDAgGKiIFA50EKiEAOw==",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}

int InterSectImageInfo(char *source, char *dest, int size)
{
	char IntersectGif[473];
	char temp[473];
	int size2;

	strncpy_s(IntersectGif,473,"R0lGODlhDQAOAKUjAAwMDBwcHAAzACIiIikpKTMzADMzMzk5OUJCQjNmM1VVVV9fX2ZmMzOZ"  \
   "M3d3d2aZM2aZZoaGhpmZZmbMM2bMZpnMM5nMZrKyspnMmcDAwMzMmZn/Zt3d3cz/Zsz/mefn"  \
   "1urq6vHx8f//zP//////////////////////////////////////////////////////////"  \
   "/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA"  \
   "AAANAA4AAAZ9wJ/wpxgACIrh0LGIXDiZiMKxPEQ+oBDoEzFQf4SEBKPBmCELAjGReEAo8Mmj"  \
   "wTa0H4+JXv5IBAp4ExaDFRV8AgUQExUWG44bjBAFCRCDGx2YG4MSCQwPFpgeHpgdFg8MEQwW"  \
   "oqyiFqg/nqsirKYLQ55jGhYSp0pCCMFsSkEAOw==",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}

int InterSectImageWarn(char *source, char *dest, int size)
{
	char IntersectGif[473];
	char temp[473];
	int size2;

	strncpy_s(IntersectGif,473,"R0lGODlhDQAOAKUjABwcHCkpKTMzM2YzAEJCQmYzM5kzAJkzM1VVVWZmM2ZmZplmM5lmZnd3"  \
   "d8xmM8xmZoaGhpmZM5mZZpaWlsyZM8yZZv+ZM/+ZZszMZszMmf/MM8zMzP/MZv/Mmd3d3efn"  \
   "1v//Zv//mf/78P//////////////////////////////////////////////////////////"  \
   "/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA"  \
   "AAANAA4AAAZ9wJ/w1wAEBIjhUNFgeDybSQMybBQkos8nKyk0hIdHpUPucCqLw49xcFAoFYzm"  \
   "7TgcCu63Zv6mOAYFFBYWGhwce4MWBgUVh4aPiAsLjY8gII4XCwyNliGelhwUDBILGJ2enhgL"  \
   "Ej8JpaipEQtDCQkRGRkYEhEJSkIJBMG9Q0EAOw==",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}
int InterSectImagePri(char *source, char *dest, int size)
{
	char IntersectGif[461];
	char temp[461];
	int size2;

	strncpy_s(IntersectGif,461,"R0lGODlhDQAOAKUlAAQEBBwcHDMzM2YzAEJCQmYzM5kzAE1NTZkzM8wzAF9fX2ZmM8wzM2Zm"  \
   "ZplmM5lmZnd3d8xmAMxmM8xmZoaGhv9mM8yZM8yZZq2pkMyZmf+ZM/+ZZsDAwP/MZv/MmdfX"  \
   "1//MzO/Wxufn1v//zP/78P//////////////////////////////////////////////////"  \
   "/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA"  \
   "AAANAA4AAAZ2wJ/w1wgAAofhsEGgcD4cikIxhAgyIJKINMIUKMKBY7LxmC8Xx+DnMEgYkrgl"  \
   "bjCoDYl4ZV+RRBADA3oaG4UafRKBcYUdHYZ9ioVmHo2FEnYIkpMehQ4OFAUXm2aOCBc/D6Ee"  \
   "ISFnnkMPCA5oaQ4LSkIFurpKQQA7",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}
int InterSectImageCrit(char *source, char *dest, int size)
{
	char IntersectGif[469];
	char temp[469];
	int size2;

	strncpy_s(IntersectGif,469,"R0lGODlhDQAOAKUhAAQEBDMAABwcHGYAACkpKUJCQmYzM01NTZkzM1VVVV9fX8wzM2ZmZswz"  \
   "ZplmM5lmZnd3d8xmM8xmZoaGhv9mZpaWlsyZZv98gMyZmf+ZZv+ZmcDAwP/MmdfX1//MzOfn"  \
   "1vHx8f//////////////////////////////////////////////////////////////////"  \
   "/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA"  \
   "AAANAA4AAAZ8wJ/wxxAABIfhkFGYbDqbiUIxhBAwH5D2UzlMhAaHBIPRkCUPwy+NQDQkkkik"  \
   "bWAjFgu4fEEP3OEUFxQUEXwDAxESgReMgnEDBgiNGpQZjBF1kheUnIwIDxMGZRocpZQWn2sG"  \
   "EhoeHhwaEg4PQ2kPEhYPumpKPwkGwLxCQQA7",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}

int InterSectImage(char *source, char *dest, int size)
{
	char IntersectGif[2029];
	char temp[2029];
	int size2;

	strncpy_s(IntersectGif,2029,"R0lGODlhzQBGALMAAB8aF01JR2toZtwrGYF+fONVRo+Mi5eWleuCePKzrLOysszLy/jRzunl" \
	    "5f////j29SwAAAAAzQBGAEAI/gAdCBxIsKDBgw4eIFxIUCHDhxAjSkT4AMGAAQgmatw40CHH" \
	    "jxs9ghQJsuTEBxdTpkxgsqXLlzBjyvyoMuXMmzAB6NQp0MDOnzoDkOz504ADn0CTAniAVOlO" \
		"oQqcSgVqdKpVAARrXiyA0+XQkkCJ7jRakMDPAA3MjmUYtikAsgfV6lTw9WFYgwKACj34gIFW" \
		"jF0DCx5MeGPUsw08WtTKMqFcAGgZNghQ9ChQAQ1Kuq36s7DnzxL7/kXw4DFah6gFpk4o8ADV" \
		"Bwpjs45d1/Lau6Bz6y5YQCvXmbV3Cx++MUHvvxcZHFSgoOGB5g4WGFhAfUFmAwqqL2i94EGD" \
		"AwSZ/nNXreDA9gXmq5vvmb165sDBIcYnfjAB8gLz6ev3up+ifa0i5VeYgCEtROBIsyUIm0Gy" \
		"seZgbatFqNqEBB2nUkb9BXbXZgJN9hN0YukE10FtVYbQY1clxVmKSjW0WE0HZijRhiYetIBS" \
		"AdjVGYcUPZAXi0Bth9tBHv4EnkEWqjQUU5SxKMB2HTEFpJBXrTiVjFhO9F9NGKIIpE7g8ahZ" \
		"ZUNmaeZGL6rUkQJNfgllQmyyCKJBHJZ55p0LNZBkSr8VhN4D66mGnkGBEjRdRwcUetQB7zmw" \
		"HnraBYqddo3ieecDe2IUo6WcdtrRlkp6KuqoqmH6F34ZbkrqpZkOoOqq/7DqZmpNjcVqK55/" \
		"VSrjqyR2BmdSkSHEoVtS2TbVXkV+CQB0yho5EKgp6XorQmFJudZjBJAkZq87GfvWQo/NKWyN" \
		"8jnQwJDQXlTrtNT6KuYDN/6UmLcjGlTiWic2K68D+s5VEEq+Ycmrve6S21GbKrK1o8Edndsv" \
		"AN3ZqRrCAAiAUJopKcfuTQ0oYMChGwsU709vCuRXwAMl2+x7FF9FpVVWFhsyfMRaPBByDj0m" \
		"wMc898wzwgZYK2JLdfo6s4ytKqSzz0z3zGiIbw1cdLdH75rpbz/qC2XWci40NU9Vy4jxRWGX" \
		"/dnYA6zLWgPW8fUvTEtS5KDZoD2QLp/LpYceiP6DFqRoT1B+pxBzDk33HV2PHkloon/TLRhy" \
		"KzkuuWB9JYnh5C8N7OndgOmnOeaUN3DfgqCb9DmenDd6eulho315qpfSLRpjq7NOd6av244g" \
		"f2f+RXpH+9UON+h/6W78RpmqPXfIuMHbZAAEzMvXsCkKLdVesBnQslRPDtSv4g6MjWqWtd/l" \
		"MLDSQm0UsU5565RQD2zPYmYPL9XhXwl4JHx/NJ71k83A2xbBuiVAgpgmfSkDmmGGhLb9Yal/" \
		"Q3MAwsBHL4URkGEDWVrTeqbADW6QYvo7FfliAsFvdShIhcOg9xaGr7jUDzwPyxFB7pY/s5Ww" \
		"XocJynVUKJB7RZBBGv70oNPeQxWfcU1E3TlIAx24nxsy6IhUsSBPCphBxDyIQqvpodEKckQZ" \
		"HkSEsMtJwVpYkPMlpWQDnCIPHQDFKfFri2WkWL1MNpoeXfGOEIINbRS0PBKO8YfL0QsCV3hB" \
		"MiIkTsqKGBwNYkZ/FQRtDBCJyoAEovi56QEpiln7jheRHO4EjUkbiCebZZSRTQmTVXqjVTg5" \
		"EdecxSMnq0mfwgUR6j1FamRaJCs5ogAC9OxNaGuMl760vqLg8ja63CXcTqW0+u3QkBz5GlaU" \
		"2RVIluZDH3GLAAg0FGlSsysA45K56tedRqaILuNCJtW+eRPxqaaNKUqiJSlZF2+ys53FA6ne" \
		"PY3nzgLtM2TeqeM/jxdLGDHIY+Jim0GsQ5K2pQyNDhVZZuClnTdVlKED1UhsGNCqAWjMOdsp" \
		"j0ekQyc0OupNzBHcQJ5zKECdZ0QONQ8TOVkRyA1AV94xAOMSZYD3DEokMvVbEj2203mt5wHM" \
		"OVTfBJId7ugvoxJBm0qUZ66IdqhtbKNUdCoq0ehUCl6ZsWrbKKodh1x0kFAliFQL8NG0lm5L" \
		"CJAe3QICADs=",_TRUNCATE);

	size2=base64decode (temp, IntersectGif);

	memcpy(dest,temp,size2);
	return(size2);
}

int debracket(char *source, char *dest, int length)
{
	//This routine is simply to replace the HTML metacharacters "<" and ">" with
	// "&lt;" and "&gt;". That's all!

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) return(1);

      while(*source) {
              if(*source == '<') {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='l'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } else if(*source == '>') {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='g'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } else {
                      if(count < length) { *dest=*source; dest++; count++;}
              }
              source++;
      }
      *dest='\0';

	  dest=copyofdest;

      return(0);
}

int Display404(SOCKET http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy_s(HTTPBuffer,_countof(HTTPBuffer), "HTTP/1.0 404 Not Found\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/html\r\n\r\n" \
						"<html><body><center><h2>Page Not Found</h2></center></body></html>",
			_TRUNCATE);

	return(send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0));
}

int DisplayTextHeader(SOCKET http_socket)
{
	char HTTPBuffer[512];
	if(SNAREDEBUG >= 5) { DebugMsg("DisplayTextHeader"); }
	// Overwrite HTTPBuffer with the header data.
	strncpy_s(HTTPBuffer, _countof(HTTPBuffer), "HTTP/1.0 200 OK\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/plain\r\n\r\n",
			_TRUNCATE);
	return(send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0));
}

// Convert sid to text.
BOOL GetUserSid(
    LPSTR szName,            // username
    LPTSTR TextualSid,    // buffer for Textual representation of SID
    LPDWORD lpdwBufferLen // required/provided TextualSid buffersize
    )
{
	// For LookupAccountName
	PSID pSid = NULL;
	DWORD sid_size=0;
	char * domain;
	DWORD dom_size=0;

	SID_NAME_USE sid_use;
	int retval=0;
	if (SNAREDEBUG >=5) DebugMsg("GetUserSid");

	if(!szName || !TextualSid) {
		strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
		return(0);
	}

	if(LookupAccountName(NULL,(LPCSTR)szName,0,&sid_size,0,&dom_size,&sid_use) == 0) {
		if(GetLastError() != ERROR_INSUFFICIENT_BUFFER) {
			strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
			return(0);
		}
	}

	pSid = (PSID)LocalAlloc( LMEM_FIXED, sid_size);
	if(!pSid) {
		strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
		return(0);
	}
	domain = (char *)LocalAlloc( LMEM_FIXED, dom_size);
	if(!domain) {
		LocalFree((HLOCAL)pSid);
		strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
		return(0);
	}

	if(LookupAccountName(0, (LPCSTR)szName, pSid, &sid_size, domain, &dom_size, &sid_use) == 0) {
		LocalFree((HLOCAL)pSid);
		LocalFree((HLOCAL)domain);
		return(0);
	}

	if(pSid) {
		// Obtain the textual representation of the SID.
		if (!GetTextualSid(
			pSid, // user binary Sid
			TextualSid,      // buffer for TextualSid
			lpdwBufferLen)) {       // size/required buffer
				strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
		}
	} else {
		strncpy_s(TextualSid,*lpdwBufferLen,"Unknown",_TRUNCATE);
	}

	LocalFree((HLOCAL)pSid);
	LocalFree((HLOCAL)domain);

	return(1);
}



int DumpRegistry(SOCKET http_socket, char *source, char * Output, int OutputSize) {

	// Hmm.. maybe present a list of options here:
	// HKEY_CLASSES_ROOT, HKEY_CURRENT_CONFIG, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE, HKEY_USERS

	char Variable[2048]="", Argument[2048]="";
	char Base[2048]="", SubKey[2048]="";
	char HTTPBuffer[2048]="";
	HKEY BaseKey;
	HKEY FinalKey;

	char *psource=source;

	while((psource=GetNextArgument(psource,Variable,_countof(Variable),Argument,_countof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_Base") != NULL)
		{
			strncpy_s(Base,_countof(Base),Argument,_TRUNCATE);
		}
		if (strstr(Variable,"str_SubKey") != NULL)
		{
			strncpy_s(SubKey,_countof(SubKey),Argument,_TRUNCATE);
		}
	}
	
	if(!(strlen(Base))) {
		strncpy_s(Output,OutputSize,"<ul><li><a href=\"/RegDump?str_Base=HKEY_CLASSES_ROOT\">HKEY_CLASSES_ROOT</a><br><li><a href=\"/RegDump?str_Base=HKEY_CURRENT_CONFIG\">HKEY_CURRENT_CONFIG</a><br><li><a href=\"/RegDump?str_Base=HKEY_CURRENT_USER\">HKEY_CURRENT_USER</a><br><li><a href=\"/RegDump?str_Base=HKEY_LOCAL_MACHINE\">HKEY_LOCAL_MACHINE</a><br><li><a href=\"/RegDump?str_Base=HKEY_USERS\">HKEY_USERS</a><br></ul><p>Note: You can also supply a str_SubKey argument to the URL to restrict your scan to certain registry keys. Backslashes must be escaped. Eg: <a href=\"/RegDump?str_Base=HKEY_LOCAL_MACHINE&str_SubKey=HARDWARE\\\\DESCRIPTION\\\\System\">HKEY_LOCAL_MACHINE\\HARDWARE\\DESCRIPTION\\System</a>",_TRUNCATE);
		return(-1);
	}
	
	BaseKey=HKEY_LOCAL_MACHINE;
	if(!strcmp(Base,"HKEY_CLASSES_ROOT")) {
		BaseKey=HKEY_CLASSES_ROOT;
	} else if(!strcmp(Base,"HKEY_CURRENT_CONFIG")) {
		BaseKey=HKEY_CURRENT_CONFIG;
	} else if(!strcmp(Base,"HKEY_CURRENT_USER")) {
		BaseKey=HKEY_CURRENT_USER;
	} else if(!strcmp(Base,"HKEY_LOCAL_MACHINE")) {
		BaseKey=HKEY_LOCAL_MACHINE;
	} else if(!strcmp(Base,"HKEY_USERS")) {
		BaseKey=HKEY_USERS;
	}

	// Try and turn on enhanced privileges, so we can read the security registry keys.
	//EnableSecurityName();

	// HERE: Take registry key from the arguments.
	// NOT SURE What to do with the HKEY_CURRENT_USER thing though......

	LONG result = ::RegOpenKeyEx(BaseKey, // root key
        SubKey,  // key name
        0,   // reserved
        KEY_READ,  // access desired
        &FinalKey);  // result goes here
	
	if(result != ERROR_SUCCESS) {
		switch(result) {
		
			case ERROR_FILE_NOT_FOUND:
				// Basic configuration key missing
				strncpy_s(Output,OutputSize,"<div align=center><font color=\"red\">Sorry - the supplied subkey cannot be found.</font></div>",_TRUNCATE);
				return(-1);
			default:
				return(-1);
		}
	}

	DisplayTextHeader(http_socket);

	RegDump(FinalKey,Base,SubKey,http_socket);
	RegCloseKey(FinalKey);
	return(1);
}

// Recursive function
int RegDump(HKEY key, char * rootname, char *path, SOCKET http_socket)
{
	long result;
	int retval;

	DWORD subkeys;
	DWORD maxsubkeylen;
	DWORD maxvaluenamelen;
	DWORD maxvaluelen;
	DWORD i=0;
	char HTTPBuffer[2048];

	_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"KEY: %s\\%s\n",rootname,path);
	retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);			

	result=RegQueryInfoKey(key,
		NULL,			// class buffer
		NULL,			// pointer to class buffer size
		NULL,			// reserved
		&subkeys,		// number of subkeys here
		&maxsubkeylen,	// maximum subkey name length
		NULL,			// max class name length
		NULL,			// number of values associated with the key
		&maxvaluenamelen,// maximum value name length
		&maxvaluelen,	// maximum value length
		NULL,			// security descriptor
		NULL);			// last write time

	if(result != ERROR_SUCCESS) {
		return(0);
	}

	// FREE These
	LPTSTR subkeyname = new TCHAR [maxsubkeylen + 1];
	LPTSTR name       = new TCHAR [maxvaluenamelen + 1];
	LPBYTE value      = new BYTE [maxvaluelen + 1];

	BOOL cont=1;
	DWORD namelen = maxvaluenamelen + 1;
	DWORD valuelen = maxvaluelen + 1;
	DWORD type;


	while(cont) {
		namelen = maxvaluenamelen + 1;
		valuelen = maxvaluelen + 1;
		result = RegEnumValue(key,  // base key
			i,   // index
			name, &namelen, // name buffer
			NULL,  // reserved
			&type,  // type
			value,  // value buffer
			&valuelen);  // value count
		if(result == ERROR_NO_MORE_ITEMS) {
			cont=0;
			break;
		}
		if(result != ERROR_SUCCESS) {
			// error
			cont=0;
			break;
		}
		i++;

		char *spos=NULL;
		switch(type) {
			case REG_SZ:
			case REG_MULTI_SZ:
			case REG_EXPAND_SZ:
				_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"	STRING: %s	",name);
				retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
				spos=(char *)value;
				while(*spos) {
					switch(*spos) {
						case '\a':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\b':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\f':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\n':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\r':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\t':
							send(http_socket," ",(int)strlen(" "),0); break;
						case '\v':
							send(http_socket," ",(int)strlen(" "),0); break;
						//case '\\':
						//	send(http_socket,"\\\\",(int)strlen("\\\\"),0); break;
						default:
							send(http_socket,spos,1,0); break;
					}
					spos++;
				}
				send(http_socket,"\n",(int)strlen("\n"),0);

				break;
			case REG_DWORD:
				_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"	DWORD: %s	0x%016x\n",name,*(DWORD *)value);
				retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
				break;
			case REG_BINARY:
				_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"	BINARY: %s	",name);
				retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
				if(*(DWORD *)value == 0) {
					strncpy_s(HTTPBuffer,_countof(HTTPBuffer),"00000000000000000000000000000000",_TRUNCATE);
				} else {
					_ultoa_s(*(DWORD *)value,HTTPBuffer,_countof(HTTPBuffer),2);
				}
				retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
				retval = send(http_socket,"\n",(int)strlen("\n"),0);
				break;
			default:
				// Assume Hex
				_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"	OTHER: %s	0x",name);
				retval = send(http_socket,HTTPBuffer,(int)strlen(HTTPBuffer),0);
				spos=(char *)value;
				int hval=0;
				DWORD vcount=0;
				while(vcount < valuelen) {
					hval=*spos;
					_snprintf_s(HTTPBuffer,_countof(HTTPBuffer),_TRUNCATE,"%02x",hval);
					send(http_socket,HTTPBuffer,2,0);
					if(vcount < (valuelen-1)) {
						send(http_socket," ",1,0);
					}

					spos++;
					vcount++;
				}
				send(http_socket,"\n",(int)strlen("\n"),0);
				break;
		}
	}

	i=0;
	cont=1;
	HKEY subkey;

	// Now enumerate the subkeys
	while(cont) {
		DWORD length = maxsubkeylen + 1;
		result = RegEnumKeyEx(key, i,
			subkeyname,
			&length,
			NULL, // reserved
			NULL, // class name buffer
			NULL, // class name buffer length
			NULL); // file time

		if(result == ERROR_NO_MORE_ITEMS) {
			cont=0;
			break;
		}
		if(result != ERROR_SUCCESS) {
			cont=0;
			break;
		}
		i++;
		
		result = RegOpenKeyEx(key,  // root key
            subkeyname, // key name
            0,  // reserved
            KEY_READ, // access desired
            &subkey); // result goes here
		
		if(result != ERROR_SUCCESS) {
			
			// Should really find out the value of this.
			if(result == 5) {
				// Permission denied
				continue;
			} else {
				cont=0;
				break;
			}
		}

		int tlength=(int)strlen(path) + (int)strlen(subkeyname) + 3;
		LPTSTR subpath = new TCHAR [tlength];
		if(strlen(path)) {
			_snprintf_s(subpath,tlength,_TRUNCATE,"%s\\%s",path,subkeyname);
		} else {
			_snprintf_s(subpath,tlength,_TRUNCATE,"%s",subkeyname);
		}

		// Recurse through
		RegDump(subkey, rootname, subpath, http_socket);
		
		delete [] subpath;

		RegCloseKey(subkey);
	}
	
	delete [] subkeyname;
    delete [] name;
    delete [] value;
	return(1);

}

int Current_Events(char *source, char *dest, int size)
{
	DWORD dwWaitRes=0;
	MsgCache *myMsg=NULL;
	snprintf_s(dest,size,_TRUNCATE,"<HTML><BODY><H2><CENTER>Current Events</H2></CENTER><P><center><br />");
	dwWaitRes = WaitForSingleObject(hMutex,500);
	strncat_s(dest,size,"<table border=1 cellspacing=0 cellpadding=2 width=\"99%\" bgcolor=\"white\">\n" \
		"<tr bgcolor=\"#ffffcc\"><td>&nbsp;</td><td>Date</td><td>System</td><td>Event Count</td><td>EventID</td>" \
		"<td>Source</td><td>UserName</td><td>UserType</td><td>ReturnCode</td><td>Strings</td></tr>\n",size);
	if(dwWaitRes == WAIT_OBJECT_0) {
		myMsg = MCHead;
		int i=0;
		for (myMsg = MCHead; myMsg && i < 20; myMsg = myMsg->next, i++) {
			if (myMsg->seenflag) {
				if (i%2) snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#FEFEFE>", dest);
				else snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#EEEEEE>", dest);
			} else {
				if (i%2) snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#DDFFDD>", dest);
				else snprintf_s(dest,size,_TRUNCATE,"%s<tr bgcolor=#CCEECC>", dest);
			}
			strncat_s(dest,size,"<td>&nbsp;<div style=\"border: 1px solid black; background-color: ",_TRUNCATE);
			switch(myMsg->criticality) {
				case EVENT_CRITICAL:	strncat_s(dest,size,"#FFBBBB",_TRUNCATE); break;
				case EVENT_PRIORITY:	strncat_s(dest,size,"#FFDDBB",_TRUNCATE); break;
				case EVENT_WARNING:		strncat_s(dest,size,"#FFFFBB",_TRUNCATE); break;
				case EVENT_INFORMATION:	strncat_s(dest,size,"#BBFFBB",_TRUNCATE); break;
				default:				strncat_s(dest,size,"#FFFFFF",_TRUNCATE); break;
			}
			strncat_s(dest,size,";height: 20;width: 20\"></div>&nbsp;</td>",_TRUNCATE);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td>", dest, myMsg->SubmitTime);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td>", dest, myMsg->Hostname);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%d</td>", dest, myMsg->SnareCounter);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%d <font color=green>(%s)</font></td>", dest, myMsg->ShortEventID, myMsg->szCategoryString);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td>", dest, myMsg->SourceName);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td>", dest, myMsg->UserName);
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td>", dest, myMsg->SIDType);
			if (strstr(myMsg->EventLogType, "Fail") || strstr(myMsg->EventLogType, "Error")) {
				if (i%2) snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#FFBBBB>%s</td>", dest, myMsg->EventLogType);
				else snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#EEAAAA>%s</td>", dest, myMsg->EventLogType);
			} else if (strstr(myMsg->EventLogType, "Warn") || strstr(myMsg->EventLogType, "Info")) {
				if (i%2) snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#FFEEBB>%s</td>", dest, myMsg->EventLogType);
				else snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#EEDDAA>%s</td>", dest, myMsg->EventLogType);
			} else {
				if (i%2) snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#BBFFBB>%s</td>", dest, myMsg->EventLogType);
				else snprintf_s(dest,size,_TRUNCATE,"%s<td bgcolor=#AAEEAA>%s</td>", dest, myMsg->EventLogType);
			}
			snprintf_s(dest,size,_TRUNCATE,"%s<td>%s</td></tr>\n", dest, myMsg->szTempString);
			myMsg->seenflag=1;
		}
	} else {
		if(SNAREDEBUG >= 5) { DebugMsg("WebPages: Mutex grab failed."); }
	}
	ReleaseMutex(hMutex);
	strncat_s(dest,size,"</table>",_TRUNCATE);
	snprintf_s(dest,size,_TRUNCATE,"%s</CENTER></BODY></HTML>",dest);
	return(0);
}
