/*
FILE: SnareIIS.h
*/

#include "NTService.h"

#define MAX_EVENT 8192
#define MAX_STRING 8192
#define MAX_OUTPUT_STRING 8192
#define MAX_USERNAME	512


class CSnareIISService : public CNTService
{
public:
	CSnareIISService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();

    void SaveStatus();

	int SNAREDEBUG;

private:
	HANDLE m_hEventList[1]; // One element at the moment.
};

// Function Prototypes.
BOOL	InitWinsock				(char *);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

SOCKET	ConnectToServer			(char *, UINT, char *);

BOOL	SendToSocket			(SOCKET hSocket, char *buf, int nSize, char *szError);
void	GetFQDN					(char *string,int length);
char *	getdate					(char *date);
void	syslogdate				(char *sdate, struct tm *cdate);

// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;


// Linked list
struct dirnode {
	char filepath[1024];	// Location
	char logname[256];		// eg: W3SVC1
	long filepointer;		// Current position in file
	char logtype[256];		// eg: IISWebLog / SMTPSvcLog / FTPSvcLog
	struct dirnode * next;
};