// Snare for ISA - Version 1.3
// Copyright 2001-2003 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// See Readme.txt file for more information.
//
//
#define _CRT_SECURE_NO_DEPRECATE 1
#define _CRT_NONSTDC_NO_DEPRECATE 1

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <winsock2.h>
#include <windows.h>
#include <time.h>
#include <tchar.h>
#include <sys/stat.h>

#include "NTServApp.h"
#include "SnareISA.h"
#include "support.h"



// Quick function proto
void DebugMsg(const char* pszFormat, ...);


// Pull this from registry

char			Hostname[100];
ThreadStruct	g_Info;
SOCKET			g_hSocket = INVALID_SOCKET;      // global client/server socket
TCHAR			DELIM[2]="	";	// TAB

CSnareISAService::CSnareISAService()
:CNTService("SnareISA")
{
	//TODO: Initialize your class members here
}

BOOL CSnareISAService::OnInit()
{
	char szError[MAX_STRING];
	//TODO: Perform any initialization that needs to be done before intering the main loop

	SNAREDEBUG=this->DEBUGSET;

	if( !InitWinsock( szError ) )
	{
		DebugMsg(szError);
		return FALSE;
	}
	
	DebugMsg("SnareISA Initialisation complete");
	// return FALSE here if initialization failed & the service shouldn't start
	return TRUE;
}

void CSnareISAService::Run()
{
	DWORD dwEventLogRecords = 0, dwOldestEventLogRecord = 0, dwNewestEventLogRecord = 0,
		dwEvLogStart = 0, dwEvLogCounter = 0, dwNumberOfBytesToRead = 0, 
		dwBytesRead = 0, dwMinNumberOfBytesNeeded = 0, dwCancel = 0, dwClose = 0;

	DWORD ClearTabs=0;


	
	PEVENTLOGRECORD pELR = 0;
	PSID UserSID = 0;
	unsigned long EventID=0;
	DWORD dwSyslog=13;
	DWORD dwSyslogEnabled=0;

	// Destination for log events. Default it to something safe.
	TCHAR lpszDestination[512]="localhost";
	
	BOOL bRetVal = FALSE;
	
	SOCKET g_hSocket;
	TCHAR szError[MAX_STRING];

	DWORD dwWaitRes=0;

	DWORD dwPort=6161;

	BOOL Continue=1;
	BOOL FirstRun=1;

    char lpszPath[MAX_STRING] = "C:\\Program Files\\Microsoft ISA Server\\ISALogs\\";   // must have trailing backslash
    char filespec[2048];
	char newpath[2048]="";

	//struct stat statbuf;

    char currentdate[9]; // YYYYMMDD
    char newdate[9];	// YYYYMMDD

	long eventcount=0;

	FILE * fp;
	HANDLE handle;
	WIN32_FIND_DATA findData;

    filenode *firstnode = NULL;
	filenode *lastnode = NULL;
    filenode *newnode = NULL;
    filenode *currentnode = NULL;
	filenode *tempnode = NULL;

    int nodecount=0;


	if(SNAREDEBUG) { DebugMsg("Entering Run Phase"); }


	// Should resolve the log directory here - probably from configurator
	// Also, the names of the various web sites.
	if(!MyGetProfileString("Config","LogPath",lpszPath,sizeof(lpszPath)-1))
	{
		strncpy(lpszPath,"C:\\Program Files\\Microsoft ISA Server\\ISALogs\\",sizeof(lpszPath)-1);
		MyWriteProfileString("Config","LogPath",lpszPath);
	}
	if(lpszPath[strlen(lpszPath)-1] != '\\') {
		strcat(lpszPath,"\\");
	}

	if(!MyGetProfileString("Network","Destination",lpszDestination,sizeof(lpszDestination)))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		strncpy(lpszDestination,"localhost",sizeof(lpszDestination));
		MyWriteProfileString("Network","Destination",lpszDestination);
	}

	if(!MyGetProfileString("Config","Delimiter",DELIM,2))
	{
		DELIM[0]=9;	// TAB character
		DELIM[1]='\0';
	}

	dwPort=514;

	dwSyslogEnabled=MyGetProfileDWORD("Network","Syslog",0);
	if(!dwSyslogEnabled) {
		dwPort=MyGetProfileDWORD("Network","Port",6161);
	} else {
		// Where should we be sending this stuff (syslog ID)
		dwSyslog=MyGetProfileDWORD("Network","SyslogDest",13);
	}


	if( !InitWinsock( szError ) )
	{
		DebugMsg(szError);
		return;
	}
	
	m_hEventList[0] = CreateEvent(NULL, TRUE, FALSE, NULL);
	
	if(m_hEventList[0] == NULL)
	{	DebugMsg("CreateEvent() failed");	return;	}
	
	// Open the socket (UDP) to the indicated port
	g_hSocket = ConnectToServer( lpszDestination, (UINT)dwPort, szError );
	
	if( g_hSocket == INVALID_SOCKET )
	{
		DebugMsg(szError);
		return;
	}

	// Now, grab fully qualified hostname here.
	// Get the normal name.
	GetFQDN(Hostname, sizeof( Hostname ));

	// Set the terminate flag to zero.
	// setting this value to TRUE will terminate the service,
	// and ask it to save it's current status.
	g_Info.bTerminate = FALSE;

	// Initialise the current and new dates
    getdate(currentdate);
	getdate(newdate);


	if(SNAREDEBUG) { DebugMsg("About to enter while-continue loop"); }

	while(Continue)
	{
		// If we have been asked to terminate, do so.
		if(g_Info.bTerminate || m_bIsRunning == 0)
		{
			Continue=0;
			break;
		}

		// The service performs one check per 30 seconds. This should not be
		// a significant drain on resources.
		
		if(!FirstRun) {
			if(SNAREDEBUG) { DebugMsg("Waiting..."); }
			dwWaitRes=WaitForMultipleObjects(1,m_hEventList,FALSE,30000);
			if(SNAREDEBUG) { DebugMsg("Waiting done."); }
		}

		// If we have been asked to terminate, do so.
		if(g_Info.bTerminate || m_bIsRunning == 0)
		{
			Continue=0;
			break;
		}

		// Timeout..
		getdate(newdate);
		if(strcmp(currentdate,newdate) || !fp) {
			if(SNAREDEBUG) { DebugMsg("New date detected.."); }
			// Finish the current files we have open.
			// Ok, we should have a node list containing all interesting files.
			// -1 if we should seek to end of file.
			currentnode=firstnode;
			while(currentnode) {
				fp=fopen(currentnode->filepath,"r");
				if(!fp) {
					continue;
				}
				if(currentnode->filepointer == -1) {
					fseek(fp,0,SEEK_END);
				} else {
					fseek(fp,currentnode->filepointer,SEEK_SET);
				}

				if(SNAREDEBUG) { DebugMsg("Reading/Sending %s from %ld",currentnode->filepath,currentnode->filepointer); }
				ReadAndSendISALog(fp,g_hSocket,dwSyslogEnabled,dwSyslog,currentnode->logtype);

				currentnode->filepointer=ftell(fp);
				fclose(fp);

				currentnode=currentnode->next;
			}

			// Clear our nodes.
			if(SNAREDEBUG) { DebugMsg("Clearing nodes"); }
			currentnode=firstnode;			
			while(currentnode) {
				tempnode=currentnode->next;
				free(currentnode);
				currentnode=tempnode;
			}
			firstnode=NULL;
			lastnode=NULL;
			
			// Update our date.
			strncpy(currentdate,newdate,sizeof(currentdate));
		}


		// Ok, search for any new files in the log directory.
		// Consider only running this bit once every few minutes.
		_snprintf(filespec,sizeof(filespec),"%s*.*",lpszPath);

		if(SNAREDEBUG) { DebugMsg("Hunting through %s for files.",filespec); }

		handle = FindFirstFile( filespec, &findData );

		while(handle && FindNextFile( handle, &findData )) {
			if ( strstr(findData.cFileName,currentdate) ) {
				int found=0;
				char temppath[1024]="";

				// Do we already have this file?
				currentnode=firstnode;
				_snprintf(temppath,sizeof(temppath),"%s%s",lpszPath,findData.cFileName);

				while(currentnode) {
					//DMM file path is a bad pointer when the date changes (GMT+10)
					if(strcmp(currentnode->filepath,temppath) == 0) {
						found=1;
					}
					currentnode=currentnode->next;
				}

				// Set currentnode to the last node in the list.
				currentnode=lastnode;

				if(!found) {
					// Cool.. new filename. Add it to our list.
					// Start from the begining of the file unless this is our first run.
					newnode = (filenode *)malloc(sizeof(filenode));
					if(newnode) {
						_snprintf(newnode->filepath,1024,"%s%s",lpszPath,findData.cFileName);
				
						if(FirstRun) {
							// -1 indicates 'start at end of file'.
							newnode->filepointer=-1;
						} else {
							newnode->filepointer=0;
						}

						if(currentnode) {
							currentnode->next = newnode;
						} else {
							firstnode = newnode;
						}
						newnode->next=NULL;
					
						// Work out the log type here..
						if(strstr(findData.cFileName,"WEBEXTD")) {
							strncpy(newnode->logtype,"ISAWebLog",255);
						} else if(strstr(findData.cFileName,"_FWS_")) {
							strncpy(newnode->logtype,"ISAFWS",255);
						} else if(strstr(findData.cFileName,"_WEB_")) {
							strncpy(newnode->logtype,"ISAWebLog",255);
						} else if(strstr(findData.cFileName,"_EML_")) {
							strncpy(newnode->logtype,"ISAMail",255);
						} else {
							// Fall back to a generic basis.
							strncpy(newnode->logtype,"GenericLog",255);
						}
			
						currentnode = newnode;
						lastnode=newnode;

						nodecount++;
					}
				}
			}
		}
		
		FirstRun=0;

		// Ok, we should have a node list containing all interesting files.
		// -1 if we should seek to end of file.
		currentnode=firstnode;
		while(currentnode && !(g_Info.bTerminate || m_bIsRunning == 0)) {
			fp=fopen(currentnode->filepath,"r");
			if(!fp) {
				continue;
			}
			if(currentnode->filepointer == -1) {
				fseek(fp,0,SEEK_END);
			} else {
				fseek(fp,currentnode->filepointer,SEEK_SET);
			}

			if(SNAREDEBUG) { DebugMsg("Reading/Sending %s from %ld",currentnode->filepath,currentnode->filepointer); }

			ReadAndSendISALog(fp,g_hSocket,dwSyslogEnabled,dwSyslog,currentnode->logtype);
			currentnode->filepointer=ftell(fp);
			fclose(fp);
			currentnode=currentnode->next;
		}

	}

	if(fp) {
		fclose(fp);
	}
	
	// Clear our linked list.
	currentnode=firstnode;			
	while(currentnode) {
		tempnode=currentnode->next;
		free(currentnode);
		currentnode=tempnode;
	}
	firstnode=(filenode *)NULL;
	TerminateWinsock(g_hSocket);
	if( m_hEventList[0] ) ::CloseHandle(m_hEventList[0]);
}

long CSnareISAService::ReadAndSendISALog(FILE *fp, SOCKET g_hSocket, DWORD dwSyslogEnabled, DWORD dwSyslog, char * logtype) {
	char CurrentDate[16]="";
	time_t currenttime;
	struct tm *newtime;

	TCHAR szError[MAX_STRING];
	
	TCHAR szReadString[MAX_STRING];
	TCHAR szSendString[MAX_STRING];

	BOOL Continue=1;
	int eventcount=0;
							
	time(&currenttime);                
	newtime=localtime(&currenttime);
	syslogdate(CurrentDate,newtime);
							
	while(fgets(szReadString,MAX_STRING,fp)) {
		if(g_Info.bTerminate || m_bIsRunning == 0)
		{
			Continue=0;
			break;	
		}

		// Don't bother sending comments/headers
		if(szReadString[0] != '#') {
			if(dwSyslogEnabled) {
				_snprintf(szSendString,MAX_STRING,"<%ld>%s %s %s%s3%s%s\n",   dwSyslog,CurrentDate,Hostname,logtype,DELIM,DELIM,szReadString);
			} else {
				_snprintf(szSendString,MAX_STRING,"%s%s%s%s3%s%s\n",Hostname,DELIM,logtype,DELIM,DELIM,szReadString);
			}

			if(SNAREDEBUG) {
				DebugMsg("DEBUG - received: %s",szReadString);
				DebugMsg("DEBUG - sending: %s",szSendString);
				DebugMsg("DEBUG - length is: %d",strlen(szSendString));
			}

			if( !SendToSocket(g_hSocket, szSendString, strlen(szSendString), szError) )
			{
				puts(szError);
				break;
			}
			eventcount++;
		}
	}
	return(eventcount);
}

// Returns YYYYMMDD
char * getdate(char *date)
{
   time_t t;
   struct tm *tm;

   char year[5],month[3],day[3];
   int tempyear,tempmonth,tempday;

   t = time(NULL);
   tm=(struct tm *)gmtime(&t);

   tempyear = tm->tm_year + 1900;
   _snprintf(year,5,"%d",tempyear);

   tempmonth=tm->tm_mon+1;
   if(tempmonth >=10) {
	_snprintf(month,3,"%d",tempmonth);
   } else {
	_snprintf(month,3,"0%d",tempmonth);
   }

   tempday=tm->tm_mday;
   if(tempday >=10) {
	_snprintf(day,3,"%d",tempday);
   } else {
	_snprintf(day,3,"0%d",tempday);
   }

   _snprintf(date,9,"%s%s%s",year,month,day);

   return(date);
}


void syslogdate(char *sdate, struct tm *cdate)
{
	char Month[4];
	char Date[3];
	char Hour[3];
	char Min[3];
	char Sec[3];

	switch (cdate->tm_mon) {
		case 0: strcpy(Month,"Jan"); break;
		case 1: strcpy(Month,"Feb"); break;
		case 2: strcpy(Month,"Mar"); break;
		case 3: strcpy(Month,"Apr"); break;
		case 4: strcpy(Month,"May"); break;
		case 5: strcpy(Month,"Jun"); break;
		case 6: strcpy(Month,"Jul"); break;
		case 7: strcpy(Month,"Aug"); break;
		case 8: strcpy(Month,"Sep"); break;
		case 9: strcpy(Month,"Oct"); break;
		case 10: strcpy(Month,"Nov"); break;
		default: strcpy(Month,"Dec"); break;
	}

	if(cdate->tm_mday<10) {
		_snprintf(Date,3," %d\0",cdate->tm_mday);
	} else {
		_snprintf(Date,3,"%d\0",cdate->tm_mday);
	}

	if(cdate->tm_hour<10) {
		_snprintf(Hour,3,"0%d\0",cdate->tm_hour);
	} else {
		_snprintf(Hour,3,"%d\0",cdate->tm_hour);
	}

	if(cdate->tm_min<10) {
		_snprintf(Min,3,"0%d\0",cdate->tm_min);
	} else {
		_snprintf(Min,3,"%d\0",cdate->tm_min);
	}

	if(cdate->tm_sec<10) {
		_snprintf(Sec,3,"0%d\0",cdate->tm_sec);
	} else {
		_snprintf(Sec,3,"%d\0",cdate->tm_sec);
	}

	_snprintf(sdate,16,"%s %s %s:%s:%s\0",Month,Date,Hour,Min,Sec);
}



void GetFQDN(char *string, int length)
{
	struct hostent *phostent;
	
	// Now, grab fully qualified hostname here.
	// Get the normal name.
	if(gethostname(string, length)) {		
		strncpy(string,"localhost.unknown",length);
		return;
	}
	
	
	// Now perform a lookup on that name.
	phostent=gethostbyname(string);
	if(phostent) {
		while(phostent->h_aliases && *phostent->h_aliases) {
			if(strlen(*(phostent->h_aliases)) > strlen(string) && !strncmp(string,*(phostent->h_aliases),strlen(string))) {
				strncpy(string,*(phostent->h_aliases),length);
			}
			phostent->h_aliases++;
		}
		if(strlen(phostent->h_name) > strlen(string) && !strncmp(string,phostent->h_name,strlen(string))) {
			strncpy(string,phostent->h_name,length);
		}
	}
}


//////////////////////////////////////////////////////////////////
// SendToSocket
//              sends a buffer (buf) of size size to the specified socket
//              returns TRUE or FALSE.
BOOL  SendToSocket(SOCKET hSocket, char *buf, int nSize, char *szError)
{
	int   rv;
	
	// write it all
	while ((rv = send(hSocket, buf, nSize,0)) != nSize)
	{
		if (rv == -1)
		{
			DebugMsg("SendToSocket error encountered");
			return FALSE;
		}
		
		if (rv == nSize)
			break;
		buf += rv;
		nSize -= rv;
	}
	return TRUE;
}




///////////////////////////////////////////////////////////////////
// InitWinsock
//              starts up winsock.dll or wsock32.dll
BOOL InitWinsock( char *szError )
{
	WSAData wsData;
	
	WORD wVersionRequested = WINSOCK_VERSION;
	
	if(WSAStartup(wVersionRequested, &wsData) != 0)
	{
		// :( error
		if( szError )
		{
			_snprintf(szError,MAX_STRING,"WSAStartup failed: WSA ERROR: %d\r\n",
				WSAGetLastError());
			DebugMsg(szError);
		}
		return FALSE;
	}
	
	// all is well
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// TerminateWinsock
//      call this function with the current socket or INVALID_SOCKET
void TerminateWinsock( SOCKET hSocket )
{
	// cancel blocking calls, if any
	WSACancelBlockingCall();
	
	// close socket
	if( hSocket != INVALID_SOCKET )
		closesocket(hSocket);
	
	// unload winsock
	WSACleanup();
}


//////////////////////////////////////////////////////////////
// ConnectToServer:
//    connects to a server on a specified port number
//    returns the connected socket
SOCKET ConnectToServer(char *name, UINT nPort, char *szError)
{
	SOCKET hSocket;
	struct sockaddr_in server;
	struct hostent far *hp;
	
	
	if( !name || !*name )
		return INVALID_SOCKET;
	
	
	// Should use something nicer to check for IP addresses...
	if( isdigit(name[0]))
	{
		ZeroMemory((char *) &server, sizeof(server));
		server.sin_family      = AF_INET;
		server.sin_addr.s_addr = inet_addr(name);
		server.sin_port        = htons(nPort);
	}
	else
	{
		if ( (hp = (struct hostent far *) gethostbyname(name)) == NULL)
		{
			_snprintf(szError,MAX_STRING,"Error: gethostbyname failed: %s.",name);
			return INVALID_SOCKET;
		}
		
		ZeroMemory((char *)&server, sizeof(server));
		CopyMemory((char *) &server.sin_addr,hp->h_addr,hp->h_length);
		server.sin_family = hp->h_addrtype;
		server.sin_port = htons(nPort);
	} // else
	
	// create socket
	if( (hSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET)
	{
		_snprintf(szError,MAX_STRING,"socket failed to create datagram socket: %d\n",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	// connect to server.
	if (connect(hSocket,(struct sockaddr *)&server, sizeof(server)) == SOCKET_ERROR)
	{
		_snprintf(szError,MAX_STRING,"connect failed to connect to requested address: %d",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	return hSocket;
}


void CSnareISAService::OnShutdown() {
	// Audit: Set that global variable to TRUE so that the threads
	// receive the terminate message
	g_Info.bTerminate=TRUE;
	
	DebugMsg("SnareISA Shutdown request received");
}


// Process user control requests
BOOL CSnareISAService::OnUserControl(DWORD dwOpcode)
{
    switch (dwOpcode) {
    case SERVICE_CONTROL_USER + 0:

        // Save the current status in the registry
        SaveStatus();
        return TRUE;

    default:
        break;
    }
    return FALSE; // say not handled
}

// Save the current status in the registry
void CSnareISAService::SaveStatus()
{
	// TODO: add code to save the sate of the service in the registry
}

// Duplicate of the CNTService DebugMsg
void DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[50];
	char time[50];

	if(!pszFormat) return;
	
	SYSTEMTIME st;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,sizeof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,sizeof(time));

	_snprintf(buf, 8192, "[SNAREISA](%lu - %s %s): ", GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf(&buf[strlen(buf)],8192-strlen(buf)-1,pszFormat,arglist);
	va_end(arglist);
    _snprintf(buf,8192,"%s\n",buf);

	if(buf) { printf("%s",buf); fflush(stdout); }

#ifdef DEBUG_TO_FILE
	FILE *fp;

	if(!strlen(pszFormat)) {
		// Send a "" to truncate the file back to zero
		fp=fopen("C:\\SNAREISADebug.log","wt");
	} else {
		fp=fopen("C:\\SNAREISADebug.log","a");
	}
	if(fp) {
		fprintf(fp,"%s",buf);
		fflush(fp);
		fclose(fp);
	}
#endif
}
