// SnareISAGUIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SnareISAGUI.h"
#include "SnareISAGUIDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareISAGUIDlg dialog

CSnareISAGUIDlg::CSnareISAGUIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSnareISAGUIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnareISAGUIDlg)
	m_category = _T("");
	m_type = _T("");
	m_host = _T("");
	m_path = _T("");
	m_Delim = _T("");
	m_Port  = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSnareISAGUIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnareISAGUIDlg)
	DDX_CBString(pDX, IDC_COMBO1, m_category);
	DDX_CBString(pDX, IDC_COMBO2, m_type);
	DDX_Text(pDX, IDC_EDIT1, m_host);
	DDX_Text(pDX, IDC_EDIT2, m_Delim);
	DDX_Text(pDX, IDC_EDIT3, m_path);
	DDX_Text(pDX, IDC_EDIT4, m_Port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSnareISAGUIDlg, CDialog)
	//{{AFX_MSG_MAP(CSnareISAGUIDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareISAGUIDlg message handlers

BOOL CSnareISAGUIDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
//	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
//	ASSERT(IDM_ABOUTBOX < 0xF000);
//
//	CMenu* pSysMenu = GetSystemMenu(FALSE);
//	if (pSysMenu != NULL)
//	{
//		CString strAboutMenu;
//		strAboutMenu.LoadString(IDS_ABOUTBOX);
//		if (!strAboutMenu.IsEmpty())
//		{
//			pSysMenu->AppendMenu(MF_SEPARATOR);
//			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
//		}
//	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// This isn't all that pretty. I could really use CString etc instead.
	// Perhaps later.
	TCHAR lpszDestination[512]="localhost";
	TCHAR lpszPath[2048]="C:\\Program Files\\Microsoft ISA Server\\ISALogs\\";
	TCHAR lpszDelimiter[2]="	";
	DWORD dwSyslog=0;
	DWORD dwSyslogEnabled=0;
	DWORD dwPort=6161;
	UINT criticality=0;
	UINT category=0;
	UINT categorymap=0;

	if(!MyGetProfileString("Network","Destination",lpszDestination,sizeof(lpszDestination)))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		strncpy(lpszDestination,"localhost",sizeof(lpszDestination));
	}
	
	dwSyslogEnabled=MyGetProfileDWORD("Network","Syslog",0);
	dwSyslog=MyGetProfileDWORD("Network","SyslogDest",13);

	if(!MyGetProfileString("Config","LogPath",lpszPath,sizeof(lpszPath)))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		strncpy(lpszPath,"C:\\Program Files\\Microsoft ISA Server\\ISALogs\\",sizeof(lpszPath));
	}

	// MyWriteProfileDWORD("Network","Syslog",dwSyslogEnabled);

	// First 3 bits = criticality (eg: emerg, alert, etc.)
	// Rest = category. Note that there is a gap between ftp and local1.
	criticality=(UINT)dwSyslog & 7;
	category=(UINT)dwSyslog >> 3;
	if(category > 11) categorymap=category-4;
	else			  categorymap=category;
		
	this->SetDlgItemText(IDC_EDIT1,lpszDestination);
	this->SetDlgItemText(IDC_EDIT3,lpszPath);
	
	CComboBox * p_ComboBox;
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO2);
	p_ComboBox->SetCurSel(criticality);
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO1);
	p_ComboBox->SetCurSel(categorymap);

	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT4);
	m_edit->SetLimitText(5);

	m_edit = (CEdit*)GetDlgItem(IDC_EDIT2);
	m_edit->SetLimitText(1);

	if(!MyGetProfileString("Config","Delimiter",lpszDelimiter,2))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		strncpy(lpszDelimiter,"	",sizeof(lpszDelimiter));
	}
	this->SetDlgItemText(IDC_EDIT2,lpszDelimiter);

	dwPort=MyGetProfileDWORD("Network","Port",6161);
	
	char szPort[10];
	
	_snprintf(szPort,6,"%d",dwPort);
	this->SetDlgItemText(IDC_EDIT4,szPort);

	CButton * m_radio1;
	CButton * m_radio2;
	CButton * m_radio3;
	CButton * m_radio4;
	CButton * m_radio5;

	m_radio1 = (CButton*)GetDlgItem(IDC_RADIO1);
	m_radio2 = (CButton*)GetDlgItem(IDC_RADIO2);
	m_radio3 = (CButton*)GetDlgItem(IDC_RADIO3);
	m_radio4 = (CButton*)GetDlgItem(IDC_RADIO4);
	m_radio5 = (CButton*)GetDlgItem(IDC_RADIO5);

	if(lpszDelimiter[0] == '	') {
		m_radio1->SetCheck(1);
		m_radio2->SetCheck(0);
		m_radio3->SetCheck(0);
	} else if(lpszDelimiter[0] == ',') {
		m_radio1->SetCheck(0);
		m_radio2->SetCheck(1);
		m_radio3->SetCheck(0);
	} else {
		m_radio1->SetCheck(0);
		m_radio2->SetCheck(0);
		m_radio3->SetCheck(1);

		CEdit * m_edit;
		m_edit = (CEdit*)GetDlgItem(IDC_EDIT2);
		m_edit->EnableWindow(1);
	}

	if(dwSyslogEnabled) {
		m_radio4->SetCheck(1);
		m_radio5->SetCheck(0);

		CEdit * m_edit;
		m_edit = (CEdit*)GetDlgItem(IDC_EDIT4);
		m_edit->EnableWindow(0);
	} else {
		m_radio4->SetCheck(0);
		m_radio5->SetCheck(1);

		CEdit * m_edit;
		m_edit = (CEdit*)GetDlgItem(IDC_EDIT4);
		m_edit->EnableWindow(1);
	}


	if(!dwSyslogEnabled) {
		p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO2);
		p_ComboBox->EnableWindow(0);
		p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO1);
		p_ComboBox->EnableWindow(0);
	}


	// CG: The following block was added by the ToolTips component.
	{
		// Create the ToolTip control.
		m_tooltip.Create(this);
		m_tooltip.Activate(TRUE);

		// TODO: Use one of the following forms to add controls:
		// m_tooltip.AddTool(GetDlgItem(IDC_<name>), <string-table-id>);
		m_tooltip.AddTool(GetDlgItem(IDC_EDIT1), "Target Host: Server to receive syslog entries. Target Host may be a DNS name or IP address.");
		m_tooltip.AddTool(GetDlgItem(IDC_EDIT3), "ISA Log Path: Path to the ISA Logs. Should be terminated with a \\ character.");
		m_tooltip.AddTool(GetDlgItem(IDC_COMBO1), "Syslog Category: What category to send SYSLOG alerts to.");
		m_tooltip.AddTool(GetDlgItem(IDC_COMBO2), "Syslog Category: What criticality SYSLOG alerts should be sent as.");
		m_tooltip.AddTool(GetDlgItem(IDC_RADIO1), "Note: Any TABS that already exist in an event log will be replaced by spaces.");
		m_tooltip.AddTool(GetDlgItem(IDC_RADIO2), "Note: Any COMMAS that already exist in an event log will be replaced by spaces.");
		m_tooltip.AddTool(GetDlgItem(IDC_RADIO3), "Note: Any Delimiters that already exist in an event log will be replaced by spaces.");
		m_tooltip.AddTool(GetDlgItem(IDC_RADIO4), "Send data to a SysLog Server.");
		m_tooltip.AddTool(GetDlgItem(IDC_RADIO5), "Send data to a Custom UDP Port");
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSnareISAGUIDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDialog::OnSysCommand(nID, lParam);
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSnareISAGUIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSnareISAGUIDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSnareISAGUIDlg::OnOK() 
{
	// TODO: Add extra validation here
	// Save off the entries back into the registry.
	UINT criticality=0;
	UINT category=0;
	DWORD dwSyslog=0;
	DWORD dwPort=6161;
	DWORD dwSyslogEnabled=0;

	this->UpdateData(TRUE);

	CComboBox * p_ComboBox;
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO2);
	criticality=p_ComboBox->GetCurSel();
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO1);
	category=p_ComboBox->GetCurSel();
	if(category>11) category+=4;

	// First 3 bits = criticality (eg: emerg, alert, etc.)
	// Rest = category.
	dwSyslog =(DWORD) (category << 3);
	dwSyslog = dwSyslog | (DWORD)criticality;

	dwPort=atoi(m_Port);

	CButton * m_radio4;
	m_radio4 = (CButton*)GetDlgItem(IDC_RADIO4);
	if(m_radio4->GetState() & 0x0003) {
		dwSyslogEnabled=1;
	}

	MyWriteProfileString("Network","Destination",(LPCTSTR)m_host);
	MyWriteProfileDWORD("Network","Syslog",dwSyslogEnabled);
	MyWriteProfileDWORD("Network","SyslogDest",dwSyslog);
	MyWriteProfileString("Config","LogPath",(LPCTSTR)m_path);
	MyWriteProfileString("Config","Delimiter",(LPCTSTR)m_Delim);
	MyWriteProfileDWORD("Network","Port",dwPort);

	CDialog::OnOK();
}


BOOL CSnareISAGUIDlg::MyWriteProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nValue)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return FALSE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_DWORD,
		(LPBYTE)&nValue, sizeof(nValue));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

DWORD CSnareISAGUIDlg::MyGetProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nDefault)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, (LPTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)&dwValue, &dwCount);
	RegCloseKey(hSecKey);
	if (lResult == ERROR_SUCCESS)
	{
		return dwValue;
	}
	return nDefault;
}

BOOL CSnareISAGUIDlg::MyWriteProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return FALSE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_SZ,
		(unsigned char *)lpszString, (strlen(lpszString)+1) * sizeof(LPCTSTR));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

BOOL CSnareISAGUIDlg::MyGetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString, DWORD dwStringBuffer)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return FALSE;
	DWORD dwSize = sizeof(LPCTSTR) * dwStringBuffer;
	DWORD dwType;
	LONG lResult = RegQueryValueEx(hSecKey, (LPCTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)lpszString, &dwSize);
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

HKEY CSnareISAGUIDlg::MyGetSectionKey(LPCTSTR lpszSection)
{
	//	ASSERT(lpszSection != NULL);
	
	HKEY hSectionKey = NULL;
	HKEY hAppKey = MyGetServiceRegistryKey();
	if (hAppKey == NULL)
		return NULL;
	
	DWORD dw;
	RegCreateKeyEx(hAppKey, lpszSection, 0, REG_NONE,
		REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
		&hSectionKey, &dw);
	RegCloseKey(hAppKey);
	return hSectionKey;
}

HKEY CSnareISAGUIDlg::MyGetServiceRegistryKey()
{
	// Have no idea what company name. This will do for the moment.
	char m_sServiceName[256]="InterSect Alliance";
	
	HKEY hServicesKey = NULL;
	HKEY hParametersKey = NULL;
	HKEY hAppKey = NULL;
	
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE", 0, KEY_WRITE|KEY_READ,
		&hServicesKey) == ERROR_SUCCESS)
	{
		DWORD dw;
		if (RegCreateKeyEx(hServicesKey, m_sServiceName, 0, REG_NONE,
			REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
			&hAppKey, &dw) == ERROR_SUCCESS)
		{
			RegCreateKeyEx(hAppKey, "ISAAuditService", 0, REG_NONE,
				REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
				&hParametersKey, &dw);
		}
	}
	if (hServicesKey != NULL)
		RegCloseKey(hServicesKey);
	if (hAppKey != NULL)
		RegCloseKey(hAppKey);
	
	return hParametersKey;
}

void CSnareISAGUIDlg::OnRadio1() 
{
	CButton * m_radio1;
	CButton * m_radio2;
	CButton * m_radio3;

	m_radio1 = (CButton*)GetDlgItem(IDC_RADIO1);
	m_radio2 = (CButton*)GetDlgItem(IDC_RADIO2);
	m_radio3 = (CButton*)GetDlgItem(IDC_RADIO3);
	m_radio1->SetCheck(1);
	m_radio2->SetCheck(0);
	m_radio3->SetCheck(0);

	this->SetDlgItemText(IDC_EDIT2,"	");
	
	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT2);
	m_edit->EnableWindow(0);
}

void CSnareISAGUIDlg::OnRadio2() 
{
	CButton * m_radio1;
	CButton * m_radio2;
	CButton * m_radio3;

	m_radio1 = (CButton*)GetDlgItem(IDC_RADIO1);
	m_radio2 = (CButton*)GetDlgItem(IDC_RADIO2);
	m_radio3 = (CButton*)GetDlgItem(IDC_RADIO3);
	m_radio1->SetCheck(0);
	m_radio2->SetCheck(1);
	m_radio3->SetCheck(0);
	this->SetDlgItemText(IDC_EDIT2,",");

	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT2);
	m_edit->EnableWindow(0);
}

void CSnareISAGUIDlg::OnRadio3() 
{
	CButton * m_radio1;
	CButton * m_radio2;
	CButton * m_radio3;

	m_radio1 = (CButton*)GetDlgItem(IDC_RADIO1);
	m_radio2 = (CButton*)GetDlgItem(IDC_RADIO2);
	m_radio3 = (CButton*)GetDlgItem(IDC_RADIO3);
	
	m_radio1->SetCheck(0);
	m_radio2->SetCheck(0);
	m_radio3->SetCheck(1);

	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT2);
	m_edit->EnableWindow(1);
}

void CSnareISAGUIDlg::OnRadio4() 
{
	CButton * m_radio4;
	CButton * m_radio5;

	m_radio4 = (CButton*)GetDlgItem(IDC_RADIO4);
	m_radio5 = (CButton*)GetDlgItem(IDC_RADIO5);
	m_radio4->SetCheck(1);
	m_radio5->SetCheck(0);

	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT4);
	m_edit->EnableWindow(0);

	CComboBox * p_ComboBox;
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO2);
	p_ComboBox->EnableWindow(1);
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO1);
	p_ComboBox->EnableWindow(1);
}

void CSnareISAGUIDlg::OnRadio5() 
{
	CButton * m_radio4;
	CButton * m_radio5;

	m_radio4 = (CButton*)GetDlgItem(IDC_RADIO4);
	m_radio5 = (CButton*)GetDlgItem(IDC_RADIO5);
	m_radio4->SetCheck(0);
	m_radio5->SetCheck(1);

	CEdit * m_edit;
	m_edit = (CEdit*)GetDlgItem(IDC_EDIT4);
	m_edit->EnableWindow(1);

	CComboBox * p_ComboBox;
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO2);
	p_ComboBox->EnableWindow(0);
	p_ComboBox = (CComboBox *) this->GetDlgItem(IDC_COMBO1);
	p_ComboBox->EnableWindow(0);
}


BOOL CSnareISAGUIDlg::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following block was added by the ToolTips component.
	{
		// Let the ToolTip process this message.
		m_tooltip.RelayEvent(pMsg);
	}
	return CDialog::PreTranslateMessage(pMsg);	// CG: This was added by the ToolTips component.
}
