#ifndef _WEBPAGES_H_
#define _WEBPAGES_H_ 1

#define SIZE_OF_RESTRICTIP               20
#define SIZE_OF_PASSWORD                 20
#define SIZE_OF_EVENTIDMATCH     256
#define SIZE_OF_USERMATCH                256
#define SIZE_OF_GENERALMATCH     512
#define SIZE_OF_EVENTLOG                 35
#define SIZE_OF_CRITICALITY              12
#define SIZE_OF_AN_OBJECTIVE     1056
#define SIZE_OF_CLIENTNAME               100
#define SIZE_OF_DESTINATION              100
#define SIZE_OF_USER_MATCH_TYPE  10
#define WEB_READ_CONFIG_ERROR_CODE              510000
#define WEB_READ_NETWORK_ERROR_CODE             530000
#define WEB_READ_REMOTE_ERROR_CODE              580000
#define WEB_READ_OBJECTIVE_ERROR_CODE   610000
#define WEB_WRITE_CONFIG_ERROR_CODE             660000
#define WEB_WRITE_NETWORK_ERROR_CODE    720000
#define WEB_WRITE_REMOTE_ERROR_CODE             770000
#define WEB_WRITE_OBJECTIVE_ERROR_CODE  850000
#define WEB_RESTART_SERVICE_ERROR_CODE  890000

#define SIZE_OF_RESTRICTIP               20
#define SIZE_OF_PASSWORD                 20
#define SIZE_OF_EVENTIDMATCH     256
#define SIZE_OF_USERMATCH                256
#define SIZE_OF_GENERALMATCH     512
#define SIZE_OF_EVENTLOG                 35
#define SIZE_OF_CRITICALITY              12
#define SIZE_OF_AN_OBJECTIVE     1056
#define SIZE_OF_CLIENTNAME               100
#define SIZE_OF_DESTINATION              100

#define CRITICAL_TOKEN "Critical"
#define PRIORITY_TOKEN "Priority"
#define WARNING_TOKEN "Warning"
#define INFORMATION_TOKEN "Information"
#define CLEAR_TOKEN "Clear"

#define SUCCESS_TOKEN "Success"
#define FAILURE_TOKEN "Failure"
#define ALL_TOKEN ".*"

#define LOGON_LOGOFF_EVENTS "sat_ae_identity"
#define FILE_READ_EVENTS "sat_open_ro,sat_access_denied,sat_access_failed"
#define FILE_WRITE_EVENTS "sat_open"
#define PROCESS_EVENTS "sat_exec,sat_exit"
#define FILE_ATTRIB_EVENTS "sat_file_attr_write"
#define ADMIN_EVENTS "sat_chroot,sat_mount,sat_clock_set,sat_hostname_set,sat_domainname_set,sat_hostid_set,sat_control,sat_bsdipc_snoop_ok,sat_bsdipc_snoop_fail,sat_ae_audit,sat_ae_mount"


#define LOGONOFF_TOKEN "Logon_Logoff"
#define FILE_READ_TOKEN "File_Read"
#define FILE_WRITE_TOKEN "File_Write"
#define FILE_ATTRIB_TOKEN "File_Attrib"
#define PROCESS_TOKEN "Process_Events"
#define ADMIN_TOKEN "Admin_Events"
//#define USER_TOKEN "User_Events"
// #define SOCKET_TOKEN "Socket_Events"



// The following structure has been defined to cater for the 'config' registry settings
struct Reg_Config {
	char str_ClientName[SIZE_OF_CLIENTNAME];
	char str_NetworkDestination[SIZE_OF_DESTINATION];
	int dw_DestPort;
	char str_FileDestination[SIZE_OF_DESTINATION];
	int dw_stdout;
};

struct Reg_Remote {
	int dw_Allow;
	int dw_WebPort;
	int dw_Restrict;
	char str_RestrictIP[SIZE_OF_RESTRICTIP];
	int dw_Password;
	char str_Password[SIZE_OF_PASSWORD];
};

struct Reg_Objective {
	char str_critic[SIZE_OF_CRITICALITY];
	char str_event_type[SIZE_OF_EVENTLOG];
	char str_eventid_match[SIZE_OF_EVENTIDMATCH];
	char str_user_match[SIZE_OF_USERMATCH];
	char str_general_match[SIZE_OF_GENERALMATCH];
	char str_user_match_type[SIZE_OF_USER_MATCH_TYPE];
};


// int          HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size);
int HandleWebPages(char *HTTPBuffer, char *HTTPOutputBuffer, int size,
		   int http_listen_socket, int http_message_socket);
int Status_Page(char *source, char *dest, int size);
int DefaultHeader(char *source, char *dest, int size);
int DisplayTextHeader(int http_socket);

int Network_Config(char *source, char *dest, int size);
int Remote_Config(char *source, char *dest, int size);
int Remote_Set(char *source, char *dest, int size);
int Objective_Config(char *source, char *dest, int size);
int DefaultFooter(char *source, char *dest, int size);

int InterSectImage(char *source, char *dest, int size);
int Objective_Display(char *source, char *dest, int size);
// int          Restart(char *source, char *dest, int size);
int Restart(char *source, char *dest, int size, int one, int two);
int Network_Set(char *source, char *dest, int size);
int Objective_Result(char *, char *, int);

FILE *Find_First_Objective();
int Get_Next_Objective(FILE * configfile, struct Reg_Objective *objective);
int Close_Objective_File(FILE * configfile);

int ReadObjectives();
void DestroyList(void);
int debracket(char *source, char *dest, int length);
int ShowUsers(int http_socket);
int ShowGroups(int http_socket);
int ShowGroupMembers(int http_socket);


// Stuff we use from webserver.h
int base64decode(char *dest, char *src);
char *GetNextArgument(char *source, char *destvar, int varlength,
		      char *destval, int vallength);

void *Load_Config_File();
void Clear_Config_File(void *location);
int Grab_RAMConfig_Line(char *source, char *dest, int size);

int getnetwork(char *string, char *host, int length);

int Read_Config_From_File(struct Reg_Config *remote_struct);
int Read_Remote_From_File(struct Reg_Remote *remote_struct);
void * Load_Config_File(void);

FILE *Find_First_Objective(void);


int iswebfilename(char *string);
int isstdout(char *string);
int isnetwork(char *string);

#endif				// _WEBPAGES_H_
