//
// webserver.h
// Copyright (c) 1999-2004 InterSect Alliance Pty Ltd
//

#ifndef _WEBSERVER_H_
#define _WEBSERVER_H_ 1

#define MAX_HTTPBUFFER 8192

#if defined (__linux__)
	#define SALT "$1$Snare$"
#elif defined __sgi
	// IRIX
	#define SALT "Sn"
#else
	// Solaris
	#define SALT "$1"
#endif

void decodeurl(char *pEncoded);
int hex2int(char *pChars);
int InitWebServer(unsigned short, char *, char *);
int StartThread(void);
int ListenThread(void);
int HandleConnect(void);
int CloseWebServer(void);
void RequestAuth(char *HTTPOutputBuffer, int size);
int MatchAuth(char *AuthStart);
int AuthorisedSource(char *address);
char *GetNextArgument(char *source, char *destvar, int varlength,
		      char *destval, int vallength);
int base64decode(char *dest, char *src);
#endif				// _WEBSERVER_H_ 1
