#!/bin/sh
#
# Snare for Irix installation script
#
# Copyright (c) InterSect Alliance Pty Ltd, 2004
#

echo "Snare for Irix Installation Script"
echo '----------------------------------'
echo ''

if [ `whoami` != "root" ]; then
	echo "Sorry, only the root user can install Snare."
	exit
fi

# Check to see if snare is already installed.
if [ -f /usr/sbin/snarecore ]; then
	echo "Snare is already installed on this system."
	echo "Please uninstall snare using the uninstall script in"
	echo "/usr/bin/snare-uninstall.sh"
	exit 1
fi

if [ ! -f Install.tar ]; then
	echo "Cannot find the installation file 'Install.tar' in the"
	echo "current directory. Cannot continue."
	exit 1
fi

AUDITON=""
if [ -f /etc/config/audit ]; then
	AUDITON=`cat /etc/config/audit`
fi

if [ "$AUDITON" != "on" ]; then
	echo "The audit subsystem doed not seem to be active."
	echo "Please ensure that Irix auditing has been installed"
	echo "on this system, and retry the Snare Installation process."
	exit 1
fi


# Back up key files.
echo -n "Backing up key files..  "
if [ -f /etc/config/sat_select.options-snarebackup ]; then
	echo "A backup of sat_select.options already exists. Not overwriting."
else
	cp -f /etc/config/sat_select.options /etc/config/sat_select.options-snarebackup
fi

if [ -f /etc/config/satd.options-snarebackup ]; then
	echo "A backup of satd.options already exists. Not overwriting."
else
	cp -f /etc/config/satd.options /etc/config/satd.options-snarebackup
fi

if [ -f /etc/config/snare.conf ]; then
	# make a backup copy of snare.conf
	cp -f /etc/config/snare.conf /etc/config/snare.conf-snarebackup
fi

echo "Done."
echo ""

echo "Stopping the Irix audit service:"
/etc/init.d/audit stop

echo "Extracting Snare files to your system"
DIR=`pwd`
(cd /; tar xvf $DIR/Install.tar)

if [ -f /etc/config/snare.conf-snarebackup ]; then
	echo ""
	echo -n "Restoring your existing snare.conf file"
	cp -f /etc/config/snare.conf-snarebackup /etc/config/snare.conf
	echo "   OK"
fi

if [ -f /etc/config/snare.conf ]; then
	MAX=4
else
	MAX=3
fi

SELECTION=0

while [ $SELECTION -lt 1 -o $SELECTION -gt $MAX ]; do
 echo ""
 echo "Snare files have been installed on your system."
 echo "Snare comes with three 'default' configurations that may"
 echo "provide you with a starting point for your auditing requirements."
 echo "Please choose one:"
 echo "1) General Administrative and Login events"
 echo "2) General Administrative, Login, and process execution events"
 echo "3) General Administrative, Login, process execution"
 echo "   and file events related to system configuration files"
 if [ -f /etc/config/snare.conf ]; then
 	echo "4) Preserve your existing snare configuration"
 fi
 echo -n "Please choose one of the options above: "
 read SELECTION
done

if [ $SELECTION -eq 1 ]; then
	cp -f /etc/config/snare.conf.ADMIN /etc/config/snare.conf
fi
if [ $SELECTION -eq 2 ]; then
	cp -f /etc/config/snare.conf.PROCESS /etc/config/snare.conf
fi
if [ $SELECTION -eq 3 ]; then
	cp -f /etc/config/snare.conf.FILE /etc/config/snare.conf
fi

echo ""
echo "Restarting the Irix audit service, with Snare enabled:"
/etc/init.d/audit start

echo ""
echo "Done."
echo ""
echo "Snare is currently saving audit data to a file in /var/adm/sat/SNARE.log"
echo ""
echo "Snare has enabled a tiny web server on this system on port 6161"
echo "to enable security administrators to remotely control the audit"
echo "configuration. Recommend that you connect to `hostname` on port 6161"
echo "with a web browser, and set a password for access."
echo ""
echo "A Snare uninstall script has been installed in /usr/bin/snare-uninstall.sh"

