#!/bin/sh
#
# Snare for Irix removal script
#
# Copyright (c) InterSect Alliance Pty Ltd, 2004
#

echo "Snare for Irix Removal Script"
echo '-----------------------------'
echo ''

echo "Stopping auditing:"
if [ -f /etc/init.d/audit ]; then
	/etc/init.d/audit stop
fi

if [ -f /usr/sbin/snarecore ]; then
	echo -n "Removing the SnareCore binary  "
	rm -f /usr/sbin/snarecore
	echo "Done."
fi

if [ -f /usr/sbin/restartsnare ]; then
	echo -n "Removing the Snare restart script  "
	rm -f /usr/sbin/restartsnare
	echo "Done."
fi

if [ -f /etc/config/satd.filter-snare00 ]; then
	echo -n "Removing Snare filters..  "
	rm -f /etc/config/satd.filter-snare00
	rm -f /etc/config/satd.filter-snare01
	echo "Done."
fi

if [ -f /etc/config/satd.options-snarebackup ]; then
	echo -n "Restoring default satd.options file  "
	mv /etc/config/satd.options-snarebackup /etc/config/satd.options
	echo "Done."
fi

if [ -f /etc/config/sat_select.options-snarebackup ]; then
	echo -n "Restoring default sat_select.options file  "
	mv /etc/config/sat_select.options-snarebackup /etc/config/sat_select.options
	echo "Done."
fi

if [ -f /etc/config/snare.conf.ADMIN ]; then
	rm -f /etc/config/snare.conf.ADMIN
fi

if [ -f /etc/config/snare.conf.PROCESS ]; then
	rm -f /etc/config/snare.conf.PROCESS
fi

if [ -f /etc/config/snare.conf.FILE ]; then
	rm -f /etc/config/snare.conf.FILE
fi

echo ""
echo "Removal of Snare has been completed."
echo "Your existing /etc/config/snare.conf file has been preserved."
echo "Please remove it manually if you do not wish to reinstall snare."
echo ""
echo "You may wish to restart your audit daemon by running:"
echo "   /etc/init.d/audit start"
