#!/bin/sh
#
# Makefile installation helper

if [ "$1" == "" ]; then ACTION="-i";else ACTION=$1;fi
if [ "$2" == "" ]; then CONFDIR="/etc";else CONFDIR=$2;fi
if [ "$3" == "" ]; then BINDIR="/usr/sbin";else BINDIR=$3;fi
if [ "$4" == "" ]; then SHAREDIR="/usr/share/snarelinux";else SHAREDIR=$4;fi

if [ "$ACTION" == "-i" ]; then
	# Install
	VERSION=`/sbin/auditctl -v | /usr/bin/awk '{print $3}'`
	MAJOR=`echo $VERSION | cut -d. -f1`
	MINOR=`echo $VERSION | cut -d. -f2`
	RELEASE=`echo $VERSION | cut -d. -f3`

	VERSIONOK=0
	if [ $MAJOR -ge 1 ]; then
		if [ $MINOR -ge 2 ]; then
			if [ $RELEASE -ge 1 ]; then
				VERSIONOK=1
			fi
		fi
	fi

	if [ $VERSIONOK -ne 1 ]; then
		echo "Version 1.2.1 of the native audit daemon is required in order"
		echo "for snare to operate correctly. Please install this version"
		echo "or later."
		exit
	fi

	$CONFDIR/init.d/auditd stop

	if [ ! -f $CONFDIR/audit/auditd.conf-snarebackup ]; then
        	cp $CONFDIR/audit/auditd.conf $CONFDIR/audit/auditd.conf-snarebackup
	fi

	if [ -f /usr/sbin/semodule ]; then
		/usr/sbin/semodule -i snare.pp
	fi

	grep "^dispatcher" $CONFDIR/audit/auditd.conf
        if [ $? -eq 0 ]; then
                cat $CONFDIR/audit/auditd.conf-snarebackup | sed 's/^dispatcher.*//' | egrep -v "^$" > $CONFDIR/audit/auditd.conf
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/audit/auditd.conf;
        else
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/audit/auditd.conf;
        fi
	$CONFDIR/init.d/auditd start
	exit
fi

if [ $1 == "-u" ]; then
	# Uninstall
	$CONFDIR/init.d/auditd stop
	if [ -f $CONFDIR/audit/auditd.conf-snarebackup ]; then
                cat $CONFDIR/audit/auditd.conf-snarebackup | egrep -v "^dispatcher = .*SnareDispatcher.*" > $CONFDIR/audit/auditd.conf
		rm -f $CONFDIR/audit/auditd.conf-snarebackup
        else
                cp $CONFDIR/audit/auditd.conf $CONFDIR/audit/auditd.conf-snarebackup
                cat $CONFDIR/audit/auditd.conf-snarebackup | egrep -v "^dispatcher" > $CONFDIR/audit/auditd.conf
                rm -f $CONFDIR/audit/auditd.conf-snarebackup
        fi

	if [ -f /usr/sbin/semodule ]; then
		/usr/sbin/semodule -r snare
	fi

	$CONFDIR/init.d/auditd start
	exit
fi
