#
# rpm spec file for Snare for Linux
#
Name: SnareLinux
Summary: Snare for Linux - audit subsystem control and distribution
Version: 1.1
Release: 2
License: GPL
Group: System Environment/Daemons
Packager: Leigh Purdie
URL: http://www.intersectalliance.com/

Source0: %{name}-%{version}.tar.gz

Requires: audit >= 1.2.2, audit-libs >= 1.2.2
BuildRequires: audit-libs-devel >= 1.2.2

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
The System iNtrusion Analysis and Reporting Environment (SNARE) agent for
Linux provides a event collection, filtering, control and remote distribution
cabability for the Linux operating system. Snare supports organisations
that need to meet national security policy guidelines such as NISPOM,
DCID/DIAM, SOX/Sarbanes Oxley, GLBA, CISP and BS7799.

%prep
zcat $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz | tar -xvf -

%build
cd %{name}-%{version}
%{__make}

%install
if [ ! %{buildroot} = "/" ]; then %{__rm} -rf %{buildroot}; fi
cd %{name}-%{version}
#%{__make} DESTDIR=%{buildroot} install
mkdir -p %{buildroot}/usr/sbin  %{buildroot}/etc %{buildroot}/usr/share/%{name}-%{version} %{buildroot}/etc/audit
cp SnareDispatcher.pl %{buildroot}/usr/sbin/SnareDispatcher
cp SnareWebServer.pl %{buildroot}/usr/sbin/SnareWebServer.pl
cp SnareTranslationTable %{buildroot}/usr/sbin/SnareTranslationTable
cp snare.conf %{buildroot}/etc/snare.conf
cp snare.pp %{buildroot}/usr/share/%{name}-%{version}/
cat /etc/audit/auditd.conf | egrep -v "^dispatcher *=" > %{buildroot}/etc/audit/auditd.conf
echo "$
a
dispatcher = /usr/sbin/SnareDispatcher
.
w
q" | ed %{buildroot}/etc/audit/auditd.conf
#cat /etc/audit/audit.rules | egrep -v "^dispatcher *=" > %{buildroot}/etc/audit/audit.rules

%post
if [ -f /usr/sbin/semodule ]; then /usr/sbin/semodule -i /usr/share/%{name}-%{version}/snare.pp; fi
echo "Please modify /etc/snare.conf to turn on the web control interface"
/usr/sbin/SnareTranslationTable

%clean
if [ ! %{buildroot} = "/" ]; then %{__rm} -rf %{buildroot}; fi

%preun
/etc/init.d/auditd stop && echo "auditd stopped, restoring auditd.conf"

%postun
if [ -f /usr/sbin/semodule ]; then /usr/sbin/semodule -r snare; fi
echo "/SnareDispatcher
d
w" | ed /etc/audit/auditd.conf
/etc/init.d/auditd start

%files
%defattr(-,root,root)
%attr(755,root,root) /usr/sbin/SnareDispatcher
%attr(755,root,root) /usr/sbin/SnareTranslationTable
%attr(755,root,root) /usr/sbin/SnareWebServer.pl
%attr(640,root,root) /etc/snare.conf
%attr(640,root,root) /etc/audit/auditd.conf
%attr(644,root,root) /usr/share/%{name}-%{version}/snare.pp

%changelog
* Mon Jul 2 2007 David Mohr
- Fixed syslog output
- Added file output support to web interface
- Fixed "Other" objective type to allow underscores
- Fixed exclusion lists
- Changed wildcards to match zero or more characters
- Added regex option to config file
- Added better Audit version detection

* Wed Nov 29 2006 Leigh Purdie
- Initial release - InterSect Alliance - http://www.intersectalliance.com/
