#!/bin/sh
#
# Makefile installation helper

if [ "$1" == "" ]; then ACTION="-i";else ACTION=$1;fi
if [ "$2" == "" ]; then CONFDIR="/etc";else CONFDIR=$2;fi
if [ "$3" == "" ]; then BINDIR="/usr/sbin";else BINDIR=$3;fi
if [ "$4" == "" ]; then SHAREDIR="/usr/share/snarelinux";else SHAREDIR=$4;fi

if [ "$ACTION" == "-i" ]; then
	# Install
	VERSION=`/sbin/auditctl -v | /usr/bin/awk '{print $3}'`
	MAJOR=`echo $VERSION | cut -d. -f1`
	MINOR=`echo $VERSION | cut -d. -f2`
	RELEASE=`echo $VERSION | cut -d. -f3`

	VERSIONOK=0
	if [ $MAJOR -ge 1 ]; then
		if [ $MINOR -ge 0 ]; then
			if [ $RELEASE -ge 15 ]; then
				VERSIONOK=1
			fi
		fi
	fi

	if [ $VERSIONOK -ne 1 ]; then
		echo "Version 1.0.15 of the native audit daemon is required in order"
		echo "for snare to operate correctly. Please install this version"
		echo "or later."
		exit
	fi

	$CONFDIR/init.d/auditd stop

	if [ ! -f $CONFDIR/auditd.conf-snarebackup ]; then
        	cp $CONFDIR/auditd.conf $CONFDIR/auditd.conf-snarebackup
	fi

	if [ -f /usr/sbin/semodule ]; then
		/usr/sbin/semodule -i snare.pp
	fi

	grep "^dispatcher" $CONFDIR/auditd.conf
        if [ $? -eq 0 ]; then
                cat $CONFDIR/auditd.conf-snarebackup | sed 's/^dispatcher.*//' | egrep -v "^$" > $CONFDIR/auditd.conf
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/auditd.conf;
        else
                echo "dispatcher = $BINDIR/SnareDispatcher" >> $CONFDIR/auditd.conf;
        fi
	$CONFDIR/init.d/auditd start
	exit
fi

if [ $1 == "-u" ]; then
	# Uninstall
	$CONFDIR/init.d/auditd stop
	if [ -f $CONFDIR/auditd.conf-snarebackup ]; then
                cat $CONFDIR/auditd.conf-snarebackup | egrep -v "^dispatcher = .*SnareDispatcher.*" > $CONFDIR/auditd.conf
		rm -f $CONFDIR/auditd.conf-snarebackup
        else
                cp $CONFDIR/auditd.conf $CONFDIR/auditd.conf-snarebackup
                cat $CONFDIR/auditd.conf-snarebackup | egrep -v "^dispatcher" > $CONFDIR/auditd.conf
                rm -f $CONFDIR/auditd.conf-snarebackup
        fi

	if [ -f /usr/sbin/semodule ]; then
		/usr/sbin/semodule -r snare
	fi

	$CONFDIR/init.d/auditd start
	exit
fi
