#!/bin/sh
#
# Makefile installation helper

if [ "$1" == "" ]; then ACTION="-i";else ACTION=$1;fi
if [ "$2" == "" ]; then CONFDIR="/etc";else CONFDIR=$2;fi
if [ "$3" == "" ]; then BINDIR="/usr/sbin";else BINDIR=$3;fi
if [ "$4" == "" ]; then SHAREDIR="/usr/share/snarelinux";else SHAREDIR=$4;fi

#Find out where auditd.conf resides
if [ -f $CONFDIR/audit/auditd.conf ]; then
	AUDITCONF="audit/auditd.conf"
	AUDITRULES="audit/audit.rules"
else
	AUDITCONF="auditd.conf"
	AUDITRULES="audit.rules"
fi

if [ "$ACTION" == "-i" ]; then
	# Install
	VERSION=`/sbin/auditctl -v | /usr/bin/awk '{print $3}'`
	MAJOR=`echo $VERSION | cut -d. -f1`
	MINOR=`echo $VERSION | cut -d. -f2`
	RELEASE=`echo $VERSION | cut -d. -f3`

	VERSIONOK=0
	if [ $MAJOR -gt 1 ]; then
		VERSIONOK=1
	elif [ $MAJOR -eq 1 ]; then
		if [ $MINOR -gt 0 ]; then
			VERSIONOK=1
		elif [ $MINOR -eq 0 ]; then
			if [ $RELEASE -ge 15 ]; then
				VERSIONOK=1
			fi
		fi
	fi

	if [ $VERSIONOK -ne 1 ]; then
		echo "Version 1.0.15 of the native audit daemon is required in order"
		echo "for snare to operate correctly. Please install this version"
		echo "or later."
		exit
	fi

	$CONFDIR/init.d/auditd stop

	if [ ! -f $CONFDIR/$AUDITCONF-snarebackup ]; then
        	cp $CONFDIR/$AUDITCONF $CONFDIR/$AUDITCONF-snarebackup
	fi
	if [ ! -f $CONFDIR/$AUDITRULES-snarebackup ]; then
        	cp $CONFDIR/$AUDITRULES $CONFDIR/$AUDITRULES-snarebackup
	fi
 
	if [ -f /usr/sbin/semodule ] && [ -f snare.pp ]; then
		/usr/sbin/semodule -i snare.pp
	fi

	echo "# SnareDispatchHelper added" > $CONFDIR/$AUDITCONF
	cat $CONFDIR/$AUDITCONF-snarebackup | sed 's/^dispatcher.*//' | sed 's/^log_format =.*/log_format = NOLOG/' | egrep -v "^$" >> $CONFDIR/$AUDITCONF
	echo "dispatcher = $BINDIR/SnareDispatchHelper" >> $CONFDIR/$AUDITCONF
	cat $CONFDIR/$AUDITRULES-snarebackup | sed 's/^-D.*//' | egrep -v "^$" > $CONFDIR/$AUDITRULES

	$CONFDIR/init.d/auditd start
	exit
fi

if [ $1 == "-u" ]; then
	# Uninstall
	UNINST=`rpm -q SnareLinux | wc -l`
	if [ $UNINST -le 1 ]; then
		$CONFDIR/init.d/auditd stop
		if [ -f $CONFDIR/$AUDITCONF-snarebackup ]; then
			cat $CONFDIR/$AUDITCONF-snarebackup | sed 's/^log_format =.*/log_format = RAW/' | egrep -v "^dispatcher = .*SnareDispatch.*" > $CONFDIR/$AUDITCONF
			rm -f $CONFDIR/$AUDITCONF-snarebackup
		else
			cp $CONFDIR/$AUDITCONF $CONFDIR/$AUDITCONF-snarebackup
			cat $CONFDIR/$AUDITCONF-snarebackup | sed 's/^log_format =.*/log_format = RAW/' | egrep -v "^dispatcher" > $CONFDIR/$AUDITCONF
			rm -f $CONFDIR/$AUDITCONF-snarebackup
		fi

		if [ -f /usr/sbin/semodule ]; then
			/usr/sbin/semodule -l | egrep "^snare" > /dev/null
			if [ "$?" -eq 0 ]; then
				/usr/sbin/semodule -r snare;
			fi
		fi

		$CONFDIR/init.d/auditd start
	fi
	exit
fi
