#
# rpm spec file for Snare for Linux
#
Name: SnareLinux
Summary: Snare for Linux - audit subsystem control and distribution
Version: 1.3
Release: 1
License: GPL
Group: System Environment/Daemons
Packager: Leigh Purdie
URL: http://www.intersectalliance.com/

Source0: %{name}-%{version}.tar.gz

Requires: audit >= 1.0.15, audit-libs >= 1.0.15
BuildRequires: audit-libs-devel >= 1.0.15

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
The System iNtrusion Analysis and Reporting Environment (SNARE) agent for
Linux provides a event collection, filtering, control and remote distribution
cabability for the Linux operating system. Snare supports organisations
that need to meet national security policy guidelines such as NISPOM,
DCID/DIAM, SOX/Sarbanes Oxley, GLBA, CISP and BS7799.

%prep
zcat $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz | tar -xvf -

%build
cd %{name}-%{version}
%{__make}

%install
if [ ! %{buildroot} = "/" ]; then %{__rm} -rf %{buildroot}; fi
cd %{name}-%{version}
#%{__make} DESTDIR=%{buildroot} install
mkdir -p %{buildroot}/usr/sbin  %{buildroot}/etc %{buildroot}/usr/share/%{name}-%{version} %{buildroot}/etc/audit
cp Installer.sh %{buildroot}/usr/sbin/SnareInstaller.sh
cp SnareDispatcher.pl %{buildroot}/usr/sbin/SnareDispatcher
cp SnareDispatchHelper %{buildroot}/usr/sbin/SnareDispatchHelper
cp SnareWebServer.pl %{buildroot}/usr/sbin/SnareWebServer.pl
cp SnareTranslationTable %{buildroot}/usr/sbin/SnareTranslationTable
cp snare.conf %{buildroot}/etc/snare.conf
cp snare.pp %{buildroot}/usr/share/%{name}-%{version}/

%post
if [ -f /usr/sbin/semodule ]; then /usr/sbin/semodule -i /usr/share/%{name}-%{version}/snare.pp; fi
#/usr/sbin/SnareInstaller.sh -i %{buildroot}/etc %{buildroot}/usr/sbin %{buildroot}/usr/share/%{name}-%{version}
/usr/sbin/SnareInstaller.sh -i /etc /usr/sbin /usr/share/%{name}-%{version}
echo "Please modify /etc/snare.conf to turn on the web control interface"
/usr/sbin/SnareTranslationTable

%clean
if [ ! %{buildroot} = "/" ]; then %{__rm} -rf %{buildroot}; fi

%preun
# only if this is not an upgrade
if [ $1 -eq 0 ]; then
	#/etc/init.d/auditd stop && echo "auditd stopped, restoring auditd.conf"
	#/usr/sbin/SnareInstaller.sh -u %{buildroot}/etc %{buildroot}/usr/sbin %{buildroot}/usr/share/%{name}-%{version}
	/usr/sbin/SnareInstaller.sh -u /etc /usr/sbin /usr/share/%{name}-%{version}
fi

%postun
# only if this is not an upgrade
if [ $1 -eq 0 ]; then
	if [ -f /usr/sbin/semodule ]; then
		/usr/sbin/semodule -l | egrep "^snare" > /dev/null
		if [ "$?" -eq 0 ]; then
			/usr/sbin/semodule -r snare;
		fi
	fi
fi
#/etc/init.d/auditd start

%files
%defattr(-,root,root)
%attr(755,root,root) /usr/sbin/SnareDispatcher
%attr(755,root,root) /usr/sbin/SnareDispatchHelper
%attr(755,root,root) /usr/sbin/SnareTranslationTable
%attr(755,root,root) /usr/sbin/SnareWebServer.pl
%attr(755,root,root) /usr/sbin/SnareInstaller.sh
%attr(640,root,root) /etc/snare.conf
%attr(644,root,root) /usr/share/%{name}-%{version}/snare.pp
%config(noreplace) /etc/snare.conf

%changelog
* Mon Dec 3 2007 David Mohr
- Added support for login/logout events
- Added support for account modification events
- Improved resource handling and collection speed (SnareDispatchHelper)

* Mon Aug 7 2007 David Mohr
- Added support for compound matching elements (e.g. name=/etc/* name!=/etc/blah/*)
- Improved authentication support for remote control interface
- Updated SELinux policy (RHEL5 support)
- Improved automatic audit configuration using objective returncode detection to pre filter unnecessary records
- Fixed element matching error
- Fixed error in criticality reporting (e.g. criticality was always zero)
- Fixed race condition that could potentially clear all audit rules on restart
- Improved effeciency allowing a higher throughput
- Improved installer for easier deployment

* Mon Jul 2 2007 David Mohr
- Fixed syslog output
- Added file output support to web interface
- Fixed "Other" objective type to allow underscores
- Fixed exclusion lists
- Changed wildcards to match zero or more characters
- Added regex option to config file
- Added better Audit version detection
- DNS timeout for restricted access hosts

* Wed Nov 29 2006 Leigh Purdie
- Initial release - InterSect Alliance - http://www.intersectalliance.com/
