// SNARE for Lotus Notes
// Copyright 2001-2005 InterSect Alliance Pty Ltd
// http://www.intersectalliance.com/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// See Readme.txt file for more information.
//
//
// NOTE: SNARE now includes two new fields - criticality and event category.
//

#include <stdio.h>
#include <stdlib.h>
#include <winsock2.h>
#include <windows.h>
#include <time.h>
#include <tchar.h>
#include <sys/stat.h>

#include "NTServApp.h"
#include "SnareNotes.h"
#include "webserver.h"


// DOMINO AND NOTES INCLUDE FILES
#include <global.h>
#include <osmisc.h>
#include <nsfdb.h>

#include <lapicinc.h>
#include <nsfnote.h>
#include <nsfsearc.h>
#include <textlist.h>

#include <stdnames.h>

#include <log.h>

// Testing only
//#define DEBUG_TO_FILE 1

// Quick function proto
void				DebugMsg(const char* pszFormat, ...);
STATUS LNPUBLIC		ReadNotesData (VOID far *,SEARCH_MATCH far *,ITEM_TABLE far *);
STATUS  LNPUBLIC	DumpItem( WORD, WORD, char far *, WORD, void far *, DWORD, void far * );

STATUS LNCALLBACK ActionRoutine(const char *DescName,
								DWORD DescIdx,
								DWORD Flags,
								WORD  PrimaryKey,
								const TIMEDATE* TimeStamp,
								void *pActivityRecord,
								void *pUserData);

// Pull this from registry
DWORD			WEBSERVER_ACTIVE = 0;

DWORD			g_dwLastError = 0L;
char			Hostname[100];
ThreadStruct	g_Info;
SOCKET			g_hSocket = INVALID_SOCKET;      // global client/server socket
DWORD			dwSyslog=13;					// global syslog destination
int				nStopListening=0;
TCHAR			DELIM[2]="	";	// TAB

int				SNAREDEBUG=0;

static Node *head, *currentnode;
static long CurrentNoteID;			// The note we are currently operating on
static BOOL FirstRun=1;				// Ugly global, but needed.

DBHANDLE    db_handle;    // handle of source database

CSnareNotesService::CSnareNotesService()
:CNTService("SNARENotes")
{
	// Initialize class members here
}

BOOL CSnareNotesService::OnInit()
{
	char szError[MAX_STRING];
	int nError;

	SNAREDEBUG=this->DEBUGSET;

	if( !InitWinsock( szError ) )
	{
		DebugMsg(szError);
		return FALSE;
	}

	m_hEventList[0] = CreateEvent(NULL, TRUE, FALSE, NULL);
	
	// Web server
	m_hEventList[1] = CreateEvent(NULL, TRUE, FALSE, NULL);
	
	if(m_hEventList[0] == NULL)
	{	DebugMsg("CreateEvent() 0 failed");	return FALSE;	}

	if(m_hEventList[1] == NULL)
	{	DebugMsg("CreateEvent() Web Server failed");	return FALSE;	}


    // Init the Domino and Notes runtime system.
    // nError = NotesInitExtended(__argc, __argv);
	// nError = NotesInitExtended(0, NULL);
	
	nError=NotesInit();

   // If the call to NotesInit fails, display an error message
   // and exit the program.

   if (nError != NOERROR) {
       DebugMsg("Unable to Initialize Notes!");
       return (FALSE);
   }

	DebugMsg("SNARE Initialisation complete");
	DebugMsg("NOTES API Routines have disabled CTRL-C, sorry.\n  Terminate via the task manager");
	// return FALSE here if initialization failed & the service shouldn't start
	
	return(TRUE);
}

void CSnareNotesService::Run()
{
	DWORD dwEventLogRecords = 0, dwOldestEventLogRecord = 0, dwNewestEventLogRecord = 0,
		dwEvLogStart = 0, dwEvLogCounter = 0, dwNumberOfBytesToRead = 0, 
		dwBytesRead = 0, dwMinNumberOfBytesNeeded = 0, dwCancel = 0, dwClose = 0;

	DWORD ClearTabs=0;
	DWORD dwSyslogHeader=0; // Send the Syslog header?
	DWORD dwPortNumber=80;
	DWORD dwRestrictIP=0;
	DWORD dwUsePassword=0;

	DWORD dwCatchUpCount=0;

	long Category=0;

  	TCHAR szError[MAX_STRING];
	TCHAR SubmitTime[26]="None Yet";

	TCHAR lpszIPAddress[16];
	TCHAR lpszPassword[256];

	short nEventCount=2; // including the web server event

	// Destination for log events. Default it to something safe.
	TCHAR lpszDestination[512]="localhost";

	PEVENTLOGRECORD pELR = 0;
	PSID UserSID = 0;
	unsigned long EventID=0;
	
	BOOL bRetVal = FALSE;
	BOOL fExit = FALSE;
	UINT uStep = 0, uStepAt = 0, uPos = 0, uOffset = 0;

	//int nRet;
	
	DWORD dwWaitRes=0;
	DWORD Offset=0;
	DWORD dwDestPort=6161;
	
    STATUS      nError = NOERROR;   // return status from API calls

	DebugMsg("SNARE for Lotus Notes is Running");

	// Grab the fully qualified hostname
	// Note: if the user has explicitly set a hostname in the registry, use that instead.

	Hostname[0]='\0';
	MyGetProfileString("Config","Clientname",Hostname,100);
	if(Hostname[0]=='\0') {
		GetFQDN(Hostname,sizeof(Hostname));
	}
	

	// Where should we be sending this stuff (syslog ID)
	dwDestPort=MyGetProfileDWORD("Network","DestPort",6161);
	dwSyslog=MyGetProfileDWORD("Network","SyslogDest",13);
	dwSyslogHeader=MyGetProfileDWORD("Network","Syslog",0);
	if(!dwSyslogHeader) {
			dwSyslog=-1;
	} else {
		// Send to syslog
		dwDestPort=514;
	}

	WEBSERVER_ACTIVE=MyGetProfileDWORD("Remote","Allow",0);
	dwPortNumber=MyGetProfileDWORD("Remote","WebPort",6161);

	strcpy(lpszDestination,"localhost");
	if(!MyGetProfileString("Network","Destination",lpszDestination,512))
	{
		// Problem. Couldn't retrieve the destination from the registry.
		// Default it to something harmless.
		MyWriteProfileString("Network","Destination",lpszDestination);
	}


	DELIM[0]=9;	// TAB character
	DELIM[1]='\0';
	// Only allow a different character for delimiters if we're sending data via syslog.
	if(dwSyslogHeader) {
		MyGetProfileString("Config","Delimiter",DELIM,2);
	}


	// Need to MD5 this.
	strcpy(lpszPassword,"");
	dwUsePassword=MyGetProfileDWORD("Remote","AccessKey",0);
	if(dwUsePassword) {
		if(!MyGetProfileString("Remote","AccessKeySet",lpszPassword,256))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strcpy(lpszPassword,"");
		}
	}

	strcpy(lpszIPAddress,"");
	dwRestrictIP=MyGetProfileDWORD("Remote","Restrict",0);

	if(dwRestrictIP) {
		if(!MyGetProfileString("Remote","RestrictIP",lpszIPAddress,16))
		{
			// Problem. Couldn't retrieve the destination from the registry.
			// Default it to something harmless.
			strcpy(lpszIPAddress,"127.0.0.1");
		}
	}

	// Open the socket (UDP) to the indicated port
	g_hSocket = ConnectToServer( lpszDestination, (UINT)dwDestPort, szError );

	if( g_hSocket == INVALID_SOCKET )
	{
		DebugMsg(szError);
		return;
	}

	if(SNAREDEBUG) { DebugMsg("Opening event log sources"); }
	
	if(WEBSERVER_ACTIVE) {
		if(SNAREDEBUG) { DebugMsg("Starting web thread."); }
		if(InitWebServer((unsigned short)dwPortNumber,lpszPassword,lpszIPAddress) >0) {
			StartThread(m_hEventList[1]);
		} else {
			WEBSERVER_ACTIVE = 0;
		}
	}

	// Set the terminate flag to zero.
	// setting this value to TRUE will terminate the service,
	// and ask it to save it's current status.
	g_Info.bTerminate = FALSE;

    nError = NSFDbOpen ("log.nsf", &db_handle);
	if (nError)
	{
		printf ("Error: unable to open log.nsf");
		return;
	}

	if(SNAREDEBUG) { DebugMsg("Entering main loop."); }
	
	// int tcount=0;
	
	// This is the service's main run loop.
    while (m_bIsRunning) 
	{
		// If we have been asked to terminate, do so.
		if(g_Info.bTerminate)
		{
			m_bIsRunning=0;
			break;
		}	
		

		// if(SNAREDEBUG) { DebugMsg("Waiting.."); }

		// The service performs one check per 10 seconds. This should not be
		// a significant drain on resources.
		dwWaitRes=WaitForMultipleObjects(nEventCount,m_hEventList,FALSE,10000);

		if(dwWaitRes != WAIT_FAILED && dwWaitRes != WAIT_TIMEOUT)
		{
			UINT EventTriggered=0;

			// This first event does nothing yet.
			if(dwWaitRes == WAIT_OBJECT_0) {
				EventTriggered=0;
				ResetEvent(m_hEventList[0]);
			} else if (dwWaitRes == WAIT_OBJECT_0+1) {
				// Web server has data to read.
				ResetEvent(m_hEventList[1]);
				if(SNAREDEBUG) { DebugMsg("WEB Server Connect."); }

				if(WEBSERVER_ACTIVE) {
					HandleConnect();

					if(SNAREDEBUG) { DebugMsg("Running thread again."); }
					StartThread(m_hEventList[1]);
				}
				
				continue;
			} else {
				DebugMsg("Warning: An event occured that I am not programmed to deal with. Continuing\n");
				continue;
			}

		}

		// Call NSFSearch to find all data notes in the database.
		//if(SNAREDEBUG) { DebugMsg("DEBUG: About to READDATA\n\n\n"); }


	    if (nError = NSFSearch (
			db_handle,          // database handle
			NULLHANDLE,         // selection formula
			NULL,               // title of view in selection formula
			0,					// search flags: get summary data!
			NOTE_CLASS_DOCUMENT, // note class to find (NOTE: NOTE_CLASS_DOCUMENT is the new name for NOTE_CLASS_DATA.
			NULL,               // starting date (unused)
			ReadNotesData,		// action routine for notes found
			NULL,               // argument to action routine
			NULL))              // returned ending date (unused)
		{
			if(SNAREDEBUG) { DebugMsg("Error: unable to search database."); }
			m_bIsRunning=0;
			break;
		}
		
		FirstRun=0;


    }

	if(SNAREDEBUG) { DebugMsg("SNARE Closing"); }

    // Close the database.
    if (nError = NSFDbClose (db_handle))
    {
        printf ("Error: unable to close log.nsf\n");
    }

	// Kill off our linked list
	DestroyList();

	// Shut down Notes
	NotesTerm();

	CloseWebServer();
	
	TerminateWinsock(g_hSocket);
	if( m_hEventList[0] ) ::CloseHandle(m_hEventList[0]);
	if( m_hEventList[1] ) ::CloseHandle(m_hEventList[1]);
}



STATUS LNPUBLIC ReadNotesData
            (VOID far *optional_param,
            SEARCH_MATCH far *search_info,
            ITEM_TABLE far *summary_info)
{
    SEARCH_MATCH  SearchMatch;
    STATUS        error;
	DWORD        OFlags = 0;
	NOTEHANDLE  hNote;

    memcpy ((char*)(&SearchMatch), (char *)search_info, sizeof(SEARCH_MATCH));
    

	//if(SNAREDEBUG) { DebugMsg("Inside ReadNotesData"); }

    if (!(SearchMatch.SERetFlags & SE_FMATCH)) {
		//if(SNAREDEBUG) { DebugMsg("No search match found"); }
        return (NOERROR);
	}

    // Print the note ID.
    //if(SNAREDEBUG) { DebugMsg("Note ID is: %#010lx (%d).", SearchMatch.ID.NoteID,SearchMatch.ID.NoteID); }

	if (error = NSFNoteOpenExt( db_handle, SearchMatch.ID.NoteID, OFlags, &hNote ))
    {
		if(SNAREDEBUG) { DebugMsg("Error: unable to open note"); }
		return (error);
    }

	// Save off the current Note ID.
	// .. hmm. what if there is more than one text item in a note?
	CurrentNoteID=SearchMatch.ID.NoteID;

	// Ok.. note open.. what to do with it now?
    // IF THIS IS A FIELD WE WANT...    
	NSFItemScan( hNote, DumpItem, NULL );

	// NOTE: Could potentially use nsfitemquery / nsfiteminfo rather than scanning through
	//       as long as we can identify the items we need..

	error = NSFNoteClose( hNote );

    if (error != NOERROR) {
		if(SNAREDEBUG) { DebugMsg("Error: unable to close note." ); }
		return(error);
	}

    return (NOERROR);
}



STATUS   LNPUBLIC   DumpItem(WORD Spare, WORD ItemFlags, char far * Name, 
                             WORD NameLength, void far * Value,
							 DWORD ValueLength,void far * Parameter)
{
	char  * pData;
    WORD    length;
    WORD    wDataType;
	WORD	startposition;
	LIST *plist;
	WORD listentries;

	char szSendString[MAX_OUTPUT_STRING]="";
	char szError[MAX_STRING];
	time_t currenttime;
	struct tm *newtime;
	char CurrentDate[16]="";

	
	Node * tnode=(Node *)NULL;

	// Note: Notes R6 seems to have changed the log.nsf format significantly - This does not seem to work.
	//
	// Fields in R6 include:
	// * StartTime
	// * Form
	// * Server
	// * Port
	// * InitiatedBy
	// * SourceServer
	// * EventList    <- This MAY have info?
	// * EventType
	// * EventSeverity
	// * EventStatus
	// * EventTime
	// * EventTimeSize
	// * EventAddinName
	// * Pathname
	// * FinishTime
	// * UpdatedBy

    pData = (char *) Value;
    length = (WORD) ValueLength; // includes the 2 byte data type

	memcpy( (char*)&wDataType, pData, sizeof(WORD) );
    pData += sizeof(WORD);
    length -= sizeof(WORD);

	// DEBUG: Testing for the moment...
	if(wDataType == TYPE_TEXT_LIST) {

		if(strncmp(Name,"EventList",NameLength) != 0) {
			// Don't care about non-eventlist data at this point in time.
			return(0);
		}

	
		//if(SNAREDEBUG) { DebugMsg("Current NOTE ID: %ld",CurrentNoteID); }

		// Excellent. We have some information!
		// Where are we up to in this note?

		plist = (LIST* ) pData;
		listentries = ListGetNumEntries(plist, FALSE);


		tnode=FindNode(CurrentNoteID);
		if(!tnode) {
			//if(SNAREDEBUG) { DebugMsg("First time through.."); }

			// First time we have seen this note! Create a new entry in the list.
			//if(SNAREDEBUG) { DebugMsg("Adding this note ID (%ld) to the linked list.",CurrentNoteID); }
						
			// If this is the first time we have gone through this process, set all notes to
			// the 'end point'. Once we've been through one iteration, we can start looking at
			// newly created notes right from the beginning.
			if(FirstRun) {	
				startposition=listentries;
			} else {
				startposition=0;
			}

			tnode=AddToList(CurrentNoteID,startposition);
			// Cool. Ignore this note for the current iteration. Check it again next time.
			return(NOERROR);			
		} else {
			// Bonus, been here before. Check to see if there is any new data.
			startposition=tnode->readpos;
			if(startposition > listentries) {
				// Oh dear, the note has been cleared/reset.
				// Jump back to position 0.
				startposition = 0;
				tnode->readpos = 0;
			} else if(startposition == listentries) {
				// No new data.
				return(NOERROR);
			}
		}

		// Ok, if we have made it here, then we must have some data to read.

		for (int i = startposition; i < listentries; i++) {
			char *ptext;
			WORD len;
			ListGetText(plist, FALSE, i, &ptext, &len);
			if(!ptext || !len) {
				continue;
			}
			if(dwSyslog!=-1) {
				// Send to Syslog

				time(&currenttime);
				newtime=localtime(&currenttime);
				syslogdate(CurrentDate,newtime);
				_snprintf(szSendString,sizeof(szSendString),"<%ld>%s %s NotesLog%s%d%s%.*s",dwSyslog,CurrentDate,Hostname,DELIM,0,DELIM,len,ptext);
			} else {
				_snprintf(szSendString,sizeof(szSendString),"%s%sNotesLog%s%d%s%.*s",Hostname,DELIM,DELIM,0,DELIM,len,ptext);
			}
			SendToSocket(g_hSocket,szSendString,strlen(szSendString),szError);
			//if(SNAREDEBUG) { DebugMsg("Sent: %s",szSendString); }
		}

		tnode->readpos=listentries;
	} else {
		return(NOERROR);

		// This stuff is for testing only:
		char timestr[MAXALPHATIMEDATE + 1];
		WORD timelen;
		char numstr[MAXALPHANUMBER + 1];
		WORD numlen;
		LIST *plist;
		WORD listentries;

	

		switch (wDataType) {
		case TYPE_TEXT:
			{
				printf(
					"\t%.*s: %.*s\n",
					NameLength,
					Name,
					ValueLength - sizeof(USHORT),
					pData);              
				break;
			}                          
		case TYPE_TIME:
			{
				ConvertTIMEDATEToText(NULL, NULL, (TIMEDATE* )pData, timestr, MAXALPHATIMEDATE, &timelen);
				printf(
					"\t%.*s: %.*s\n",
					NameLength,
					Name,
					timelen,
					timestr);                                              
				break;
			}
		case TYPE_NUMBER:
			{
				ConvertFLOATToText(NULL, NULL, (NUMBER *)pData, numstr, MAXALPHANUMBER, &numlen);
				printf(
					"\t%.*s: %.*s\n",
					NameLength,
					Name,
					numlen,
					numstr);                                              
				break;
			}
		case TYPE_TEXT_LIST:
			{
				plist = (LIST* ) pData;
				listentries = ListGetNumEntries(plist, FALSE);
				printf(
					"\t%.*s:\n\t\t{\n",
					NameLength,
					Name);
				
				for (int j = 0; j < listentries; j++)
				{
					char *ptext;
					WORD len;
					ListGetText(plist, FALSE, j, &ptext, &len);
					printf("\t\t%.*s\n", len, ptext);
				}
				printf("\t\t}\n");
	
				
				break;
			}
			
		default:
			printf("type not implemented: %*.s\n", NameLength, Name);          
		}

		// end of testing stuff.
	}

	return(NOERROR);
}


void GetFQDN(char *string, int length)
{
	struct hostent *phostent;
	
	// Now, grab fully qualified hostname here.
	// Get the normal name.
	if(gethostname(string, length)) {		
		strncpy(string,"localhost.unknown",length);
		return;
	}
	
	// Now perform a lookup on that name.
	phostent=gethostbyname(string);
	if(phostent) {
		while(phostent->h_aliases && *phostent->h_aliases) {
			if(strlen(*(phostent->h_aliases)) > strlen(string) && !strncmp(string,*(phostent->h_aliases),strlen(string))) {
				strncpy(string,*(phostent->h_aliases),length);
			}
			phostent->h_aliases++;
		}
		if(strlen(phostent->h_name) > strlen(string) && !strncmp(string,phostent->h_name,strlen(string))) {
			strncpy(string,phostent->h_name,length);
		}
	}
}



// Match a DOS wildcard against a string.
// eg: wildmatch("c:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatch(char *pattern, char *source)
{
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatch(pattern, source+1) || wildmatch(pattern+1, source) || wildmatch(pattern+1, source+1);
    case '?':
        return wildmatch(pattern+1, source+1);
    default:
        return (*pattern == *source) && wildmatch(pattern+1, source+1);
    }
}

// Match a DOS wildcard against a string.
// eg: wildmatch("C:\blah\abc???.*","c:\blah\abc123.txt");
int wildmatchi(char *pattern, char *source)
{
    if(*pattern == 0)
        return (*source == 0);

    // special case
    if(strspn(pattern, "*") == strlen(pattern))
        return 1;

    if(*source == 0)
        return 0;

    switch(*pattern){
    case '*':
        return wildmatchi(pattern, source+1) || wildmatchi(pattern+1, source) || wildmatchi(pattern+1, source+1);
    case '?':
        return wildmatchi(pattern+1, source+1);
    default:
		char lpattern,lsource;
		lpattern = tolower(*pattern);
		lsource = tolower(*source);
		
        return (lpattern == lsource) && wildmatchi(pattern+1, source+1);
    }
}



// Find the nth entry in the tab-delimited string 'search'.
// NOTE: may need to take into account the user delimiter
void splitstrings(char *store, int field, char *search, int size)
{
	int count;
	char *start=search;
	char *end=search;

	strcpy(store,"");

	for(count=1;count<=field;count++) {
		end=strstr(start,"	");
		if(!end) {
			if(count < field) {
				return;
			} else {
				strncpy(store,start,size);
				store[size]='\0';
				return;
			}
		} else {
			int nsize;

			if((end-start) > size) {
				nsize=size;
			} else {
				nsize=(end-start);
			}

			if(count == field) {
				strncpy(store,start,nsize);
				store[nsize]='\0';
				return;
			}

			start=end+1;
			end=start;
		}
	}
}


void syslogdate(char *sdate, struct tm *cdate)
{
	char Month[4];
	char Date[3];
	char Hour[3];
	char Min[3];
	char Sec[3];

	switch (cdate->tm_mon) {
		case 0: strcpy(Month,"Jan"); break;
		case 1: strcpy(Month,"Feb"); break;
		case 2: strcpy(Month,"Mar"); break;
		case 3: strcpy(Month,"Apr"); break;
		case 4: strcpy(Month,"May"); break;
		case 5: strcpy(Month,"Jun"); break;
		case 6: strcpy(Month,"Jul"); break;
		case 7: strcpy(Month,"Aug"); break;
		case 8: strcpy(Month,"Sep"); break;
		case 9: strcpy(Month,"Oct"); break;
		case 10: strcpy(Month,"Nov"); break;
		default: strcpy(Month,"Dec"); break;
	}

	if(cdate->tm_mday<10) {
		_snprintf(Date,3," %d\0",cdate->tm_mday);
	} else {
		_snprintf(Date,3,"%d\0",cdate->tm_mday);
	}

	if(cdate->tm_hour<10) {
		_snprintf(Hour,3,"0%d\0",cdate->tm_hour);
	} else {
		_snprintf(Hour,3,"%d\0",cdate->tm_hour);
	}

	if(cdate->tm_min<10) {
		_snprintf(Min,3,"0%d\0",cdate->tm_min);
	} else {
		_snprintf(Min,3,"%d\0",cdate->tm_min);
	}

	if(cdate->tm_sec<10) {
		_snprintf(Sec,3,"0%d\0",cdate->tm_sec);
	} else {
		_snprintf(Sec,3,"%d\0",cdate->tm_sec);
	}

	_snprintf(sdate,16,"%s %s %s:%s:%s\0",Month,Date,Hour,Min,Sec);
}


//////////////////////////////////////////////////////////////////
// SendToSocket
//              sends a buffer (buf) of size size to the specified socket
//              returns TRUE or FALSE.
BOOL  SendToSocket(SOCKET hSocket, char *buf, int nSize, char *szError)
{
	int   rv;
	
	// write it all
	while ((rv = send(hSocket, buf, nSize,0)) != nSize)
	{
		if (rv == -1)
		{
			sprintf(szError,"error sending to server. WSA ERROR: %d\r\n",
				WSAGetLastError());
			DebugMsg(szError);
			return FALSE;
		}
		
		if (rv == nSize)
			break;
		buf += rv;
		nSize -= rv;
	}
	return TRUE;
}


///////////////////////////////////////////////////////////////////
// InitWinsock
//              starts up winsock.dll or wsock32.dll
BOOL InitWinsock( char *szError )
{
	WSAData wsData;
	
	WORD wVersionRequested = WINSOCK_VERSION;
	
	if(WSAStartup(wVersionRequested, &wsData) != 0)
	{
		// :( error
		if( szError )
		{
			sprintf(szError,"WSAStartup failed: WSA ERROR: %d\r\n",
				WSAGetLastError());
			DebugMsg(szError);
		}
		return FALSE;
	}
	
	// all is well
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// TerminateWinsock
//      call this function with the current socket or INVALID_SOCKET
void TerminateWinsock( SOCKET hSocket )
{
	// cancel blocking calls, if any
	WSACancelBlockingCall();
	
	// close socket
	if( hSocket != INVALID_SOCKET )
		closesocket(hSocket);
	
//	g_Info.bTerminate = TRUE;
	// allow threads to terminate, if any.
//	Sleep(5000);
	
	// unload winsock
	WSACleanup();
}


//////////////////////////////////////////////////////////////
// ConnectToServer:
//    connects to a server on a specified port number
//    returns the connected socket
SOCKET ConnectToServer(char *name, UINT nPort, char *szError)
{
	SOCKET hSocket;
	struct sockaddr_in server;
	struct hostent far *hp;
	
	
	if( !name || !*name )
		return INVALID_SOCKET;

	
	// Should use something nicer to check for IP addresses...
	if( isdigit(name[0]))
	{
		ZeroMemory((char *) &server, sizeof(server));
		server.sin_family      = AF_INET;
		server.sin_addr.s_addr = inet_addr(name);
		server.sin_port        = htons(nPort);
	} else {
		if ( (hp = (struct hostent far *) gethostbyname(name)) == NULL)
		{
			_snprintf(szError,MAX_STRING,"Error: gethostbyname failed: %s.",name);
			return INVALID_SOCKET;
		}
		
		ZeroMemory((char *)&server, sizeof(server));
		CopyMemory((char *) &server.sin_addr,hp->h_addr,hp->h_length);
		server.sin_family = hp->h_addrtype;
		server.sin_port = htons(nPort);
	}
	
	// create socket
	if( (hSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET)
	{
		_snprintf(szError,MAX_STRING,"socket failed to create datagram socket: %d\n",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	// connect to server.
	if (connect(hSocket,(struct sockaddr *)&server, sizeof(server)) == SOCKET_ERROR)
	{
		_snprintf(szError,MAX_STRING,"connect failed to connect to requested address: %d",WSAGetLastError());
		return INVALID_SOCKET;
	}
	
	return hSocket;
}



// Linked List Functions
void CreateLinkedList(void)
{
    head = currentnode = NULL;
}

int IsListEmpty(void)
{
    if (NULL == head)
        return 1;
    else
        return 0;
}

Node * FindNode(long noteid)
{
	Node * cnode;

	ResetCurrentNode();
	cnode=GetCurrentItem();

	while(cnode) {
		if(cnode->noteid == noteid) {
			return(cnode);
		}
		NextItemInList();
		cnode=GetCurrentItem();
	}
	return((Node *)NULL);
}


Node * AddToList(long noteid, WORD readpos)
{
    Node *newNode=NULL;

    newNode = (Node *) malloc(sizeof(Node));

    if (newNode == NULL)
    {
        fprintf(stderr, "AddToList(): error in dynamic memory allocation\nCould not add a new objective into our linked list. You may be low on memory.\n");
        return((Node *)NULL);
    }

	// Add the note ID to the node. This is the primary key.
	newNode->noteid=noteid;
	// Set the current read position to the end of file
	newNode->readpos=readpos;
	
    if (head == NULL)
    {
        head = newNode;
        newNode->next = NULL;
    }
    else
    {
        newNode->next = head;
        head = newNode;
    }

    return newNode;
}

void RemoveFromListHead(void)
{
    Node *tempPtr;

    if (NULL == head)
        return;

    tempPtr = head;
    head = head->next;

    free(tempPtr);
}

void RemoveFromList(Node* node)
{
    Node *tempPtr, *previousPtr;

    if (NULL == node)
        return;

    if (head == node)
    {
        RemoveFromListHead();
        return;
    }

    tempPtr = head;

    while (NULL != tempPtr)
    {
        previousPtr = tempPtr;
        tempPtr = tempPtr ->next;

        if (tempPtr == node)
        {
            previousPtr->next = tempPtr->next;
            free(tempPtr);
            break;
        }
    }
}

void ResetCurrentNode(void)
{
    currentnode = head;
}

int IsValidItem(void)
{
    return (NULL == currentnode) ? 0 : 1;
}

Node * GetCurrentItem()
{
    return (currentnode);
}

void NextItemInList(void)
{
    if (NULL == currentnode)
        return;

    currentnode = currentnode->next;
}

void DestroyList(void)
{
    if (NULL == head)
    {
        return;
    }

    while (NULL != head)
    {
        Node *tempPtr = head;
        head = head->next;

        free(tempPtr);
    }
}



void CSnareNotesService::OnShutdown() {
	// Audit: Set that global variable to TRUE so that the threads
	// receive the terminate message
	g_Info.bTerminate=TRUE;
	
	if(SNAREDEBUG) { DebugMsg("SNARE Shutdown request received"); }

	// Call a fake event so that the subroutine	gets the shutdown message
	// through the setting of g_Info.bTerminate
	if(m_hEventList[0])
		::SetEvent(m_hEventList[0]);
}


// Process user control requests
BOOL CSnareNotesService::OnUserControl(DWORD dwOpcode)
{
    switch (dwOpcode) {
    case SERVICE_CONTROL_USER + 0:

        // Save the current status in the registry
        SaveStatus();
        return TRUE;

    default:
        break;
    }
    return FALSE; // say not handled
}

// Save the current status in the registry
void CSnareNotesService::SaveStatus()
{
	// add code to save the sate of the service in the registry
}


// Duplicate of the CNTService DebugMsg
void DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[50];
	char time[50];
	
	SYSTEMTIME st;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,sizeof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,sizeof(time));

	_snprintf(buf, 8192, "[SNARENotes](%lu - %s %s): ", GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf(&buf[strlen(buf)],8192-strlen(buf)-1,pszFormat,arglist);
	va_end(arglist);
    _snprintf(buf,8192,"%s\n",buf);
    OutputDebugString(buf);

// #ifdef _DEBUG
	printf(buf);
// #endif

//#ifdef DEBUG_TO_FILE
//	FILE *fp;
//	if(!strlen(pszFormat)) {
//		// Send a "" to truncate the file back to zero
//		fp=fopen("C:\\SNAREDebug.log","wt");
//	} else {
//		fp=fopen("C:\\SNAREDebug.log","a");
//	}
//	if(fp) {
//		fprintf(fp,buf);
//		fclose(fp);
//	}
//#endif
}


