/*
FILE: SnareNotes.h
*/

#include "NTService.h"
#include "support.h"
#include <ntsecapi.h>


#define MAX_EVENT 8192
#define MAX_STRING 1024
#define MAX_OUTPUT_STRING 8192
#define MAX_USERNAME	512

class CSnareNotesService : public CNTService
{
public:
	CSnareNotesService();
	virtual BOOL OnInit();
    virtual void Run();
    virtual BOOL OnUserControl(DWORD dwOpcode);
	void OnShutdown();

    void SaveStatus();

private:
	HANDLE m_hEventList[8]; // Eight elements at the moment.

	HANDLE hEventLog[6];
	HANDLE hPipe;
	HANDLE hWritePipe;		// Pipe to the Audit GUI
};

// Function Prototypes.
BOOL	InitWinsock				(char *);
int		RunServer				();
void	TerminateWinsock		(SOCKET);
SOCKET	StartServer				(UINT, char *);
BOOL	WINAPI ClientThread		(LPVOID);

void	syslogdate				(char *, struct tm *);

int		wildmatch				(char *, char *);
void	splitstrings			(char *, int, char *, int);

SOCKET	ConnectToServer			(char *, UINT, char *);

BOOL	SendToSocket			(SOCKET hSocket, char *buf, int nSize, char *szError);
void	GetFQDN					(char *string,int length);


struct _node
{
        long noteid;		// The id of the current Note
		WORD readpos;		// Current read position
        struct _node *next;
};

typedef struct _node Node;


void CreateLinkedList(void);
int IsListEmpty(void);
Node * FindNode(long noteid);
Node * AddToList(long nodeid, WORD readpos);
void RemoveFromListHead(void);
void RemoveFromList(Node* node);
void ResetCurrentNode(void);
Node * GetCurrentItem(void);
void NextItemInList(void);
void DestroyList(void);



// thread structure
typedef struct
{
	SOCKET hSocket;
	BOOL bTerminate;
} ThreadStruct;


