

#define CONFIG_KEY_NAME "SOFTWARE\\Intersect Alliance\\NotesAuditService\\Config\\"
#define NETWORK_KEY_NAME "SOFTWARE\\Intersect Alliance\\NotesAuditService\\Network\\"
#define REMOTE_KEY_NAME "SOFTWARE\\Intersect Alliance\\NotesAuditService\\Remote\\"
#define OBJECTIVE_KEY_NAME "SOFTWARE\\Intersect Alliance\\NotesAuditService\\Objective\\"

#define CRITICAL_TOKEN "Critical"
#define PRIORITY_TOKEN "Priority"
#define WARNING_TOKEN "Warning"
#define INFORMATION_TOKEN "Information"
#define CLEAR_TOKEN "Clear"

#define EVENT_CRITICAL		4
#define EVENT_PRIORITY		3
#define EVENT_WARNING		2
#define EVENT_INFORMATION	1 
#define EVENT_CLEAR			0

#define EXCLUDE "Exclude"
#define INCLUDE "Include"

#define SIZE_OF_RESTRICTIP		 64
#define SIZE_OF_PASSWORD		 64
#define SIZE_OF_EVENTIDMATCH	 256
#define SIZE_OF_USERMATCH		 256
#define SIZE_OF_GENERALMATCH	 512
#define SIZE_OF_EVENTLOG		 35
#define SIZE_OF_CRITICALITY		 12
#define SIZE_OF_AN_OBJECTIVE	 1056
#define SIZE_OF_CLIENTNAME		 100
#define SIZE_OF_DESTINATION		 100
#define SIZE_OF_USER_MATCH_TYPE	 10

#define OBJECTIVE_DELIMITER		 "\t"

//These are definitions for the length of event record fields
#define MAX_OUTPUT_STRING		  8192
#define FIELD_SOURCE_NAME		  100
#define	FIELD_SIDTYPE			  100
#define FIELD_EVENTLOGTYPE	      50
#define FIELD_EXPANDEDSTRING	  1024
#define FIELD_DATASTRING		  1024
#define FIELD_COMPUTERNAME		  256
#define FIELD_USERNAME		      256
#define FIELD_CATEGORYSTRING      256
#define FIELD_DATETIME		      100
#define FIELD_CRITICALITY		  2
#define FIELD_SYSTEM			  256
#define FIELD_NULL			      256
#define FIELD_EVENTID			  10

#define READ_CONFIG_ERROR_CODE			210000;
#define READ_NETWORK_ERROR_CODE			230000;
#define READ_REMOTE_ERROR_CODE			260000;
#define READ_OBJECTIVE_ERROR_CODE		310000;
#define WRITE_CONFIG_ERROR_CODE			330000;
#define WRITE_NETWORK_ERROR_CODE		370000;
#define WRITE_REMOTE_ERROR_CODE			410000;
#define WRITE_OBJECTIVE_ERROR_CODE		440000;
#define RESTART_SERVICE_ERROR_CODE		480000;
#define WEB_READ_CONFIG_ERROR_CODE		510000;
#define WEB_READ_NETWORK_ERROR_CODE		530000;
#define WEB_READ_REMOTE_ERROR_CODE		580000;
#define WEB_READ_OBJECTIVE_ERROR_CODE	610000;
#define WEB_WRITE_CONFIG_ERROR_CODE		660000;
#define WEB_WRITE_NETWORK_ERROR_CODE	720000;
#define WEB_WRITE_REMOTE_ERROR_CODE		770000;
#define WEB_WRITE_OBJECTIVE_ERROR_CODE	850000;
#define WEB_RESTART_SERVICE_ERROR_CODE	890000;



// The following structure has been defined to cater for the 'config' registry settings
struct  Reg_Config
{
	char	str_Delimiter[3];
	char	str_ClientName[SIZE_OF_CLIENTNAME];
//	DWORD	dw_Audit;
//	DWORD	dw_FileAudit;
};

struct Reg_Network
{
	char	str_Destination[SIZE_OF_DESTINATION];
	DWORD	dw_SyslogDest;
	DWORD	dw_Syslog;
	DWORD	dw_DestPort;
};

struct Reg_Remote
{
	DWORD	dw_Allow;
	DWORD	dw_WebPort;
	DWORD	dw_WebPortChange;
	DWORD	dw_Restrict;
	char	str_RestrictIP[SIZE_OF_RESTRICTIP];
	DWORD	dw_Password;
	char	str_Password[SIZE_OF_PASSWORD];
};

struct Reg_Objective
{
	char	str_critic[SIZE_OF_CRITICALITY];
	char	str_event_type[SIZE_OF_EVENTLOG];
	char	str_eventlog_type[SIZE_OF_EVENTLOG];
	char	str_eventid_match[SIZE_OF_EVENTIDMATCH];
	char	str_user_match[SIZE_OF_USERMATCH];
	char	str_general_match[SIZE_OF_GENERALMATCH];
	char	str_user_match_type[SIZE_OF_USER_MATCH_TYPE];
	//These three DWORDS and the STRING are ONLY to support READ operations for Leigh's code
	DWORD	dw_event_type;			
	DWORD	dw_eventlog_type;
	DWORD	dw_user_match_type;
	char	str_unformatted_eventid_match[SIZE_OF_EVENTIDMATCH];
};


int Read_Config_Registry(Reg_Config *);
int Read_Objective_Registry(int, Reg_Objective *);
int Read_Network_Registry(Reg_Network *);
int Read_Remote_Registry(Reg_Remote *);
int Write_Config_Registry(Reg_Config *);
int Write_Network_Registry(Reg_Network *);
int Write_Remote_Registry(Reg_Remote *);
int Write_Objective_Registry(int, Reg_Objective *);
int Recreate_Objective_Key();
int Restart_Service();
int Delete_Objective(int);
int add_wildcard_start_and_end(char *,char *,int);
int remove_wildcard_start_and_end(char *,char *,int);
void read_event(char *str_buffer,char *SourceName,char *SIDType,char *EventLogType,
				char *ExpandedString,char *DataString,char *ComputerName,char *UserName,
				char *CategoryString,char *DateTime,char *Criticality,char *System,
				char *null,char *EventID);
int	validate_file_or_directory(char *filename);


BOOL	MyWriteProfileString	(LPCTSTR,LPCTSTR,LPCTSTR);
BOOL	MyWriteProfileDWORD		(LPCTSTR,LPCTSTR,DWORD);
BOOL	MyGetProfileString		(LPCTSTR,LPCTSTR,LPCTSTR,DWORD);
DWORD	MyGetProfileDWORD		(LPCTSTR,LPCTSTR,DWORD);
HKEY	MyGetSectionKey			(LPCTSTR);
HKEY	MyGetServiceRegistryKey	();


