#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <winsock2.h>
#include <lm.h>

#include <sys/stat.h>
#include <windows.h>

#define snprintf _snprintf

// DOMINO AND NOTES INCLUDE FILES
#include <global.h>
#include <osmisc.h>
#include <nsfdb.h>

#include <lapicinc.h>
#include <acl.h>
#include <nsfdata.h>                    // TYPE_TEXT, etc.
#include <nsfsearc.h>
#include <osfile.h>
#include <osmem.h>
#include <misc.h>
#include <niferr.h>                     // ERR_NO_MORE_MEMBERS
#include <lookup.h>
#include <lapiplat.h>

#include "WebPages.h"
#include "support.h"

SOCKET GLOBALhttp_socket;


int		ShowNotesACLs(SOCKET http_socket);
void	LNPUBLIC EnumACLCallback (void *pParams, char far *Name, WORD wAccessLevel, 
                                 ACL_PRIVILEGES far *pRoleBits, WORD wAccessFlags);
STATUS	LNPUBLIC ShowACLs(void *unused, SEARCH_MATCH far *pSearchMatch, ITEM_TABLE *summary_info);
void	GetAccessLevelStr (WORD wAccessLevel, char *pAccessLevelName);
int		DisplayTextHeader(SOCKET http_socket);

extern void	GetFQDN					(char *string,int length);

// Make sure we return the size, or zero (for strings).
// Note that for the most part, the socket will be ignored
int HandleWebPages(char *HTTPBuffer,char *HTTPOutputBuffer,int size,SOCKET http_socket)
{
	int returncode=0;
	char *ArgPosition;

	// Stuff without the header/footer
	if(!strcmp(HTTPBuffer,"/intersect.gif")) {
		return(InterSectImage(HTTPBuffer,HTTPOutputBuffer,size));
	} else {
		char * pBuffer=HTTPOutputBuffer;
		int length=0;
		int psize=0;

		ArgPosition=strstr(HTTPBuffer,"?");
		// No arguments passed?
		if(!ArgPosition) {
			// Set argument position to the beginning of the buffer.
			ArgPosition=HTTPBuffer;
		} else {
			ArgPosition++;
		}

		if(!strcmp(HTTPBuffer,"/NotesUsers")) {
			DisplayTextHeader(http_socket);
			ShowNotesUsers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/NotesGroups")) {
			DisplayTextHeader(http_socket);
			ShowNotesGroups(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/NotesGroupMembers")) {
			DisplayTextHeader(http_socket);
			ShowNotesGroupMembers(http_socket);
			return(-1);
		} else if(!strcmp(HTTPBuffer,"/NotesACLs")) {
			DisplayTextHeader(http_socket);
			ShowNotesACLs(http_socket);
			return(-1);
		}

		returncode=DefaultHeader(HTTPBuffer,pBuffer,size);
		length=strlen(HTTPOutputBuffer);
		
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}


		// Web pages
		if(!strcmp(HTTPBuffer,"/network")) {
			returncode+=Network_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/network?",9)) {
			strncpy(pBuffer,"Nothing here yet",psize);
		} else if(!strcmp(HTTPBuffer,"/remote")) {
			returncode+=Remote_Config(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setremote",10)) {
			returncode+=Remote_Set(ArgPosition,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/setnetwork",11)) {
			returncode+=Network_Set(HTTPBuffer,pBuffer,psize);
		} else if(!strncmp(HTTPBuffer,"/status",6)) {
			returncode+=Status_Page(ArgPosition,pBuffer,psize);
		} else {
			returncode=+Status_Page(ArgPosition,pBuffer,psize);
		}

		pBuffer = HTTPOutputBuffer;
		length=strlen(HTTPOutputBuffer);
		pBuffer+=length;
		psize=size-length;
		if(psize < 0) {
			psize=0;
		}

		returncode+=DefaultFooter(HTTPBuffer,pBuffer,psize);
	}

	return(returncode);
}


// This page will be usefull for debug information
int Status_Page(char *source, char *dest, int size)
{
	strncpy(dest,"<HTML><BODY><H1><CENTER>SNARE Status Page</H1><P><font color=green>Snare for Lotus Notes is currently active.</font></CENTER></BODY></HTML>",size);
	return(0);
}

int Network_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Config config_struct;
	Reg_Network network_struct;
	DWORD dw_config_error,dw_network_error;
	char str_DestPort[10];
	char str_conferr[10],str_neterr[10];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	UINT i,i_SyslogFacility,i_SyslogPriority;
		
	dw_config_error = Read_Config_Registry(&config_struct);
	dw_network_error = Read_Network_Registry(&network_struct);

	// This function will display the form used to set the audit configuration
	// The result of the form will be sent to "network_set"
	strncpy(dest,"<form action=setnetwork><h1><center>SNARE Network Configuration</h1>",size);

	// Will display an error if unable to completely read from the registry
	if ((dw_network_error > 0) || (dw_config_error > 0))
	{
		dw_network_error += WEB_READ_NETWORK_ERROR_CODE;
		dw_config_error += WEB_READ_CONFIG_ERROR_CODE;
		itoa(dw_network_error,str_neterr,10);
		itoa(dw_config_error,str_conferr,10);

		strncat(dest,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",size - strlen(dest));
		strncat(dest,str_neterr,size - strlen(dest));
		strncat(dest,".",size - strlen(dest));
		strncat(dest,str_conferr,size - strlen(dest));
		strncat(dest,"</b><br>",size - strlen(dest));
	}

	strncat(dest,"<br>The following network configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>" \
		"<tr bgcolor=#FFFFCC><td>Clientname</td><td><input type=text name=str_ClientName size=25 value=\"",size - strlen(dest));
	
	strncat(dest,config_struct.str_ClientName,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFBB><td>Destination Server address </td><td><input type=text name=str_Destination size=25 value=\"",size - strlen(dest));
	strncat(dest,network_struct.str_Destination,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Destination UDP Port <br>(if SYSLOG Header NOT enabled)</td><td><input type=text name=dw_DestPort size=8 value=\"",size - strlen(dest));
	itoa(network_struct.dw_DestPort,str_DestPort,10);
	strncat(dest,str_DestPort,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	// First 3 bits = facility (eg: emerg, alert, etc.)
	// Rest = priority. Note that there is a gap between ftp and local1.
	i_SyslogPriority = (UINT)network_struct.dw_SyslogDest & 7;
	i_SyslogFacility = (UINT)network_struct.dw_SyslogDest >> 3;
	if(i_SyslogFacility > 11) { 
		i_SyslogFacility = i_SyslogFacility - 4;
	}


	// Need to convert this next section to YES or NO
	strncat(dest,"<tr bgcolor=#FFFFBB><td>Enable SYSLOG Header?</td><td><input type=checkbox name=dw_Syslog",size - strlen(dest));
	if (network_struct.dw_Syslog != 0)
		strncat(dest," checked",size - strlen(dest));	
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>SYSLOG Facility </td><td><select name=SyslogFacility>",size - strlen(dest));
	for (i = 0; i < 19; i++)
	{
		strncat(dest,"<option",size - strlen(dest));
		if (i == i_SyslogFacility)
			strncat(dest," selected>",size - strlen(dest));
		else
			strncat(dest,">",size - strlen(dest));
		strncat(dest,str_facility[i],size - strlen(dest));
	}
	strncat(dest,"</select></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFBB><td>SYSLOG Priority </td><td><select name=SyslogPriority>",size - strlen(dest));
	for (i = 0; i < 8; i++)
	{
		strncat(dest,"<option",size - strlen(dest));
		if (i == i_SyslogPriority)
			strncat(dest," selected>",size - strlen(dest));
		else
			strncat(dest,">",size - strlen(dest));
		strncat(dest,str_priority[i],size - strlen(dest));
	}
	strncat(dest,"</select></td></tr>",size - strlen(dest));

	strncat(dest,"</table><br>",size - strlen(dest));
	strncat(dest,"<input type=submit value=\"Change Configuration\">    ",size - strlen(dest));
	strncat(dest,"<input type=reset value=\"Reset Form\"></form>",size - strlen(dest));
	
	return(0);
}

int Network_Set(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100],syslog_fac[100],syslog_pri[100];
	char Argument[100], delimiter[5];
	char *str_facility[] = {"Kernel","User","Mail","Daemon","Auth","Syslog","Lpr","News","UUCP","Cron","Authpriv","Ftp","Local0","Local1","Local2","Local3","Local4","Local5","Local6","Local7"};
	char *str_priority[] = {"Emergency","Alert","Critical","Error","Warning","Notice","Information","Debug"};
	Reg_Network network_struct;
	Reg_Config config_struct;
	DWORD dw_error_network = 1,dw_error_config = 1,dw_SyslogClass = 0,dw_delimiter_set = 0;
	int i;

	//This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest,"<h1><center>SNARE Network Configuration</h1>",size);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Checking is limited to ensuring the Detsination port in the range 1-65535.
	// The variable associated with the checkbox (dw_Syslog) must be
	// exactly "on" or it will be defaulted to "off".
	// str_Destination,str_Delimiter_Text,str_ClientName can be anything it wants to be, so long 
	// as it is within size bounds.

	network_struct.dw_DestPort = -1;
	network_struct.dw_Syslog = 0;

	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"str_Delimiter") != NULL)
		{
			if (strcmp(Argument,"Comma") == 0)
			{
				strncpy(config_struct.str_Delimiter,",",sizeof(config_struct.str_Delimiter));
				dw_delimiter_set = 1;
			}
			else if (strcmp(Argument,"Tab") == 0)
			{
				strncpy(config_struct.str_Delimiter,"	",sizeof(config_struct.str_Delimiter));
				dw_delimiter_set = 1;
			}
			
		}
		if (strstr(Variable,"str_Delimiter_Text") != NULL) {
			strncpy(delimiter,Argument,sizeof(delimiter));
		}
		if (strstr(Variable,"str_ClientName") != NULL) {
			strncpy(config_struct.str_ClientName,Argument,sizeof(config_struct.str_ClientName));
		}
		if (strstr(Variable,"str_Destination") != NULL) {
			strncpy(network_struct.str_Destination,Argument,sizeof(network_struct.str_Destination));
		}
		if (strstr(Variable,"dw_DestPort") != NULL) {
			strncpy(web_port,Argument,sizeof(web_port));
		}
		if (strstr(Variable,"SyslogPriority") != NULL) {
			strncpy(syslog_pri,Argument,sizeof(syslog_pri));
		}
		if (strstr(Variable,"SyslogFacility") != NULL) {
			strncpy(syslog_fac,Argument,sizeof(syslog_fac));
		}
		if (strstr(Variable,"dw_Syslog") != NULL) {
			if (strcmp(Argument,"on") == 0)
				network_struct.dw_Syslog = 1;
		}

	}

	if (dw_delimiter_set == 0) {
		strncpy(config_struct.str_Delimiter,delimiter,sizeof(config_struct.str_Delimiter));
	}

	for (i = 0; i < 8; i++) {
		if (strstr(syslog_pri,str_priority[i]) != NULL) {
			network_struct.dw_SyslogDest = i;
		}
	}
	for (i = 0; i < 19; i++)
	{
		if (strstr(syslog_fac,str_facility[i]) != NULL) {
			dw_SyslogClass = i;
		}
	}


	if(dw_SyslogClass > 11) {
		dw_SyslogClass = dw_SyslogClass + 4;
	}
	network_struct.dw_SyslogDest = network_struct.dw_SyslogDest | (dw_SyslogClass << 3);


	network_struct.dw_DestPort = atoi(web_port);
	if ((network_struct.dw_DestPort < 1) || (network_struct.dw_DestPort > 65535)) {
		strncat(dest,"The Destination Port value must be between 1 and 65535. Use the 'back' button to change the value.",size - strlen(dest));
	} else {
		dw_error_network = Write_Network_Registry(&network_struct);
		dw_error_config = Write_Config_Registry(&config_struct);
		if ((dw_error_network != 0) || (dw_error_config != 0)) {
			strncat(dest,"Values have NOT been changed.",size - strlen(dest));
			//**********PUT AN ERROR CODE IN HERE
		} else {
			strncat(dest,"Values have been changed.",size - strlen(dest));
		}
	}
	return(0);

}


int Remote_Config(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	Reg_Remote remote_struct;
	DWORD dw_remote_error;
	char str_WebPort[10];
	char str_remerr[10];


	dw_remote_error = Read_Remote_Registry(&remote_struct);

	//This function will display the form used to set the remote audit configuration
	strncpy(dest,"<form action=setremote><h1><center>SNARE Remote Control Configuration</h1>",size);

	//Will display an error if unable to completely read from the registry
	if (dw_remote_error > 0)
	{
		dw_remote_error += WEB_READ_REMOTE_ERROR_CODE;
		itoa(dw_remote_error,str_remerr,10);
		
		strncat(dest,"<br><b>NOTE: Some errors were encountered in reading the registry. Default values " \
					"may be used.<br> Report error: ",size - strlen(dest));
		strncat(dest,str_remerr,size - strlen(dest));
		strncat(dest,"</b><br>",size - strlen(dest));
	}
	strncat(dest,"<br>The following remote control configuration parameters of the SNARE unit is set to the following values:<br><br>" \
		"<table  width=70% border=0>" \
		"<tr bgcolor=#FFFFCC><td>Allow remote control of SNARE agent</td><td><input type=checkbox name=dw_Allow",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Allow != 0)
		strncat(dest," checked",size - strlen(dest));
	
	strncat(dest,"></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",size - strlen(dest));
	strncat(dest,"<tr bgcolor=#FFFFBB><td>Restrict remote control of SNARE agent to certain hosts </td><td><input type=checkbox name=dw_Restrict",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Restrict != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>IP Address allowed to remote control SNARE </td><td><input type=text name=str_RestrictIP size=12 value=\"",size - strlen(dest));
	strncat(dest,remote_struct.str_RestrictIP,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));
	

	strncat(dest,"<tr bgcolor=#FFFFBB><td>Require a password for remote control? </td><td><input type=checkbox name=dw_Password",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_Password != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Password to allow remote control of SNARE </td><td><input type=password name=str_Password size=12 value=\"",size - strlen(dest));
	strncat(dest,remote_struct.str_Password,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));



	strncat(dest,"<tr bgcolor=#FFFFBB><td>Change Web Server default (80) port </td><td><input type=checkbox name=dw_PortChange",size - strlen(dest));

	//Need to convert this next section to YES or NO
	if (remote_struct.dw_WebPortChange != 0)
		strncat(dest," checked",size - strlen(dest));
	strncat(dest,"></td></tr>",size - strlen(dest));

	strncat(dest,"<tr bgcolor=#FFFFCC><td>Web Server Port </td><td><input type=text name=dw_WebPort size=8 value=\"",size - strlen(dest));
	itoa(remote_struct.dw_WebPort,str_WebPort,10);
	strncat(dest,str_WebPort,size - strlen(dest));
	strncat(dest,"\"></td></tr>",size - strlen(dest));

	strncat(dest,"</table><br>",size - strlen(dest));
	strncat(dest,"<input type=submit value=\"Change Configuration\">    ",size - strlen(dest));
	strncat(dest,"<input type=reset value=\"Reset Form\"></form>",size - strlen(dest));
	
	return(0);
}

int Remote_Set(char *source, char *dest, int size) 
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	char *psource=source;
	char Variable[100], web_port[100];
	char Argument[100];
	Reg_Remote remote_struct;
	DWORD dw_error = 0;
	
	//This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest,"<h1><center>SNARE Remote Control Configuration</h1>",size);

	//Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	//via a checkbox will not be listed if the checkbox has been deselected.
	//Also be aware that there may not be any arguments for this objective. If a sysadmin does not want
	//remote control, then there will be no arguments.
	//Hence: Checking is limited to Webport in the range 1-65535 only if portchange is "on"
	//The three variable associated with the checkboxes (dw_Allow, dw_Restrict, and dw_PortChange) must be
	//exactly "on" or they will be defaulted to "off".
	//str_RestrictIP can be anything it wants to be, so long as it is within size bounds.

	remote_struct.dw_WebPort = -1;

	while((psource=GetNextArgument(psource,Variable,sizeof(Variable),Argument,sizeof(Argument))) != (char *)NULL) 
	{	
		if (strstr(Variable,"dw_WebPort") != NULL) {
			strncpy(web_port,Argument,sizeof(web_port));
		}
		if (strstr(Variable,"str_RestrictIP") != NULL) {
			strncpy(remote_struct.str_RestrictIP,Argument,sizeof(remote_struct.str_RestrictIP));
		}
		if (strstr(Variable,"str_Password") != NULL) {
			strncpy(remote_struct.str_Password,Argument,sizeof(remote_struct.str_Password));
		}
		if (strstr(Variable,"dw_Allow") != NULL) {
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Allow = 1;
			} else {
				remote_struct.dw_Allow = 0;
			}
		}
		if (strstr(Variable,"dw_Password") != NULL) {
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Password = 1;
			} else {
				remote_struct.dw_Password = 0;
			}
		}
		if (strstr(Variable,"dw_Restrict") != NULL) {
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_Restrict = 1;
			} else {
				remote_struct.dw_Restrict = 0;
			}
		}
		if (strstr(Variable,"dw_PortChange") != NULL) {
			if (strcmp(Argument,"on") == 0) {
				remote_struct.dw_WebPortChange = 1;
			} else {
				remote_struct.dw_WebPortChange = 0;
			}
		}
	}

	remote_struct.dw_WebPort = atoi(web_port);
	if ((remote_struct.dw_WebPort < 1) || (remote_struct.dw_WebPort > 65535)) {
		strncat(dest,"The Web Port value must be between 1 and 65535. Use the 'back' button to change the value.",size - strlen(dest));
	} else {
		dw_error = Write_Remote_Registry(&remote_struct);
		if (dw_error != 0) {
			strncat(dest,"Remote Control Values have NOT been changed. Report error: ",size - strlen(dest));
			// **********PUT AN ERROR CODE IN HERE
		} else {
			strncat(dest,"Remote Control Values have been changed.",size - strlen(dest));
		}
	}
	return(0);
}


int DefaultHeader(char *source, char *dest, int size)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy(dest,"<HTML><head>" \
	"<title>InterSect Alliance - Information Technology Security</title>" \
	"<meta name=\"TITLE\" content=\"InterSect Alliance - Information Technology Security\">" \
	"</head>" \
	"<body text=black bgcolor=white link=#000066 vlink=#000044 alink=#000055>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=3 width=100%>" \
	"<tbody>" \
    "<tr>" \
    "<td height=70><img src=/intersect.gif alt=\"InterSect\" width=205 height=70 hspace=20 vspace=0 border=0 align=Right>" \
    "</td>" \
    "<td height=70 width=1% bgcolor=#eeeeee><br></td>" \
	"<td height=70 width=1% bgcolor=#dddddd><br></td>" \
	"<td height=70 width=1% bgcolor=#cccccc><br></td>" \
	"<td height=70 width=1% bgcolor=#ccbbbb><br></td>" \
	"<td height=70 width=1% bgcolor=#ccaaaa><br></td>" \
	"<td height=70 width=1% bgcolor=#cc9999><br></td>" \
	"<td height=70 width=1% bgcolor=#cc8888><br></td>" \
	"<td height=70 width=1% bgcolor=#cc7777><br></td>" \
	"<td height=70 width=1% bgcolor=#cc6666><br></td>" \
	"<td height=70 width=1% bgcolor=#cc5555><br></td>" \
	"<td height=70 width=1% bgcolor=#cc4444><br></td>" \
	"<td height=70 width=1% bgcolor=#cc3333><br></td>" \
	"<td height=70 width=1% bgcolor=#cc2222><br></td>" \
	"<td height=70 width=1% bgcolor=#cc1111><br></td>" \
	"<td height=70 width=86% bgcolor=#cc0000><div align=right><font face=\"Helvetica,Arial,sans-serif\" size=+2 color=white><b><center>SNARE for Windows&nbsp;</b></font><font color=white></font>&nbsp;&nbsp;</center></div></td>" \
    "</tr>" \
    "</tbody>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=0 columns=1 width=100%>" \
    "<tr><td height=3 border=0 bgcolor=white width=100%></td></tr>" \
    "<tr><td height=3 border=0 bgcolor=black width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=#AAAAAA width=100%></td></tr>" \
    "<tr><td height=2 border=0 bgcolor=white width=100%></td></tr>" \
	"</table>" \
	"<table border=0 cellspacing=0 cellpadding=5 columns=2 width=100% height=100%>" \
	"<tbody>" \
    "<tr>" \
      "<td valign=Top width=20% bgcolor=#cc0000>" \
      "<div align=Center><font color=#ffffff>" \
      "<br>" \
      "<font face=\"Helvetica,Arial,sans-serif\" size=-1><B>" \
      "<br><A HREF=\"/network\" style=\"color:FFFFFF;text-decoration:none\">Network Configuration</A><br>" \
      "<br><A HREF=\"/remote\" style=\"color:FFFFFF;text-decoration:none\">Remote Control Configuration</A><br>" \
      "<br><A HREF=\"/status\" style=\"color:FFFFFF;text-decoration:none\">View Audit Service Status</A><br>" \
	  "<font size=-1>" \
	  "<br><A HREF=\"/NotesUsers\" style=\"color:FFFFFF;text-decoration:none\">Notes Users</A><br>" \
	  "<br><A HREF=\"/NotesGroups\" style=\"color:FFFFFF;text-decoration:none\">Notes Groups</A><br>" \
	  "<br><A HREF=\"/NotesGroupMembers\" style=\"color:FFFFFF;text-decoration:none\">Notes Group Members</A><br>" \
	  "<br><A HREF=\"/NotesACLs\" style=\"color:FFFFFF;text-decoration:none\">Notes Access Controls</A><br>" \
      "</font>" \
	  "</b></font>" \
      "<br>" \
      "</div>" \
    "</td>" \
    "<td width=100% valign=Top>" \
     "<table cellpadding=0 cellspacing=10 border=0 width=100%>" \
      "<tbody>" \
       "<tr>" \
        "<td valign=Top align=Justify>",size);

	return(0);
}

int DefaultFooter(char *source, char *dest, int size)
{
	//All strncpy or strncat functions in this routine have been designed avoid overflows
	strncpy(dest,"</td>" \
		"</tr>" \
		"</tbody>" \
		"</table>" \
		"</body><center>" \
		"<BR><BR><FONT SIZE=-1 face=helvetica>(c) <A HREF=\"http://www.intersectalliance.com\">Intersect Alliance</A> Pty Ltd 2002. " \
		"This site is powered by <A HREF=\"http://www.intersectalliance.com/projects/\">SNARE for Windows.</A></FONT>" \
		"</center></html>",size);

	return(0);
}


int ShowNotesUsers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";
	char TempBuffer2[1024]="";

    HANDLE  hLookup;
    STATUS  error = NOERROR;
	char   *pLookup;
	char   *pName;
	DWORD	NumMatches;
	DWORD	NumViews=1;
	DWORD	NumNames=1;
	DWORD NumItems=4;
	DWORD i,j;
	int k;
	int found=0;

    char   *pMatch;

	GetFQDN(TempBuffer2,sizeof(TempBuffer2));

	snprintf(TempBuffer,sizeof(TempBuffer),"SERVER: %s\n",TempBuffer2);
	retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);

	error = NAMELookup2(NULL,		// Ptr to mail server name
				NAME_LOOKUP_ALL,	// Flags - DWORD for NAMELookup2 NAME_LOOKUP_ALL/NAME_LOOKUP_EXHAUSTIVE is an alternative
				(int)NumViews,		// Number of name spaces
				"$Users",			// Name of name space (view name)
				(int)NumNames,		// # of names
				"",					// Ptr to the names themselves
				(int)NumItems,		// # of items desired
				// "Members",			// Ptr to the item names
				"Type\0ShortName\0FullName\0Comment",
				// "Domain\0Server\0PublicKey\0Members\0Certificate",	// Ptr to the item names
				&hLookup);			//  Handle of returned buffer

	if (error)
		goto Abort;

	pLookup = (char *)OSLockObject(hLookup);

	for (pName = NULL, i = 0; i < (NumViews*NumNames); i++) {
		//	Locate the set of matches for the next name searched for
		pName = (char *)NAMELocateNextName2(pLookup, pName, &NumMatches);

		found=0;
		//	Traverse all matches for this name
		for (pMatch = NULL, j = 0; j < NumMatches; j++) {
			pMatch = (char *)NAMELocateNextMatch2(pLookup, pName, pMatch);
			//	Here, handle a text list or text item (this handles
			//	both kinds) and traverse all members. Once we have a person match, break out.
			for (k = 0; ; k++) {
				// Names seem to be only in the MEMBERS match term. Have killed the others
				// for the moment.
				if (NAMEGetTextItem2(pMatch, 0, k, 
					TempBuffer, sizeof(TempBuffer)) != NOERROR) {
					break;
				}

				if(!strncmp(TempBuffer,"Person",6)) {
					if (NAMEGetTextItem2(pMatch, 1, k, 
						TempBuffer, sizeof(TempBuffer)) != NOERROR) {
						break;
					} else {
						retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
					}
					retval = send(http_socket,"	",1,0);

					if (NAMEGetTextItem2(pMatch, 2, k, 
						TempBuffer, sizeof(TempBuffer)) == NOERROR) {
						retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
					}
					retval = send(http_socket,"	",1,0);

					if (NAMEGetTextItem2(pMatch, 3, k, 
						TempBuffer, sizeof(TempBuffer)) == NOERROR) {
						retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
					}
					retval = send(http_socket,"\n",1,0);
					// found=1;
					//break;
				}
			}
		}
	}
	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

Abort:
	OSUnlockObject(hLookup);
	OSMemFree(hLookup);


	return(0);
}

int ShowNotesGroups(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";
	char TempBuffer2[1024]="";

    HANDLE  hLookup;

    STATUS  error = NOERROR;
	char   *pLookup;

	char   *pName;
	DWORD	NumMatches;
	DWORD	NumViews=1;
	DWORD	NumNames=1;
	DWORD NumItems=2;

    char   *pMatch;

	GetFQDN(TempBuffer2,sizeof(TempBuffer2));
	snprintf(TempBuffer,sizeof(TempBuffer),"SERVER: %s\n",TempBuffer2);
	retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);


	// SERVERACCESS seems to provide a list of groups... not sure if this
	// is the best way to get them though... but $Groups not working?
	// USER seems to work too..

	// 'serveraccess sorts by name and the groups they have access to' (from newsnet).
	error = NAMELookup2(NULL,		// Ptr to mail server name
				NAME_LOOKUP_ALL,	// Flags - DWORD for NAMELookup2 NAME_LOOKUP_ALL/NAME_LOOKUP_EXHAUSTIVE is an alternative
				(int)NumViews,		// Number of name spaces
				//"$ServerAccess",			// Name of name space (view name)
				// "$Groups",			// Name of name space (view name)
				// "$Users",
				"$VIMGroups",
				(int)NumNames,		// # of names
				"",					// Ptr to the names themselves
				(int)NumItems,		// # of items desired
				"ListName\0ListDescription",			// Ptr to the item names
				// "Members",			// Ptr to the item names
				// "Domain\0Server\0PublicKey\0Members\0Certificate",	// Ptr to the item names
				&hLookup);			//  Handle of returned buffer



	if (error) {
		goto Abort;
	}

	pLookup = (char *)OSLockObject(hLookup);

	DWORD i,j;
	int k;

	for (pName = NULL, i = 0; i < (NumViews*NumNames); i++) {
		//	Locate the set of matches for the next name searched for
		pName = (char *)NAMELocateNextName2(pLookup, pName, &NumMatches);

		//	Traverse all matches for this name
		for (pMatch = NULL, j = 0; j < NumMatches; j++) {
			pMatch = (char *)NAMELocateNextMatch2(pLookup, pName, pMatch);
			//	Here, handle a text list or text item (this handles
			//	both kinds) and traverse all members
			for (k = 0; ; k++) {
				// Names seem to be only in the MEMBERS match term. Have killed the others
				// for the moment.
				if (NAMEGetTextItem2(pMatch, 0, k, 
					TempBuffer, sizeof(TempBuffer)) != NOERROR) {
					break;
				}

				if(strlen(TempBuffer) > 1) {
					// Ignore duplicates, if they're sorted.
					retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
					retval = send(http_socket,"	",1,0);

					if (NAMEGetTextItem2(pMatch, 1, k, 
						TempBuffer, sizeof(TempBuffer)) == NOERROR) {
						retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
					}
					retval = send(http_socket,"\n",1,0);
				}
			}
		}
	}
	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

Abort:
	OSUnlockObject(hLookup);
	OSMemFree(hLookup);


	return(0);
}



//// NOTE: This doesnt yet cater for groups within groups. Do we need to do this??
//// Does notes have a 'isgroup' equiv?

int ShowNotesGroupMembers(SOCKET http_socket)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";
	char TempBuffer2[1024]="";
	char TempBuffer3[1024]="";

    HANDLE  hLookup;
	HANDLE  hLookup2;

    STATUS  error = NOERROR;
	char   *pLookup;
	char   *pLookup2;

	char   *pName;
	char   *pName2;
	DWORD	NumMatches;
	DWORD	NumMatches2;
	DWORD	NumViews=1;
	DWORD	NumNames=1;
	DWORD NumItems=1;

    char   *pMatch;
	char   *pMatch2;

	DWORD i,j;
	int k;
	DWORD i2,j2;
	int k2;

	int FirstUser=1;

	GetFQDN(TempBuffer2,sizeof(TempBuffer2));
	snprintf(TempBuffer,sizeof(TempBuffer),"SERVER: %s\n",TempBuffer2);
	retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);


	// SERVERACCESS seems to provide a list of groups... not sure if this
	// is the best way to get them though... but $Groups not working?
	// USER seems to work too..

	// 'serveraccess sorts by name and the groups they have access to' (from newsnet).
	error = NAMELookup2(NULL,		// Ptr to mail server name
				NAME_LOOKUP_ALL,	// Flags - DWORD for NAMELookup2 NAME_LOOKUP_ALL/NAME_LOOKUP_EXHAUSTIVE is an alternative
				(int)NumViews,		// Number of name spaces
				//"$ServerAccess",			// Name of name space (view name)
				// "$Groups",			// Name of name space (view name)
				// "$Users",
				"$VIMGroups",
				(int)NumNames,		// # of names
				"",					// Ptr to the names themselves
				(int)NumItems,		// # of items desired
				"ListName",			// Ptr to the item names
				// "Members",			// Ptr to the item names
				// "Domain\0Server\0PublicKey\0Members\0Certificate",	// Ptr to the item names
				&hLookup);			//  Handle of returned buffer



	if (error) {
		goto Abort;
	}

	pLookup = (char *)OSLockObject(hLookup);

	for (pName = NULL, i = 0; i < (NumViews*NumNames); i++) {
		//	Locate the set of matches for the next name searched for
		pName = (char *)NAMELocateNextName2(pLookup, pName, &NumMatches);
		//	Traverse all matches for this name
		for (pMatch = NULL, j = 0; j < NumMatches; j++) {
			pMatch = (char *)NAMELocateNextMatch2(pLookup, pName, pMatch);
			//	Here, handle a text list or text item (this handles
			//	both kinds) and traverse all members
			for (k = 0; ; k++) {
				// Names seem to be only in the MEMBERS match term. Have killed the others
				// for the moment.
				if (NAMEGetTextItem2(pMatch, 0, k, 
					TempBuffer, sizeof(TempBuffer)) != NOERROR) {
					break;
				}

				if(strlen(TempBuffer) > 1) {
					// Ignore duplicates, if they're sorted.
					if(strcmp(TempBuffer,TempBuffer2) != 0) {
						retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
						retval = send(http_socket,"\t",1,0);
						strncpy(TempBuffer2,TempBuffer,sizeof(TempBuffer2));


						FirstUser=1;
						// We have a group name. Look up the members.
						error = NAMELookup2(NULL,		// Ptr to mail server name
							NAME_LOOKUP_ALL,	// Flags - DWORD for NAMELookup2 NAME_LOOKUP_ALL/NAME_LOOKUP_EXHAUSTIVE is an alternative
							(int)NumViews,		// Number of name spaces
							"$VIMGroups",
							(int)NumNames,		// # of names
							TempBuffer,			// Ptr to the names themselves
							(int)NumItems,		// # of items desired
							"Members",			// Ptr to the item names
							&hLookup2);			//  Handle of returned buffer

						if(!error) {
							pLookup2 = (char *)OSLockObject(hLookup2);
							for (pName2 = NULL, i2 = 0; i2 < (NumViews*NumNames); i2++) {
								//	Locate the set of matches for the next name searched for
								pName2 = (char *)NAMELocateNextName2(pLookup2, pName2, &NumMatches2);
								//	Traverse all matches for this name
								for (pMatch2 = NULL, j2 = 0; j2 < NumMatches2; j2++) {
									pMatch2 = (char *)NAMELocateNextMatch2(pLookup2, pName2, pMatch2);
									//	Here, handle a text list or text item (this handles
									//	both kinds) and traverse all members
									for (k2 = 0; ; k2++) {
										// Names seem to be only in the MEMBERS match term. Have killed the others
										// for the moment.
										if (NAMEGetTextItem2(pMatch2, 0, k2, 
											TempBuffer, sizeof(TempBuffer)) != NOERROR) {
											break;
										}
										if(strlen(TempBuffer) > 1) {
											if(!FirstUser) {
												retval = send(http_socket,",",1,0);	
											}
											FirstUser=0;
											// Ignore duplicates, if they're sorted.
											retval = send(http_socket,TempBuffer,strlen(TempBuffer),0);
										}
									}
								}
							}
						}
						retval = send(http_socket,"\n",1,0);
						if(hLookup2) {
							OSUnlockObject(hLookup2);
							OSMemFree(hLookup2);
						}
					}
				}
			}
		}
	}
	// Send a newline to finish off.
	retval = send(http_socket,"\n",strlen("\n"),0);

Abort:
	if(hLookup) {
		OSUnlockObject(hLookup);
		OSMemFree(hLookup);
	}


	return(0);
}




int ShowNotesACLs(SOCKET http_socket)
{
	char        full_netpath[MAXPATH];
	DBHANDLE    dir_handle;

	// Need a global for the moment.
	GLOBALhttp_socket=http_socket;
	char TempBuffer[1024]="";

    STATUS  error = NOERROR;

	// Unfortunately, we need a global here, unless I can work out a way
	// to pass data THROUGH NSFSearch to the callback routine.
	GLOBALhttp_socket=http_socket;

	// Compose the full network pathname to the directory.
    error = OSPathNetConstruct(NULL, NULL, NULL, full_netpath);
	if (error != NOERROR)
		return(error);

	// Open the directory.
    error = NSFDbOpen (full_netpath, &dir_handle);
	if (error != NOERROR)
		return(error);

	// Call NSFSearch to find files in the directory. For each file found, 
	// call an action routine.
    if (error = NSFSearch (
        dir_handle,        // directory handle
        NULLHANDLE,        // selection formula
        NULL,              // title of view in formula
        SEARCH_FILETYPE +  // search for files
        SEARCH_SUMMARY,    // return a summary buffer
        FILE_DBANY +       // find any .NS? file
        FILE_DIRS +        // find subdirectories
        FILE_NOUPDIRS,     // don't find the ".." dir
        NULL,              // starting date
        ShowACLs,          // call for each file found
        NULL,              // argument to action routine
        NULL))             // returned ending date (unused)
	{
		NSFDbClose (dir_handle);
		return(error);
	}

	// Close the directory.

    error = NSFDbClose (dir_handle);
    if(error != NOERROR) {
		return(error);
	}
	return(NOERROR);
}

STATUS LNPUBLIC ShowACLs(void *unused, SEARCH_MATCH far *pSearchMatch, ITEM_TABLE *summary_info)
{
	int retval;
	char HTTPBuffer[1024]="";
	char TempBuffer[1024]="";
	char DBPath[MAX_PATH];
	struct stat st;


	SEARCH_MATCH SearchMatch;
	STATUS  error = NOERROR;
	DBHANDLE hDB;
	HANDLE hACL;

    memcpy( (char*)&SearchMatch, (char*)pSearchMatch, sizeof(SEARCH_MATCH) );

	// Skip this object if it does not really match the search criteria (it 
	// is now deleted or modified).  This is not necessary for full searches,
	// but is shown here in case a starting date was used in the search.

    if(!(SearchMatch.SERetFlags & SE_FMATCH))	return (NOERROR);

	error=NSFGetSummaryValue((void far *)summary_info,"$PHYSICALPATH",DBPath,sizeof(DBPath));

	// Is this a directory?
	// If so, return.

	// Try STATing the file/directory
	stat(DBPath, &st);
	if(st.st_mode & S_IFDIR) {
		// Not interested in directories.
		return(NOERROR);
	}

	_snprintf(TempBuffer,sizeof(TempBuffer),"%s",DBPath);
	retval=send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);


	error = NSFDbOpen (DBPath, &hDB);
	if (error != NOERROR) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"\tCANNOT OPEN DATABASE\n",DBPath);
		retval=send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);

		return(error);
	}

	// Get the ACL - the sample database contains the default ACL
	error = NSFDbReadACL(hDB, &hACL);
	if (error != NOERROR) {
		NSFDbClose(hDB);
		_snprintf(TempBuffer,sizeof(TempBuffer),"\tCANNOT READ ACCESS CONTROLS\n",DBPath);
		retval=send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);

		return(NOERROR);		// Ignore this database. Continue reading others.
	}

	retval = send(GLOBALhttp_socket,"\n",strlen("\n"),0);

	error = ACLEnumEntries (hACL,            // handle to ACL
                            EnumACLCallback, // callback function pointer */
                            &hACL);          // pointer to params passed to
                                             // callback function
	if (error != NOERROR) {
		OSMemFree (hACL);
		NSFDbClose(hDB);
		return(error);
	}


	retval = send(GLOBALhttp_socket,"\n",strlen("\n"),0);

	OSMemFree (hACL);
	NSFDbClose(hDB);

	return(0);
}


/*   EnumACLCallback - This function is called by ACLEnumEntries.
 *   It prints out ACL information for each name in the ACL.
 *
 *   Inputs:
 *      pParams      - pointer to parameters that have been passed to
 *                     ACLEnumEntries to be used by this callback function.
 *      Name         - user name.
 *      wAccessLevel - Access level.
 *      pRoleBits    - Pointer to role bits.
 *      wAccessFlags - Access level privilege flags (eg: unable to delete 
 *                     docs).
 */
void LNPUBLIC EnumACLCallback (void *pParams, char far *Name, 
                                 WORD wAccessLevel, 
                                 ACL_PRIVILEGES far *pRoleBits, 
                                 WORD wAccessFlags)
{
	char szTempStr[256];
	char TempBuffer[1024];
	int i;
	int retval;
	STATUS nError;

	_snprintf(TempBuffer,sizeof(TempBuffer),"\t%s\t",Name);
	retval = send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);
	
	// Get the access level.
	GetAccessLevelStr (wAccessLevel, szTempStr);

	_snprintf(TempBuffer,sizeof(TempBuffer),"%s\t",szTempStr);
	retval = send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);


	// Get the role name from the role bits
	for (i = 0; i < ACL_PRIVCOUNT; i++) {
		if (ACLIsPrivSet(*pRoleBits, i)) {
			// Get the role name
			nError = ACLGetPrivName (
                     *(HANDLE *)pParams, // handle to ACL
                     (WORD)i,            // role number
                     szTempStr);         // returned role name
			if (nError == NOERROR) {
				_snprintf(TempBuffer,sizeof(TempBuffer),"%s",szTempStr);
				retval = send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);
			} else {
				OSLoadString(0, ERR(nError), szTempStr, sizeof(szTempStr) - 1);
				_snprintf(TempBuffer,sizeof(TempBuffer),"%s",szTempStr);
				retval = send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);
			}
		}
	}

	retval = send(GLOBALhttp_socket,"\t",1,0);

	strncpy(TempBuffer,"",sizeof(TempBuffer));

 /*	ACL_FLAG_AUTHOR_NOCREATE	-  User has access level of author and cannot create new notes (can only edit existing ones).
	ACL_FLAG_SERVER				-  Entry represents a Server
	ACL_FLAG_NODELETE			-  User cannot delete notes.
	ACL_FLAG_CREATE_PRAGENT		-  User can create personal agents
	ACL_FLAG_CREATE_PRFOLDER	-  User can create personal folders
	ACL_FLAG_PERSON				-  Entry represents a Person
	ACL_FLAG_GROUP				-  Entry represents a group
	ACL_FLAG_CREATE_FOLDER		-  User can create and update shared views & folders. This allows an Editor to assume some Designer-level access
	ACL_FLAG_CREATE_LOTUSSCRIPT	-  User can create LotusScript
	ACL_FLAG_PUBLICREADER		-  User can read public notes
	ACL_FLAG_PUBLICWRITER		-  User can write public notes
	ACL_FLAG_ADMIN_SERVER		-  Entry is administration server
	ACL_FLAG_MONITORS_DISALLOWED-  User cannot register headline monitors for this database.
	ACL_FLAG_RELEASE_LOCKED_DOC -  User can release locked documents. */

	if(wAccessFlags & ACL_FLAG_SERVER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_SERVER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_GROUP) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_GROUP",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_PERSON) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_PERSON",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_AUTHOR_NOCREATE) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_AUTHOR_NOCREATE",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_NODELETE) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_NODELETE",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_CREATE_PRAGENT) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_CREATE_PRAGENT",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_CREATE_PRFOLDER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_CREATE_PRFOLDER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_CREATE_FOLDER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_CREATE_FOLDER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_CREATE_LOTUSSCRIPT) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_CREATE_LOTUSSCRIPT",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_PUBLICREADER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_PUBLICREADER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_PUBLICWRITER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_PUBLICWRITER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_ADMIN_SERVER) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_ADMIN_SERVER",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_MONITORS_DISALLOWED) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_MONITORS_DISALLOWED",TempBuffer);
	}
	if(wAccessFlags & ACL_FLAG_RELEASE_LOCKED_DOC) {
		_snprintf(TempBuffer,sizeof(TempBuffer),"%s ACL_FLAG_RELEASE_LOCKED_DOC",TempBuffer);
	}
	_snprintf(TempBuffer,sizeof(TempBuffer),"%s\n",TempBuffer);
	retval = send(GLOBALhttp_socket,TempBuffer,strlen(TempBuffer),0);

}

/*   GetAccessLevelStr - This function translates a given access level
 *                       number to the corresponding character string. 
 *                       The caller is responsible 
 *                       for providing adequate space for the string.
 *
 *   Inputs:
 *      wAccessLevel     - access level.
 *      
 *   Outputs:    
 *      pAccessLevelName - contains the returned access level name.
 */
void GetAccessLevelStr (WORD wAccessLevel, char *pAccessLevelName)
{
   switch (wAccessLevel)
   {
      case ACL_LEVEL_NOACCESS:
         strcpy (pAccessLevelName, "ACL_LEVEL_NOACCESS");
         break;
      case ACL_LEVEL_DEPOSITOR:
         strcpy (pAccessLevelName, "ACL_LEVEL_DEPOSITOR");
         break;
      case ACL_LEVEL_READER:
         strcpy (pAccessLevelName, "ACL_LEVEL_READER");
         break;
      case ACL_LEVEL_AUTHOR:
         strcpy (pAccessLevelName, "ACL_LEVEL_AUTHOR");
         break;
      case ACL_LEVEL_EDITOR:
         strcpy (pAccessLevelName, "ACL_LEVEL_EDITOR");
         break;
      case ACL_LEVEL_DESIGNER:
         strcpy (pAccessLevelName, "ACL_LEVEL_DESIGNER");
         break;
      case ACL_LEVEL_MANAGER:
         strcpy (pAccessLevelName, "ACL_LEVEL_MANAGER");
         break;
      default:
         strcpy (pAccessLevelName, "UNKNOWN");
   } /* switch */
}



// General instructions:
// $ expr `./base64 intersect.gif | wc -c` - `./base64 intersect.gif | wc -l` "*" 2 + 1
//   2029
// ./base64 intersect.gif | sed 's/^/   "/' | sed 's/.$/"  \\/' >out.txt
// 
//  mangle out.txt as appropriate - add the (wc -c) - ((wc -l)*2) + 1 figure to the buffer size.
int InterSectImage(char *source, char *dest, int size)
{
	char IntersectGif[2029];

	strncpy(IntersectGif,"R0lGODlhzQBGALMAAB8aF01JR2toZtwrGYF+fONVRo+Mi5eWleuCePKzrLOysszLy/jRzunl" \
	    "5f////j29SwAAAAAzQBGAEAI/gAdCBxIsKDBgw4eIFxIUCHDhxAjSkT4AMGAAQgmatw40CHH" \
	    "jxs9ghQJsuTEBxdTpkxgsqXLlzBjyvyoMuXMmzAB6NQp0MDOnzoDkOz504ADn0CTAniAVOlO" \
		"oQqcSgVqdKpVAARrXiyA0+XQkkCJ7jRakMDPAA3MjmUYtikAsgfV6lTw9WFYgwKACj34gIFW" \
		"jF0DCx5MeGPUsw08WtTKMqFcAGgZNghQ9ChQAQ1Kuq36s7DnzxL7/kXw4DFah6gFpk4o8ADV" \
		"Bwpjs45d1/Lau6Bz6y5YQCvXmbV3Cx++MUHvvxcZHFSgoOGB5g4WGFhAfUFmAwqqL2i94EGD" \
		"AwSZ/nNXreDA9gXmq5vvmb165sDBIcYnfjAB8gLz6ev3up+ifa0i5VeYgCEtROBIsyUIm0Gy" \
		"seZgbatFqNqEBB2nUkb9BXbXZgJN9hN0YukE10FtVYbQY1clxVmKSjW0WE0HZijRhiYetIBS" \
		"AdjVGYcUPZAXi0Bth9tBHv4EnkEWqjQUU5SxKMB2HTEFpJBXrTiVjFhO9F9NGKIIpE7g8ahZ" \
		"ZUNmaeZGL6rUkQJNfgllQmyyCKJBHJZ55p0LNZBkSr8VhN4D66mGnkGBEjRdRwcUetQB7zmw" \
		"HnraBYqddo3ieecDe2IUo6WcdtrRlkp6KuqoqmH6F34ZbkrqpZkOoOqq/7DqZmpNjcVqK55/" \
		"VSrjqyR2BmdSkSHEoVtS2TbVXkV+CQB0yho5EKgp6XorQmFJudZjBJAkZq87GfvWQo/NKWyN" \
		"8jnQwJDQXlTrtNT6KuYDN/6UmLcjGlTiWic2K68D+s5VEEq+Ycmrve6S21GbKrK1o8Edndsv" \
		"AN3ZqRrCAAiAUJopKcfuTQ0oYMChGwsU709vCuRXwAMl2+x7FF9FpVVWFhsyfMRaPBByDj0m" \
		"wMc898wzwgZYK2JLdfo6s4ytKqSzz0z3zGiIbw1cdLdH75rpbz/qC2XWci40NU9Vy4jxRWGX" \
		"/dnYA6zLWgPW8fUvTEtS5KDZoD2QLp/LpYceiP6DFqRoT1B+pxBzDk33HV2PHkloon/TLRhy" \
		"KzkuuWB9JYnh5C8N7OndgOmnOeaUN3DfgqCb9DmenDd6eulho315qpfSLRpjq7NOd6av244g" \
		"f2f+RXpH+9UON+h/6W78RpmqPXfIuMHbZAAEzMvXsCkKLdVesBnQslRPDtSv4g6MjWqWtd/l" \
		"MLDSQm0UsU5565RQD2zPYmYPL9XhXwl4JHx/NJ71k83A2xbBuiVAgpgmfSkDmmGGhLb9Yal/" \
		"Q3MAwsBHL4URkGEDWVrTeqbADW6QYvo7FfliAsFvdShIhcOg9xaGr7jUDzwPyxFB7pY/s5Ww" \
		"XocJynVUKJB7RZBBGv70oNPeQxWfcU1E3TlIAx24nxsy6IhUsSBPCphBxDyIQqvpodEKckQZ" \
		"HkSEsMtJwVpYkPMlpWQDnCIPHQDFKfFri2WkWL1MNpoeXfGOEIINbRS0PBKO8YfL0QsCV3hB" \
		"MiIkTsqKGBwNYkZ/FQRtDBCJyoAEovi56QEpiln7jheRHO4EjUkbiCebZZSRTQmTVXqjVTg5" \
		"EdecxSMnq0mfwgUR6j1FamRaJCs5ogAC9OxNaGuMl760vqLg8ja63CXcTqW0+u3QkBz5GlaU" \
		"2RVIluZDH3GLAAg0FGlSsysA45K56tedRqaILuNCJtW+eRPxqaaNKUqiJSlZF2+ys53FA6ne" \
		"PY3nzgLtM2TeqeM/jxdLGDHIY+Jim0GsQ5K2pQyNDhVZZuClnTdVlKED1UhsGNCqAWjMOdsp" \
		"j0ekQyc0OupNzBHcQJ5zKECdZ0QONQ8TOVkRyA1AV94xAOMSZYD3DEokMvVbEj2203mt5wHM" \
		"OVTfBJId7ugvoxJBm0qUZ66IdqhtbKNUdCoq0ehUCl6ZsWrbKKodh1x0kFAliFQL8NG0lm5L" \
		"CJAe3QICADs=",2029);

	return(base64decode(dest,IntersectGif,size));
}

int debracket(char *source, char *dest, int length)
{
	// This routine is simply to replace the HTML metacharacters "<" and ">" with
	// "&lt;" and "&gt;". That's all!

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) return(1);

      while(*source) 
	  {
              if(*source == '<') 
			  {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='l'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } 
			  else if(*source == '>') 
			  {
                      if(count < length) { *dest='&'; dest++; count++; }
                      if(count < length) { *dest='g'; dest++; count++; }
                      if(count < length) { *dest='t'; dest++; count++; }
                      if(count < length) { *dest=';'; dest++; count++; }
              } 
			  else 
			  {
                      if(count < length) { *dest=*source; dest++; count++;}
              }
              source++;
      }
      *dest='\0';

	  dest=copyofdest;

      return(0);
}

int DisplayTextHeader(SOCKET http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n" \
						"Server: SNARE/1.0\r\n" \
						"MIME-version: 1.0\r\n" \
						"Content-type: text/plain\r\n\r\n",
			sizeof(HTTPBuffer));
	return(send(http_socket,HTTPBuffer,strlen(HTTPBuffer),0));
}
