//#include "stdafx.h"   //Only required for the SNARE GUI
#include <windows.h>
#include <stdio.h>
#include "support.h"

//Note that these functions are self contained, since they will need to be shared
//with the "web server".

//NOTE: Retrun value of 0 = SUCCESS
//		Return value of 1 to 4 = Higher End Registry Read/Write Failure
//		Return value > 4 = Lower End Registry Read/Write Failure
//Also, return values are in binary.

int Read_Config_Registry(Reg_Config *pRegistry_struct)
{
	// Keep this at 5.. For some reason, anything less dies.
	char strdelimiter[5]="	";	
	char strclientname[SIZE_OF_CLIENTNAME]="";
	int i_return_val = 0;

	//Defaults to NULL if no hostname found, or key is out of bounds.
	if(!MyGetProfileString("Config","Clientname",strclientname,SIZE_OF_CLIENTNAME)) 
	{
		strcpy(pRegistry_struct->str_ClientName,"");
		i_return_val += 1;
	} 
	else 
	{
		strncpy(pRegistry_struct->str_ClientName,strclientname,SIZE_OF_CLIENTNAME);
	}

	//Defaults to TAB is no delimiter or out out of bounds
	if(!MyGetProfileString("Config","Delimiter",strdelimiter,2)) 
	{
		strcpy(pRegistry_struct->str_Delimiter,"	");
		//Do not return a value here since the delimiter is strictly optional
	} 
	else 
	{
		strncpy(pRegistry_struct->str_Delimiter,strdelimiter,1);
		pRegistry_struct->str_Delimiter[1]='\0';
	}

	return i_return_val;
}


int Read_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	return(0);
}

int Read_Network_Registry(Reg_Network *pRegistry_struct)
{
	char str_destination[SIZE_OF_DESTINATION] = "127.0.0.1";
	DWORD dw_Destination_port = 6161, dw_Destination_port_buffer = 6161;
	DWORD dw_Syslog = 1, dw_Syslog_buffer = 1;
	DWORD dw_Syslog_Dest = 13, dw_Syslog_Dest_buffer = 13;
	int i_return_val = 0;
  

	if(!MyGetProfileString("Network","Destination",str_destination,SIZE_OF_DESTINATION)) 
	{
		strncpy(str_destination,"localhost",SIZE_OF_DESTINATION);
		i_return_val += 1;
	}

	dw_Syslog_Dest=MyGetProfileDWORD("Network","SyslogDest",13);
	dw_Syslog=MyGetProfileDWORD("Network","Syslog",0);
	dw_Destination_port=MyGetProfileDWORD("Network","DestPort",6161);
	
	if(dw_Destination_port > 65535 || dw_Destination_port < 1) 
	{
		dw_Destination_port = 6161;
		i_return_val += 4;
	}

	//Write the values to the struct
	strncpy( pRegistry_struct->str_Destination,str_destination,SIZE_OF_DESTINATION);
	pRegistry_struct->dw_SyslogDest = dw_Syslog_Dest;
	pRegistry_struct->dw_Syslog = dw_Syslog;
	pRegistry_struct->dw_DestPort = dw_Destination_port;
	return i_return_val;
}

int Read_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	char str_restrictip[SIZE_OF_RESTRICTIP] = "127.0.0.1";
	char str_password[SIZE_OF_PASSWORD] = "password";
	DWORD dw_webport = 8080, dw_webport_buffer = 8080;
	DWORD dw_allow = 0, dw_allow_buffer = 0, dw_password = 0;
	DWORD dw_restrict = 0, dw_restrict_buffer = 0;
	DWORD dw_webportchange = 0, dw_webportchange_buffer = 0;
	int i_return_val = 0;
    
	if(!MyGetProfileString("Remote","RestrictIP",str_restrictip,SIZE_OF_RESTRICTIP)) 
	{
		strncpy(str_restrictip,"127.0.0.1",SIZE_OF_RESTRICTIP);
		i_return_val += 1;
	}

	dw_allow=MyGetProfileDWORD("Remote","Allow",0);
	dw_password=MyGetProfileDWORD("Remote","AccessKey",0);
	dw_webport=MyGetProfileDWORD("Remote","WebPort",80);
	
	if(dw_webport > 65535 || dw_webport < 1) 
	{
		dw_webport = 80;
		i_return_val += 2;
	}
	
	dw_restrict=MyGetProfileDWORD("Remote","Restrict",1);
	dw_webportchange=MyGetProfileDWORD("Remote","WebPortChange",0);

	if(!MyGetProfileString("Remote","AccessKeySet",str_password,SIZE_OF_PASSWORD)) 
	{
		strncpy(str_password,"",SIZE_OF_PASSWORD);
		i_return_val += 4;
	}

	   
   //Copy all the values into the structure
   strncpy( pRegistry_struct->str_Password,str_password,SIZE_OF_PASSWORD);
   strncpy( pRegistry_struct->str_RestrictIP,str_restrictip,SIZE_OF_RESTRICTIP);
   pRegistry_struct->dw_Restrict = dw_restrict;
   pRegistry_struct->dw_WebPortChange = dw_webportchange;
   pRegistry_struct->dw_Allow = dw_allow;
   pRegistry_struct->dw_WebPort = dw_webport;
   pRegistry_struct->dw_Password = dw_password;

   //Return the error code
   return i_return_val;
}

int Write_Config_Registry(Reg_Config *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_clientnamebuffer[SIZE_OF_CLIENTNAME]="", str_delimiterbuffer[2]="";
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, CONFIG_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_clientnamebuffer,pRegistry_struct->str_ClientName,SIZE_OF_CLIENTNAME);
	if ( RegSetValueEx(hKey, "Clientname",0,REG_SZ,
			  (CONST BYTE *) str_clientnamebuffer,strlen(str_clientnamebuffer)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//Limit the write to TWO character ONLY (including the NULL char
	strncpy(str_delimiterbuffer,pRegistry_struct->str_Delimiter,2);
	if ( RegSetValueEx(hKey, "Delimiter",0,REG_SZ,
			  (CONST BYTE *) str_delimiterbuffer,2) 
			  != ERROR_SUCCESS )
	{
		i_return_val += 0;
		//Do not return a value here since it is strictly optional
	}
		

	// Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}

int Write_Network_Registry(Reg_Network *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_destination[SIZE_OF_DESTINATION]="";
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETWORK_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_destination,pRegistry_struct->str_Destination,SIZE_OF_DESTINATION);
	if ( RegSetValueEx(hKey, "Destination",0,REG_SZ,
			  (CONST BYTE *) str_destination,strlen(str_destination)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//If DestPort is out of bounds, then it becomes 6161
	if ((pRegistry_struct->dw_DestPort < 1) | (pRegistry_struct->dw_DestPort > 65535))
		pRegistry_struct->dw_DestPort = 6161;

	if ( RegSetValueEx(hKey, "DestPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_DestPort,
			  sizeof(pRegistry_struct->dw_DestPort))
			  != ERROR_SUCCESS )
		i_return_val += 8;

	//If Syslog is out of bounds, then it becomes 1
	if ((pRegistry_struct->dw_Syslog < 0) | (pRegistry_struct->dw_Syslog > 1))
		pRegistry_struct->dw_Syslog = 1;
	if ( RegSetValueEx(hKey, "Syslog",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Syslog,
			  sizeof(pRegistry_struct->dw_Syslog))
			  != ERROR_SUCCESS )
		i_return_val += 16;

	//No error checking for the Syslog catgeory and criticality
	if ( RegSetValueEx(hKey, "SyslogDest",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_SyslogDest,
			  sizeof(pRegistry_struct->dw_SyslogDest))
			  != ERROR_SUCCESS )
		i_return_val += 32;
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Remote_Registry(Reg_Remote *pRegistry_struct)
{
	HKEY hKey;
	DWORD dwDisp, dwBytesReturned = 100; 
	int i_return_val = 0;
	char str_restrictip[SIZE_OF_RESTRICTIP]="";
	char str_password[SIZE_OF_PASSWORD]="";
    
	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) 
		!= ERROR_SUCCESS )
	{
		//The registry key does not exist and was thus unable to be opened.
		//Try and create it.
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, REMOTE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
		{
		//The registry key was unable to be created. Return.
			i_return_val += 2;
			return i_return_val;
		}
	}
		
	//Now attempt to set the registry values

	//No error checking required on this Reg Value
	strncpy(str_restrictip,pRegistry_struct->str_RestrictIP,SIZE_OF_RESTRICTIP);
	if ( RegSetValueEx(hKey, "RestrictIP",0,REG_SZ,
			  (CONST BYTE *) str_restrictip,strlen(str_restrictip)) 
			  != ERROR_SUCCESS )
		i_return_val += 4;
		
	//If WebPort is out of bounds, then it becomes 8080
	if ((pRegistry_struct->dw_WebPort < 1) | (pRegistry_struct->dw_WebPort > 65535))
		pRegistry_struct->dw_WebPort = 8080;

	if ( RegSetValueEx(hKey, "WebPort",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPort,
			  sizeof(pRegistry_struct->dw_WebPort))
			  != ERROR_SUCCESS )
		i_return_val += 8;

	//If Allow is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Allow < 0) | (pRegistry_struct->dw_Allow > 1))
		pRegistry_struct->dw_Allow = 0;

	if ( RegSetValueEx(hKey, "Allow",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Allow,
			  sizeof(pRegistry_struct->dw_Allow))
			  != ERROR_SUCCESS )
		i_return_val += 16;

	//If Password is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Password < 0) | (pRegistry_struct->dw_Password > 1))
		pRegistry_struct->dw_Password = 0;

	if ( RegSetValueEx(hKey, "AccessKey",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Password,
			  sizeof(pRegistry_struct->dw_Password))
			  != ERROR_SUCCESS )
		i_return_val += 256;


	//If Restrict is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_Restrict < 0) | (pRegistry_struct->dw_Restrict > 1))
		pRegistry_struct->dw_Restrict = 0;

	if ( RegSetValueEx(hKey, "Restrict",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_Restrict,
			  sizeof(pRegistry_struct->dw_Restrict))
			  != ERROR_SUCCESS )
		i_return_val += 32;

	//If WebPortChange is out of bounds, then it becomes 0, the default
	if ((pRegistry_struct->dw_WebPortChange < 0) | (pRegistry_struct->dw_WebPortChange > 1))
		pRegistry_struct->dw_WebPortChange = 0;

	if ( RegSetValueEx(hKey, "WebPortChange",0,REG_DWORD,
			  (CONST BYTE *) &pRegistry_struct->dw_WebPortChange,
			  sizeof(pRegistry_struct->dw_WebPortChange))
			  != ERROR_SUCCESS )
		i_return_val += 64;
		
	//No error checking required on this Reg Value
	strncpy(str_password,pRegistry_struct->str_Password,SIZE_OF_PASSWORD);
	if ( RegSetValueEx(hKey, "AccessKeySet",0,REG_SZ,
			  (CONST BYTE *) str_password,strlen(str_password)) 
			  != ERROR_SUCCESS )
		i_return_val += 128;

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Write_Objective_Registry(int i_objective_number, Reg_Objective *pRegistry_struct)
{
	return(0);
}


int Recreate_Objective_Key()
{
	HKEY hKey;
	DWORD dwDisp; 
	int i_return_val = 0;
    
	//Delete the "Objective" Registry Key 
	if ( RegDeleteKey(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME) != ERROR_SUCCESS )
	{
		//The registry key could not be deleted
		i_return_val += 1;
	}
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME,0,REG_NONE,
					       REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
						   NULL,&hKey,&dwDisp) != ERROR_SUCCESS)
	{
		//The registry key was unable to be created. Return.
		i_return_val += 2;
	}
		

	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Delete_Objective(int i_objective_number)
{
	HKEY hKey;
	int i_return_val = 0;
	char str_objective_to_delete[20] = "Objective",str_temp[10]=""; 
    
	_itoa(i_objective_number,str_temp,10);
	strncat(str_objective_to_delete,str_temp,sizeof(str_objective_to_delete) - strlen(str_objective_to_delete));

	//Open the registry key for ALL access. 
	if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, OBJECTIVE_KEY_NAME, 0, KEY_ALL_ACCESS,&hKey ) != ERROR_SUCCESS )
			return i_return_val += 1;

	if ( RegDeleteValue(hKey, str_objective_to_delete) != ERROR_SUCCESS )
		i_return_val += 2;
		
	//Close the registry key when done
	RegCloseKey(hKey);

	return i_return_val;
}


int Restart_Service() 
{

	STARTUPINFO StartupInfo;  // pointer to STARTUPINFO
	PROCESS_INFORMATION ProcessInformation,ProcessInformation2;  // pointer to PROCESS_INFORMATION
	SECURITY_ATTRIBUTES saAttr;
	HANDLE h_readInPipe, h_writeInPipe, h_readOutPipe, h_writeOutPipe;
	DWORD dw_bytes,dw_return_result,dw_error=0;
	char str_buffer[1024]="";

	//Create the pipe that will be used to read from the process
	//Also need to create a pipe that the process will write to
	saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
	saAttr.bInheritHandle = TRUE;
	saAttr.lpSecurityDescriptor = NULL;

    if (!CreatePipe(&h_readInPipe,  &h_writeInPipe, &saAttr, 0))
		dw_error += 256;
    if (!CreatePipe(&h_readOutPipe, &h_writeOutPipe, &saAttr, 0))
		dw_error += 512;

	StartupInfo.cb = sizeof(STARTUPINFO);
	StartupInfo.hStdOutput = h_writeOutPipe; 
	StartupInfo.hStdInput = h_readInPipe;  
	StartupInfo.hStdError = h_writeOutPipe;
	StartupInfo.lpTitle = NULL;
	StartupInfo.cbReserved2 = 0;
	StartupInfo.lpReserved2 = NULL;
	StartupInfo.lpReserved = NULL;
	//This must be in the defintion, or the process **__WILL NOT__** run from the toolbar.
	//STDHANDLES must be also specified.
	StartupInfo.lpDesktop = NULL;
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW | STARTF_FORCEONFEEDBACK;


	//If I can't run this process, then something is wrong.
	//You must set the 5th value to TRUE....or it won't work properly with the handles...
	//Create a process to STOP the SNARE service. 
	if (CreateProcess(NULL,"net stop snare",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation))
	{
		//Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 1;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, 1024, &dw_bytes, NULL) != 0)
			{
				if (strstr(str_buffer,"stopped successfully") == NULL)
					dw_error += 2;		
			}
			else
				dw_error += 4;		
		}
	}
	else
		dw_error += 8;		


	//Now try and restart it
	if (CreateProcess(NULL,"net start snare",NULL,NULL,TRUE,
		NORMAL_PRIORITY_CLASS,NULL,NULL,
		&StartupInfo,&ProcessInformation2))
	{
		//Wait for up to 5 seconds for process to terminate
		dw_return_result = WaitForSingleObject(ProcessInformation2.hProcess, 10000);
		if ((dw_return_result == WAIT_FAILED) || (dw_return_result == WAIT_TIMEOUT))
			dw_error += 16;		
		else
		{
			if (ReadFile(h_readOutPipe, str_buffer, 1024, &dw_bytes, NULL) != 0)
			{
				if (strstr(str_buffer,"started successfully") == NULL)
					dw_error += 32;

			}
			else
				dw_error += 64;
		}
	}
	else
		dw_error += 128;
	
    if(h_writeOutPipe) CloseHandle(h_writeOutPipe);
	if(h_readOutPipe)  CloseHandle(h_readOutPipe);

	return dw_error;
}


// Write a DWORD to the registry
BOOL MyWriteProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nValue)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_DWORD,
		(LPBYTE)&nValue, sizeof(nValue));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a DWORD from the registry
DWORD MyGetProfileDWORD(LPCTSTR lpszSection, LPCTSTR lpszEntry, DWORD nDefault)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, (LPTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)&dwValue, &dwCount);
	RegCloseKey(hSecKey);
	if (lResult == ERROR_SUCCESS)
	{
		return dwValue;
	}
	return nDefault;
}

// Write a string to the registry
BOOL MyWriteProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	LONG lResult = RegSetValueEx(hSecKey, lpszEntry, NULL, REG_SZ,
		(unsigned char *)lpszString, strlen(lpszString)+1);
//		(unsigned char *)lpszString, (strlen(lpszString)+1) * sizeof(LPCTSTR));
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get a string from the registry
BOOL MyGetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszString, DWORD dwStringBuffer)
{
	HKEY hSecKey = MyGetSectionKey(lpszSection);
	if (hSecKey == NULL)
		return TRUE;
	DWORD dwSize = dwStringBuffer;
	DWORD dwType;
	LONG lResult = RegQueryValueEx(hSecKey, (LPCTSTR)lpszEntry, NULL, &dwType,
		(LPBYTE)lpszString, &dwSize);
	RegCloseKey(hSecKey);
	return lResult == ERROR_SUCCESS;
}

// Get the setion registry key
HKEY MyGetSectionKey(LPCTSTR lpszSection)
{
	HKEY hSectionKey = NULL;
	HKEY hAppKey = MyGetServiceRegistryKey();
	if (hAppKey == NULL)
		return NULL;
	
	DWORD dw;
	RegCreateKeyEx(hAppKey, lpszSection, 0, REG_NONE,
		REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
		&hSectionKey, &dw);
	RegCloseKey(hAppKey);
	return hSectionKey;
}

HKEY MyGetServiceRegistryKey()
{
	// Store the information within the InterSect Alliance high level key.
	char m_sServiceName[256]="InterSect Alliance";
	
	HKEY hServicesKey = NULL;
	HKEY hParametersKey = NULL;
	HKEY hAppKey = NULL;
	
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE", 0, KEY_WRITE|KEY_READ,
		&hServicesKey) == ERROR_SUCCESS)
	{
		DWORD dw;
		if (RegCreateKeyEx(hServicesKey, m_sServiceName, 0, REG_NONE,
			REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
			&hAppKey, &dw) == ERROR_SUCCESS)
		{
			RegCreateKeyEx(hAppKey, "NotesAuditService", 0, REG_NONE,
				REG_OPTION_NON_VOLATILE, KEY_WRITE|KEY_READ, NULL,
				&hParametersKey, &dw);
		}
	}
	if (hServicesKey != NULL)
		RegCloseKey(hServicesKey);
	if (hAppKey != NULL)
		RegCloseKey(hAppKey);
	
	return hParametersKey;
}

int add_wildcard_start_and_end(char *source, char *dest, int length)
{
	//This routine is simply to add the wildcard "*" to the start and
	//end of a string

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) 
		  return(1);
	  else
	  {	
		  if(count < length)
		  {
			  *dest='*';
			  dest++;
			  count++;
		  }
	  }


      while(*source) 
	  {
		if(count < length)
		{ 
			*dest=*source; 
			dest++; 
			count++; 
		}
		source++;
	  }

      if((count+2) < length)
	  {
		  *dest='*';
		  dest++;
		  *dest='\0';
	  }


	  dest=copyofdest;

      return(0);
}

int remove_wildcard_start_and_end(char *source, char *dest, int length)
{
	//This routine is simply to remove the wildcard "*" to the start and
	//end of a string

      int count=0;
      char *copyofdest;
      copyofdest=dest;

      if(!source || !dest) 
		  return(1);

	  if (*source == '*')
	  {
		  source++;
		  if(count < length)
		  {
			  *dest = *source;
			  dest++;
			  count++;
			  source++;
		  }
	  }

	  while(*source)
	  {
		  if(count < length)
		  {
			  *dest = *source;
			  dest++;
			  count++;
		  }
		  source++;
	  }

	  source--;
	  dest--;
	  count--;
	  if (*source == '*')
	  {
		  if(count < length)
		  {
			  *dest = '\0';
			  dest++;
			  count++;
		  }
	  }



	  dest=copyofdest;

      return(0);
}


void read_event(char *str_buffer,char *SourceName,char *SIDType,char *EventLogType,
				char *ExpandedString,char *DataString,char *ComputerName,char *UserName,
				char *CategoryString,char *DateTime,char *Criticality,char *System,
				char *null,char *EventID)
{
	
	if(str_buffer[0]=='<') 
	{
		// SYSLOG. Slightly different header structure.
		sscanf(str_buffer,"%256[^ ] %256[^ ] %256[^\t]\t%2[^\t]\t%100[^\t]\t%256[^\t]\t%100[^\t]\t%10[^\t]\t%100[^\t]\t%256[^\t]\t%100[^\t]\t%50[^\t]\t%256[^\t]\t%256[^\t]\t%1024[^\t]\t%1024s",null,System,null,Criticality,SourceName,null,DateTime,EventID,SourceName,UserName,SIDType,EventLogType,ComputerName,CategoryString,ExpandedString,DataString);
	} 
	else 
	{
		// WARNING: If the buffer sizes of any of these change, there is a potential for buffer overflow!
		sscanf(str_buffer,"%256[^\t]\t%256[^\t]\t%2[^\t]\t%100[^\t]\t%256[^\t]\t%100[^\t]\t%10[^\t]\t%100[^\t]\t%256[^\t]\t%100[^\t]\t%50[^\t]\t%256[^\t]\t%256[^\t]\t%1024[^\t]\t%1024s",System,null,Criticality,SourceName,null,DateTime,EventID,SourceName,UserName,SIDType,EventLogType,ComputerName,CategoryString,ExpandedString,DataString);
	}

	return;
}

// return 0 for failure
// return 1 for file
// return 2 for directory
int validate_file_or_directory(char *filename)
{
	if(!filename)				return(FALSE);
	if(strlen(filename) < 3)	return(FALSE); // Must be at least "C:\"
	if(!((filename[0] >= 'a' && filename[0] <= 'z') || (filename[0] >= 'A' && filename[0] <= 'Z'))) {
		return(FALSE);
	}
	if(filename[1] != ':')		return(FALSE);
	if(filename[2] != '\\')		return(FALSE);

	// Ok, anything else is fair game.
	DWORD Attributes;
	Attributes=GetFileAttributes(filename);
	if(Attributes == 0xFFFFFFFF) {
		// File or directory does not exist
		return(FALSE);
	}
	if(Attributes & FILE_ATTRIBUTE_DIRECTORY) {
		return(2);
	}

	return(1);
}

