// snareSvrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "snaresvr.h"
#include "snareSvrDlg.h"
#include "WaitDlg.h"
#include "support.h"

#include <process.h>
#include <io.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int DebugMsg(const char* pszFormat, ...)
{
	char buf[8192];
	char date[32];
	char time[32];
	
	SYSTEMTIME st;
	FILE *fp;

	GetLocalTime(&st);
	GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"dd'/'MM'/'yyyy",date,sizeof(date));
	GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&st,"HH':'mm':'ss",time,sizeof(time));

	_snprintf(buf, 8192, "[%s](%lu - %s %s): ", "SnareGUI", GetCurrentThreadId(),date,time);
	va_list arglist;
	va_start(arglist, pszFormat);
    _vsnprintf(&buf[strlen(buf)],8192-strlen(buf)-1,pszFormat,arglist);
	va_end(arglist);
    _snprintf(buf,8192,"%s\n",buf);

	if(buf) {
		OutputDebugString(buf);
		printf("%s",buf);
		fflush(stdout);
		fp=fopen("c:\\SnareDEBUG.log","a");
		if(fp) {
			fputs(buf,fp);
			fclose(fp);
		}
	}

	return(1);
}

HANDLE hGUIPipe;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareSvrDlg dialog

CSnareSvrDlg::CSnareSvrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSnareSvrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnareSvrDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSnareSvrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnareSvrDlg)
	DDX_Control(pDX, IDC_MAIN_LIST, m_List);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSnareSvrDlg, CDialog)
	//{{AFX_MSG_MAP(CSnareSvrDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_COMMAND(ID_HELP, OnSnareSvrHelp)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_ACTIVITY_APPLYANDRESTARTAUDIT, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_VIEW_AUDITSTATUS, OnViewAuditstatus)
	ON_COMMAND(ID_SETUP_SERVERCONF, OnSetupServer)
	ON_COMMAND(ID_ACTIVITY_CLEARTHEDISPLAY, OnActivityClearthedisplay)
	ON_COMMAND(ID_TOOLBAR_COMMENTS, OnToolbarComments)
	ON_COMMAND(ID_TOOLBAR_INTERSECT, OnToolbarIntersect)
	ON_WM_TIMER()
	ON_COMMAND(ID_TOOLBAR_STATUS, OnViewAuditstatus)
	ON_COMMAND(ID_TOOLBAR_CLEARDISPLAY, OnActivityClearthedisplay)
	ON_COMMAND(ID_TOOLBAR_SERVERCONF, OnSetupServer)
	ON_COMMAND(ID_TOOLBAR_RESTART, OnActivityApplyandrestartaudit)
	ON_COMMAND(ID_HELP_COMMENTONSNARE, OnToolbarComments)
	ON_COMMAND(ID_HELP_INTERSECTALLIANCEWEBSITE, OnToolbarIntersect)
	ON_WM_SIZE()
	ON_WM_CANCELMODE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnareSvrDlg message handlers

BOOL CSnareSvrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rect;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}


	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon to TRUE
	SetIcon(m_hIcon, FALSE);		// Set small icon to FALSE
		

	DWORD dwCurType, dwViewType;
	HWND hWnd;

	dwViewType = LVS_REPORT;
	hWnd = m_List;
	GetSafeHwnd();
	dwCurType = ::GetWindowLong(hWnd,GWL_STYLE);
	dwCurType &= ~LVS_TYPEMASK;
	dwViewType |= dwCurType;
	::SetWindowLong(hWnd,GWL_STYLE,dwViewType);

	// Create the image for the main clist display
	HIMAGELIST hImageList=ImageList_Create(16,16, ILC_COLOR32, 0, 10);
	m_imgSmallIcons.Attach(hImageList);
	CBitmap dummy;
	dummy.LoadBitmap(IDB_BITMAP_SMALL);
	m_imgSmallIcons.Add(&dummy, RGB(0, 0, 0));

	// This is to add the ability to select a row, which is not available in the control.
	ListView_SetExtendedListViewStyle(m_List, LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE);  

	m_List.SetImageList(&m_imgSmallIcons,LVSIL_SMALL);
	m_List.SetImageList(&m_imgSmallIcons,LVSIL_NORMAL);

	m_List.InsertColumn(0,"Alert",LVCFMT_RIGHT,33);
	m_List.InsertColumn(1,"Event Date/Time",LVCFMT_LEFT,100);
	m_List.InsertColumn(2,"Log Type",LVCFMT_LEFT,100);
	m_List.InsertColumn(3,"Source",LVCFMT_LEFT,100);
	m_List.InsertColumn(4,"Details",LVCFMT_LEFT,512);


	// Thread start	
	StartPipe((CListCtrl *)GetDlgItem(IDC_MAIN_LIST));

	// initialise and show the toolbar
	m_wndToolBar.Create(this);
	m_wndToolBar.LoadToolBar(IDR_TOOLBAR);
	m_wndToolBar.ShowWindow(SW_SHOW);
	m_wndToolBar.SetBarStyle(CBRS_ALIGN_TOP|CBRS_TOOLTIPS|CBRS_FLYBY);

	RepositionBars(AFX_IDW_CONTROLBAR_FIRST,AFX_IDW_CONTROLBAR_LAST,0);

	// Create the ToolTip control.
	m_snare_tooltip.Create(this);
	m_snare_tooltip.Activate(TRUE);
	m_snare_tooltip.AddTool(GetDlgItem(IDC_MAIN_LIST), "This list shows the events as they are received");

	// This needs to be added since the toolbar has been "added" to the dialog box
	// Note that the comments can be found in the 'properties' section of the toolbar button
	m_wndToolBar.GetToolBarCtrl().GetItemRect(0, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_STATUS,rect,ID_TOOLBAR_STATUS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(1, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_RESTART,rect,ID_TOOLBAR_RESTART);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(3, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_SERVERCONF,rect,ID_TOOLBAR_SERVERCONF);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(5, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_CLEARDISPLAY,rect,ID_TOOLBAR_CLEARDISPLAY);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(6, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_HELP,rect,ID_HELP);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(7, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_COMMENTS,rect,ID_TOOLBAR_COMMENTS);
	m_wndToolBar.GetToolBarCtrl().GetItemRect(8, rect);
	m_snare_tooltip.AddTool(&m_wndToolBar, ID_TOOLBAR_INTERSECT,rect,ID_TOOLBAR_INTERSECT);

	// Wait for the snare service to catch up.
	Sleep(500);

	// Check if the SnareSvr pipe exists.
	hPipeSNARECORE = CreateFile("\\\\.\\PIPE\\SnareSvr",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL);

	if (hPipeSNARECORE == INVALID_HANDLE_VALUE)
	{
		MessageBox("Unable to connect to the \"SNARE Server\" service. \nCheck to see the \"SNARE Server\" service is running, or has finished restarting.\nEvents will not be displayed","SNARE Server Pipe Problem",MB_ICONERROR|MB_OK);
	} else {
		//char str_buffer[1024];
		//DWORD dwRead;

		// Not interested in an error report at this stage
		//ReadFile(hPipeSNARECORE,str_buffer,sizeof(str_buffer),&dwRead,NULL);
		CloseHandle(hPipeSNARECORE);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}



int CSnareSvrDlg::StartPipe(void *list)
{	
	if(_beginthread(ListenThread, 0, list ) == -1)
	{
		MessageBox("Unable to Start the SNARE Server Listen Thread. \nCheck to see the \"SNARE Server\" service is running.\nEvents will not be displayed","SNARE Server Pipe Problem",MB_ICONERROR|MB_OK);
		return(-1);
	}

	return(1);
}


void ListenThread(void *list)
{
	char str_buffer[MAX_EVENT]="";
	int nItem;
	DWORD dwRead;
	CListCtrl *List = (CListCtrl *)list;

	char Date[SIZE_OF_DATE]="";
	int DateSize=SIZE_OF_DATE-1;
	char System[SIZE_OF_SYSTEM]="";
	int SystemSize=SIZE_OF_SYSTEM-1;
	char LogType[SIZE_OF_LOGTYPE] = "";
	int LogTypeSize=SIZE_OF_LOGTYPE-1;
	char CriticalityStr[3];
	int CriticalitySize=2;
	int criticality=0;
	char Event[MAX_EVENT]="";

	char *systempos=NULL;
	char *logtypepos=NULL;
	char *criticalitypos=NULL;
	char *messagepos=NULL;

	BOOL read_result = FALSE;
	HANDLE hPipeSNARECOREt;
	int error = -99;

	static int ItemCount=0;

	hGUIPipe = CreateFile("\\\\.\\PIPE\\SnareSvrGUI",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL);
	
	if(hGUIPipe == INVALID_HANDLE_VALUE) {
		printf("Could not create a communications pipe to facilitate communications between the Snare GUI and the Snare Server\n");
	}
	
	while(1) 
	{
		// Keep going until we have a pipe open to the snare server.
		while(hGUIPipe == INVALID_HANDLE_VALUE) {
			// DebugMsg("guipipe is invalid.. retrying");
			hGUIPipe = CreateFile("\\\\.\\PIPE\\SnareSvrGUI",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,NULL);
			if(hGUIPipe == INVALID_HANDLE_VALUE) {
				SleepEx(5000,FALSE);
			}
		}
		// Read from pipe
		str_buffer[0]='\0';
		read_result = ReadFile(hGUIPipe,str_buffer,sizeof(str_buffer),&dwRead,NULL);
		if(read_result==0) {
			error = GetLastError();
			// DebugMsg("Error encountered: %d\n",error);
		} else {
			error=0;
		}

		if(dwRead) {
			// Terminate our read buffer with a null.
			str_buffer[dwRead]='\0';
		}

		if(read_result)
		{
			systempos=strstr(str_buffer,"	");
			if(systempos) {
				DateSize=SIZE_OF_DATE-1;
				if(systempos-str_buffer < DateSize) {
					DateSize=systempos-str_buffer;
				}
				strncpy(Date,str_buffer,DateSize);
				Date[DateSize]='\0';

				logtypepos=strstr(systempos+1,"	");
				if(logtypepos) {
					SystemSize=SIZE_OF_SYSTEM-1;
					if(logtypepos-(systempos+1) < SystemSize) {
						SystemSize=logtypepos-(systempos+1);
					}
					strncpy(System,systempos+1,SystemSize);
					System[SystemSize]='\0';

					criticalitypos=strstr(logtypepos+1,"	");
					if(criticalitypos) {
						LogTypeSize=SIZE_OF_LOGTYPE-1;
						if(criticalitypos-(logtypepos+1) < LogTypeSize) {
							LogTypeSize=criticalitypos-(logtypepos+1);
						}
						strncpy(LogType,logtypepos+1,LogTypeSize);
						LogType[LogTypeSize]='\0';

						messagepos=strstr(criticalitypos+1,"	");
						if(messagepos) {
							CriticalitySize=2;
							if(messagepos-(criticalitypos+1) < CriticalitySize) {
								CriticalitySize=messagepos-(criticalitypos+1);
							}
							strncpy(CriticalityStr,criticalitypos+1,CriticalitySize);
							CriticalityStr[CriticalitySize]='\0';
							criticality = atoi(CriticalityStr);
							strncpy(Event,messagepos+1,sizeof(Event));
							Event[sizeof(Event)-1]='\0'; // Just in case
						} else {
							criticality=0;
							// No message? No point.
							continue;
						}
					} else {
						strncpy(LogType,"Generic\0",sizeof(LogType));
					}
				} else {
					strncpy(System,"Unknown\0",sizeof(System));
				}
			} else {
				strncpy(Date,"Unknown\0",sizeof(Date));
			}
					
			if(criticality > 5) {
				criticality=5;
			}

			// Kill tabs/newlines - replace with spaces (they look ugly in the GUI)
			messagepos=Event;
			if(messagepos) {
				while(*messagepos) {
					if(*messagepos == '	' || *messagepos=='\n') {
						*messagepos=' ';
					}
					messagepos++;
				}
			}

			nItem = List->InsertItem(0,"",criticality);
			List->SetItemText(nItem,1,Date);
			List->SetItemText(nItem,2,System);	
			List->SetItemText(nItem,3,LogType);
			List->SetItemText(nItem,4,Event);

			// Display a maximum of 1000 elements.
			ItemCount=List->GetItemCount();
			if(ItemCount >= 1000) {
				List->DeleteItem(1000);
			}
			
		} else {
			// Note: 6 = The handle is invalid.  ERROR_INVALID_HANDLE  and
			// 109 = The pipe has been ended.  ERROR_BROKEN_PIPE 
			if (error == 109)
			{
				if(hGUIPipe != INVALID_HANDLE_VALUE) {
					CloseHandle(hGUIPipe);
				}
				hGUIPipe = INVALID_HANDLE_VALUE;

				// Sleep until we can connect to the SNARE PIPE.
				hPipeSNARECOREt = INVALID_HANDLE_VALUE;
				while(hPipeSNARECOREt == INVALID_HANDLE_VALUE) {
					hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\SnareSvr",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,NULL);

					if (hPipeSNARECOREt != INVALID_HANDLE_VALUE)
					{
						ReadFile(hPipeSNARECOREt,str_buffer,sizeof(str_buffer),&dwRead,NULL);
						if(dwRead) {
							// Terminate our read buffer with a null.
							str_buffer[dwRead]='\0';
						}
					} else {
						SleepEx(5000,FALSE);
					}
				}
				CloseHandle(hPipeSNARECOREt);
			} else if(error == 536) {
				SleepEx(5000,FALSE);
			} else {
				// Some other error occurred - Sleep for a moment.
				SleepEx(5000,FALSE);
			}
		}
	}
}



void CSnareSvrDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX) {
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	} else {
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CSnareSvrDlg::OnDestroy()
{
	//If you get an OnOK for the SNAREDlg, put this in
	CloseHandle(hPipeSNAREGUI);

	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSnareSvrDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSnareSvrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSnareSvrDlg::OnFileExit() 
{
	exit(EXIT_FAILURE);
	
}

void CAboutDlg::OnOK() 
{
	CDialog::OnOK();
}

void CSnareSvrDlg::OnHelpAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();

}

void CSnareSvrDlg::OnSnareSvrHelp() 
{
	ShellExecute(NULL, "open", "http://www.intersectalliance.com/resources/index.html", NULL, ".", SW_SHOWNORMAL);	
}

void CSnareSvrDlg::OnActivityApplyandrestartaudit() 
{
	int return_code = -1, return_modal = 0;
	CString str_error_msg = "The SNARE Micro Server Audit Service could not be started and/or stopped. Check that it is installed.\n";
	CWaitDlg wait_dlg;

	// This displays the "Please wait..." message
	wait_dlg.Create(IDD_WAIT_DIALOG,NULL);
	wait_dlg.ShowWindow(SW_SHOW);

	return_code = Restart_Service();

	wait_dlg.EndDialog(return_modal);

	if (return_code >= 2) {
		return_code += RESTART_SERVICE_ERROR_CODE;
		MessageBox(str_error_msg,"SNARE Server Service Problem",MB_ICONERROR|MB_OK);
	} else {
		MessageBox("The SNARE Server Audit Service was restarted successfully.","SNARE Server Service",MB_ICONINFORMATION|MB_OK);
	}
}


void CSnareSvrDlg::OnViewAuditstatus() 
{
	char str_buffer[1024]="";
	DWORD dwRead;
	HANDLE hPipeSNARECOREt;


	WaitNamedPipe("\\\\.\\PIPE\\SnareSvr",1000);
	
	// Read from the status information from the "snaresvr" pipe server

	hPipeSNARECOREt = CreateFile("\\\\.\\PIPE\\SnareSvr",GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,NULL);


	if (hPipeSNARECOREt != INVALID_HANDLE_VALUE) {

		if (ReadFile(hPipeSNARECOREt,str_buffer,sizeof(str_buffer),&dwRead,NULL) != 0) {
			if(dwRead) {
				// Terminate our read buffer with a null.
				str_buffer[dwRead]='\0';
			}
			MessageBox(str_buffer,"Status Details",MB_OK);
		} else {
			MessageBox("Unable to read the status information.","SNARE Server Status Problem",MB_ICONERROR|MB_OK);
		}
		CloseHandle(hPipeSNARECOREt);
	} else {
		MessageBox("Unable to read the status information.","SNARE Server Status Problem",MB_ICONERROR|MB_OK);
	}
}


void CSnareSvrDlg::OnSetupServer() 
{
	m_dlgConfigDialog.DoModal();	
}

void CSnareSvrDlg::OnActivityClearthedisplay() 
{
	m_List.DeleteAllItems();
}

void CSnareSvrDlg::OnToolbarComments() 
{
	ShellExecute(NULL, "open", "mailto:snare_comments@intersectalliance.com", NULL, ".", SW_SHOWNORMAL);
}

void CSnareSvrDlg::OnToolbarIntersect() 
{
	ShellExecute(NULL, "open", "http://www.intersectalliance.com", NULL, ".", SW_SHOWNORMAL);	
}

BOOL CSnareSvrDlg::PreTranslateMessage(MSG* pMsg) 
{
	// This is required for tooltip control and display
	m_snare_tooltip.RelayEvent(pMsg);
	return CDialog::PreTranslateMessage(pMsg);	
}

void CSnareSvrDlg::OnSize(UINT nType, int cx, int cy) 
{
	// Get the dialog position first.

	CDialog::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
	CListCtrl *t = (CListCtrl *)GetDlgItem(IDC_MAIN_LIST);

	if(t) {
		// Not the best way of doing this, as changes to the position of the
		// clist will stuff things up... but it will do for now.
		t->SetWindowPos(t,
			0,0,
			cx-8,cy-43,
			SWP_NOZORDER|SWP_NOMOVE);
	}
}

void CSnareSvrDlg::OnCancelMode() 
{
	CDialog::OnCancelMode();
	
	// TODO: Add your message handler code here
	
}
