/* aureport-options.h -- 
 * Copyright 2005 Red Hat Inc., Durham, North Carolina.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *   Steve Grubb <sgrubb@redhat.com>
 * 
 */

#ifndef AUREPORT_OPTIONS_H
#define AUREPORT_OPTIONS_H

#include <time.h>
#include <sys/types.h>

/* Global variables that describe what search is to be performed */
extern time_t start_time, end_time;
extern unsigned int event_id;
extern gid_t event_gid, event_egid;
extern int event_type;
extern pid_t event_pid;
extern int event_success;
extern int event_exact_match;
extern uid_t event_uid, event_euid, event_loginuid;
extern const char *event_comm;
extern const char *event_filename;
extern const char *event_hostname;
extern const char *event_terminal;
extern const char *event_context;
extern int event_syscall;
extern const char *event_exe;
extern int event_ua, event_ga;

typedef enum { RPT_UNSET, RPT_AVC, RPT_CONFIG, RPT_EVENT, RPT_FILE,
	RPT_HOST, RPT_LOGIN, RPT_ACCT_MOD, RPT_PID, RPT_SUMMARY, RPT_SYSCALL,
	RPT_TIME, RPT_TERM, RPT_USER, RPT_EXE, RPT_WATCH, RPT_ANOMALY,
	RPT_RESPONSE } report_type_t;

typedef enum { D_UNSET, D_SUM, D_DETAILED, D_SPECIFIC } report_det_t;

typedef enum { RPT_RAW, RPT_INTERP, RPT_PRETTY } report_t;

typedef enum { F_BOTH, F_FAILED, F_SUCCESS } failed_t;

extern report_type_t report_type;
extern report_det_t report_detail;
extern report_t report_format;
extern failed_t event_failed;


/* Function to process commandline options */
extern int check_params(int count, char *vars[]);

#include <stdlib.h>
#define UNIMPLEMENTED { fprintf(stderr,"Unimplemented option\n"); exit(1); }

#endif

