#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <crypt.h>
#include <pwd.h>
#include <grp.h>
#include <shadow.h>
#include <time.h>
#include <dirent.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "epilog.h"
#include "webserver.h"
#include "WebPages.h"

#define VERSION "1.1"

extern char *getfqdn(char *);
extern void trim(char *);
extern int isheader(char *);
extern int iscomment(char *);
extern int getheader(char *);
extern char *getconfstring(char *string, char *file, int length);
extern int regmatch(const char *, const char *);
extern int regmatchi(const char *, const char *);
extern int getport(char *string);
extern int splitobjective(char *, char *, int *);
extern void trimallwhitespace(char *);
extern int Send(int,char *,int);

extern char USER_CONFIG_FILENAME[MAX_AUDIT_CONFIG_LINE];
char WEB_CONFIG_FILENAME[MAX_AUDIT_CONFIG_LINE] = "\0";

// Make sure we return the size, or zero (for strings).
int HandleWebPages(char *HTTPBuffer, char *HTTPOutputBuffer, int size, int http_listen_socket, int http_message_socket)
{
	int returncode = 0;
	char *ArgPosition, *pos, *pos2, *pos3;

	// Stuff without the header/footer
	if (!strcmp(HTTPBuffer, "/intersect.gif")) {
		return (InterSectImage(HTTPBuffer, HTTPOutputBuffer, size));
	} else {
		char *pBuffer = HTTPOutputBuffer;
		int length = 0;
		int psize = 0;

		ArgPosition = strstr(HTTPBuffer, "?");
		// No arguments passed?
		if (!ArgPosition) {
			// Set argument position to the beginning of the buffer.
			ArgPosition = HTTPBuffer;
		} else {
			ArgPosition++;
		}

		returncode = DefaultHeader(HTTPBuffer, pBuffer, size);
		length = strlen(HTTPOutputBuffer);

		pBuffer += length;
		psize = size - length;
		if (psize < 0) {
			psize = 0;
		}

		// Check for a config argument, but only if you are the master
		if (strlen(USER_CONFIG_FILENAME) == 0) {
			pos2 = HTTPBuffer + 1;
			pos = strstr(pos2,"/");
			pos3 = strstr(pos2,"?");
			if (pos && (!pos3 || pos < pos3)) {
				HTTPBuffer = pos;
				strncpy(WEB_CONFIG_FILENAME, pos2, MAX_AUDIT_CONFIG_LINE);
				pos = strstr(WEB_CONFIG_FILENAME,"/");
				*pos = '\0';
			} else 
				WEB_CONFIG_FILENAME[0] = '\0';
		}
		// Web pages
		if (!strcmp(HTTPBuffer, "/network")) {
			returncode +=
			    Network_Config(ArgPosition, pBuffer, psize);
		} else if (!strcmp(HTTPBuffer, "/remote")) {
			returncode +=
			    Remote_Config(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/setremote", 10)) {
			returncode += Remote_Set(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/objective", 10)) {
			returncode +=
			    Objective_Config(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/setobjective", 13)) {
			returncode +=
			    Objective_Display(HTTPBuffer, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/changeobjective", 16)) {
			returncode +=
			    Objective_Result(HTTPBuffer, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/log", 4)) {
			returncode +=
			    Log_Config(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/setlog", 7)) {
			returncode +=
			    Log_Display(HTTPBuffer, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/changelog", 10)) {
			returncode +=
			    Log_Result(HTTPBuffer, pBuffer, psize);
		} else if (!strcmp(HTTPBuffer, "/restart")) {
			returncode +=
			    Restart(HTTPBuffer, pBuffer, psize,
				    http_listen_socket, http_message_socket);
		} else if (!strncmp(HTTPBuffer, "/setnetwork", 11)) {
			returncode += Network_Set(HTTPBuffer, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/status", 7)) {
			returncode += Status_Page(ArgPosition, pBuffer, psize);
		} else if (!strncmp(HTTPBuffer, "/switch", 7)) {
			returncode += ListConf(ArgPosition, pBuffer, psize);
		} else {
			returncode += ListConf(ArgPosition, pBuffer, psize);
		}

		pBuffer = HTTPOutputBuffer;
		length = strlen(HTTPOutputBuffer);
		pBuffer += length;
		psize = size - length;
		if (psize < 0) {
			psize = 0;
		}

		returncode += DefaultFooter(HTTPBuffer, pBuffer, psize);
	}

	return (returncode);
}

int Status_Page(char *source, char *dest, int size)
{
	if (source && dest && size) {
		snprintf(dest, size,
			"<H1><CENTER>Welcome to SNARE Epilog for UNIX version %s</H1><P>Please select from the menu on the left.</CENTER><p>\nStatus: <font color=green>Snare Epilog for UNIX currently running.</font>\n", VERSION);
	}
	return (0);
}

int Network_Config(char *source, char *dest, int size)
{
	struct Reg_Config config_struct;
	struct Reg_Host host_struct;
	int dw_config_error;
	char str_DestPort[10];
	char str_net_count[10];
	char str_conferr[10], str_neterr[10];
	int SyslogPriority, SyslogFacility;
	char *str_facility[] = {"Kernel", "User", "Mail", "Daemon", "Auth", "Syslog", "Lpr", "News", "UUCP", "Cron", "Authpriv", "Ftp", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7"};
	char *str_priority[] = {"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Information", "Debug"};
	int i;
	int i_network_count= 1;

	FILE *configfile = (FILE *) NULL;

	if (!source || !dest || !size) {
		return(0);
	}

	strcpy(config_struct.str_ClientName, "");
	strcpy(host_struct.str_NetworkDestination, "");
	host_struct.dw_DestPort = 0;
	host_struct.dw_Protocol = 0;

	dw_config_error = Read_Config_From_File(&config_struct);

	// This function will display the form used to set the audit configuration
	// The result of the form will be sent to "network_set"
	strncpy(dest,
		"<form action=setnetwork><h1><center>SNARE Configuration</h1>",
		size);

	// Will display an error if unable to completely read from the registry
	if (dw_config_error > 0) {
		dw_config_error += WEB_READ_CONFIG_ERROR_CODE;
		snprintf(str_conferr, 10, "%d", dw_config_error);

		strncat(dest,
			"<br><b>NOTE: Some errors were encountered in reading the file. Default values "
			"may be used.<br> Report error: ", size - strlen(dest));
		strncat(dest, str_neterr, size - strlen(dest));
		strncat(dest, ".", size - strlen(dest));
		strncat(dest, str_conferr, size - strlen(dest));
		strncat(dest, "</b><br>", size - strlen(dest));
	}

	strncat(dest,
		"<br>The following network configuration parameters of the SNARE unit are set to the following values (blank entries are not used):<br><br>\n"
		"<table  width=70% border=0>"
		"<tr bgcolor=#FFFFCC><td>Override detected DNS Name with:</td><td><input type=text name=str_ClientName size=25 value=\"",
		size - strlen(dest));

	strncat(dest, config_struct.str_ClientName, size - strlen(dest));
	strncat(dest, "\"></td></tr>", size - strlen(dest));

	configfile = Find_First(CONFIG_OUTPUT);
	if (configfile) {
		Get_Next_Network(configfile, &host_struct);
		snprintf(str_net_count, 10, "%d", i_network_count);
		strncat(dest,
			"<tr bgcolor=#FFFFCC><td colspan=2><strong>Destination</strong></td></tr>", size - strlen(dest));
		strncat(dest,
			"<tr bgcolor=#FFFF88><td>Destination Server address </td><td><input type=text name=str_NetworkDestination size=25 value=\"",
			size - strlen(dest));
		strncat(dest, host_struct.str_NetworkDestination,
			size - strlen(dest));
		strncat(dest, "\"></td></tr>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFF88><td>Destination Port (514 to enable syslog)</td><td><input type=text name=dw_DestPort size=8 value=\"",
			size - strlen(dest));
		if (host_struct.dw_DestPort) {
			snprintf(str_DestPort, 10, "%d", host_struct.dw_DestPort);
		} else {
			str_DestPort[0] = '\0';
		}

		strncat(dest, str_DestPort, size - strlen(dest));
		strncat(dest, "\"></td></tr>", size - strlen(dest));
		strncat(dest, "<tr bgcolor=#888888><td>Use TCP (Enable caching)?</td><td><input type=checkbox name=ptcol disabled> Available in supported version</td></tr>", size - strlen(dest));

		i_network_count++;
	} else {
		strncat(dest,
			"<tr bgcolor=#FFFF88><td colspan=2>ERROR</td></tr>",
			size - strlen(dest));
	}

	SyslogPriority = config_struct.dw_Syslog & 7;
	SyslogFacility = config_struct.dw_Syslog >> 3;
	if (SyslogFacility > 11) {
		SyslogFacility -= 4;
	}

	strncat(dest, "<tr bgcolor=#FFFFCC><td>SYSLOG Facility (optional) </td><td><select name=SyslogFacility>", size - strlen(dest));
	for (i = 0; i < 19; i++) {
		strncat(dest, "<option", size - strlen(dest));
		if (i == SyslogFacility)
			strncat(dest, " selected>", size - strlen(dest));
		else
			strncat(dest, ">", size - strlen(dest));
		strncat(dest, str_facility[i], size - strlen(dest));
	}
	strncat(dest, "</select></td></tr>", size - strlen(dest));

	strncat(dest, "<tr bgcolor=#FFFFBB><td>SYSLOG Priority (optional) </td><td><select name=SyslogPriority>", size - strlen(dest));
	for (i = 0; i < 8; i++) {
		strncat(dest, "<option", size - strlen(dest));
		if (i == SyslogPriority)
			strncat(dest, " selected>", size - strlen(dest));
		else
			strncat(dest, ">", size - strlen(dest));
		strncat(dest, str_priority[i], size - strlen(dest));
	}
	strncat(dest, "</select></td></tr>", size - strlen(dest));

	strncat(dest, "</table><br>", size - strlen(dest));
	strncat(dest, "<input type=submit value=\"Change Configuration\">    ",
		size - strlen(dest));
	strncat(dest, "<input type=reset value=\"Reset Form\"></form>",
		size - strlen(dest));

	return (0);
}

int Network_Set(char *source, char *dest, int size)
{
	char *psource = source;
	char Variable[100], web_port[100], syslog_fac[100], syslog_pri[100];
	char Argument[100];
	struct Reg_Config config_struct;
	struct Reg_Host * RHead=NULL;
	struct Reg_Host * RCurrent=NULL;
	struct Reg_Host * RTail=NULL;
	int dw_error_config = 0, i = 0;
	char *str_facility[] = {"Kernel", "User", "Mail", "Daemon", "Auth", "Syslog", "Lpr", "News", "UUCP", "Cron", "Authpriv", "Ftp", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7"};
	char *str_priority[] = {"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Information", "Debug"};
	int dw_SyslogClass = 0;
	int dw_error_port=0;

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest, "<h1><center>SNARE Configuration</h1>", size);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Checking is limited to ensuring the Detsination port in the range 1-65535.
	// The variable associated with the checkbox (dw_Syslog) must be
	// exactly "on" or it will be defaulted to "off".
	// str_Destination,str_Delimiter_Text,str_ClientName can be anything it wants to be, so long 
	// as it is within size bounds.

	strncpy(config_struct.str_ClientName, "",
		sizeof (config_struct.str_ClientName));
	strncpy(web_port, "", sizeof (web_port));

	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {

		if (strstr(Variable, "str_ClientName") != NULL) {
			strncpy(config_struct.str_ClientName, Argument,
				sizeof (config_struct.str_ClientName));
		}

		if (strstr(Variable, "str_NetworkDestination") != NULL) {
			RCurrent = (struct Reg_Host *)malloc(sizeof(struct Reg_Host));
			RCurrent->next=NULL;
			RCurrent->dw_DestPort = 0;
			RCurrent->dw_Protocol = SOCKETTYPE_UDP;
			if (RCurrent) {
				strncpy(RCurrent->str_NetworkDestination, Argument,
					sizeof (RCurrent->str_NetworkDestination));
			}
		}

		if (strstr(Variable, "dw_DestPort") != NULL) {
			strncpy(web_port, Argument, sizeof (web_port));
			if (RCurrent) {
				RCurrent->dw_DestPort = atoi(web_port);
			}
			if (strcmp(RCurrent->str_NetworkDestination, "") != 0) {
				if (RTail) {
					RTail->next=RCurrent;
					RTail=RCurrent;
				}
				if (!RHead) {
					RHead=RCurrent;
					RTail=RCurrent;
				}
			}
		}

		if (strstr(Variable, "SyslogPriority") != NULL) {
			strncpy(syslog_pri, Argument, sizeof(syslog_pri));
		}
		if (strstr(Variable, "SyslogFacility") != NULL) {
			strncpy(syslog_fac, Argument, sizeof(syslog_fac));
		}
	}

	for (i = 0; i < 8; i++) {
		if (strstr(syslog_pri, str_priority[i]) != NULL)
			config_struct.dw_Syslog = i;
	}
	for (i = 0; i < 19; i++) {
		if (strstr(syslog_fac, str_facility[i]) != NULL)
			dw_SyslogClass = i;
	}
	if (dw_SyslogClass > 11) {
		dw_SyslogClass = dw_SyslogClass + 4;
	}
	config_struct.dw_Syslog = config_struct.dw_Syslog | (dw_SyslogClass << 3);

	// Check that all the port numbers are valid
	RCurrent = RHead;
	while (RCurrent) {
		if (strlen(RCurrent->str_NetworkDestination)
		    && ((RCurrent->dw_DestPort < 1)
		    || (RCurrent->dw_DestPort > 65535))) {
			strncat(dest,
				"The Destination Port value must be between 1 and 65535. Use the 'back' button to change the value.",
				size - strlen(dest));
			dw_error_port++;
			break;
		}	
		RCurrent = RCurrent->next;
	}
	if (!dw_error_port) {
		void *rampointer = (void *) NULL;
		char *position;
		char inputbuffer[MAX_AUDIT_CONFIG_LINE];
		int headertype = 0;
		FILE *configfile;

		rampointer = Load_Config_File();

		if (!rampointer) {
			dw_error_config = 1;
		} else {
			int size = 0;
			int wroteconfig = 0;
			int skip = 0;

			position = (char *) rampointer;

			configfile = current_config("w");
			if (!configfile) {
				dw_error_config = 1;
				strncat(dest,
					"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			while ((size =
				Grab_RAMConfig_Line(position, inputbuffer,
						    MAX_AUDIT_CONFIG_LINE))) {
				trim(inputbuffer);

				// Is this line a header?
				if (isheader(inputbuffer) || skip) {
					// Jump over any lines in the headers that we're writing out.
					if (!isheader(inputbuffer)) {
						position += size;
						continue;
					}
					fprintf(configfile, "%s\n",
						inputbuffer);

					headertype = getheader(inputbuffer);
					if (headertype == CONFIG_HOSTID) {
						wroteconfig += 1;
						// WRITE OUT NEW hostid here.
						if (strlen
						    (config_struct.
						     str_ClientName)) {
							fprintf(configfile,
								"	name=%s\n",
								config_struct.
								str_ClientName);
						}
						skip = 1;
					} else if (headertype == CONFIG_OUTPUT) {
						wroteconfig += 2;
						RCurrent = RHead;
						while (RCurrent) {
							fprintf(configfile,
								"	network=%s:%d\n",
								RCurrent->
								str_NetworkDestination,
								RCurrent->
								dw_DestPort);
							RCurrent=RCurrent->next;
						}
						if (config_struct.dw_Syslog) {
							fprintf(configfile,
								"	syslog=%d\n", config_struct.dw_Syslog);
						}
						fprintf(configfile, "\n");
						skip = 1;
					} else {
						skip = 0;
					}
				} else {

					// Print this line to file.
					if (iscomment(inputbuffer)
					    || !strlen(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
					} else {
						fprintf(configfile, "	%s\n",
							inputbuffer);
					}
				}
				position += size;
			}

			if (!wroteconfig || wroteconfig == 2) {
				if (strlen(config_struct.str_ClientName)) {
					fprintf(configfile,
						"\n[HostID]\n	name=%s\n",
						config_struct.str_ClientName);
				}
			}
			if (!wroteconfig || wroteconfig == 1) {
				fprintf(configfile, "\n[Output]\n");
				RCurrent = RHead;
				while (RCurrent) {
					fprintf(configfile,
						"	network=%s:%d\n",
						RCurrent->
						str_NetworkDestination,
						RCurrent->
						dw_DestPort);
					RCurrent=RCurrent->next;
				}
				fprintf(configfile, "\n");
			}

			if (fclose(configfile)) {
				dw_error_config = 1;
				strncat(dest,
					"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			Clear_Config_File(rampointer);
		}

		if (dw_error_config != 0) {
			strncat(dest, "Values have NOT been changed.",
				size - strlen(dest));
		} else {
			strncat(dest, "Values have been changed.",
				size - strlen(dest));
		}
	}

	return (0);

}

int Remote_Config(char *source, char *dest, int size)
{
	struct Reg_Remote remote_struct;
	int dw_remote_error;
	char str_WebPort[10];
	char str_remerr[10];

	if (!source || !dest || !size) {
		return(0);
	}

	dw_remote_error = Read_Remote_From_File(&remote_struct);

	// This function will display the form used to set the remote audit configuration
	strncpy(dest,
		"<form action=setremote><h1><center>SNARE Remote Control Configuration</h1>",
		size);

	// Will display an error if unable to completely read from the registry
	if (dw_remote_error > 0) {
		dw_remote_error += WEB_READ_REMOTE_ERROR_CODE;
		// itoa(dw_remote_error,str_remerr,10);
		snprintf(str_remerr, 10, "%d", dw_remote_error);

		strncat(dest,
			"<br><b>NOTE: Some errors were encountered in reading the registry. Default values "
			"may be used.<br> Report error: ", size - strlen(dest));
		strncat(dest, str_remerr, size - strlen(dest));
		strncat(dest, "</b><br>", size - strlen(dest));
	}
	strncat(dest,
		"<br>The following remote control configuration parameters of the SNARE unit is set to the following values:<br><br>"
		"<table  width=70% border=0>"
		"<tr bgcolor=#FFFFCC><td>Allow remote control of SNARE agent</td><td><input type=checkbox name=dw_Allow",
		size - strlen(dest));

	// Need to convert this next section to YES or NO
	if (remote_struct.dw_Allow != 0) {
		strncat(dest, " checked", size - strlen(dest));
	}

	strncat(dest, "></td></tr><tr bgcolor=#FFFFFF><td><br></td></tr>",
		size - strlen(dest));
	strncat(dest,
		"<tr bgcolor=#FFFFBB><td>Restrict remote control of SNARE agent to certain hosts </td><td><input type=checkbox name=dw_Restrict",
		size - strlen(dest));

	// Need to convert this next section to YES or NO
	if (remote_struct.dw_Restrict != 0)
		strncat(dest, " checked", size - strlen(dest));
	strncat(dest, "></td></tr>", size - strlen(dest));

	strncat(dest,
		"<tr bgcolor=#FFFFCC><td>IP Address allowed to remote control SNARE </td><td><input type=text name=str_RestrictIP size=12 value=\"",
		size - strlen(dest));
	strncat(dest, remote_struct.str_RestrictIP, size - strlen(dest));
	strncat(dest, "\"></td></tr>", size - strlen(dest));

	strncat(dest,
		"<tr bgcolor=#FFFFBB><td>Require a password for remote control? </td><td><input type=checkbox name=dw_Password",
		size - strlen(dest));

	// Need to convert this next section to YES or NO
	if (remote_struct.dw_Password != 0)
		strncat(dest, " checked", size - strlen(dest));
	strncat(dest, "></td></tr>", size - strlen(dest));

	strncat(dest,
		"<tr bgcolor=#FFFFCC><td>Password to allow remote control of SNARE </td><td><input type=password name=str_Password size=12 value=\"",
		size - strlen(dest));
	strncat(dest, remote_struct.str_Password, size - strlen(dest));
	strncat(dest, "\"><input type=hidden name=str_OldPassword value=\"", size - strlen(dest));
	strncat(dest, remote_struct.str_Password, size - strlen(dest));
	strncat(dest, "\"></td></tr>", size - strlen(dest));

	strncat(dest,
		"<tr bgcolor=#FFFFCC><td>Web Server Port </td><td><input type=text name=dw_WebPort size=8 value=\"",
		size - strlen(dest));
	snprintf(str_WebPort, 10, "%d", remote_struct.dw_WebPort);
	strncat(dest, str_WebPort, size - strlen(dest));
	strncat(dest, "\"></td></tr>", size - strlen(dest));

	strncat(dest, "</table><br>", size - strlen(dest));
	strncat(dest, "<input type=submit value=\"Change Configuration\">    ",
		size - strlen(dest));
	strncat(dest, "<input type=reset value=\"Reset Form\"></form>",
		size - strlen(dest));

	return (0);
}

int Remote_Set(char *source, char *dest, int size)
{
	char *psource = source;
	char Variable[100], web_port[100];
	char Argument[100];
	char OldPassword[100] = "";
	struct Reg_Remote remote_struct;
	int dw_error = 0;

	dw_error = Read_Remote_From_File(&remote_struct);

	// This function will display that the remote audit configurations have been changed, or there have been errors
	strncpy(dest, "<h1><center>SNARE Remote Control Configuration</h1>",
		size);

	// Note that all the possible variables do NOT have to be in the URL. The ones that are selected
	// via a checkbox will not be listed if the checkbox has been deselected.
	// Also be aware that there may not be any arguments for this objective. If a sysadmin does not want
	// remote control, then there will be no arguments.
	// Hence: Checking is limited to Webport in the range 1-65535 only if portchange is "on"
	// The three variable associated with the checkboxes (dw_Allow, dw_Restrict, and dw_PortChange) must be
	// exactly "on" or they will be defaulted to "off".
	// str_RestrictIP can be anything it wants to be, so long as it is within size bounds.

	remote_struct.dw_WebPort = -1;
	remote_struct.dw_Allow = 0;
	remote_struct.dw_Password = 0;
	remote_struct.dw_Restrict = 0;

	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {

		if (strstr(Variable, "dw_WebPort") != NULL) {
			strncpy(web_port, Argument, sizeof (web_port));
		}
		if (strstr(Variable, "str_RestrictIP") != NULL) {
			strncpy(remote_struct.str_RestrictIP, Argument,
				sizeof (remote_struct.str_RestrictIP));
		}
		if (strstr(Variable, "str_Password") != NULL) {
			if (strcmp(Argument, remote_struct.str_Password) != 0) {
				strncpy(remote_struct.str_Password, Argument, sizeof(remote_struct.str_Password));

			}
		}

		if (strstr(Variable, "str_OldPassword") != NULL) {
			strncpy(OldPassword, Argument, sizeof(OldPassword));
		}
		if (strstr(Variable, "dw_Allow") != NULL) {
			if (strcmp(Argument, "on") == 0)
				remote_struct.dw_Allow = 1;
			else
				remote_struct.dw_Allow = 0;
		}
		if (strstr(Variable, "dw_Password") != NULL) {
			if (strcmp(Argument, "on") == 0) {
				remote_struct.dw_Password = 1;
			} else {
				remote_struct.dw_Password = 0;
			}
		}
		if (strstr(Variable, "dw_Restrict") != NULL) {
			if (strcmp(Argument, "on") == 0)
				remote_struct.dw_Restrict = 1;
			else
				remote_struct.dw_Restrict = 0;
		}
	}

	remote_struct.dw_WebPort = atoi(web_port);
	if ((remote_struct.dw_WebPort < 1)
	    || (remote_struct.dw_WebPort > 65535)) {
		strncat(dest,
			"The Web Port value must be between 1 and 65535. Use the 'back' button to change the value.",
			size - strlen(dest));
	} else {
		void *rampointer = (void *) NULL;
		char *position;
		char inputbuffer[MAX_AUDIT_CONFIG_LINE];
		int headertype = 0;
		FILE *configfile = (FILE *)NULL;

		rampointer = Load_Config_File();

		if (!rampointer) {
			dw_error = 1;
		} else {
			int size = 0;
			int wroteconfig = 0;
			int skip = 0;

			position = (char *) rampointer;

			configfile = current_config("w");
			if (!configfile) {
				dw_error = 1;
				strncat(dest,
					"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			while ((size =
				Grab_RAMConfig_Line(position, inputbuffer,
						    MAX_AUDIT_CONFIG_LINE))) {

				trim(inputbuffer);

				// Is this line a header?
				if (isheader(inputbuffer) || skip) {
					// Jump over any lines in the headers that we're writing out.
					if (!isheader(inputbuffer)) {
						position += size;
						continue;
					}

					fprintf(configfile, "%s\n",
						inputbuffer);

					headertype = getheader(inputbuffer);

					if (headertype == CONFIG_REMOTE) {
						wroteconfig = 1;

						if (remote_struct.dw_Allow) {
							fprintf(configfile,
								"	allow=1\n");
						}
						if (remote_struct.dw_WebPort) {
							fprintf(configfile,
								"	listen_port=%d\n",
								remote_struct.
								dw_WebPort);
						}
						if (strlen
						    (remote_struct.
						     str_RestrictIP)
						    && remote_struct.
						    dw_Restrict) {
							fprintf(configfile,
								"	restrict_ip=%s\n",
								remote_struct.
								str_RestrictIP);
						}
						// Reject passwords with backslashes.
						if (strlen
						    (remote_struct.str_Password)
						    && remote_struct.
						    dw_Password) {
							if (strstr(remote_struct.str_Password, "\\")) {
								strncat(dest,
									"Sorry, passwords with the backslash character are not allowed.<br>Please use the Back Button, and try another password.<br> The other ",
									size - strlen(dest));
								fprintf(configfile,
									"	accesskey=%s\n",
									OldPassword);

							} else {
								if (strcmp(remote_struct.str_Password,OldPassword)) {
									char *tpass;
									// The password has changed. Encrypt it.
									tpass = crypt(remote_struct.str_Password,SALT);
									if (tpass) {
										fprintf(configfile,
											"	accesskey=%s\n",
											tpass);
									} else {
										// Crypt failed. Fallback to whatever the user had before.
										fprintf(configfile,
											"	accesskey=%s\n",
											remote_struct.str_Password);
									}
								} else {
									// Otherwise, leave it in peace
									fprintf(configfile,
										"	accesskey=%s\n",
										remote_struct.str_Password);
								}
							}
						}
						skip = 1;
					} else {
						skip = 0;
					}
				} else {
					// Print this line to file.
					if (iscomment(inputbuffer)
					    || !strlen(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
					} else {
						fprintf(configfile, "	%s\n",
							inputbuffer);
					}
				}
				position += size;
			}

			if (!wroteconfig) {
				fprintf(configfile, "\n[Remote]\n");

				if (remote_struct.dw_Allow) {
					fprintf(configfile, "	allow=1\n");
				}
				if (remote_struct.dw_WebPort) {
					fprintf(configfile,
						"	listen_port=%d\n",
						remote_struct.dw_WebPort);
				}
				if (strlen(remote_struct.str_RestrictIP)
				    && remote_struct.dw_Restrict) {
					fprintf(configfile,
						"	restrict_ip=%s\n",
						remote_struct.str_RestrictIP);
				}
				if (strlen(remote_struct.str_Password)
				    && remote_struct.dw_Password) {
					fprintf(configfile, "	accesskey=%s\n",
						(char *)crypt(remote_struct.str_Password, SALT));
				}
				fprintf(configfile, "\n");
			}

			if (fclose(configfile)) {
				dw_error = 1;
				strncat(dest,
					"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			Clear_Config_File(rampointer);
		}

		if (dw_error != 0) {
			strncat(dest,
				"Remote Control Values have NOT been changed. Report an error.",
				size - strlen(dest));
		} else {
			strncat(dest,
				"Remote Control Values have been changed.",
				size - strlen(dest));
		}
	}

	return (0);
}

int Objective_Config(char *source, char *dest, int size)
{
	struct Reg_Objective reg_objective;
	int i_objective_count = 0;
	char str_obj_count[10];
	char str_general_match_metachar_remove[SIZE_OF_GENERALMATCH * 2];

	FILE *configfile = (FILE *) NULL;

	if (!source || !dest || !size) {
		return(0);
	}

	strncpy(dest,
		"<form action=setobjective><H1><CENTER>SNARE Filtering Objectives Configuration</H1>",
		size);

	configfile = Find_First(CONFIG_OBJECTIVES);

	if (configfile) {
		strncat(dest,
			"<br>The following filtering objectives of the SNARE unit are active:<br><br>"
			"<table  width=100% border=1>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFBB><center><td width=\"10%\"><b>Action Required</b></td>"
			"<td width=\"90%\"><b>Search Term</b>"
			"</td></center></tr>", size - strlen(dest));

		while (Get_Next_Objective(configfile, &reg_objective)) {
			snprintf(str_obj_count, 10, "%d", i_objective_count);

			if ((i_objective_count) == 0)
				strncat(dest,
					"<tr bgcolor=#FFFFCC><td><input type=submit name=",
					size - strlen(dest));
			else
				strncat(dest,
					"<tr bgcolor=#FFFFBB><td><input type=submit name=",
					size - strlen(dest));

			strncat(dest, str_obj_count, size - strlen(dest));
			strncat(dest, " value=Delete>     ",
				size - strlen(dest));

			strncat(dest, "<input type=submit name=",
				size - strlen(dest));
			strncat(dest, str_obj_count, size - strlen(dest));
			strncat(dest, " value=Modify>", size - strlen(dest));
			strncat(dest, "</td><td>", size - strlen(dest));

			// Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			// need to be replaced. This is done with the "debracket" routine.
			// Note that the new strings are allowed to be twice as long as the real strings
			debracket(reg_objective.str_general_match,
				  str_general_match_metachar_remove,
				  SIZE_OF_GENERALMATCH * 2);

			if (strlen(reg_objective.str_general_match) == 0) {
				strncat(dest, "&nbsp", size - strlen(dest));
			} else {
				strncat(dest, str_general_match_metachar_remove,
					size - strlen(dest));
			}
			strncat(dest, "</td></tr>", size - strlen(dest));

			i_objective_count++;
		}
		Close_File(configfile);
		strncat(dest, "</table><br>", size - strlen(dest));
	} else {
		strncat(dest,
			"<br>There are no current filtering objectives active.<br><br>",
			size - strlen(dest));
	}

	strncat(dest, "Select this button to add a new objective.  ",
		size - strlen(dest));
	strncat(dest, "<input type=submit name=0", size - strlen(dest));
	strncat(dest, " value=Add>", size - strlen(dest));

	return (0);
}

int Objective_Display(char *source, char *dest, int size)
{
	struct Reg_Objective reg_objective;
	int dw_objective_error = 0, dw_objective_delete_error = 0;
	char str_objerr[10];
	int i_objective_count = 0, i_type = 0;
	char *psource = source, Variable[100], Argument[100];
	char str_temp[20], str_temp_objective[10];

	// This function will display an existing, or a blank, objective
	strncpy(dest,
		"<form action=changeobjective><h1><center>SNARE Filtering Objective Configuration</h1>",
		size);

	// Determine whether the objective will be modified or deleted
	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {
		if (strstr(Argument, "Delete") != NULL) {
			sscanf(Variable, "%20[^?]?%10[^\n]\n", str_temp,
			       str_temp_objective);
			i_type = 0;
			break;
		}
		if (strstr(Argument, "Modify") != NULL) {
			sscanf(Variable, "%20[^?]?%10[^\n]\n", str_temp,
			       str_temp_objective);
			i_type = 1;
			break;
		}
		if (strstr(Argument, "Add") != NULL) {
			strncpy(str_temp_objective, "-2",
				sizeof (str_temp_objective));
			i_type = 2;
			break;
		}
	}

	// Extract the objective number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_objective, "0") == 0)
		i_objective_count = -1;
	else
		i_objective_count = atoi(str_temp_objective);

	// If the objective number could not be successfully extracted, return immediately.
	if (i_objective_count == 0) {
		strncat(dest,
			"<br><b>NOTE: It appears the URL is encoded incorrectly.",
			size - strlen(dest));
		return 0;
	}

	if (i_objective_count == -1)
		i_objective_count = 0;

	// If the objective is being modified or added
	if (i_type > 0) {
		if (i_type == 1) {
			int count = 0;
			int returncode;
			FILE *configfile;
			configfile = Find_First(CONFIG_OBJECTIVES);
			while ((returncode =
				Get_Next_Objective(configfile, &reg_objective)))
			{
				if (count == i_objective_count)
					break;
				count++;
			}
			if (!(count == i_objective_count && returncode)) {
				dw_objective_error =
				    WEB_READ_OBJECTIVE_ERROR_CODE;
			}
			Close_File(configfile);
		} else {
			// Defaults
			strncpy(reg_objective.str_general_match, ".*",
				sizeof (reg_objective.str_general_match));
			strncpy(reg_objective.str_general_match_type, "Any",
				sizeof (reg_objective.str_general_match_type));
		}

		// Will display an error if unable to completely read from the config file
		if (dw_objective_error > 0) {
			dw_objective_error += WEB_READ_OBJECTIVE_ERROR_CODE;
			snprintf(str_objerr, 10, "%d", dw_objective_error);

			strncat(dest,
				"<br><b>NOTE: Some errors were encountered in reading the configuration file. Default values "
				"may be used.<br> Report error: ",
				size - strlen(dest));
			strncat(dest, str_objerr, size - strlen(dest));
			strncat(dest, "</b><br>", size - strlen(dest));
		}

		strncat(dest,
			"<br>The following parameters of the SNARE objective may be set:<br><br>"
			"<table  width=100% border=0>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFCC><td>Select the General Match Type</td><td>",
			size - strlen(dest));
		strncat(dest,
			"<input type=radio name=str_general_match_type value=Any",
			size - strlen(dest));

		if (strcmp(reg_objective.str_general_match, ".*") == 0) {
			strncat(dest, " checked", size - strlen(dest));
			strncpy(reg_objective.str_general_match_type, "Any", sizeof(reg_objective.str_general_match_type));
		}
		strncat(dest, ">Match Any String    ", size - strlen(dest));
		strncat(dest,
			"<input type=radio name=str_general_match_type value=Include",
			size - strlen(dest));
		if (strstr(reg_objective.str_general_match_type, "Include") !=
		    NULL) {
			strncat(dest, " checked", size - strlen(dest));
		}
		strncat(dest,
			">Include    <input type=radio name=str_general_match_type value=Exclude",
			size - strlen(dest));

		if (strstr(reg_objective.str_general_match_type, "Exclude") !=
		    NULL)
			strncat(dest, " checked", size - strlen(dest));
		strncat(dest, ">Exclude    </td></tr>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFBB><td>Search Term<br><i>(regular expression)</i></td><td><input type=text name=str_general_match size=50 value=\"",
			size - strlen(dest));
		strncat(dest, reg_objective.str_general_match,
			size - strlen(dest));
		strncat(dest, "\"></td></tr>", size - strlen(dest));

		strncat(dest, "</table><br>", size - strlen(dest));
		strncat(dest, "<input type=hidden name=objnumber value=",
			size - strlen(dest));
		strncat(dest, str_temp_objective, size - strlen(dest));	// Objective number goes here
		strncat(dest,
			"><input type=submit value=\"Change Configuration\">    ",
			size - strlen(dest));
		strncat(dest, "<input type=reset value=\"Reset Form\"></form>",
			size - strlen(dest));
	} else {
		void *rampointer = (void *) NULL;
		char *position;
		char inputbuffer[MAX_AUDIT_CONFIG_LINE];
		int headertype = 0;
		FILE *configfile;

		rampointer = Load_Config_File();
		if (!rampointer) {
			dw_objective_error = WEB_READ_CONFIG_ERROR_CODE;
			dw_objective_delete_error = 1;
		} else {
			int objectivecounter = 0;
			int size = 0;

			position = (char *) rampointer;

			configfile = current_config("w");
			if (!configfile) {
				strncat(dest,
					"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			while ((size =
				Grab_RAMConfig_Line(position, inputbuffer,
						    MAX_AUDIT_CONFIG_LINE))) {
				trim(inputbuffer);

				if (headertype == CONFIG_OBJECTIVES) {
					if (objectivecounter ==
					    i_objective_count) {
						// Do not add this line back into the original file.
						position += size;
						objectivecounter++;
						continue;
					}
					objectivecounter++;
				}

				if (!iscomment(inputbuffer)) {
					// Is this line a header?
					if (isheader(inputbuffer)) {
						headertype =
						    getheader(inputbuffer);
					}
				}
				// Print this line to file.
				if (isheader(inputbuffer)
				    || iscomment(inputbuffer)
				    || !strlen(inputbuffer)) {
					fprintf(configfile, "%s\n",
						inputbuffer);
				} else {
					fprintf(configfile, "	%s\n",
						inputbuffer);
				}

				// position+=strlen(inputbuffer)+1;
				position += size;
			}
			if (fclose(configfile)) {
				dw_objective_delete_error = 1;
				strncat(dest,
					"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			Clear_Config_File(rampointer);
		}

		if (dw_objective_delete_error == 0)
			strncat(dest,
				"<br><b>The objective has been removed<br><a href=\"objective\">Return to Objective display</a>.",
				size - strlen(dest));
		else
			strncat(dest,
				"<br>The objective was unable to be deleted.",
				size - strlen(dest));
	}

	return (0);
}

int Grab_RAMConfig_Line(char *source, char *dest, int size)
{
	int count = 0;

	if (!source || !dest || !size) {
		return (0);
	}

	while (*source && count < size) {
		*dest = *source;
		if (*source == '\n') {
			dest++;
			count++;
			break;
		}
		count++;
		dest++;
		source++;
	}
	*dest = '\0';
	if (*source == '\0') {
		return (0);
	}
	return (count);
}

void *Load_Config_File()
{
	FILE *configfile;
	char *location;
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	long filesize = 0;
	int configsize = 0;

	configfile = current_config("r");
	if (!configfile) {
		return ((void *) NULL);
	}

	if (fseek(configfile, 0, SEEK_END)) {
		fclose(configfile);
		return ((void *) NULL);
	}

	filesize = ftell(configfile);
	if (!filesize) {
		fclose(configfile);
		return ((void *) NULL);
	}

	if (fseek(configfile, 0, SEEK_SET)) {
		fclose(configfile);
		return ((void *) NULL);
	}

	location = malloc(filesize + 1);

	if (!location) {
		fclose(configfile);
		return ((void *) NULL);
	}

	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		if ((configsize + strlen(inputbuffer)) > filesize) {
			// We have run out of room.
			free(location);
			fclose(configfile);
			return ((void *) NULL);
		}
		strcpy(location + configsize, inputbuffer);	// Safe from overflow due to above check.
		configsize += strlen(inputbuffer);
	}

	fclose(configfile);

	return (location);
}

void Clear_Config_File(void *location)
{
	if (!location)
		return;

	free(location);
}

int Objective_Result(char *source, char *dest, int size)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	struct Reg_Objective reg_objective;
	int dw_objective_error = 0;
	int i_objective = 0;
	char str_obj_count[10];
	char *psource = source, Variable[100], Argument[100];

	strncpy(dest,
		"<form action=setobjective><H1><CENTER>SNARE Filtering Objectives Configuration</H1>",
		size);

	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {

		if (strstr(Variable, "str_general_match") != NULL) {
			strncpy(reg_objective.str_general_match, Argument,
				sizeof (reg_objective.str_general_match));
		}
		
		if (strstr(Variable, "objnumber") != NULL) {
			strncpy(str_obj_count, Argument,
				sizeof (str_obj_count));
		}
		if (strstr(Variable, "str_general_match_type") != NULL) {
			strncpy(reg_objective.str_general_match_type, Argument,
				sizeof (reg_objective.str_general_match_type));
		}
	}

	if (!dw_objective_error) {

		i_objective = atoi(str_obj_count);

		//-2 = "Add a new objective"
		if (i_objective == -2) {
			void *rampointer = (void *) NULL;
			char *position;
			char inputbuffer[MAX_AUDIT_CONFIG_LINE];
			int headertype = 0;
			FILE *configfile;

			rampointer = Load_Config_File();
			if (!rampointer) {
				dw_objective_error = WEB_READ_CONFIG_ERROR_CODE;
			} else {
				int size = 0;
				int wroteconfig = 0;

				position = (char *) rampointer;

				configfile = current_config("w");
				if (!configfile) {
					dw_objective_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				while ((size =
					Grab_RAMConfig_Line(position,
							    inputbuffer,
							    MAX_AUDIT_CONFIG_LINE)))
				{
					trim(inputbuffer);

					// Is this line a header?
					if (isheader(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
						headertype =
						    getheader(inputbuffer);
						if (headertype ==
						    CONFIG_OBJECTIVES) {
							char generalstring[8];
							// WRITE OUT NEW OBJECTIVE HERE

							if (strstr(reg_objective.str_general_match_type,"Any") != NULL) {
								strncpy(generalstring, "match", sizeof(generalstring));
								strncpy(reg_objective.str_general_match,".*",sizeof(reg_objective.str_general_match));
							} else {
								if (strstr(reg_objective.str_general_match_type,"Include") != NULL) {
									strncpy(generalstring, "match", sizeof(generalstring));
								} else {
									strncpy(generalstring, "match!", sizeof(generalstring));
								}
							}

							fprintf(configfile,
								"	%s=%s\n",
								generalstring,
								reg_objective.str_general_match);

							wroteconfig = 1;
						}
					} else {

						// Print this line to file.
						if (iscomment(inputbuffer)
						    || !strlen(inputbuffer)) {
							fprintf(configfile,
								"%s\n",
								inputbuffer);
						} else {
							fprintf(configfile,
								"	%s\n",
								inputbuffer);
						}
					}
					position += size;
				}

				if (!wroteconfig) {
					// Must not have been an objective header in the file...
					char generalstring[8];
					// WRITE OUT NEW OBJECTIVE HERE

					if (strstr(reg_objective.str_general_match_type,"Any") != NULL) {
						strncpy(generalstring, "match", sizeof(generalstring));
						strncpy(reg_objective.str_general_match,".*",sizeof(reg_objective.str_general_match));
					} else {
						if (strstr(reg_objective.str_general_match_type,"Include") != NULL) {
							strncpy(generalstring, "match", sizeof(generalstring));
						} else {
							strncpy(generalstring, "match!", sizeof(generalstring));
						}
					}


					fprintf(configfile,
						"\n\n[Objectives]\n	%s=%s\n",
						generalstring,
						reg_objective.
						str_general_match);
				}

				if (fclose(configfile)) {
					dw_objective_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				Clear_Config_File(rampointer);
			}
		} else {
			// Modify an existing objective
			void *rampointer = (void *) NULL;
			char *position;
			char inputbuffer[MAX_AUDIT_CONFIG_LINE];
			int headertype = 0;
			FILE *configfile;

			rampointer = Load_Config_File();
			if (!rampointer) {
				dw_objective_error = WEB_READ_CONFIG_ERROR_CODE;
			} else {
				int objectivecounter = 0;
				int size = 0;

				position = (char *) rampointer;

				configfile = current_config("w");
				if (!configfile) {
					dw_objective_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				while ((size =
					Grab_RAMConfig_Line(position,
							    inputbuffer,
							    MAX_AUDIT_CONFIG_LINE)))
				{
					trim(inputbuffer);

					if (headertype == CONFIG_OBJECTIVES) {
						if (objectivecounter ==
						    i_objective) {
							// Replace this objective with the new version.
							char generalstring[8];
							// WRITE OUT NEW OBJECTIVE HERE

							if (strstr(reg_objective.str_general_match_type,"Any") != NULL) {
								strncpy(generalstring, "match", sizeof(generalstring));
								strncpy(reg_objective.str_general_match,".*",sizeof(reg_objective.str_general_match));
							} else {
								if (strstr(reg_objective.str_general_match_type,"Include") != NULL) {
									strncpy(generalstring, "match", sizeof(generalstring));
								} else {
									strncpy(generalstring, "match!", sizeof(generalstring));
								}
							}

							fprintf(configfile,
								"	%s=%s\n",
								generalstring,
								reg_objective.str_general_match);

							position += size;
							objectivecounter++;
							continue;
						}
						objectivecounter++;
					}

					if (!iscomment(inputbuffer)) {
						// Is this line a header?
						if (isheader(inputbuffer)) {
							headertype =
							    getheader
							    (inputbuffer);
						}
					}
					// Print this line to file.
					if (isheader(inputbuffer)
					    || iscomment(inputbuffer)
					    || !strlen(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
					} else {
						fprintf(configfile, "	%s\n",
							inputbuffer);
					}

					// position+=strlen(inputbuffer)+1;
					position += size;
				}

				if (fclose(configfile)) {
					dw_objective_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				Clear_Config_File(rampointer);
			}
		}

		if (dw_objective_error == 0)
			strncat(dest,
				"<br>The objective has been modified/added.",
				size - strlen(dest));
		else
			strncat(dest,
				"<br>The objective was unable to be modified/added.",
				size - strlen(dest));
	}

	return (0);
}

int DefaultHeader(char *source, char *dest, int size)
{

	if (!source || !dest || !size) {
		return(0);
	}

	strncpy(dest, "<HTML><head>"
		"<title>InterSect Alliance - Information Technology Security</title>"
		"<meta name=\"TITLE\" content=\"InterSect Alliance - Information Technology Security\">"
		"<style type=\"text/css\">\n"
		"body {\n"
		" font-family: Verdana,Helvetica,sans-serif;\n"
		" font-size: 10px; font-weight: normal;\n"
		" margin: 0px;\n"
		"}\n"
		"font {\n"
		" font-family: Verdana,Helvetica,sans-serif;\n"
		" text-decoration: none; font-size: 10px;\n"
		" font-weight: normal;\n"
		"}\n"
		"table {\n"
		" margin: 0px; padding: 0px;\n"
		"}\n"
		"td {\n"
		" font-size: 75%;\n"
		"}\n"
		"</style>\n"
		"</head>"
		"<body text=black bgcolor=white link=#000066 vlink=#000044 alink=#000055>"
		"<table border=0 cellspacing=0 cellpadding=0 width=100%>\n"
		"<tbody>\n"
		" <tr>\n"
		"  <td height=70><img src=/intersect.gif alt=\"InterSect\" width=205 height=70 hspace=20 vspace=0 border=0 align=Right>"
		"</td>\n"
		"   <td height=70 width=1% bgcolor=#eeeeee><br></td>"
		"   <td height=70 width=1% bgcolor=#dddddd><br></td>"
		"   <td height=70 width=1% bgcolor=#cccccc><br></td>"
		"   <td height=70 width=1% bgcolor=#ccbbbb><br></td>"
		"   <td height=70 width=1% bgcolor=#ccaaaa><br></td>"
		"   <td height=70 width=1% bgcolor=#cc9999><br></td>"
		"   <td height=70 width=1% bgcolor=#cc8888><br></td>"
		"   <td height=70 width=1% bgcolor=#cc7777><br></td>"
		"   <td height=70 width=1% bgcolor=#cc6666><br></td>"
		"   <td height=70 width=1% bgcolor=#cc5555><br></td>"
		"   <td height=70 width=1% bgcolor=#cc4444><br></td>"
		"   <td height=70 width=1% bgcolor=#cc3333><br></td>"
		"   <td height=70 width=1% bgcolor=#cc2222><br></td>"
		"   <td height=70 width=1% bgcolor=#cc1111><br></td>\n"
		"   <td height=70 width=86% bgcolor=#cc0000><font color=white><center><h1>SNARE Epilog for UNIX</h1></center></font></td>\n"
		" </tr>\n"
		"</tbody>\n"
		"</table>\n"
		"<table border=0 cellspacing=0 cellpadding=0 width=100%>\n"
		" <tr><td height=3 bgcolor=white width=100%></td></tr>\n"
		" <tr><td height=3 bgcolor=black width=100%></td></tr>\n"
		" <tr><td height=2 bgcolor=#AAAAAA width=100%></td></tr>\n"
		" <tr><td height=2 bgcolor=white width=100%></td></tr>\n"
		"</table>\n"
		"<table border=0 cellspacing=0 cellpadding=5 width=100% height=100%>\n"
		"<tbody>\n"
		" <tr>\n"
		"  <td valign=Top width=20% bgcolor=#cc0000>\n"
		"   <div align=Center><font color=#ffffff>\n"
		"   <br>\n"
		"   <font face=\"Helvetica,Arial,sans-serif\" size=-1><B>\n", size);
		if (USER_CONFIG_FILENAME[0] == '\0')
			strncat(dest,"   <br><A HREF=\"switch\" style=\"color:FFFFFF;text-decoration:none\">Switch Configuration Files</A><br>\n", size);
		strncat(dest,"   <br><A HREF=\"log\" style=\"color:FFFFFF;text-decoration:none\">Log Configuration</A><br>\n"
		"   <br><A HREF=\"network\" style=\"color:FFFFFF;text-decoration:none\">Network Configuration</A><br>\n"
		"   <br><A HREF=\"remote\" style=\"color:FFFFFF;text-decoration:none\">Remote Control Configuration</A><br>\n"
		"   <br><A HREF=\"objective\" style=\"color:FFFFFF;text-decoration:none\">Objectives Configuration</A><br>\n"
		"   <br><A HREF=\"status\" style=\"color:FFFFFF;text-decoration:none\">View Audit Service Status</A><br>\n"
		"   <br><A HREF=\"restart\" style=\"color:FFFFFF;text-decoration:none\">Apply the Latest Audit Configuration</A><br>\n"
		"   </b></font>\n"
		"   <br>\n"
		"   </div>\n"
		"  </td>\n"
		"  <td width=100% valign=Top>\n"
		"   <table cellpadding=0 cellspacing=10 border=0 width=100%>\n"
		"    <tbody>\n"
		"    <tr>\n"
		"     <td valign=Top align=Justify>\n", size);

	return (0);
}

int DefaultFooter(char *source, char *dest, int size)
{

	if (!source || !dest || !size) {
		return(0);
	}

	strncpy(dest, "     </td>\n"
		"    </tr>\n"
		"    </tbody>\n"
		"   </table>\n"
		"<center>\n"
		"<BR><BR><FONT SIZE=-1>(c) <A HREF=\"http://www.intersectalliance.com\">Intersect Alliance</A> Pty Ltd 1999-2006. "
		"This site is powered by <A HREF=\"http://www.intersectalliance.com/projects/index.html\">SNARE Epilog for UNIX.</A></FONT>"
		"</center>\n"
		"</td></tr></tbody></table>\n"
		"</body></html>", size);

	return (0);
}

int DisplayTextHeader(int http_socket)
{
	char HTTPBuffer[512];
	// Overwrite HTTPBuffer with the header data.
	strncpy(HTTPBuffer, "HTTP/1.0 200 OK\r\n"
		"Server: SNARE/1.0\r\n"
		"MIME-version: 1.0\r\n"
		"Content-type: text/plain\r\n\r\n", sizeof (HTTPBuffer));
	return (Send(http_socket, HTTPBuffer, strlen(HTTPBuffer)));
}

int Restart(char *source, char *dest, int size, int socketone, int sockettwo)
{
	int pid, err=0;
	FILE *chkfile;
	char str_web_name[MAX_AUDIT_CONFIG_LINE];
	if (WEB_CONFIG_FILENAME[0] == '\0')
		strncpy(str_web_name, USER_CONFIG_FILENAME, MAX_AUDIT_CONFIG_LINE);
	else
		snprintf(str_web_name, MAX_AUDIT_CONFIG_LINE, "%s/%s", CONFIG_FILEDIR, WEB_CONFIG_FILENAME);

	if (!source || !dest || !size) {
		return(0);
	}
	if (str_web_name[0] != '\0' && strncmp(str_web_name, CONFIG_FILENAME, MAX_AUDIT_CONFIG_LINE) != 0) {
		err = 1;
		if (!strncmp(str_web_name, CONFIG_FILENAME_SQUID, MAX_AUDIT_CONFIG_LINE)) {
			chkfile = fopen("/etc/init.d/snaresquidd","r");
			if (chkfile) {
				fclose(chkfile);
				err = 0;
			}
		} else if (!strncmp(str_web_name, CONFIG_FILENAME_APACHE, MAX_AUDIT_CONFIG_LINE)) {
			chkfile = fopen("/etc/init.d/snareapached","r");
			if (chkfile) {
				fclose(chkfile);
				err = 0;
			} 
		}
	}
	if (err) {
		strncpy(dest, "<H1><CENTER>Reapply the Latest Configuration</H1><P><font color=red>FAILED: Cannot find init script</font></CENTER>", size);
		return(0);
	}


	switch (pid = fork()) {
	case 0:
		// Child process.
		if (!strncmp(str_web_name, CONFIG_FILENAME_SQUID, MAX_AUDIT_CONFIG_LINE)) {
			close(sockettwo);
			close(socketone);
			execlp("/etc/init.d/snaresquidd", "snaresquidd", "restart", "&", (char *) 0);
		} else if (!strncmp(str_web_name, CONFIG_FILENAME_APACHE, MAX_AUDIT_CONFIG_LINE)) {
			close(sockettwo);
			close(socketone);
			execlp("/etc/init.d/snareapached", "snareapached", "restart", "&", (char *) 0);
		} else {
			// close our copy of the existing sockets.
			close(sockettwo);
			close(socketone);
			sleep(1);
			execlp("/etc/init.d/epilogd", "epilogd", "restart", "&", (char *) 0);
		}
	default:
		strncpy(dest,
			"<H1><CENTER>Reapply the Latest Configuration</H1><P>Reapplying the configuration</CENTER>",
			size);
	}

	return (0);
}

// General instructions:
// $ expr `./base64 intersect.gif | wc -c` - `./base64 intersect.gif | wc -l` "*" 2 + 1
//   2029
// ./base64 intersect.gif | sed 's/^/   "/' | sed 's/.$/"  \\/' >out.txt
// 
//  mangle out.txt as appropriate - add the (wc -c) - ((wc -l)*2) + 1 figure to the buffer size.
int InterSectImage(char *source, char *dest, int size)
{
	char IntersectGif[2029];
	char temp[2029];
	int size2;

	if (!source || !dest || !size) {
		return(0);
	}

	strncpy(IntersectGif,
		"R0lGODlhzQBGALMAAB8aF01JR2toZtwrGYF+fONVRo+Mi5eWleuCePKzrLOysszLy/jRzunl"
		"5f////j29SwAAAAAzQBGAEAI/gAdCBxIsKDBgw4eIFxIUCHDhxAjSkT4AMGAAQgmatw40CHH"
		"jxs9ghQJsuTEBxdTpkxgsqXLlzBjyvyoMuXMmzAB6NQp0MDOnzoDkOz504ADn0CTAniAVOlO"
		"oQqcSgVqdKpVAARrXiyA0+XQkkCJ7jRakMDPAA3MjmUYtikAsgfV6lTw9WFYgwKACj34gIFW"
		"jF0DCx5MeGPUsw08WtTKMqFcAGgZNghQ9ChQAQ1Kuq36s7DnzxL7/kXw4DFah6gFpk4o8ADV"
		"Bwpjs45d1/Lau6Bz6y5YQCvXmbV3Cx++MUHvvxcZHFSgoOGB5g4WGFhAfUFmAwqqL2i94EGD"
		"AwSZ/nNXreDA9gXmq5vvmb165sDBIcYnfjAB8gLz6ev3up+ifa0i5VeYgCEtROBIsyUIm0Gy"
		"seZgbatFqNqEBB2nUkb9BXbXZgJN9hN0YukE10FtVYbQY1clxVmKSjW0WE0HZijRhiYetIBS"
		"AdjVGYcUPZAXi0Bth9tBHv4EnkEWqjQUU5SxKMB2HTEFpJBXrTiVjFhO9F9NGKIIpE7g8ahZ"
		"ZUNmaeZGL6rUkQJNfgllQmyyCKJBHJZ55p0LNZBkSr8VhN4D66mGnkGBEjRdRwcUetQB7zmw"
		"HnraBYqddo3ieecDe2IUo6WcdtrRlkp6KuqoqmH6F34ZbkrqpZkOoOqq/7DqZmpNjcVqK55/"
		"VSrjqyR2BmdSkSHEoVtS2TbVXkV+CQB0yho5EKgp6XorQmFJudZjBJAkZq87GfvWQo/NKWyN"
		"8jnQwJDQXlTrtNT6KuYDN/6UmLcjGlTiWic2K68D+s5VEEq+Ycmrve6S21GbKrK1o8Edndsv"
		"AN3ZqRrCAAiAUJopKcfuTQ0oYMChGwsU709vCuRXwAMl2+x7FF9FpVVWFhsyfMRaPBByDj0m"
		"wMc898wzwgZYK2JLdfo6s4ytKqSzz0z3zGiIbw1cdLdH75rpbz/qC2XWci40NU9Vy4jxRWGX"
		"/dnYA6zLWgPW8fUvTEtS5KDZoD2QLp/LpYceiP6DFqRoT1B+pxBzDk33HV2PHkloon/TLRhy"
		"KzkuuWB9JYnh5C8N7OndgOmnOeaUN3DfgqCb9DmenDd6eulho315qpfSLRpjq7NOd6av244g"
		"f2f+RXpH+9UON+h/6W78RpmqPXfIuMHbZAAEzMvXsCkKLdVesBnQslRPDtSv4g6MjWqWtd/l"
		"MLDSQm0UsU5565RQD2zPYmYPL9XhXwl4JHx/NJ71k83A2xbBuiVAgpgmfSkDmmGGhLb9Yal/"
		"Q3MAwsBHL4URkGEDWVrTeqbADW6QYvo7FfliAsFvdShIhcOg9xaGr7jUDzwPyxFB7pY/s5Ww"
		"XocJynVUKJB7RZBBGv70oNPeQxWfcU1E3TlIAx24nxsy6IhUsSBPCphBxDyIQqvpodEKckQZ"
		"HkSEsMtJwVpYkPMlpWQDnCIPHQDFKfFri2WkWL1MNpoeXfGOEIINbRS0PBKO8YfL0QsCV3hB"
		"MiIkTsqKGBwNYkZ/FQRtDBCJyoAEovi56QEpiln7jheRHO4EjUkbiCebZZSRTQmTVXqjVTg5"
		"EdecxSMnq0mfwgUR6j1FamRaJCs5ogAC9OxNaGuMl760vqLg8ja63CXcTqW0+u3QkBz5GlaU"
		"2RVIluZDH3GLAAg0FGlSsysA45K56tedRqaILuNCJtW+eRPxqaaNKUqiJSlZF2+ys53FA6ne"
		"PY3nzgLtM2TeqeM/jxdLGDHIY+Jim0GsQ5K2pQyNDhVZZuClnTdVlKED1UhsGNCqAWjMOdsp"
		"j0ekQyc0OupNzBHcQJ5zKECdZ0QONQ8TOVkRyA1AV94xAOMSZYD3DEokMvVbEj2203mt5wHM"
		"OVTfBJId7ugvoxJBm0qUZ66IdqhtbKNUdCoq0ehUCl6ZsWrbKKodh1x0kFAliFQL8NG0lm5L"
		"CJAe3QICADs=", 2029);

	size2 = base64decode(temp, IntersectGif);
	if (size2 > size) {
		return(0);
	}

	memcpy(dest, temp, size2);
	return(size2);
}

int debracket(char *source, char *dest, int length)
{
	// This routine is simply to replace the HTML metacharacters "<" and ">" with
	// "&lt;" and "&gt;". That's all!

	int count = 0;
	char *copyofdest;
	copyofdest = dest;

	if (!source || !dest)
		return (1);

	while (*source) {
		if (*source == '<') {
			if (count < length) {
				*dest = '&';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = 'l';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = 't';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = ';';
				dest++;
				count++;
			}
		} else if (*source == '>') {
			if (count < length) {
				*dest = '&';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = 'g';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = 't';
				dest++;
				count++;
			}
			if (count < length) {
				*dest = ';';
				dest++;
				count++;
			}
		} else {
			if (count < length) {
				*dest = *source;
				dest++;
				count++;
			}
		}
		source++;
	}
	*dest = '\0';

	dest = copyofdest;

	return (0);
}

int Read_Config_From_File(struct Reg_Config *config_struct)
{
	FILE *configfile;
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	int headertype = 0;

	configfile = current_config("r");
	if (!configfile)
		return (0);

	strcpy(config_struct->str_ClientName, "");
	//strcpy(config_struct->str_NetworkDestination, "");
	//config_struct->dw_DestPort = 0;

	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		// Kill whitespace from start and end of line.
		trim(inputbuffer);

		if (!iscomment(inputbuffer)) {
			// Is this line a header?
			if (isheader(inputbuffer)) {
				headertype = getheader(inputbuffer);
			} else {
				if (headertype == CONFIG_HOSTID) {
					if (!strlen
					    (config_struct->str_ClientName)) {
						// Grab hostname here.
						if (!getconfstring
						    (inputbuffer,
						     config_struct->
						     str_ClientName,
						     SIZE_OF_CLIENTNAME)) {
							strncpy(config_struct->
								str_ClientName,
								"",
								SIZE_OF_CLIENTNAME);
						}
					}
				} else if (headertype == CONFIG_OUTPUT) {
					if (isnetwork(inputbuffer)) {
						// Ignore network entries for now, we will come back to them later
					} else if (issyslog(inputbuffer)) {
						config_struct->dw_Syslog = get_syslog_dest(inputbuffer);
						if (!config_struct->dw_Syslog) {
							config_struct->dw_Syslog = 13;
						}
					}
				}
			}
		}
	}
	// If we have made it this far, then we don't have any objectives.
	fclose(configfile);
	return (0);

}

int Read_Remote_From_File(struct Reg_Remote *remote_struct)
{
	FILE *configfile;
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	int headertype = 0;

	configfile = current_config("r");
	if (!configfile)
		return (0);

	remote_struct->dw_Allow = 0;
	remote_struct->dw_WebPort = 80;
	remote_struct->dw_Restrict = 0;
	strncpy(remote_struct->str_RestrictIP, "", SIZE_OF_RESTRICTIP);
	remote_struct->dw_Password = 0;
	strncpy(remote_struct->str_Password, "", SIZE_OF_PASSWORD);	// Just a failsafe password - not a default.

	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		// Kill whitespace from start and end of line.
		trim(inputbuffer);

		if (!iscomment(inputbuffer)) {
			// Is this line a header?
			if (isheader(inputbuffer)) {
				headertype = getheader(inputbuffer);
			} else {
				if (headertype == CONFIG_REMOTE) {
					if (regmatchi(inputbuffer, "^allow=")) {
						if (regmatchi
						    (inputbuffer, "=1")) {
							remote_struct->
							    dw_Allow = 1;
						}
					} else
					    if (regmatchi
						(inputbuffer,
						 "^listen_port=")) {
						remote_struct->dw_WebPort =
						    getport(inputbuffer);
					} else
					    if (regmatchi
						(inputbuffer,
						 "^restrict_ip=")) {
						if (!getconfstring
						    (inputbuffer,
						     remote_struct->
						     str_RestrictIP,
						     SIZE_OF_RESTRICTIP)) {
							remote_struct->
							    dw_Restrict = 0;
							strncpy(remote_struct->
								str_RestrictIP,
								"",
								SIZE_OF_RESTRICTIP);
						} else {
							remote_struct->
							    dw_Restrict = 1;
						}
					} else
					    if (regmatchi
						(inputbuffer, "^accesskey=")) {
						if (!getconfstring
						    (inputbuffer,
						     remote_struct->
						     str_Password,
						     SIZE_OF_PASSWORD)) {
							remote_struct->
							    dw_Password = 0;
							strncpy(remote_struct->
								str_Password,
								"",
								SIZE_OF_PASSWORD);
						} else {
							remote_struct->
							    dw_Password = 1;
						}
					}
				}
			}
		}
	}

	fclose(configfile);
	return (0);

}

// Return the host identifier
int getnetwork(char *string, char *host, int length, int *protocol)
{
	char *stringp = string;
	char *pos, *pos2;
	char strPort[10];

	stringp = strstr(string, "=");
	*protocol=SOCKETTYPE_UDP;

	if (stringp != (char *) NULL) {
		stringp++;
		if (strlen(stringp)) {
			pos = strstr(stringp, ":");
			if (pos != (char *) NULL) {
				strncpy(strPort, pos + 1, 10);
				*pos = '\0';
				strncpy(host, stringp, length - 1);
				return (atoi((char *) strPort));
			} else {
				strncpy(host, stringp, length - 1);
				return(6161);
			}
		} else {
			return (0);
		}
	} else {
		return (0);
	}
}

void getlog(char *string, struct Reg_Log *log_struct)
{
	char *stringp;
	char *pos, *pos2;
	stringp = strstr(string, "=");
	stringp++;
	if (strlen(stringp)) {
		int length;
		pos = strstr(stringp, ":");
		pos2 = strstr(stringp, "/");
		if (pos && pos2 && pos < pos2) {
			pos2 = stringp;
			stringp = pos + 1;
			*pos='\0';
			strncpy(log_struct->type, pos2, MAX_AUDIT_CONFIG_LINE);
		} else {
			//assume the default Epilog
			strncpy(log_struct->type, "GenericLog", MAX_AUDIT_CONFIG_LINE);
		}
		// Record the name and open the file for reading
		strncpy(log_struct->name, stringp, MAX_AUDIT_CONFIG_LINE);
	}
}

FILE *Find_First(int config_header)
{
	FILE *configfile;
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	int headertype = 0;

	configfile = current_config("r");
	if (!configfile)
		return (configfile);

	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		// Kill whitespace from start and end of line.
		trim(inputbuffer);

		if (!iscomment(inputbuffer)) {
			// Is this line a header?
			if (isheader(inputbuffer)) {
				headertype = getheader(inputbuffer);
				if (headertype == config_header) {
					return (configfile);
				}
			}
		}
	}
	// If we have made it this far, then we don't have any objectives.
	fclose(configfile);
	configfile = (FILE *) NULL;
	return (configfile);
}

int Get_Next_Network(FILE * configfile, struct Reg_Host *host_struct) {
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		trim(inputbuffer);

		if (isheader(inputbuffer)) {
			return (0);
		}

		if (strlen(inputbuffer) < 3) {
			continue;
		}

		if (isnetwork(inputbuffer)) {
			host_struct->dw_DestPort =
			    getnetwork(inputbuffer,
				       host_struct->
				       str_NetworkDestination,
				       SIZE_OF_DESTINATION,
				       &host_struct->
				       dw_Protocol);
			if (!host_struct->dw_DestPort) {
				// Give it the default value
				host_struct->dw_DestPort = 6161;
			}
			return(1);
		}
	}
	return (0);
}

int Get_Next_Objective(FILE * configfile, struct Reg_Objective *objective)
{
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	// Save off enough space to store the data we need.
	char path[MAX_AUDIT_CONFIG_LINE];
	int excludematchflag = 0;

	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		trim(inputbuffer);

		if (isheader(inputbuffer)) {
			return (0);
		}

		if (strlen(inputbuffer) < 3) {
			continue;
		}

		if (splitobjective(inputbuffer, path, &excludematchflag) > -1) {
			// add the objective to the linked list.

			if (excludematchflag) {
				strncpy(objective->str_general_match_type,
					"Exclude",
					sizeof (objective->
						str_general_match_type));
			} else {
				strncpy(objective->str_general_match_type,
					"Include",
					sizeof (objective->
						str_general_match_type));
			}

			strncpy(objective->str_general_match, path,
				SIZE_OF_GENERALMATCH);

			return (1);
		}
	}
	return (0);
}

int Get_Next_Log(FILE * configfile, struct Reg_Log *log_struct) {
	char inputbuffer[MAX_AUDIT_CONFIG_LINE];
	while (fgets(inputbuffer, MAX_AUDIT_CONFIG_LINE, configfile)) {
		trim(inputbuffer);

		if (isheader(inputbuffer)) return (0);

		if (strlen(inputbuffer) < 3) continue;

		if (islog(inputbuffer)) {
			getlog(inputbuffer, log_struct);
			return(1);
		}
	}
	return (0);
}

int Close_File(FILE * configfile)
{
	return (fclose(configfile));
}

int dir_exists(const char *path) {
	struct stat st;

	return stat(path, &st) == 0 && S_ISDIR(st.st_mode);
}

int file_exists(const char *path)
{
	struct stat st;

	return stat(path, &st) == 0;
}

int Log_Config(char *source, char *dest, int size)
{
	struct Reg_Log log_struct;
	int i_log_count= 0;
	char str_log_count[10];
	char str_name_metachar_remove[MAX_AUDIT_CONFIG_LINE * 2];

	FILE *configfile = (FILE *) NULL;

	if (!source || !dest || !size) {
		return(0);
	}

	strcpy(log_struct.name, "");
	strcpy(log_struct.type, "");

	strncpy(dest,
		"<form action=setlog><H1><CENTER>SNARE Log Configuration</H1>",
		size);

	configfile = Find_First(CONFIG_INPUT);

	if (configfile) {
		strncat(dest,
			"<br>The following log files are being monitored by SNARE:<br><br>"
			"<table  width=100% border=1>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFBB><center><td width=\"10%\"><b>Action Required</b></td><td width=\"20%\"><b>Log Type</b></td>"
			"<td width=\"70%\"><b>Log File</b>"
			"</td></center></tr>", size - strlen(dest));

		while (Get_Next_Log(configfile, &log_struct)) {
			snprintf(str_log_count, 10, "%d", i_log_count);

			if ((i_log_count) == 0)
				strncat(dest,
					"<tr bgcolor=#FFFFCC><td><input type=submit name=",
					size - strlen(dest));
			else
				strncat(dest,
					"<tr bgcolor=#FFFFBB><td><input type=submit name=",
					size - strlen(dest));

			strncat(dest, str_log_count, size - strlen(dest));
			strncat(dest, " value=Delete>     ",
				size - strlen(dest));

			strncat(dest, "<input type=submit name=",
				size - strlen(dest));
			strncat(dest, str_log_count, size - strlen(dest));
			strncat(dest, " value=Modify>", size - strlen(dest));
			strncat(dest, "</td><td>", size - strlen(dest));

			strncat(dest, log_struct.type,
				size - strlen(dest));
			strncat(dest, "</td><td>", size - strlen(dest));

			// Debracket the strings in here. For HTML display purposes, the HTML metacharacters
			// need to be replaced. This is done with the "debracket" routine.
			// Note that the new strings are allowed to be twice as long as the real strings
			debracket(log_struct.name,
				  str_name_metachar_remove,
				  MAX_AUDIT_CONFIG_LINE * 2);

			if (strlen(log_struct.name) == 0) {
				strncat(dest, "&nbsp", size - strlen(dest));
			} else {
				strncat(dest, str_name_metachar_remove,
					size - strlen(dest));
			}
			strncat(dest, "</td></tr>", size - strlen(dest));

			i_log_count++;
		}
		Close_File(configfile);
		strncat(dest, "</table><br>", size - strlen(dest));
	} else {
		strncat(dest,
			"<br>There are no current log monitors active.<br><br>",
			size - strlen(dest));
	}

	strncat(dest, "Select this button to add a new log monitor.  ",
		size - strlen(dest));
	strncat(dest, "<input type=submit name=0", size - strlen(dest));
	strncat(dest, " value=Add>", size - strlen(dest));

	return (0);
}

int Log_Display(char *source, char *dest, int size)
{
	struct Reg_Log log_struct;
	int dw_log_error = 0, dw_log_delete_error = 0;
	char str_logerr[10];
	int i_log_count = 0, i_type = 0, i;
	char *psource = source, Variable[100], Argument[100];
	char str_temp[20], str_temp_log[10];
	int log_type_count = 6;		// Don't forget to change this when adding new types
	char *str_value[] = {"GenericLog", "ApacheLog", "ISAWebLog", "MSProxySvr", "SMTPSvcLog", "SquidProxyLog"};
	char *str_descr[] = {"Generic log format (default)", "Apache web logs", "Microsoft ISA web logs", "Microsoft proxy server logs", "Microsoft SMTP logs", "Squid proxy logs"};

	// This function will display an existing, or a blank, log
	strncpy(dest,
		"<form action=changelog><h1><center>SNARE Log Configuration</h1>",
		size);

	// Determine whether the log will be modified or deleted
	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {
		if (strstr(Argument, "Delete") != NULL) {
			sscanf(Variable, "%20[^?]?%10[^\n]\n", str_temp,
			       str_temp_log);
			i_type = 0;
			break;
		}
		if (strstr(Argument, "Modify") != NULL) {
			sscanf(Variable, "%20[^?]?%10[^\n]\n", str_temp,
			       str_temp_log);
			i_type = 1;
			break;
		}
		if (strstr(Argument, "Add") != NULL) {
			strncpy(str_temp_log, "-2",
				sizeof (str_temp_log));
			i_type = 2;
			break;
		}
	}

	// Extract the log number. I have to do this stuff, because atoi returns 0 if it cannot convert the string
	if (strcmp(str_temp_log, "0") == 0)
		i_log_count = -1;
	else
		i_log_count = atoi(str_temp_log);

	// If the log number could not be successfully extracted, return immediately.
	if (i_log_count == 0) {
		strncat(dest,
			"<br><b>NOTE: It appears the URL is encoded incorrectly.",
			size - strlen(dest));
		return 0;
	}

	if (i_log_count == -1)
		i_log_count = 0;

	// If the log is being modified or added
	if (i_type > 0) {
		if (i_type == 1) {
			int count = 0;
			int returncode;
			FILE *configfile;
			configfile = Find_First(CONFIG_INPUT);
			while ((returncode =
				Get_Next_Log(configfile, &log_struct)))
			{
				if (count == i_log_count)
					break;
				count++;
			}
			if (!(count == i_log_count && returncode)) {
				dw_log_error =
				    WEB_READ_LOG_ERROR_CODE;
			}
			Close_File(configfile);
		} else {
			// Defaults
			strncpy(log_struct.name, "", sizeof(log_struct.name));
			strncpy(log_struct.type, "GenericLog", sizeof(log_struct.type));
		}

		// Will display an error if unable to completely read from the config file
		if (dw_log_error > 0) {
			dw_log_error += WEB_READ_LOG_ERROR_CODE;
			snprintf(str_logerr, 10, "%d", dw_log_error);

			strncat(dest,
				"<br><b>NOTE: Some errors were encountered in reading the configuration file. Default values "
				"may be used.<br> Report error: ",
				size - strlen(dest));
			strncat(dest, str_logerr, size - strlen(dest));
			strncat(dest, "</b><br>", size - strlen(dest));
		}

		strncat(dest,
			"<br>The following parameters of the SNARE log inputs may be set:<br><br>"
			"<table  width=100% border=0>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFCC><td>Select the Log Type</td><td><select name=str_log_type>",
			size - strlen(dest));

		for (i = 0; i < log_type_count; i++) {
			strncat(dest, "<option value=", size - strlen(dest));
			strncat(dest, str_value[i], size - strlen(dest));
			if (strncmp(str_value[i], log_struct.type, MAX_AUDIT_CONFIG_LINE) == 0)
				strncat(dest, " selected>", size - strlen(dest));
			else
				strncat(dest, ">", size - strlen(dest));
			strncat(dest, str_descr[i], size - strlen(dest));
		}

		/*if (strcmp(log_struct.str_general_match, ".*") == 0) {
			strncat(dest, " checked", size - strlen(dest));
			strncpy(log_struct.str_general_match_type, "Any", sizeof(log_struct.str_general_match_type));
		}
		strncat(dest, ">Match Any String    ", size - strlen(dest));
		*/
		strncat(dest, "</select></td></tr>", size - strlen(dest));

		strncat(dest,
			"<tr bgcolor=#FFFFBB><td>Log File<br></td><td><input type=text name=str_log_name size=50 value=\"",
			size - strlen(dest));
		strncat(dest, log_struct.name,
			size - strlen(dest));
		strncat(dest, "\"></td></tr>", size - strlen(dest));

		strncat(dest, "</table><br>", size - strlen(dest));
		strncat(dest, "<input type=hidden name=lognumber value=",
			size - strlen(dest));
		strncat(dest, str_temp_log, size - strlen(dest));	// Log number goes here
		strncat(dest,
			"><input type=submit value=\"Change Configuration\">    ",
			size - strlen(dest));
		strncat(dest, "<input type=reset value=\"Reset Form\"></form>",
			size - strlen(dest));
	} else {
		void *rampointer = (void *) NULL;
		char *position;
		char inputbuffer[MAX_AUDIT_CONFIG_LINE];
		int headertype = 0;
		FILE *configfile;

		rampointer = Load_Config_File();
		if (!rampointer) {
			dw_log_error = WEB_READ_CONFIG_ERROR_CODE;
			dw_log_delete_error = 1;
		} else {
			int logcounter = 0;
			int size = 0;

			position = (char *) rampointer;

			configfile = current_config("w");
			if (!configfile) {
				strncat(dest,
					"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			while ((size =
				Grab_RAMConfig_Line(position, inputbuffer,
						    MAX_AUDIT_CONFIG_LINE))) {
				trim(inputbuffer);

				if (headertype == CONFIG_INPUT) {
					if (logcounter ==
					    i_log_count) {
						// Do not add this line back into the original file.
						position += size;
						logcounter++;
						continue;
					}
					logcounter++;
				}

				if (!iscomment(inputbuffer)) {
					// Is this line a header?
					if (isheader(inputbuffer)) {
						headertype =
						    getheader(inputbuffer);
					}
				}
				// Print this line to file.
				if (isheader(inputbuffer)
				    || iscomment(inputbuffer)
				    || !strlen(inputbuffer)) {
					fprintf(configfile, "%s\n",
						inputbuffer);
				} else {
					fprintf(configfile, "	%s\n",
						inputbuffer);
				}

				// position+=strlen(inputbuffer)+1;
				position += size;
			}
			if (fclose(configfile)) {
				dw_log_delete_error = 1;
				strncat(dest,
					"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
					size - strlen(dest));
				Clear_Config_File(rampointer);
				return (0);
			}

			Clear_Config_File(rampointer);
		}

		if (dw_log_delete_error == 0)
			strncat(dest,
				"<br><b>The log monitor has been removed<br><a href=\"log\">Return to Log display</a>.",
				size - strlen(dest));
		else
			strncat(dest,
				"<br>The log monitor was unable to be deleted.",
				size - strlen(dest));
	}

	return (0);
}

int Log_Result(char *source, char *dest, int size)
{
	// All strncpy or strncat functions in this routine have been designed avoid overflows
	struct Reg_Log log_struct;
	int dw_log_error = 0;
	int i_log = 0;
	char str_log_count[10];
	char *psource = source, Variable[100], Argument[100];

	strncpy(dest,
		"<form action=setlog><H1><CENTER>SNARE Log Configuration</H1>",
		size);

	while ((psource =
		GetNextArgument(psource, Variable, sizeof (Variable), Argument,
				sizeof (Argument))) != (char *) NULL) {

		if (strstr(Variable, "str_log_name") != NULL) {
			strncpy(log_struct.name, Argument,
				sizeof (log_struct.name));
		}
		
		if (strstr(Variable, "lognumber") != NULL) {
			strncpy(str_log_count, Argument,
				sizeof (str_log_count));
		}
		if (strstr(Variable, "str_log_type") != NULL) {
			strncpy(log_struct.type, Argument,
				sizeof (log_struct.type));
		}
	}

	if (!dw_log_error) {

		i_log = atoi(str_log_count);

		//-2 = "Add a new log monitor"
		if (i_log == -2) {
			void *rampointer = (void *) NULL;
			char *position;
			char inputbuffer[MAX_AUDIT_CONFIG_LINE];
			int headertype = 0;
			FILE *configfile;

			rampointer = Load_Config_File();
			if (!rampointer) {
				dw_log_error = WEB_READ_CONFIG_ERROR_CODE;
			} else {
				int size = 0;
				int wroteconfig = 0;

				position = (char *) rampointer;

				configfile = current_config("w");
				if (!configfile) {
					dw_log_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				while ((size =
					Grab_RAMConfig_Line(position,
							    inputbuffer,
							    MAX_AUDIT_CONFIG_LINE)))
				{
					trim(inputbuffer);

					// Is this line a header?
					if (isheader(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
						headertype =
						    getheader(inputbuffer);
						if (headertype ==
						    CONFIG_INPUT) {
							// WRITE OUT NEW LOG MONITOR HERE
							fprintf(configfile,
								"	log=%s:%s\n",
								log_struct.type,
								log_struct.name);

							wroteconfig = 1;
						}
					} else {

						// Print this line to file.
						if (iscomment(inputbuffer)
						    || !strlen(inputbuffer)) {
							fprintf(configfile,
								"%s\n",
								inputbuffer);
						} else {
							fprintf(configfile,
								"	%s\n",
								inputbuffer);
						}
					}
					position += size;
				}

				if (!wroteconfig) {
					// Must not have been an input header in the file...
					// WRITE OUT NEW LOG MONITOR HERE
					fprintf(configfile,
						"\n\n[Input]\n	log=%s:%s\n",
						log_struct.type,
						log_struct.name);
				}

				if (fclose(configfile)) {
					dw_log_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				Clear_Config_File(rampointer);
			}
		} else {
			// Modify an existing log monitor
			void *rampointer = (void *) NULL;
			char *position;
			char inputbuffer[MAX_AUDIT_CONFIG_LINE];
			int headertype = 0;
			FILE *configfile;

			rampointer = Load_Config_File();
			if (!rampointer) {
				dw_log_error = WEB_READ_CONFIG_ERROR_CODE;
			} else {
				int logcounter = 0;
				int size = 0;

				position = (char *) rampointer;

				configfile = current_config("w");
				if (!configfile) {
					dw_log_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not open the configuration file for writing. Please verify the permissions set on the audit config file.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				while ((size =
					Grab_RAMConfig_Line(position,
							    inputbuffer,
							    MAX_AUDIT_CONFIG_LINE)))
				{
					trim(inputbuffer);

					if (headertype == CONFIG_INPUT) {
						if (logcounter ==
						    i_log) {
							// Replace this log monitor with the new version.
							// WRITE OUT NEW LOG MONITOR HERE
							fprintf(configfile,
								"	log=%s:%s\n",
								log_struct.type,
								log_struct.name);

							position += size;
							logcounter++;
							continue;
						}
						logcounter++;
					}

					if (!iscomment(inputbuffer)) {
						// Is this line a header?
						if (isheader(inputbuffer)) {
							headertype =
							    getheader
							    (inputbuffer);
						}
					}
					// Print this line to file.
					if (isheader(inputbuffer)
					    || iscomment(inputbuffer)
					    || !strlen(inputbuffer)) {
						fprintf(configfile, "%s\n",
							inputbuffer);
					} else {
						fprintf(configfile, "	%s\n",
							inputbuffer);
					}

					// position+=strlen(inputbuffer)+1;
					position += size;
				}

				if (fclose(configfile)) {
					dw_log_error = 1;
					strncat(dest,
						"<br><b>NOTE: Could not write to the configuration file. Does the system have enough free disk space?.",
						size - strlen(dest));
					Clear_Config_File(rampointer);
					return (0);
				}

				Clear_Config_File(rampointer);
			}
		}

		if (dw_log_error == 0)
			strncat(dest,
				"<br>The log monitor has been modified/added.",
				size - strlen(dest));
		else
			strncat(dest,
				"<br>The log monitor was unable to be modified/added.",
				size - strlen(dest));
	}

	return (0);
}

int ListConf (char *source, char *dest, int size)
{
	DIR *confdir;
	struct dirent *conffile;
	char str_file_name[MAX_AUDIT_CONFIG_LINE];
	int cflag=0, def_flag=0;

	if (USER_CONFIG_FILENAME[0] != '\0') {
		return Status_Page(source, dest, size);
	}
	snprintf(dest, size,
		"<HTML><BODY><H1><CENTER>Welcome to SNARE Epilog for UNIX version %s</H1><P>Please choose the file you wish to edit or select from the menu on the left. (Current selection in bold) </CENTER><p>\n", VERSION);
	confdir = opendir(CONFIG_FILEDIR);
	while ((conffile = readdir(confdir)) != NULL) {
		cflag=0; def_flag=0;
		if (conffile->d_name[0] == '.')
			continue;
		snprintf(str_file_name, MAX_AUDIT_CONFIG_LINE, "%s/%s", CONFIG_FILEDIR, conffile->d_name);
		if (!strncmp(CONFIG_FILENAME,str_file_name, MAX_AUDIT_CONFIG_LINE)) def_flag=1;
		if (!strncmp(conffile->d_name, WEB_CONFIG_FILENAME, MAX_AUDIT_CONFIG_LINE) || WEB_CONFIG_FILENAME[0] == '\0' && def_flag) {
			strncat(dest, "<strong>", size);
			cflag = 1;
		}
		strncat(dest, "<a href=\"/", size);
		strncat(dest, conffile->d_name, size);
		strncat(dest, "/\">", size);
		strncat(dest, conffile->d_name, size);
		if (def_flag) strncat(dest, " (default)", size);
		if (cflag) strncat(dest, "</strong>", size);
		strncat(dest, "<br />\n", size);
	}

	return(0);
}

FILE *current_config (char *mode)
{
	char str_web_name[MAX_AUDIT_CONFIG_LINE];
	snprintf(str_web_name, MAX_AUDIT_CONFIG_LINE, "%s/%s", CONFIG_FILEDIR, WEB_CONFIG_FILENAME);

	if (USER_CONFIG_FILENAME[0] == '\0') {
		if (WEB_CONFIG_FILENAME[0] == '\0')
			return fopen(CONFIG_FILENAME,mode);
		else
			return fopen(str_web_name,mode);
	} else {
		return fopen(USER_CONFIG_FILENAME,mode);
	}
}
