/**********************************************************
 *
 * Snare Epilog for UNIX version 1.1
 *
 * Author: InterSect Alliance Pty Ltd
 *
 * Copyright 2001-2006 InterSect Alliance Pty Ltd
 *
 * Last Modified: 23/05/2006
 *
 **********************************************************
 *
 *
 **********************************************************
 *
 * History:
 *      23/05/2006  Initial working version
 *
 **********************************************************
 *
 * Compilation Instructions:
 *    gcc -o epilog epilog.c webserver.c WebPages.c -lsocket -lnsl -lintl
 *
 **********************************************************/

// TODO: Cut up audit log data into TAB and COMMA delim stuff (like SNARE)

#include <sys/types.h> 
#include <sys/wait.h> 
#include <sys/errno.h>
#include <sys/fcntl.h>
#include <sys/termios.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <pthread.h>
#include <limits.h>
#include <dirent.h>

#include <regex.h>

#include "webserver.h"

// Should migrate these to a header.

#define CACHESIZE 2		/* MAX cache size */
#define LOGBUFSIZE 8192		/* MAX UDP string buffer size */
#define HOSTSIZE 1024		/* MAX hostname */
#define MAXAUDIT 65535		/* Maximum number of audit events */
#define MAX_AUDIT_CONFIG_LINE	8192
#define CONFIG_FILENAME "/etc/snare/epilog/epilog.conf"
#define CONFIG_FILEDIR "/etc/snare/epilog"
// #define CONFIG_FILENAME "epilog.conf"
// These are for the benefit of WebPages.c so it know's how to restart
// the agents
#define CONFIG_FILENAME_APACHE "/etc/snare/epilog/apache.conf"
#define CONFIG_FILENAME_SQUID "/etc/snare/epilog/squid.conf"

#define CONFIG_AUDITTYPE	1
#define	CONFIG_OBJECTIVES	2
#define CONFIG_INPUT		3
#define CONFIG_OUTPUT		4
#define CONFIG_DELIVERY		5
#define CONFIG_HOSTID		6
#define CONFIG_REMOTE		7

#define MAX_HOSTID		256	// Host identifier - usually the fully qualified hostname.
#define MAX_AUDITREC 		8192		// How much buffer to reserve for the textual representation of an audit event.
#define MAX_AUDIT_CONFIG_LINE	8192
#define MAX_USERNAME		256
#define MAX_OPTIONS		256
#define MAX_EVENTNAME		32
#define MAX_USERREG		PATH_MAX
#define MAX_HOSTID		256		// Host identifier - usually the fully qualified hostname.
#define MAX_PATH			1024		// PATH_MAX in linux is 4096, but we cannot afford to
#define MAXCOMMAND 		16
#define WAITTIME		30			// Time, in seconds, to wait until attempting to send to a dead host
#define TIMEOUT			1000			// Time, in nanoseconds, to wait between reads, needs to be 1000 for SPARC

#define CRITICALITY_CLEAR	0
#define CRITICALITY_INFO	1
#define CRITICALITY_WARNING 2
#define CRITICALITY_PRIORITY 3
#define CRITICALITY_CRITICAL 4

#define	RETURNCODE_FAILURE	0
#define RETURNCODE_SUCCESS	1
#define RETURNCODE_ANY		999

#define AUDIT_TO_STDOUT		1
#define AUDIT_TO_NETWORK        2
#define AUDIT_TO_SYSLOG         4

#define DEFAULT_CACHE 320000
#define SOCKETTYPE_UDP 0

#define AUDIT_ALL	-1

//#define DEBUG	1

// Linked List
struct _node
{
	int excludematchflag;	// Include or exclude the match?
	char path[PATH_MAX];			// NOTE: this could match either path or destpath
	regex_t pathRE;
	struct _node *next;
};

typedef struct _node Node;

struct _log_node
{
	// File name
	char name[MAX_AUDIT_CONFIG_LINE];

	/* File stream on which the file is open; -1 if it's not open. */
	FILE *fs;

	// partial msg storage
	char pmsg[LOGBUFSIZE];

	// Log type
	char type[MAX_AUDIT_CONFIG_LINE];

	/* Attributes of the file the last time we checked. */
	off_t size;
	struct timespec mtime;
	dev_t dev;
	ino_t ino;
	mode_t mode;

	// When did the last error occur (zero means no error)
	time_t last_error;

	struct _log_node *next;
};

typedef struct _log_node LogNode;

// Linked List
struct _msgcache {
	char msg[MAX_AUDIT_CONFIG_LINE];
	// Log type
	char type[MAX_AUDIT_CONFIG_LINE];
	int msglen;
	struct _msgcache *next;
};

typedef struct _msgcache MsgCache;

struct _hostnode
{
	int AuditSocket;
	struct sockaddr_in      AuditSocketName;
	socklen_t dest_addr_size;
	time_t last_error;
	char desthost[MAX_HOSTID];
	int port;
	int protocol;
	struct _hostnode *next;
};

typedef struct _hostnode HostNode;

void	pipe_signal();		/* Routine to handle SIGPIPEs */
void	kill_signal();		/* Routine to handle SIGTERMs */
void	usr1_signal();

int		read_config_file();
char *	getconfstring(char *string, char *file,int length);
int		getport(char *string);

int		setsignals(sigset_t *signalset);

void	trim(char *string);
void	trimallwhitespace(char *string);
int		IsListEmpty(void);

int sendevent(char *string, char *type);
int iscomment(char * line);
int getheader(char *string);
int splitobjective(char *string, char *match, int *excludematchflag);
int regmatch(const char *string, const char *pattern);
int regmatchi(const char *string, const char *pattern);
int open_audit_output(char *string);
int open_audit_network(char *string);
int add_log_watch(char *string);
int file_has_changed(LogNode *f);
int isheader(char *string);
int islog(char *string);
int isnetwork(char *string);
void syslogdate(char *sdate, struct tm *cdate);



Node *	AddToList(char *path, int excludematchflag);
char *	getfqdn(char * FQDN);

int 	CheckObjective(char *searchterm);
char *	FormatDelimiters(char *eventbuffer);
int		GetTextDetails(char *logbuffer,char *username,char *searchterm,char *eventname, char *options);
int		GetElement(char *source,int count,char *dest,int buffersize);

char * FindHeaderToken(char *buffer);
char * FindSubjectToken(char *buffer);
char * FindReturnToken(char *buffer);
char * FindPathToken(char *buffer);
char * FindExecArgsToken(char *buffer);
char * FindAttributeToken(char *buffer);

void DestroyList(void);
int IsSocketValid(int socket);
void send_logs();
int fix_last_error(HostNode *hn);
void usage (char *exe);
////// DEBUG
#include <stdarg.h>
void DebugMsg(const char *pszFormat, ...);
////// END DEBUG

