%define name	epilog
%define version 1.1
%define release 1
%define prefix  /

Summary: Snare Epilog for UNIX
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: System Environment/Daemons
URL: http://www.intersectalliance.com/

Source: http://www.intersectalliance.com/projects/SnareEpilog/epilog-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

Docdir: %{prefix}/usr/share/doc

%description
A Snare Log Forwarder for any text based log file, that is designed to send data to the SNARE (System iNtrusion Analysis and Reporting Environment) Server, or a syslog server.

%prep

%setup

%build
%ifarch i586
BCFLAGS="-mpentium -march=pentium" 
%endif
%ifarch i686
BCFLAGS="-mpentiumpro -march=pentiumpro" 
%endif
./configure
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/etc/init.d
mkdir -p $RPM_BUILD_ROOT/etc/snare/epilog

./redhat-install.sh $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%attr(755,root,root) %{prefix}/usr/bin/epilog
%attr(755,root,root) %{prefix}/etc/init.d/epilogd
%config %{prefix}/etc/snare/epilog/epilog.conf
%attr(600,root,root) %{prefix}/etc/snare/epilog/epilog.conf

%clean
rm -r $RPM_BUILD_ROOT

%post
chkconfig --add epilogd
chkconfig epilogd on
service epilogd start

%preun
service epilogd stop
chkconfig epilogd off
chkconfig --del epilogd

%changelog
* Tue Jun 20 2006 David Mohr
- Initial spec file for Epilog 1.0 - InterSect Alliance - http://www.intersectalliance.com/

* Tue Jun 20 2006 David Mohr
- Initial spec file for Epilog 1.1 - InterSect Alliance - http://www.intersectalliance.com/
