#!/bin/sh
# chkconfig: 2345 99 33
# description: SNARE System iNtrusion Analysis and Reporting Environment
# processname: epilog
# config: /etc/snare/epilog/epilog.conf
########################################################################
#
#   (c) 2001-2006 Intersect Alliance Pty Ltd
#
#   This script controls Snare Epilog for UNIX
#
#   Version 1.1
#
#   Usage: /etc/init.d/epilogd { start | stop | restart } 
#
########################################################################

case "$1" in
'start')
        PID=`cat /var/run/epilog.pid 2>/dev/null`
        if [ ! -z "$PID" ] ;  then
		echo "Epilog already running. Please stop Epilog first."
		exit 1
	fi

	id | grep '^uid=0' > /dev/null
	if [ $? -ne 0 ]; then
		echo "Sorry, you need to be root to start epilog."
		exit 1
	fi

        if [ -f /usr/bin/epilog ] ; then
                echo "Epilog starting."
		/usr/bin/epilog
        fi
	exit 0
        ;;
'stop')
	id | grep '^uid=0' > /dev/null
	if [ $? -ne 0 ]; then
		echo "Sorry, you need to be root to start epilog."
		exit 1
	fi

        PID=`cat /var/run/epilog.pid 2>/dev/null`
       	if [ ! -z "$PID" ] ;  then
		kill -USR1 ${PID}
		sleep 1
		kill ${PID}
	fi
	rm -f /var/run/epilog.pid 2>/dev/null
	sleep 1

	# Just in case:
	# Kill all epilog processes, sorted on parent process ID
	# This way epilog with ppid of 1 gets killed first
        ps -e -u 0 -o "pid,ppid,comm"|grep "epilog$" |grep -v grep|sort -n|awk '{print $1}' |
		while read pid ppid command; do
			if [ ! -z "$pid" ] ; then
				echo "Cleaning up epilog process $pid"
				kill ${pid} 1>/dev/null 2>&1
			fi
		done
	exit 0
        ;;
'restart')
        if [ -f /etc/init.d/epilogd ] ; then
		/etc/init.d/epilogd stop
		RC=$?
		if [ $RC -gt 0 ]; then
			exit $RC
		fi
		/etc/init.d/epilogd start
		RC=$?
		if [ $RC -gt 0 ]; then
			exit $RC
		fi
	fi
	;;
	
*)
        echo 'Usage: /etc/init.d/epilogd { start | stop | restart }'
        ;;
esac

exit 0
