#!/bin/sh
########################################################################
#    
#    (c) 2006 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of snare epilog for UNIX.
#   
#   Version 1.1
#    
#    Usage: ./install.sh
#
########################################################################

########################################################################
#   Check that the necessary files are contained within the local
#   directory. 
########################################################################

file_check()
{

     if [ ! -f epilog.sol.sparc ]
     then
        echo "The program epilog.sol.sparc binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f epilog.sol.x86 ]
     then
        echo "The program epilog.sol.x86 binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f epilog.linux ]
     then
        echo "The program epilog.linux binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f epilog.conf.basic ]
     then
        echo "The new basic configuration file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f uninstall.sh ]
     then
        echo "The snare removal script is missing. Terminating script."
        exit 1 
     fi
}

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 1
        else
           echo "Confirmed that you are logged in as root"
	fi

}

########################################################################
#  Check the OS
########################################################################

check_os()
{
   uname | egrep "(Linux|SunOS)" > /dev/null
   RETVAL=$?

   if [ $RETVAL -gt 0 ]
   then
     echo "This agent is currently designed for Solaris and Linux based operating system only. Terminating script"
     exit 1
   fi 
	
}

########################################################################
#  This is the main loop  
########################################################################

file_check 
root_check
check_os

INSTAL=0
SNAREC=0

if [ -f /etc/snare/epilog/epilog.conf ]; then
   SNAREC=1
fi

if [ -f /etc/init.d/epilogd ]; then
	echo "WARNING: It looks as though Epilog is already installed."
	echo
	echo "Please uninstall Epilog first before proceeding: /etc/snare/epilog_uninstall.sh"
	echo
	exit
fi

# Kill off any outstanding pid files.
if [ -f /var/run/epilog.pid ]; then
	rm -f /var/run/epilog.pid >/dev/null 2>&1
fi

if [ "$SNAREC" -eq "1" ]; then
	while [ "$INSTAL" -ne "1" ] && [ "$INSTAL" -ne "2" ] && [ "$INSTAL" -ne "3" ] && [ "$INSTAL" -ne "4" ]
	do
	  echo 
	  echo "Enter [1] to install a basic starting configuration"
	  echo "Enter [2] to preserve the EXISTING snare configuration file"
	  echo "Enter anything else to terminate the script"
	  echo -n "Selection: "
	    read INSTAL
	    case $INSTAL in
	       1) echo "Installing basic configuration files"; INSTALL_TYPE=1 ;;
	       2) echo "Preserving existing SNARE configuration"; INSTALL_TYPE=2;;
	       *) echo "Script terminating at user request"; exit 1 ;;
	    esac 
	done
else
   INSTALL_TYPE=1
fi
 

########################################################################
#  This provides the final warning before the software is loaded onto
#  the system. In case of mistakes, it allows the user to escape before 
#  the software is loaded.   
########################################################################

echo 
echo "*************************************************"
echo 
echo "You are about to install Epilog on this host."
echo "Your selections are as follows:"
if [ $INSTALL_TYPE -eq 1 ]; then
  echo "Basic Installation"
else
  echo "Preserving existing configuration file."
fi



########################################################################
#  This will copy the common files to the /etc directory.  
########################################################################

if [ $INSTALL_TYPE -eq 1 ] || [ $INSTALL_TYPE -eq 2 ]; then

   echo
   echo "Installing common files..........."

   mkdir -p /etc/snare/epilog

   # Are we on a sparc or x86 arch?
   uname -a | egrep "(i686|i386|i86pc)" > /dev/null
   if [ $? -eq 0 ]; then
	# Are we on a Solaris or Linux?
	uname | grep "Linux" > /dev/null
	if [ $? -gt 0 ]; then
		cp ./epilog.sol.x86 /usr/bin/epilog
	else
		cp ./epilog.linux /usr/bin/epilog
	fi
   else
	cp ./epilog.sol.sparc /usr/bin/epilog
   fi

   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the epilog program to /usr/bin. Terminating script"
     exit 1
   fi

   chown root:root /usr/bin/epilog
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change owner for file to /usr/bin/epilog. Terminating script"
     exit 1
   fi
   chmod  550 /usr/bin/epilog
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change the permissions for file to /usr/bin/epilog. Terminating script"
     exit 1
   fi

   cp ./epilog_start.sh  /etc/init.d/epilogd
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the startup script: /etc/init.d/epilogd. Terminating script"
     exit 1
   fi

   cp uninstall.sh /etc/snare/epilog_uninstall.sh
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the snare uninstall.sh script to /etc/snare. Terminating script"
     exit 1
   fi

   uname | grep Linux > /dev/null
   RETVAL=$?
   if [ $RETVAL -gt 0 ]; then
	   ln /etc/init.d/epilogd /etc/rc0.d/K33epilogd
	   ln /etc/init.d/epilogd /etc/rc1.d/K33epilogd
	   ln /etc/init.d/epilogd /etc/rc2.d/S99zepilogd
   else
	   ln -s /etc/init.d/epilogd /etc/rc0.d/K33epilogd
	   ln -s /etc/init.d/epilogd /etc/rc1.d/K33epilogd
	   ln -s /etc/init.d/epilogd /etc/rc2.d/S99zepilogd
	   ln -s /etc/init.d/epilogd /etc/rc3.d/S99zepilogd
	   ln -s /etc/init.d/epilogd /etc/rc4.d/S99zepilogd
	   ln -s /etc/init.d/epilogd /etc/rc5.d/S99zepilogd
	   ln -s /etc/init.d/epilogd /etc/rc6.d/K33epilogd
   fi
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to create etc/rc*.d files. Terminating script"
     exit 1
   fi

   echo
   echo "Successfully installed the common files"
   echo
fi

	
########################################################################
#  This will copy the basic files to /etc/snare/epilog
#  It will also change the owner and permissions for these files.
########################################################################

if [ $INSTALL_TYPE -eq 1 ]
then
   echo
   echo "Installing basic configuration files..........."

   cp ./epilog.conf.basic /etc/snare/epilog/epilog.conf
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the configuration file to /etc/snare/epilog. Terminating script"
     exit 1 
   fi
   chown root:root /etc/snare/epilog/epilog.conf
   chmod 600 /etc/snare/epilog/epilog.conf

fi

echo
echo "Successfully installed the necessary files. Activating monitoring..."
echo 

/etc/init.d/epilogd start
sleep 2

PID=`ps -e -u 0|fgrep epilog|egrep -v fgrep|awk '{print $1}'`
if [ -z "$PID" ] ;  then
        echo "Epilog not running. Please check installation parameters."
        exit 1;
fi

echo "Done."
echo
if [ $INSTALL_TYPE -ne 2 ]; then
        echo "Epilog will also be activated after a reboot via the"
        echo "init.d/epilogd startup script."
	echo
	echo "Please connect to the local machine using your web browser"
	echo "using the following URL: http://"`hostname`":6162/"
	echo "and a userid and password of 'snare'"
	echo "Once connected, please CHANGE THE DEFAULT PASSWORD, configure"
	echo "any additonal audit objectives you require, and restart"
	echo "the audit server".
	echo ""
else
	echo "Epilog has been upgraded. Note that Snare now supports"
	echo "passwords to be in MD5 hash format."
	echo ""
	echo "Recommend that you re-set the password used for snare"
	echo "remote access in order to take advantage of the new"
	echo "password scheme."
fi

exit 0
