#!/bin/sh
########################################################################
#    
#    (c) 2006 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of snare epilog for UNIX.
#   
#   Version 1.1
#    
#    Usage: ./install.sh
#
########################################################################

########################################################################
#   Check that the necessary files are contained within the local
#   directory. 
########################################################################

file_check()
{

     if [ ! -f epilog.linux ]
     then
        echo "The program epilog.linux binary file is missing. Terminating script."
        exit 1
     fi

     if [ ! -f epilog.conf.basic ]
     then
        echo "The new basic configuration file is missing. Terminating script."
        exit 1
     fi
}

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 1
        else
           echo "Confirmed that you are logged in as root"
	fi

}

########################################################################
#  This is the main loop  
########################################################################

file_check 
root_check
prefix=$1

# Kill off any outstanding pid files.
if [ -f /var/run/epilog.pid ]; then
	rm -f /var/run/epilog.pid >/dev/null 2>&1
fi

########################################################################
#  This will copy the common files to the /etc directory.  
########################################################################

   echo
   echo "Installing common files..........."

   cp ./epilog.linux $prefix/usr/bin/epilog

   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the epilog program to $prefix/usr/bin. Terminating script"
     exit 1
   fi

   chown root:root $prefix/usr/bin/epilog
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change owner for file to $prefix/usr/bin/epilog. Terminating script"
     exit 1
   fi
   chmod  550 $prefix/usr/bin/epilog
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to change the permissions for file to $prefix/usr/bin/epilog. Terminating script"
     exit 1
   fi

   cp ./epilog_start.sh  $prefix/etc/init.d/epilogd
   RETVAL=$?
   if [ $RETVAL -gt 0 ]
   then
     echo "Unable to copy the startup script: /etc/init.d/epilogd. Terminating script"
     exit 1
   fi

	
########################################################################
#  This will copy the basic files to /etc/snare/epilog
#  It will also change the owner and permissions for these files.
########################################################################

echo
echo "Installing basic configuration files..........."

cp ./epilog.conf.basic $prefix/etc/snare/epilog/epilog.conf
RETVAL=$?
if [ $RETVAL -gt 0 ]
then
     echo "Unable to copy the configuration file to /etc/snare/epilog. Terminating script"
     exit 1 
   fi
chown root:root $prefix/etc/snare/epilog/epilog.conf
chmod 600 $prefix/etc/snare/epilog/epilog.conf

#/etc/init.d/epilogd start
