#!/bin/sh

########################################################################
#    
#    (c) 2006 Intersect Alliance Pty Ltd
# 
#   This script will automate the installation of snare epilog for UNIX.
#   
#   Version 1.1
#    
#    Usage: ./uninstall.sh
#
########################################################################

########################################################################
#   Check that the user has an effective userid of 0 (root) 
########################################################################

root_check()
{
     id | grep -c uid=0 > /dev/null
     RETVAL=$?

	if [ $RETVAL -gt 0 ]
	then
           echo "You need to be root to run this script. Terminating script."
           exit 7
        else
           echo "Confirmed your are logged in as root"
	fi

}

restore_key_files()
{
   echo "Removing epilog binary..."
   if [ -f /usr/bin/epilog ]
   then
	rm /usr/bin/epilog 2>/dev/null
        echo "Done."
   fi

   echo "I will leave the snare configuration file (/etc/snare/epilog/epilog.conf) - please remove it manually if you intend to permanently remove SNARE..."
}

/etc/init.d/epilogd stop

root_check
restore_key_files

# Remove the snare-specific startup scripts
rm /etc/init.d/epilogd 2>/dev/null
rm /etc/rc0.d/K33epilogd 2>/dev/null
rm /etc/rc1.d/K33epilogd 2>/dev/null
rm /etc/rc2.d/S99zepilogd 2>/dev/null
rm /etc/rc3.d/S99zepilogd 2>/dev/null
rm /etc/rc4.d/S99zepilogd 2>/dev/null
rm /etc/rc5.d/S99zepilogd 2>/dev/null
rm /etc/rc6.d/K33epilogd 2>/dev/null

rm -f /var/run/epilog.pid 2>/dev/null
rm -f /etc/snare/epilog_uninstall.sh
