%define name	snare
%define version 0.9
%define release 1
%define prefix  /usr

Summary: A intrusion detection tool for GNOME
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/System
URL: http://www.intersectalliance.com/

Source: http://www.intersectalliance.com/snare/snare-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

Docdir: %{prefix}/share/doc

Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.2.0

%description
The Graphical User Interface component of the System iNtrusion Analysis and Reporting Environment (SNARE).

%prep

%setup

%build
CFLAGS="-O2" 
%ifarch i586
CFLAGS="-O2 -mpentium -march=pentium" 
%endif
%ifarch i686
CFLAGS="-O2 -mpentiumpro -march=pentiumpro" 
%endif
[ -f config.cache ] && rm config.cache          # force reconfigure
./configure --prefix=%{prefix} --sysconfdir=/etc
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
mkdir -p $RPM_BUILD_ROOT/usr/share/gnome/apps/System
mkdir -p $RPM_BUILD_ROOT/usr/share/gnome/ximian/Programs/Utilities
mkdir -p $RPM_BUILD_ROOT/usr/share/applnk/System
cp snare-icon.png $RPM_BUILD_ROOT/usr/share/pixmaps
cp snare-logo.png $RPM_BUILD_ROOT/usr/share/pixmaps
cp snare.desktop $RPM_BUILD_ROOT/usr/share/gnome/apps/System
cp snare.desktop $RPM_BUILD_ROOT/usr/share/gnome/ximian/Programs/Utilities
cp Snare.kdelnk $RPM_BUILD_ROOT/usr/share/applnk/System

make prefix=$RPM_BUILD_ROOT%{prefix} install

mv $RPM_BUILD_ROOT/usr/bin/snare $RPM_BUILD_ROOT/usr/sbin/
ln -s /usr/bin/consolehelper $RPM_BUILD_ROOT/%{prefix}/bin/snare

mkdir -p $RPM_BUILD_ROOT/etc/pam.d
cat > $RPM_BUILD_ROOT/etc/pam.d/snare <<EOF
auth       sufficient   /lib/security/pam_rootok.so
auth       required     /lib/security/pam_pwdb.so
session    optional     /lib/security/pam_xauth.so
account    required     /lib/security/pam_permit.so
EOF

mkdir -p $RPM_BUILD_ROOT/etc/security/console.apps
cat > $RPM_BUILD_ROOT/etc/security/console.apps/snare <<EOF
USER=root
FALLBACK=true
PROGRAM=/usr/sbin/snare
SESSION=true
EOF

%files
%defattr(-,root,root)
%doc README ChangeLog AUTHORS COPYING
%attr(755,root,root) %{prefix}/sbin/snare
%{prefix}/share/gnome/apps/System/snare.desktop
%{prefix}/share/gnome/ximian/Programs/Utilities/snare.desktop
%{prefix}/share/pixmaps/*
%{prefix}/bin/snare
/etc/pam.d/snare
/etc/security/console.apps/snare

%clean
rm -r $RPM_BUILD_ROOT

%changelog
* Mon Mar 25 2002 InterSect Alliance
- Updates for 0.9
* Mon Oct 29 2001 InterSect Alliance
- Initial release
