/************************************************************
 *
 * 1999 - 2001 (c) Intersect Alliance Pty Ltd.
 *
 * These routines implement the callbacks from the various
 * SNARE widget signals, created under Glade
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 ************************************************************
 * V0.9 1Feb02. Included the set_network_logging_pixmap() 
 * function.
 ************************************************************/

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "read_config.h"
#include "write_config.h"
#include "objectives_window.h"
#include "read_events.h"
#include "write_objective.h"
#include "daemon.h"
#include "event_window.h"

int objectives_clist_current_row_static = -1;
int mainclist_current_row_static = -1;
GtkWidget *objectives_clist_static;
GtkWidget *mainclist_static;
GtkWidget *eventwindow_static;
int objectives_clist_change_static;



void check_daemon_status (gpointer *button,gpointer user_data)
{
   daemon_status();
}

void reload_main_clist (gpointer *button, gpointer user_data)
{
   GtkWidget *main_display, *error_dialog;
   int result = 0;

   main_display = lookup_widget(GTK_WIDGET (button),"mainclist");

   gtk_clist_freeze(GTK_CLIST (main_display));
   gtk_clist_clear(GTK_CLIST (main_display));
   gtk_clist_thaw(GTK_CLIST (main_display));

   result = open_close_event_file(READ_EVENT_FILE_FROM_START);

   if (result > 0)
   {
      error_dialog = gnome_message_box_new("Beware: Event Log cannot be read",
                     GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
      gnome_dialog_run (GNOME_DIALOG (error_dialog));
   }

   update_main_clist();

}

void network_configuration (gpointer *button, gpointer user_data)
{
   GtkWidget *network_setup;

   network_setup = create_network_setup();
   gtk_widget_show (network_setup);

}


void clear_main_clist (gpointer *menuitem, gpointer user_data)
{
   GtkWidget *main_display;

   main_display = lookup_widget(GTK_WIDGET (menuitem),"mainclist");

   gtk_clist_freeze(GTK_CLIST (main_display));
   gtk_clist_clear(GTK_CLIST (main_display));
   gtk_clist_thaw(GTK_CLIST (main_display));

}

void restart_daemon (gpointer *button, gpointer user_data)
{
   
   reload_daemon();

   open_close_event_file(CLOSE_EVENT_FILE);
   open_close_event_file(OPEN_EVENT_FILE);
   open_close_event_file(READ_EVENT_FILE_FROM_END);
    
   set_pixmap();
} 


void create_the_event_window(void)
{
   GtkWidget *event_details;

   event_details = create_event_details();
   eventwindow_static = event_details;
}


void mainclist_select_row(GtkCList *clist,gint row,gint column,GdkEvent *event, gpointer user_data)
{
   GtkWidget *previous_button, *next_button;

   mainclist_current_row_static = row; 
   mainclist_static = (GtkWidget *) clist;

   previous_button = lookup_widget(GTK_WIDGET (eventwindow_static),"previous_button");
   next_button = lookup_widget(GTK_WIDGET (eventwindow_static),"next_button");
   gtk_widget_set_sensitive(previous_button,TRUE);
   gtk_widget_set_sensitive(next_button,TRUE);
   
   if ((mainclist_current_row_static >= (GTK_CLIST(mainclist_static)->rows - 1)) &&
       (mainclist_current_row_static <= 0))
   {
      gtk_widget_set_sensitive(next_button,FALSE);
      gtk_widget_set_sensitive(previous_button,FALSE);
   }
   if (mainclist_current_row_static >= (GTK_CLIST(mainclist_static)->rows - 1))
       gtk_widget_set_sensitive(next_button,FALSE);
   else if (mainclist_current_row_static <= 0)
      gtk_widget_set_sensitive(previous_button,FALSE);

   if (mainclist_current_row_static > -1)
      display_event(clist,row,(GtkWindow *)eventwindow_static);
}


void next_button_clicked(GtkButton *button,gpointer user_data)
{

   if (mainclist_current_row_static < (GTK_CLIST(mainclist_static)->rows - 1))
   { 
      mainclist_current_row_static = mainclist_current_row_static + 1;
      gtk_clist_moveto(GTK_CLIST(mainclist_static),mainclist_current_row_static,0,0.5,0.0);
      gtk_clist_select_row((GtkCList *)mainclist_static,mainclist_current_row_static,0);
   }
}


void previous_button_clicked(GtkButton *button,gpointer user_data)
{
   
   if (mainclist_current_row_static > 0)
   {
      mainclist_current_row_static = mainclist_current_row_static - 1;
      gtk_clist_moveto(GTK_CLIST(mainclist_static),mainclist_current_row_static,0,0.5,0.0);
      gtk_clist_select_row((GtkCList *)mainclist_static,mainclist_current_row_static,0);
   }
}




void audit_configuration (gpointer *menuitem, gpointer user_data)
{
  GtkWidget *audit_config, *obj_clist, *create_new;

  audit_config = create_audit_configuration();
    
  if (read_configuration(audit_config) == FALSE)
  {
     create_new = create_default_config_window();
     gtk_widget_show(create_new);
  }
  else
  {
     obj_clist = lookup_widget(GTK_WIDGET (audit_config),"objectives_clist");
     objectives_clist_static = obj_clist;
     gtk_widget_show(audit_config);
  }
}


void menu_exit_activate (GtkMenuItem *menuitem,gpointer user_data)
{
   open_close_event_file(CLOSE_EVENT_FILE);
   gtk_main_quit();
}


void save_configuration_button_clicked(gpointer *button,gpointer user_data)
{
   GtkWidget *config_window;
   int result;

   config_window = lookup_widget(GTK_WIDGET (user_data),"audit_configuration");
   result = write_configuration(config_window);
   if (result == TRUE)
   {
      gtk_widget_destroy(config_window);
   }

}


void menu_about (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *about_window;

   about_window = create_about();
   gtk_widget_show (about_window);
}


void objectives_clist_select_row(GtkCList *clist,gint row,gint column,GdkEvent *event,gpointer user_data)
{
   objectives_clist_current_row_static = row;
}

void objectives_clist_unselect_row(GtkCList *clist,gint row,gint column,GdkEvent *event,gpointer user_data)
{
   objectives_clist_current_row_static = -1;
}


void objectives_clist_button_press(GtkWidget *widget,GdkEventButton *event,gpointer user_data)
{
  GtkWidget *popup_menu, *popup_edit_menuitem, *popup_delete_menuitem;

  if ((event->button == 3) && (objectives_clist_current_row_static == -1))
  {
     popup_menu = create_objectives_popup_menu();
     popup_edit_menuitem = lookup_widget( (GtkWidget *) popup_menu,"edit_objective");     
     popup_delete_menuitem = lookup_widget( (GtkWidget *) popup_menu,"delete_objective");
     gtk_widget_set_sensitive(popup_edit_menuitem,FALSE);
     gtk_widget_set_sensitive(popup_delete_menuitem,FALSE);
     gtk_menu_popup (GTK_MENU(popup_menu), NULL, NULL, NULL, NULL,event->button,event->time);
     gtk_widget_show (popup_menu);
  }
  else if ((event->button == 3) && (objectives_clist_current_row_static > -1))  
  {
     popup_menu = create_objectives_popup_menu();
     gtk_menu_popup (GTK_MENU(popup_menu), NULL, NULL, NULL, NULL,event->button,event->time);
     gtk_widget_show (popup_menu);
  }
}




void edit_objective_menu_activate(GtkMenuItem *menuitem,gpointer user_data)
{
   //NEED TO MOVE ALL OF THIS INTO THE update_objective_window FUNCTION
   gchar *alert, *success, *users, *events, *filter, *user_match, *filter_match;

  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,0,&alert);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,1,&success);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,2,&user_match);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,3,&users);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,4,&filter_match);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,5,&filter);
  gtk_clist_get_text(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static,6,&events);


  objectives_clist_change_static = CHANGE;

  update_objective_window(alert,success,user_match,users,filter_match,filter,events,objectives_clist_current_row_static);

}


void delete_objective_menu_activate(GtkMenuItem *menuitem,gpointer user_data)
{

   gtk_clist_freeze(GTK_CLIST (objectives_clist_static));
   gtk_clist_remove(GTK_CLIST (objectives_clist_static),objectives_clist_current_row_static);
   gtk_clist_thaw(GTK_CLIST (objectives_clist_static));

}


void add_an_objective_button_clicked(GtkButton *button,gpointer user_data)
{
   GtkWidget *audit_objective_window, *objectives_clist;

   objectives_clist = lookup_widget( (GtkWidget *) button,"objectives_clist");

   objectives_clist_change_static = ADD;
   objectives_clist_static = objectives_clist;

   audit_objective_window = create_audit_objectives();

   // THIS IS TO DRAW THE PIXMAPS FOR THE ALERT LEVELS
   draw_alert_level_pixmaps(audit_objective_window);
   gtk_widget_show (audit_objective_window);
}


void save_objective_button_clicked(gpointer *button,gpointer user_data)
{

   write_objective(objectives_clist_static,(GtkWidget *) user_data,objectives_clist_current_row_static,objectives_clist_change_static);

   gtk_widget_destroy((GtkWidget *) user_data);
         
}

void save_and_apply_clicked(gpointer *button,gpointer user_data)
{
    save_configuration_button_clicked(button,user_data);

    restart_daemon ((gpointer *) NULL, (gpointer) NULL);
    
    set_pixmap();
}



void mail_configuration(GtkButton *button,gpointer user_data)
{
   GtkWidget *mail_setup;

   mail_setup = create_mail_setup();
   gtk_widget_show (mail_setup);
}



void suggestions_window(GtkMenuItem *menuitem,gpointer user_data)
{
   GtkWidget *suggestions_window;

   suggestions_window = create_suggestions_window();
   gtk_widget_show (suggestions_window);

}

void create_new_config_file(GtkButton *button, gpointer user_data)
{
   GtkWidget *audit_config, *default_window;

   audit_config = create_audit_configuration();
   write_configuration(audit_config);  
   gtk_widget_destroy(audit_config);

   default_window = lookup_widget( (GtkWidget *) button,"default_config_window");    
   gtk_widget_destroy(default_window);

}


void network_documentation(GtkButton *button,gpointer user_data)
{
   gnome_url_show("file:///usr/share/doc/snare-core-0.9/doc/index.html#Network_Configuration");

}


void audit_configuration_documentation(GtkButton *button,gpointer user_data)
{
   gnome_url_show("file:///usr/share/doc/snare-core-0.9/doc/index.html#Audit_Configuration");
   
}


void audit_objectives_documentation(GtkButton *button, gpointer user_data)
{
   gnome_url_show("file:///usr/share/doc/snare-core-0.9/doc/index.html#Audit_Configuration");
}

void documentation(gpointer *menuitem, gpointer user_data)
{  

   gnome_url_show("file:///usr/share/doc/snare-core-0.9/doc/index.html"); 
}
