/************************************************************
 *
 * 1999 - 2001 (c) Intersect Alliance Pty Ltd.
 *
 * These functions undertake the necessary tasks required
 * to read and report on the audit daemon.
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <signal.h>
#include "support.h"
#include "interface.h"
#include "daemon.h"
#include "read_config.h"


void reload_daemon(void)
{
   int pid, result;
   GtkWidget *error_dialog;

   pid=get_pid();
   if(pid > 0) 
   {
      // SEND USR1 TO INITIATE A DAEMON RELOAD
      result = kill((pid_t)pid,SIGUSR1);
      if (result == 0)
      {
         error_dialog = gnome_message_box_new("Audit daemon restarted",
                     GNOME_MESSAGE_BOX_INFO,GNOME_STOCK_BUTTON_OK,NULL);
         gnome_dialog_run (GNOME_DIALOG (error_dialog));
      }
      else
      {
         error_dialog = gnome_message_box_new("SNARE does not have permissions to restart the audit daemon",
                     GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
         gnome_dialog_run (GNOME_DIALOG (error_dialog));
      }
   }
   else
   {
      error_dialog = gnome_message_box_new("Audit daemon not active, or unable to open /proc/auditinfo",
                     GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
      gnome_dialog_run (GNOME_DIALOG (error_dialog));
   }
}

int get_pid(void)
{
   FILE * auditinfo;
   char configline[LARGE_TOKEN_SIZE];
   char *linepos;
   int pid=0;

   auditinfo=fopen("/proc/auditinfo","r");

   if(auditinfo == (FILE *) NULL) 
      return 0;
   
   while(fgets(configline,LARGE_TOKEN_SIZE,auditinfo)) 
   {
      if(strstr(configline,"Audit Process ID: ")) 
      {
	 linepos=configline;
	 linepos+=strlen("Audit Process ID: ");
         pid=atoi(linepos);
      }
   }

   fclose(auditinfo);

   return pid;
}

void daemon_status(void)
{
   FILE * auditinfo;
   char configline[LARGE_TOKEN_SIZE];
   char alive[TOKEN_SIZE]="No";
   char version[TOKEN_SIZE]="audit not running";
   char process_id[TOKEN_SIZE] = "audit not running";
   int lost=0, recvd=0;
   int pid=0;  //, result=0;
   char *buffer;
   char stats[TOKEN_SIZE], total_events[TOKEN_SIZE];
   float result = 100.0;
   GtkWidget *audit_status, *version_label, *id_label, *active_label, *stats_label, *error_dialog;
   GtkWidget *total_label;

   pid=get_pid();
   if(pid > 0)
   {  
      auditinfo=fopen("/proc/auditinfo","r");

      if(auditinfo == (FILE *) NULL)
      {
         error_dialog = gnome_message_box_new("Cannot open /proc/auditinfo. It appears the audit daemon is not active.",
                     GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
         gnome_dialog_run (GNOME_DIALOG (error_dialog));
         return;
      }

      while(fgets(configline,1024,auditinfo))
      {
         if(strstr(configline,"Audit Process ID: "))
            {sscanf(configline,"%*[^:]:%256[^\n]\n",process_id);}
         if(strstr(configline,"SNARE Version: "))
            {sscanf(configline,"%*[^:]:%256[^\n]\n",version);}
         if(strstr(configline,"Events Lost This Session: "))
         {
            buffer=configline;
            buffer+=strlen("Events Lost This Session: ");
            lost=atoi(buffer);
         }
         if(strstr(configline,"Events Processed This Session: "))
         {
            buffer=configline;
            buffer+=strlen("Events Processed This Session: ");
            recvd=atoi(buffer);
         }
      }

      strcpy(alive,"Yes");
      fclose(auditinfo);
   }


  if (recvd > 0)
  {
     result = (100.0 - ((float) lost/(float)recvd * 100.0) );
     snprintf(stats,6,"%f",result);
     snprintf(total_events,20,"%d",recvd);
  }
  else
  { 
     strcpy(stats,"No events received");
     strcpy(total_events,"No events received");
  }


  audit_status = create_status_window();

  version_label = lookup_widget(audit_status,"version_label");
  id_label = lookup_widget(audit_status,"id_label");
  active_label = lookup_widget(audit_status,"active_label");
  stats_label = lookup_widget(audit_status,"stats_label");
  total_label = lookup_widget(audit_status,"total_label");

  gtk_label_set_text(GTK_LABEL (id_label),process_id);
  gtk_label_set_text(GTK_LABEL (active_label),alive);
  gtk_label_set_text(GTK_LABEL (version_label),version);
  gtk_label_set_text(GTK_LABEL (stats_label),stats);
  gtk_label_set_text(GTK_LABEL (total_label),total_events);
 
  gtk_widget_show (audit_status);
}

