/************************************************************
 *
 * 1999 - 2001 (c) Intersect Alliance Pty Ltd.
 *
 * These functions undertake the necessary tasks required
 * to display the details for an event.
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 ************************************************************
 * V0.9 1Feb02. Added a new 'socket' token
 ************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <stdlib.h>

#include "support.h"
#include "interface.h"
#include "read_events.h"
#include "read_config.h"
#include "event_window.h"

static GdkBitmap *clist_mask;
static GdkBitmap *window_mask;
static GdkColormap *colormap;

void display_event(GtkCList *clist,gint row,GtkWindow *event_details)
{
  GtkWidget *datetime_entry, *criticality_entry;
  GtkWidget *path_frame, *socket_frame;
  char *datetime, *details, *extended_details;
  char token1[LARGE_TOKEN_SIZE]="NULL", token2[LARGE_TOKEN_SIZE]="NULL", token3[LARGE_TOKEN_SIZE]="NULL";
  char token4[LARGE_TOKEN_SIZE]="NULL", token5[LARGE_TOKEN_SIZE]="NULL", token6[LARGE_TOKEN_SIZE]="NULL";
  char token7[LARGE_TOKEN_SIZE]="NULL", token8[LARGE_TOKEN_SIZE]="NULL",  token0[LARGE_TOKEN_SIZE]="NULL";
  char token9[LARGE_TOKEN_SIZE]="NULL";
  char *token[10] = {token0,token1,token2,token3,token4,token5,token6,token7,token8,token9} ;
  char header_temp[LARGE_TOKEN_SIZE]="NULL";
  char temp_extended_details[LARGE_TOKEN_SIZE]="NULL"; // NEED THIS SINCE strtok EATS THINGS UP
  GdkPixmap *pixmap_test;
  int critic_return, loop_value;


  path_frame = lookup_widget(GTK_WIDGET (event_details),"path_frame");
  socket_frame = lookup_widget(GTK_WIDGET (event_details),"socket_frame");
  gtk_widget_hide(path_frame);
  gtk_widget_hide(socket_frame);
   
  gtk_clist_get_text(GTK_CLIST (clist),row,1,&datetime);
  gtk_clist_get_text(GTK_CLIST (clist),row,2,&details);
  gtk_clist_get_text(GTK_CLIST (clist),row,3,&extended_details);

  //INCLUDE FOR ALL POSSIBLE TOKENS
  strcpy(temp_extended_details,extended_details);  // NEED THIS FOR strtok...so CLIST ISN'T EATEN UP
  token[0] = strtok(temp_extended_details,"\t");
  token[1] = strtok(0,"\t");
  token[2] = strtok(0,"\t");
  token[3] = strtok(0,"\t");
  token[4] = strtok(0,"\t");
  token[5] = strtok(0,"\t");
  token[6] = strtok(0,"\t");
  token[7] = strtok(0,"\t");
  token[8] = strtok(0,"\t");
  token[9] = strtok(0,"\t");

  for(loop_value = 0; loop_value < 10; loop_value++)
  {
     if (token[loop_value] != (char *)NULL)
     {
        strcpy(header_temp,token[loop_value]);
        read_event_header(header_temp,(GtkWidget *)event_details,loop_value);
     }
  }


  criticality_entry = lookup_widget(GTK_WIDGET (event_details),"criticality_entry");
  datetime_entry = lookup_widget(GTK_WIDGET (event_details),"datetime_entry");
  gtk_entry_set_text( GTK_ENTRY (datetime_entry), datetime);
  gtk_clist_get_pixmap(GTK_CLIST(clist),row,0,&pixmap_test,&clist_mask);
  critic_return = find_pixmap_type(pixmap_test);

  if (critic_return == CRITICALITY_CRITICAL)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Critical");
  else if (critic_return == CRITICALITY_PRIORITY)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Priority");
  else if (critic_return == CRITICALITY_WARNING)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Warning");
  else if (critic_return == CRITICALITY_INFO)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Information");
  else
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Clear");

  gtk_widget_show ((GtkWidget *)event_details);
}



void read_event_header(char *string, GtkWidget *display_window, int first_time_called)
{
   char *header="Nil header included";
   char *ruid, *rgid, *euid, *egid, *pid, *procname, *argument, *path, *destpath, *attributes;
   char *return_code, *event, *target, *user_owner, *group_owner;
   char *sourceip, *destip, *sourceport, *destport;
   GtkWidget *ruid_entry, *rgid_entry, *euid_entry, *egid_entry, *procname_entry, *procid_entry;
   GtkWidget *ruid_label, *rgid_label, *euid_label, *egid_label, *procname_label, *procid_label;
   GtkWidget *arg_entry, *path_entry, *attributes_entry, *destpath_entry, *return_entry;
   GtkWidget *arg_label, *destpath_label, *attributes_label, *event_entry, *path_label, *return_label;
   GtkWidget *user_owner_label, *group_owner_label, *user_owner_entry, *group_owner_entry;
   GtkWidget *target_label, *target_entry;
   GtkWidget *sourceip_label, *sourceport_label, *sourceip_entry, *sourceport_entry;
   GtkWidget *destip_label, *destport_label, *destip_entry, *destport_entry;
   GtkWidget *path_frame, *socket_frame;

   ruid_entry = lookup_widget(GTK_WIDGET (display_window),"ruid_entry");
   rgid_entry = lookup_widget(GTK_WIDGET (display_window),"rgid_entry");
   euid_entry = lookup_widget(GTK_WIDGET (display_window),"euid_entry");
   egid_entry = lookup_widget(GTK_WIDGET (display_window),"egid_entry");
   ruid_label = lookup_widget(GTK_WIDGET (display_window),"ruid_label");
   rgid_label = lookup_widget(GTK_WIDGET (display_window),"rgid_label");
   euid_label = lookup_widget(GTK_WIDGET (display_window),"euid_label");
   egid_label = lookup_widget(GTK_WIDGET (display_window),"egid_label");
   procname_entry = lookup_widget(GTK_WIDGET (display_window),"procname_entry");
   procid_entry = lookup_widget(GTK_WIDGET (display_window),"procid_entry");
   procname_label = lookup_widget(GTK_WIDGET (display_window),"procname_label");
   procid_label = lookup_widget(GTK_WIDGET (display_window),"procid_label");
   arg_entry = lookup_widget(GTK_WIDGET (display_window),"arg_entry");
   arg_label = lookup_widget(GTK_WIDGET (display_window),"arg_label");
   path_entry = lookup_widget(GTK_WIDGET (display_window),"path_entry");
   path_label = lookup_widget(GTK_WIDGET (display_window),"path_label");
   destpath_entry = lookup_widget(GTK_WIDGET (display_window),"destpath_entry");
   destpath_label = lookup_widget(GTK_WIDGET (display_window),"destpath_label");
   attributes_entry = lookup_widget(GTK_WIDGET (display_window),"attributes_entry");
   attributes_label = lookup_widget(GTK_WIDGET (display_window),"attributes_label");
   return_entry = lookup_widget(GTK_WIDGET (display_window),"return_entry");
   return_label = lookup_widget(GTK_WIDGET (display_window),"return_label");
   user_owner_label = lookup_widget(GTK_WIDGET (display_window),"user_owner_label");
   group_owner_label = lookup_widget(GTK_WIDGET (display_window),"group_owner_label");
   user_owner_entry = lookup_widget(GTK_WIDGET (display_window),"user_owner_entry");
   group_owner_entry = lookup_widget(GTK_WIDGET (display_window),"group_owner_entry");
   target_label = lookup_widget(GTK_WIDGET (display_window),"target_label");
   target_entry = lookup_widget(GTK_WIDGET (display_window),"target_entry"); 
   sourceip_label = lookup_widget(GTK_WIDGET (display_window),"sourceip_label");
   sourceport_label = lookup_widget(GTK_WIDGET (display_window),"sourceport_label");
   sourceip_entry = lookup_widget(GTK_WIDGET (display_window),"sourceip_entry");
   sourceport_entry = lookup_widget(GTK_WIDGET (display_window),"sourceport_entry");
   destip_label = lookup_widget(GTK_WIDGET (display_window),"destip_label");
   destport_label = lookup_widget(GTK_WIDGET (display_window),"destport_label");
   destip_entry = lookup_widget(GTK_WIDGET (display_window),"destip_entry");
   destport_entry = lookup_widget(GTK_WIDGET (display_window),"destport_entry");
   path_frame = lookup_widget(GTK_WIDGET (display_window),"path_frame");
   socket_frame = lookup_widget(GTK_WIDGET (display_window),"socket_frame");
      
   if (first_time_called == 0)
   {
      // SET ALL THE LABEL AND ENTRY WIDGETS AS INSENSITIVE, IN CASE THE WINDOW HAS BEEN RECALLED
      // USING THE "PREV" OR "NEXT" BUTTONS
      gtk_widget_set_sensitive(ruid_entry,FALSE);
      gtk_widget_set_sensitive(rgid_entry,FALSE);
      gtk_widget_set_sensitive(euid_entry,FALSE);
      gtk_widget_set_sensitive(egid_entry,FALSE);
      gtk_widget_set_sensitive(procid_entry,FALSE);
      gtk_widget_set_sensitive(procname_entry,FALSE);
      gtk_widget_set_sensitive(arg_entry,FALSE);
      gtk_widget_set_sensitive(path_entry,FALSE);
      gtk_widget_set_sensitive(destpath_entry,FALSE);
      gtk_widget_set_sensitive(attributes_entry,FALSE);
      gtk_widget_set_sensitive(return_entry,FALSE);
      gtk_widget_set_sensitive(user_owner_entry,FALSE);
      gtk_widget_set_sensitive(group_owner_entry,FALSE);
      gtk_widget_set_sensitive(target_entry,FALSE);
      gtk_widget_set_sensitive(sourceip_entry,FALSE);
      gtk_widget_set_sensitive(sourceport_entry,FALSE);
      gtk_widget_set_sensitive(destip_entry,FALSE);
      gtk_widget_set_sensitive(destport_entry,FALSE);
 
      gtk_entry_set_text( GTK_ENTRY (ruid_entry), "");
      gtk_entry_set_text( GTK_ENTRY (rgid_entry), "");
      gtk_entry_set_text( GTK_ENTRY (euid_entry), "");
      gtk_entry_set_text( GTK_ENTRY (egid_entry), "");
      gtk_entry_set_text( GTK_ENTRY (procid_entry), "");
      gtk_entry_set_text( GTK_ENTRY (procname_entry), "");
      gtk_entry_set_text( GTK_ENTRY (arg_entry), "");
      gtk_entry_set_text( GTK_ENTRY (path_entry), "");
      gtk_entry_set_text( GTK_ENTRY (destpath_entry), "");
      gtk_entry_set_text( GTK_ENTRY (attributes_entry), "");
      gtk_entry_set_text( GTK_ENTRY (return_entry), ""); 
      gtk_entry_set_text( GTK_ENTRY (user_owner_entry), "");
      gtk_entry_set_text( GTK_ENTRY (group_owner_entry), "");
      gtk_entry_set_text( GTK_ENTRY (target_entry), "");
      gtk_entry_set_text( GTK_ENTRY (sourceip_entry), ""); 
      gtk_entry_set_text( GTK_ENTRY (sourceport_entry), "");
      gtk_entry_set_text( GTK_ENTRY (destip_entry), "");
      gtk_entry_set_text( GTK_ENTRY (destport_entry), "");

      gtk_widget_set_sensitive(ruid_label,FALSE);
      gtk_widget_set_sensitive(rgid_label,FALSE);
      gtk_widget_set_sensitive(euid_label,FALSE);
      gtk_widget_set_sensitive(egid_label,FALSE);
      gtk_widget_set_sensitive(procid_label,FALSE);
      gtk_widget_set_sensitive(procname_label,FALSE);
      gtk_widget_set_sensitive(arg_label,FALSE);
      gtk_widget_set_sensitive(path_label,FALSE);
      gtk_widget_set_sensitive(destpath_label,FALSE);
      gtk_widget_set_sensitive(attributes_label,FALSE);
      gtk_widget_set_sensitive(return_label,FALSE);
      gtk_widget_set_sensitive(user_owner_label,FALSE);
      gtk_widget_set_sensitive(group_owner_label,FALSE);
      gtk_widget_set_sensitive(target_label,FALSE);
      gtk_widget_set_sensitive(sourceip_label,FALSE);
      gtk_widget_set_sensitive(sourceport_label,FALSE);
      gtk_widget_set_sensitive(destip_label,FALSE);
      gtk_widget_set_sensitive(destport_label,FALSE);
   }

   strcat(string,","); //MAKE IT EASY TO READ ALL THE COMMA SEPARATED TOKENS
   header = strtok(string,","); //READ THE TOKEN HEADER

   if (strcasecmp(header,"event") == 0)
   {   
      event_entry = lookup_widget(GTK_WIDGET (display_window),"event_entry");   
      event = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (event_entry), event);
   }
   else if (strcasecmp(header,"user") == 0)
   {
      gtk_widget_set_sensitive(ruid_entry,TRUE); 
      gtk_widget_set_sensitive(rgid_entry,TRUE);
      gtk_widget_set_sensitive(euid_entry,TRUE);
      gtk_widget_set_sensitive(egid_entry,TRUE);
      gtk_widget_set_sensitive(ruid_label,TRUE);
      gtk_widget_set_sensitive(rgid_label,TRUE);
      gtk_widget_set_sensitive(euid_label,TRUE);
      gtk_widget_set_sensitive(egid_label,TRUE);
      ruid = strtok(0,",");
      rgid = strtok(0,",");
      euid = strtok(0,",");
      egid = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (ruid_entry), ruid);
      gtk_entry_set_text( GTK_ENTRY (rgid_entry), rgid);
      gtk_entry_set_text( GTK_ENTRY (euid_entry), euid);
      gtk_entry_set_text( GTK_ENTRY (egid_entry), egid);
   } 
   else if (strcasecmp(header,"socket") == 0)
   {
      gtk_widget_show(socket_frame);
      gtk_widget_set_sensitive(sourceip_entry,TRUE); 
      gtk_widget_set_sensitive(sourceport_entry,TRUE);
      gtk_widget_set_sensitive(destip_entry,TRUE);
      gtk_widget_set_sensitive(destport_entry,TRUE);
      gtk_widget_set_sensitive(sourceip_label,TRUE);
      gtk_widget_set_sensitive(sourceport_label,TRUE);
      gtk_widget_set_sensitive(destip_label,TRUE);
      gtk_widget_set_sensitive(destport_label,TRUE);
      sourceip = strtok(0,",");
      destip = strtok(0,",");
      sourceport = strtok(0,",");
      destport = strtok(0,",");
      
      gtk_entry_set_text( GTK_ENTRY (sourceip_entry), sourceip);
      gtk_entry_set_text( GTK_ENTRY (sourceport_entry), sourceport);
      gtk_entry_set_text( GTK_ENTRY (destip_entry), destip);
      gtk_entry_set_text( GTK_ENTRY (destport_entry), destport);
   }
   else if (strcasecmp(header,"process") == 0)
   {
      gtk_widget_set_sensitive(procid_entry,TRUE);
      gtk_widget_set_sensitive(procname_entry,TRUE);
      gtk_widget_set_sensitive(procid_label,TRUE);
      gtk_widget_set_sensitive(procname_label,TRUE);
      pid = strtok(0,",");
      procname = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (procid_entry), pid);
      gtk_entry_set_text( GTK_ENTRY (procname_entry), procname);
   }
   else if (strcasecmp(header,"owner") == 0)
   {
      gtk_widget_show(path_frame);
      gtk_widget_set_sensitive(user_owner_entry,TRUE);
      gtk_widget_set_sensitive(group_owner_entry,TRUE);
      gtk_widget_set_sensitive(user_owner_label,TRUE);
      gtk_widget_set_sensitive(group_owner_label,TRUE);
      user_owner = strtok(0,",");
      group_owner = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (user_owner_entry), user_owner);
      gtk_entry_set_text( GTK_ENTRY (group_owner_entry), group_owner);
   }
   else if (strcasecmp(header,"arguments") == 0)
   {
      gtk_widget_set_sensitive(arg_entry,TRUE);
      gtk_widget_set_sensitive(arg_label,TRUE);
      argument = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (arg_entry), argument);
   }
   else if (strcasecmp(header,"target") == 0)
   {
      gtk_widget_set_sensitive(target_entry,TRUE);
      gtk_widget_set_sensitive(target_label,TRUE);
      target = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (target_entry), target);
   }
   else if (strcasecmp(header,"path") == 0)
   {
      gtk_widget_show(path_frame);
      gtk_widget_set_sensitive(path_entry,TRUE);
      gtk_widget_set_sensitive(path_label,TRUE);
      path = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (path_entry), path);
   }
   else if (strcasecmp(header,"destpath") == 0)
   {
      gtk_widget_show(path_frame);
      gtk_widget_set_sensitive(destpath_entry,TRUE);
      gtk_widget_set_sensitive(destpath_label,TRUE);
      destpath = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (destpath_entry), destpath);
   }
   else if (strcasecmp(header,"attributes") == 0)
   {
      gtk_widget_show(path_frame);
      gtk_widget_set_sensitive(attributes_entry,TRUE);
      gtk_widget_set_sensitive(attributes_label,TRUE);
      attributes = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (attributes_entry), attributes);
   }


   else if (strcasecmp(header,"return") == 0)
   {
      gtk_widget_set_sensitive(return_entry,TRUE);
      gtk_widget_set_sensitive(return_label,TRUE);
      return_code = strtok(0,",");
      gtk_entry_set_text( GTK_ENTRY (return_entry), return_code);
   }
}


