/************************************************************
 *
 * 1999 - 2001 (c) Intersect Alliance Pty Ltd.
 *
 * This is the main routine that initialises the main vars,
 * and defines the timeout function and period for reading
 * the event log file.
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 *
 ************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include "support.h"
#include "interface.h"
#include "read_events.h"
#include "read_config.h"
#include "callbacks.h"


int  main (int argc, char *argv[])
{
  
  GtkWidget *main_window;


  #ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
  #endif

  gnome_init ("snare", VERSION, argc, argv);

  main_window = create_main_window();
  gtk_widget_show (main_window);

  read_log_file_and_type(READ_EVENT_FILE_FROM_END);

  // THIS IS TO DEFINE, BUT NOT SHOW, THE EVENT WINDOW
  create_the_event_window();

  // A CALL TO CREATE THE VARIOUS PIXMAPS USED IN SNARE
  create_pixmaps(main_window); 
  
  //THIS CALL IS TO DRAW THE "RAW"/"FILTERED" PIXMAP
  draw_audit_type_pixmap(main_window,READ_TYPE_FROM_STRUCT);

  // THIS IS THE MAIN CALL TO CHECK FOR NEW EVENTS AT REGULAR INTERVALS
  gtk_timeout_add (READ_LOG_INTERVAL,(GtkFunction)update_main_clist,(gpointer)NULL);
  

  gtk_main();

  return 0;
}


