/************************************************************
 *
 * 1999 - 2001 (c) Intersect Alliance Pty Ltd.
 *
 * These routines support the reading of the event log file,
 * management of the log file, and drawing the pixmaps
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 ************************************************************
 * V0.9 1Feb02. Changed code significantly to cater for new
 * network type and pixmap
 ************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>

#include "read_events.h"
#include "read_config.h"
#include "support.h"
#include "check_file.h"
#include "pixmaps.h"

char event_log_filename_static[LARGE_TOKEN_SIZE]="NULL";
int error_reported_static = 0;

static char file_line[BUFR_SIZE];

static struct read_events_struct event_struct_store;
static struct read_events_struct *read_variables = &event_struct_store;

static GdkBitmap *clist_mask;
static GdkBitmap *window_mask;
static GdkColormap *colormap;

gint update_main_clist(void)
{

   gchar alert[SMALL_TOKEN_SIZE]="NULL";
   gchar date_time[SMALL_TOKEN_SIZE]="NULL";
   gchar details[LARGE_TOKEN_SIZE]="NULL";
   gchar temp_buffer_1[LARGE_TOKEN_SIZE]="NULL";
   gchar temp_buffer_2[LARGE_TOKEN_SIZE]="NULL";
   gchar header[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_1[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_2[SMALL_TOKEN_SIZE]="NULL";
   gchar extended_details[LARGE_TOKEN_SIZE]="NULL";
   gchar *line[4]={alert,date_time,details,extended_details};
   GtkWidget *main_display, *main_display_pixmap, *error_dialog;
   int current_row=0, file_lines_to_be_read = 1;
   int result_filename = 0, auditing_type = AUDIT_BY_OBJECTIVE, last_clist_row, move_to_command = 0;

   
   main_display = lookup_widget(read_variables->main_window,"mainclist");
   main_display_pixmap = lookup_widget(read_variables->main_window,"view_pixmap");


   // THIS DETERMINES WHETHER THE CLIST NEEDS TO "MOVE TO" THE END. THIS WILL DEPEND
   // ON WHETHER THE USER HAS SCROLLED OFF THE LAST ROW, SO IT ISN'T VISIBLE
   // WHICH IS WHAT THE NEXT FEW LINES DETERMINE. WE NEED TO DO THIS, BEFORE WE
   // START READING ANY LINES.
   last_clist_row = GTK_CLIST(main_display)->rows - 1;
   if (last_clist_row < 1)
      last_clist_row = 0;
   if ((gtk_clist_row_is_visible((GtkCList *)main_display,last_clist_row) != GTK_VISIBILITY_FULL) &&
       (last_clist_row > 0))
           move_to_command = 1;


   // THIS NEXT SECTION DOES THE FILE CHECKING
   result_filename = check_filename();
   if ((read_variables->events_file==(FILE *)NULL) || (result_filename == FILE_NON_EXIST))
   {
      if (error_reported_static < 1)
      {
         error_dialog = gnome_message_box_new("Warning: Event Log cannot be read.\nThis may be caused by \"auditing to the network only\".\n If this is not the case, then restart the audit daemon.",
                  GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
         gnome_dialog_run (GNOME_DIALOG (error_dialog)); 
      }
      error_reported_static = 1;
      return -1;
   }
   else if (result_filename == FILE_CHANGED)
   {
      open_close_event_file(CLOSE_EVENT_FILE);
      open_close_event_file(OPEN_EVENT_FILE);
      open_close_event_file(READ_EVENT_FILE_FROM_START); 
   }
   else
      error_reported_static = 0;


   // THESE LINES WILL READ THE EVENTS FILE AND DISPLAY THE RESULTS TO THE MAIN CLIST 
   while (fgets(file_line,BUFR_SIZE,read_variables->events_file) != NULL)
   {
      if (file_lines_to_be_read == 1)
      {
         gtk_clist_freeze(GTK_CLIST (main_display));
         file_lines_to_be_read = 0;
      }

      // NEED TO LOOK AT THE HEADER, FIRST
      sscanf(file_line,"%64[^\t]\t%64[^\t]\t%64[^,]",temp_header_1,temp_header_2,header);

      // THE LINE TO BE DISPLAYED WILL DEPEND ON THE WHETHER THE LINE IS AN
      // OBJECTIVE OR AN EVENT
      if (strcasecmp(header,"event") == 0)
      {
sscanf(file_line,"%64[^\t]\t%64[^\t]\t%64[^,],%1024[^,],%64[^\t]\t%1024[^\n]\n",temp_header_1,temp_header_2,header,temp_buffer_1,date_time,temp_buffer_2);
         strcat(temp_buffer_1,"\t");
         strcat(temp_buffer_1,temp_buffer_2);
         strcpy(details,temp_buffer_1); 
         strcpy(extended_details,file_line);
         strcpy(alert,"Clear");
         current_row = gtk_clist_append (GTK_CLIST (main_display),line);  
         auditing_type = AUDIT_BY_EVENT;
         //read_variables->read_type = AUDIT_BY_EVENT;
      }
      else if (strcasecmp(header,"objective") == 0)
      {
sscanf(file_line,"%64[^\t]\t%64[^\t]\t%64[^,],%64[^,],%64[^,],%1024[^\t]\t%1024[^\n]\n",temp_header_1,temp_header_2,header,alert,date_time,details,extended_details);
         current_row = gtk_clist_append (GTK_CLIST (main_display),line);
         auditing_type = AUDIT_BY_OBJECTIVE;
         //read_variables->read_type = AUDIT_BY_OBJECTIVE;
      }      
      else
      {
         strcpy(alert,"Clear");
         strcpy(extended_details,"NOTE: Event unable to be read correctly");
         strcpy(details,"NOTE: Event unable to be read correctly");
         strcpy(date_time,"Unknown");
         current_row = gtk_clist_append (GTK_CLIST (main_display),line);
      }
      if (strcasecmp(alert,"Critical") == 0)
         gtk_clist_set_pixmap(GTK_CLIST (main_display),current_row,0,gdkpixmap_critic,clist_mask);

      else if (strcasecmp(alert,"Priority") == 0)
         gtk_clist_set_pixmap(GTK_CLIST (main_display),current_row,0,gdkpixmap_priority,clist_mask);

      else if (strcasecmp(alert,"Warning") == 0)
         gtk_clist_set_pixmap(GTK_CLIST (main_display),current_row,0,gdkpixmap_warning,clist_mask);

      else if (strcasecmp(alert,"Information") == 0)
         gtk_clist_set_pixmap(GTK_CLIST (main_display),current_row,0,gdkpixmap_info,clist_mask); 

      else
         gtk_clist_set_pixmap(GTK_CLIST (main_display),current_row,0,gdkpixmap_unknown,clist_mask);

   }

   if ((file_lines_to_be_read == 0) && (move_to_command == 0))
   {
      gtk_clist_thaw(GTK_CLIST (main_display));
      gtk_clist_moveto(GTK_CLIST(main_display),current_row,0,0.0,0.0);
      //draw_audit_type_pixmap(read_variables->main_window,auditing_type);
   }
   else if ((file_lines_to_be_read == 0) && (move_to_command == 1))
   {
      gtk_clist_thaw(GTK_CLIST (main_display));
      //draw_audit_type_pixmap(read_variables->main_window,auditing_type);
   }

   return TRUE;
}


   
void create_pixmaps(GtkWidget *main_display)
{

   // THIS SETS UP THE ALERT PIXMAPS AND THE PIXMAP AT THE BOTTOM OF THE MAIN WINDOW
   colormap = gtk_widget_get_colormap(main_display);
   gdkpixmap_critic = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&clist_mask,NULL,critic_xpm);
   gdkpixmap_priority = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&clist_mask,NULL,priority_xpm);
   gdkpixmap_warning = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&clist_mask,NULL,warning_xpm);
   gdkpixmap_info = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&clist_mask,NULL,info_xpm);
   gdkpixmap_unknown = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&clist_mask,NULL,unknown_xpm);
   gdkpixmap_filtered = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&window_mask,NULL,filtered_xpm);
   gdkpixmap_raw = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&window_mask,NULL,raw_xpm);
   gdkpixmap_network = gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&window_mask,NULL,network_xpm);

   return;
}


int find_pixmap_type(GdkPixmap *gdkpixmap_test)
{
   if (gdkpixmap_test == gdkpixmap_critic)
      return CRITICALITY_CRITICAL;
   else if (gdkpixmap_test == gdkpixmap_priority)
      return CRITICALITY_PRIORITY;
   else if (gdkpixmap_test == gdkpixmap_warning)
      return CRITICALITY_WARNING;
   else if (gdkpixmap_test == gdkpixmap_info)
      return CRITICALITY_INFO;
   else
      return CRITICALITY_CLEAR;
}

// READ THE LOG FILE TO ASCERTAIN THE LOG FILE NAME AND THE TYPE OF AUDITING
int read_log_file_and_type(int read_file_from)
{
   struct read_events_struct; // *read_variables;
   FILE *configfile;
   char inputbuffer[MAX_AUDIT_CONFIG_LINE];
   int headertype=0;
   int audittype=AUDIT_BY_EVENT;          
   gchar *filename;
   int return_result = 0,audit_to_file=FALSE,audit_to_network=FALSE;

   configfile = fopen(CONFIG_FILENAME,"r");

   // IF SNARE CANNOT OPEN THE CONFIGURATION FILE, THEN RESULT == -1 
   if(configfile==(FILE *)NULL)
   {
      return -1;
   }

   while(fgets(inputbuffer,MAX_AUDIT_CONFIG_LINE,configfile)) 
   {
      trim(inputbuffer); 
      if(!iscomment(inputbuffer))
      {
         // A HEADER IS SOMETHING LIKE: [Event]
         if(isheader(inputbuffer))
         {
            headertype=getheader(inputbuffer);
         }
         else
         {
            if(headertype == CONFIG_AUDITTYPE)
            {
               // AUDIT BY OBJECTIVE
               if(isaudittype(inputbuffer))
               {
                  audittype=getaudittype(inputbuffer);
                  if (audittype == AUDIT_BY_OBJECTIVE)
                     read_variables->read_type = AUDIT_BY_OBJECTIVE;
                  else
                     read_variables->read_type = AUDIT_BY_EVENT;
               }
            }
            
            // NOTE: CONFIG_FILE IS ACTUALLY THE EVENT FILE HERE
            else if(headertype == CONFIG_OUTPUT)
            {
               if(isfilename(inputbuffer))
               {
                  filename = inputbuffer;
                  filename+=strlen("file=");
                  audit_to_file=TRUE; 
                  strcpy(event_log_filename_static,filename);

                  if ((open_close_event_file(OPEN_EVENT_FILE) == 0) &&
                      (read_file_from == READ_EVENT_FILE_FROM_END))
                         open_close_event_file(READ_EVENT_FILE_FROM_END);
                  
                  else if ((open_close_event_file(OPEN_EVENT_FILE) == 0) &&
                      (read_file_from == READ_EVENT_FILE_FROM_START))
                         open_close_event_file(READ_EVENT_FILE_FROM_START);

                  else
                     return -2;

               }
               else if(isnetwork(inputbuffer))
                  audit_to_network=TRUE;
            }
         }
      }
   }

   if ((audit_to_network==TRUE) && (audit_to_file==FALSE))
      read_variables->read_type = AUDIT_TO_NETWORK;
   
   fclose(configfile);

   return (return_result);
}

int check_filename(void)
{
   int result = 0, return_result = FILE_OK;

   // CHECK THE FILENAME INODE. DON'T NEED TO CHECK
   result = checkinode(event_log_filename_static);
   if (result == FILE_CHANGED)
      return_result = FILE_CHANGED;

   else if (result == FILE_NON_EXIST)
      return_result = FILE_NON_EXIST;
   return (return_result);

}


void draw_audit_type_pixmap(GtkWidget *window_var,int read_type)
{
   GtkWidget *main_display_pixmap, *main_clist;

   read_variables->main_window = window_var;   
   main_display_pixmap = lookup_widget(read_variables->main_window,"view_pixmap");
   main_clist = lookup_widget(read_variables->main_window,"mainclist");

   set_pixmap();
   

   // THESE CALLS INCLUDED HERE SINCE UNABLE TO BE DEFINED IN GLADE
   gtk_clist_set_column_justification(GTK_CLIST (main_clist),0,GTK_JUSTIFY_CENTER); 
   gtk_clist_set_column_visibility (GTK_CLIST (main_clist),3,FALSE);
    
}


int open_close_event_file(int close_open)
{
   int return_value = 0;

   if(close_open == OPEN_EVENT_FILE)
   {
      read_variables->events_file = fopen(event_log_filename_static,"r");
      // THIS WILL CHECK FOR ERRORS IN READING THE FILE.
      if(read_variables->events_file==(FILE *)NULL)
         return_value = 1;
   }
   if(close_open == READ_EVENT_FILE_FROM_START)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fseek(read_variables->events_file,0,SEEK_SET);
   }

   if(close_open == READ_EVENT_FILE_FROM_END)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fseek(read_variables->events_file,0,SEEK_END);
   }

   if(close_open == CLOSE_EVENT_FILE)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fclose(read_variables->events_file);
   }

   return abs(return_value);
}



int declare_new_file(char *new_filename)
{
   int new_file_result = 0;

   new_file_result = strcmp(event_log_filename_static,new_filename);

   if (new_file_result != 0)
      strcpy(event_log_filename_static,new_filename);

   return new_file_result;

}

void set_pixmap(void)
{
   GtkWidget *main_display_pixmap;

   main_display_pixmap = lookup_widget(read_variables->main_window,"view_pixmap");
   if (read_variables->read_type == AUDIT_TO_NETWORK)
      gtk_pixmap_set(GTK_PIXMAP(main_display_pixmap),gdkpixmap_network,window_mask);
   else if (read_variables->read_type == AUDIT_BY_OBJECTIVE)
      gtk_pixmap_set(GTK_PIXMAP(main_display_pixmap),gdkpixmap_filtered,window_mask);
   else
      gtk_pixmap_set(GTK_PIXMAP(main_display_pixmap),gdkpixmap_raw,window_mask);
}

void set_network_logging_variable(int audit_type)
{
   read_variables->read_type = audit_type;
}


void draw_alert_level_pixmaps(GtkWidget *objective_window)
{

 gtk_pixmap_set(GTK_PIXMAP(lookup_widget(objective_window,"critical_pixmap")),gdkpixmap_critic,clist_mask);
 gtk_pixmap_set(GTK_PIXMAP(lookup_widget(objective_window,"priority_pixmap")),gdkpixmap_priority,clist_mask);
 gtk_pixmap_set(GTK_PIXMAP(lookup_widget(objective_window,"warning_pixmap")),gdkpixmap_warning,clist_mask);
 gtk_pixmap_set(GTK_PIXMAP(lookup_widget(objective_window,"information_pixmap")),gdkpixmap_info,clist_mask);
 gtk_pixmap_set(GTK_PIXMAP(lookup_widget(objective_window,"clear_pixmap")),gdkpixmap_unknown,clist_mask);

 return;
}


