/************************************************************
 *
 * 1999 - 2002 (c) Intersect Alliance Pty Ltd.
 *
 * These routines write the components of the audit configuration
 * window to the audit.conf file
 *
 *
 * SNARE GUI Version 0.8 Dated 1 October 2001
 ************************************************************
 * V0.9 1Feb02. Added "user!=" for user excludes. Also included
 * the 4 new abstracted objectives. Include the "network_logging_
 * active() function.
 *
 ************************************************************/


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <regex.h>              // Regular expression matches.

#include "write_config.h"
#include "read_config.h"
#include "support.h"
#include "read_events.h"

gint write_configuration(GtkWidget *config_window)
{
   GtkWidget *objectives_clist, *error_dialog;
   FILE *configfile;

   // LOOKUP THE "OBJECTIVES" CLIST WIDGET
   objectives_clist = lookup_widget(config_window,"objectives_clist");

   configfile = fopen(CONFIG_FILENAME,"w");

   // IF CAN'T OPEN THE FILE (FOR WRITING), DISPLAY ALTERNATE ERROR WINDOW
   if(configfile==(FILE *)NULL) 
   {
      error_dialog = gnome_message_box_new("Unable to open /etc/audit/audit.conf for writing. \nCheck the whether the file exists, and has \nthe allowable permissions.",
                     GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
      gnome_dialog_run (GNOME_DIALOG (error_dialog));
      return FALSE;
   }


   write_header(config_window,configfile); 
   write_log_or_network_parameters(config_window,configfile);
   write_objectives(config_window,configfile);
   write_raw_events(config_window,configfile);
 
   fclose(configfile);
   return TRUE;
}



gint write_raw_events(GtkWidget *config_window, FILE *configfile)
{
   GtkWidget *raw_open_checkbutton, *raw_setuid_checkbutton, *raw_setgid_checkbutton;
   GtkWidget *raw_setresgid_checkbutton, *raw_setregid_checkbutton, *raw_truncate_checkbutton;
   GtkWidget *raw_lchown_checkbutton, *raw_chmod_checkbutton;
   GtkWidget *raw_rename_checkbutton, *raw_execve_checkbutton, *raw_chroot_checkbutton;
   GtkWidget *raw_reboot_checkbutton, *raw_exit_checkbutton, *raw_creat_checkbutton;
   GtkWidget *raw_mknod_checkbutton, *raw_mkdir_checkbutton, *raw_rmdir_checkbutton;
   GtkWidget *raw_link_checkbutton, *raw_unlink_checkbutton, *raw_symlink_checkbutton;
   GtkWidget *raw_chown_checkbutton, *raw_chown32_checkbutton, *raw_lchown32_checkbutton;
   GtkWidget *raw_setreuid_checkbutton, *raw_setresuid_checkbutton;
   GtkWidget *raw_setuid32_checkbutton, *raw_setreuid32_checkbutton, *raw_setresuid32_checkbutton;
   GtkWidget *raw_setgid32_checkbutton, *raw_setregid32_checkbutton, *raw_setresgid32_checkbutton;
   GtkWidget *raw_truncate64_checkbutton, *raw_create_module_checkbutton, *raw_socketcall_checkbutton;

   fprintf(configfile,"\n[Events]\n");

   raw_open_checkbutton = lookup_widget(config_window,"raw_open_checkbutton"); 
   if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_open_checkbutton)))  
      fprintf(configfile,"\topen=%d\n",EVENT_ON);
   else fprintf(configfile,"\topen=%d\n",EVENT_OFF);

   raw_creat_checkbutton = lookup_widget(config_window,"raw_creat_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_creat_checkbutton))) 
      fprintf(configfile,"\tcreat=%d\n",EVENT_ON);
   else fprintf(configfile,"\tcreat=%d\n",EVENT_OFF);

   raw_execve_checkbutton = lookup_widget(config_window,"raw_execve_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_execve_checkbutton))) 
      fprintf(configfile,"\texecve=%d\n",EVENT_ON);
   else fprintf(configfile,"\texecve=%d\n",EVENT_OFF);

   raw_exit_checkbutton = lookup_widget(config_window,"raw_exit_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_exit_checkbutton))) 
      fprintf(configfile,"\texit=%d\n",EVENT_ON);
   else fprintf(configfile,"\texit=%d\n",EVENT_OFF);

   raw_mkdir_checkbutton = lookup_widget(config_window,"raw_mkdir_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_mkdir_checkbutton))) 
      fprintf(configfile,"\tmkdir=%d\n",EVENT_ON);
   else fprintf(configfile,"\tmkdir=%d\n",EVENT_OFF);

   raw_unlink_checkbutton = lookup_widget(config_window,"raw_unlink_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_unlink_checkbutton))) 
      fprintf(configfile,"\tunlink=%d\n",EVENT_ON);
   else fprintf(configfile,"\tunlink=%d\n",EVENT_OFF);

   raw_mknod_checkbutton = lookup_widget(config_window,"raw_mknod_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_mknod_checkbutton))) 
      fprintf(configfile,"\tmknod=%d\n",EVENT_ON);
   else fprintf(configfile,"\tmknod=%d\n",EVENT_OFF);

   raw_rmdir_checkbutton = lookup_widget(config_window,"raw_rmdir_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_rmdir_checkbutton))) 
      fprintf(configfile,"\trmdir=%d\n",EVENT_ON);
   else fprintf(configfile,"\trmdir=%d\n",EVENT_OFF);

   raw_chown_checkbutton = lookup_widget(config_window,"raw_chown_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_chown_checkbutton))) 
      fprintf(configfile,"\tchown=%d\n",EVENT_ON);
   else fprintf(configfile,"\tchown=%d\n",EVENT_OFF);

   raw_lchown_checkbutton = lookup_widget(config_window,"raw_lchown_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_lchown_checkbutton))) 
      fprintf(configfile,"\tlchown=%d\n",EVENT_ON);
   else fprintf(configfile,"\tlchown=%d\n",EVENT_OFF);

   raw_chown32_checkbutton = lookup_widget(config_window,"raw_chown32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_chown32_checkbutton))) 
      fprintf(configfile,"\tchown32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tchown32=%d\n",EVENT_OFF);

   raw_lchown32_checkbutton = lookup_widget(config_window,"raw_lchown32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_lchown32_checkbutton))) 
      fprintf(configfile,"\tlchown32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tlchown32=%d\n",EVENT_OFF);

   raw_chmod_checkbutton = lookup_widget(config_window,"raw_chmod_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_chmod_checkbutton))) 
      fprintf(configfile,"\tchmod=%d\n",EVENT_ON);
   else fprintf(configfile,"\tchmod=%d\n",EVENT_OFF);

   raw_symlink_checkbutton = lookup_widget(config_window,"raw_symlink_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_symlink_checkbutton))) 
      fprintf(configfile,"\tsymlink=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsymlink=%d\n",EVENT_OFF);

   raw_link_checkbutton = lookup_widget(config_window,"raw_link_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_link_checkbutton))) 
      fprintf(configfile,"\tlink=%d\n",EVENT_ON);
   else fprintf(configfile,"\tlink=%d\n",EVENT_OFF);

   raw_rename_checkbutton = lookup_widget(config_window,"raw_rename_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_rename_checkbutton))) 
      fprintf(configfile,"\trename=%d\n",EVENT_ON);
   else fprintf(configfile,"\trename=%d\n",EVENT_OFF);

   raw_reboot_checkbutton = lookup_widget(config_window,"raw_reboot_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_reboot_checkbutton))) 
      fprintf(configfile,"\treboot=%d\n",EVENT_ON);
   else fprintf(configfile,"\treboot=%d\n",EVENT_OFF);

   raw_truncate_checkbutton = lookup_widget(config_window,"raw_truncate_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_truncate_checkbutton))) 
      fprintf(configfile,"\ttruncate=%d\n",EVENT_ON);
   else fprintf(configfile,"\ttruncate=%d\n",EVENT_OFF);

   raw_chroot_checkbutton = lookup_widget(config_window,"raw_chroot_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_chroot_checkbutton))) 
      fprintf(configfile,"\tchroot=%d\n",EVENT_ON);
   else fprintf(configfile,"\tchroot=%d\n",EVENT_OFF);

   raw_setuid_checkbutton = lookup_widget(config_window,"raw_setuid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setuid_checkbutton))) 
      fprintf(configfile,"\tsetuid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetuid=%d\n",EVENT_OFF);

   raw_setreuid_checkbutton = lookup_widget(config_window,"raw_setreuid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setreuid_checkbutton))) 
      fprintf(configfile,"\tsetreuid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetreuid=%d\n",EVENT_OFF);

   raw_setresuid_checkbutton = lookup_widget(config_window,"raw_setresuid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setresuid_checkbutton))) 
      fprintf(configfile,"\tsetresuid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetresuid=%d\n",EVENT_OFF);

   raw_setuid32_checkbutton = lookup_widget(config_window,"raw_setuid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setuid32_checkbutton))) 
      fprintf(configfile,"\tsetuid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetuid32=%d\n",EVENT_OFF);

   raw_setreuid32_checkbutton = lookup_widget(config_window,"raw_setreuid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setreuid32_checkbutton))) 
      fprintf(configfile,"\tsetreuid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetreuid32=%d\n",EVENT_OFF);

   raw_setresuid32_checkbutton = lookup_widget(config_window,"raw_setresuid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setresuid32_checkbutton))) 
      fprintf(configfile,"\tsetresuid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetresuid32=%d\n",EVENT_OFF);

   raw_setgid_checkbutton = lookup_widget(config_window,"raw_setgid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setgid_checkbutton))) 
      fprintf(configfile,"\tsetgid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetgid=%d\n",EVENT_OFF);

   raw_setregid_checkbutton = lookup_widget(config_window,"raw_setregid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setregid_checkbutton))) 
      fprintf(configfile,"\tsetregid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetregid=%d\n",EVENT_OFF);

   raw_setresgid_checkbutton = lookup_widget(config_window,"raw_setresgid_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setresgid_checkbutton))) 
      fprintf(configfile,"\tsetresgid=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetresgid=%d\n",EVENT_OFF);

   raw_setgid32_checkbutton = lookup_widget(config_window,"raw_setgid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setgid32_checkbutton))) 
      fprintf(configfile,"\tsetgid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetgid32=%d\n",EVENT_OFF);

   raw_setregid32_checkbutton = lookup_widget(config_window,"raw_setregid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setregid32_checkbutton))) 
      fprintf(configfile,"\tsetregid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetregid32=%d\n",EVENT_OFF);

   raw_setresgid32_checkbutton = lookup_widget(config_window,"raw_setresgid32_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_setresgid32_checkbutton))) 
      fprintf(configfile,"\tsetresgid32=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsetresgid32=%d\n",EVENT_OFF);

   raw_truncate64_checkbutton = lookup_widget(config_window,"raw_truncate64_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_truncate64_checkbutton))) 
      fprintf(configfile,"\ttruncate64=%d\n",EVENT_ON);
   else fprintf(configfile,"\ttruncate64=%d\n",EVENT_OFF);

   raw_socketcall_checkbutton = lookup_widget(config_window,"raw_socketcall_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_socketcall_checkbutton))) 
      fprintf(configfile,"\tsocketcall=%d\n",EVENT_ON);
   else fprintf(configfile,"\tsocketcall=%d\n",EVENT_OFF);
   
   raw_create_module_checkbutton = lookup_widget(config_window,"raw_create_module_checkbutton");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (raw_create_module_checkbutton))) 
      fprintf(configfile,"\tcreate_module=%d\n",EVENT_ON);
   else fprintf(configfile,"\tcreate_module=%d\n",EVENT_OFF);
   
   return TRUE;
}

gint write_header(GtkWidget *config_window, FILE *configfile)
{
   GtkWidget *type_of_auditing_button;

 
   fprintf(configfile,"# WARNING: DO NOT MANUALLY EDIT, UNLESS YOU KNOW WHAT YOU ARE DOING\n");
   fprintf(configfile,"[AuditType]\n");

   type_of_auditing_button = lookup_widget(config_window,"obj_radio_button");
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (type_of_auditing_button))) 
      fprintf(configfile,"\ttype=Objective\n");
   else fprintf(configfile,"\ttype=Event\n");

   return TRUE;
}

gint write_log_or_network_parameters(GtkWidget *config_window, FILE *configfile)
{
   GtkWidget *logging_file_text_box, *hostid_entry, *desthost_entry, *port_entry, *network_radio;
   GtkWidget *type_of_auditing_button, *log_radio;
   gchar *logging_file_entry, *hostid, *desthost, *port;

   network_radio = lookup_widget(config_window,"network_radio");   
   log_radio = lookup_widget(config_window,"log_radio");   
   
   hostid_entry = lookup_widget(config_window,"hostid_entry");
   hostid = gtk_entry_get_text(GTK_ENTRY (hostid_entry));
   fprintf(configfile,"\n[HostID]\n");
   fprintf(configfile,"\tname=%s\n",hostid);
   desthost_entry = lookup_widget(config_window,"desthost_entry");
   port_entry = lookup_widget(config_window,"port_entry");
   desthost = gtk_entry_get_text(GTK_ENTRY (desthost_entry));
   port = gtk_entry_get_text(GTK_ENTRY (port_entry));
   logging_file_text_box = lookup_widget(config_window,"log_file");
   logging_file_entry = gtk_entry_get_text(GTK_ENTRY (logging_file_text_box));
        
   if   (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (network_radio)))
   {
         
      fprintf(configfile,"\n[Output]\n");
      fprintf(configfile,"\tnetwork=%s:%s\n",desthost,port); 
      set_network_logging_variable(AUDIT_TO_NETWORK);
    }
    else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (log_radio)))
    {  
      fprintf(configfile,"\n[Output]\n");
      fprintf(configfile,"\tfile=%s\n",logging_file_entry);

      declare_new_file(logging_file_entry);

      type_of_auditing_button = lookup_widget(config_window,"obj_radio_button");      
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (type_of_auditing_button))) 
         set_network_logging_variable(AUDIT_BY_OBJECTIVE);
      else set_network_logging_variable(AUDIT_BY_EVENT);
    }
    else
    {
      fprintf(configfile,"\n[Output]\n");
      fprintf(configfile,"\tnetwork=%s:%s\n",desthost,port);      
      fprintf(configfile,"\tfile=%s\n",logging_file_entry);

      declare_new_file(logging_file_entry);

      // When sending audit to the network and a file, we display either
      // the objective or kernel auditing pixmap
      type_of_auditing_button = lookup_widget(config_window,"obj_radio_button");      
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (type_of_auditing_button))) 
         set_network_logging_variable(AUDIT_BY_OBJECTIVE);
      else set_network_logging_variable(AUDIT_BY_EVENT);
    	
    }

   return TRUE;
}

gint write_objectives(GtkWidget *config_window, FILE *configfile)
{
   GtkWidget *obj_clist;
   gint row = 0, column = 0;
   gchar *alert, *success, *user_match, *users, *filter_type, *filter, *objective;
   gint criticality;
   int user_match_type, filter_match_type;
   char filter_exp[TOKEN_SIZE], user_exp[TOKEN_SIZE], events[TOKEN_SIZE];

   fprintf(configfile,"\n[Objectives]\n");

   obj_clist = lookup_widget(config_window,"objectives_clist");
   while (gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&alert))
   {
   
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&success);
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&user_match);
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&users);
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&filter_type);
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&filter);
      column++;
      gtk_clist_get_text(GTK_CLIST (obj_clist),row,column,&objective);

      if (g_strcasecmp(alert,"Critical") == 0)
         criticality = CRITICALITY_CRITICAL;
      else if (g_strcasecmp(alert,"Priority") == 0)
         criticality = CRITICALITY_PRIORITY;
      else if (g_strcasecmp(alert,"Warning") == 0)
         criticality = CRITICALITY_WARNING;
      else if (g_strcasecmp(alert,"Information") == 0)
         criticality = CRITICALITY_INFO;
      else
         criticality = CRITICALITY_CLEAR;

      if (g_strcasecmp(success,"Success & Failure") == 0)
         strcpy(success,"*");
      else if (g_strcasecmp(success,"Success") == 0)
         strcpy(success,"Success");
      else
         strcpy(success,"Failure");

      if (g_strcasecmp(objective,"Read, write or create a file or directory") ==0)
         strcpy(events,OPEN_FILE);
      else if (g_strcasecmp(objective,"Open a file for reading only") ==0)
         strcpy(events,OPEN_READ_FILE);
      else if (g_strcasecmp(objective,"Write or create a file or directory") ==0)
         strcpy(events,OPEN_WRITE_FILE);
      else if (g_strcasecmp(objective,"Remove a file or directory") ==0)
         strcpy(events,REMOVE_FILE);
      else if (g_strcasecmp(objective,"Modify system, file or directory attributes") ==0)
         strcpy(events,ATTRIBUTES);
      else if (g_strcasecmp(objective,"Start or stop a program execution") ==0)
         strcpy(events,PROG_EXEC);
      else if (g_strcasecmp(objective,"Change user or group identity") ==0)
         strcpy(events,USER_IDENT);
      else if (g_strcasecmp(objective,"Open a network connection") ==0)
         strcpy(events,CONNECT_SOCKET);
      else if (g_strcasecmp(objective,"Accept a network connection") ==0)
         strcpy(events,ACCEPT_SOCKET);
      else if (g_strcasecmp(objective,"Administrative events") ==0)
         strcpy(events,ADMIN);

      if (g_strcasecmp(user_match,"All") == 0)
         user_match_type = MATCH_ALL;
      else if (g_strcasecmp(user_match,"Exclude") == 0)
         user_match_type = MATCH_EXCLUDE;
      else
         user_match_type = MATCH_SELECTED;

      SetMatch(users,user_exp,user_match_type);

      if (g_strcasecmp(filter_type,"Full") == 0)
         filter_match_type = MATCH_EXACT;
      else if (g_strcasecmp(filter_type,"Partial") == 0)
         filter_match_type = MATCH_PARTIAL;
      else
         filter_match_type = MATCH_REGEXP;
      SetMatch(filter,filter_exp,filter_match_type);

      // PRINTING TO THE CONFIG FILE STARTS HERE
      fprintf(configfile,"\tcriticality=%d",criticality);
      fprintf(configfile,"\tevent=%s",events);
      fprintf(configfile,"\treturn=%s",success);
      if (user_match_type == MATCH_EXCLUDE)
         fprintf(configfile,"\tuser!=%s",user_exp);
      else
         fprintf(configfile,"\tuser=%s",user_exp);
      fprintf(configfile,"\tmatch=%s\n",filter_exp);

      row++;
      column = 0;
   }
   
   return TRUE;
}


void SetMatch(const char *string, char *buffer,int type)
{

        if(type==MATCH_PARTIAL) {
                *buffer='.'; buffer++;
                *buffer='*'; buffer++;
        } else if(type==MATCH_EXACT) {
                *buffer='^'; buffer++;
        } else if(type==MATCH_SELECTED) {
                *buffer='^'; buffer++;
                *buffer='('; buffer++;
        } else if(type==MATCH_ALL) {
                strcpy(buffer,".*");
                return;
        }

        // Expand regular expression characters.
        while(*string) {
                if(type != MATCH_REGEXP && type != MATCH_ALL) {
                        if(*string == '.' || *string == '[' || *string == ']' ||
                           *string == '$' || *string == '(' || *string == ')' ||
                           *string == '|' || *string == '*' || *string == '+' ||
                           *string == '?' || *string == '{' || *string == '}' || *string == '\\') {
                                *buffer='\\'; buffer++; 
                        }
                }
                if(type == MATCH_SELECTED) {
                        // Replace pipes with commas
                        if(*string == ',') {
                                *buffer='|'; buffer++;
                        } else {
                                *buffer=*string; buffer++;
                        }
                } else {
                        *buffer=*string; buffer++;
                }
                string++;
        }
        if(type==MATCH_PARTIAL) {
                *buffer='.'; buffer++;
                *buffer='*'; buffer++;
        } else if(type==MATCH_EXACT) {
                *buffer='$'; buffer++;
        } else if(type==MATCH_SELECTED) {
                *buffer=')'; buffer++;
                *buffer='$'; buffer++;
        } else if(type==MATCH_ALL) {
                *buffer='.'; buffer++;
                *buffer='*'; buffer++;
        }
        *buffer='\0';
}

