///////////////////////////////////////////////////////////////////////////////////////////
//
// System iNtrusion Analysis and Reporting Environment (SNARE) - Audit Module
//
// Audit Header file
//
///////////////////////////////////////////////////////////////////////////////////////////
// Copyright 1999-2001 InterSect Alliance Pty Ltd - http://www.intersectalliance.com/
///////////////////////////////////////////////////////////////////////////////////////////

#include <linux/limits.h>

#define AUDIT_NULL			0
#define AUDIT_open			1
#define AUDIT_creat			2
#define AUDIT_execve		3
#define AUDIT_exit			4
#define AUDIT_mkdir			5
#define AUDIT_unlink		6
#define AUDIT_mknod			7
#define AUDIT_rmdir			8
#define AUDIT_chown			9
#define AUDIT_lchown		10
#define AUDIT_chown32		11
#define AUDIT_lchown32		12
#define AUDIT_chmod			13
#define AUDIT_symlink		14
#define AUDIT_link			15
#define AUDIT_rename		16
#define AUDIT_reboot		17
#define AUDIT_truncate		18
#define AUDIT_chroot		19
#define AUDIT_setuid		20
#define AUDIT_setreuid		21
#define AUDIT_setresuid		22
#define AUDIT_setuid32		23
#define AUDIT_setreuid32	24
#define AUDIT_setresuid32	25
#define AUDIT_setgid		26
#define AUDIT_setregid		27
#define AUDIT_setresgid		28
#define AUDIT_setgid32		29
#define AUDIT_setregid32	30
#define AUDIT_setresgid32	31
#define AUDIT_truncate64	32
#define AUDIT_socketcall	33
#define AUDIT_create_module	34
#define AUDIT_delete_module	35
#define AUDIT_mount			36
#define AUDIT_umount		37
#define AUDIT_umount2		38
#define MAXAUDIT 38			// Number of system calls that have been modified for audit.

#define MAX_PATH	512		// PATH_MAX in linux is 4096, but we cannot afford to
							// go over a page boundary in the kernel (4096). Set to 512 for the moment.
							// Note: Now we have direct kmallocs, this may be ok.... (0.9).

// The following system calls are translated into the normal non-f* system calls!
// eg: fchown actually calls chown32!

// #define AUDIT_ftruncate
// #define AUDIT_fchmod
// #define AUDIT_ftruncate64
// #define AUDIT_fchown

#define AUDIT_ALL			999			// Used for event selection

// ioctl modes - note that '1' doesnt seem to work. Added 10.
#define AUDIT_STOP			10  // stop auditing
#define AUDIT_START			11  // start auditing
#define AUDIT_INFO			12  // Give me a list of events currently active, and other information such as the process ID
#define AUDIT_LOSTEVENTS	13
#define AUDIT_FLUSH			14	// Stop all events.
#define AUDIT_EVENT_ON		15	// Turn on a selected event
#define AUDIT_EVENT_OFF		16	// Turn off a selected event
#define AUDIT_DELIVERY 		17  // Do we want to guarantee audit event delivery
#define AUDIT_TOTALEVENTS	18	// How many events have been received this session?


#define AUDIT_CLASS_NONE	0
#define AUDIT_CLASS_IO		1	// Input/output (file opens)
#define AUDIT_CLASS_PC		2	// Process Control
#define AUDIT_CLASS_EXEC	3	// Execution
#define AUDIT_CLASS_NET		4	// Network related
#define AUDIT_CLASS_ADMIN	5	// Administrative events
#define AUDIT_CLASS_CH		6	// CHMOD event. Might not use this for anything else.
#define AUDIT_CLASS_CP		7	// Where more than one pathname is required
#define AUDIT_CLASS_SU		8	// SetUID
#define AUDIT_CLASS_AD		9	// Admin such as create/delete module

#define AUDITMODULE_MAJOR_VERSION 0
#define AUDITMODULE_MINOR_VERSION 9
#define AUDITMODULE_PATCH_VERSION 0


// /proc entry
#define AUDITDEV_NAME  "audit"				// device name in /dev and /proc/devices
#define AUDITINFO_NAME	"auditinfo"			// Information about the process
#define AUDITDEV_FILE  "/proc/audit"		// full file name
#define AUDITINFO_FILE "/proc/auditinfo"	// Information about the process.

#define FALSE 0
#define TRUE (!FALSE)


typedef struct
{
	unsigned short event_class;		// event class. Each class has a predictable format for tokens.
	unsigned short event_id;		// number of the event
	unsigned short event_size;		// size of the event struct - don't include header
									// since it's always the same
	struct timeval time;			// time

	int user_id;			// User ID
	int euser_id;			// Effective User ID
	int group_id;			// Group ID
	int egroup_id;			// Effective Group ID
} header_token;

typedef struct
{
	int returncode;				// Make sure that this is big enough to contain the largest returncode.
} return_token;

typedef struct
{
	char path[MAX_PATH];
} path_token;

typedef struct
{
	int mode;						// How the file was attempted to be opened or created
	unsigned long	createmode;		// Flags associated with the file creation. Ulong for mknod.
} attributes_token;

typedef struct
{
	int owner;			// new owner of a file - was uid_t, but these are different between kernel and user.
	int group;			// new group of a file
} owner_token;

typedef struct
{
	char args[MAX_PATH];		// Should really allocate more here. Whats is the max command line size?
} execargs_token;

#define MAXCOMMAND 16
typedef struct
{
	pid_t pid;				// process ID.
	char name[MAXCOMMAND];	// Same as in /usr/include/linux/sched.h for current->comm
} process_token;

// System calls like setuid
typedef struct
{
	int id;		// uid/gid/euid depending on the call
	int rid;	// ruid/rgid
	int sid;	// suid/sgid
} target_token;

// Network connections
typedef struct
{
	char src_ip[40];	// String containing source dotted ip address - 40 bytes, for IPv6
	int src_port;		// Source port
	char dst_ip[40];	// String containing destination dotted ip address - 40 bytes, for IPv6
	int dst_port;		// Destination port
} connection_token;



// Now for the audit event classes

// Just a bare class with the minimal data
// note that this will probably mean that EVERY class must start with header and return IN THAT order
typedef struct
{
	header_token	t_header;
} null_class;
	

// NOTE: ANY CLASS STRUCTURE SHOULD HAVE THE RETURN TOKEN AS THE SECOND ELEMENT.
// SEE AUDITD FOR MORE INFO.
// io - reads/writes
typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	path_token			t_path;
	path_token			t_pwd;	// Working directory
	attributes_token	t_attributes;
} io_class;

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	path_token			t_path;
	path_token			t_pwd;	// Working directory
	owner_token			t_owner;
} ch_class;

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	path_token			t_path;
	path_token			t_pwd;	// Working directory
	execargs_token		t_execargs;
	// environment variables too?
} ex_class;

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
} pc_class;

// copy one file to another (amongst others - eg: symlink)
typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	path_token			t_sourcepath;
	path_token			t_pwd;	// Working directory
	path_token			t_destpath;
} cp_class;

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	target_token		t_target;	// target UID or GID.. I really only need a single value here.
} su_class;

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	int					syscall;		// Which of the socketcall calls does this relate to? eg: connect(), accept(), listen()
	connection_token	t_connection;	
} nt_class;	// Network

typedef struct
{
	header_token		t_header;
	return_token		t_return;
	process_token		t_process;
	path_token			t_name;		// Name of the module loaded / removed
} ad_class;	// General Administrative
