///////////////////////////////////////////////////////////////////////////////////////////
//
// System iNtrusion Analysis and Reporting Environment (SNARE) - Audit Daemon Header
//
// Audit Daemon Header file
//
///////////////////////////////////////////////////////////////////////////////////////////
// Copyright 1999-2002 InterSect Alliance Pty Ltd - http://www.intersectalliance.com/
///////////////////////////////////////////////////////////////////////////////////////////

#define MAX_AUDITREC PATH_MAX+4096		// How much buffer to reserve for the textual representation of an audit event.
#define IDELIMITER ","					// Internal Delimiter between fields of a token
#define DELIMITER "\t"					// Will probably let the user change this later.
#define CONFIG_FILENAME "/etc/audit/audit.conf"
#define MAX_AUDIT_CONFIG_LINE	8192
#define MAX_USERNAME			256
#define MAX_OPTIONS				256
#define MAX_EVENTNAME			32
#define MAX_USERREG				PATH_MAX
#define MAX_HOSTID				256		// Host identifier - usually the fully qualified hostname.

#define CONFIG_AUDITTYPE	1
#define	CONFIG_OBJECTIVES	2
#define CONFIG_EVENTS		3
#define CONFIG_OUTPUT		4
#define CONFIG_DELIVERY		5
#define CONFIG_HOSTID		6

#define AUDIT_BY_OBJECTIVE	1
#define AUDIT_BY_EVENT		2

#define AUDIT_TO_STDOUT		1
#define AUDIT_TO_FILE		2
#define AUDIT_TO_NETWORK	4

#define CRITICALITY_CLEAR	0
#define CRITICALITY_INFO	1
#define CRITICALITY_WARNING 2
#define CRITICALITY_PRIORITY 3
#define CRITICALITY_CRITICAL 4

#define	RETURNCODE_FAILURE	0
#define RETURNCODE_SUCCESS	1
#define RETURNCODE_ANY		2

#define TARGET_EID			2
#define TARGET_GID			2

// Linked List
struct _node
{
	int event_number;	// The event number this is supposed to match
	int criticality;	// How critical is this particular node
	int returncode;		// return code required.
	int excludeflag;	// Include or exclude users?
	char username[MAX_USERREG];	// Remember, this will be a regular expression.
	char path[PATH_MAX];			// NOTE: this could match either path or destpath
	char options[MAX_OPTIONS];	// Options associated with a audit type (eg: O_RDONLY|O_CREAT)
	struct _node *next;
};

typedef struct _node Node;


void sig_handler			(int);
int process_io_class		(header_token *);
int process_ex_class		(header_token *);
int process_pc_class		(header_token *);
int process_ch_class		(header_token *);
int process_cp_class		(header_token *);
int process_su_class		(header_token *);
int process_nt_class		(header_token *);

char * eventcat				(char * , char *);
int sendevent				(char *);
char * textmode				(int, char *, int);
char * passname				(int, char *, int);
char * groupname			(int, char *, int);

int add_user_token			(char *, header_token *);
int add_process_token		(char *, process_token *);
int add_return_token		(char *, return_token *);
int add_sequence_token		(char *);

char * eventnumber2name		(int, char *, int);
int	eventname2number		(char * );

char * resolved_path		(char *,char *,char *);
int	read_config_file		(void);

int turn_event_on			(int);

char * criticalitystring	(int, char *);
void trim					(char *);
void trimallwhitespace		(char *);
char * strip				(char *);
int iscomment				(char *);
int isfilename				(char *);
int isnetwork				(char *);
int open_audit_output		(char *);
int open_audit_network		(char *);
int splitobjective			(char *, char *, char *, char *,int *,int *);
int isheader				(char *);
int getheader				(char *);
int isaudittype				(char *);
int getaudittype			(char *);
int regmatch				(const char *, const char *);
int regmatchi				(const char *, const char *);
int geteventswitch			(char *);
char * gethostident			(char *, char *,int);
char * getfqdn				(char *);
int SendToSocket			(char *);

Node * CheckObjective(int,const char *,const char *,char *,int);

// Some potential linked list stuff.
void	CreateLinkedList	(void);
void	DestroyList			(void);
int		IsListEmpty			(void);
Node *	AddToList			(int, char *, char*, int, char *, int, int);
void	RemoveFromListHead	(void);
void	RemoveFromList		(Node*);
void	ResetCurrentNode	(void);
int		IsValidItem			(void);
Node *	GetCurrentItem		(void);
void	NextItemInList		(void);
