///////////////////////////////////////////////////////////////////////////////////////////
//
// System iNtrusion Analysis and Reporting Environment (SNARE) - Audit Module
//
// Audit Module Header file
//
///////////////////////////////////////////////////////////////////////////////////////////
// Copyright 1999-2002 InterSect Alliance Pty Ltd - http://www.intersectalliance.com/
///////////////////////////////////////////////////////////////////////////////////////////

#ifndef _AUDITMODULE_H
#define _AUDITMODULE_H
#endif

// 2.4.2 debian and prior, may not have *32/ *64 calls.
/*
#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,4,2)
#define SYS_chown32	SYS_chown
#define SYS_lchown32	SYS_lchown
#define SYS_setuid32	SYS_setuid
#define SYS_setreuid32	SYS_setreuid
#define SYS_setresuid32	SYS_setresuid
#define SYS_setgid32	SYS_setgid
#define SYS_setregid32	SYS_setregid
#define SYS_setresgid32	SYS_setresgid
#define SYS_ftruncate64	SYS_ftruncate
#define SYS_truncate64	SYS_truncate
#endif
*/


///////////////////////////////////////////////////////////////////////////////
// Linked List
struct _node
{
	void * location;	// Location in RAM of the allocated chunk
	int size;			// Size of the chunk
	struct _node *next;	// Next node in the series.
};

typedef struct _node Node;


static int auditmodule_ioctl		(struct inode *, struct file *, unsigned int, unsigned long);
static int auditmodule_open			(struct inode *, struct file *);
static int auditmodule_close		(struct inode *, struct file *);
static ssize_t auditmodule_read		(struct file *, char *, size_t, loff_t *);

// /proc/auditinfo
static int info_open				(struct inode *, struct file *);
static int info_close				(struct inode *, struct file *);
static ssize_t info_read			(struct file *, char *, size_t, loff_t *);


int get_buffer						(unsigned int);
// int audit_event						(void * event, int);
int audit_event						(Node * node, int);
/*int write_io						(io_class *);
int write_ex						(ex_class *);
int write_pc						(pc_class *);
int write_ch						(ch_class *);
int write_cp						(cp_class *);
int write_su						(su_class *);
int write_nt						(nt_class *);*/

void signal_auditd					();
void audit_on						(int auditnum);
void audit_off						(int auditnum);

// static int __init init_module(void);
//static int init_module(void);
int init_module(void);
void cleanup_module(void);

//int timeout							(struct timeval *);
//void timecheck						(void *);

// Original System Calls
asmlinkage int	(*orig_open)		(const char *pathname, int flag, mode_t mode);
asmlinkage int	(*orig_creat)		(const char *pathname, mode_t mode);
int				(*orig_execve)		(struct pt_regs regs);
asmlinkage int	(*orig_exit)		(int);
asmlinkage int	(*orig_mkdir)		(const char *path, mode_t mode);
asmlinkage int	(*orig_unlink)		(const char *path);
asmlinkage int	(*orig_mknod)		(const char *pathname, mode_t mode, dev_t dev);
asmlinkage int	(*orig_rmdir)		(const char *path);
asmlinkage int  (*orig_chown)		(const char *path, uid_t owner, gid_t group);
asmlinkage int  (*orig_lchown)		(const char *path, uid_t owner, gid_t group);
asmlinkage int  (*orig_chown32)		(const char *path, uid_t owner, gid_t group);
asmlinkage int  (*orig_lchown32)	(const char *path, uid_t owner, gid_t group);
asmlinkage int	(*orig_chmod)		(const char *pathname, mode_t mode);
asmlinkage int	(*orig_symlink)		(const char *oldpath, const char *newpath);
asmlinkage int	(*orig_link)		(const char *oldpath, const char *newpath);
asmlinkage int	(*orig_rename)		(const char *oldpath, const char *newpath);
asmlinkage int	(*orig_reboot)		(int magic, int magic2, int flag, void *arg);
asmlinkage int	(*orig_truncate)	(const char *path, off_t length);
asmlinkage int	(*orig_chroot)		(const char *path);
asmlinkage int	(*orig_setuid)		(uid_t uid);
asmlinkage int	(*orig_setreuid)	(uid_t ruid, uid_t euid);
asmlinkage int	(*orig_setresuid)	(uid_t ruid, uid_t euid, uid_t suid);
asmlinkage int	(*orig_setuid32)	(uid_t uid);
asmlinkage int	(*orig_setreuid32)	(uid_t ruid, uid_t euid);
asmlinkage int	(*orig_setresuid32)	(uid_t ruid, uid_t euid, uid_t suid);
asmlinkage int	(*orig_setgid)		(gid_t gid);
asmlinkage int	(*orig_setregid)	(gid_t rgid, uid_t egid);
asmlinkage int	(*orig_setresgid)	(gid_t rgid, uid_t egid, uid_t sgid);
asmlinkage int	(*orig_setgid32)	(gid_t gid);
asmlinkage int	(*orig_setregid32)	(gid_t rgid, uid_t egid);
asmlinkage int	(*orig_setresgid32)	(gid_t rgid, uid_t egid, uid_t sgid);
//asmlinkage int	(*orig_ftruncate)	(int fd, off_t length);
//asmlinkage int	(*orig_fchmod)		(int filedes, mode_t mode);
//asmlinkage int	(*orig_ftruncate64)	(int fd, off_t length);
asmlinkage int	(*orig_truncate64)	(const char *path, off_t length);
asmlinkage int	(*orig_fchown)		(int fd, uid_t owner, gid_t group);
asmlinkage int	(*orig_socketcall)	(int call, unsigned long *args);
asmlinkage caddr_t (*orig_create_module) (const char *name, size_t size);
//asmlinkage caddr_t (*orig_delete_module) (const char *name);

asmlinkage int (*orig_mount)		(char *dev_name, char *dir_name, char *type, unsigned long flags, void *data);
asmlinkage int (*orig_umount)		(char *name, int flags);
asmlinkage int (*orig_umount2)		(char *name, int flags);

// System Call Replacements
asmlinkage int	audit_open			(const char *, int, mode_t);
asmlinkage int	audit_creat			(const char *, mode_t);
int 			audit_execve		(struct pt_regs regs);
asmlinkage int	audit_exit			(int);
asmlinkage int	audit_mkdir			(const char *path, mode_t mode);
asmlinkage int	audit_unlink		(const char *path);
asmlinkage int	audit_mknod			(const char *pathname, mode_t mode, dev_t dev);
asmlinkage int	audit_rmdir			(const char *path);
asmlinkage int  audit_chown			(const char *path, uid_t owner, gid_t group);
asmlinkage int  audit_lchown		(const char *path, uid_t owner, gid_t group);
asmlinkage int  audit_chown32		(const char *path, uid_t owner, gid_t group);
asmlinkage int  audit_lchown32		(const char *path, uid_t owner, gid_t group);
asmlinkage int	audit_chmod			(const char *pathname, mode_t mode);
asmlinkage int	audit_symlink		(const char *oldpath, const char *newpath);
asmlinkage int	audit_link			(const char *oldpath, const char *newpath);
asmlinkage int	audit_rename		(const char *oldpath, const char *newpath);
asmlinkage int	audit_reboot		(int magic, int magic2, int flag, void *arg);
asmlinkage int	audit_truncate		(const char *path, off_t length);
asmlinkage int	audit_chroot		(const char *path);
asmlinkage int	audit_setuid		(uid_t uid);
asmlinkage int	audit_setreuid		(uid_t ruid, uid_t euid);
asmlinkage int	audit_setresuid		(uid_t ruid, uid_t euid, uid_t suid);
asmlinkage int	audit_setuid32		(uid_t uid);
asmlinkage int	audit_setreuid32	(uid_t ruid, uid_t euid);
asmlinkage int	audit_setresuid32	(uid_t ruid, uid_t euid, uid_t suid);
asmlinkage int	audit_setgid		(gid_t gid);
asmlinkage int	audit_setregid		(gid_t rgid, gid_t egid);
asmlinkage int	audit_setresgid		(gid_t rgid, gid_t egid, gid_t sgid);
asmlinkage int	audit_setgid32		(gid_t gid);
asmlinkage int	audit_setregid32	(gid_t rgid, gid_t egid);
asmlinkage int	audit_setresgid32	(gid_t rgid, gid_t egid, gid_t sgid);
//asmlinkage int	audit_ftruncate		(int fd, off_t length);
//asmlinkage int	audit_fchmod		(int filedes, mode_t mode);
//asmlinkage int	audit_ftruncate64	(int fd, off_t length);
asmlinkage int	audit_truncate64	(const char *path, off_t length);
asmlinkage int	audit_fchown		(int fd, uid_t owner, gid_t group);
asmlinkage int	audit_socketcall	(int call, unsigned long *args);
asmlinkage caddr_t audit_create_module	(const char *name, size_t size);
//asmlinkage caddr_t audit_delete_module	(const char *name);
asmlinkage int audit_mount			(char *dev_name, char *dir_name, char *type, unsigned long flags, void *data);
asmlinkage int audit_umount			(char *name, int flags);
asmlinkage int audit_umount2		(char *name, int flags);
