/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * Routines to check the inode of the log file, to see if it 
 * has changed.
 *
 *
 * SNARE GUI Version 2.3 Dated 1 March 2004
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include "check_file.h"


// FILE RETURNS, AND ACTIONS
// 0: ALL OK. DO NOTHING.
// 1: FILE HAS CHANGED. OPEN AND CLOSE THE FILE.
// -1: FILE DOES NOT EXIST. SHOW AN ALERT WINDOW (ONCE ONLY).
// 2: FILE IS NEW.

static ino_t originode=(ino_t)NULL;

int checkinode(char * filename)
{
   ino_t newinode;
   struct stat filestat;

   // FOR THE FIRST TIME THIS ROUTINE HAS BEEN RUN
   if(stat(filename,&filestat) == -1) 
      return(FILE_NON_EXIST);
  
   // FILE EXISTS, AND ASSIGN originode FOR THE FIRST TIME
   if(originode == (ino_t) NULL) 
   {
      originode=filestat.st_ino;
      return(FILE_NEW);
   }
   else
   {
      // OTHERWISE, CHECK THE CURRENT FILENAME
      newinode=filestat.st_ino;
      if(newinode == originode)
      {
         originode=newinode; 
         return(FILE_OK);
      }
      else
      {
         originode=newinode;
         return(FILE_CHANGED);
      }
   }
}



