/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These functions undertake the necessary tasks required
 * to display the details for an event.
 *
 *
 * SNARE GUI Version 2.3 Dated 1 March 2004
 *
 ************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <stdlib.h>

#include "support.h"
#include "interface.h"
#include "read_events.h"
#include "read_config.h"
#include "event_window.h"
#include "pixmaps.h"

static GdkBitmap *clist_mask;
static GdkBitmap *window_mask;
static GdkColormap *colormap;

void display_event(GtkWidget *event_details, gchar *datetime, gchar *details)
{
  GtkWidget *datetime_entry, *criticality_entry;
  GtkWidget *event_details_textview, *event_entry;
  char *extended_details;
  char header_temp[LARGE_TOKEN_SIZE]="NULL";
  char header_temp_2[LARGE_TOKEN_SIZE]="NULL";
  char header_temp_3[LARGE_TOKEN_SIZE]="NULL";
  char byte_temp[LARGE_TOKEN_SIZE]="NULL";
  char vers_temp[LARGE_TOKEN_SIZE]="NULL";
  char alert[LARGE_TOKEN_SIZE]="NULL";
  char syscall[SMALL_TOKEN_SIZE]="NULL";
  int critic_return, loop_value;
  GtkTextBuffer *buffer;
  GtkTextIter start_iter, end_iter;

  criticality_entry = lookup_widget(GTK_WIDGET (event_details),"criticality_entry");
  datetime_entry = lookup_widget(GTK_WIDGET (event_details),"datetime_entry");
  event_entry = lookup_widget(GTK_WIDGET (event_details),"event_entry");
  event_details_textview = lookup_widget(GTK_WIDGET (event_details),"event_details_textview");

  gtk_entry_set_text( GTK_ENTRY (datetime_entry), datetime);

  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW (event_details_textview));
  gtk_text_buffer_get_start_iter(buffer,&start_iter);  
  gtk_text_buffer_get_end_iter(buffer,&end_iter);
  gtk_text_buffer_delete(buffer,&start_iter,&end_iter);
  gtk_text_buffer_insert_at_cursor(buffer,details,-1);

  //Extract the alert level and header details which will not be displayed in the GUI
  sscanf(details,"%1024[^\t]\t%64[^\t]\t%64[^\t]\t%64[^,],%64[^,],%64[^,],%64[^,]",header_temp,header_temp_3,alert,header_temp_2,byte_temp,vers_temp,syscall);
  gtk_entry_set_text( GTK_ENTRY (event_entry), syscall);


  if (strstr(alert,CRITICALITY_CRITICAL_CHAR) != NULL)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Critical");
  else if (strstr(alert,CRITICALITY_PRIORITY_CHAR) != NULL)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Priority");
  else if (strstr(alert,CRITICALITY_WARNING_CHAR) != NULL)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Warning");
  else if (strstr(alert,CRITICALITY_INFO_CHAR) != NULL)
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Information");
  else
     gtk_entry_set_text( GTK_ENTRY (criticality_entry), "Clear");

  gtk_widget_show ((GtkWidget *)event_details);
	
}
