/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These routines populate the audit objective window, from
 * the configuration file. 
 *
 *
 * SNARE GUI Version 2.3 Dated 1 March 2004
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <stdlib.h>

#include "objectives_window.h"
#include "support.h"
#include "interface.h"
#include "read_events.h"

void update_objective_window(gchar *alert, gchar *success, gchar *user_match, gchar *users, gchar *filter_match, gchar *filter, gchar *events, gint row)
{
   GtkWidget *audit_objective_window;
   GtkWidget *fail_radio, *succ_radio, *succfail_radio;
   GtkWidget *critic_radio, *pri_radio, *warn_radio, *info_radio, *clear_radio;
   GtkWidget *exp_entry, *users_entry;
   GtkWidget *full_radio, *partial_radio, *regexp_radio;
   GtkWidget *selusers_radio, *otherusers_radio, *allusers_radio; 
   GtkWidget *openfile_radio, *modify_radio, *execute_radio, *set_radio;
   GtkWidget *openfile_read_radio, *logon_logoff_radio, *open_socket_radio;
   GtkWidget *accept_socket_radio, *event_list_combo, *remove_radio;

   
   audit_objective_window = (GtkWidget *)create_audit_objectives();
   populate_combo_list(audit_objective_window);

   // THIS IS TO DRAW THE PIXMAPS FOR THE ALERT LEVELS
   draw_alert_level_pixmaps(audit_objective_window);

   event_list_combo = lookup_widget(audit_objective_window,"event_list_combo");
   
   fail_radio = lookup_widget(audit_objective_window,"fail_radio");   
   succ_radio = lookup_widget(audit_objective_window,"succ_radio");
   succfail_radio = lookup_widget(audit_objective_window,"succfail_radio");

   critic_radio = lookup_widget(audit_objective_window,"critic_radio");
   pri_radio = lookup_widget(audit_objective_window,"pri_radio");
   warn_radio = lookup_widget(audit_objective_window,"warn_radio");
   info_radio = lookup_widget(audit_objective_window,"info_radio");
   clear_radio = lookup_widget(audit_objective_window,"clear_radio");

   exp_entry = lookup_widget(audit_objective_window,"exp_entry");
   users_entry = lookup_widget(audit_objective_window,"users_entry");

   allusers_radio = lookup_widget(audit_objective_window,"allusers_radio");
   selusers_radio = lookup_widget(audit_objective_window,"selusers_radio");
   otherusers_radio = lookup_widget(audit_objective_window,"otherusers_radio");

   full_radio = lookup_widget(audit_objective_window,"full_radio");
   partial_radio = lookup_widget(audit_objective_window,"partial_radio");
   regexp_radio = lookup_widget(audit_objective_window,"regexp_radio");

   openfile_radio = lookup_widget(audit_objective_window,"openfile_radio");
   remove_radio = lookup_widget(audit_objective_window,"remove_radio");
   modify_radio = lookup_widget(audit_objective_window,"modify_radio");
   execute_radio = lookup_widget(audit_objective_window,"execute_radio");
   set_radio = lookup_widget(audit_objective_window,"set_radio");
   openfile_read_radio = lookup_widget(audit_objective_window,"openfile_read_radio");
   logon_logoff_radio = lookup_widget(audit_objective_window,"logon_logoff_radio");
   open_socket_radio = lookup_widget(audit_objective_window,"open_socket_radio");
   accept_socket_radio = lookup_widget(audit_objective_window,"accept_socket_radio");



   //NOTE: NO NEED TO EXTENSIVE CHECKING, SINCE THIS HAS ALREADY BEEN DONE
   if (strstr(events,"Read, write or create a file or directory") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (openfile_radio), TRUE);
   else if (strstr(events,"Remove a file or directory") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remove_radio), TRUE);
   else if (strstr(events,"Modify system, file or directory attributes") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modify_radio), TRUE);
   else if (strstr(events,"Start or stop a program execution") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (execute_radio), TRUE);
   else if (strstr(events,"Change user or group identity") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (set_radio), TRUE);
   else if (strstr(events,"Open a file for reading only") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (openfile_read_radio), TRUE); 
   else if (strstr(events,"User logon or logoff") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (logon_logoff_radio), TRUE);   
   else if (strstr(events,"Establish an outgoing network connection") != NULL)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (open_socket_radio), TRUE);  
   else
   {
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (accept_socket_radio), TRUE);  
     gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (event_list_combo)->entry),events); 
   }        


   // USER MATCH
   if (g_strcasecmp(user_match,"selected") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (selusers_radio), TRUE);
   if (g_strcasecmp(user_match,"exclude") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (otherusers_radio), TRUE);
   else if (g_strcasecmp(user_match,"all") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (allusers_radio), TRUE);

   // SUCCESS AND FAILURE
   if (g_strcasecmp(success,"failure") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fail_radio), TRUE);
   else if (g_strcasecmp(success,"success") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (succ_radio), TRUE);
   else if (g_strcasecmp(success,"success & failure") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (succfail_radio), TRUE);


   // FILTER MATCH
   if (g_strcasecmp(filter_match,"full") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (full_radio), TRUE);
   else if (g_strcasecmp(filter_match,"partial") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (partial_radio), TRUE);
   else if (g_strcasecmp(filter_match,"regular exp") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (regexp_radio), TRUE);


   // ALERT LEVELS
   if (g_strcasecmp(alert,"Critical") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (critic_radio), TRUE);
   else if (g_strcasecmp(alert,"Priority") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pri_radio), TRUE);
   else if (g_strcasecmp(alert,"Warning") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (warn_radio), TRUE);
   else if (g_strcasecmp(alert,"Information") == 0)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (info_radio), TRUE);
   else
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clear_radio), TRUE);


   gtk_entry_set_text(GTK_ENTRY (exp_entry),filter);
   gtk_entry_set_text(GTK_ENTRY (users_entry),users);

   // FINALLY SHOW THE WINDOW
   gtk_widget_show (audit_objective_window);

}
   
void populate_combo_list(GtkWidget *audit_objective_window)
{
        FILE * audit_event;
        char inputbuffer[MAX_AUDIT_CONFIG_LINE];
        char teventname[256]="Null";
        char *position;
        char *position2;
        GList *items = NULL;
	GtkWidget *event_list_combo;

	event_list_combo = lookup_widget(audit_objective_window,"event_list_combo");

        audit_event=fopen("/etc/security/audit_event","r");

        if(audit_event==(FILE *)NULL) {
                printf("Cannot open /etc/security/audit_event. Exiting\n");
                return;
        }

        while(fgets(inputbuffer,MAX_AUDIT_CONFIG_LINE,audit_event)) 
    	{
                if(!iscomment(inputbuffer))     
		{
                        if((position = (char *)strstr(inputbuffer,":"))) 
 			{
                                position+=5;
                                if((position2 = (char *)strstr(position,":"))) 
				{
                                        int size;
                                        size=position2-position;
                                        if(size>255) size=255;
                                        strncpy(teventname,position,size);
                                        teventname[size]='\0';
					g_strdown(teventname);  //CONVERT TO LOWER CASE
                                        // ADD TEVENTNAME to the list
					items = g_list_append (items, g_strdup(teventname));
                                }
                        }
                }
        }


        gtk_combo_set_popdown_strings (GTK_COMBO (event_list_combo), items);

        g_list_free(items);
        fclose(audit_event);

        return;
}



