/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These routines support the reading of the event log file,
 * management of the log file, and drawing the pixmaps
 *
 *
 * SNARE GUI Version 2.3 Dated 1 Mar 2004
 *
 ************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>

#include "read_events.h"
#include "read_config.h"
#include "support.h"
#include "check_file.h"
#include "pixmaps.h"

char event_log_filename_static[LARGE_TOKEN_SIZE]="NULL";
int error_reported_static = 0;

static char file_line[BUFR_SIZE];

static struct read_events_struct event_struct_store;
static struct read_events_struct *read_variables = &event_struct_store;

static GdkBitmap *clist_mask;
static GdkBitmap *window_mask;
static GdkColormap *colormap;

gint update_main_clist(GtkWidget *list)
{

   gchar alert[SMALL_TOKEN_SIZE]="NULL";
   gchar date_time[SMALL_TOKEN_SIZE]="NULL";
   gchar details[BUFR_SIZE]="NULL";
   gchar temp_buffer_1[LARGE_TOKEN_SIZE]="NULL";
   gchar temp_buffer_2[LARGE_TOKEN_SIZE]="NULL";
   gchar header[LARGE_TOKEN_SIZE]="NULL";
   gchar temp_header_1[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_2[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_3[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_4[SMALL_TOKEN_SIZE]="NULL";
   gchar temp_header_5[SMALL_TOKEN_SIZE]="NULL";
   gchar syscall[BUFR_SIZE]="NULL";
   gchar temp_details[BUFR_SIZE]="NULL";
   gchar extended_details[BUFR_SIZE]="NULL";
   gchar *line[4]={alert,date_time,details,extended_details};
   GtkWidget *main_display, *error_dialog;
   GtkTreeIter iter;
   GtkListStore *model;
   GtkTreePath *path;
   GdkRectangle rect,rect2;
   gint viewable_y=0,current_pos=0,row_visible=0;

   int current_row=0, file_lines_to_be_read = 1;
   int result_filename = 0, auditing_type = AUDIT_BY_OBJECTIVE,last_clist_row, move_to_command = 0;

   
   main_display=list;
   
   //Set the image type (graphic at the bottom of the main GUI window)
   if (read_variables->read_type == AUDIT_TO_NETWORK)
        gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(main_display,"image_audit_type")),gdkpixbuf_network);
   else
        gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(main_display,"image_audit_type")),gdkpixbuf_filtered);


   // This next section does the file checking
   result_filename = check_filename();
   if ((read_variables->events_file==(FILE *)NULL) || (result_filename == FILE_NON_EXIST)) {
      if (error_reported_static < 1) {
         error_dialog = gnome_message_box_new("Warning: Event Log cannot be read.\nThis may be caused by \"auditing to the network only\".\n If this is not the case, then restart the audit daemon.",
                  GNOME_MESSAGE_BOX_ERROR,GNOME_STOCK_BUTTON_OK,NULL);
         gnome_dialog_run (GNOME_DIALOG (error_dialog));
      }
      error_reported_static = 1;
      return -1;
   } else if (result_filename == FILE_CHANGED) {
      open_close_event_file(CLOSE_EVENT_FILE);
      open_close_event_file(OPEN_EVENT_FILE);
      open_close_event_file(READ_EVENT_FILE_FROM_START); 
   } else {
      error_reported_static = 0;
   }



   // Read the log files lines, and display to the main TreeView 
   
   while (fgets(file_line,BUFR_SIZE,read_variables->events_file) != NULL)
   {
        //Extended details contains the whole original line
	strncpy(extended_details,file_line,BUFR_SIZE);

	//Extract the alert level and header details which will not be displayed in the GUI
	sscanf(file_line,"%64[^\t]\t%64[^\t]\t%64[^\t]\t%64[^,],%64[^,],%64[^,],%64[^,]%64[,fe,|,,]%64[^,],%64[^\t]\t%8192[^\n]\n",temp_buffer_1,temp_buffer_2,alert,temp_header_1,temp_header_2,temp_header_3,syscall,temp_header_4,date_time,temp_header_5,details);

	strncat(syscall,"\t",BUFR_SIZE - strlen(syscall));
	strncat(syscall,details,BUFR_SIZE - strlen(syscall));
	strncpy(details,syscall,BUFR_SIZE);

      GdkPixbuf *alertlevel = gdkpixbuf_unknown;

      if (strcasecmp(alert,"4") == 0) {
		alertlevel=gdkpixbuf_critic;
      } else if (strcasecmp(alert,"3") == 0) {
		alertlevel=gdkpixbuf_priority;
      } else if (strcasecmp(alert,"2") == 0) {
		alertlevel=gdkpixbuf_warning;
      } else if (strcasecmp(alert,"1") == 0) {
		alertlevel=gdkpixbuf_info;
      } else {
		alertlevel=gdkpixbuf_unknown;
     }

      model = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(main_display)));
      gtk_list_store_append(model,&iter);
      gtk_list_store_set(model,&iter,0,alertlevel,
			 1,date_time,2,details,3,extended_details,4,alert,-1);
      // printf("DEBUG 900: Details = %s\n Extended Details = %s\n\n",details,extended_details);
      path= gtk_tree_model_get_path(GTK_TREE_MODEL(model),&iter);
      if (file_lines_to_be_read == 1)
      {
         //The next few lines determine whether it is required to scroll to the bottom of the list,
         //if the user can see the last row in the Tree View.
         gtk_tree_view_get_visible_rect(GTK_TREE_VIEW(main_display),&rect);
         gtk_tree_view_get_cell_area(GTK_TREE_VIEW(main_display),path,NULL,&rect2);
         viewable_y = rect.y + rect.height;
         current_pos = rect.y + rect2.y;
         if ((current_pos > rect.y -700) && (current_pos < viewable_y + 700))
	    row_visible = 1;
      }


      file_lines_to_be_read = 0;
      

   }

      if (row_visible == 1)
         gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(main_display),path,NULL,TRUE,1.0,0.0);

   if (file_lines_to_be_read == 0)
      gtk_tree_path_free(path);

   return TRUE;
}


   
void create_pixmaps(GtkWidget *main_display)
{

   // This sets up the alert pixmaps and the pixmaps at the bottom of the screen.
   gdkpixbuf_critic=gdk_pixbuf_new_from_xpm_data((const char**)&critic_xpm);
   gdkpixbuf_priority=gdk_pixbuf_new_from_xpm_data((const char**)&priority_xpm);
   gdkpixbuf_warning=gdk_pixbuf_new_from_xpm_data((const char**)&warning_xpm);
   gdkpixbuf_info=gdk_pixbuf_new_from_xpm_data((const char**)&info_xpm);
   gdkpixbuf_unknown=gdk_pixbuf_new_from_xpm_data((const char**)&unknown_xpm);

   //These two are for the type of auditing
   gdkpixbuf_filtered=gdk_pixbuf_new_from_xpm_data((const char**)&filtered_xpm);
   gdkpixbuf_network=gdk_pixbuf_new_from_xpm_data((const char**)&network_xpm);

   return;
}

// Read the log file to ascertain the type of auditing
int read_log_file_and_type(int read_file_from)
{
   struct read_events_struct; 
   FILE *configfile;
   char inputbuffer[MAX_AUDIT_CONFIG_LINE];
   int headertype=0;
   int audittype=AUDIT_BY_EVENT;          
   gchar *filename;
   int return_result = 0,audit_to_file=FALSE,audit_to_network=FALSE;

   configfile = fopen(CONFIG_FILENAME,"r");

   // If file cannot be opened, return value == -1 
   if(configfile==(FILE *)NULL)
   {
      return -1;
   }

   while(fgets(inputbuffer,MAX_AUDIT_CONFIG_LINE,configfile)) 
   {
      trim(inputbuffer); 
      if(!iscomment(inputbuffer))
      {
         // A HEADER IS SOMETHING LIKE: [Event]
         if(isheader(inputbuffer))
         {
            headertype=getheader(inputbuffer);
         }
         else
         {      
            // NOTE: CONFIG_FILE IS ACTUALLY THE EVENT FILE HERE
            if(headertype == CONFIG_OUTPUT)
            {
               if(isfilename(inputbuffer))
               {
                  filename = inputbuffer;
                  filename+=strlen("file=");
                  audit_to_file=TRUE; 
                  strncpy(event_log_filename_static,filename,LARGE_TOKEN_SIZE);

                  if ((open_close_event_file(OPEN_EVENT_FILE) == 0) &&
                      (read_file_from == READ_EVENT_FILE_FROM_END))
                         open_close_event_file(READ_EVENT_FILE_FROM_END);
                  
                  else if ((open_close_event_file(OPEN_EVENT_FILE) == 0) &&
                      (read_file_from == READ_EVENT_FILE_FROM_START))
                         open_close_event_file(READ_EVENT_FILE_FROM_START);

                  else
                     return -2;

               }
               else if(isnetwork(inputbuffer))
                  audit_to_network=TRUE;
            }
         }
      }
   }

   if ((audit_to_network==TRUE) && (audit_to_file==FALSE))
      read_variables->read_type = AUDIT_TO_NETWORK;
   else
      read_variables->read_type = AUDIT_BY_OBJECTIVE;
   
   fclose(configfile);

   return (return_result);
}

int check_filename(void)
{
   int result = 0, return_result = FILE_OK;

   // Check the filename inode only
   result = checkinode(event_log_filename_static);

   if (result == FILE_CHANGED)
      return_result = FILE_CHANGED;

   else if (result == FILE_NON_EXIST)
      return_result = FILE_NON_EXIST;
   return (return_result);

}

int open_close_event_file(int close_open)
{
   int result_filename = 0,return_value = 0;

   if(close_open == OPEN_EVENT_FILE)
   {
      read_variables->events_file = fopen(event_log_filename_static,"r");
      // This will check for errors in reading the file.
      if(read_variables->events_file==(FILE *)NULL)
         return_value = 1;
   }
   if(close_open == READ_EVENT_FILE_FROM_START)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fseek(read_variables->events_file,0,SEEK_SET);
      // This next section does the file checking
      result_filename = check_filename();
      if ((read_variables->events_file==(FILE *)NULL) || (result_filename == FILE_NON_EXIST))         
		   return_value = 1;
   }

   if(close_open == READ_EVENT_FILE_FROM_END)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fseek(read_variables->events_file,0,SEEK_END);
      // This next section does the file checking
      result_filename = check_filename();
      if ((read_variables->events_file==(FILE *)NULL) || (result_filename == FILE_NON_EXIST))         
		   return_value = 1;
   }

   if(close_open == CLOSE_EVENT_FILE)
   {
      if(read_variables->events_file!=(FILE *)NULL)
         return_value = fclose(read_variables->events_file);
   }

   return abs(return_value);
}



int declare_new_file(char *new_filename)
{
   int new_file_result = 0;

   new_file_result = strcmp(event_log_filename_static,new_filename);

   if (new_file_result != 0)
      strcpy(event_log_filename_static,new_filename);

   return new_file_result;

}

void set_network_logging_variable(int audit_type)
{
   read_variables->read_type = audit_type;
}


void draw_alert_level_pixmaps(GtkWidget *objective_window)
{

   gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(objective_window,"critical_pixmap")),gdkpixbuf_critic);
   gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(objective_window,"priority_pixmap")),gdkpixbuf_priority);
   gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(objective_window,"warning_pixmap")),gdkpixbuf_warning);
   gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(objective_window,"information_pixmap")),gdkpixbuf_info);
   gtk_image_set_from_pixbuf(GTK_IMAGE(lookup_widget(objective_window,"clear_pixmap")),gdkpixbuf_unknown);


 return;
}


