/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These routines implement the callbacks from the various
 * SNARE widget signals, created under Glade2
 *
 *
 * SNARE GUI Version 2.4
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "read_config.h"
#include "write_config.h"
#include "objectives_window.h"
#include "read_events.h"
#include "write_objective.h"
#include "daemon.h"
#include "event_window.h"
#include "pixmaps.h"

int objectives_clist_current_row_static = -1;
GtkTreeIter iter_static;
gint mainclist_current_row_static = 1;
GtkTreePath *path_static = NULL;
GtkTreePath *objectives_path_static = NULL;
gboolean objectives_clist_selected = FALSE;

GtkWidget *objectives_clist_static;
GtkWidget *mainclist_static;
GtkWidget *eventwindow_static;
int objectives_clist_change_static = ADD;


void check_daemon_status(gpointer * button, gpointer user_data)
{
	daemon_status();
}

void reload_main_clist(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkTreeView *main_display;
	GtkWidget *error_dialog;
	GtkTreeModel *model;
	int result = 0;

	main_display =
	    GTK_TREE_VIEW(lookup_widget
			  (GTK_WIDGET(menuitem), "mainclist"));
	model = gtk_tree_view_get_model(main_display);
	gtk_list_store_clear(GTK_LIST_STORE(model));

	result = open_close_event_file(READ_EVENT_FILE_FROM_START);

	if (result > 0) {
		error_dialog =
		    gnome_message_box_new
		    ("Beware: Event Log cannot be read",
		     GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL);
		gnome_dialog_run(GNOME_DIALOG(error_dialog));
	} else {
		error_dialog =
		    gnome_message_box_new
		    ("Please wait: Entire audit file being reloaded",
		     GNOME_MESSAGE_BOX_INFO, GNOME_STOCK_BUTTON_OK, NULL);
		gnome_dialog_run(GNOME_DIALOG(error_dialog));
	}

	update_main_clist(GTK_WIDGET(main_display));
}


void clear_main_clist(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkTreeView *main_display;
	GtkTreeModel *model;

	main_display =
	    GTK_TREE_VIEW(lookup_widget
			  (GTK_WIDGET(menuitem), "mainclist"));
	model = gtk_tree_view_get_model(main_display);
	gtk_list_store_clear(GTK_LIST_STORE(model));
}

void restart_daemon(gpointer * button, gpointer user_data)
{

	reload_daemon();

	open_close_event_file(CLOSE_EVENT_FILE);
	open_close_event_file(OPEN_EVENT_FILE);
	open_close_event_file(READ_EVENT_FILE_FROM_END);

}


void create_the_event_window(void)
{
	GtkWidget *event_details;

	event_details = create_event_details();
	eventwindow_static = event_details;
}


void mainclist_select_row(GtkTreeView * treeview, GtkTreePath * path,
			  GtkTreeViewColumn * column, gpointer user_data)
{
	GtkWidget *previous_button, *next_button;
	gboolean iter_result = FALSE;
	gboolean result_bool = FALSE, previous_row = TRUE, next_row = TRUE;
	GtkTreeModel *model;
	GtkTreeIter iter;
	GtkTreePath *treeview_path;
	gchar *datetime, *details, *extended_details;
	GdkPixbuf *graphic;

	mainclist_static = (GtkWidget *) treeview;


	path_static = gtk_tree_path_copy(path);
	if (!gtk_tree_path_prev(path))
		previous_row = FALSE;
	else
		gtk_tree_path_next(path);

	gtk_tree_path_next(path);
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));

	if (!gtk_tree_model_get_iter(model, &iter, path))
		next_row = FALSE;

	gtk_tree_path_prev(path);

	previous_button =
	    lookup_widget(GTK_WIDGET(eventwindow_static),
			  "previous_button");
	next_button =
	    lookup_widget(GTK_WIDGET(eventwindow_static), "next_button");
	gtk_widget_set_sensitive(previous_button, TRUE);
	gtk_widget_set_sensitive(next_button, TRUE);

	if ((!previous_row) && (!next_row)) {
		gtk_widget_set_sensitive(next_button, FALSE);
		gtk_widget_set_sensitive(previous_button, FALSE);
	} else if (!next_row)
		gtk_widget_set_sensitive(next_button, FALSE);
	else if (!previous_row)
		gtk_widget_set_sensitive(previous_button, FALSE);


	gtk_tree_view_get_cursor(GTK_TREE_VIEW(treeview), &treeview_path,
				 NULL);
	iter_result = gtk_tree_model_get_iter(model, &iter, treeview_path);
	gtk_tree_model_get(model, &iter, 0, &graphic, 1, &datetime, 2,
			   &details, 3, &extended_details, -1);
	display_event(eventwindow_static, datetime, extended_details);

}


void next_button_clicked(GtkButton * button, gpointer user_data)
{

	gtk_tree_path_next(path_static);
	gtk_tree_view_set_cursor(GTK_TREE_VIEW(mainclist_static),
				 path_static, NULL, FALSE);
	mainclist_select_row(GTK_TREE_VIEW(mainclist_static), path_static,
			     NULL, NULL);

}


void previous_button_clicked(GtkButton * button, gpointer user_data)
{

	gtk_tree_path_prev(path_static);
	gtk_tree_view_set_cursor(GTK_TREE_VIEW(mainclist_static),
				 path_static, NULL, FALSE);
	mainclist_select_row(GTK_TREE_VIEW(mainclist_static), path_static,
			     NULL, NULL);
}




void audit_configuration(gpointer * menuitem, gpointer user_data)
{
	GtkWidget *audit_config, *obj_clist, *create_new;
	GtkListStore *Obj_List;
	GtkTreeView *obj_list_display;
	GtkCellRenderer *renderer;

	audit_config = create_audit_configuration();

	Obj_List =
	    gtk_list_store_new(7, G_TYPE_STRING, G_TYPE_STRING,
			       G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
			       G_TYPE_STRING, G_TYPE_STRING);
	obj_list_display =
	    GTK_TREE_VIEW(lookup_widget(audit_config, "objectives_clist"));
	gtk_tree_view_set_model(obj_list_display,
				GTK_TREE_MODEL(Obj_List));

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Alert", renderer,
						    "text", 0, NULL);

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Success/Failure",
						    renderer, "text", 1,
						    NULL);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "User Match", renderer,
						    "text", 2, NULL);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Users", renderer,
						    "text", 3, NULL);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Filter Type",
						    renderer, "text", 4,
						    NULL);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Filter", renderer,
						    "text", 5, NULL);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (obj_list_display), -1,
						    "Objective", renderer,
						    "text", 6, NULL);

	if (read_configuration(audit_config) == FALSE) {
		create_new = create_default_config_window();
		gtk_widget_show(create_new);
	} else {
		obj_clist =
		    lookup_widget(GTK_WIDGET(audit_config),
				  "objectives_clist");
		objectives_clist_static = (GTK_WIDGET(obj_list_display));
		gtk_widget_show(audit_config);
	}
}


void menu_exit_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	open_close_event_file(CLOSE_EVENT_FILE);
	gtk_main_quit();
}


void save_configuration_button_clicked(gpointer * button,
				       gpointer user_data)
{
	GtkWidget *config_window;
	int result;

	config_window =
	    lookup_widget(GTK_WIDGET(user_data), "audit_configuration");
	result = write_configuration(config_window);

	if (result == TRUE) {
		gtk_widget_destroy(config_window);
	}

}


void menu_about(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *about_window;
	GdkPixbuf *gdkpixbuf_snare;

	about_window = create_about_snare();
	gdkpixbuf_snare =
	    gdk_pixbuf_new_from_xpm_data((const char **) &snare_xpm);
	gtk_image_set_from_pixbuf(GTK_IMAGE
				  (lookup_widget
				   (about_window, "about_snare_graphic")),
				  gdkpixbuf_snare);
	gtk_widget_show(about_window);
}


void objectives_clist_select_row(GtkTreeView * treeview,
				 GtkTreePath * path,
				 GtkTreeViewColumn * column,
				 gpointer user_data)
{
	GtkWidget *popup_menu, *popup_edit_menuitem,
	    *popup_delete_menuitem;

	objectives_path_static = gtk_tree_path_copy(path);
	objectives_clist_static = (GTK_WIDGET(treeview));

	gtk_menu_popup(GTK_MENU(popup_menu), NULL, NULL, NULL, NULL, 0,
		       gtk_get_current_event_time());
	gtk_widget_show(popup_menu);

}



void edit_objective_menu_activate(GtkMenuItem * menuitem,
				  gpointer user_data)
{

	gchar *alert, *success, *users, *events, *filter, *user_match,
	    *filter_match;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gboolean iter_result = FALSE;

	model =
	    gtk_tree_view_get_model(GTK_TREE_VIEW
				    (objectives_clist_static));
	iter_result =
	    gtk_tree_model_get_iter(model, &iter, objectives_path_static);
	gtk_tree_model_get(model, &iter, 0, &alert, 1, &success, 2,
			   &user_match, 3, &users, 4, &filter_match, 5,
			   &filter, 6, &events, -1);


	objectives_clist_change_static = CHANGE;
	iter_static = iter;

	update_objective_window(alert, success, user_match, users,
				filter_match, filter, events,
				objectives_clist_current_row_static);

}

void delete_objective_menu_activate(GtkMenuItem * menuitem,
				    gpointer user_data)
{
	GtkListStore *list;
	GtkTreeIter iter;
	gboolean iter_result = FALSE;

	list =
	    GTK_LIST_STORE(gtk_tree_view_get_model
			   (GTK_TREE_VIEW(objectives_clist_static)));
	iter_result =
	    gtk_tree_model_get_iter(GTK_TREE_MODEL(list), &iter,
				    objectives_path_static);
	gtk_list_store_remove(list, &iter);

}


void add_an_objective_button_clicked(GtkButton * button,
				     gpointer user_data)
{
	GtkWidget *audit_objective_window, *objectives_clist;

	objectives_clist =
	    lookup_widget((GtkWidget *) button, "objectives_clist");
	objectives_clist_static = objectives_clist;

	objectives_clist_change_static = ADD;

	audit_objective_window = create_audit_objectives();
	populate_combo_list(audit_objective_window);

	// THIS IS TO DRAW THE PIXMAPS FOR THE ALERT LEVELS
	draw_alert_level_pixmaps(audit_objective_window);
	gtk_widget_show(audit_objective_window);
}


void save_objective_button_clicked(gpointer * button, gpointer user_data)
{
	GtkWidget *objectives_clist, *objective_window;

	objective_window =
	    lookup_widget((GtkWidget *) button, "audit_objectives");
	write_objective(objectives_clist_static, objective_window,
			iter_static, objectives_clist_change_static);

	gtk_widget_destroy(objective_window);

}

void save_and_apply_clicked(gpointer * button, gpointer user_data)
{
	save_configuration_button_clicked(button, user_data);

	restart_daemon((gpointer *) NULL, (gpointer) NULL);
}



void create_new_config_file(GtkButton * button, gpointer user_data)
{
	GtkWidget *audit_config, *default_window;

	audit_config = create_audit_configuration();
	write_configuration(audit_config);
	gtk_widget_destroy(audit_config);

	default_window =
	    lookup_widget((GtkWidget *) button, "default_config_window");
	gtk_widget_destroy(default_window);

}


void network_documentation(GtkButton * button, gpointer user_data)
{
	GError *error;
	gnome_url_show
	    ("http://www.intersectalliance.com/resources/index.html",
	     &error);

}


void audit_configuration_documentation(GtkButton * button,
				       gpointer user_data)
{
	GError *error;
	gnome_url_show
	    ("http://www.intersectalliance.com/resources/index.html",
	     &error);

}


void audit_objectives_documentation(GtkButton * button, gpointer user_data)
{
	GError *error;
	gnome_url_show
	    ("http://www.intersectalliance.com/resources/index.html",
	     &error);
}

void documentation(gpointer * menuitem, gpointer user_data)
{
	GError *error;
	gnome_url_show
	    ("http://www.intersectalliance.com/resources/index.html",
	     &error);
}

void
delete_an_objective_button_clicked(GtkButton * button, gpointer user_data)
{
	GtkListStore *list;
	GtkTreeIter iter;
	gboolean iter_result = FALSE;
	GtkTreePath *objective_path;
	GtkWidget *error_dialog;

	gtk_tree_view_get_cursor(GTK_TREE_VIEW(objectives_clist_static),
				 &objective_path, NULL);
	if (objective_path == NULL) {
		error_dialog =
		    gnome_message_box_new
		    (" Please select (highlight) a row to edit",
		     GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL);
		gnome_dialog_run(GNOME_DIALOG(error_dialog));
	} else {
		list =
		    GTK_LIST_STORE(gtk_tree_view_get_model
				   (GTK_TREE_VIEW
				    (objectives_clist_static)));
		iter_result =
		    gtk_tree_model_get_iter(GTK_TREE_MODEL(list), &iter,
					    objective_path);
		gtk_list_store_remove(list, &iter);
	}


}



void
edit_an_objective_button_clicked(GtkButton * button, gpointer user_data)
{
	GtkTreePath *objective_path;
	gchar *alert, *success, *users, *events, *filter, *user_match,
	    *filter_match;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gboolean iter_result = FALSE;
	GtkWidget *error_dialog;

	gtk_tree_view_get_cursor(GTK_TREE_VIEW(objectives_clist_static),
				 &objective_path, NULL);
	if (objective_path == NULL) {
		error_dialog =
		    gnome_message_box_new
		    (" Please select (highlight) a row to edit",
		     GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL);
		gnome_dialog_run(GNOME_DIALOG(error_dialog));
	} else {
		model =
		    gtk_tree_view_get_model(GTK_TREE_VIEW
					    (objectives_clist_static));
		iter_result =
		    gtk_tree_model_get_iter(model, &iter, objective_path);
		gtk_tree_model_get(model, &iter, 0, &alert, 1, &success, 2,
				   &user_match, 3, &users, 4,
				   &filter_match, 5, &filter, 6, &events,
				   -1);
		objectives_clist_change_static = CHANGE;	//MAY NOT NEED THIS ***********
		iter_static = iter;
		update_objective_window(alert, success, user_match, users,
					filter_match, filter, events,
					objectives_clist_current_row_static);
	}
}
