/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * These functions undertake the necessary tasks required
 * to read and report on the audit daemon.
 *
 *
 * SNARE FOR SOLARIS GUI Version 2.4
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gnome.h>
#include <signal.h>
#include "support.h"
#include "interface.h"
#include "daemon.h"
#include "read_config.h"


void reload_daemon(void)
{
	int pid, result;
	GtkWidget *error_dialog;

	// Do not need this line, since we are doing a manual independant restart/start pid=get_pid();
	pid = 1;
	if (pid > 0) {
		// INITIATE A DAEMON RELOAD
		result = system("/etc/init.d/snare restart");
		if (result == 0) {
			error_dialog =
			    gnome_message_box_new
			    ("SnareCore daemon has been restarted",
			     GNOME_MESSAGE_BOX_INFO, GNOME_STOCK_BUTTON_OK,
			     NULL);
			gnome_dialog_run(GNOME_DIALOG(error_dialog));
		} else {
			error_dialog =
			    gnome_message_box_new
			    ("SNARE does not have permissions to restart\nthe SnareCore daemon, or daemon is not active",
			     GNOME_MESSAGE_BOX_ERROR,
			     GNOME_STOCK_BUTTON_OK, NULL);
			gnome_dialog_run(GNOME_DIALOG(error_dialog));
		}
	} else {
		error_dialog =
		    gnome_message_box_new
		    ("SnareCore daemon not active, or unable to open /var/run/snarecore.pid",
		     GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL);
		gnome_dialog_run(GNOME_DIALOG(error_dialog));
	}
}

int get_pid(void)
{
	FILE *auditinfo;
	char configline[LARGE_TOKEN_SIZE];
	char *linepos;
	int pid = 0;

	auditinfo = fopen(PID_FILENAME, "r");

	if (auditinfo == (FILE *) NULL)
		return 0;

	while (fgets(configline, LARGE_TOKEN_SIZE, auditinfo)) {
		linepos = configline;
		pid = atoi(linepos);
	}

	fclose(auditinfo);

	return pid;
}

void daemon_status(void)
{
	FILE *auditinfo;
	int running = 1;
	int pid;
	char alive[TOKEN_SIZE] = "No";
	char process_id[TOKEN_SIZE] = "audit not running";
	char buffer[1024];
	GtkWidget *audit_status, *id_label, *version_label, *active_label;

	auditinfo = fopen(PID_FILENAME, "r");

	if (auditinfo == (FILE *) NULL) {
		running = 0;
	} else {
		while (fgets(buffer, sizeof(buffer), auditinfo)) {
			pid = atoi(buffer);
		}
		if (pid) {
			running = 1;
		}
	}
	fclose(auditinfo);

	if (running) {
		strncpy(alive, "Yes", sizeof(alive));
		snprintf(process_id, sizeof(process_id), "%d", pid);
	}

	audit_status = create_status_window();

	id_label = lookup_widget(audit_status, "id_label");
	active_label = lookup_widget(audit_status, "active_label");

	gtk_label_set_text(GTK_LABEL(id_label), process_id);
	gtk_label_set_text(GTK_LABEL(active_label), alive);

	gtk_widget_show(audit_status);
}
