/************************************************************
 *
 * 1999 - 2004 (c) Intersect Alliance Pty Ltd.
 *
 * This is the main routine that initialises the main vars,
 * and defines the timeout function and period for reading
 * the event log file.
 *
 *
 * SNARE GUI Version 2.4
 *
 ************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"

#include "interface.h"
#include "read_events.h"
#include "read_config.h"
#include "callbacks.h"

#include "pixmaps.h"


int main(int argc, char *argv[])
{
	GtkWidget *main_window;
	GtkListStore *eventList;
	GtkTreeView *main_display;
	GtkCellRenderer *renderer;

#ifdef ENABLE_NLS
	bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
#endif

	gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			   argc, argv,
			   GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
			   NULL);

	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
	main_window = create_main_window();
	gtk_widget_show(main_window);

	eventList =
	    gtk_list_store_new(5, GDK_TYPE_PIXBUF, G_TYPE_STRING,
			       G_TYPE_STRING, G_TYPE_STRING,
			       G_TYPE_STRING);
	main_display =
	    GTK_TREE_VIEW(lookup_widget(main_window, "mainclist"));
	gtk_tree_view_set_model(main_display, GTK_TREE_MODEL(eventList));

	// A call to create the pixmaps used in SNARE
	create_pixmaps(main_window);
	renderer = gtk_cell_renderer_pixbuf_new();

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(main_display), -1,	// position from end
						    "Alert",	// column title
						    renderer,	// cell
						    "pixbuf",	// cell attribute
						    0,	// column
						    NULL);	// end attributes

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (main_display), -1,
						    "Event Date/Time",
						    renderer, "text", 1,
						    NULL);

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW
						    (main_display), -1,
						    "Selected Details",
						    renderer, "text", 2,
						    NULL);


	read_log_file_and_type(READ_EVENT_FILE_FROM_END);



	// This is to create but not show the event window
	create_the_event_window();


	// Read the event log every few seconds
	gtk_timeout_add(READ_LOG_INTERVAL, (GtkFunction) update_main_clist,
			GTK_WIDGET(main_display));

	gtk_main();
	return 0;
}
